/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util.check;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import nicelee.bilibili.util.check.RafRBuffered;
import nicelee.bilibili.util.check.RafWBuffered;

public class FlvMerger {
    protected int lastTimestamp = -1;
    private byte[] buffer;
    byte[] durationHeader = new byte[]{8, 100, 117, 114, 97, 116, 105, 111, 110};
    int pDurationHeader = 0;

    public static void main(String[] stringArray) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File("D:\\Workspace\\javaweb-springboot\\BilibiliDown\\download\\BV1Ss411h7Ge-80-p7-part1.flv");
        File file2 = new File("D:\\Workspace\\javaweb-springboot\\BilibiliDown\\download\\BV1Ss411h7Ge-80-p7-part2.flv");
        File file3 = new File("D:\\Workspace\\javaweb-springboot\\BilibiliDown\\download\\BV1Ss411h7Ge-80-p7-part3.flv");
        arrayList.add(file);
        arrayList.add(file2);
        arrayList.add(file3);
        File file4 = new File("D:\\Workspace\\javaweb-springboot\\BilibiliDown\\download\\test2.flv");
        new FlvMerger().merge(arrayList, file4);
    }

    private void skip(RafRBuffered rafRBuffered) throws IOException {
        int n;
        rafRBuffered.skipBytes(9);
        rafRBuffered.skipBytes(4);
        while ((n = rafRBuffered.read()) == 18 || n == 0) {
            int n2 = this.readBytesToInt(rafRBuffered, 3);
            rafRBuffered.skipBytes(4);
            rafRBuffered.skipBytes(3 + n2 + 4);
        }
        rafRBuffered.seek(rafRBuffered.getFilePointer() - 1L);
    }

    public void merge(List<File> list, File file) throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[0x400000];
        }
        RafWBuffered rafWBuffered = new RafWBuffered(file, "rw");
        System.out.println("\u5904\u7406flv\u6587\u4ef60");
        RafRBuffered rafRBuffered = new RafRBuffered(list.get(0), "r");
        int n = rafRBuffered.read(this.buffer);
        while (n > -1) {
            rafWBuffered.write(this.buffer, 0, n);
            n = rafRBuffered.read(this.buffer);
        }
        long l = rafRBuffered.getFilePointer();
        rafRBuffered.seek(l - 4L);
        int n2 = this.readBytesToInt(rafRBuffered, 4);
        rafRBuffered.seek(l -= (long)(n2 + 4));
        int n3 = rafRBuffered.read();
        int n4 = this.readBytesToInt(rafRBuffered, 3);
        int n5 = this.readBytesToInt(rafRBuffered, 3);
        int n6 = rafRBuffered.read() << 24;
        this.lastTimestamp = n5 += n6;
        rafRBuffered.close();
        for (int i = 1; i < list.size(); ++i) {
            System.out.println("\u5904\u7406flv\u6587\u4ef6" + i);
            rafRBuffered = new RafRBuffered(list.get(i), "r");
            this.skip(rafRBuffered);
            int n7 = this.lastTimestamp + 1;
            while (((n2 = rafRBuffered.read()) == 8 || n2 == 9 || n2 == 18) && (n3 = this.readBytesToInt(rafRBuffered, 3)) != 0) {
                rafWBuffered.write(n2);
                rafWBuffered.write(this.buffer, 0, 3);
                n4 = this.readBytesToInt(rafRBuffered, 3);
                n5 = rafRBuffered.read() << 24;
                this.dealTimestamp(rafWBuffered, n4 += n5, n7);
                rafRBuffered.read(this.buffer, 0, 3 + n3 + 4);
                rafWBuffered.write(this.buffer, 0, 3 + n3 + 4);
            }
            rafRBuffered.close();
        }
        rafWBuffered.close();
        this.changeDuration(file.getAbsolutePath(), this.getDuration() / 1000.0);
    }

    protected void dealTimestamp(RafWBuffered rafWBuffered, int n, int n2) throws IOException {
        this.lastTimestamp = n2 + n;
        int n3 = this.lastTimestamp & 0xFFFFFF;
        rafWBuffered.write(this.int2Bytes(n3), 1, 3);
        int n4 = this.lastTimestamp >> 24;
        rafWBuffered.write(n4);
    }

    protected int readBytesToInt(RafRBuffered rafRBuffered, int n) throws IOException {
        rafRBuffered.read(this.buffer, 0, n);
        return this.bytes2Int(this.buffer, n);
    }

    protected byte[] int2Bytes(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[3 - i] = (byte)(n >> 8 * i & 0xFF);
        }
        return byArray;
    }

    protected int bytes2Int(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 |= (byArray[n - 1 - i] & 0xFF) << i * 8;
        }
        return n2;
    }

    protected byte[] double2Bytes(double d) {
        long l = Double.doubleToRawLongBits(d);
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l >> 8 * i & 0xFFL);
        }
        byte[] byArray2 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray2[i] = byArray[7 - i];
        }
        return byArray2;
    }

    public double bytes2Double(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray2[i] = byArray[7 - i];
        }
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l |= (long)(byArray2[i] & 0xFF) << 8 * i;
        }
        return Double.longBitsToDouble(l);
    }

    public void changeDuration(String string, double d) throws IOException {
        File file = new File(string);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        int n = randomAccessFile.read(this.buffer);
        int n2 = this.checkBufferForDuration();
        boolean bl = false;
        while (n > -1) {
            long l = 0L;
            if (n2 != -1) {
                bl = true;
                randomAccessFile.seek(l + (long)n2 + 1L);
                randomAccessFile.write(0);
                randomAccessFile.write(this.double2Bytes(d));
                break;
            }
            n = randomAccessFile.read(this.buffer);
            if (!bl) {
                n2 = this.checkBufferForDuration();
            }
            l += (long)n;
        }
        randomAccessFile.close();
    }

    int checkBufferForDuration() {
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] != this.durationHeader[this.pDurationHeader]) continue;
            ++this.pDurationHeader;
            if (this.pDurationHeader != this.durationHeader.length) continue;
            this.pDurationHeader = 0;
            return i;
        }
        return -1;
    }

    public double getDuration() {
        return this.lastTimestamp;
    }
}

