/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util.batchdownload;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.regex.Pattern;
import nicelee.bilibili.enums.VideoQualityEnum;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.RepoUtil;
import nicelee.ui.Global;

public class Condition {
    String left;
    String operator;
    String right;
    static final HashSet<String> validsOfLeft = new HashSet();
    static final HashSet<String> validsOfOperator;
    static final SimpleDateFormat sdf;

    public Condition(String string, String string2, String string3) {
        if (!validsOfLeft.contains(string)) {
            throw new RuntimeException("\u6279\u91cf\u4e0b\u8f7d\u914d\u7f6e\u4e0d\u5bf9, \u5224\u65ad\u8868\u8fbe\u5f0f\u5de6\u503c\u6709\u8bef: " + string);
        }
        if (!validsOfOperator.contains(string2)) {
            throw new RuntimeException("\u6279\u91cf\u4e0b\u8f7d\u914d\u7f6e\u4e0d\u5bf9, \u5224\u65ad\u8868\u8fbe\u5f0f\u64cd\u4f5c\u7b26\u6709\u8bef: " + string2);
        }
        this.left = string;
        this.operator = string2;
        this.right = string3;
    }

    public String toString() {
        return this.left + this.operator + this.right;
    }

    public boolean match(ClipInfo clipInfo, int n) {
        switch (this.left) {
            case "_": {
                if (this.operator.equals(":")) {
                    return this.matchUnderlineColon(clipInfo, n);
                }
                if (this.operator.equals("!")) {
                    return !this.matchUnderlineColon(clipInfo, n);
                }
                throw new RuntimeException("\u4e0d\u5408\u6cd5\u7684\u8868\u8fbe\u5f0f   " + this.left + this.operator + this.right);
            }
            case "page": {
                int n2 = Integer.parseInt(this.right);
                if (this.operator.equals(":")) {
                    return n2 == n;
                }
                if (this.operator.equals(">")) {
                    return n2 > n;
                }
                if (this.operator.equals("<")) {
                    return n2 < n;
                }
                throw new RuntimeException("\u4e0d\u5408\u6cd5\u7684\u8868\u8fbe\u5f0f   " + this.left + this.operator + this.right);
            }
            case "bv": {
                if (this.operator.equals(":")) {
                    return clipInfo.getAvId().equals(this.right);
                }
                throw new RuntimeException("\u4e0d\u5408\u6cd5\u7684\u8868\u8fbe\u5f0f   " + this.left + this.operator + this.right);
            }
            case "favTime": {
                if (clipInfo.getFavTime() == 0L) {
                    throw new RuntimeException("\u8be5url\u7c7b\u578b\u89e3\u6790\u7ed3\u679c\u4e0d\u5b58\u5728favTime\u5b57\u6bb5\u7684\u4fe1\u606f ");
                }
                if (this.operator.equals(">")) {
                    try {
                        return clipInfo.getFavTime() > sdf.parse(this.right).getTime();
                    }
                    catch (ParseException parseException) {
                    }
                } else if (this.operator.equals("<")) {
                    try {
                        return clipInfo.getFavTime() < sdf.parse(this.right).getTime();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                throw new RuntimeException("\u4e0d\u5408\u6cd5\u7684\u8868\u8fbe\u5f0f   " + this.left + this.operator + this.right);
            }
            case "cTime": {
                if (clipInfo.getcTime() == 0L) {
                    throw new RuntimeException("\u8be5url\u7c7b\u578b\u89e3\u6790\u7ed3\u679c\u4e0d\u5b58\u5728cTime\u5b57\u6bb5\u7684\u4fe1\u606f ");
                }
                if (this.operator.equals(">")) {
                    try {
                        return clipInfo.getcTime() > sdf.parse(this.right).getTime();
                    }
                    catch (ParseException parseException) {
                    }
                } else if (this.operator.equals("<")) {
                    try {
                        return clipInfo.getcTime() < sdf.parse(this.right).getTime();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                throw new RuntimeException("\u4e0d\u5408\u6cd5\u7684\u8868\u8fbe\u5f0f   " + this.left + this.operator + this.right);
            }
            case "avTitle": {
                boolean bl = this.operator.equals(":");
                if (!bl && !this.operator.equals("!")) {
                    throw new RuntimeException("avTitle\u64cd\u4f5c\u7b26\u53ea\u80fd\u4e3a : \u6216\u8005 !, \u4e0d\u80fd\u662f: " + this.operator);
                }
                boolean bl2 = Pattern.matches(this.right, clipInfo.getAvTitle());
                Logger.printf("\u6807\u9898\u6b63\u5219\u5339\u914d: %s\nPattern: %s\nContent: %s", bl2, this.right, clipInfo.getAvTitle());
                return bl ? bl2 : !bl2;
            }
            case "clipTitle": {
                boolean bl = this.operator.equals(":");
                if (!bl && !this.operator.equals("!")) {
                    throw new RuntimeException("clipTitle\u64cd\u4f5c\u7b26\u53ea\u80fd\u4e3a : \u6216\u8005 !, \u4e0d\u80fd\u662f: " + this.operator);
                }
                boolean bl3 = Pattern.matches(this.right, clipInfo.getTitle());
                Logger.printf("\u5c0f\u6807\u9898\u6b63\u5219\u5339\u914d: %s\nPattern: %s\nContent: %s", bl3, this.right, clipInfo.getTitle());
                return bl ? bl3 : !bl3;
            }
        }
        return true;
    }

    public boolean matchUnderlineColon(ClipInfo clipInfo, int n) {
        if (this.right.equals("_")) {
            return true;
        }
        if (this.right.equals("downloaded")) {
            String string = clipInfo.getAvId() + "-" + VideoQualityEnum.getQN(Global.menu_qn) + "-p" + clipInfo.getPage();
            return RepoUtil.isInRepo(string);
        }
        throw new RuntimeException("\u4e0d\u5408\u6cd5\u7684\u8868\u8fbe\u5f0f   " + this.left + this.operator + this.right);
    }

    public String getKey() {
        return this.left;
    }

    public void setKey(String string) {
        this.left = string;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String string) {
        this.operator = string;
    }

    public String getValue() {
        return this.right;
    }

    public void setValue(String string) {
        this.right = string;
    }

    static {
        validsOfLeft.add("_");
        validsOfLeft.add("page");
        validsOfLeft.add("bv");
        validsOfLeft.add("favTime");
        validsOfLeft.add("cTime");
        validsOfLeft.add("avTitle");
        validsOfLeft.add("clipTitle");
        validsOfOperator = new HashSet();
        validsOfOperator.add(":");
        validsOfOperator.add("!");
        validsOfOperator.add("<");
        validsOfOperator.add(">");
        sdf = new SimpleDateFormat("yyyy-MM-dd");
    }
}

