/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util.batchdownload;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.FavList;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.bilibili.util.batchdownload.Condition;
import nicelee.ui.Global;

public class BatchDownload
implements Cloneable {
    String type;
    String url;
    String remark;
    List<Condition[]> stopCondition;
    List<Condition[]> downloadCondition;
    boolean includeBoundsBV;
    boolean alertAfterMissionComplete;
    int startPage;

    public static void main(String[] stringArray) throws FileNotFoundException {
        List<BatchDownload> list = new BatchDownloadsBuilder("D:\\Workspace\\javaweb-springboot\\BilibiliDown\\release\\config\\click-once-download-all.config").Build();
        System.out.println(list);
    }

    private BatchDownload(String string) {
        this.url = string;
        this.remark = "";
        this.includeBoundsBV = false;
        this.stopCondition = new ArrayList<Condition[]>();
        this.downloadCondition = new ArrayList<Condition[]>();
    }

    public boolean matchStopCondition(ClipInfo clipInfo, int n) {
        for (Condition[] conditionArray : this.stopCondition) {
            if (!this.match(conditionArray, clipInfo, n)) continue;
            return true;
        }
        return false;
    }

    public boolean matchDownloadCondition(ClipInfo clipInfo, int n) {
        for (Condition[] conditionArray : this.downloadCondition) {
            if (!this.match(conditionArray, clipInfo, n)) continue;
            return true;
        }
        return false;
    }

    private boolean match(Condition[] conditionArray, ClipInfo clipInfo, int n) {
        for (Condition condition : conditionArray) {
            if (condition.match(clipInfo, n)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(this.type).append(":").append(this.url).append("]\n");
        stringBuilder.append("stopCondition:");
        for (Condition[] conditionArray : this.stopCondition) {
            stringBuilder.append("\n[\n\t");
            for (n = 0; n < conditionArray.length; ++n) {
                stringBuilder.append(conditionArray[n]).append(",");
            }
            stringBuilder.append("\n],");
        }
        stringBuilder.append("\n");
        stringBuilder.append("downloadCondition:");
        for (Condition[] conditionArray : this.downloadCondition) {
            stringBuilder.append("\n[\n\t");
            for (n = 0; n < conditionArray.length; ++n) {
                stringBuilder.append(conditionArray[n]).append(",");
            }
            stringBuilder.append("\n],");
        }
        stringBuilder.append("\n");
        stringBuilder.append("includeBoundsBV:").append(this.includeBoundsBV).append("\n");
        return stringBuilder.toString();
    }

    private void addStopCondition(Condition[] conditionArray) {
        this.stopCondition.add(conditionArray);
    }

    private void addDownloadCondition(Condition[] conditionArray) {
        this.downloadCondition.add(conditionArray);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public List<Condition[]> getStopCondition() {
        return this.stopCondition;
    }

    public void setStopCondition(List<Condition[]> list) {
        this.stopCondition = list;
    }

    public List<Condition[]> getDownloadCondition() {
        return this.downloadCondition;
    }

    public void setDownloadCondition(List<Condition[]> list) {
        this.downloadCondition = list;
    }

    public boolean isIncludeBoundsBV() {
        return this.includeBoundsBV;
    }

    public void setIncludeBoundsBV(boolean bl) {
        this.includeBoundsBV = bl;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int n) {
        this.startPage = n;
    }

    public boolean isAlertAfterMissionComplete() {
        return this.alertAfterMissionComplete;
    }

    public void setAlertAfterMissionComplete(boolean bl) {
        this.alertAfterMissionComplete = bl;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String string) {
        this.remark = string;
    }

    public static class BatchDownloadsBuilder {
        InputStream in;
        static final Pattern urlPattern = Pattern.compile("^\\[(url|favorite):(.*)\\]$");
        static final Pattern stopPattern = Pattern.compile("^stop\\.condition *= *(.*)$");
        static final Pattern downloadPattern = Pattern.compile("^download\\.condition *= *(.*)$");
        static final Pattern expressionPattern = Pattern.compile("^([^:!<>]+)([:!<>])(.+)$");
        static final Pattern otherSettingsPattern = Pattern.compile("^([^=]+) *= *(.*)$");

        public BatchDownloadsBuilder(String string) throws FileNotFoundException {
            this.in = new FileInputStream(string);
        }

        public BatchDownloadsBuilder(InputStream inputStream) {
            this.in = inputStream;
        }

        public List<BatchDownload> Build() {
            ArrayList<BatchDownload> arrayList = new ArrayList<BatchDownload>();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in, "utf-8"));){
                String string = bufferedReader.readLine();
                BatchDownload batchDownload = null;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (string != null) {
                    if (!(string = string.trim()).startsWith("#")) {
                        BatchDownload batchDownload2 = batchDownload;
                        boolean bl = batchDownload2 != (batchDownload = this.matchUrlPattern(arrayList, hashMap, string, batchDownload)) || this.matchStopPattern(string, batchDownload) || this.matchDownloadPattern(string, batchDownload) || this.matchOtherSettingsPattern(hashMap, string, batchDownload);
                    }
                    string = bufferedReader.readLine();
                }
                if (batchDownload != null) {
                    this.addBatchToList(arrayList, hashMap, batchDownload);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ResourcesUtil.closeQuietly(this.in);
            return arrayList;
        }

        private void addBatchToList(List<BatchDownload> list, HashMap<String, String> hashMap, BatchDownload batchDownload) {
            String string = hashMap.getOrDefault("stop.bv.bounds", "exclude");
            batchDownload.setIncludeBoundsBV("include".equals(string));
            String string2 = hashMap.getOrDefault("stop.alert", "true");
            batchDownload.setAlertAfterMissionComplete("true".equals(string2));
            String string3 = hashMap.getOrDefault("start.page", "1");
            batchDownload.setStartPage(Integer.parseInt(string3));
            if ("url".equals(batchDownload.getType())) {
                list.add(batchDownload);
            } else if ("favorite".equals(batchDownload.getType())) {
                HashSet<String> hashSet = null;
                if (!"all".equals(batchDownload.getUrl())) {
                    hashSet = new HashSet<String>();
                    for (String string4 : batchDownload.getUrl().split(",")) {
                        hashSet.add(string4.trim());
                    }
                }
                for (int i = 2; i < Global.index.cmbFavList.getItemCount(); ++i) {
                    FavList favList = (FavList)Global.index.cmbFavList.getItemAt(i);
                    if (hashSet != null && !hashSet.contains(favList.getTitle())) continue;
                    try {
                        BatchDownload batchDownload2 = (BatchDownload)batchDownload.clone();
                        batchDownload2.setRemark(batchDownload2.getType() + "-" + favList.getTitle());
                        batchDownload2.setType("url");
                        batchDownload2.setUrl(String.format("https://space.bilibili.com/%d/favlist?fid=%d&ftype=create", favList.getOwnerId(), favList.getfId()));
                        list.add(batchDownload2);
                        continue;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        cloneNotSupportedException.printStackTrace();
                    }
                }
            }
        }

        private boolean matchOtherSettingsPattern(HashMap<String, String> hashMap, String string, BatchDownload batchDownload) {
            Matcher matcher = otherSettingsPattern.matcher(string);
            if (matcher.find()) {
                hashMap.put(matcher.group(1).trim(), matcher.group(2).trim());
                return true;
            }
            return false;
        }

        private BatchDownload matchUrlPattern(List<BatchDownload> list, HashMap<String, String> hashMap, String string, BatchDownload batchDownload) {
            Matcher matcher = urlPattern.matcher(string);
            if (matcher.find()) {
                if (batchDownload != null) {
                    this.addBatchToList(list, hashMap, batchDownload);
                }
                batchDownload = new BatchDownload(matcher.group(2).trim());
                batchDownload.setType(matcher.group(1).trim());
                hashMap.clear();
            }
            return batchDownload;
        }

        private boolean matchStopPattern(String string, BatchDownload batchDownload) {
            Matcher matcher = stopPattern.matcher(string);
            if (matcher.find()) {
                String[] stringArray = matcher.group(1).split(",");
                Condition[] conditionArray = new Condition[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].trim();
                    Matcher matcher2 = expressionPattern.matcher(string2);
                    if (!matcher2.find()) {
                        throw new RuntimeException("\u975e\u6cd5\u8868\u8fbe\u5f0f: " + string2);
                    }
                    conditionArray[i] = new Condition(matcher2.group(1).trim(), matcher2.group(2).trim(), matcher2.group(3).trim());
                }
                batchDownload.addStopCondition(conditionArray);
                return true;
            }
            return false;
        }

        private boolean matchDownloadPattern(String string, BatchDownload batchDownload) {
            Matcher matcher = downloadPattern.matcher(string);
            if (matcher.find()) {
                String[] stringArray = matcher.group(1).split(",");
                Condition[] conditionArray = new Condition[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].trim();
                    Matcher matcher2 = expressionPattern.matcher(string2);
                    if (!matcher2.find()) {
                        throw new RuntimeException("\u975e\u6cd5\u8868\u8fbe\u5f0f: " + string2);
                    }
                    conditionArray[i] = new Condition(matcher2.group(1).trim(), matcher2.group(2).trim(), matcher2.group(3).trim());
                }
                batchDownload.addDownloadCondition(conditionArray);
                return true;
            }
            return false;
        }
    }
}

