/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Paths;
import java.util.Random;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.util.ConfigUtil;
import nicelee.bilibili.util.Logger;

public class ResourcesUtil {
    static final String dataDirPath;
    static final boolean isJarLaunch;
    static String cacheBaseDir;
    static File cacheBaseDirFile;

    public static void write(File file, String string) {
        try {
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes("utf-8"));
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String readAll(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return new String(byArray2, "utf-8");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String random(int n, String string, long l) {
        StringBuilder stringBuilder = new StringBuilder(n);
        Random random = new Random(l);
        for (int i = 0; i < n; ++i) {
            int n2 = random.nextInt(string.length());
            stringBuilder.append(string.charAt(n2));
        }
        return stringBuilder.toString();
    }

    public static String randomInt(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        String string = "0123456789";
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(Math.random() * (double)string.length());
            stringBuilder.append(string.charAt(n2));
        }
        return stringBuilder.toString();
    }

    public static String randomLower(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        String string = "abcdefghijklmnopqrstuvwxyz0123456789";
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(Math.random() * (double)string.length());
            stringBuilder.append(string.charAt(n2));
        }
        return stringBuilder.toString();
    }

    public static String randomHex(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        String string = "ABCDEF0123456789";
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(Math.random() * (double)string.length());
            stringBuilder.append(string.charAt(n2));
        }
        return stringBuilder.toString();
    }

    public static String randomUpper(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(Math.random() * (double)string.length());
            stringBuilder.append(string.charAt(n2));
        }
        return stringBuilder.toString();
    }

    public static String random(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        String string = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(Math.random() * (double)string.length());
            stringBuilder.append(string.charAt(n2));
        }
        return stringBuilder.toString();
    }

    public static void copy(File file, File file2) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(file2, "rw");
            byte[] byArray = new byte[0x100000];
            int n = randomAccessFile.read(byArray);
            while (n != -1) {
                randomAccessFile2.write(byArray, 0, n);
                n = randomAccessFile.read(byArray);
            }
            randomAccessFile.close();
            randomAccessFile2.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static File search(String string) {
        File file = new File(ResourcesUtil.baseDirectory(), string);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static File sourceOf(String string) {
        File file = new File(ResourcesUtil.baseDirectory(), string);
        if (!file.exists()) {
            file.getParentFile().mkdir();
        }
        return file;
    }

    public static String resolve(String string) {
        if (!Paths.get(string, new String[0]).isAbsolute()) {
            try {
                File file = new File(ResourcesUtil.baseDirectory(), string);
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return string;
            }
        }
        return string;
    }

    public static File baseDirFile() {
        if (cacheBaseDirFile == null) {
            cacheBaseDirFile = new File(ResourcesUtil.baseDirectory());
        }
        return cacheBaseDirFile;
    }

    public static String baseDirectory() {
        block7: {
            if (cacheBaseDir == null) {
                if (dataDirPath != null) {
                    cacheBaseDir = dataDirPath;
                    return cacheBaseDir;
                }
                if (isJarLaunch) {
                    try {
                        String string = ClassLoader.getSystemResource("").getPath();
                        if (string == null || "".equals(string)) {
                            cacheBaseDir = ResourcesUtil.getProjectPath();
                            break block7;
                        }
                        cacheBaseDir = URLDecoder.decode(string, "UTF-8");
                    }
                    catch (Exception exception) {
                        cacheBaseDir = ResourcesUtil.getProjectPath();
                    }
                } else {
                    cacheBaseDir = System.getProperty("user.dir", "");
                }
            }
        }
        return cacheBaseDir;
    }

    public static String canonicalPath(String string) {
        try {
            return new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    private static String getProjectPath() {
        URL uRL = ConfigUtil.class.getProtectionDomain().getCodeSource().getLocation();
        String string = null;
        try {
            string = URLDecoder.decode(uRL.getPath(), "UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string.endsWith(".jar")) {
            int n = string.lastIndexOf("/");
            string = n > -1 ? string.substring(0, n + 1) : string.substring(0, string.lastIndexOf("\\") + 1);
        }
        File file = new File(string);
        string = file.getAbsolutePath();
        return string;
    }

    public static void close(Object object) throws IOException, NoSuchMethodException, SecurityException {
        if (object == null) {
            return;
        }
        if (object instanceof Closeable) {
            ((Closeable)object).close();
        } else {
            System.err.println(object.getClass().getName() + ": \u5c1d\u8bd5\u5229\u7528\u53cd\u5c04\u8c03\u7528close()\u65b9\u6cd5");
            try {
                Method method = object.getClass().getDeclaredMethod("close", new Class[0]);
                try {
                    method.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    exception.printStackTrace();
                }
            }
            catch (NoSuchMethodException | SecurityException exception) {
                Method method = object.getClass().getMethod("close", new Class[0]);
                try {
                    method.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception2) {
                    exception2.printStackTrace();
                }
            }
        }
    }

    public static void closeQuietly(Object object) {
        try {
            ResourcesUtil.close(object);
        }
        catch (IOException | NoSuchMethodException | SecurityException exception) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public static String detailsOfException(Throwable var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isPicture(String string) {
        return string.startsWith("h") || string.startsWith("cv") || string.startsWith("opus");
    }

    public static boolean isPicture(ClipInfo clipInfo) {
        return ResourcesUtil.isPicture(clipInfo.getAvId());
    }

    static {
        String[] stringArray;
        String string = System.getProperty("bilibili.prop.dataDirPath");
        try {
            if (string != null) {
                Logger.println(string);
                stringArray = new File(string);
                string = stringArray.getCanonicalPath();
                if (stringArray.exists()) {
                    Logger.println("\u6307\u5b9a\u6570\u636e\u76ee\u5f55\uff1a" + string);
                } else {
                    Logger.println("\u76ee\u5f55\u4e0d\u5b58\u5728\uff1a" + string);
                    string = null;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = null;
        }
        dataDirPath = string;
        stringArray = System.getProperty("sun.java.command", "").split(" ");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            if (string2.endsWith(".jar")) {
                stringBuilder.append(string2);
                String string3 = stringBuilder.toString();
                Logger.println(string3);
                if (!new File(string3).exists()) break;
                bl = true;
                break;
            }
            stringBuilder.append(string2).append(" ");
        }
        isJarLaunch = bl;
    }
}

