/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class QrCodeUtil {
    public static boolean createQrCode(OutputStream outputStream, String string, int n, String string2) throws WriterException, IOException {
        BufferedImage bufferedImage = QrCodeUtil.createQrCode(string, n);
        return ImageIO.write((RenderedImage)bufferedImage, string2, outputStream);
    }

    public static BufferedImage createQrCode(String string, int n) throws WriterException {
        Hashtable<EncodeHintType, Enum> hashtable = new Hashtable<EncodeHintType, Enum>();
        hashtable.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hashtable.put(EncodeHintType.CHARACTER_SET, CharacterSetECI.UTF8);
        QRCodeWriter qRCodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = qRCodeWriter.encode(string, BarcodeFormat.QR_CODE, n, n, hashtable);
        int n2 = bitMatrix.getWidth();
        BufferedImage bufferedImage = new BufferedImage(n2 - 100, n2 - 100, 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n2, n2);
        graphics2D.setColor(Color.BLACK);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!bitMatrix.get(i, j)) continue;
                graphics2D.fillRect(i - 50, j - 50, 1, 1);
            }
        }
        return bufferedImage;
    }

    public static void main(String[] stringArray) throws IOException, WriterException {
        QrCodeUtil.createQrCode(new FileOutputStream(new File("d:\\qrcode.jpg")), "WE1231238239128sASDASDSADSDWEWWREWRERWSDFDFSDSDF123123123123213123", 900, "JPEG");
    }
}

