/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import nicelee.bilibili.enums.StatusEnum;
import nicelee.bilibili.exceptions.Status412Exception;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.ui.Global;

public class HttpRequestUtil {
    protected static CookieManager defaultManager = new CookieManager();
    protected byte[] buffer;
    protected Long downloadedFileSize = 0L;
    protected long totalFileSize;
    protected String savePath = "./download/";
    protected File fileDownload;
    protected volatile StatusEnum status = StatusEnum.NONE;
    protected volatile boolean bDown = true;
    CookieManager manager;
    static Charset UTF_8 = Charset.forName("UTF-8");
    static Pattern filePartPattern = Pattern.compile("^(.*)-part[0-9]+\\.(flv|mp4)$");

    public HttpRequestUtil() {
        this(defaultManager);
    }

    public HttpRequestUtil(CookieManager cookieManager) {
        this.manager = cookieManager;
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
        this.savePath = Global.savePath;
    }

    public void setSavePath(String string) {
        this.savePath = string;
    }

    public static CookieManager DefaultCookieManager() {
        return defaultManager;
    }

    public void stopDownload() {
        this.bDown = false;
        this.status = StatusEnum.STOP;
    }

    public void stopDownloadAsFail() {
        this.bDown = false;
        this.status = StatusEnum.FAIL;
    }

    public void init() {
        this.bDown = true;
        this.status = StatusEnum.NONE;
        this.reset();
    }

    public void reset() {
        this.downloadedFileSize = 0L;
        this.totalFileSize = 0L;
    }

    protected Boolean check(String string) {
        File file;
        if (this.status == StatusEnum.STOP) {
            return false;
        }
        this.status = StatusEnum.DOWNLOADING;
        this.fileDownload = this.getFile(string);
        File file2 = new File(this.fileDownload.getParent(), this.fileDownload.getName().replaceAll("_(video|audio)", "").replaceAll("\\.m4s$", ".mp4"));
        System.out.println(file2.getName());
        Matcher matcher = filePartPattern.matcher(file2.getName());
        if (matcher.find() && (file = new File(file2.getParent(), matcher.group(1) + "." + matcher.group(2))).exists()) {
            this.status = StatusEnum.SUCCESS;
            return true;
        }
        if (this.fileDownload.exists() || file2.exists()) {
            this.totalFileSize = this.fileDownload.length();
            this.downloadedFileSize = this.fileDownload.length();
            this.status = StatusEnum.SUCCESS;
            return true;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean download(String string, String string2, HashMap<String, String> hashMap) {
        boolean bl;
        RandomAccessFile randomAccessFile;
        InputStream inputStream;
        block17: {
            Boolean bl2 = this.check(string2);
            if (bl2 != null) {
                return bl2;
            }
            inputStream = null;
            randomAccessFile = null;
            try {
                File file = new File(this.fileDownload.getParent(), this.fileDownload.getName() + ".part");
                randomAccessFile = new RandomAccessFile(file, "rw");
                long l = 0L;
                l = this.modifyHeaderMapByDownloaded(hashMap, randomAccessFile, file, l);
                String string3 = string;
                HttpURLConnection httpURLConnection = this.connect(hashMap, string3, null);
                httpURLConnection.connect();
                Map<String, List<String>> map = httpURLConnection.getHeaderFields();
                List<String> list = map.get("Content-Length");
                if (list == null) {
                    list = map.get("content-length");
                }
                System.out.printf("\u6587\u4ef6\u5927\u5c0f: %s \u5b57\u8282.\r\n", list);
                if (list != null) {
                    this.totalFileSize = l + Long.parseUnsignedLong(list.get(0));
                }
                try {
                    inputStream = httpURLConnection.getInputStream();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Logger.println(hashMap.get("range"));
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), "utf-8"));
                    while (true) {
                        String string4;
                        if ((string4 = bufferedReader.readLine()) == null) {
                            bufferedReader.close();
                            throw exception;
                        }
                        System.out.println(string4);
                    }
                }
                if (this.buffer == null) {
                    this.buffer = new byte[0x100000];
                }
                int n = inputStream.read(this.buffer);
                this.downloadedFileSize = l + (long)n;
                while (n > -1) {
                    if (!this.bDown) {
                        this.status = StatusEnum.STOP;
                        bl = false;
                        this.buffer = null;
                        break block17;
                    }
                    randomAccessFile.write(this.buffer, 0, n);
                    n = inputStream.read(this.buffer);
                    this.downloadedFileSize = this.downloadedFileSize + (long)n;
                }
                randomAccessFile.close();
                if (file.length() < this.totalFileSize) {
                    this.download(string3, string2, hashMap);
                } else {
                    file.renameTo(this.fileDownload);
                    System.out.println("\u4e0b\u8f7d\u5b8c\u6bd5...");
                }
                this.buffer = null;
            }
            catch (Exception exception) {
                boolean bl3;
                try {
                    System.out.println("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + exception);
                    exception.printStackTrace();
                    this.status = StatusEnum.FAIL;
                    bl3 = false;
                    this.buffer = null;
                }
                catch (Throwable throwable) {
                    this.buffer = null;
                    ResourcesUtil.closeQuietly(inputStream);
                    ResourcesUtil.closeQuietly(randomAccessFile);
                    throw throwable;
                }
                ResourcesUtil.closeQuietly(inputStream);
                ResourcesUtil.closeQuietly(randomAccessFile);
                return bl3;
            }
            ResourcesUtil.closeQuietly(inputStream);
            ResourcesUtil.closeQuietly(randomAccessFile);
            this.status = StatusEnum.SUCCESS;
            return true;
        }
        ResourcesUtil.closeQuietly(inputStream);
        ResourcesUtil.closeQuietly(randomAccessFile);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected HttpURLConnection connect(HashMap<String, String> hashMap, String string, List<HttpCookie> list) throws MalformedURLException, IOException {
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(10000);
        httpURLConnection.setReadTimeout(10000);
        if (hashMap != null) {
            for (Map.Entry object : hashMap.entrySet()) {
                httpURLConnection.setRequestProperty((String)object.getKey(), (String)object.getValue());
            }
        }
        if (list != null) {
            void var7_11;
            StringBuilder stringBuilder = new StringBuilder();
            for (HttpCookie httpCookie : list) {
                stringBuilder.append(httpCookie.getName()).append("=").append(httpCookie.getValue()).append("; ");
            }
            String string2 = stringBuilder.toString();
            if (string2.endsWith("; ")) {
                String string3 = string2.substring(0, string2.length() - 2);
            }
            httpURLConnection.setRequestProperty("Cookie", (String)var7_11);
        }
        return httpURLConnection;
    }

    protected long modifyHeaderMapByDownloaded(HashMap<String, String> hashMap, RandomAccessFile randomAccessFile, File file, long l) throws IOException {
        hashMap.remove("range");
        if (file.exists() && file.length() > 0L) {
            l = file.length();
            hashMap.put("range", "bytes=" + l + "-");
            System.out.println("\u5f53\u524d\u5df2\u4e0b\u8f7d: [" + l + "]\u5b57\u8282");
            randomAccessFile.seek(l);
        }
        return l;
    }

    public String getContent(String string, HashMap<String, String> hashMap) {
        return this.getContent(string, hashMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContent(String string, HashMap<String, String> hashMap, List<HttpCookie> list) {
        StringBuffer stringBuffer = new StringBuffer();
        Object var5_5 = null;
        try {
            HttpURLConnection httpURLConnection = this.connect(hashMap, string, list);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 412) {
                throw new Status412Exception("HTTP\u8fd4\u56de\u72b6\u6001\u7801\u4e3a412");
            }
            String string2 = httpURLConnection.getContentEncoding();
            InputStream inputStream = httpURLConnection.getInputStream();
            if (string2 != null && string2.contains("gzip")) {
                inputStream = new GZIPInputStream(inputStream);
            } else if (string2 != null && string2.contains("deflate")) {
                inputStream = new InflaterInputStream(inputStream, new Inflater(true));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[256];
            int n = inputStream.read(byArray);
            while (n > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            stringBuffer.append(new String(byteArrayOutputStream.toByteArray(), UTF_8));
            byteArrayOutputStream.close();
        }
        catch (Status412Exception status412Exception) {
            throw status412Exception;
        }
        catch (Exception exception) {
            System.out.println("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + exception);
            exception.printStackTrace();
        }
        finally {
            ResourcesUtil.closeQuietly(var5_5);
        }
        return stringBuffer.toString();
    }

    public String postContent(String string, HashMap<String, String> hashMap, String string2) {
        return this.postContent(string, hashMap, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postContent(String string, HashMap<String, String> hashMap, String string2, List<HttpCookie> list) {
        StringBuffer stringBuffer = new StringBuffer();
        Object var6_6 = null;
        try {
            HttpURLConnection httpURLConnection = this.connect(hashMap, string, list);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.connect();
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            dataOutputStream.writeBytes(string2);
            dataOutputStream.flush();
            dataOutputStream.close();
            if (httpURLConnection.getResponseCode() == 412) {
                throw new Status412Exception("HTTP\u8fd4\u56de\u72b6\u6001\u7801\u4e3a412");
            }
            String string3 = httpURLConnection.getContentEncoding();
            InputStream inputStream = httpURLConnection.getInputStream();
            if (string3 != null && string3.contains("gzip")) {
                inputStream = new GZIPInputStream(httpURLConnection.getInputStream());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[256];
            int n = inputStream.read(byArray);
            while (n > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            stringBuffer.append(new String(byteArrayOutputStream.toByteArray(), UTF_8));
            byteArrayOutputStream.close();
        }
        catch (Status412Exception status412Exception) {
            throw status412Exception;
        }
        catch (Exception exception) {
            System.out.println("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + exception);
        }
        finally {
            ResourcesUtil.closeQuietly(var6_6);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkValid(String string, HashMap<String, String> hashMap, List<HttpCookie> list) {
        Object var4_4 = null;
        try {
            HttpURLConnection httpURLConnection = this.connect(hashMap, string, list);
            hashMap.put("range", "bytes=0-100");
            httpURLConnection.connect();
            boolean bl = httpURLConnection.getResponseCode() != 404;
            return bl;
        }
        catch (Exception exception) {
            System.out.println("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + exception);
            boolean bl = false;
            return bl;
        }
        finally {
            ResourcesUtil.closeQuietly(var4_4);
        }
    }

    protected File getFile(String string) {
        File file = new File(this.savePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(file, string);
        return file2;
    }

    public File getFileDownload() {
        return this.fileDownload;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public long getDownloadedFileSize() {
        return this.downloadedFileSize;
    }

    public long getTotalFileSize() {
        return this.totalFileSize;
    }
}

