/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.enums.VideoQualityEnum;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractBaseParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="URL4WatchLater", note="\u7a0d\u540e\u518d\u770b")
public class URL4WatchLater
extends AbstractBaseParser {
    private static final Pattern pattern = Pattern.compile("www.bilibili.com/watchlater/#/list");

    public URL4WatchLater(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        return this.matcher.find();
    }

    @Override
    public String validStr(String string) {
        return this.matcher.group().trim();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        VideoInfo videoInfo = new VideoInfo();
        videoInfo.setVideoId("WatchLater");
        try {
            String string2 = "https://api.bilibili.com/x/v2/history/toview/web?jsonp=jsonp";
            String string3 = this.util.getContent(string2, new HttpHeaders().getCommonHeaders("api.bilibili.com"), HttpCookies.getGlobalCookies());
            Logger.println(string2);
            JSONObject jSONObject = new JSONObject(string3);
            JSONArray jSONArray = jSONObject.getJSONObject("data").getJSONArray("list");
            videoInfo.setVideoName("\u7a0d\u540e\u518d\u770b");
            videoInfo.setBrief("\u7a0d\u540e\u518d\u770b");
            videoInfo.setAuthor("\u7a0d\u540e\u518d\u770b");
            videoInfo.setAuthorId("\u7a0d\u540e\u518d\u770b");
            videoInfo.setVideoPreview(jSONArray.getJSONObject(0).getString("pic"));
            LinkedHashMap<Long, ClipInfo> linkedHashMap = new LinkedHashMap<Long, ClipInfo>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                String string4 = jSONObject2.getString("bvid");
                String string5 = jSONObject2.getString("title");
                String string6 = jSONObject2.getJSONObject("owner").getString("name");
                String string7 = "" + jSONObject2.getJSONObject("owner").getLong("mid");
                JSONArray jSONArray2 = jSONObject2.getJSONArray("pages");
                for (int j = 0; j < jSONArray2.length(); ++j) {
                    JSONObject jSONObject3 = jSONArray2.getJSONObject(j);
                    ClipInfo clipInfo = new ClipInfo();
                    clipInfo.setAvId(string4);
                    clipInfo.setcId(jSONObject3.getLong("cid"));
                    clipInfo.setPage(jSONObject3.getInt("page"));
                    clipInfo.setRemark(i);
                    clipInfo.setPicPreview(jSONObject2.getString("pic"));
                    clipInfo.setUpName(string6);
                    clipInfo.setUpId(string7);
                    clipInfo.setAvTitle(string5);
                    clipInfo.setTitle(jSONObject3.getString("part"));
                    clipInfo.setListName("\u7a0d\u540e\u518d\u770b");
                    LinkedHashMap<Integer, String> linkedHashMap2 = new LinkedHashMap<Integer, String>();
                    try {
                        for (VideoQualityEnum videoQualityEnum : VideoQualityEnum.values()) {
                            if (bl) {
                                String string8 = this.getVideoLink(string4, String.valueOf(clipInfo.getcId()), videoQualityEnum.getQn(), n);
                                linkedHashMap2.put(videoQualityEnum.getQn(), string8);
                                continue;
                            }
                            linkedHashMap2.put(videoQualityEnum.getQn(), "");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    clipInfo.setLinks(linkedHashMap2);
                    linkedHashMap.put(clipInfo.getcId(), clipInfo);
                }
            }
            videoInfo.setClips(linkedHashMap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return videoInfo;
    }
}

