/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.parsers.impl.URL4PictureCVParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="URL4PictureRLParser", note="\u56fe\u7247\u89e3\u6790 - \u4e13\u680f\u6587\u96c6")
public class URL4PictureRLParser
extends AbstractPageQueryParser<VideoInfo> {
    private static final Pattern pattern = Pattern.compile("\\.bilibili\\.com/read/[^/]*readlist/rl([0-9]+)");
    private String rlIdNumber;
    private final Object[] obj;

    public URL4PictureRLParser(Object ... objectArray) {
        super(objectArray);
        this.obj = objectArray;
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        if (this.matcher.find()) {
            this.rlIdNumber = this.matcher.group(1);
            Logger.println("\u5339\u914dURL4PictureRLParser: rl" + this.rlIdNumber);
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return this.matcher.group().trim() + "p=" + this.paramSetter.getPage();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        return this.result(this.pageSize, this.paramSetter.getPage(), n, bl);
    }

    @Override
    public void initPageQueryParam() {
        this.API_PMAX = 9999;
        this.pageQueryResult = new VideoInfo();
        ((VideoInfo)this.pageQueryResult).setClips(new LinkedHashMap<Long, ClipInfo>());
    }

    @Override
    public VideoInfo result(int n, int n2, Object ... objectArray) {
        this.initPageQueryParam();
        Logger.printf("pageSize: %d, page: %d", n, n2);
        try {
            Logger.printf("URL4PictureRLParser\u6b63\u5728\u83b7\u53d6\u7ed3\u679c: rl%s, p=%d, pageSize=%d", this.rlIdNumber, n2, n);
            String string = "rl" + this.rlIdNumber;
            String string2 = "https://api.bilibili.com/x/article/list/web/articles?jsonp=jsonp&id=" + this.rlIdNumber;
            HashMap<String, String> hashMap = new HttpHeaders().getCommonHeaders();
            String string3 = this.util.getContent(string2, hashMap, HttpCookies.globalCookiesWithFingerprint());
            Logger.println(string2);
            Logger.println(string3);
            JSONObject jSONObject = new JSONObject(string3).getJSONObject("data");
            JSONObject jSONObject2 = jSONObject.getJSONObject("list");
            JSONObject jSONObject3 = jSONObject.getJSONObject("author");
            JSONArray jSONArray = jSONObject.getJSONArray("articles");
            ((VideoInfo)this.pageQueryResult).setVideoId(string);
            ((VideoInfo)this.pageQueryResult).setVideoName(jSONObject2.getString("name") + this.paramSetter.getPage());
            ((VideoInfo)this.pageQueryResult).setBrief(jSONObject2.getString("summary"));
            ((VideoInfo)this.pageQueryResult).setAuthor(jSONObject3.getString("name"));
            ((VideoInfo)this.pageQueryResult).setAuthorId(jSONObject3.optString("mid"));
            ((VideoInfo)this.pageQueryResult).setVideoPreview(jSONObject2.getString("image_url"));
            int n3 = (n2 - 1) * n;
            int n4 = n2 * n - 1;
            LinkedHashMap<Long, ClipInfo> linkedHashMap = ((VideoInfo)this.pageQueryResult).getClips();
            URL4PictureCVParser uRL4PictureCVParser = new URL4PictureCVParser(this.obj);
            for (int i = n3; i < jSONArray.length() && i <= n4; ++i) {
                JSONObject jSONObject4 = jSONArray.getJSONObject(i);
                String string4 = jSONObject4.optString("id");
                VideoInfo videoInfo = uRL4PictureCVParser.getCVDetail(string4);
                for (ClipInfo clipInfo : videoInfo.getClips().values()) {
                    clipInfo.setRemark(i);
                    linkedHashMap.put(Long.parseLong(string4 + clipInfo.getPage()), clipInfo);
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return (VideoInfo)this.pageQueryResult;
    }

    @Override
    protected boolean query(int n, int n2, int n3, Object ... objectArray) {
        return false;
    }
}

