/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.convert.ConvertUtil;
import nicelee.ui.Global;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="CheeseSSParser", note="\u8bfe\u7a0b\u96c6\u5408")
public class CheeseSSParser
extends AbstractPageQueryParser<VideoInfo> {
    private static final Pattern pattern = Pattern.compile("/cheese/play/ss([0-9]+)");
    private static final Pattern idPattern = Pattern.compile("season([0-9]+)_([0-9]+)_([0-9]+)");
    private String ssID;
    private String epID;
    private String avID;

    public CheeseSSParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        if (this.matcher.find()) {
            this.ssID = this.matcher.group(1);
            return true;
        }
        this.matcher = idPattern.matcher(string);
        if (this.matcher.find()) {
            this.ssID = this.matcher.group(1);
            this.epID = this.matcher.group(2);
            this.avID = this.matcher.group(3);
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return this.matcher.group().trim() + "p=" + this.paramSetter.getPage();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        Logger.println(this.paramSetter.getPage());
        return (VideoInfo)this.result(this.pageSize, this.paramSetter.getPage(), n, bl);
    }

    @Override
    public void initPageQueryParam() {
        this.API_PMAX = 10;
        this.pageQueryResult = new VideoInfo();
        ((VideoInfo)this.pageQueryResult).setClips(new LinkedHashMap<Long, ClipInfo>());
    }

    @Override
    protected boolean query(int n, int n2, int n3, Object ... objectArray) {
        try {
            JSONObject jSONObject;
            Object object;
            String string;
            String string2;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0");
            hashMap.put("Accept", "application/json, text/plain, */*");
            hashMap.put("Accept-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
            hashMap.put("Accept-Encoding", "gzip, deflate");
            hashMap.put("Origin", "https://www.bilibili.com");
            hashMap.put("Referer", "https://www.bilibili.com/cheese/play/ss" + this.ssID);
            if (((VideoInfo)this.pageQueryResult).getVideoName() == null) {
                string2 = "https://api.bilibili.com/pugv/view/web/season?season_id=" + this.ssID;
                string = this.util.getContent(string2, hashMap, HttpCookies.getGlobalCookies());
                Logger.println(string2);
                Logger.println(string);
                object = new JSONObject(string).getJSONObject("data");
                jSONObject = ((JSONObject)object).getJSONObject("up_info");
                ((VideoInfo)this.pageQueryResult).setVideoId("season_" + this.ssID);
                ((VideoInfo)this.pageQueryResult).setAuthor(jSONObject.getString("uname"));
                ((VideoInfo)this.pageQueryResult).setVideoName(((JSONObject)object).getString("title"));
                ((VideoInfo)this.pageQueryResult).setVideoPreview(((JSONObject)object).getString("cover"));
                ((VideoInfo)this.pageQueryResult).setAuthorId(jSONObject.optString("mid"));
                ((VideoInfo)this.pageQueryResult).setBrief(((JSONObject)object).getString("subtitle"));
            }
            string2 = "https://api.bilibili.com/pugv/view/web/ep/list?season_id=%s&pn=%d&ps=%d";
            string = String.format(string2, this.ssID, n, this.API_PMAX);
            object = this.util.getContent(string, hashMap, HttpCookies.getGlobalCookies());
            Logger.println(string);
            Logger.println((String)object);
            jSONObject = new JSONObject((String)object);
            JSONArray jSONArray = jSONObject.getJSONObject("data").getJSONArray("items");
            LinkedHashMap<Long, ClipInfo> linkedHashMap = ((VideoInfo)this.pageQueryResult).getClips();
            for (int i = n2 - 1; i < jSONArray.length() && i < n3; ++i) {
                int[] nArray;
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                ClipInfo clipInfo = new ClipInfo();
                clipInfo.setAvTitle(((VideoInfo)this.pageQueryResult).getVideoName());
                String string3 = jSONObject2.optString("id");
                String string4 = jSONObject2.optString("aid");
                String string5 = "season%s_%s_%s";
                clipInfo.setAvId(String.format(string5, this.ssID, string3, string4));
                clipInfo.setcId(jSONObject2.optLong("cid"));
                clipInfo.setPage(1);
                clipInfo.setTitle(jSONObject2.getString("title"));
                clipInfo.setPicPreview(((VideoInfo)this.pageQueryResult).getVideoPreview());
                clipInfo.setRemark((n - 1) * this.API_PMAX + i + 1);
                clipInfo.setUpName(((VideoInfo)this.pageQueryResult).getAuthor());
                clipInfo.setUpId(((VideoInfo)this.pageQueryResult).getAuthorId());
                LinkedHashMap<Integer, String> linkedHashMap2 = new LinkedHashMap<Integer, String>();
                for (int n4 : nArray = new int[]{112, 80, 64, 32, 16}) {
                    linkedHashMap2.put(n4, "");
                }
                clipInfo.setLinks(linkedHashMap2);
                linkedHashMap.put(clipInfo.getcId(), clipInfo);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int[] getVideoQNList(String string, String string2, String string3) {
        String string4 = "https://api.bilibili.com/pugv/player/web/playurl?avid=%s&cid=%s&bvid=&qn=%d&type=&otype=json&ep_id=%s&fourk=1&fnver=0&fnval=80";
        String string5 = String.format(string4, string, string2, 80, string3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:75.0) Gecko/20100101 Firefox/75.0");
        hashMap.put("Accept", "application/json, text/plain, */*");
        hashMap.put("Accept-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
        hashMap.put("Accept-Encoding", "gzip, deflate");
        hashMap.put("Origin", "https://www.bilibili.com");
        hashMap.put("Referer", "https://www.bilibili.com/cheese/play/ss" + this.ssID);
        String string6 = this.util.getContent(string5, hashMap, HttpCookies.getGlobalCookies());
        Logger.println(string5);
        Logger.println(string6);
        JSONArray jSONArray = new JSONObject(string6).getJSONObject("data").getJSONArray("accept_quality");
        int[] nArray = new int[jSONArray.length()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = jSONArray.getInt(i);
        }
        return nArray;
    }

    @Override
    public String getVideoLink(String string, String string2, int n, int n2) {
        if (n == 800) {
            return this.getVideoSubtitleLink(ConvertUtil.Av2Bv(this.avID), string2, n);
        }
        if (n == 801) {
            this.paramSetter.setRealQN(n);
            return "https://api.bilibili.com/x/v1/dm/list.so?oid=" + string2;
        }
        String string3 = "https://api.bilibili.com/pugv/player/web/playurl?avid=%s&cid=%s&bvid=&qn=%d&type=&otype=json&ep_id=%s&fourk=1&fnver=0&fnval=80";
        String string4 = String.format(string3, this.avID, string2, n, this.epID);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", Global.userAgent);
        hashMap.put("Accept", "application/json, text/plain, */*");
        hashMap.put("Accept-Language", "zh-CN,zh;q=0.8,zh-TW;q=0.7,zh-HK;q=0.5,en-US;q=0.3,en;q=0.2");
        hashMap.put("Accept-Encoding", "gzip, deflate");
        hashMap.put("Origin", "https://www.bilibili.com");
        hashMap.put("Referer", "https://www.bilibili.com/cheese/play/ss" + this.ssID);
        String string5 = this.util.getContent(string4, hashMap, HttpCookies.getGlobalCookies());
        Logger.println(string4);
        Logger.println(string5);
        JSONObject jSONObject = new JSONObject(string5).getJSONObject("data");
        int n3 = jSONObject.getInt("quality");
        this.paramSetter.setRealQN(n3);
        System.out.println("\u67e5\u8be2\u8d28\u91cf\u4e3a:" + n + "\u7684\u94fe\u63a5, \u5f97\u5230\u8d28\u91cf\u4e3a:" + n3 + "\u7684\u94fe\u63a5");
        try {
            HashMap<String, String> hashMap2 = new HttpHeaders().getBiliWwwM4sHeaders("av" + this.avID);
            hashMap2.put("Referer", "https://www.bilibili.com/cheese/play/ss" + this.ssID);
            return this.parseType1(jSONObject, n3, hashMap2);
        }
        catch (Exception exception) {
            Logger.println("\u5207\u6362\u89e3\u6790\u65b9\u5f0f");
            return this.parseType2(jSONObject);
        }
    }
}

