/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.downloaders.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.downloaders.impl.FLVDownloader;
import nicelee.bilibili.enums.StatusEnum;
import nicelee.bilibili.util.Encrypt;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.bilibili.util.VersionManagerUtil;
import nicelee.ui.Global;
import nicelee.ui.item.JOptionPane;

@Bilibili(name="version-downloader", type="downloader", note="\u6700\u65b0\u7684\u7248\u672c\u4e0b\u8f7d")
public class VersionDownloader
extends FLVDownloader {
    private static final Pattern pattern = Pattern.compile("BilibiliDown\\.v([0-9]+\\.[0-9]+).*\\.zip");
    protected static final File updateDir = new File(ResourcesUtil.baseDirectory(), "update");
    String downName;
    String version;

    @Override
    public boolean matches(String string) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.downName = matcher.group();
            this.version = matcher.group(1);
            return true;
        }
        return false;
    }

    @Override
    public boolean download(String string, String string2, int n, int n2) {
        this.convertingStatus = StatusEnum.NONE;
        this.currentTask = 1;
        if (this.file == null) {
            this.file = new File(updateDir, this.downName);
        }
        try {
            this.util.setSavePath(updateDir.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl = this.util.download(string, this.downName, new HashMap<String, String>());
        if (bl) {
            this.sumSuccessDownloaded += this.util.getTotalFileSize();
            this.util.reset();
            try {
                int n3;
                String string3 = Encrypt.SHA1(this.util.getFileDownload());
                Logger.println("\u6587\u4ef6sha1:" + string3);
                String string4 = this.util.getContent(this.getSHA1Url(this.version, this.downName + ".sha1"), null).trim();
                Logger.println("expectedSHA1:" + string4);
                Object[] objectArray = new Object[]{"\u662f", "\u5426"};
                if (!string4.isEmpty() && !string3.equalsIgnoreCase(string4) && (n3 = JOptionPane.showOptionDialog(null, "\u4e0b\u8f7d\u7684SHA1\u4e0e\u6587\u4ef6\u4e0d\u5339\u914d\uff0c\u662f\u5426\u7ee7\u7eed?", "\u6210\u529f\uff01", 0, -1, null, objectArray, objectArray[0])) != 0) {
                    return bl;
                }
                VersionManagerUtil.unzipTargetJar(this.downName);
                n3 = JOptionPane.showOptionDialog(null, "\u5df2\u7ecf\u4e0b\u8f7d\u6210\u529f\uff0c\u9700\u8981\u5173\u95ed\u7a0b\u5e8f\u624d\u80fd\u66f4\u65b0\uff0c\u73b0\u5728\u662f\u5426\u91cd\u542f?", "\u6210\u529f\uff01", 0, -1, null, objectArray, objectArray[0]);
                if (n3 == 0) {
                    VersionManagerUtil.RunCmdAndCloseApp("1");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    private String getSHA1Url(String string, String string2) {
        Logger.println("\u5f53\u524d\u4f7f\u7528\u7684\u66f4\u65b0\u6e90\u4e3a\uff1a " + Global.updateSourceActive);
        String string3 = "bilibili.download.update.patterns." + Global.updateSourceActive;
        String string4 = Global.settings.getOrDefault(string3, "https://github.com/nICEnnnnnnnLee/BilibiliDown/releases/download/V{version}/{file}");
        return string4.replace("{version}", string).replace("{file}", string2);
    }
}

