/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.downloaders.impl;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.downloaders.IDownloader;
import nicelee.bilibili.enums.StatusEnum;
import nicelee.bilibili.exceptions.BilibiliError;
import nicelee.bilibili.util.CmdUtil;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.HttpRequestUtil;
import nicelee.ui.Global;

@Bilibili(name="flv-downloader", type="downloader", note="FLV\u4e0b\u8f7d")
public class FLVDownloader
implements IDownloader {
    protected HttpRequestUtil util;
    protected File file = null;
    protected int currentTask = 1;
    protected int totalTaskCnt = 1;
    protected StatusEnum convertingStatus = StatusEnum.NONE;
    protected long sumSuccessDownloaded = 0L;
    static Pattern pcdnPattern;
    static Pattern hostPattern;
    static Pattern urlReplaceWhitelist;
    static String hostAlt;

    @Override
    public boolean matches(String string) {
        return string.contains(".flv");
    }

    @Override
    public void init(HttpRequestUtil httpRequestUtil) {
        this.util = httpRequestUtil;
    }

    @Override
    public boolean download(String string, String string2, int n, int n2) {
        return this.download(string, string2, n, n2, ".flv");
    }

    protected String tryBetterUrl(String string) {
        string = this.tryReplaceHost(string);
        string = this.tryForceHttp(string);
        return string;
    }

    private String tryReplaceHost(String string) {
        if (Global.forceReplaceUposHost) {
            Matcher matcher;
            if (hostPattern == null) {
                hostPattern = Pattern.compile("://[^/]+");
                urlReplaceWhitelist = Pattern.compile(Global.forceReplaceUrlPattern);
                hostAlt = "://" + Global.altHost;
            }
            if ((matcher = urlReplaceWhitelist.matcher(string)).find()) {
                Matcher matcher2 = hostPattern.matcher(string);
                return matcher2.replaceFirst(hostAlt);
            }
        }
        return string;
    }

    private String tryForceHttp(String string) {
        if (Global.forceHttp) {
            Matcher matcher;
            if (pcdnPattern == null) {
                pcdnPattern = Pattern.compile("://[^/:]+:\\d+/");
            }
            if (!(matcher = pcdnPattern.matcher(string)).find()) {
                return string.replace("https:/", "http:/");
            }
        }
        return string;
    }

    protected boolean download(String string, String string2, int n, int n2, String string3) {
        String string4;
        this.convertingStatus = StatusEnum.NONE;
        this.currentTask = 1;
        String string5 = string2 + "-" + n + "-p" + n2;
        HttpHeaders httpHeaders = new HttpHeaders();
        if (this.file == null) {
            this.file = new File(Global.savePath, string5 + string3);
        }
        if (string.contains("#")) {
            int n3;
            String[] stringArray = string.split("#");
            this.totalTaskCnt = stringArray.length;
            Pattern pattern = Pattern.compile("^([0-9]+)(http.*)$");
            if (this.util.getStatus() == StatusEnum.STOP) {
                return false;
            }
            this.util.init();
            for (n3 = this.currentTask - 1; n3 < stringArray.length; ++n3) {
                stringArray[n3] = this.tryBetterUrl(stringArray[n3]);
                this.currentTask = n3 + 1;
                Matcher matcher = pattern.matcher(stringArray[n3]);
                matcher.find();
                String string6 = matcher.group(1);
                String string7 = matcher.group(2);
                String string8 = string5 + "-part" + string6 + string3;
                if (!this.util.download(string7, string8, httpHeaders.getBiliWwwFLVHeaders(string2))) {
                    return false;
                }
                this.sumSuccessDownloaded += this.util.getTotalFileSize();
                this.util.reset();
            }
            this.convertingStatus = StatusEnum.PROCESSING;
            n3 = CmdUtil.convert(string5 + string3, stringArray.length) ? 1 : 0;
            return this.throwErrorIfNotConvertOk(n3 != 0, string5);
        }
        boolean bl = this.util.download(string = this.tryBetterUrl(string), string4 = string5 + string3, httpHeaders.getBiliWwwFLVHeaders(string2));
        if (bl) {
            this.sumSuccessDownloaded += this.util.getTotalFileSize();
            this.util.reset();
        }
        return bl;
    }

    protected boolean throwErrorIfNotConvertOk(boolean bl, String string) {
        if (bl) {
            this.convertingStatus = StatusEnum.SUCCESS;
            return true;
        }
        this.convertingStatus = StatusEnum.FAIL;
        if (Global.alertIfFFmpegFail) {
            throw new BilibiliError("\u5982\u9700\u5173\u95ed\u8be5\u8b66\u544a\uff0c\u8bf7\u5728\u914d\u7f6e\u9875\u641c\u7d22\u5e76\u4fee\u6539\u914d\u7f6e bilibili.alert.ffmpegFail\n\t\u8f6c\u7801\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5ffmpeg\u914d\u7f6e: " + string);
        }
        return false;
    }

    @Override
    public StatusEnum currentStatus() {
        if (this.file != null && this.file.exists() && (this.convertingStatus == StatusEnum.SUCCESS || this.convertingStatus == StatusEnum.NONE)) {
            return StatusEnum.SUCCESS;
        }
        if (this.currentTask == this.totalTaskCnt) {
            if (this.convertingStatus == StatusEnum.SUCCESS) {
                return StatusEnum.SUCCESS;
            }
            if (this.convertingStatus == StatusEnum.FAIL) {
                return StatusEnum.FAIL;
            }
            if (this.convertingStatus == StatusEnum.PROCESSING) {
                return StatusEnum.PROCESSING;
            }
            return this.util.getStatus();
        }
        switch (this.util.getStatus()) {
            case DOWNLOADING: {
                return StatusEnum.DOWNLOADING;
            }
            case STOP: {
                return StatusEnum.STOP;
            }
            case FAIL: {
                return StatusEnum.FAIL;
            }
            case SUCCESS: {
                return StatusEnum.DOWNLOADING;
            }
        }
        return StatusEnum.NONE;
    }

    @Override
    public int totalTaskCount() {
        return this.totalTaskCnt;
    }

    @Override
    public int currentTask() {
        return this.currentTask;
    }

    @Override
    public void startTask() {
        this.util.init();
    }

    @Override
    public void stopTask() {
        this.util.stopDownload();
    }

    @Override
    public long sumTotalFileSize() {
        return this.sumSuccessDownloaded + this.util.getTotalFileSize();
    }

    @Override
    public long sumDownloadedFileSize() {
        return this.sumSuccessDownloaded + this.util.getDownloadedFileSize();
    }

    @Override
    public long currentFileDownloadedSize() {
        return this.util.getDownloadedFileSize();
    }

    @Override
    public long currentFileTotalSize() {
        return this.util.getTotalFileSize();
    }

    @Override
    public File file() {
        return this.file;
    }
}

