// Copyright (c) Microsoft Corporation.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception

#include <algorithm>
#include <cassert>
#include <cstddef>
#include <format>
#include <iterator>
#include <span>
#include <type_traits>
#include <vector>

using namespace std;

// Generator: tools/unicode_properties_parse/grapheme_break_test_data_gen.py
// Beginning of generated data - DO NOT EDIT manually!

// GraphemeBreakTest-15.0.0.txt
// Date: 2022-02-26, 00:38:37 GMT
template <typename T>
struct test_case_data {
    vector<T> code_points;
    vector<size_t> breaks;
};

template <typename T>
const test_case_data<T> test_data[602];

template <>
const test_case_data<char32_t> test_data<char32_t>[602] = {{{U'\x20', U'\x20'}, {0, 1, 2}},
    {{U'\x20', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\x20', U'\xd'}, {0, 1, 2}}, {{U'\x20', U'\x308', U'\xd'}, {0, 2, 3}},
    {{U'\x20', U'\xa'}, {0, 1, 2}}, {{U'\x20', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\x20', U'\x1'}, {0, 1, 2}},
    {{U'\x20', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\x20', U'\x34f'}, {0, 2}}, {{U'\x20', U'\x308', U'\x34f'}, {0, 3}},
    {{U'\x20', U'\x1f1e6'}, {0, 1, 2}}, {{U'\x20', U'\x308', U'\x1f1e6'}, {0, 2, 3}}, {{U'\x20', U'\x600'}, {0, 1, 2}},
    {{U'\x20', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\x20', U'\x903'}, {0, 2}}, {{U'\x20', U'\x308', U'\x903'}, {0, 3}},
    {{U'\x20', U'\x1100'}, {0, 1, 2}}, {{U'\x20', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\x20', U'\x1160'}, {0, 1, 2}},
    {{U'\x20', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\x20', U'\x11a8'}, {0, 1, 2}},
    {{U'\x20', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\x20', U'\xac00'}, {0, 1, 2}},
    {{U'\x20', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\x20', U'\xac01'}, {0, 1, 2}},
    {{U'\x20', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\x20', U'\x231a'}, {0, 1, 2}},
    {{U'\x20', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\x20', U'\x300'}, {0, 2}}, {{U'\x20', U'\x308', U'\x300'}, {0, 3}},
    {{U'\x20', U'\x200d'}, {0, 2}}, {{U'\x20', U'\x308', U'\x200d'}, {0, 3}}, {{U'\x20', U'\x378'}, {0, 1, 2}},
    {{U'\x20', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\xd', U'\x20'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\x20'}, {0, 1, 2, 3}}, {{U'\xd', U'\xd'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\xd'}, {0, 1, 2, 3}}, {{U'\xd', U'\xa'}, {0, 2}}, {{U'\xd', U'\x308', U'\xa'}, {0, 1, 2, 3}},
    {{U'\xd', U'\x1'}, {0, 1, 2}}, {{U'\xd', U'\x308', U'\x1'}, {0, 1, 2, 3}}, {{U'\xd', U'\x34f'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\x34f'}, {0, 1, 3}}, {{U'\xd', U'\x1f1e6'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\x1f1e6'}, {0, 1, 2, 3}}, {{U'\xd', U'\x600'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\x600'}, {0, 1, 2, 3}}, {{U'\xd', U'\x903'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\x903'}, {0, 1, 3}}, {{U'\xd', U'\x1100'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\x1100'}, {0, 1, 2, 3}}, {{U'\xd', U'\x1160'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\x1160'}, {0, 1, 2, 3}}, {{U'\xd', U'\x11a8'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\x11a8'}, {0, 1, 2, 3}}, {{U'\xd', U'\xac00'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\xac00'}, {0, 1, 2, 3}}, {{U'\xd', U'\xac01'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\xac01'}, {0, 1, 2, 3}}, {{U'\xd', U'\x231a'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\x231a'}, {0, 1, 2, 3}}, {{U'\xd', U'\x300'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\x300'}, {0, 1, 3}}, {{U'\xd', U'\x200d'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\x200d'}, {0, 1, 3}}, {{U'\xd', U'\x378'}, {0, 1, 2}},
    {{U'\xd', U'\x308', U'\x378'}, {0, 1, 2, 3}}, {{U'\xa', U'\x20'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x20'}, {0, 1, 2, 3}}, {{U'\xa', U'\xd'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\xd'}, {0, 1, 2, 3}}, {{U'\xa', U'\xa'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\xa'}, {0, 1, 2, 3}}, {{U'\xa', U'\x1'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x1'}, {0, 1, 2, 3}}, {{U'\xa', U'\x34f'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x34f'}, {0, 1, 3}}, {{U'\xa', U'\x1f1e6'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x1f1e6'}, {0, 1, 2, 3}}, {{U'\xa', U'\x600'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x600'}, {0, 1, 2, 3}}, {{U'\xa', U'\x903'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x903'}, {0, 1, 3}}, {{U'\xa', U'\x1100'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x1100'}, {0, 1, 2, 3}}, {{U'\xa', U'\x1160'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x1160'}, {0, 1, 2, 3}}, {{U'\xa', U'\x11a8'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x11a8'}, {0, 1, 2, 3}}, {{U'\xa', U'\xac00'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\xac00'}, {0, 1, 2, 3}}, {{U'\xa', U'\xac01'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\xac01'}, {0, 1, 2, 3}}, {{U'\xa', U'\x231a'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x231a'}, {0, 1, 2, 3}}, {{U'\xa', U'\x300'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x300'}, {0, 1, 3}}, {{U'\xa', U'\x200d'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x200d'}, {0, 1, 3}}, {{U'\xa', U'\x378'}, {0, 1, 2}},
    {{U'\xa', U'\x308', U'\x378'}, {0, 1, 2, 3}}, {{U'\x1', U'\x20'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x20'}, {0, 1, 2, 3}}, {{U'\x1', U'\xd'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\xd'}, {0, 1, 2, 3}}, {{U'\x1', U'\xa'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\xa'}, {0, 1, 2, 3}}, {{U'\x1', U'\x1'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x1'}, {0, 1, 2, 3}}, {{U'\x1', U'\x34f'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x34f'}, {0, 1, 3}}, {{U'\x1', U'\x1f1e6'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x1f1e6'}, {0, 1, 2, 3}}, {{U'\x1', U'\x600'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x600'}, {0, 1, 2, 3}}, {{U'\x1', U'\x903'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x903'}, {0, 1, 3}}, {{U'\x1', U'\x1100'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x1100'}, {0, 1, 2, 3}}, {{U'\x1', U'\x1160'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x1160'}, {0, 1, 2, 3}}, {{U'\x1', U'\x11a8'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x11a8'}, {0, 1, 2, 3}}, {{U'\x1', U'\xac00'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\xac00'}, {0, 1, 2, 3}}, {{U'\x1', U'\xac01'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\xac01'}, {0, 1, 2, 3}}, {{U'\x1', U'\x231a'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x231a'}, {0, 1, 2, 3}}, {{U'\x1', U'\x300'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x300'}, {0, 1, 3}}, {{U'\x1', U'\x200d'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x200d'}, {0, 1, 3}}, {{U'\x1', U'\x378'}, {0, 1, 2}},
    {{U'\x1', U'\x308', U'\x378'}, {0, 1, 2, 3}}, {{U'\x34f', U'\x20'}, {0, 1, 2}},
    {{U'\x34f', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\x34f', U'\xd'}, {0, 1, 2}},
    {{U'\x34f', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\x34f', U'\xa'}, {0, 1, 2}},
    {{U'\x34f', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\x34f', U'\x1'}, {0, 1, 2}},
    {{U'\x34f', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\x34f', U'\x34f'}, {0, 2}}, {{U'\x34f', U'\x308', U'\x34f'}, {0, 3}},
    {{U'\x34f', U'\x1f1e6'}, {0, 1, 2}}, {{U'\x34f', U'\x308', U'\x1f1e6'}, {0, 2, 3}},
    {{U'\x34f', U'\x600'}, {0, 1, 2}}, {{U'\x34f', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\x34f', U'\x903'}, {0, 2}},
    {{U'\x34f', U'\x308', U'\x903'}, {0, 3}}, {{U'\x34f', U'\x1100'}, {0, 1, 2}},
    {{U'\x34f', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\x34f', U'\x1160'}, {0, 1, 2}},
    {{U'\x34f', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\x34f', U'\x11a8'}, {0, 1, 2}},
    {{U'\x34f', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\x34f', U'\xac00'}, {0, 1, 2}},
    {{U'\x34f', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\x34f', U'\xac01'}, {0, 1, 2}},
    {{U'\x34f', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\x34f', U'\x231a'}, {0, 1, 2}},
    {{U'\x34f', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\x34f', U'\x300'}, {0, 2}},
    {{U'\x34f', U'\x308', U'\x300'}, {0, 3}}, {{U'\x34f', U'\x200d'}, {0, 2}},
    {{U'\x34f', U'\x308', U'\x200d'}, {0, 3}}, {{U'\x34f', U'\x378'}, {0, 1, 2}},
    {{U'\x34f', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\x1f1e6', U'\x20'}, {0, 1, 2}},
    {{U'\x1f1e6', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\x1f1e6', U'\xd'}, {0, 1, 2}},
    {{U'\x1f1e6', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\x1f1e6', U'\xa'}, {0, 1, 2}},
    {{U'\x1f1e6', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\x1f1e6', U'\x1'}, {0, 1, 2}},
    {{U'\x1f1e6', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\x1f1e6', U'\x34f'}, {0, 2}},
    {{U'\x1f1e6', U'\x308', U'\x34f'}, {0, 3}}, {{U'\x1f1e6', U'\x1f1e6'}, {0, 2}},
    {{U'\x1f1e6', U'\x308', U'\x1f1e6'}, {0, 2, 3}}, {{U'\x1f1e6', U'\x600'}, {0, 1, 2}},
    {{U'\x1f1e6', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\x1f1e6', U'\x903'}, {0, 2}},
    {{U'\x1f1e6', U'\x308', U'\x903'}, {0, 3}}, {{U'\x1f1e6', U'\x1100'}, {0, 1, 2}},
    {{U'\x1f1e6', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\x1f1e6', U'\x1160'}, {0, 1, 2}},
    {{U'\x1f1e6', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\x1f1e6', U'\x11a8'}, {0, 1, 2}},
    {{U'\x1f1e6', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\x1f1e6', U'\xac00'}, {0, 1, 2}},
    {{U'\x1f1e6', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\x1f1e6', U'\xac01'}, {0, 1, 2}},
    {{U'\x1f1e6', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\x1f1e6', U'\x231a'}, {0, 1, 2}},
    {{U'\x1f1e6', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\x1f1e6', U'\x300'}, {0, 2}},
    {{U'\x1f1e6', U'\x308', U'\x300'}, {0, 3}}, {{U'\x1f1e6', U'\x200d'}, {0, 2}},
    {{U'\x1f1e6', U'\x308', U'\x200d'}, {0, 3}}, {{U'\x1f1e6', U'\x378'}, {0, 1, 2}},
    {{U'\x1f1e6', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\x600', U'\x20'}, {0, 2}},
    {{U'\x600', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\x600', U'\xd'}, {0, 1, 2}},
    {{U'\x600', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\x600', U'\xa'}, {0, 1, 2}},
    {{U'\x600', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\x600', U'\x1'}, {0, 1, 2}},
    {{U'\x600', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\x600', U'\x34f'}, {0, 2}}, {{U'\x600', U'\x308', U'\x34f'}, {0, 3}},
    {{U'\x600', U'\x1f1e6'}, {0, 2}}, {{U'\x600', U'\x308', U'\x1f1e6'}, {0, 2, 3}}, {{U'\x600', U'\x600'}, {0, 2}},
    {{U'\x600', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\x600', U'\x903'}, {0, 2}},
    {{U'\x600', U'\x308', U'\x903'}, {0, 3}}, {{U'\x600', U'\x1100'}, {0, 2}},
    {{U'\x600', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\x600', U'\x1160'}, {0, 2}},
    {{U'\x600', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\x600', U'\x11a8'}, {0, 2}},
    {{U'\x600', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\x600', U'\xac00'}, {0, 2}},
    {{U'\x600', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\x600', U'\xac01'}, {0, 2}},
    {{U'\x600', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\x600', U'\x231a'}, {0, 2}},
    {{U'\x600', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\x600', U'\x300'}, {0, 2}},
    {{U'\x600', U'\x308', U'\x300'}, {0, 3}}, {{U'\x600', U'\x200d'}, {0, 2}},
    {{U'\x600', U'\x308', U'\x200d'}, {0, 3}}, {{U'\x600', U'\x378'}, {0, 2}},
    {{U'\x600', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\x903', U'\x20'}, {0, 1, 2}},
    {{U'\x903', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\x903', U'\xd'}, {0, 1, 2}},
    {{U'\x903', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\x903', U'\xa'}, {0, 1, 2}},
    {{U'\x903', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\x903', U'\x1'}, {0, 1, 2}},
    {{U'\x903', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\x903', U'\x34f'}, {0, 2}}, {{U'\x903', U'\x308', U'\x34f'}, {0, 3}},
    {{U'\x903', U'\x1f1e6'}, {0, 1, 2}}, {{U'\x903', U'\x308', U'\x1f1e6'}, {0, 2, 3}},
    {{U'\x903', U'\x600'}, {0, 1, 2}}, {{U'\x903', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\x903', U'\x903'}, {0, 2}},
    {{U'\x903', U'\x308', U'\x903'}, {0, 3}}, {{U'\x903', U'\x1100'}, {0, 1, 2}},
    {{U'\x903', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\x903', U'\x1160'}, {0, 1, 2}},
    {{U'\x903', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\x903', U'\x11a8'}, {0, 1, 2}},
    {{U'\x903', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\x903', U'\xac00'}, {0, 1, 2}},
    {{U'\x903', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\x903', U'\xac01'}, {0, 1, 2}},
    {{U'\x903', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\x903', U'\x231a'}, {0, 1, 2}},
    {{U'\x903', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\x903', U'\x300'}, {0, 2}},
    {{U'\x903', U'\x308', U'\x300'}, {0, 3}}, {{U'\x903', U'\x200d'}, {0, 2}},
    {{U'\x903', U'\x308', U'\x200d'}, {0, 3}}, {{U'\x903', U'\x378'}, {0, 1, 2}},
    {{U'\x903', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\x1100', U'\x20'}, {0, 1, 2}},
    {{U'\x1100', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\x1100', U'\xd'}, {0, 1, 2}},
    {{U'\x1100', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\x1100', U'\xa'}, {0, 1, 2}},
    {{U'\x1100', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\x1100', U'\x1'}, {0, 1, 2}},
    {{U'\x1100', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\x1100', U'\x34f'}, {0, 2}},
    {{U'\x1100', U'\x308', U'\x34f'}, {0, 3}}, {{U'\x1100', U'\x1f1e6'}, {0, 1, 2}},
    {{U'\x1100', U'\x308', U'\x1f1e6'}, {0, 2, 3}}, {{U'\x1100', U'\x600'}, {0, 1, 2}},
    {{U'\x1100', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\x1100', U'\x903'}, {0, 2}},
    {{U'\x1100', U'\x308', U'\x903'}, {0, 3}}, {{U'\x1100', U'\x1100'}, {0, 2}},
    {{U'\x1100', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\x1100', U'\x1160'}, {0, 2}},
    {{U'\x1100', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\x1100', U'\x11a8'}, {0, 1, 2}},
    {{U'\x1100', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\x1100', U'\xac00'}, {0, 2}},
    {{U'\x1100', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\x1100', U'\xac01'}, {0, 2}},
    {{U'\x1100', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\x1100', U'\x231a'}, {0, 1, 2}},
    {{U'\x1100', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\x1100', U'\x300'}, {0, 2}},
    {{U'\x1100', U'\x308', U'\x300'}, {0, 3}}, {{U'\x1100', U'\x200d'}, {0, 2}},
    {{U'\x1100', U'\x308', U'\x200d'}, {0, 3}}, {{U'\x1100', U'\x378'}, {0, 1, 2}},
    {{U'\x1100', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\x1160', U'\x20'}, {0, 1, 2}},
    {{U'\x1160', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\x1160', U'\xd'}, {0, 1, 2}},
    {{U'\x1160', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\x1160', U'\xa'}, {0, 1, 2}},
    {{U'\x1160', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\x1160', U'\x1'}, {0, 1, 2}},
    {{U'\x1160', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\x1160', U'\x34f'}, {0, 2}},
    {{U'\x1160', U'\x308', U'\x34f'}, {0, 3}}, {{U'\x1160', U'\x1f1e6'}, {0, 1, 2}},
    {{U'\x1160', U'\x308', U'\x1f1e6'}, {0, 2, 3}}, {{U'\x1160', U'\x600'}, {0, 1, 2}},
    {{U'\x1160', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\x1160', U'\x903'}, {0, 2}},
    {{U'\x1160', U'\x308', U'\x903'}, {0, 3}}, {{U'\x1160', U'\x1100'}, {0, 1, 2}},
    {{U'\x1160', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\x1160', U'\x1160'}, {0, 2}},
    {{U'\x1160', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\x1160', U'\x11a8'}, {0, 2}},
    {{U'\x1160', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\x1160', U'\xac00'}, {0, 1, 2}},
    {{U'\x1160', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\x1160', U'\xac01'}, {0, 1, 2}},
    {{U'\x1160', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\x1160', U'\x231a'}, {0, 1, 2}},
    {{U'\x1160', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\x1160', U'\x300'}, {0, 2}},
    {{U'\x1160', U'\x308', U'\x300'}, {0, 3}}, {{U'\x1160', U'\x200d'}, {0, 2}},
    {{U'\x1160', U'\x308', U'\x200d'}, {0, 3}}, {{U'\x1160', U'\x378'}, {0, 1, 2}},
    {{U'\x1160', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\x11a8', U'\x20'}, {0, 1, 2}},
    {{U'\x11a8', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\x11a8', U'\xd'}, {0, 1, 2}},
    {{U'\x11a8', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\x11a8', U'\xa'}, {0, 1, 2}},
    {{U'\x11a8', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\x11a8', U'\x1'}, {0, 1, 2}},
    {{U'\x11a8', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\x11a8', U'\x34f'}, {0, 2}},
    {{U'\x11a8', U'\x308', U'\x34f'}, {0, 3}}, {{U'\x11a8', U'\x1f1e6'}, {0, 1, 2}},
    {{U'\x11a8', U'\x308', U'\x1f1e6'}, {0, 2, 3}}, {{U'\x11a8', U'\x600'}, {0, 1, 2}},
    {{U'\x11a8', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\x11a8', U'\x903'}, {0, 2}},
    {{U'\x11a8', U'\x308', U'\x903'}, {0, 3}}, {{U'\x11a8', U'\x1100'}, {0, 1, 2}},
    {{U'\x11a8', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\x11a8', U'\x1160'}, {0, 1, 2}},
    {{U'\x11a8', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\x11a8', U'\x11a8'}, {0, 2}},
    {{U'\x11a8', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\x11a8', U'\xac00'}, {0, 1, 2}},
    {{U'\x11a8', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\x11a8', U'\xac01'}, {0, 1, 2}},
    {{U'\x11a8', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\x11a8', U'\x231a'}, {0, 1, 2}},
    {{U'\x11a8', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\x11a8', U'\x300'}, {0, 2}},
    {{U'\x11a8', U'\x308', U'\x300'}, {0, 3}}, {{U'\x11a8', U'\x200d'}, {0, 2}},
    {{U'\x11a8', U'\x308', U'\x200d'}, {0, 3}}, {{U'\x11a8', U'\x378'}, {0, 1, 2}},
    {{U'\x11a8', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\xac00', U'\x20'}, {0, 1, 2}},
    {{U'\xac00', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\xac00', U'\xd'}, {0, 1, 2}},
    {{U'\xac00', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\xac00', U'\xa'}, {0, 1, 2}},
    {{U'\xac00', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\xac00', U'\x1'}, {0, 1, 2}},
    {{U'\xac00', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\xac00', U'\x34f'}, {0, 2}},
    {{U'\xac00', U'\x308', U'\x34f'}, {0, 3}}, {{U'\xac00', U'\x1f1e6'}, {0, 1, 2}},
    {{U'\xac00', U'\x308', U'\x1f1e6'}, {0, 2, 3}}, {{U'\xac00', U'\x600'}, {0, 1, 2}},
    {{U'\xac00', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\xac00', U'\x903'}, {0, 2}},
    {{U'\xac00', U'\x308', U'\x903'}, {0, 3}}, {{U'\xac00', U'\x1100'}, {0, 1, 2}},
    {{U'\xac00', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\xac00', U'\x1160'}, {0, 2}},
    {{U'\xac00', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\xac00', U'\x11a8'}, {0, 2}},
    {{U'\xac00', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\xac00', U'\xac00'}, {0, 1, 2}},
    {{U'\xac00', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\xac00', U'\xac01'}, {0, 1, 2}},
    {{U'\xac00', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\xac00', U'\x231a'}, {0, 1, 2}},
    {{U'\xac00', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\xac00', U'\x300'}, {0, 2}},
    {{U'\xac00', U'\x308', U'\x300'}, {0, 3}}, {{U'\xac00', U'\x200d'}, {0, 2}},
    {{U'\xac00', U'\x308', U'\x200d'}, {0, 3}}, {{U'\xac00', U'\x378'}, {0, 1, 2}},
    {{U'\xac00', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\xac01', U'\x20'}, {0, 1, 2}},
    {{U'\xac01', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\xac01', U'\xd'}, {0, 1, 2}},
    {{U'\xac01', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\xac01', U'\xa'}, {0, 1, 2}},
    {{U'\xac01', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\xac01', U'\x1'}, {0, 1, 2}},
    {{U'\xac01', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\xac01', U'\x34f'}, {0, 2}},
    {{U'\xac01', U'\x308', U'\x34f'}, {0, 3}}, {{U'\xac01', U'\x1f1e6'}, {0, 1, 2}},
    {{U'\xac01', U'\x308', U'\x1f1e6'}, {0, 2, 3}}, {{U'\xac01', U'\x600'}, {0, 1, 2}},
    {{U'\xac01', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\xac01', U'\x903'}, {0, 2}},
    {{U'\xac01', U'\x308', U'\x903'}, {0, 3}}, {{U'\xac01', U'\x1100'}, {0, 1, 2}},
    {{U'\xac01', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\xac01', U'\x1160'}, {0, 1, 2}},
    {{U'\xac01', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\xac01', U'\x11a8'}, {0, 2}},
    {{U'\xac01', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\xac01', U'\xac00'}, {0, 1, 2}},
    {{U'\xac01', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\xac01', U'\xac01'}, {0, 1, 2}},
    {{U'\xac01', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\xac01', U'\x231a'}, {0, 1, 2}},
    {{U'\xac01', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\xac01', U'\x300'}, {0, 2}},
    {{U'\xac01', U'\x308', U'\x300'}, {0, 3}}, {{U'\xac01', U'\x200d'}, {0, 2}},
    {{U'\xac01', U'\x308', U'\x200d'}, {0, 3}}, {{U'\xac01', U'\x378'}, {0, 1, 2}},
    {{U'\xac01', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\x231a', U'\x20'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\x231a', U'\xd'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\x231a', U'\xa'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\x231a', U'\x1'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\x231a', U'\x34f'}, {0, 2}},
    {{U'\x231a', U'\x308', U'\x34f'}, {0, 3}}, {{U'\x231a', U'\x1f1e6'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\x1f1e6'}, {0, 2, 3}}, {{U'\x231a', U'\x600'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\x231a', U'\x903'}, {0, 2}},
    {{U'\x231a', U'\x308', U'\x903'}, {0, 3}}, {{U'\x231a', U'\x1100'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\x231a', U'\x1160'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\x231a', U'\x11a8'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\x231a', U'\xac00'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\x231a', U'\xac01'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\x231a', U'\x231a'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\x231a', U'\x300'}, {0, 2}},
    {{U'\x231a', U'\x308', U'\x300'}, {0, 3}}, {{U'\x231a', U'\x200d'}, {0, 2}},
    {{U'\x231a', U'\x308', U'\x200d'}, {0, 3}}, {{U'\x231a', U'\x378'}, {0, 1, 2}},
    {{U'\x231a', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\x300', U'\x20'}, {0, 1, 2}},
    {{U'\x300', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\x300', U'\xd'}, {0, 1, 2}},
    {{U'\x300', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\x300', U'\xa'}, {0, 1, 2}},
    {{U'\x300', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\x300', U'\x1'}, {0, 1, 2}},
    {{U'\x300', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\x300', U'\x34f'}, {0, 2}}, {{U'\x300', U'\x308', U'\x34f'}, {0, 3}},
    {{U'\x300', U'\x1f1e6'}, {0, 1, 2}}, {{U'\x300', U'\x308', U'\x1f1e6'}, {0, 2, 3}},
    {{U'\x300', U'\x600'}, {0, 1, 2}}, {{U'\x300', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\x300', U'\x903'}, {0, 2}},
    {{U'\x300', U'\x308', U'\x903'}, {0, 3}}, {{U'\x300', U'\x1100'}, {0, 1, 2}},
    {{U'\x300', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\x300', U'\x1160'}, {0, 1, 2}},
    {{U'\x300', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\x300', U'\x11a8'}, {0, 1, 2}},
    {{U'\x300', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\x300', U'\xac00'}, {0, 1, 2}},
    {{U'\x300', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\x300', U'\xac01'}, {0, 1, 2}},
    {{U'\x300', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\x300', U'\x231a'}, {0, 1, 2}},
    {{U'\x300', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\x300', U'\x300'}, {0, 2}},
    {{U'\x300', U'\x308', U'\x300'}, {0, 3}}, {{U'\x300', U'\x200d'}, {0, 2}},
    {{U'\x300', U'\x308', U'\x200d'}, {0, 3}}, {{U'\x300', U'\x378'}, {0, 1, 2}},
    {{U'\x300', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\x200d', U'\x20'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\x200d', U'\xd'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\x200d', U'\xa'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\x200d', U'\x1'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\x200d', U'\x34f'}, {0, 2}},
    {{U'\x200d', U'\x308', U'\x34f'}, {0, 3}}, {{U'\x200d', U'\x1f1e6'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\x1f1e6'}, {0, 2, 3}}, {{U'\x200d', U'\x600'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\x200d', U'\x903'}, {0, 2}},
    {{U'\x200d', U'\x308', U'\x903'}, {0, 3}}, {{U'\x200d', U'\x1100'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\x200d', U'\x1160'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\x200d', U'\x11a8'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\x200d', U'\xac00'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\x200d', U'\xac01'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\x200d', U'\x231a'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\x200d', U'\x300'}, {0, 2}},
    {{U'\x200d', U'\x308', U'\x300'}, {0, 3}}, {{U'\x200d', U'\x200d'}, {0, 2}},
    {{U'\x200d', U'\x308', U'\x200d'}, {0, 3}}, {{U'\x200d', U'\x378'}, {0, 1, 2}},
    {{U'\x200d', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\x378', U'\x20'}, {0, 1, 2}},
    {{U'\x378', U'\x308', U'\x20'}, {0, 2, 3}}, {{U'\x378', U'\xd'}, {0, 1, 2}},
    {{U'\x378', U'\x308', U'\xd'}, {0, 2, 3}}, {{U'\x378', U'\xa'}, {0, 1, 2}},
    {{U'\x378', U'\x308', U'\xa'}, {0, 2, 3}}, {{U'\x378', U'\x1'}, {0, 1, 2}},
    {{U'\x378', U'\x308', U'\x1'}, {0, 2, 3}}, {{U'\x378', U'\x34f'}, {0, 2}}, {{U'\x378', U'\x308', U'\x34f'}, {0, 3}},
    {{U'\x378', U'\x1f1e6'}, {0, 1, 2}}, {{U'\x378', U'\x308', U'\x1f1e6'}, {0, 2, 3}},
    {{U'\x378', U'\x600'}, {0, 1, 2}}, {{U'\x378', U'\x308', U'\x600'}, {0, 2, 3}}, {{U'\x378', U'\x903'}, {0, 2}},
    {{U'\x378', U'\x308', U'\x903'}, {0, 3}}, {{U'\x378', U'\x1100'}, {0, 1, 2}},
    {{U'\x378', U'\x308', U'\x1100'}, {0, 2, 3}}, {{U'\x378', U'\x1160'}, {0, 1, 2}},
    {{U'\x378', U'\x308', U'\x1160'}, {0, 2, 3}}, {{U'\x378', U'\x11a8'}, {0, 1, 2}},
    {{U'\x378', U'\x308', U'\x11a8'}, {0, 2, 3}}, {{U'\x378', U'\xac00'}, {0, 1, 2}},
    {{U'\x378', U'\x308', U'\xac00'}, {0, 2, 3}}, {{U'\x378', U'\xac01'}, {0, 1, 2}},
    {{U'\x378', U'\x308', U'\xac01'}, {0, 2, 3}}, {{U'\x378', U'\x231a'}, {0, 1, 2}},
    {{U'\x378', U'\x308', U'\x231a'}, {0, 2, 3}}, {{U'\x378', U'\x300'}, {0, 2}},
    {{U'\x378', U'\x308', U'\x300'}, {0, 3}}, {{U'\x378', U'\x200d'}, {0, 2}},
    {{U'\x378', U'\x308', U'\x200d'}, {0, 3}}, {{U'\x378', U'\x378'}, {0, 1, 2}},
    {{U'\x378', U'\x308', U'\x378'}, {0, 2, 3}}, {{U'\xd', U'\xa', U'\x61', U'\xa', U'\x308'}, {0, 2, 3, 4, 5}},
    {{U'\x61', U'\x308'}, {0, 2}}, {{U'\x20', U'\x200d', U'\x646'}, {0, 2, 3}},
    {{U'\x646', U'\x200d', U'\x20'}, {0, 2, 3}}, {{U'\x1100', U'\x1100'}, {0, 2}},
    {{U'\xac00', U'\x11a8', U'\x1100'}, {0, 2, 3}}, {{U'\xac01', U'\x11a8', U'\x1100'}, {0, 2, 3}},
    {{U'\x1f1e6', U'\x1f1e7', U'\x1f1e8', U'\x62'}, {0, 2, 3, 4}},
    {{U'\x61', U'\x1f1e6', U'\x1f1e7', U'\x1f1e8', U'\x62'}, {0, 1, 3, 4, 5}},
    {{U'\x61', U'\x1f1e6', U'\x1f1e7', U'\x200d', U'\x1f1e8', U'\x62'}, {0, 1, 4, 5, 6}},
    {{U'\x61', U'\x1f1e6', U'\x200d', U'\x1f1e7', U'\x1f1e8', U'\x62'}, {0, 1, 3, 5, 6}},
    {{U'\x61', U'\x1f1e6', U'\x1f1e7', U'\x1f1e8', U'\x1f1e9', U'\x62'}, {0, 1, 3, 5, 6}},
    {{U'\x61', U'\x200d'}, {0, 2}}, {{U'\x61', U'\x308', U'\x62'}, {0, 2, 3}},
    {{U'\x61', U'\x903', U'\x62'}, {0, 2, 3}}, {{U'\x61', U'\x600', U'\x62'}, {0, 1, 3}},
    {{U'\x1f476', U'\x1f3ff', U'\x1f476'}, {0, 2, 3}}, {{U'\x61', U'\x1f3ff', U'\x1f476'}, {0, 2, 3}},
    {{U'\x61', U'\x1f3ff', U'\x1f476', U'\x200d', U'\x1f6d1'}, {0, 2, 5}},
    {{U'\x1f476', U'\x1f3ff', U'\x308', U'\x200d', U'\x1f476', U'\x1f3ff'}, {0, 6}},
    {{U'\x1f6d1', U'\x200d', U'\x1f6d1'}, {0, 3}}, {{U'\x61', U'\x200d', U'\x1f6d1'}, {0, 2, 3}},
    {{U'\x2701', U'\x200d', U'\x2701'}, {0, 3}}, {{U'\x61', U'\x200d', U'\x2701'}, {0, 2, 3}}};

template <>
const test_case_data<char> test_data<char>[602] = {{{'\x20', '\x20'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\x20'}, {0, 2, 3}}, {{'\x20', '\xd'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\xd'}, {0, 2, 3}}, {{'\x20', '\xa'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\xa'}, {0, 2, 3}}, {{'\x20', '\x1'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\x1'}, {0, 2, 3}}, {{'\x20', '\xcd', '\x8f'}, {0, 2}},
    {{'\x20', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}}, {{'\x20', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}}, {{'\x20', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}}, {{'\x20', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\x20', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}}, {{'\x20', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}}, {{'\x20', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}}, {{'\x20', '\xe1', '\x86', '\xa8'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}}, {{'\x20', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}}, {{'\x20', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}}, {{'\x20', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}}, {{'\x20', '\xcc', '\x80'}, {0, 2}},
    {{'\x20', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}}, {{'\x20', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\x20', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}}, {{'\x20', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\x20', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}}, {{'\xd', '\x20'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\x20'}, {0, 1, 2, 3}}, {{'\xd', '\xd'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xd'}, {0, 1, 2, 3}}, {{'\xd', '\xa'}, {0, 2}},
    {{'\xd', '\xcc', '\x88', '\xa'}, {0, 1, 2, 3}}, {{'\xd', '\x1'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\x1'}, {0, 1, 2, 3}}, {{'\xd', '\xcd', '\x8f'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 1, 3}}, {{'\xd', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2, 3}}, {{'\xd', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xd8', '\x80'}, {0, 1, 2, 3}}, {{'\xd', '\xe0', '\xa4', '\x83'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 1, 3}}, {{'\xd', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 1, 2, 3}}, {{'\xd', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 1, 2, 3}}, {{'\xd', '\xe1', '\x86', '\xa8'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 1, 2, 3}}, {{'\xd', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 1, 2, 3}}, {{'\xd', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 1, 2, 3}}, {{'\xd', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 1, 2, 3}}, {{'\xd', '\xcc', '\x80'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xcc', '\x80'}, {0, 1, 3}}, {{'\xd', '\xe2', '\x80', '\x8d'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 1, 3}}, {{'\xd', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xd', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 1, 2, 3}}, {{'\xa', '\x20'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\x20'}, {0, 1, 2, 3}}, {{'\xa', '\xd'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xd'}, {0, 1, 2, 3}}, {{'\xa', '\xa'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xa'}, {0, 1, 2, 3}}, {{'\xa', '\x1'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\x1'}, {0, 1, 2, 3}}, {{'\xa', '\xcd', '\x8f'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 1, 3}}, {{'\xa', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2, 3}}, {{'\xa', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xd8', '\x80'}, {0, 1, 2, 3}}, {{'\xa', '\xe0', '\xa4', '\x83'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 1, 3}}, {{'\xa', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 1, 2, 3}}, {{'\xa', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 1, 2, 3}}, {{'\xa', '\xe1', '\x86', '\xa8'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 1, 2, 3}}, {{'\xa', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 1, 2, 3}}, {{'\xa', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 1, 2, 3}}, {{'\xa', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 1, 2, 3}}, {{'\xa', '\xcc', '\x80'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xcc', '\x80'}, {0, 1, 3}}, {{'\xa', '\xe2', '\x80', '\x8d'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 1, 3}}, {{'\xa', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xa', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 1, 2, 3}}, {{'\x1', '\x20'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\x20'}, {0, 1, 2, 3}}, {{'\x1', '\xd'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xd'}, {0, 1, 2, 3}}, {{'\x1', '\xa'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xa'}, {0, 1, 2, 3}}, {{'\x1', '\x1'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\x1'}, {0, 1, 2, 3}}, {{'\x1', '\xcd', '\x8f'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 1, 3}}, {{'\x1', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2, 3}}, {{'\x1', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xd8', '\x80'}, {0, 1, 2, 3}}, {{'\x1', '\xe0', '\xa4', '\x83'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 1, 3}}, {{'\x1', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 1, 2, 3}}, {{'\x1', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 1, 2, 3}}, {{'\x1', '\xe1', '\x86', '\xa8'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 1, 2, 3}}, {{'\x1', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 1, 2, 3}}, {{'\x1', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 1, 2, 3}}, {{'\x1', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 1, 2, 3}}, {{'\x1', '\xcc', '\x80'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xcc', '\x80'}, {0, 1, 3}}, {{'\x1', '\xe2', '\x80', '\x8d'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 1, 3}}, {{'\x1', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\x1', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 1, 2, 3}}, {{'\xcd', '\x8f', '\x20'}, {0, 1, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\x20'}, {0, 2, 3}}, {{'\xcd', '\x8f', '\xd'}, {0, 1, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xd'}, {0, 2, 3}}, {{'\xcd', '\x8f', '\xa'}, {0, 1, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xa'}, {0, 2, 3}}, {{'\xcd', '\x8f', '\x1'}, {0, 1, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\x1'}, {0, 2, 3}}, {{'\xcd', '\x8f', '\xcd', '\x8f'}, {0, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xcd', '\x8f', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xcd', '\x8f', '\xd8', '\x80'}, {0, 1, 2}}, {{'\xcd', '\x8f', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xcd', '\x8f', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xcd', '\x8f', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xcd', '\x8f', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xcd', '\x8f', '\xe1', '\x86', '\xa8'}, {0, 1, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xcd', '\x8f', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xcd', '\x8f', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xcd', '\x8f', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}}, {{'\xcd', '\x8f', '\xcc', '\x80'}, {0, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}}, {{'\xcd', '\x8f', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}}, {{'\xcd', '\x8f', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xcd', '\x8f', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\x20'}, {0, 1, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\x20'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xd'}, {0, 1, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xd'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xa'}, {0, 1, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xa'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\x1'}, {0, 1, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\x1'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcd', '\x8f'}, {0, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xe1', '\x86', '\xa8'}, {0, 1, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x80'}, {0, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}}, {{'\xd8', '\x80', '\x20'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\x20'}, {0, 2, 3}}, {{'\xd8', '\x80', '\xd'}, {0, 1, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xd'}, {0, 2, 3}}, {{'\xd8', '\x80', '\xa'}, {0, 1, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xa'}, {0, 2, 3}}, {{'\xd8', '\x80', '\x1'}, {0, 1, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\x1'}, {0, 2, 3}}, {{'\xd8', '\x80', '\xcd', '\x8f'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xd8', '\x80', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xd8', '\x80', '\xd8', '\x80'}, {0, 2}}, {{'\xd8', '\x80', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xd8', '\x80', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xd8', '\x80', '\xe1', '\x84', '\x80'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xd8', '\x80', '\xe1', '\x85', '\xa0'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xd8', '\x80', '\xe1', '\x86', '\xa8'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xd8', '\x80', '\xea', '\xb0', '\x80'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xd8', '\x80', '\xea', '\xb0', '\x81'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xd8', '\x80', '\xe2', '\x8c', '\x9a'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}}, {{'\xd8', '\x80', '\xcc', '\x80'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}}, {{'\xd8', '\x80', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}}, {{'\xd8', '\x80', '\xcd', '\xb8'}, {0, 2}},
    {{'\xd8', '\x80', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}}, {{'\xe0', '\xa4', '\x83', '\x20'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\x20'}, {0, 2, 3}}, {{'\xe0', '\xa4', '\x83', '\xd'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xd'}, {0, 2, 3}}, {{'\xe0', '\xa4', '\x83', '\xa'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xa'}, {0, 2, 3}}, {{'\xe0', '\xa4', '\x83', '\x1'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\x1'}, {0, 2, 3}}, {{'\xe0', '\xa4', '\x83', '\xcd', '\x8f'}, {0, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xe0', '\xa4', '\x83', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xe0', '\xa4', '\x83', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xe0', '\xa4', '\x83', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xe0', '\xa4', '\x83', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xe0', '\xa4', '\x83', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xe0', '\xa4', '\x83', '\xe1', '\x86', '\xa8'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xe0', '\xa4', '\x83', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xe0', '\xa4', '\x83', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xe0', '\xa4', '\x83', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x80'}, {0, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}},
    {{'\xe0', '\xa4', '\x83', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}},
    {{'\xe0', '\xa4', '\x83', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xe0', '\xa4', '\x83', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\x20'}, {0, 1, 2}}, {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\x20'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\xd'}, {0, 1, 2}}, {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xd'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\xa'}, {0, 1, 2}}, {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xa'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\x1'}, {0, 1, 2}}, {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\x1'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\xcd', '\x8f'}, {0, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xe1', '\x84', '\x80', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xe1', '\x84', '\x80', '\xe1', '\x84', '\x80'}, {0, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\xe1', '\x85', '\xa0'}, {0, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\xe1', '\x86', '\xa8'}, {0, 1, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\xea', '\xb0', '\x80'}, {0, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\xea', '\xb0', '\x81'}, {0, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x80'}, {0, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}},
    {{'\xe1', '\x84', '\x80', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}},
    {{'\xe1', '\x84', '\x80', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xe1', '\x84', '\x80', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\x20'}, {0, 1, 2}}, {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\x20'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\xd'}, {0, 1, 2}}, {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xd'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\xa'}, {0, 1, 2}}, {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xa'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\x1'}, {0, 1, 2}}, {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\x1'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\xcd', '\x8f'}, {0, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xe1', '\x85', '\xa0', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xe1', '\x85', '\xa0', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\xe1', '\x85', '\xa0'}, {0, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\xe1', '\x86', '\xa8'}, {0, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x80'}, {0, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}},
    {{'\xe1', '\x85', '\xa0', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}},
    {{'\xe1', '\x85', '\xa0', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xe1', '\x85', '\xa0', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\x20'}, {0, 1, 2}}, {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\x20'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\xd'}, {0, 1, 2}}, {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xd'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\xa'}, {0, 1, 2}}, {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xa'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\x1'}, {0, 1, 2}}, {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\x1'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\xcd', '\x8f'}, {0, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xe1', '\x86', '\xa8', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xe1', '\x86', '\xa8', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\xe1', '\x86', '\xa8'}, {0, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x80'}, {0, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}},
    {{'\xe1', '\x86', '\xa8', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}},
    {{'\xe1', '\x86', '\xa8', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xe1', '\x86', '\xa8', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\x20'}, {0, 1, 2}}, {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\x20'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\xd'}, {0, 1, 2}}, {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xd'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\xa'}, {0, 1, 2}}, {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xa'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\x1'}, {0, 1, 2}}, {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\x1'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\xcd', '\x8f'}, {0, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xea', '\xb0', '\x80', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xea', '\xb0', '\x80', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\xe1', '\x85', '\xa0'}, {0, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\xe1', '\x86', '\xa8'}, {0, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x80'}, {0, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}},
    {{'\xea', '\xb0', '\x80', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}},
    {{'\xea', '\xb0', '\x80', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x80', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\x20'}, {0, 1, 2}}, {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\x20'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\xd'}, {0, 1, 2}}, {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xd'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\xa'}, {0, 1, 2}}, {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xa'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\x1'}, {0, 1, 2}}, {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\x1'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\xcd', '\x8f'}, {0, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xea', '\xb0', '\x81', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xea', '\xb0', '\x81', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\xe1', '\x86', '\xa8'}, {0, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x80'}, {0, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}},
    {{'\xea', '\xb0', '\x81', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}},
    {{'\xea', '\xb0', '\x81', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xea', '\xb0', '\x81', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\x20'}, {0, 1, 2}}, {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\x20'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xd'}, {0, 1, 2}}, {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xd'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xa'}, {0, 1, 2}}, {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xa'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\x1'}, {0, 1, 2}}, {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\x1'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xcd', '\x8f'}, {0, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xe1', '\x86', '\xa8'}, {0, 1, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x80'}, {0, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}},
    {{'\xe2', '\x8c', '\x9a', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xe2', '\x8c', '\x9a', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}}, {{'\xcc', '\x80', '\x20'}, {0, 1, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\x20'}, {0, 2, 3}}, {{'\xcc', '\x80', '\xd'}, {0, 1, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xd'}, {0, 2, 3}}, {{'\xcc', '\x80', '\xa'}, {0, 1, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xa'}, {0, 2, 3}}, {{'\xcc', '\x80', '\x1'}, {0, 1, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\x1'}, {0, 2, 3}}, {{'\xcc', '\x80', '\xcd', '\x8f'}, {0, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xcc', '\x80', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xcc', '\x80', '\xd8', '\x80'}, {0, 1, 2}}, {{'\xcc', '\x80', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xcc', '\x80', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xcc', '\x80', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xcc', '\x80', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xcc', '\x80', '\xe1', '\x86', '\xa8'}, {0, 1, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xcc', '\x80', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xcc', '\x80', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xcc', '\x80', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}}, {{'\xcc', '\x80', '\xcc', '\x80'}, {0, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}}, {{'\xcc', '\x80', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}}, {{'\xcc', '\x80', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xcc', '\x80', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}}, {{'\xe2', '\x80', '\x8d', '\x20'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\x20'}, {0, 2, 3}}, {{'\xe2', '\x80', '\x8d', '\xd'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xd'}, {0, 2, 3}}, {{'\xe2', '\x80', '\x8d', '\xa'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xa'}, {0, 2, 3}}, {{'\xe2', '\x80', '\x8d', '\x1'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\x1'}, {0, 2, 3}}, {{'\xe2', '\x80', '\x8d', '\xcd', '\x8f'}, {0, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xe2', '\x80', '\x8d', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xe2', '\x80', '\x8d', '\xd8', '\x80'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xe2', '\x80', '\x8d', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xe2', '\x80', '\x8d', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xe2', '\x80', '\x8d', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xe2', '\x80', '\x8d', '\xe1', '\x86', '\xa8'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xe2', '\x80', '\x8d', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xe2', '\x80', '\x8d', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xe2', '\x80', '\x8d', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x80'}, {0, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}},
    {{'\xe2', '\x80', '\x8d', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}},
    {{'\xe2', '\x80', '\x8d', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xe2', '\x80', '\x8d', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}}, {{'\xcd', '\xb8', '\x20'}, {0, 1, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\x20'}, {0, 2, 3}}, {{'\xcd', '\xb8', '\xd'}, {0, 1, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xd'}, {0, 2, 3}}, {{'\xcd', '\xb8', '\xa'}, {0, 1, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xa'}, {0, 2, 3}}, {{'\xcd', '\xb8', '\x1'}, {0, 1, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\x1'}, {0, 2, 3}}, {{'\xcd', '\xb8', '\xcd', '\x8f'}, {0, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xcd', '\x8f'}, {0, 3}},
    {{'\xcd', '\xb8', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 1, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xf0', '\x9f', '\x87', '\xa6'}, {0, 2, 3}},
    {{'\xcd', '\xb8', '\xd8', '\x80'}, {0, 1, 2}}, {{'\xcd', '\xb8', '\xcc', '\x88', '\xd8', '\x80'}, {0, 2, 3}},
    {{'\xcd', '\xb8', '\xe0', '\xa4', '\x83'}, {0, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xe0', '\xa4', '\x83'}, {0, 3}},
    {{'\xcd', '\xb8', '\xe1', '\x84', '\x80'}, {0, 1, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xcd', '\xb8', '\xe1', '\x85', '\xa0'}, {0, 1, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xe1', '\x85', '\xa0'}, {0, 2, 3}},
    {{'\xcd', '\xb8', '\xe1', '\x86', '\xa8'}, {0, 1, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xe1', '\x86', '\xa8'}, {0, 2, 3}},
    {{'\xcd', '\xb8', '\xea', '\xb0', '\x80'}, {0, 1, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xea', '\xb0', '\x80'}, {0, 2, 3}},
    {{'\xcd', '\xb8', '\xea', '\xb0', '\x81'}, {0, 1, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xea', '\xb0', '\x81'}, {0, 2, 3}},
    {{'\xcd', '\xb8', '\xe2', '\x8c', '\x9a'}, {0, 1, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xe2', '\x8c', '\x9a'}, {0, 2, 3}}, {{'\xcd', '\xb8', '\xcc', '\x80'}, {0, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xcc', '\x80'}, {0, 3}}, {{'\xcd', '\xb8', '\xe2', '\x80', '\x8d'}, {0, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xe2', '\x80', '\x8d'}, {0, 3}}, {{'\xcd', '\xb8', '\xcd', '\xb8'}, {0, 1, 2}},
    {{'\xcd', '\xb8', '\xcc', '\x88', '\xcd', '\xb8'}, {0, 2, 3}},
    {{'\xd', '\xa', '\x61', '\xa', '\xcc', '\x88'}, {0, 2, 3, 4, 5}}, {{'\x61', '\xcc', '\x88'}, {0, 2}},
    {{'\x20', '\xe2', '\x80', '\x8d', '\xd9', '\x86'}, {0, 2, 3}},
    {{'\xd9', '\x86', '\xe2', '\x80', '\x8d', '\x20'}, {0, 2, 3}},
    {{'\xe1', '\x84', '\x80', '\xe1', '\x84', '\x80'}, {0, 2}},
    {{'\xea', '\xb0', '\x80', '\xe1', '\x86', '\xa8', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xea', '\xb0', '\x81', '\xe1', '\x86', '\xa8', '\xe1', '\x84', '\x80'}, {0, 2, 3}},
    {{'\xf0', '\x9f', '\x87', '\xa6', '\xf0', '\x9f', '\x87', '\xa7', '\xf0', '\x9f', '\x87', '\xa8', '\x62'},
        {0, 2, 3, 4}},
    {{'\x61', '\xf0', '\x9f', '\x87', '\xa6', '\xf0', '\x9f', '\x87', '\xa7', '\xf0', '\x9f', '\x87', '\xa8', '\x62'},
        {0, 1, 3, 4, 5}},
    {{'\x61', '\xf0', '\x9f', '\x87', '\xa6', '\xf0', '\x9f', '\x87', '\xa7', '\xe2', '\x80', '\x8d', '\xf0', '\x9f',
         '\x87', '\xa8', '\x62'},
        {0, 1, 4, 5, 6}},
    {{'\x61', '\xf0', '\x9f', '\x87', '\xa6', '\xe2', '\x80', '\x8d', '\xf0', '\x9f', '\x87', '\xa7', '\xf0', '\x9f',
         '\x87', '\xa8', '\x62'},
        {0, 1, 3, 5, 6}},
    {{'\x61', '\xf0', '\x9f', '\x87', '\xa6', '\xf0', '\x9f', '\x87', '\xa7', '\xf0', '\x9f', '\x87', '\xa8', '\xf0',
         '\x9f', '\x87', '\xa9', '\x62'},
        {0, 1, 3, 5, 6}},
    {{'\x61', '\xe2', '\x80', '\x8d'}, {0, 2}}, {{'\x61', '\xcc', '\x88', '\x62'}, {0, 2, 3}},
    {{'\x61', '\xe0', '\xa4', '\x83', '\x62'}, {0, 2, 3}}, {{'\x61', '\xd8', '\x80', '\x62'}, {0, 1, 3}},
    {{'\xf0', '\x9f', '\x91', '\xb6', '\xf0', '\x9f', '\x8f', '\xbf', '\xf0', '\x9f', '\x91', '\xb6'}, {0, 2, 3}},
    {{'\x61', '\xf0', '\x9f', '\x8f', '\xbf', '\xf0', '\x9f', '\x91', '\xb6'}, {0, 2, 3}},
    {{'\x61', '\xf0', '\x9f', '\x8f', '\xbf', '\xf0', '\x9f', '\x91', '\xb6', '\xe2', '\x80', '\x8d', '\xf0', '\x9f',
         '\x9b', '\x91'},
        {0, 2, 5}},
    {{'\xf0', '\x9f', '\x91', '\xb6', '\xf0', '\x9f', '\x8f', '\xbf', '\xcc', '\x88', '\xe2', '\x80', '\x8d', '\xf0',
         '\x9f', '\x91', '\xb6', '\xf0', '\x9f', '\x8f', '\xbf'},
        {0, 6}},
    {{'\xf0', '\x9f', '\x9b', '\x91', '\xe2', '\x80', '\x8d', '\xf0', '\x9f', '\x9b', '\x91'}, {0, 3}},
    {{'\x61', '\xe2', '\x80', '\x8d', '\xf0', '\x9f', '\x9b', '\x91'}, {0, 2, 3}},
    {{'\xe2', '\x9c', '\x81', '\xe2', '\x80', '\x8d', '\xe2', '\x9c', '\x81'}, {0, 3}},
    {{'\x61', '\xe2', '\x80', '\x8d', '\xe2', '\x9c', '\x81'}, {0, 2, 3}}};

// End of generated data - DO NOT EDIT manually!


void run_unicode_test_data_utf32() {
    for (const auto& test_case : test_data<char32_t>) {
        _Grapheme_break_property_iterator<char32_t> iter(
            test_case.code_points.data(), test_case.code_points.data() + test_case.code_points.size());
        size_t i = 0;
        while (iter != default_sentinel) {
            assert(i < test_case.breaks.size());
            assert(*iter == test_case.code_points[test_case.breaks[i]]);
            ++iter;
            ++i;
        }
    }
}

void run_unicode_test_data_utf32_utf8_comparison() {
    for (size_t i = 0; i < size(test_data<char>); ++i) {
        const auto& utf32_code_points = test_data<char32_t>[i].code_points;
        const auto& utf8_code_points  = test_data<char>[i].code_points;
        assert(ranges::equal(_Grapheme_break_property_iterator<char32_t>{utf32_code_points.data(),
                                 utf32_code_points.data() + utf32_code_points.size()},
            default_sentinel,
            _Grapheme_break_property_iterator<char>{
                utf8_code_points.data(), utf8_code_points.data() + utf8_code_points.size()},
            default_sentinel));
    }
}

constexpr bool test_unicode_properties() {
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0xB)
           == _Grapheme_Break_property_values::_Control_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0xC)
           == _Grapheme_Break_property_values::_Control_value);
    assert(
        _Grapheme_Break_property_data._Get_property_for_codepoint(0xA) == _Grapheme_Break_property_values::_LF_value);
    assert(
        _Grapheme_Break_property_data._Get_property_for_codepoint(0xD) == _Grapheme_Break_property_values::_CR_value);

    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0x7F)
           == _Grapheme_Break_property_values::_Control_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0x80)
           == _Grapheme_Break_property_values::_Control_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0x9F)
           == _Grapheme_Break_property_values::_Control_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0x300)
           == _Grapheme_Break_property_values::_Extend_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0x08D4)
           == _Grapheme_Break_property_values::_Extend_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0xE01EF)
           == _Grapheme_Break_property_values::_Extend_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0x1F1E6)
           == _Grapheme_Break_property_values::_Regional_Indicator_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0x1F1FF)
           == _Grapheme_Break_property_values::_Regional_Indicator_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0x0903)
           == _Grapheme_Break_property_values::_SpacingMark_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0x1934)
           == _Grapheme_Break_property_values::_SpacingMark_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0x1D16D)
           == _Grapheme_Break_property_values::_SpacingMark_value);
    assert(
        _Grapheme_Break_property_data._Get_property_for_codepoint(0x1100) == _Grapheme_Break_property_values::_L_value);
    assert(
        _Grapheme_Break_property_data._Get_property_for_codepoint(0xA97C) == _Grapheme_Break_property_values::_L_value);
    assert(
        _Grapheme_Break_property_data._Get_property_for_codepoint(0x1160) == _Grapheme_Break_property_values::_V_value);
    assert(
        _Grapheme_Break_property_data._Get_property_for_codepoint(0xD7C6) == _Grapheme_Break_property_values::_V_value);
    assert(
        _Grapheme_Break_property_data._Get_property_for_codepoint(0x11A8) == _Grapheme_Break_property_values::_T_value);
    assert(
        _Grapheme_Break_property_data._Get_property_for_codepoint(0xD7FB) == _Grapheme_Break_property_values::_T_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0xAC00)
           == _Grapheme_Break_property_values::_LV_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0xD788)
           == _Grapheme_Break_property_values::_LV_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0xAC01)
           == _Grapheme_Break_property_values::_LVT_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0xD7A3)
           == _Grapheme_Break_property_values::_LVT_value);
    assert(_Grapheme_Break_property_data._Get_property_for_codepoint(0x200D)
           == _Grapheme_Break_property_values::_ZWJ_value);
    assert(
        _Grapheme_Break_property_data._Get_property_for_codepoint(0x7E) == _Grapheme_Break_property_values::_No_value);
    assert(
        _Grapheme_Break_property_data._Get_property_for_codepoint(0xA0) == _Grapheme_Break_property_values::_No_value);


    // emoji-data
    assert(_Extended_Pictographic_property_data._Get_property_for_codepoint(0x2194)
           == _Extended_Pictographic_property_values::_Extended_Pictographic_value);

    // emoji_component, not extended_pictographic
    assert(_Extended_Pictographic_property_data._Get_property_for_codepoint(0x23)
           == _Extended_Pictographic_property_values::_No_value);
    return true;
}

template <typename CharT>
constexpr void test_utf_decode_spans(const span<const CharT> encoded, const span<const char32_t> decoded) {
    static_assert(is_same_v<CharT, char> || is_same_v<CharT, wchar_t>);
    assert(ranges::equal(_Unicode_codepoint_iterator{encoded.data(), encoded.data() + encoded.size()}, default_sentinel,
        decoded.begin(), decoded.end()));
}

template <typename CharT, size_t N_enc, size_t N_dec>
constexpr void test_utf_decode_arrays(const CharT (&encoded)[N_enc], const char32_t (&decoded)[N_dec]) {
    test_utf_decode_spans<CharT>(encoded, decoded);
}

constexpr bool test_utf8_decode() {
    test_utf_decode_arrays("\xC0\xAF\xE0\x80\xBF\xF0\x81\x82\x41",
        {0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0x41, 0x0});
    test_utf_decode_arrays("\xED\xA0\x80\xED\xBF\xBF\xED\xAF\x41",
        {0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0x41, 0x0});
    test_utf_decode_arrays("\xF4\x91\x92\x93\xFF\x41\x80\xBF\x42",
        {0xFFFd, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0x41, 0xFFFD, 0xFFFD, 0x42, 0x0});
    test_utf_decode_arrays("\xE1\x80\xE2\xF0\x91\x92\xF1\xBF\x41", {0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0x41, 0x0});
    test_utf_decode_arrays("\xCE\xA9", {0x03A9, 0x0});
    test_utf_decode_arrays("\x7F", {0x7F, 0x0});
    test_utf_decode_arrays("\xC2\xA2", {0xA2, 0x0});
    test_utf_decode_arrays("\xD4\x84", {0x0504, 0x0});
    test_utf_decode_arrays("\xDF\xA0", {0x7E0, 0x0});
    test_utf_decode_arrays("\xE0\xA4\x93", {0x0913, 0x0});
    test_utf_decode_arrays("\xE1\xBC\x80", {0x1F00, 0x0});
    test_utf_decode_arrays("\xEF\xA0\x93", {0xF813, 0x0});
    test_utf_decode_arrays("\xF3\xBA\xBE\x8F", {0xFAF8F, 0x0});
    test_utf_decode_arrays("\xFF\xBA", {0xFFFD, 0xFFFD, 0x0});
    test_utf_decode_arrays("\xEF", {0xFFFD, 0x0});
    test_utf_decode_arrays("\xE0\x91", {0xFFFD, 0xFFFD, 0x0});
    return true;
}

constexpr bool test_utf16_decode() {
    test_utf_decode_arrays<wchar_t>({0xD7FF, 0xD800}, {0xD7FF, 0xFFFD});
    test_utf_decode_arrays<wchar_t>({0xD800, 0xD7FF}, {0xFFFD, 0xD7FF});
    test_utf_decode_arrays<wchar_t>({0xD7FF, 0xDF02}, {0xD7FF, 0xFFFD});
    test_utf_decode_arrays<wchar_t>({0xDF02, 0xD7FF}, {0xFFFD, 0xD7FF});

    return true;
}

void test_unicode_decoding() {
    for (size_t i = 0; i < size(test_data<char>); ++i) {
        test_utf_decode_spans<char>(test_data<char>[i].code_points, test_data<char32_t>[i].code_points);
    }
}

int main() {
    run_unicode_test_data_utf32();
    run_unicode_test_data_utf32_utf8_comparison();

    test_unicode_properties();
    static_assert(test_unicode_properties());

    test_utf8_decode();
    static_assert(test_utf8_decode());

    test_utf16_decode();
    static_assert(test_utf16_decode());

    test_unicode_decoding();

    static_assert(forward_iterator<_Unicode_codepoint_iterator<char>>);
    static_assert(sentinel_for<default_sentinel_t, _Unicode_codepoint_iterator<char>>);
    static_assert(forward_iterator<_Grapheme_break_property_iterator<char>>);
    return 0;
}
