"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parse = void 0;
const wxml_1 = require("./wxml");
const script_1 = require("./script");
const global_1 = require("./global");
const utils_1 = require("./utils");
const vue_1 = require("./vue");
function parse(option) {
    global_1.resetGlobals();
    utils_1.setting.rootPath = option.rootPath;
    if (option.json) {
        const config = JSON.parse(option.json);
        const usingComponents = config.usingComponents;
        if (usingComponents) {
            for (const key in usingComponents) {
                if (usingComponents.hasOwnProperty(key)) {
                    global_1.THIRD_PARTY_COMPONENTS.add(key);
                }
            }
        }
    }
    if (option.framework === 'vue') {
        const result = vue_1.parseVue(option.path, option.wxml || '', option.script);
        return Object.assign(Object.assign({}, result), { errors: global_1.errors });
    }
    const { wxml, wxses, imports, refIds } = wxml_1.parseWXML(option.path, option.wxml);
    utils_1.setting.sourceCode = option.script;
    const ast = script_1.parseScript(option.script, wxml, wxses, refIds);
    return {
        ast,
        imports,
        errors: global_1.errors
    };
}
exports.parse = parse;
//# sourceMappingURL=index.js.map