export declare const EMPTY_OBJ: any;
export declare const EMPTY_ARR: never[];
export declare const noop: (..._: unknown[]) => void;
/**
 * Boxed value.
 *
 * @typeparam T Value type.
 */
export interface Box<T> {
    v: T;
}
/**
 * box creates a boxed value.
 *
 * @typeparam T Value type.
 * @param v Value.
 * @returns Boxed value.
 */
export declare const box: <T>(v: T) => {
    v: T;
};
/**
 * box creates a boxed value.
 *
 * @typeparam T Value type.
 * @param b Boxed value.
 * @returns Value.
 */
export declare const unbox: <T>(b: Box<T>) => T;
export declare function toDashed(s: string): string;
export declare function toCamelCase(s: string): string;
export declare function capitalize(s: string): string;
export declare const hasOwn: (val: object, key: string | symbol) => any;
/**
 * ensure takes a condition and throw a error if the condition fails,
 * like failure::ensure: https://docs.rs/failure/0.1.1/failure/macro.ensure.html
 * @param condition condition.
 * @param msg error message.
 */
export declare function ensure(condition: boolean, msg: string): asserts condition;
export declare function warn(condition: boolean, msg: string): void;
