"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Template = void 0;
const shared_1 = require("@tarojs/shared");
const util_1 = require("../../util");
class Template extends shared_1.UnRecursiveTemplate {
    constructor() {
        super(...arguments);
        this.supportXS = true;
        this.Adapter = {
            if: 'wx:if',
            else: 'wx:else',
            elseif: 'wx:elif',
            for: 'wx:for',
            forItem: 'wx:for-item',
            forIndex: 'wx:for-index',
            key: 'wx:key',
            xs: 'wxs',
            type: 'weapp'
        };
    }
    buildXsTemplate() {
        return '<wxs module="xs" src="./utils.wxs" />';
    }
    replacePropName(name, value, componentName) {
        if (value === 'eh') {
            const nameLowerCase = name.toLowerCase();
            if (nameLowerCase === 'bindlongtap' && componentName !== 'canvas')
                return 'bindlongpress';
            return nameLowerCase;
        }
        return name;
    }
}
exports.Template = Template;
exports.default = (ctx) => {
    ctx.registerPlatform({
        name: 'weapp',
        useConfigName: 'mini',
        fn({ config }) {
            return __awaiter(this, void 0, void 0, function* () {
                const { appPath, nodeModulesPath, outputPath } = ctx.paths;
                const { npm, emptyDirectory } = ctx.helper;
                emptyDirectory(outputPath);
                util_1.printDevelopmentTip('weapp');
                // 生成 project.config.json
                ctx.generateProjectConfig({
                    srcConfigName: 'project.config.json',
                    distConfigName: 'project.config.json'
                });
                // 准备 miniRunner 参数
                const miniRunnerOpts = Object.assign(Object.assign({}, config), { nodeModulesPath, buildAdapter: config.platform, isBuildPlugin: false, globalObject: 'wx', fileType: {
                        templ: '.wxml',
                        style: '.wxss',
                        config: '.json',
                        script: '.js',
                        xs: '.wxs'
                    }, isUseComponentBuildPage: true, template: new Template() });
                // build with webpack
                const miniRunner = yield npm.getNpmPkg('@tarojs/mini-runner', appPath);
                yield miniRunner(appPath, miniRunnerOpts);
            });
        }
    });
};
//# sourceMappingURL=weapp.js.map