"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Template = void 0;
const shared_1 = require("@tarojs/shared");
const util_1 = require("../../util");
class Template extends shared_1.RecursiveTemplate {
    constructor() {
        super(...arguments);
        this.exportExpr = 'export default';
        this.supportXS = true;
        this.Adapter = {
            if: 'a:if',
            else: 'a:else',
            elseif: 'a:elif',
            for: 'a:for',
            forItem: 'a:for-item',
            forIndex: 'a:for-index',
            key: 'a:key',
            xs: 'sjs',
            type: 'alipay'
        };
        this.modifyCompProps = (compName, target) => {
            if (compName === 'canvas') {
                return Object.assign(Object.assign({}, target), { width: '', height: '' });
            }
            return target;
        };
        this.modifyLoopBody = (child, nodeName) => {
            if (nodeName === 'picker-view') {
                return `<picker-view-column>
        <view a:for="{{item.cn}}" a:key="id">
          ${child}
        </view>
      </picker-view-column>`;
            }
            if (nodeName === 'swiper') {
                return `<swiper-item>
        <block a:for="{{item.cn}}" a:key="id">
          ${child}
        </block>
      </swiper-item>`;
            }
            return child;
        };
        this.modifyLoopContainer = (children, nodeName) => {
            if (nodeName === 'picker') {
                return `
  <view>${children}</view>
  `;
            }
            return children;
        };
        this.modifyTemplateResult = (res, nodeName) => {
            if (nodeName === 'picker-view-column' || nodeName === 'swiper-item')
                return '';
            return res;
        };
    }
    buildXsTemplate() {
        return '<import-sjs name="xs" from="./utils.sjs" />';
    }
    replacePropName(name, value, compName) {
        if (value === 'eh')
            return name.replace('bind', 'on');
        if (compName === 'map' && value === 'i.polygons') {
            name = 'polygon';
        }
        return name;
    }
    getEvents() {
        return {
            onTap: 'eh',
            onTouchMove: 'eh',
            onTouchEnd: 'eh',
            onTouchCancel: 'eh',
            onLongTap: 'eh'
        };
    }
    buildThirdPartyAttr(attrs) {
        return [...attrs].reduce((str, attr) => {
            if (attr.startsWith('@')) {
                return str + `on${shared_1.capitalize(attr.slice(1))}="eh" `;
            }
            else if (attr.startsWith('bind')) {
                return str + `${attr}="eh" `;
            }
            else if (attr.startsWith('on')) {
                return str + `${attr}="eh" `;
            }
            return str + `${attr}="{{ i.${shared_1.toCamelCase(attr)} }}" `;
        }, '');
    }
}
exports.Template = Template;
exports.default = (ctx) => {
    ctx.registerPlatform({
        name: 'alipay',
        useConfigName: 'mini',
        fn({ config }) {
            return __awaiter(this, void 0, void 0, function* () {
                const { appPath, nodeModulesPath, outputPath } = ctx.paths;
                const { npm, emptyDirectory } = ctx.helper;
                emptyDirectory(outputPath);
                util_1.printDevelopmentTip('alipay');
                // 准备 miniRunner 参数
                const miniRunnerOpts = Object.assign(Object.assign({}, config), { nodeModulesPath, buildAdapter: config.platform, isBuildPlugin: false, globalObject: 'my', fileType: {
                        templ: '.axml',
                        style: '.acss',
                        config: '.json',
                        script: '.js',
                        xs: '.sjs'
                    }, isUseComponentBuildPage: false, template: new Template() });
                ctx.modifyMiniConfigs(({ configMap }) => {
                    const replaceKeyMap = {
                        navigationBarTitleText: 'defaultTitle',
                        navigationBarBackgroundColor: 'titleBarColor',
                        enablePullDownRefresh: 'pullRefresh',
                        list: 'items',
                        text: 'name',
                        iconPath: 'icon',
                        selectedIconPath: 'activeIcon',
                        color: 'textColor'
                    };
                    Object.keys(configMap).forEach(key => {
                        const item = configMap[key];
                        if (item.content) {
                            util_1.recursiveReplaceObjectKeys(item.content, replaceKeyMap);
                        }
                    });
                });
                // build with webpack
                const miniRunner = yield npm.getNpmPkg('@tarojs/mini-runner', appPath);
                yield miniRunner(appPath, miniRunnerOpts);
            });
        }
    });
};
//# sourceMappingURL=alipay.js.map