"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const configValidator_1 = require("../../doctor/configValidator");
exports.default = (ctx) => {
    registerBuildHooks(ctx);
    ctx.registerCommand({
        name: 'build',
        optionsMap: {
            '--type [typeName]': 'Build type, weapp/swan/alipay/tt/h5/quickapp/rn/qq/jd',
            '--watch': 'Watch mode',
            '--page [pagePath]': 'Build one page',
            '--component [pagePath]': 'Build one component',
            '--env [env]': 'Env type',
            '--ui': 'Build Taro UI library',
            '--ui-index [uiIndexPath]': 'Index file for build Taro UI library',
            '--plugin [typeName]': 'Build Taro plugin project, weapp',
            '--port [port]': 'Specified port',
            '--release': 'Release quickapp'
        },
        fn(opts) {
            return __awaiter(this, void 0, void 0, function* () {
                const { platform, config } = opts;
                const { fs, chalk, PROJECT_CONFIG } = ctx.helper;
                const { outputPath, configPath } = ctx.paths;
                const { isWatch, envHasBeenSet } = ctx.runOpts;
                if (!configPath || !fs.existsSync(configPath)) {
                    console.log(chalk.red(`找不到项目配置文件${PROJECT_CONFIG}，请确定当前目录是 Taro 项目根目录!`));
                    process.exit(1);
                }
                const checkResult = yield checkConfig({
                    configPath,
                    projectConfig: ctx.initialConfig
                });
                if (checkResult.lines.length) {
                    const NOTE_VALID = chalk.yellow('[!] ');
                    const NOTE_INVALID = chalk.red('[✗] ');
                    const lineChalk = chalk.hex('#fff');
                    const errorChalk = chalk.hex('#f00');
                    console.log(errorChalk(`Taro 配置有误，请检查！ (${configPath})`));
                    checkResult.lines.forEach(line => {
                        console.log('  ' +
                            (line.valid ? NOTE_VALID : NOTE_INVALID) +
                            lineChalk(line.desc));
                    });
                }
                if (typeof platform !== 'string') {
                    console.log(chalk.red('请传入正确的编译类型！'));
                    process.exit(0);
                }
                process.env.TARO_ENV = platform;
                fs.ensureDirSync(outputPath);
                let isProduction = false;
                if (!envHasBeenSet) {
                    isProduction = process.env.NODE_ENV === 'production' || !isWatch;
                }
                yield ctx.applyPlugins('onBuildStart');
                yield ctx.applyPlugins({
                    name: platform,
                    opts: {
                        config: Object.assign(Object.assign({}, config), { isWatch, mode: isProduction ? 'production' : 'development', modifyWebpackChain(chain, webpack) {
                                return __awaiter(this, void 0, void 0, function* () {
                                    yield ctx.applyPlugins({
                                        name: 'modifyWebpackChain',
                                        initialVal: chain,
                                        opts: {
                                            chain,
                                            webpack
                                        }
                                    });
                                });
                            },
                            modifyBuildAssets(assets) {
                                return __awaiter(this, void 0, void 0, function* () {
                                    yield ctx.applyPlugins({
                                        name: 'modifyBuildAssets',
                                        initialVal: assets,
                                        opts: {
                                            assets
                                        }
                                    });
                                });
                            },
                            modifyMiniConfigs(configMap) {
                                return __awaiter(this, void 0, void 0, function* () {
                                    yield ctx.applyPlugins({
                                        name: 'modifyMiniConfigs',
                                        initialVal: configMap,
                                        opts: {
                                            configMap
                                        }
                                    });
                                });
                            },
                            onBuildFinish({ error, stats, isWatch }) {
                                return __awaiter(this, void 0, void 0, function* () {
                                    yield ctx.applyPlugins({
                                        name: 'onBuildFinish',
                                        opts: {
                                            error,
                                            stats,
                                            isWatch
                                        }
                                    });
                                });
                            } })
                    }
                });
            });
        }
    });
};
function registerBuildHooks(ctx) {
    [
        'modifyWebpackChain',
        'modifyBuildAssets',
        'modifyMiniConfigs',
        'onBuildStart',
        'onBuildFinish'
    ].forEach(methodName => {
        ctx.registerMethod(methodName);
    });
}
function checkConfig({ projectConfig, configPath }) {
    return __awaiter(this, void 0, void 0, function* () {
        const result = yield configValidator_1.default({
            configPath,
            projectConfig
        });
        return result;
    });
}
//# sourceMappingURL=build.js.map