function isString(o) {
    return typeof o === 'string';
}
function isUndefined(o) {
    return typeof o === 'undefined';
}
function isNull(o) {
    return o === null;
}
function isObject(o) {
    return o !== null && typeof o === 'object';
}
function isBoolean(o) {
    return o === true || o === false;
}
function isFunction(o) {
    return typeof o === 'function';
}
function isNumber(o) {
    return typeof o === 'number';
}
function isBooleanStringLiteral(o) {
    return o === 'true' || o === 'false';
}
const isArray = Array.isArray;

function selectEnv(options) {
    let option;
    if (process.env.TARO_ENV === 'alipay') {
        option = options.alipay;
    }
    else if (process.env.TARO_ENV === 'jd') {
        option = options.jd;
    }
    else if (process.env.TARO_ENV === 'qq') {
        option = options.qq;
    }
    else if (process.env.TARO_ENV === 'swan') {
        option = options.swan;
    }
    else if (process.env.TARO_ENV === 'tt') {
        option = options.tt;
    }
    else if (process.env.TARO_ENV === 'weapp') {
        option = options.weapp;
    }
    return option || options.default || Object.create(null);
}
const styles = {
    style: `i.${"st" /* Style */}`,
    class: `i.${"cl" /* Class */}`
};
const events = {
    bindtap: 'eh'
};
const touchEvents = {
    bindTouchStart: '',
    bindTouchMove: '',
    bindTouchEnd: '',
    bindTouchCancel: '',
    bindLongTap: ''
};
const specialEvents = new Set([
    'htouchmove',
    'vtouchmove'
]);
function singleQuote(s) {
    return `'${s}'`;
}
const View = Object.assign({ 'hover-class': singleQuote('none'), 'hover-stop-propagation': 'false', 'hover-start-time': '50', 'hover-stay-time': '400', animation: '', bindAnimationStart: '', bindAnimationIteration: '', bindAnimationEnd: '', bindTransitionEnd: '' }, touchEvents);
const Icon = {
    type: '',
    size: '23',
    color: ''
};
const Map$1 = Object.assign(Object.assign({ longitude: '', latitude: '', scale: '16', markers: '[]', covers: '', polyline: '[]', circles: '[]', controls: '', 'include-points': '[]', 'show-location': '', polygons: '', subkey: '', 'layer-style': '1', rotate: '0', skew: 'skew', 'enable-3D': 'false', 'show-compass': 'false', 'show-scale': 'false', 'enable-overlooking': 'false', 'enable-zoom': 'true', 'enable-scroll': 'true', 'enable-rotate': 'false', 'enable-satellite': 'false', 'enable-traffic': 'false', bindMarkerTap: '', bindLabelTap: '', bindControlTap: '', bindCalloutTap: '', bindUpdated: '', bindRegionChange: '', bindPoiTap: '' }, touchEvents), selectEnv({
    alipay: {
        setting: '{}'
    },
    default: {
        setting: '[]'
    }
}));
const Progress = {
    percent: '',
    'show-info': 'false',
    'border-radius': '0',
    'font-size': '16',
    'stroke-width': '6',
    color: singleQuote('#09BB07'),
    activeColor: singleQuote('#09BB07'),
    backgroundColor: singleQuote('#EBEBEB'),
    active: 'false',
    'active-mode': singleQuote('backwards'),
    duration: '30',
    bindActiveEnd: ''
};
const RichText = {
    nodes: '[]',
    space: ''
};
const Text = {
    selectable: 'false',
    space: '',
    decode: 'false'
};
const Button = Object.assign({ size: singleQuote('default'), type: '', plain: 'false', disabled: '', loading: 'false', 'form-type': '', 'open-type': '', 'hover-class': singleQuote('button-hover'), 'hover-stop-propagation': 'false', 'hover-start-time': '20', 'hover-stay-time': '70', lang: 'en', 'session-from': '', 'send-message-title': '', 'send-message-path': '', 'send-message-img': '', 'app-parameter': '', 'show-message-card': 'false', bindGetUserInfo: '', bindGetAuthorize: '', bindContact: '', bindGetPhoneNumber: '', bindError: '', bindOpenSetting: '', bindLaunchApp: '', scope: '', name: '' }, selectEnv({
    qq: {
        'app-packagename': '',
        'app-bundleid': '',
        'app-connect-id': ''
    }
}));
const Checkbox = {
    value: '',
    disabled: '',
    checked: 'false',
    color: singleQuote('#09BB07'),
    name: ''
};
const CheckboxGroup = {
    bindChange: '',
    name: ''
};
const Editor = {
    'read-only': 'false',
    placeholder: '',
    'show-img-size': 'false',
    'show-img-toolbar': 'false',
    'show-img-resize': 'false',
    focus: 'false',
    bindReady: '',
    bindFocus: '',
    bindBlur: '',
    bindInput: '',
    bindStatusChange: '',
    name: ''
};
const Form = {
    'report-submit': 'false',
    'report-submit-timeout': '0',
    bindSubmit: '',
    bindReset: '',
    name: ''
};
const Input = Object.assign({ value: '', type: singleQuote(''), password: 'false', placeholder: '', 'placeholder-style': '', 'placeholder-class': singleQuote('input-placeholder'), disabled: '', maxlength: '140', 'cursor-spacing': '0', 'auto-focus': 'false', focus: 'false', 'confirm-type': singleQuote('done'), 'confirm-hold': 'false', cursor: 'i.value.length', 'selection-start': '-1', 'selection-end': '-1', 'adjust-position': 'true', 'hold-keyboard': 'false', bindInput: '', bindFocus: '', bindBlur: '', bindConfirm: '', bindKeyboardHeightChange: '', name: '' }, selectEnv({
    alipay: {
        'random-number': 'false',
        controlled: 'false'
    },
    weapp: {
        'always-embed': 'false'
    }
}));
const Label = {
    for: '',
    name: ''
};
const Picker = {
    mode: singleQuote('selector'),
    disabled: '',
    bindCancel: '',
    range: '',
    'range-key': '',
    value: '',
    bindChange: '',
    bindColumnChange: '',
    start: '',
    end: '',
    fields: singleQuote('day'),
    'custom-item': '',
    name: ''
};
const PickerView = {
    value: '',
    'indicator-style': '',
    'indicator-class': '',
    'mask-style': '',
    'mask-class': '',
    bindChange: '',
    bindPickStart: '',
    bindPickEnd: '',
    name: ''
};
const PickerViewColumn = {
    name: ''
};
const Radio = {
    value: '',
    checked: 'false',
    disabled: '',
    color: singleQuote('#09BB07'),
    name: ''
};
const RadioGroup = {
    bindChange: '',
    name: ''
};
const Slider = {
    min: '0',
    max: '100',
    step: '1',
    disabled: '',
    value: '0',
    color: singleQuote('#e9e9e9'),
    'selected-color': singleQuote('#1aad19'),
    activeColor: singleQuote('#1aad19'),
    backgroundColor: singleQuote('#e9e9e9'),
    'block-size': '28',
    'block-color': singleQuote('#ffffff'),
    'show-value': 'false',
    bindChange: '',
    bindChanging: '',
    name: ''
};
const Switch = {
    checked: 'false',
    disabled: '',
    type: singleQuote('switch'),
    color: singleQuote('#04BE02'),
    bindChange: '',
    name: ''
};
const CoverImage = {
    src: '',
    bindLoad: 'eh',
    bindError: 'eh'
};
const Textarea = {
    value: '',
    placeholder: '',
    'placeholder-style': '',
    'placeholder-class': singleQuote('textarea-placeholder'),
    disabled: '',
    maxlength: '140',
    'auto-focus': 'false',
    focus: 'false',
    'auto-height': 'false',
    fixed: 'false',
    'cursor-spacing': '0',
    cursor: '-1',
    'show-confirm-bar': 'true',
    'selection-start': '-1',
    'selection-end': '-1',
    'adjust-position': 'true',
    'hold-keyboard': 'false',
    bindFocus: '',
    bindBlur: '',
    bindLineChange: '',
    bindInput: '',
    bindConfirm: '',
    bindKeyboardHeightChange: '',
    name: ''
};
const CoverView = Object.assign({ 'scroll-top': 'false' }, touchEvents);
const MatchMedia = {
    'min-width': '',
    'max-width': '',
    width: '',
    'min-height': '',
    'max-height': '',
    height: '',
    orientation: ''
};
const MovableArea = {
    'scale-area': 'false'
};
const MovableView = Object.assign({ direction: 'none', inertia: 'false', 'out-of-bounds': 'false', x: '', y: '', damping: '20', friction: '2', disabled: '', scale: 'false', 'scale-min': '0.5', 'scale-max': '10', 'scale-value': '1', animation: 'true', bindAnimationEnd: '', bindChange: '', bindScale: '', htouchmove: '', vtouchmove: '', width: singleQuote('10px'), height: singleQuote('10px') }, touchEvents);
const ScrollView = Object.assign({ 'scroll-x': 'false', 'scroll-y': 'false', 'upper-threshold': '50', 'lower-threshold': '50', 'scroll-top': '', 'scroll-left': '', 'scroll-into-view': '', 'scroll-with-animation': 'false', 'enable-back-to-top': 'false', 'enable-flex': 'false', 'scroll-anchoring': 'false', 'refresher-enabled': 'false', 'refresher-threshold': '45', 'refresher-default-style': singleQuote('black'), 'refresher-background': singleQuote('#FFF'), 'refresher-triggered': 'false', enhanced: 'false', bounces: 'true', 'show-scrollbar': 'true', 'paging-enabled': 'false', 'fast-deceleration': 'false', bindRefresherPulling: '', bindRefresherRefresh: '', bindRefresherRestore: '', bindRefresherAbort: '', bindScrollToUpper: '', bindScrollToLower: '', bindScroll: '', animation: '', bindTransitionEnd: '', bindAnimationStart: '', bindAnimationIteration: '', bindAnimationEnd: '', bindDragStart: '', bindDragging: '', bindDragEnd: '' }, touchEvents);
const Swiper = Object.assign(Object.assign({ 'indicator-dots': 'false', 'indicator-color': singleQuote('rgba(0, 0, 0, .3)'), 'indicator-active-color': singleQuote('#000000'), autoplay: 'false', current: '0', interval: '5000', duration: '500', circular: 'false', vertical: 'false', 'previous-margin': '\'0px\'', 'next-margin': '\'0px\'', 'snap-to-edge': 'false', 'display-multiple-items': '1', 'skip-hidden-item-layout': 'false', 'easing-function': singleQuote('default'), bindChange: '', bindTransition: '', bindAnimationFinish: '' }, touchEvents), selectEnv({
    alipay: {
        acceleration: 'false',
        'disable-touch': 'false'
    }
}));
const SwiperItem = {
    'item-id': ''
};
const FunctionalPageNavigator = {
    version: singleQuote('release'),
    name: '',
    args: '',
    bindSuccess: '',
    bindFail: '',
    bindCancel: ''
};
const Navigator = {
    target: singleQuote('self'),
    url: '',
    'open-type': singleQuote('navigate'),
    delta: '1',
    'app-id': '',
    path: '',
    'extra-data': '',
    version: singleQuote('version'),
    'hover-class': singleQuote('navigator-hover'),
    'hover-stop-propagation': 'false',
    'hover-start-time': '50',
    'hover-stay-time': '600',
    bindSuccess: '',
    bindFail: '',
    bindComplete: ''
};
const Audio = {
    id: '',
    src: '',
    loop: 'false',
    controls: 'false',
    poster: '',
    name: '',
    author: '',
    bindError: '',
    bindPlay: '',
    bindPause: '',
    bindTimeUpdate: '',
    bindEnded: ''
};
const Camera = {
    mode: singleQuote('normal'),
    'device-position': singleQuote('back'),
    flash: singleQuote('auto'),
    'frame-size': singleQuote('medium'),
    bindStop: '',
    bindError: '',
    bindInitDone: '',
    bindScanCode: ''
};
const Image = Object.assign({ src: '', mode: singleQuote('scaleToFill'), webp: 'false', 'lazy-load': 'false', 'show-menu-by-longpress': 'false', bindError: '', bindLoad: '' }, touchEvents);
const LivePlayer = {
    src: '',
    mode: singleQuote('live'),
    autoplay: 'false',
    muted: 'false',
    orientation: singleQuote('vertical'),
    'object-fit': singleQuote('contain'),
    'background-mute': 'false',
    'min-cache': '1',
    'max-cache': '3',
    'sound-mode': singleQuote('speaker'),
    'auto-pause-if-navigate': 'true',
    'auto-pause-if-open-native': 'true',
    'picture-in-picture-mode': '[]',
    animation: '',
    bindStateChange: '',
    bindFullScreenChange: '',
    bindNetStatus: '',
    bindAudioVolumeNotify: '',
    bindEnterPictureInPicture: '',
    bindLeavePictureInPicture: ''
};
const LivePusher = {
    url: '',
    mode: singleQuote('RTC'),
    autopush: 'false',
    muted: 'false',
    'enable-camera': 'true',
    'auto-focus': 'true',
    orientation: singleQuote('vertical'),
    beauty: '0',
    whiteness: '0',
    aspect: singleQuote('9:16'),
    'min-bitrate': '200',
    'max-bitrate': '1000',
    'audio-quality': singleQuote('high'),
    'waiting-image': '',
    'waiting-image-hash': '',
    zoom: 'false',
    'device-position': singleQuote('front'),
    'background-mute': 'false',
    mirror: 'false',
    'remote-mirror': 'false',
    'local-mirror': 'false',
    'audio-reverb-type': '0',
    'enable-mic': 'true',
    'enable-agc': 'false',
    'enable-ans': 'false',
    'audio-volume-type': singleQuote('voicecall'),
    'video-width': '360',
    'video-height': '640',
    animation: '',
    bindStateChange: '',
    bindNetStatus: '',
    bindBgmStart: '',
    bindBgmProgress: '',
    bindBgmComplete: ''
};
const Video = {
    src: '',
    duration: '',
    controls: 'true',
    'danmu-list': '',
    'danmu-btn': '',
    'enable-danmu': '',
    autoplay: 'false',
    loop: 'false',
    muted: 'false',
    'initial-time': '0',
    'page-gesture': 'false',
    direction: '',
    'show-progress': 'true',
    'show-fullscreen-btn': 'true',
    'show-play-btn': 'true',
    'show-center-play-btn': 'true',
    'enable-progress-gesture': 'true',
    'object-fit': singleQuote('contain'),
    poster: '',
    'show-mute-btn': 'false',
    title: '',
    'play-btn-position': singleQuote('bottom'),
    'enable-play-gesture': 'false',
    'auto-pause-if-navigate': 'true',
    'auto-pause-if-open-native': 'true',
    'vslide-gesture': 'false',
    'vslide-gesture-in-fullscreen': 'true',
    'ad-unit-id': '',
    'poster-for-crawler': '',
    'show-casting-button': 'false',
    'picture-in-picture-mode': '[]',
    // picture-in-picture-show-progress 属性先注释掉的原因如下：
    // 该属性超过了 wxml 属性的长度限制，实际无法使用且导致编译报错。可等微信官方修复后再放开。
    // 参考1：https://developers.weixin.qq.com/community/develop/doc/000a429beb87f0eac07acc0fc5b400
    // 参考2: https://developers.weixin.qq.com/community/develop/doc/0006883619c48054286a4308258c00?_at=vyxqpllafi
    // 'picture-in-picture-show-progress': 'false',
    'enable-auto-rotation': 'false',
    'show-screen-lock-button': 'false',
    animation: '',
    bindPlay: '',
    bindPause: '',
    bindEnded: '',
    bindTimeUpdate: '',
    bindFullScreenChange: '',
    bindWaiting: '',
    bindError: '',
    bindProgress: '',
    bindLoadedMetadata: '',
    bindControlsToggle: '',
    bindEnterPictureInPicture: '',
    bindLeavePictureInPicture: '',
    bindSeekComplete: ''
};
const Canvas = {
    type: '',
    'canvas-id': '',
    'disable-scroll': 'false',
    bindTouchStart: '',
    bindTouchMove: '',
    bindTouchEnd: '',
    bindTouchCancel: '',
    bindLongtap: '',
    bindError: ''
};
const Ad = {
    'unit-id': '',
    'ad-intervals': '',
    'ad-type': singleQuote('banner'),
    'ad-theme': singleQuote('white'),
    bindLoad: '',
    bindError: '',
    bindClose: ''
};
const OfficialAccount = {
    bindLoad: '',
    bindError: ''
};
const OpenData = {
    type: '',
    'open-gid': '',
    lang: singleQuote('en'),
    'default-text': '',
    'default-avatar': '',
    bindError: ''
};
const WebView = {
    src: '',
    bindMessage: '',
    bindLoad: ''
};
const NavigationBar = {
    title: '',
    loading: 'false',
    'front-color': '',
    'background-color': '',
    'color-animation-duration': '0',
    'color-animation-timing-func': singleQuote('linear')
};
const PageMeta = {
    'background-text-style': '',
    'background-color': '',
    'background-color-top': '',
    'background-color-bottom': '',
    'scroll-top': singleQuote(''),
    'scroll-duration': '300',
    'page-style': singleQuote(''),
    'root-font-size': singleQuote(''),
    bindResize: '',
    bindScroll: '',
    bindScrollDone: ''
};
const Block = {};
// For Vue，因为 slot 标签被 vue 占用了
const SlotView = {
    name: ''
};
// For React
// Slot 和 SlotView 最终都会编译成 <view slot={{ i.name }} />
// 因为 <slot name="{{ i.name }}" /> 适用性没有前者高（无法添加类和样式）
// 不给 View 直接加 slot 属性的原因是性能损耗
const Slot = {
    name: ''
};
const internalComponents = {
    View,
    Icon,
    Progress,
    RichText,
    Text,
    Button,
    Checkbox,
    CheckboxGroup,
    Editor,
    Form,
    Input,
    Label,
    Picker,
    PickerView,
    PickerViewColumn,
    Radio,
    RadioGroup,
    Slider,
    Switch,
    CoverImage,
    Textarea,
    CoverView,
    MatchMedia,
    MovableArea,
    MovableView,
    ScrollView,
    Swiper,
    SwiperItem,
    FunctionalPageNavigator,
    Navigator,
    Audio,
    Camera,
    Image,
    LivePlayer,
    LivePusher,
    Video,
    Canvas,
    Ad,
    OfficialAccount,
    OpenData,
    WebView,
    NavigationBar,
    PageMeta,
    Block,
    Map: Map$1,
    Slot,
    SlotView
};
const controlledComponent = new Set([
    'input',
    'checkbox',
    'picker',
    'picker-view',
    'radio',
    'slider',
    'switch',
    'textarea'
]);
const focusComponents = new Set([
    'input',
    'textarea',
    'editor'
]);

const EMPTY_OBJ = {};
const EMPTY_ARR = [];
const noop = (..._) => { };
/**
 * box creates a boxed value.
 *
 * @typeparam T Value type.
 * @param v Value.
 * @returns Boxed value.
 */
const box = (v) => ({ v });
/**
 * box creates a boxed value.
 *
 * @typeparam T Value type.
 * @param b Boxed value.
 * @returns Value.
 */
const unbox = (b) => b.v;
function toDashed(s) {
    return s.replace(/([a-z0-9])([A-Z])/g, '$1-$2').toLowerCase();
}
function toCamelCase(s) {
    let camel = '';
    let nextCap = false;
    for (let i = 0; i < s.length; i++) {
        if (s[i] !== '-') {
            camel += nextCap ? s[i].toUpperCase() : s[i];
            nextCap = false;
        }
        else {
            nextCap = true;
        }
    }
    return camel;
}
function capitalize(s) {
    return s.charAt(0).toUpperCase() + s.slice(1);
}
const hasOwnProperty = Object.prototype.hasOwnProperty;
const hasOwn = (val, key) => hasOwnProperty.call(val, key);
const reportIssue = '如有疑问，请提交 issue 至：https://github.com/nervjs/taro/issues';
/**
 * ensure takes a condition and throw a error if the condition fails,
 * like failure::ensure: https://docs.rs/failure/0.1.1/failure/macro.ensure.html
 * @param condition condition.
 * @param msg error message.
 */
function ensure(condition, msg) {
    if (!condition) {
        throw new Error(msg + '\n' + reportIssue);
    }
}
function warn(condition, msg) {
    if (process.env.NODE_ENV !== 'production') {
        if (condition) {
            console.warn(msg);
        }
    }
}

/**
 * 这里我们需要关心的小程序种类有两类：
 * 1. 模板递归：
 *  - 支持：tmpl0 套 tmpl0
 *  - 不支持：这就使得我们必须生成多级的模板，tmpl0 套 tmpl1，tmpl1 套 tmpl2……
 *           直到超过阈值 N (N = config.miniapp.baseLevel) tmplN 会套组件 comp，组件 comp 重新再套 tmpl0。
 * 2. 小程序脚本语言（wxs, sjs, etc...）：
 *  - 支持：可以在模板使用函数缩减模板大小或提高性能（存疑），例如判断一个值是不是假值（falsy value）。
 *         将来或许会把数据序列化^1 的操作也放到小程序脚本语言里。
 *  - 不支持：使用纯 *xml 语法
 *
 * ^1: packages/taro-runtime/src/hydrate.ts
*/
const voidElements = new Set([
    'progress',
    'icon',
    'rich-text',
    'input',
    'textarea',
    'slider',
    'switch',
    'audio',
    'live-pusher',
    'video',
    'ad',
    'official-account',
    'open-data',
    'navigation-bar'
]);
const nestElements = new Map([
    ['view', -1],
    ['cover-view', -1],
    ['block', -1],
    ['text', -1],
    ['slot', 8],
    ['slot-view', 8],
    ['label', 6],
    ['form', 4],
    ['scroll-view', 4]
]);
const weixinAdapter = {
    if: 'wx:if',
    else: 'wx:else',
    elseif: 'wx:elif',
    for: 'wx:for',
    forItem: 'wx:for-item',
    forIndex: 'wx:for-index',
    key: 'wx:key',
    xs: 'wxs',
    type: 'weapp'
};
class BaseTemplate {
    constructor() {
        this.exportExpr = 'module.exports =';
        this.supportXS = false;
        this.Adapter = weixinAdapter;
        this.buildPageTemplate = (baseTempPath) => {
            const template = `<import src="${baseTempPath}"/>
  <template is="taro_tmpl" data="{{${this.dataKeymap('root:root')}}}" />`;
            return template;
        };
        this.buildBaseComponentTemplate = (ext) => {
            const data = !this.isSupportRecursive && this.supportXS
                ? this.dataKeymap('i:i,l:l')
                : this.dataKeymap('i:i');
            return `<import src="./base${ext}" />
  <template is="tmpl_0_${"container" /* Container */}" data="{{${data}}}" />`;
        };
        this.buildXScript = () => {
            return `${this.exportExpr} {
  a: ${this.buildXSTmplName()},
  b: function (a, b) {
    return a === undefined ? b : a
  },
  c: function(i, prefix) {
    var s = i.focus !== undefined ? 'focus' : 'blur'
    return prefix + i.${"nn" /* NodeName */} + '_' + s
  },
  d: function (i, v) {
    return i === undefined ? v : i
  },
  e: function (n) {
    return 'tmpl_' + n + '_${"container" /* Container */}'
  },
  ${this.buildXSTmpExtra()}
}`;
        };
    }
    buildAttribute(attrs, nodeName) {
        return Object.keys(attrs)
            .map(k => `${k}="${k.startsWith('bind') || k.startsWith('on') ? attrs[k] : `{${this.getAttrValue(attrs[k], k, nodeName)}}`}" `)
            .join('');
    }
    replacePropName(name, value, _componentName) {
        if (value === 'eh')
            return name.toLowerCase();
        return name;
    }
    createMiniComponents(components) {
        const result = Object.create(null);
        for (const key in components) {
            if (hasOwn(components, key)) {
                let component = components[key];
                const compName = toDashed(key);
                const newComp = Object.create(null);
                if (isFunction(this.modifyCompProps)) {
                    component = this.modifyCompProps(compName, component);
                }
                for (let prop in component) {
                    if (hasOwn(component, prop)) {
                        let propValue = component[prop];
                        if (prop.startsWith('bind') || specialEvents.has(prop)) {
                            propValue = 'eh';
                        }
                        else if (propValue === '') {
                            propValue = `i.${toCamelCase(prop)}`;
                        }
                        else if (isBooleanStringLiteral(propValue) || isNumber(+propValue)) {
                            propValue = this.supportXS
                                ? `xs.b(i.${toCamelCase(prop)},${propValue})`
                                : `i.${toCamelCase(prop)}===undefined?${propValue}:i.${toCamelCase(prop)}`;
                        }
                        else {
                            propValue = `i.${toCamelCase(prop)}||${propValue || singleQuote('')}`;
                        }
                        prop = this.replacePropName(prop, propValue, compName);
                        newComp[prop] = propValue;
                    }
                }
                if (compName !== 'block') {
                    Object.assign(newComp, styles, this.getEvents());
                }
                if (compName === 'swiper-item') {
                    delete newComp.style;
                }
                if (compName === 'slot' || compName === 'slot-view') {
                    result[compName] = {
                        slot: 'i.name'
                    };
                }
                else {
                    result[compName] = newComp;
                }
            }
        }
        return result;
    }
    buildBaseTemplate() {
        const Adapter = this.Adapter;
        const data = !this.isSupportRecursive && this.supportXS
            ? `${this.dataKeymap('i:item,l:\'\'')}`
            : this.dataKeymap('i:item');
        return `${this.buildXsTemplate()}
<template name="taro_tmpl">
  <block ${Adapter.for}="{{root.cn}}" ${Adapter.key}="uid">
    <template is="tmpl_0_${"container" /* Container */}" data="{{${data}}}" />
  </block>
</template>
`;
    }
    buildThirdPartyAttr(attrs) {
        return Array.from(attrs).reduce((str, attr) => {
            if (attr.startsWith('@')) { // vue event
                return str + `bind${attr.slice(1)}="eh" `;
            }
            else if (attr.startsWith('bind')) {
                return str + `${attr}="eh" `;
            }
            else if (attr.startsWith('on')) {
                return str + `bind${attr.slice(2).toLowerCase()}="eh" `;
            }
            return str + `${attr}="{{i.${toCamelCase(attr)}}}" `;
        }, '');
    }
    buildComponentTemplate(comp, level) {
        return focusComponents.has(comp.nodeName)
            ? this.buildFocusComponentTemplte(comp, level)
            : this.buildStandardComponentTemplate(comp, level);
    }
    buildFocusComponentTemplte(comp, level) {
        const attrs = Object.assign({}, comp.attributes);
        const templateName = this.supportXS
            ? `xs.c(i, 'tmpl_${level}_')`
            : `i.focus ? 'tmpl_${level}_${comp.nodeName}_focus' : 'tmpl_${level}_${comp.nodeName}_blur'`;
        delete attrs.focus;
        return `
<template name="tmpl_${level}_${comp.nodeName}">
  <template is="{{${templateName}}}" data="{{${this.dataKeymap('i:i')}}}" />
</template>

<template name="tmpl_${level}_${comp.nodeName}_focus">
  <${comp.nodeName} ${this.buildAttribute(comp.attributes, comp.nodeName)} id="{{i.uid}}" />
</template>

<template name="tmpl_${level}_${comp.nodeName}_blur">
  <${comp.nodeName} ${this.buildAttribute(attrs, comp.nodeName)} id="{{i.uid}}" />
</template>
`;
    }
    buildStandardComponentTemplate(comp, level) {
        const { isSupportRecursive, Adapter } = this;
        const nextLevel = isSupportRecursive ? 0 : level + 1;
        const data = !this.isSupportRecursive
            ? `${this.dataKeymap('i:item,l:l')}`
            : this.dataKeymap('i:item');
        let child = this.supportXS
            ? `<template is="{{xs.e(${isSupportRecursive ? 0 : 'cid+1'})}}" data="{{${data}}}" />`
            : `<template is="tmpl_${nextLevel}_${"container" /* Container */}" data="{{${this.dataKeymap('i:item')}}}" />`;
        if (isFunction(this.modifyLoopBody)) {
            child = this.modifyLoopBody(child, comp.nodeName);
        }
        let children = voidElements.has(comp.nodeName)
            ? ''
            : `
    <block ${Adapter.for}="{{i.${"cn" /* Childnodes */}}}" ${Adapter.key}="uid">
      ${child}
    </block>
  `;
        if (isFunction(this.modifyLoopContainer)) {
            children = this.modifyLoopContainer(children, comp.nodeName);
        }
        const nodeName = comp.nodeName === 'slot' || comp.nodeName === 'slot-view' ? 'view' : comp.nodeName;
        let res = `
<template name="tmpl_${level}_${comp.nodeName}">
  <${nodeName} ${this.buildAttribute(comp.attributes, comp.nodeName)} id="{{i.uid}}">${children}</${nodeName}>
</template>
`;
        if (isFunction(this.modifyTemplateResult)) {
            res = this.modifyTemplateResult(res, comp.nodeName, level, children);
        }
        return res;
    }
    buildPlainTextTemplate(level) {
        return `
<template name="tmpl_${level}_#text" data="{{${this.dataKeymap('i:i')}}}">
  <block>{{i.${"v" /* Text */}}}</block>
</template>
`;
    }
    buildThirdPartyTemplate(level, componentConfig) {
        const { Adapter, isSupportRecursive } = this;
        const nextLevel = isSupportRecursive ? 0 : level + 1;
        let template = '';
        const data = !this.isSupportRecursive && this.supportXS
            ? `${this.dataKeymap('i:item,l:l')}`
            : this.dataKeymap('i:item');
        componentConfig.thirdPartyComponents.forEach((attrs, compName) => {
            template += `
<template name="tmpl_${level}_${compName}">
  <${compName} ${this.buildThirdPartyAttr(attrs)} id="{{i.uid}}">
    <block ${Adapter.for}="{{i.${"cn" /* Childnodes */}}}" ${Adapter.key}="uid">
      <template is="tmpl_${nextLevel}_${"container" /* Container */}" data="{{${data}}}" />
    </block>
  </${compName}>
</template>
  `;
        });
        return template;
    }
    buildContainerTemplate(level, restart = false) {
        let tmpl = '';
        if (restart) {
            if (!this.isSupportRecursive && this.supportXS) {
                tmpl = '<comp i="{{i}}" l="{{l}}" />';
            }
            else {
                tmpl = '<comp i="{{i}}" />';
            }
        }
        else {
            const xs = !this.isSupportRecursive
                ? `xs.a(${level}, i.${"nn" /* NodeName */}, l)`
                : `xs.a(${level}, i.${"nn" /* NodeName */})`;
            const data = !this.isSupportRecursive
                ? `${this.dataKeymap(`i:i,cid:${level},l:xs.f(l,i.${"nn" /* NodeName */})`)}`
                : `${this.dataKeymap('i:i')}`;
            tmpl = this.supportXS
                ? `<template is="{{${xs}}}" data="{{${data}}}" />`
                : `<template is="{{'tmpl_${level}_' + i.${"nn" /* NodeName */}}}" data="{{${this.dataKeymap('i:i')}}}" />`;
        }
        return `
<template name="tmpl_${level}_${"container" /* Container */}">
  ${tmpl}
</template>
`;
    }
    dataKeymap(keymap) {
        return keymap;
    }
    getEvents() {
        return events;
    }
    getAttrValue(value, _key, _nodeName) {
        return `{${value}}`;
    }
    buildXsTemplate() {
        return '';
    }
    buildXSTmplName() {
        return `function (l, n) {
    return 'tmpl_' + l + '_' + n
  }`;
    }
    buildXSTmpExtra() {
        return '';
    }
}
class RecursiveTemplate extends BaseTemplate {
    constructor() {
        super(...arguments);
        this.isSupportRecursive = true;
        this.buildTemplate = (componentConfig) => {
            let template = this.buildBaseTemplate();
            if (!this.miniComponents) {
                this.miniComponents = this.createMiniComponents(internalComponents);
            }
            const ZERO_FLOOR = 0;
            const components = Object.keys(this.miniComponents)
                .filter(c => componentConfig.includes.size && !componentConfig.includeAll ? componentConfig.includes.has(c) : true);
            template = components.reduce((current, nodeName) => {
                const attributes = this.miniComponents[nodeName];
                return current + this.buildComponentTemplate({ nodeName, attributes }, ZERO_FLOOR);
            }, template);
            template += this.buildPlainTextTemplate(ZERO_FLOOR);
            template += this.buildThirdPartyTemplate(ZERO_FLOOR, componentConfig);
            template += this.buildContainerTemplate(ZERO_FLOOR);
            return template;
        };
    }
}
class UnRecursiveTemplate extends BaseTemplate {
    constructor() {
        super(...arguments);
        this.isSupportRecursive = false;
        this._baseLevel = 16;
        this.buildTemplate = (componentConfig) => {
            this.componentConfig = componentConfig;
            if (!this.miniComponents) {
                this.miniComponents = this.createMiniComponents(internalComponents);
            }
            const components = Object.keys(this.miniComponents)
                .filter(c => componentConfig.includes.size && !componentConfig.includeAll ? componentConfig.includes.has(c) : true);
            let template = this.buildBaseTemplate();
            for (let i = 0; i < this.baseLevel; i++) {
                template += this.supportXS
                    ? this.buildOptimizeFloor(i, components, this.baseLevel === i + 1)
                    : this.buildFloor(i, components, this.baseLevel === i + 1);
            }
            return template;
        };
    }
    set baseLevel(lv) {
        this._baseLevel = lv;
    }
    get baseLevel() {
        return this._baseLevel;
    }
    buildFloor(level, components, restart = false) {
        if (restart)
            return this.buildContainerTemplate(level, restart);
        let template = components.reduce((current, nodeName) => {
            const attributes = this.miniComponents[nodeName];
            return current + this.buildComponentTemplate({ nodeName, attributes }, level);
        }, '');
        template += this.buildPlainTextTemplate(level);
        template += this.buildThirdPartyTemplate(level, this.componentConfig);
        template += this.buildContainerTemplate(level, restart);
        return template;
    }
    buildOptimizeFloor(level, components, restart = false) {
        if (restart)
            return this.buildContainerTemplate(level, restart);
        let template = components.reduce((current, nodeName) => {
            if (level !== 0) {
                if (!nestElements.has(nodeName)) {
                    // 不可嵌套自身的组件只需输出一层模板
                    return current;
                }
                else {
                    // 部分可嵌套自身的组件实际上不会嵌套过深，这里按阈值限制层数
                    const max = nestElements.get(nodeName);
                    if (max > 0 && level >= max) {
                        return current;
                    }
                }
            }
            const attributes = this.miniComponents[nodeName];
            return current + this.buildComponentTemplate({ nodeName, attributes }, level);
        }, '');
        if (level === 0)
            template += this.buildPlainTextTemplate(level);
        template += this.buildThirdPartyTemplate(level, this.componentConfig);
        template += this.buildContainerTemplate(level);
        return template;
    }
    buildXSTmplName() {
        const comps = [
            ...Array.from(nestElements.keys()),
            ...Array.from(this.componentConfig.thirdPartyComponents.keys())
        ];
        const hasMaxComps = [];
        nestElements.forEach((max, comp) => {
            if (max > -1)
                hasMaxComps.push(comp);
        });
        return `function (l, n, s) {
    var a = ${JSON.stringify(comps)}
    var b = ${JSON.stringify(hasMaxComps)}
    if (a.indexOf(n) === -1) {
      l = 0
    }
    if (b.indexOf(n) > -1) {
      var u = s.split(',')
      var depth = 0
      for (var i = 0; i < u.length; i++) {
        if (u[i] === n) depth++
      }
      l = depth
    }
    return 'tmpl_' + l + '_' + n
  }`;
    }
    buildXSTmpExtra() {
        const hasMaxComps = [];
        nestElements.forEach((max, comp) => {
            if (max > -1)
                hasMaxComps.push(comp);
        });
        return `f: function (l, n) {
    var b = ${JSON.stringify(hasMaxComps)}
    if (b.indexOf(n) > -1) {
      if (l) l += ','
      l += n
    }
    return l
  }`;
    }
}

export { BaseTemplate, EMPTY_ARR, EMPTY_OBJ, RecursiveTemplate, UnRecursiveTemplate, box, capitalize, controlledComponent, ensure, events, focusComponents, hasOwn, internalComponents, isArray, isBoolean, isBooleanStringLiteral, isFunction, isNull, isNumber, isObject, isString, isUndefined, noop, singleQuote, specialEvents, styles, toCamelCase, toDashed, unbox, warn };
//# sourceMappingURL=shared.esm.js.map
