'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function isString(o) {
    return typeof o === 'string';
}
function isUndefined(o) {
    return typeof o === 'undefined';
}
function isNull(o) {
    return o === null;
}
function isObject(o) {
    return o !== null && typeof o === 'object';
}
function isBoolean(o) {
    return o === true || o === false;
}
function isFunction(o) {
    return typeof o === 'function';
}
function isNumber(o) {
    return typeof o === 'number';
}
function isBooleanStringLiteral(o) {
    return o === 'true' || o === 'false';
}
var isArray = Array.isArray;

// 字符串简写
(function (Shortcuts) {
    Shortcuts["Container"] = "container";
    Shortcuts["Childnodes"] = "cn";
    Shortcuts["Text"] = "v";
    Shortcuts["NodeType"] = "nt";
    Shortcuts["NodeName"] = "nn";
    // Attrtibutes
    Shortcuts["Style"] = "st";
    Shortcuts["Class"] = "cl";
    Shortcuts["Src"] = "src";
})(exports.Shortcuts || (exports.Shortcuts = {}));

function selectEnv(options) {
    var option;
    if (process.env.TARO_ENV === 'alipay') {
        option = options.alipay;
    }
    else if (process.env.TARO_ENV === 'jd') {
        option = options.jd;
    }
    else if (process.env.TARO_ENV === 'qq') {
        option = options.qq;
    }
    else if (process.env.TARO_ENV === 'swan') {
        option = options.swan;
    }
    else if (process.env.TARO_ENV === 'tt') {
        option = options.tt;
    }
    else if (process.env.TARO_ENV === 'weapp') {
        option = options.weapp;
    }
    return option || options.default || Object.create(null);
}
var styles = {
    style: ("i." + ("st")),
    class: ("i." + ("cl"))
};
var events = {
    bindtap: 'eh'
};
var touchEvents = {
    bindTouchStart: '',
    bindTouchMove: '',
    bindTouchEnd: '',
    bindTouchCancel: '',
    bindLongTap: ''
};
var specialEvents = new Set([
    'htouchmove',
    'vtouchmove'
]);
function singleQuote(s) {
    return ("'" + s + "'");
}
var View = Object.assign({ 'hover-class': singleQuote('none'), 'hover-stop-propagation': 'false', 'hover-start-time': '50', 'hover-stay-time': '400', animation: '', bindAnimationStart: '', bindAnimationIteration: '', bindAnimationEnd: '', bindTransitionEnd: '' }, touchEvents);
var Icon = {
    type: '',
    size: '23',
    color: ''
};
var Map$1 = Object.assign(Object.assign({ longitude: '', latitude: '', scale: '16', markers: '[]', covers: '', polyline: '[]', circles: '[]', controls: '', 'include-points': '[]', 'show-location': '', polygons: '', subkey: '', 'layer-style': '1', rotate: '0', skew: 'skew', 'enable-3D': 'false', 'show-compass': 'false', 'show-scale': 'false', 'enable-overlooking': 'false', 'enable-zoom': 'true', 'enable-scroll': 'true', 'enable-rotate': 'false', 'enable-satellite': 'false', 'enable-traffic': 'false', bindMarkerTap: '', bindLabelTap: '', bindControlTap: '', bindCalloutTap: '', bindUpdated: '', bindRegionChange: '', bindPoiTap: '' }, touchEvents), selectEnv({
    alipay: {
        setting: '{}'
    },
    default: {
        setting: '[]'
    }
}));
var Progress = {
    percent: '',
    'show-info': 'false',
    'border-radius': '0',
    'font-size': '16',
    'stroke-width': '6',
    color: singleQuote('#09BB07'),
    activeColor: singleQuote('#09BB07'),
    backgroundColor: singleQuote('#EBEBEB'),
    active: 'false',
    'active-mode': singleQuote('backwards'),
    duration: '30',
    bindActiveEnd: ''
};
var RichText = {
    nodes: '[]',
    space: ''
};
var Text = {
    selectable: 'false',
    space: '',
    decode: 'false'
};
var Button = Object.assign({ size: singleQuote('default'), type: '', plain: 'false', disabled: '', loading: 'false', 'form-type': '', 'open-type': '', 'hover-class': singleQuote('button-hover'), 'hover-stop-propagation': 'false', 'hover-start-time': '20', 'hover-stay-time': '70', lang: 'en', 'session-from': '', 'send-message-title': '', 'send-message-path': '', 'send-message-img': '', 'app-parameter': '', 'show-message-card': 'false', bindGetUserInfo: '', bindGetAuthorize: '', bindContact: '', bindGetPhoneNumber: '', bindError: '', bindOpenSetting: '', bindLaunchApp: '', scope: '', name: '' }, selectEnv({
    qq: {
        'app-packagename': '',
        'app-bundleid': '',
        'app-connect-id': ''
    }
}));
var Checkbox = {
    value: '',
    disabled: '',
    checked: 'false',
    color: singleQuote('#09BB07'),
    name: ''
};
var CheckboxGroup = {
    bindChange: '',
    name: ''
};
var Editor = {
    'read-only': 'false',
    placeholder: '',
    'show-img-size': 'false',
    'show-img-toolbar': 'false',
    'show-img-resize': 'false',
    focus: 'false',
    bindReady: '',
    bindFocus: '',
    bindBlur: '',
    bindInput: '',
    bindStatusChange: '',
    name: ''
};
var Form = {
    'report-submit': 'false',
    'report-submit-timeout': '0',
    bindSubmit: '',
    bindReset: '',
    name: ''
};
var Input = Object.assign({ value: '', type: singleQuote(''), password: 'false', placeholder: '', 'placeholder-style': '', 'placeholder-class': singleQuote('input-placeholder'), disabled: '', maxlength: '140', 'cursor-spacing': '0', 'auto-focus': 'false', focus: 'false', 'confirm-type': singleQuote('done'), 'confirm-hold': 'false', cursor: 'i.value.length', 'selection-start': '-1', 'selection-end': '-1', 'adjust-position': 'true', 'hold-keyboard': 'false', bindInput: '', bindFocus: '', bindBlur: '', bindConfirm: '', bindKeyboardHeightChange: '', name: '' }, selectEnv({
    alipay: {
        'random-number': 'false',
        controlled: 'false'
    },
    weapp: {
        'always-embed': 'false'
    }
}));
var Label = {
    for: '',
    name: ''
};
var Picker = {
    mode: singleQuote('selector'),
    disabled: '',
    bindCancel: '',
    range: '',
    'range-key': '',
    value: '',
    bindChange: '',
    bindColumnChange: '',
    start: '',
    end: '',
    fields: singleQuote('day'),
    'custom-item': '',
    name: ''
};
var PickerView = {
    value: '',
    'indicator-style': '',
    'indicator-class': '',
    'mask-style': '',
    'mask-class': '',
    bindChange: '',
    bindPickStart: '',
    bindPickEnd: '',
    name: ''
};
var PickerViewColumn = {
    name: ''
};
var Radio = {
    value: '',
    checked: 'false',
    disabled: '',
    color: singleQuote('#09BB07'),
    name: ''
};
var RadioGroup = {
    bindChange: '',
    name: ''
};
var Slider = {
    min: '0',
    max: '100',
    step: '1',
    disabled: '',
    value: '0',
    color: singleQuote('#e9e9e9'),
    'selected-color': singleQuote('#1aad19'),
    activeColor: singleQuote('#1aad19'),
    backgroundColor: singleQuote('#e9e9e9'),
    'block-size': '28',
    'block-color': singleQuote('#ffffff'),
    'show-value': 'false',
    bindChange: '',
    bindChanging: '',
    name: ''
};
var Switch = {
    checked: 'false',
    disabled: '',
    type: singleQuote('switch'),
    color: singleQuote('#04BE02'),
    bindChange: '',
    name: ''
};
var CoverImage = {
    src: '',
    bindLoad: 'eh',
    bindError: 'eh'
};
var Textarea = {
    value: '',
    placeholder: '',
    'placeholder-style': '',
    'placeholder-class': singleQuote('textarea-placeholder'),
    disabled: '',
    maxlength: '140',
    'auto-focus': 'false',
    focus: 'false',
    'auto-height': 'false',
    fixed: 'false',
    'cursor-spacing': '0',
    cursor: '-1',
    'show-confirm-bar': 'true',
    'selection-start': '-1',
    'selection-end': '-1',
    'adjust-position': 'true',
    'hold-keyboard': 'false',
    bindFocus: '',
    bindBlur: '',
    bindLineChange: '',
    bindInput: '',
    bindConfirm: '',
    bindKeyboardHeightChange: '',
    name: ''
};
var CoverView = Object.assign({ 'scroll-top': 'false' }, touchEvents);
var MatchMedia = {
    'min-width': '',
    'max-width': '',
    width: '',
    'min-height': '',
    'max-height': '',
    height: '',
    orientation: ''
};
var MovableArea = {
    'scale-area': 'false'
};
var MovableView = Object.assign({ direction: 'none', inertia: 'false', 'out-of-bounds': 'false', x: '', y: '', damping: '20', friction: '2', disabled: '', scale: 'false', 'scale-min': '0.5', 'scale-max': '10', 'scale-value': '1', animation: 'true', bindAnimationEnd: '', bindChange: '', bindScale: '', htouchmove: '', vtouchmove: '', width: singleQuote('10px'), height: singleQuote('10px') }, touchEvents);
var ScrollView = Object.assign({ 'scroll-x': 'false', 'scroll-y': 'false', 'upper-threshold': '50', 'lower-threshold': '50', 'scroll-top': '', 'scroll-left': '', 'scroll-into-view': '', 'scroll-with-animation': 'false', 'enable-back-to-top': 'false', 'enable-flex': 'false', 'scroll-anchoring': 'false', 'refresher-enabled': 'false', 'refresher-threshold': '45', 'refresher-default-style': singleQuote('black'), 'refresher-background': singleQuote('#FFF'), 'refresher-triggered': 'false', enhanced: 'false', bounces: 'true', 'show-scrollbar': 'true', 'paging-enabled': 'false', 'fast-deceleration': 'false', bindRefresherPulling: '', bindRefresherRefresh: '', bindRefresherRestore: '', bindRefresherAbort: '', bindScrollToUpper: '', bindScrollToLower: '', bindScroll: '', animation: '', bindTransitionEnd: '', bindAnimationStart: '', bindAnimationIteration: '', bindAnimationEnd: '', bindDragStart: '', bindDragging: '', bindDragEnd: '' }, touchEvents);
var Swiper = Object.assign(Object.assign({ 'indicator-dots': 'false', 'indicator-color': singleQuote('rgba(0, 0, 0, .3)'), 'indicator-active-color': singleQuote('#000000'), autoplay: 'false', current: '0', interval: '5000', duration: '500', circular: 'false', vertical: 'false', 'previous-margin': '\'0px\'', 'next-margin': '\'0px\'', 'snap-to-edge': 'false', 'display-multiple-items': '1', 'skip-hidden-item-layout': 'false', 'easing-function': singleQuote('default'), bindChange: '', bindTransition: '', bindAnimationFinish: '' }, touchEvents), selectEnv({
    alipay: {
        acceleration: 'false',
        'disable-touch': 'false'
    }
}));
var SwiperItem = {
    'item-id': ''
};
var FunctionalPageNavigator = {
    version: singleQuote('release'),
    name: '',
    args: '',
    bindSuccess: '',
    bindFail: '',
    bindCancel: ''
};
var Navigator = {
    target: singleQuote('self'),
    url: '',
    'open-type': singleQuote('navigate'),
    delta: '1',
    'app-id': '',
    path: '',
    'extra-data': '',
    version: singleQuote('version'),
    'hover-class': singleQuote('navigator-hover'),
    'hover-stop-propagation': 'false',
    'hover-start-time': '50',
    'hover-stay-time': '600',
    bindSuccess: '',
    bindFail: '',
    bindComplete: ''
};
var Audio = {
    id: '',
    src: '',
    loop: 'false',
    controls: 'false',
    poster: '',
    name: '',
    author: '',
    bindError: '',
    bindPlay: '',
    bindPause: '',
    bindTimeUpdate: '',
    bindEnded: ''
};
var Camera = {
    mode: singleQuote('normal'),
    'device-position': singleQuote('back'),
    flash: singleQuote('auto'),
    'frame-size': singleQuote('medium'),
    bindStop: '',
    bindError: '',
    bindInitDone: '',
    bindScanCode: ''
};
var Image = Object.assign({ src: '', mode: singleQuote('scaleToFill'), webp: 'false', 'lazy-load': 'false', 'show-menu-by-longpress': 'false', bindError: '', bindLoad: '' }, touchEvents);
var LivePlayer = {
    src: '',
    mode: singleQuote('live'),
    autoplay: 'false',
    muted: 'false',
    orientation: singleQuote('vertical'),
    'object-fit': singleQuote('contain'),
    'background-mute': 'false',
    'min-cache': '1',
    'max-cache': '3',
    'sound-mode': singleQuote('speaker'),
    'auto-pause-if-navigate': 'true',
    'auto-pause-if-open-native': 'true',
    'picture-in-picture-mode': '[]',
    animation: '',
    bindStateChange: '',
    bindFullScreenChange: '',
    bindNetStatus: '',
    bindAudioVolumeNotify: '',
    bindEnterPictureInPicture: '',
    bindLeavePictureInPicture: ''
};
var LivePusher = {
    url: '',
    mode: singleQuote('RTC'),
    autopush: 'false',
    muted: 'false',
    'enable-camera': 'true',
    'auto-focus': 'true',
    orientation: singleQuote('vertical'),
    beauty: '0',
    whiteness: '0',
    aspect: singleQuote('9:16'),
    'min-bitrate': '200',
    'max-bitrate': '1000',
    'audio-quality': singleQuote('high'),
    'waiting-image': '',
    'waiting-image-hash': '',
    zoom: 'false',
    'device-position': singleQuote('front'),
    'background-mute': 'false',
    mirror: 'false',
    'remote-mirror': 'false',
    'local-mirror': 'false',
    'audio-reverb-type': '0',
    'enable-mic': 'true',
    'enable-agc': 'false',
    'enable-ans': 'false',
    'audio-volume-type': singleQuote('voicecall'),
    'video-width': '360',
    'video-height': '640',
    animation: '',
    bindStateChange: '',
    bindNetStatus: '',
    bindBgmStart: '',
    bindBgmProgress: '',
    bindBgmComplete: ''
};
var Video = {
    src: '',
    duration: '',
    controls: 'true',
    'danmu-list': '',
    'danmu-btn': '',
    'enable-danmu': '',
    autoplay: 'false',
    loop: 'false',
    muted: 'false',
    'initial-time': '0',
    'page-gesture': 'false',
    direction: '',
    'show-progress': 'true',
    'show-fullscreen-btn': 'true',
    'show-play-btn': 'true',
    'show-center-play-btn': 'true',
    'enable-progress-gesture': 'true',
    'object-fit': singleQuote('contain'),
    poster: '',
    'show-mute-btn': 'false',
    title: '',
    'play-btn-position': singleQuote('bottom'),
    'enable-play-gesture': 'false',
    'auto-pause-if-navigate': 'true',
    'auto-pause-if-open-native': 'true',
    'vslide-gesture': 'false',
    'vslide-gesture-in-fullscreen': 'true',
    'ad-unit-id': '',
    'poster-for-crawler': '',
    'show-casting-button': 'false',
    'picture-in-picture-mode': '[]',
    // picture-in-picture-show-progress 属性先注释掉的原因如下：
    // 该属性超过了 wxml 属性的长度限制，实际无法使用且导致编译报错。可等微信官方修复后再放开。
    // 参考1：https://developers.weixin.qq.com/community/develop/doc/000a429beb87f0eac07acc0fc5b400
    // 参考2: https://developers.weixin.qq.com/community/develop/doc/0006883619c48054286a4308258c00?_at=vyxqpllafi
    // 'picture-in-picture-show-progress': 'false',
    'enable-auto-rotation': 'false',
    'show-screen-lock-button': 'false',
    animation: '',
    bindPlay: '',
    bindPause: '',
    bindEnded: '',
    bindTimeUpdate: '',
    bindFullScreenChange: '',
    bindWaiting: '',
    bindError: '',
    bindProgress: '',
    bindLoadedMetadata: '',
    bindControlsToggle: '',
    bindEnterPictureInPicture: '',
    bindLeavePictureInPicture: '',
    bindSeekComplete: ''
};
var Canvas = {
    type: '',
    'canvas-id': '',
    'disable-scroll': 'false',
    bindTouchStart: '',
    bindTouchMove: '',
    bindTouchEnd: '',
    bindTouchCancel: '',
    bindLongtap: '',
    bindError: ''
};
var Ad = {
    'unit-id': '',
    'ad-intervals': '',
    'ad-type': singleQuote('banner'),
    'ad-theme': singleQuote('white'),
    bindLoad: '',
    bindError: '',
    bindClose: ''
};
var OfficialAccount = {
    bindLoad: '',
    bindError: ''
};
var OpenData = {
    type: '',
    'open-gid': '',
    lang: singleQuote('en'),
    'default-text': '',
    'default-avatar': '',
    bindError: ''
};
var WebView = {
    src: '',
    bindMessage: '',
    bindLoad: ''
};
var NavigationBar = {
    title: '',
    loading: 'false',
    'front-color': '',
    'background-color': '',
    'color-animation-duration': '0',
    'color-animation-timing-func': singleQuote('linear')
};
var PageMeta = {
    'background-text-style': '',
    'background-color': '',
    'background-color-top': '',
    'background-color-bottom': '',
    'scroll-top': singleQuote(''),
    'scroll-duration': '300',
    'page-style': singleQuote(''),
    'root-font-size': singleQuote(''),
    bindResize: '',
    bindScroll: '',
    bindScrollDone: ''
};
var Block = {};
// For Vue，因为 slot 标签被 vue 占用了
var SlotView = {
    name: ''
};
// For React
// Slot 和 SlotView 最终都会编译成 <view slot={{ i.name }} />
// 因为 <slot name="{{ i.name }}" /> 适用性没有前者高（无法添加类和样式）
// 不给 View 直接加 slot 属性的原因是性能损耗
var Slot = {
    name: ''
};
var internalComponents = {
    View: View,
    Icon: Icon,
    Progress: Progress,
    RichText: RichText,
    Text: Text,
    Button: Button,
    Checkbox: Checkbox,
    CheckboxGroup: CheckboxGroup,
    Editor: Editor,
    Form: Form,
    Input: Input,
    Label: Label,
    Picker: Picker,
    PickerView: PickerView,
    PickerViewColumn: PickerViewColumn,
    Radio: Radio,
    RadioGroup: RadioGroup,
    Slider: Slider,
    Switch: Switch,
    CoverImage: CoverImage,
    Textarea: Textarea,
    CoverView: CoverView,
    MatchMedia: MatchMedia,
    MovableArea: MovableArea,
    MovableView: MovableView,
    ScrollView: ScrollView,
    Swiper: Swiper,
    SwiperItem: SwiperItem,
    FunctionalPageNavigator: FunctionalPageNavigator,
    Navigator: Navigator,
    Audio: Audio,
    Camera: Camera,
    Image: Image,
    LivePlayer: LivePlayer,
    LivePusher: LivePusher,
    Video: Video,
    Canvas: Canvas,
    Ad: Ad,
    OfficialAccount: OfficialAccount,
    OpenData: OpenData,
    WebView: WebView,
    NavigationBar: NavigationBar,
    PageMeta: PageMeta,
    Block: Block,
    Map: Map$1,
    Slot: Slot,
    SlotView: SlotView
};
var controlledComponent = new Set([
    'input',
    'checkbox',
    'picker',
    'picker-view',
    'radio',
    'slider',
    'switch',
    'textarea'
]);
var focusComponents = new Set([
    'input',
    'textarea',
    'editor'
]);

var EMPTY_OBJ = {};
var EMPTY_ARR = [];
var noop = function () {
    var _ = [], len = arguments.length;
    while ( len-- ) _[ len ] = arguments[ len ];
 };
/**
 * box creates a boxed value.
 *
 * @typeparam T Value type.
 * @param v Value.
 * @returns Boxed value.
 */
var box = function (v) { return ({ v: v }); };
/**
 * box creates a boxed value.
 *
 * @typeparam T Value type.
 * @param b Boxed value.
 * @returns Value.
 */
var unbox = function (b) { return b.v; };
function toDashed(s) {
    return s.replace(/([a-z0-9])([A-Z])/g, '$1-$2').toLowerCase();
}
function toCamelCase(s) {
    var camel = '';
    var nextCap = false;
    for (var i = 0; i < s.length; i++) {
        if (s[i] !== '-') {
            camel += nextCap ? s[i].toUpperCase() : s[i];
            nextCap = false;
        }
        else {
            nextCap = true;
        }
    }
    return camel;
}
function capitalize(s) {
    return s.charAt(0).toUpperCase() + s.slice(1);
}
var hasOwnProperty = Object.prototype.hasOwnProperty;
var hasOwn = function (val, key) { return hasOwnProperty.call(val, key); };
var reportIssue = '如有疑问，请提交 issue 至：https://github.com/nervjs/taro/issues';
/**
 * ensure takes a condition and throw a error if the condition fails,
 * like failure::ensure: https://docs.rs/failure/0.1.1/failure/macro.ensure.html
 * @param condition condition.
 * @param msg error message.
 */
function ensure(condition, msg) {
    if (!condition) {
        throw new Error(msg + '\n' + reportIssue);
    }
}
function warn(condition, msg) {
    if (process.env.NODE_ENV !== 'production') {
        if (condition) {
            console.warn(msg);
        }
    }
}

/**
 * 这里我们需要关心的小程序种类有两类：
 * 1. 模板递归：
 *  - 支持：tmpl0 套 tmpl0
 *  - 不支持：这就使得我们必须生成多级的模板，tmpl0 套 tmpl1，tmpl1 套 tmpl2……
 *           直到超过阈值 N (N = config.miniapp.baseLevel) tmplN 会套组件 comp，组件 comp 重新再套 tmpl0。
 * 2. 小程序脚本语言（wxs, sjs, etc...）：
 *  - 支持：可以在模板使用函数缩减模板大小或提高性能（存疑），例如判断一个值是不是假值（falsy value）。
 *         将来或许会把数据序列化^1 的操作也放到小程序脚本语言里。
 *  - 不支持：使用纯 *xml 语法
 *
 * ^1: packages/taro-runtime/src/hydrate.ts
*/
var voidElements = new Set([
    'progress',
    'icon',
    'rich-text',
    'input',
    'textarea',
    'slider',
    'switch',
    'audio',
    'live-pusher',
    'video',
    'ad',
    'official-account',
    'open-data',
    'navigation-bar'
]);
var nestElements = new Map([
    ['view', -1],
    ['cover-view', -1],
    ['block', -1],
    ['text', -1],
    ['slot', 8],
    ['slot-view', 8],
    ['label', 6],
    ['form', 4],
    ['scroll-view', 4]
]);
var weixinAdapter = {
    if: 'wx:if',
    else: 'wx:else',
    elseif: 'wx:elif',
    for: 'wx:for',
    forItem: 'wx:for-item',
    forIndex: 'wx:for-index',
    key: 'wx:key',
    xs: 'wxs',
    type: 'weapp'
};
var BaseTemplate = function BaseTemplate() {
      var this$1 = this;

      this.exportExpr = 'module.exports =';
      this.supportXS = false;
      this.Adapter = weixinAdapter;
      this.buildPageTemplate = function (baseTempPath) {
          var template = "<import src=\"" + baseTempPath + "\"/>\n  <template is=\"taro_tmpl\" data=\"{{" + (this$1.dataKeymap('root:root')) + "}}\" />";
          return template;
      };
      this.buildBaseComponentTemplate = function (ext) {
          var data = !this$1.isSupportRecursive && this$1.supportXS
              ? this$1.dataKeymap('i:i,l:l')
              : this$1.dataKeymap('i:i');
          return ("<import src=\"./base" + ext + "\" />\n  <template is=\"tmpl_0_" + ("container") + "\" data=\"{{" + data + "}}\" />");
      };
      this.buildXScript = function () {
          return ((this$1.exportExpr) + " {\n  a: " + (this$1.buildXSTmplName()) + ",\n  b: function (a, b) {\n    return a === undefined ? b : a\n  },\n  c: function(i, prefix) {\n    var s = i.focus !== undefined ? 'focus' : 'blur'\n    return prefix + i." + ("nn") + " + '_' + s\n  },\n  d: function (i, v) {\n    return i === undefined ? v : i\n  },\n  e: function (n) {\n    return 'tmpl_' + n + '_" + ("container") + "'\n  },\n  " + (this$1.buildXSTmpExtra()) + "\n}");
      };
  };
  BaseTemplate.prototype.buildAttribute = function buildAttribute (attrs, nodeName) {
        var this$1 = this;

      return Object.keys(attrs)
          .map(function (k) { return (k + "=\"" + (k.startsWith('bind') || k.startsWith('on') ? attrs[k] : ("{" + (this$1.getAttrValue(attrs[k], k, nodeName)) + "}")) + "\" "); })
          .join('');
  };
  BaseTemplate.prototype.replacePropName = function replacePropName (name, value, _componentName) {
      if (value === 'eh')
          { return name.toLowerCase(); }
      return name;
  };
  BaseTemplate.prototype.createMiniComponents = function createMiniComponents (components) {
      var result = Object.create(null);
      for (var key in components) {
          if (hasOwn(components, key)) {
              var component = components[key];
              var compName = toDashed(key);
              var newComp = Object.create(null);
              if (isFunction(this.modifyCompProps)) {
                  component = this.modifyCompProps(compName, component);
              }
              for (var prop in component) {
                  if (hasOwn(component, prop)) {
                      var propValue = component[prop];
                      if (prop.startsWith('bind') || specialEvents.has(prop)) {
                          propValue = 'eh';
                      }
                      else if (propValue === '') {
                          propValue = "i." + (toCamelCase(prop));
                      }
                      else if (isBooleanStringLiteral(propValue) || isNumber(+propValue)) {
                          propValue = this.supportXS
                              ? ("xs.b(i." + (toCamelCase(prop)) + "," + propValue + ")")
                              : ("i." + (toCamelCase(prop)) + "===undefined?" + propValue + ":i." + (toCamelCase(prop)));
                      }
                      else {
                          propValue = "i." + (toCamelCase(prop)) + "||" + (propValue || singleQuote(''));
                      }
                      prop = this.replacePropName(prop, propValue, compName);
                      newComp[prop] = propValue;
                  }
              }
              if (compName !== 'block') {
                  Object.assign(newComp, styles, this.getEvents());
              }
              if (compName === 'swiper-item') {
                  delete newComp.style;
              }
              if (compName === 'slot' || compName === 'slot-view') {
                  result[compName] = {
                      slot: 'i.name'
                  };
              }
              else {
                  result[compName] = newComp;
              }
          }
      }
      return result;
  };
  BaseTemplate.prototype.buildBaseTemplate = function buildBaseTemplate () {
      var Adapter = this.Adapter;
      var data = !this.isSupportRecursive && this.supportXS
          ? ("" + (this.dataKeymap('i:item,l:\'\'')))
          : this.dataKeymap('i:item');
      return ((this.buildXsTemplate()) + "\n<template name=\"taro_tmpl\">\n  <block " + (Adapter.for) + "=\"{{root.cn}}\" " + (Adapter.key) + "=\"uid\">\n    <template is=\"tmpl_0_" + ("container") + "\" data=\"{{" + data + "}}\" />\n  </block>\n</template>\n");
  };
  BaseTemplate.prototype.buildThirdPartyAttr = function buildThirdPartyAttr (attrs) {
      return Array.from(attrs).reduce(function (str, attr) {
          if (attr.startsWith('@')) { // vue event
              return str + "bind" + (attr.slice(1)) + "=\"eh\" ";
          }
          else if (attr.startsWith('bind')) {
              return str + attr + "=\"eh\" ";
          }
          else if (attr.startsWith('on')) {
              return str + "bind" + (attr.slice(2).toLowerCase()) + "=\"eh\" ";
          }
          return str + attr + "=\"{{i." + (toCamelCase(attr)) + "}}\" ";
      }, '');
  };
  BaseTemplate.prototype.buildComponentTemplate = function buildComponentTemplate (comp, level) {
      return focusComponents.has(comp.nodeName)
          ? this.buildFocusComponentTemplte(comp, level)
          : this.buildStandardComponentTemplate(comp, level);
  };
  BaseTemplate.prototype.buildFocusComponentTemplte = function buildFocusComponentTemplte (comp, level) {
      var attrs = Object.assign({}, comp.attributes);
      var templateName = this.supportXS
          ? ("xs.c(i, 'tmpl_" + level + "_')")
          : ("i.focus ? 'tmpl_" + level + "_" + (comp.nodeName) + "_focus' : 'tmpl_" + level + "_" + (comp.nodeName) + "_blur'");
      delete attrs.focus;
      return ("\n<template name=\"tmpl_" + level + "_" + (comp.nodeName) + "\">\n  <template is=\"{{" + templateName + "}}\" data=\"{{" + (this.dataKeymap('i:i')) + "}}\" />\n</template>\n\n<template name=\"tmpl_" + level + "_" + (comp.nodeName) + "_focus\">\n  <" + (comp.nodeName) + " " + (this.buildAttribute(comp.attributes, comp.nodeName)) + " id=\"{{i.uid}}\" />\n</template>\n\n<template name=\"tmpl_" + level + "_" + (comp.nodeName) + "_blur\">\n  <" + (comp.nodeName) + " " + (this.buildAttribute(attrs, comp.nodeName)) + " id=\"{{i.uid}}\" />\n</template>\n");
  };
  BaseTemplate.prototype.buildStandardComponentTemplate = function buildStandardComponentTemplate (comp, level) {
      var ref = this;
        var isSupportRecursive = ref.isSupportRecursive;
        var Adapter = ref.Adapter;
      var nextLevel = isSupportRecursive ? 0 : level + 1;
      var data = !this.isSupportRecursive
          ? ("" + (this.dataKeymap('i:item,l:l')))
          : this.dataKeymap('i:item');
      var child = this.supportXS
          ? ("<template is=\"{{xs.e(" + (isSupportRecursive ? 0 : 'cid+1') + ")}}\" data=\"{{" + data + "}}\" />")
          : ("<template is=\"tmpl_" + nextLevel + "_" + ("container") + "\" data=\"{{" + (this.dataKeymap('i:item')) + "}}\" />");
      if (isFunction(this.modifyLoopBody)) {
          child = this.modifyLoopBody(child, comp.nodeName);
      }
      var children = voidElements.has(comp.nodeName)
          ? ''
          : ("\n    <block " + (Adapter.for) + "=\"{{i." + ("cn") + "}}\" " + (Adapter.key) + "=\"uid\">\n      " + child + "\n    </block>\n  ");
      if (isFunction(this.modifyLoopContainer)) {
          children = this.modifyLoopContainer(children, comp.nodeName);
      }
      var nodeName = comp.nodeName === 'slot' || comp.nodeName === 'slot-view' ? 'view' : comp.nodeName;
      var res = "\n<template name=\"tmpl_" + level + "_" + (comp.nodeName) + "\">\n  <" + nodeName + " " + (this.buildAttribute(comp.attributes, comp.nodeName)) + " id=\"{{i.uid}}\">" + children + "</" + nodeName + ">\n</template>\n";
      if (isFunction(this.modifyTemplateResult)) {
          res = this.modifyTemplateResult(res, comp.nodeName, level, children);
      }
      return res;
  };
  BaseTemplate.prototype.buildPlainTextTemplate = function buildPlainTextTemplate (level) {
      return ("\n<template name=\"tmpl_" + level + "_#text\" data=\"{{" + (this.dataKeymap('i:i')) + "}}\">\n  <block>{{i." + ("v") + "}}</block>\n</template>\n");
  };
  BaseTemplate.prototype.buildThirdPartyTemplate = function buildThirdPartyTemplate (level, componentConfig) {
        var this$1 = this;

      var ref = this;
        var Adapter = ref.Adapter;
        var isSupportRecursive = ref.isSupportRecursive;
      var nextLevel = isSupportRecursive ? 0 : level + 1;
      var template = '';
      var data = !this.isSupportRecursive && this.supportXS
          ? ("" + (this.dataKeymap('i:item,l:l')))
          : this.dataKeymap('i:item');
      componentConfig.thirdPartyComponents.forEach(function (attrs, compName) {
          template += "\n<template name=\"tmpl_" + level + "_" + compName + "\">\n  <" + compName + " " + (this$1.buildThirdPartyAttr(attrs)) + " id=\"{{i.uid}}\">\n    <block " + (Adapter.for) + "=\"{{i." + ("cn") + "}}\" " + (Adapter.key) + "=\"uid\">\n      <template is=\"tmpl_" + nextLevel + "_" + ("container") + "\" data=\"{{" + data + "}}\" />\n    </block>\n  </" + compName + ">\n</template>\n  ";
      });
      return template;
  };
  BaseTemplate.prototype.buildContainerTemplate = function buildContainerTemplate (level, restart) {
        if ( restart === void 0 ) restart = false;

      var tmpl = '';
      if (restart) {
          if (!this.isSupportRecursive && this.supportXS) {
              tmpl = '<comp i="{{i}}" l="{{l}}" />';
          }
          else {
              tmpl = '<comp i="{{i}}" />';
          }
      }
      else {
          var xs = !this.isSupportRecursive
              ? ("xs.a(" + level + ", i." + ("nn") + ", l)")
              : ("xs.a(" + level + ", i." + ("nn") + ")");
          var data = !this.isSupportRecursive
              ? ("" + (this.dataKeymap(("i:i,cid:" + level + ",l:xs.f(l,i." + ("nn") + ")"))))
              : ("" + (this.dataKeymap('i:i')));
          tmpl = this.supportXS
              ? ("<template is=\"{{" + xs + "}}\" data=\"{{" + data + "}}\" />")
              : ("<template is=\"{{'tmpl_" + level + "_' + i." + ("nn") + "}}\" data=\"{{" + (this.dataKeymap('i:i')) + "}}\" />");
      }
      return ("\n<template name=\"tmpl_" + level + "_" + ("container") + "\">\n  " + tmpl + "\n</template>\n");
  };
  BaseTemplate.prototype.dataKeymap = function dataKeymap (keymap) {
      return keymap;
  };
  BaseTemplate.prototype.getEvents = function getEvents () {
      return events;
  };
  BaseTemplate.prototype.getAttrValue = function getAttrValue (value, _key, _nodeName) {
      return ("{" + value + "}");
  };
  BaseTemplate.prototype.buildXsTemplate = function buildXsTemplate () {
      return '';
  };
  BaseTemplate.prototype.buildXSTmplName = function buildXSTmplName () {
      return "function (l, n) {\n    return 'tmpl_' + l + '_' + n\n  }";
  };
  BaseTemplate.prototype.buildXSTmpExtra = function buildXSTmpExtra () {
      return '';
  };
var RecursiveTemplate = /*@__PURE__*/(function (BaseTemplate) {
  function RecursiveTemplate() {
        var this$1 = this;

        BaseTemplate.apply(this, arguments);
        this.isSupportRecursive = true;
        this.buildTemplate = function (componentConfig) {
            var template = this$1.buildBaseTemplate();
            if (!this$1.miniComponents) {
                this$1.miniComponents = this$1.createMiniComponents(internalComponents);
            }
            var ZERO_FLOOR = 0;
            var components = Object.keys(this$1.miniComponents)
                .filter(function (c) { return componentConfig.includes.size && !componentConfig.includeAll ? componentConfig.includes.has(c) : true; });
            template = components.reduce(function (current, nodeName) {
                var attributes = this$1.miniComponents[nodeName];
                return current + this$1.buildComponentTemplate({ nodeName: nodeName, attributes: attributes }, ZERO_FLOOR);
            }, template);
            template += this$1.buildPlainTextTemplate(ZERO_FLOOR);
            template += this$1.buildThirdPartyTemplate(ZERO_FLOOR, componentConfig);
            template += this$1.buildContainerTemplate(ZERO_FLOOR);
            return template;
        };
    }

  if ( BaseTemplate ) RecursiveTemplate.__proto__ = BaseTemplate;
  RecursiveTemplate.prototype = Object.create( BaseTemplate && BaseTemplate.prototype );
  RecursiveTemplate.prototype.constructor = RecursiveTemplate;

  return RecursiveTemplate;
}(BaseTemplate));
var UnRecursiveTemplate = /*@__PURE__*/(function (BaseTemplate) {
  function UnRecursiveTemplate() {
        var this$1 = this;

        BaseTemplate.apply(this, arguments);
        this.isSupportRecursive = false;
        this._baseLevel = 16;
        this.buildTemplate = function (componentConfig) {
            this$1.componentConfig = componentConfig;
            if (!this$1.miniComponents) {
                this$1.miniComponents = this$1.createMiniComponents(internalComponents);
            }
            var components = Object.keys(this$1.miniComponents)
                .filter(function (c) { return componentConfig.includes.size && !componentConfig.includeAll ? componentConfig.includes.has(c) : true; });
            var template = this$1.buildBaseTemplate();
            for (var i = 0; i < this$1.baseLevel; i++) {
                template += this$1.supportXS
                    ? this$1.buildOptimizeFloor(i, components, this$1.baseLevel === i + 1)
                    : this$1.buildFloor(i, components, this$1.baseLevel === i + 1);
            }
            return template;
        };
    }

  if ( BaseTemplate ) UnRecursiveTemplate.__proto__ = BaseTemplate;
  UnRecursiveTemplate.prototype = Object.create( BaseTemplate && BaseTemplate.prototype );
  UnRecursiveTemplate.prototype.constructor = UnRecursiveTemplate;

  var prototypeAccessors = { baseLevel: { configurable: true } };
    prototypeAccessors.baseLevel.set = function (lv) {
        this._baseLevel = lv;
    };
    prototypeAccessors.baseLevel.get = function () {
        return this._baseLevel;
    };
    UnRecursiveTemplate.prototype.buildFloor = function buildFloor (level, components, restart) {
        var this$1 = this;
        if ( restart === void 0 ) restart = false;

        if (restart)
            { return this.buildContainerTemplate(level, restart); }
        var template = components.reduce(function (current, nodeName) {
            var attributes = this$1.miniComponents[nodeName];
            return current + this$1.buildComponentTemplate({ nodeName: nodeName, attributes: attributes }, level);
        }, '');
        template += this.buildPlainTextTemplate(level);
        template += this.buildThirdPartyTemplate(level, this.componentConfig);
        template += this.buildContainerTemplate(level, restart);
        return template;
    };
    UnRecursiveTemplate.prototype.buildOptimizeFloor = function buildOptimizeFloor (level, components, restart) {
        var this$1 = this;
        if ( restart === void 0 ) restart = false;

        if (restart)
            { return this.buildContainerTemplate(level, restart); }
        var template = components.reduce(function (current, nodeName) {
            if (level !== 0) {
                if (!nestElements.has(nodeName)) {
                    // 不可嵌套自身的组件只需输出一层模板
                    return current;
                }
                else {
                    // 部分可嵌套自身的组件实际上不会嵌套过深，这里按阈值限制层数
                    var max = nestElements.get(nodeName);
                    if (max > 0 && level >= max) {
                        return current;
                    }
                }
            }
            var attributes = this$1.miniComponents[nodeName];
            return current + this$1.buildComponentTemplate({ nodeName: nodeName, attributes: attributes }, level);
        }, '');
        if (level === 0)
            { template += this.buildPlainTextTemplate(level); }
        template += this.buildThirdPartyTemplate(level, this.componentConfig);
        template += this.buildContainerTemplate(level);
        return template;
    };
    UnRecursiveTemplate.prototype.buildXSTmplName = function buildXSTmplName () {
        var comps = Array.from(nestElements.keys()).concat( Array.from(this.componentConfig.thirdPartyComponents.keys())
        );
        var hasMaxComps = [];
        nestElements.forEach(function (max, comp) {
            if (max > -1)
                { hasMaxComps.push(comp); }
        });
        return ("function (l, n, s) {\n    var a = " + (JSON.stringify(comps)) + "\n    var b = " + (JSON.stringify(hasMaxComps)) + "\n    if (a.indexOf(n) === -1) {\n      l = 0\n    }\n    if (b.indexOf(n) > -1) {\n      var u = s.split(',')\n      var depth = 0\n      for (var i = 0; i < u.length; i++) {\n        if (u[i] === n) depth++\n      }\n      l = depth\n    }\n    return 'tmpl_' + l + '_' + n\n  }");
    };
    UnRecursiveTemplate.prototype.buildXSTmpExtra = function buildXSTmpExtra () {
        var hasMaxComps = [];
        nestElements.forEach(function (max, comp) {
            if (max > -1)
                { hasMaxComps.push(comp); }
        });
        return ("f: function (l, n) {\n    var b = " + (JSON.stringify(hasMaxComps)) + "\n    if (b.indexOf(n) > -1) {\n      if (l) l += ','\n      l += n\n    }\n    return l\n  }");
    };

  Object.defineProperties( UnRecursiveTemplate.prototype, prototypeAccessors );

  return UnRecursiveTemplate;
}(BaseTemplate));

exports.BaseTemplate = BaseTemplate;
exports.EMPTY_ARR = EMPTY_ARR;
exports.EMPTY_OBJ = EMPTY_OBJ;
exports.RecursiveTemplate = RecursiveTemplate;
exports.UnRecursiveTemplate = UnRecursiveTemplate;
exports.box = box;
exports.capitalize = capitalize;
exports.controlledComponent = controlledComponent;
exports.ensure = ensure;
exports.events = events;
exports.focusComponents = focusComponents;
exports.hasOwn = hasOwn;
exports.internalComponents = internalComponents;
exports.isArray = isArray;
exports.isBoolean = isBoolean;
exports.isBooleanStringLiteral = isBooleanStringLiteral;
exports.isFunction = isFunction;
exports.isNull = isNull;
exports.isNumber = isNumber;
exports.isObject = isObject;
exports.isString = isString;
exports.isUndefined = isUndefined;
exports.noop = noop;
exports.singleQuote = singleQuote;
exports.specialEvents = specialEvents;
exports.styles = styles;
exports.toCamelCase = toCamelCase;
exports.toDashed = toDashed;
exports.unbox = unbox;
exports.warn = warn;
//# sourceMappingURL=index.js.map
