export declare const styles: {
    style: string;
    class: string;
};
export declare const events: {
    bindtap: string;
};
export declare const specialEvents: Set<string>;
export declare function singleQuote(s: string): string;
export declare const internalComponents: {
    View: {
        bindTouchStart: string;
        bindTouchMove: string;
        bindTouchEnd: string;
        bindTouchCancel: string;
        bindLongTap: string;
        'hover-class': string;
        'hover-stop-propagation': string;
        'hover-start-time': string;
        'hover-stay-time': string;
        animation: string;
        bindAnimationStart: string;
        bindAnimationIteration: string;
        bindAnimationEnd: string;
        bindTransitionEnd: string;
    };
    Icon: {
        type: string;
        size: string;
        color: string;
    };
    Progress: {
        percent: string;
        'show-info': string;
        'border-radius': string;
        'font-size': string;
        'stroke-width': string;
        color: string;
        activeColor: string;
        backgroundColor: string;
        active: string;
        'active-mode': string;
        duration: string;
        bindActiveEnd: string;
    };
    RichText: {
        nodes: string;
        space: string;
    };
    Text: {
        selectable: string;
        space: string;
        decode: string;
    };
    Button: {
        size: string;
        type: string;
        plain: string;
        disabled: string;
        loading: string;
        'form-type': string;
        'open-type': string;
        'hover-class': string;
        'hover-stop-propagation': string;
        'hover-start-time': string;
        'hover-stay-time': string;
        lang: string;
        'session-from': string;
        'send-message-title': string;
        'send-message-path': string;
        'send-message-img': string;
        'app-parameter': string;
        'show-message-card': string;
        bindGetUserInfo: string;
        bindGetAuthorize: string;
        bindContact: string;
        bindGetPhoneNumber: string;
        bindError: string;
        bindOpenSetting: string;
        bindLaunchApp: string;
        scope: string;
        name: string;
    };
    Checkbox: {
        value: string;
        disabled: string;
        checked: string;
        color: string;
        name: string;
    };
    CheckboxGroup: {
        bindChange: string;
        name: string;
    };
    Editor: {
        'read-only': string;
        placeholder: string;
        'show-img-size': string;
        'show-img-toolbar': string;
        'show-img-resize': string;
        focus: string;
        bindReady: string;
        bindFocus: string;
        bindBlur: string;
        bindInput: string;
        bindStatusChange: string;
        name: string;
    };
    Form: {
        'report-submit': string;
        'report-submit-timeout': string;
        bindSubmit: string;
        bindReset: string;
        name: string;
    };
    Input: {
        value: string;
        type: string;
        password: string;
        placeholder: string;
        'placeholder-style': string;
        'placeholder-class': string;
        disabled: string;
        maxlength: string;
        'cursor-spacing': string;
        'auto-focus': string;
        focus: string;
        'confirm-type': string;
        'confirm-hold': string;
        cursor: string;
        'selection-start': string;
        'selection-end': string;
        'adjust-position': string;
        'hold-keyboard': string;
        bindInput: string;
        bindFocus: string;
        bindBlur: string;
        bindConfirm: string;
        bindKeyboardHeightChange: string;
        name: string;
    };
    Label: {
        for: string;
        name: string;
    };
    Picker: {
        mode: string;
        disabled: string;
        bindCancel: string;
        range: string;
        'range-key': string;
        value: string;
        bindChange: string;
        bindColumnChange: string;
        start: string;
        end: string;
        fields: string;
        'custom-item': string;
        name: string;
    };
    PickerView: {
        value: string;
        'indicator-style': string;
        'indicator-class': string;
        'mask-style': string;
        'mask-class': string;
        bindChange: string;
        bindPickStart: string;
        bindPickEnd: string;
        name: string;
    };
    PickerViewColumn: {
        name: string;
    };
    Radio: {
        value: string;
        checked: string;
        disabled: string;
        color: string;
        name: string;
    };
    RadioGroup: {
        bindChange: string;
        name: string;
    };
    Slider: {
        min: string;
        max: string;
        step: string;
        disabled: string;
        value: string;
        color: string;
        'selected-color': string;
        activeColor: string;
        backgroundColor: string;
        'block-size': string;
        'block-color': string;
        'show-value': string;
        bindChange: string;
        bindChanging: string;
        name: string;
    };
    Switch: {
        checked: string;
        disabled: string;
        type: string;
        color: string;
        bindChange: string;
        name: string;
    };
    CoverImage: {
        src: string;
        bindLoad: string;
        bindError: string;
    };
    Textarea: {
        value: string;
        placeholder: string;
        'placeholder-style': string;
        'placeholder-class': string;
        disabled: string;
        maxlength: string;
        'auto-focus': string;
        focus: string;
        'auto-height': string;
        fixed: string;
        'cursor-spacing': string;
        cursor: string;
        'show-confirm-bar': string;
        'selection-start': string;
        'selection-end': string;
        'adjust-position': string;
        'hold-keyboard': string;
        bindFocus: string;
        bindBlur: string;
        bindLineChange: string;
        bindInput: string;
        bindConfirm: string;
        bindKeyboardHeightChange: string;
        name: string;
    };
    CoverView: {
        bindTouchStart: string;
        bindTouchMove: string;
        bindTouchEnd: string;
        bindTouchCancel: string;
        bindLongTap: string;
        'scroll-top': string;
    };
    MatchMedia: {
        'min-width': string;
        'max-width': string;
        width: string;
        'min-height': string;
        'max-height': string;
        height: string;
        orientation: string;
    };
    MovableArea: {
        'scale-area': string;
    };
    MovableView: {
        bindTouchStart: string;
        bindTouchMove: string;
        bindTouchEnd: string;
        bindTouchCancel: string;
        bindLongTap: string;
        direction: string;
        inertia: string;
        'out-of-bounds': string;
        x: string;
        y: string;
        damping: string;
        friction: string;
        disabled: string;
        scale: string;
        'scale-min': string;
        'scale-max': string;
        'scale-value': string;
        animation: string;
        bindAnimationEnd: string;
        bindChange: string;
        bindScale: string;
        htouchmove: string;
        vtouchmove: string;
        width: string;
        height: string;
    };
    ScrollView: {
        bindTouchStart: string;
        bindTouchMove: string;
        bindTouchEnd: string;
        bindTouchCancel: string;
        bindLongTap: string;
        'scroll-x': string;
        'scroll-y': string;
        'upper-threshold': string;
        'lower-threshold': string;
        'scroll-top': string;
        'scroll-left': string;
        'scroll-into-view': string;
        'scroll-with-animation': string;
        'enable-back-to-top': string;
        'enable-flex': string;
        'scroll-anchoring': string;
        'refresher-enabled': string;
        'refresher-threshold': string;
        'refresher-default-style': string;
        'refresher-background': string;
        'refresher-triggered': string;
        enhanced: string;
        bounces: string;
        'show-scrollbar': string;
        'paging-enabled': string;
        'fast-deceleration': string;
        bindRefresherPulling: string;
        bindRefresherRefresh: string;
        bindRefresherRestore: string;
        bindRefresherAbort: string;
        bindScrollToUpper: string;
        bindScrollToLower: string;
        bindScroll: string;
        animation: string;
        bindTransitionEnd: string;
        bindAnimationStart: string;
        bindAnimationIteration: string;
        bindAnimationEnd: string;
        bindDragStart: string;
        bindDragging: string;
        bindDragEnd: string;
    };
    Swiper: {
        bindTouchStart: string;
        bindTouchMove: string;
        bindTouchEnd: string;
        bindTouchCancel: string;
        bindLongTap: string;
        'indicator-dots': string;
        'indicator-color': string;
        'indicator-active-color': string;
        autoplay: string;
        current: string;
        interval: string;
        duration: string;
        circular: string;
        vertical: string;
        'previous-margin': string;
        'next-margin': string;
        'snap-to-edge': string;
        'display-multiple-items': string;
        'skip-hidden-item-layout': string;
        'easing-function': string;
        bindChange: string;
        bindTransition: string;
        bindAnimationFinish: string;
    };
    SwiperItem: {
        'item-id': string;
    };
    FunctionalPageNavigator: {
        version: string;
        name: string;
        args: string;
        bindSuccess: string;
        bindFail: string;
        bindCancel: string;
    };
    Navigator: {
        target: string;
        url: string;
        'open-type': string;
        delta: string;
        'app-id': string;
        path: string;
        'extra-data': string;
        version: string;
        'hover-class': string;
        'hover-stop-propagation': string;
        'hover-start-time': string;
        'hover-stay-time': string;
        bindSuccess: string;
        bindFail: string;
        bindComplete: string;
    };
    Audio: {
        id: string;
        src: string;
        loop: string;
        controls: string;
        poster: string;
        name: string;
        author: string;
        bindError: string;
        bindPlay: string;
        bindPause: string;
        bindTimeUpdate: string;
        bindEnded: string;
    };
    Camera: {
        mode: string;
        'device-position': string;
        flash: string;
        'frame-size': string;
        bindStop: string;
        bindError: string;
        bindInitDone: string;
        bindScanCode: string;
    };
    Image: {
        bindTouchStart: string;
        bindTouchMove: string;
        bindTouchEnd: string;
        bindTouchCancel: string;
        bindLongTap: string;
        src: string;
        mode: string;
        webp: string;
        'lazy-load': string;
        'show-menu-by-longpress': string;
        bindError: string;
        bindLoad: string;
    };
    LivePlayer: {
        src: string;
        mode: string;
        autoplay: string;
        muted: string;
        orientation: string;
        'object-fit': string;
        'background-mute': string;
        'min-cache': string;
        'max-cache': string;
        'sound-mode': string;
        'auto-pause-if-navigate': string;
        'auto-pause-if-open-native': string;
        'picture-in-picture-mode': string;
        animation: string;
        bindStateChange: string;
        bindFullScreenChange: string;
        bindNetStatus: string;
        bindAudioVolumeNotify: string;
        bindEnterPictureInPicture: string;
        bindLeavePictureInPicture: string;
    };
    LivePusher: {
        url: string;
        mode: string;
        autopush: string;
        muted: string;
        'enable-camera': string;
        'auto-focus': string;
        orientation: string;
        beauty: string;
        whiteness: string;
        aspect: string;
        'min-bitrate': string;
        'max-bitrate': string;
        'audio-quality': string;
        'waiting-image': string;
        'waiting-image-hash': string;
        zoom: string;
        'device-position': string;
        'background-mute': string;
        mirror: string;
        'remote-mirror': string;
        'local-mirror': string;
        'audio-reverb-type': string;
        'enable-mic': string;
        'enable-agc': string;
        'enable-ans': string;
        'audio-volume-type': string;
        'video-width': string;
        'video-height': string;
        animation: string;
        bindStateChange: string;
        bindNetStatus: string;
        bindBgmStart: string;
        bindBgmProgress: string;
        bindBgmComplete: string;
    };
    Video: {
        src: string;
        duration: string;
        controls: string;
        'danmu-list': string;
        'danmu-btn': string;
        'enable-danmu': string;
        autoplay: string;
        loop: string;
        muted: string;
        'initial-time': string;
        'page-gesture': string;
        direction: string;
        'show-progress': string;
        'show-fullscreen-btn': string;
        'show-play-btn': string;
        'show-center-play-btn': string;
        'enable-progress-gesture': string;
        'object-fit': string;
        poster: string;
        'show-mute-btn': string;
        title: string;
        'play-btn-position': string;
        'enable-play-gesture': string;
        'auto-pause-if-navigate': string;
        'auto-pause-if-open-native': string;
        'vslide-gesture': string;
        'vslide-gesture-in-fullscreen': string;
        'ad-unit-id': string;
        'poster-for-crawler': string;
        'show-casting-button': string;
        'picture-in-picture-mode': string;
        'enable-auto-rotation': string;
        'show-screen-lock-button': string;
        animation: string;
        bindPlay: string;
        bindPause: string;
        bindEnded: string;
        bindTimeUpdate: string;
        bindFullScreenChange: string;
        bindWaiting: string;
        bindError: string;
        bindProgress: string;
        bindLoadedMetadata: string;
        bindControlsToggle: string;
        bindEnterPictureInPicture: string;
        bindLeavePictureInPicture: string;
        bindSeekComplete: string;
    };
    Canvas: {
        type: string;
        'canvas-id': string;
        'disable-scroll': string;
        bindTouchStart: string;
        bindTouchMove: string;
        bindTouchEnd: string;
        bindTouchCancel: string;
        bindLongtap: string;
        bindError: string;
    };
    Ad: {
        'unit-id': string;
        'ad-intervals': string;
        'ad-type': string;
        'ad-theme': string;
        bindLoad: string;
        bindError: string;
        bindClose: string;
    };
    OfficialAccount: {
        bindLoad: string;
        bindError: string;
    };
    OpenData: {
        type: string;
        'open-gid': string;
        lang: string;
        'default-text': string;
        'default-avatar': string;
        bindError: string;
    };
    WebView: {
        src: string;
        bindMessage: string;
        bindLoad: string;
    };
    NavigationBar: {
        title: string;
        loading: string;
        'front-color': string;
        'background-color': string;
        'color-animation-duration': string;
        'color-animation-timing-func': string;
    };
    PageMeta: {
        'background-text-style': string;
        'background-color': string;
        'background-color-top': string;
        'background-color-bottom': string;
        'scroll-top': string;
        'scroll-duration': string;
        'page-style': string;
        'root-font-size': string;
        bindResize: string;
        bindScroll: string;
        bindScrollDone: string;
    };
    Block: {};
    Map: {
        bindTouchStart: string;
        bindTouchMove: string;
        bindTouchEnd: string;
        bindTouchCancel: string;
        bindLongTap: string;
        longitude: string;
        latitude: string;
        scale: string;
        markers: string;
        covers: string;
        polyline: string;
        circles: string;
        controls: string;
        'include-points': string;
        'show-location': string;
        polygons: string;
        subkey: string;
        'layer-style': string;
        rotate: string;
        skew: string;
        'enable-3D': string;
        'show-compass': string;
        'show-scale': string;
        'enable-overlooking': string;
        'enable-zoom': string;
        'enable-scroll': string;
        'enable-rotate': string;
        'enable-satellite': string;
        'enable-traffic': string;
        bindMarkerTap: string;
        bindLabelTap: string;
        bindControlTap: string;
        bindCalloutTap: string;
        bindUpdated: string;
        bindRegionChange: string;
        bindPoiTap: string;
    };
    Slot: {
        name: string;
    };
    SlotView: {
        name: string;
    };
};
export declare const controlledComponent: Set<string>;
export declare const focusComponents: Set<string>;
