"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FRAMEWORK_EXT_MAP = exports.FRAMEWORK_MAP = exports.ENTRY = exports.NPM_DIR = exports.TEMP_DIR = exports.SOURCE_DIR = exports.OUTPUT_DIR = exports.TARO_BASE_CONFIG = exports.TARO_CONFIG_FLODER = exports.DEFAULT_TEMPLATE_SRC_GITEE = exports.DEFAULT_TEMPLATE_SRC = exports.isWindows = exports.DEVICE_RATIO_NAME = exports.taroJsMobxCommon = exports.taroJsMobx = exports.taroJsRedux = exports.taroJsFramework = exports.taroJsQuickAppComponents = exports.taroJsComponents = exports.META_TYPE = exports.UPDATE_PACKAGE_LIST = exports.FILE_PROCESSOR_MAP = exports.DEVICE_RATIO = exports.PROJECT_CONFIG = exports.NODE_MODULES_REG = exports.NODE_MODULES = exports.CSS_IMPORT_REG = exports.REG_URL = exports.REG_WXML_IMPORT = exports.REG_TEMPLATE = exports.REG_UX = exports.REG_JSON = exports.REG_FONT = exports.REG_IMAGE = exports.REG_MEDIA = exports.REG_CSS = exports.REG_STYLE = exports.REG_STYLUS = exports.REG_LESS = exports.REG_SASS_SCSS = exports.REG_SASS_SASS = exports.REG_SASS = exports.REG_VUE = exports.REG_SCRIPTS = exports.REG_TYPESCRIPT = exports.REG_SCRIPT = exports.REG_JS = exports.VUE_EXT = exports.SCRIPT_EXT = exports.UX_EXT = exports.TS_EXT = exports.JS_EXT = exports.SCSS_EXT = exports.CSS_EXT = exports.processTypeMap = exports.processTypeEnum = exports.PLATFORMS = void 0;
const os = require("os");
const chalk = require("chalk");
// eslint-disable-next-line dot-notation
exports.PLATFORMS = global['PLATFORMS'] = global['PLATFORMS'] || {};
var processTypeEnum;
(function (processTypeEnum) {
    processTypeEnum["START"] = "start";
    processTypeEnum["CREATE"] = "create";
    processTypeEnum["COMPILE"] = "compile";
    processTypeEnum["CONVERT"] = "convert";
    processTypeEnum["COPY"] = "copy";
    processTypeEnum["GENERATE"] = "generate";
    processTypeEnum["MODIFY"] = "modify";
    processTypeEnum["ERROR"] = "error";
    processTypeEnum["WARNING"] = "warning";
    processTypeEnum["UNLINK"] = "unlink";
    processTypeEnum["REFERENCE"] = "reference";
    processTypeEnum["REMIND"] = "remind";
})(processTypeEnum = exports.processTypeEnum || (exports.processTypeEnum = {}));
exports.processTypeMap = {
    ["create" /* CREATE */]: {
        name: '创建',
        color: 'cyan'
    },
    ["compile" /* COMPILE */]: {
        name: '编译',
        color: 'green'
    },
    ["convert" /* CONVERT */]: {
        name: '转换',
        color: chalk.rgb(255, 136, 0)
    },
    ["copy" /* COPY */]: {
        name: '拷贝',
        color: 'magenta'
    },
    ["generate" /* GENERATE */]: {
        name: '生成',
        color: 'blue'
    },
    ["modify" /* MODIFY */]: {
        name: '修改',
        color: 'yellow'
    },
    ["error" /* ERROR */]: {
        name: '错误',
        color: 'red'
    },
    ["warning" /* WARNING */]: {
        name: '警告',
        color: 'yellowBright'
    },
    ["unlink" /* UNLINK */]: {
        name: '删除',
        color: 'magenta'
    },
    ["start" /* START */]: {
        name: '启动',
        color: 'green'
    },
    ["reference" /* REFERENCE */]: {
        name: '引用',
        color: 'blue'
    },
    ["remind" /* REMIND */]: {
        name: '提示',
        color: 'green'
    }
};
exports.CSS_EXT = ['.css', '.scss', '.sass', '.less', '.styl', '.stylus', '.wxss', '.acss'];
exports.SCSS_EXT = ['.scss'];
exports.JS_EXT = ['.js', '.jsx'];
exports.TS_EXT = ['.ts', '.tsx'];
exports.UX_EXT = ['.ux'];
exports.SCRIPT_EXT = exports.JS_EXT.concat(exports.TS_EXT);
exports.VUE_EXT = ['.vue'];
exports.REG_JS = /\.js(\?.*)?$/;
exports.REG_SCRIPT = /\.(js|jsx)(\?.*)?$/;
exports.REG_TYPESCRIPT = /\.(tsx|ts)(\?.*)?$/;
exports.REG_SCRIPTS = /\.[tj]sx?$/i;
exports.REG_VUE = /\.vue$/i;
exports.REG_SASS = /\.(s[ac]ss)$/;
exports.REG_SASS_SASS = /\.sass$/;
exports.REG_SASS_SCSS = /\.scss$/;
exports.REG_LESS = /\.less$/;
exports.REG_STYLUS = /\.styl(us)?$/;
exports.REG_STYLE = /\.(css|scss|sass|less|styl|stylus|wxss|acss|ttss|jxss|qss)(\?.*)?$/;
exports.REG_CSS = /\.(css|wxss|acss|ttss)(\?.*)?$/;
exports.REG_MEDIA = /\.(mp4|webm|ogg|mp3|m4a|wav|flac|aac)(\?.*)?$/;
exports.REG_IMAGE = /\.(png|jpe?g|gif|bpm|svg|webp)(\?.*)?$/;
exports.REG_FONT = /\.(woff2?|eot|ttf|otf)(\?.*)?$/;
exports.REG_JSON = /\.json(\?.*)?$/;
exports.REG_UX = /\.ux(\?.*)?$/;
exports.REG_TEMPLATE = /\.(wxml|axml|ttml|qml|swan|jxml)(\?.*)?$/;
exports.REG_WXML_IMPORT = /<import(.*)?src=(?:(?:'([^']*)')|(?:"([^"]*)"))/gi;
exports.REG_URL = /^(?:(?:(?:https?|ftp):)?\/\/)(?:\S+(?::\S*)?@)?(?:(?!(?:10|127)(?:\.\d{1,3}){3})(?!(?:169\.254|192\.168)(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\u00a1-\uffff0-9]-*)*[a-z\u00a1-\uffff0-9]+)(?:\.(?:[a-z\u00a1-\uffff0-9]-*)*[a-z\u00a1-\uffff0-9]+)*(?:\.(?:[a-z\u00a1-\uffff]{2,}))\.?)(?::\d{2,5})?(?:[/?#]\S*)?$/i;
exports.CSS_IMPORT_REG = /@import (["'])(.+?)\1;/g;
exports.NODE_MODULES = 'node_modules';
exports.NODE_MODULES_REG = /(.*)node_modules/;
exports.PROJECT_CONFIG = 'config/index';
exports.DEVICE_RATIO = {
    640: 2.34 / 2,
    750: 1,
    828: 1.81 / 2
};
exports.FILE_PROCESSOR_MAP = {
    '.js': 'babel',
    '.scss': 'sass',
    '.sass': 'sass',
    '.less': 'less',
    '.styl': 'stylus'
};
exports.UPDATE_PACKAGE_LIST = [
    'babel-plugin-transform-taroapi',
    'babel-preset-taro',
    'eslint-config-taro',
    'eslint-plugin-taro',
    'postcss-plugin-constparse',
    'postcss-pxtransform',
    '@tarojs/shared',
    '@tarojs/taro',
    '@tarojs/api',
    '@tarojs/cli',
    '@tarojs/components',
    '@tarojs/taro-h5',
    '@tarojs/helper',
    '@tarojs/taro-loader',
    '@tarojs/mini-runner',
    '@tarojs/react',
    '@tarojs/router',
    '@tarojs/runner-utils',
    '@tarojs/runtime',
    '@tarojs/service',
    '@tarojs/webpack-runner',
    '@tarojs/with-weapp',
    '@tarojs/taroize',
    'nervjs',
    'nerv-devtools'
];
var META_TYPE;
(function (META_TYPE) {
    META_TYPE["ENTRY"] = "ENTRY";
    META_TYPE["PAGE"] = "PAGE";
    META_TYPE["COMPONENT"] = "COMPONENT";
    META_TYPE["NORMAL"] = "NORMAL";
    META_TYPE["STATIC"] = "STATIC";
    META_TYPE["CONFIG"] = "CONFIG";
    META_TYPE["EXPORTS"] = "EXPORTS";
})(META_TYPE = exports.META_TYPE || (exports.META_TYPE = {}));
exports.taroJsComponents = '@tarojs/components';
exports.taroJsQuickAppComponents = '@tarojs/components-qa';
exports.taroJsFramework = '@tarojs/taro';
exports.taroJsRedux = '@tarojs/redux';
exports.taroJsMobx = '@tarojs/mobx';
exports.taroJsMobxCommon = '@tarojs/mobx-common';
exports.DEVICE_RATIO_NAME = 'deviceRatio';
exports.isWindows = os.platform() === 'win32';
exports.DEFAULT_TEMPLATE_SRC = 'github:NervJS/taro-project-templates#v3';
exports.DEFAULT_TEMPLATE_SRC_GITEE = 'direct:https://gitee.com/o2team/taro-project-templates.git#v3';
exports.TARO_CONFIG_FLODER = '.taro3';
exports.TARO_BASE_CONFIG = 'index.json';
exports.OUTPUT_DIR = 'dist';
exports.SOURCE_DIR = 'src';
exports.TEMP_DIR = '.temp';
exports.NPM_DIR = 'npm';
exports.ENTRY = 'app';
var FRAMEWORK_MAP;
(function (FRAMEWORK_MAP) {
    FRAMEWORK_MAP["VUE"] = "vue";
    FRAMEWORK_MAP["VUE3"] = "vue3";
    FRAMEWORK_MAP["REACT"] = "react";
    FRAMEWORK_MAP["NERV"] = "nerv";
})(FRAMEWORK_MAP = exports.FRAMEWORK_MAP || (exports.FRAMEWORK_MAP = {}));
exports.FRAMEWORK_EXT_MAP = {
    vue: exports.VUE_EXT,
    vue3: exports.VUE_EXT,
    react: exports.SCRIPT_EXT,
    nerv: exports.SCRIPT_EXT
};
