"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
function createBabelRegister({ only }) {
    require('@babel/register')({
        only: Array.from(new Set([...only])),
        presets: [
            require.resolve('@babel/preset-env'),
            require.resolve('@babel/preset-typescript')
        ],
        plugins: [
            [require.resolve('@babel/plugin-proposal-decorators'), {
                    legacy: true
                }],
            require.resolve('@babel/plugin-proposal-class-properties'),
            require.resolve('@babel/plugin-proposal-object-rest-spread'),
            [require.resolve('@babel/plugin-transform-runtime'), {
                    corejs: false,
                    helpers: true,
                    regenerator: true,
                    useESModules: false,
                    absoluteRuntime: path.resolve(__dirname, '..', 'node_modules/@babel/runtime')
                }]
        ],
        extensions: ['.jsx', '.js', '.ts', '.tsx'],
        babelrc: false,
        configFile: false,
        cache: false
    });
}
exports.default = createBabelRegister;
