"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.printDevelopmentTip = exports.recursiveReplaceObjectKeys = exports.readDirWithFileTypes = exports.getTemplateSourceType = exports.getAllFilesInFloder = exports.printPkgVersion = exports.getPkgItemByKey = exports.getPkgVersion = exports.getRootPath = void 0;
const fs = require("fs-extra");
const path = require("path");
const helper_1 = require("@tarojs/helper");
function getRootPath() {
    return path.resolve(__dirname, '../../');
}
exports.getRootPath = getRootPath;
function getPkgVersion() {
    return require(path.join(getRootPath(), 'package.json')).version;
}
exports.getPkgVersion = getPkgVersion;
function getPkgItemByKey(key) {
    const packageMap = require(path.join(getRootPath(), 'package.json'));
    if (Object.keys(packageMap).indexOf(key) === -1) {
        return {};
    }
    else {
        return packageMap[key];
    }
}
exports.getPkgItemByKey = getPkgItemByKey;
function printPkgVersion() {
    const taroVersion = getPkgVersion();
    console.log(`👽 Taro v${taroVersion}`);
    console.log();
}
exports.printPkgVersion = printPkgVersion;
exports.getAllFilesInFloder = (floder, filter = []) => __awaiter(void 0, void 0, void 0, function* () {
    let files = [];
    const list = readDirWithFileTypes(floder);
    yield Promise.all(list.map((item) => __awaiter(void 0, void 0, void 0, function* () {
        const itemPath = path.join(floder, item.name);
        if (item.isDirectory) {
            const _files = yield exports.getAllFilesInFloder(itemPath, filter);
            files = [...files, ..._files];
        }
        else if (item.isFile) {
            if (!filter.find(rule => rule === item.name))
                files.push(itemPath);
        }
    })));
    return files;
});
function getTemplateSourceType(url) {
    if (/^github:/.test(url) || /^gitlab:/.test(url) || /^direct:/.test(url)) {
        return 'git';
    }
    else {
        return 'url';
    }
}
exports.getTemplateSourceType = getTemplateSourceType;
function readDirWithFileTypes(floder) {
    const list = fs.readdirSync(floder);
    const res = list.map(name => {
        const stat = fs.statSync(path.join(floder, name));
        return {
            name,
            isDirectory: stat.isDirectory(),
            isFile: stat.isFile()
        };
    });
    return res;
}
exports.readDirWithFileTypes = readDirWithFileTypes;
function recursiveReplaceObjectKeys(obj, keyMap) {
    Object.keys(obj).forEach(key => {
        if (keyMap[key]) {
            obj[keyMap[key]] = obj[key];
            if (typeof obj[key] === 'object') {
                recursiveReplaceObjectKeys(obj[keyMap[key]], keyMap);
            }
            delete obj[key];
        }
        else if (keyMap[key] === false) {
            delete obj[key];
        }
        else if (typeof obj[key] === 'object') {
            recursiveReplaceObjectKeys(obj[key], keyMap);
        }
    });
}
exports.recursiveReplaceObjectKeys = recursiveReplaceObjectKeys;
function printDevelopmentTip(platform) {
    if (process.env.NODE_ENV !== 'production' && process.env.NODE_ENV !== 'test') {
        let exampleCommand;
        if (helper_1.isWindows) {
            exampleCommand = `$ set NODE_ENV=production && taro build --type ${platform} --watch`;
        }
        else {
            exampleCommand = `$ NODE_ENV=production taro build --type ${platform} --watch`;
        }
        console.log(helper_1.chalk.yellowBright(`Tips: 预览模式生成的文件较大，设置 NODE_ENV 为 production 可以开启压缩。
Example:
${exampleCommand}
`));
    }
}
exports.printDevelopmentTip = printDevelopmentTip;
//# sourceMappingURL=index.js.map