"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Template = void 0;
const shared_1 = require("@tarojs/shared");
const util_1 = require("../../util");
const swanSpecialAttrs = {
    'scroll-view': ['scrollTop', 'scrollLeft', 'scrollIntoView'],
    'movable-view': ['x', 'y'],
    slider: ['value'],
    input: ['value'],
    textarea: ['value']
};
class Template extends shared_1.RecursiveTemplate {
    constructor() {
        super(...arguments);
        this.supportXS = true;
        this.Adapter = {
            if: 's-if',
            else: 's-else',
            elseif: 's-elif',
            for: 's-for',
            forItem: 's-for-item',
            forIndex: 's-for-index',
            key: 's-key',
            xs: 'sjs',
            type: 'swan'
        };
        this.modifyLoopBody = (child, nodeName) => {
            if (nodeName === 'text') {
                return `<block>{{ i.${"cn" /* Childnodes */}[index].${"v" /* Text */} }}</block>`;
            }
            return child;
        };
    }
    buildXsTemplate() {
        return '<import-sjs module="xs" src="./utils.sjs" />';
    }
    dataKeymap(keymap) {
        return `{ ${keymap} }`;
    }
    getAttrValue(value, key, nodeName) {
        if (shared_1.isArray(swanSpecialAttrs[nodeName]) && swanSpecialAttrs[nodeName].includes(key)) {
            return `= ${value} =`;
        }
        return `{ ${value} }`;
    }
}
exports.Template = Template;
exports.default = (ctx) => {
    ctx.registerPlatform({
        name: 'swan',
        useConfigName: 'mini',
        fn({ config }) {
            return __awaiter(this, void 0, void 0, function* () {
                const { appPath, nodeModulesPath, outputPath } = ctx.paths;
                const { npm, emptyDirectory } = ctx.helper;
                emptyDirectory(outputPath);
                // ctx.generateFrameworkInfo({
                //   platform: config.platform
                // })
                util_1.printDevelopmentTip('swan');
                // 生成 project.swan.json
                ctx.generateProjectConfig({
                    srcConfigName: 'project.swan.json',
                    distConfigName: 'project.swan.json'
                });
                // 准备 miniRunner 参数
                const miniRunnerOpts = Object.assign(Object.assign({}, config), { nodeModulesPath, buildAdapter: config.platform, isBuildPlugin: false, globalObject: 'swan', fileType: {
                        templ: '.swan',
                        style: '.css',
                        config: '.json',
                        script: '.js',
                        xs: '.sjs'
                    }, isUseComponentBuildPage: true, template: new Template() });
                // build with webpack
                const miniRunner = yield npm.getNpmPkg('@tarojs/mini-runner', appPath);
                yield miniRunner(appPath, miniRunnerOpts);
            });
        }
    });
};
//# sourceMappingURL=swan.js.map