"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const lodash_1 = require("lodash");
const util_1 = require("../../util");
exports.default = (ctx) => {
    ctx.registerPlatform({
        name: 'h5',
        useConfigName: 'h5',
        fn({ config }) {
            return __awaiter(this, void 0, void 0, function* () {
                const { appPath, outputPath, sourcePath } = ctx.paths;
                const { initialConfig } = ctx;
                const { port } = ctx.runOpts;
                const { emptyDirectory, recursiveMerge, npm, ENTRY, SOURCE_DIR, OUTPUT_DIR } = ctx.helper;
                emptyDirectory(outputPath);
                const entryFileName = `${ENTRY}.config`;
                const entryFile = path.basename(entryFileName);
                const defaultEntry = {
                    [ENTRY]: [path.join(sourcePath, entryFile)]
                };
                const customEntry = lodash_1.get(initialConfig, 'h5.entry');
                const h5RunnerOpts = recursiveMerge(Object.assign({}, config), {
                    entryFileName: ENTRY,
                    env: {
                        TARO_ENV: JSON.stringify('h5'),
                        FRAMEWORK: JSON.stringify(config.framework),
                        TARO_VERSION: JSON.stringify(util_1.getPkgVersion())
                    },
                    port,
                    sourceRoot: config.sourceRoot || SOURCE_DIR,
                    outputRoot: config.outputRoot || OUTPUT_DIR
                });
                h5RunnerOpts.entry = lodash_1.merge(defaultEntry, customEntry);
                const webpackRunner = yield npm.getNpmPkg('@tarojs/webpack-runner', appPath);
                webpackRunner(appPath, h5RunnerOpts);
            });
        }
    });
};
//# sourceMappingURL=h5.js.map