"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
exports.default = (ctx) => {
    ctx.registerMethod('writeFileToDist', ({ filePath, content }) => {
        const { outputPath } = ctx.paths;
        const { printLog, processTypeEnum, fs } = ctx.helper;
        if (path.isAbsolute(filePath)) {
            printLog("error" /* ERROR */, 'ctx.writeFileToDist 不能接受绝对路径');
            return;
        }
        const absFilePath = path.join(outputPath, filePath);
        fs.ensureDirSync(path.dirname(absFilePath));
        fs.writeFileSync(absFilePath, content);
    });
};
//# sourceMappingURL=writeFileToDist.js.map