"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const helper_1 = require("@tarojs/helper");
const cli_highlight_1 = require("cli-highlight");
exports.default = (ctx) => {
    ctx.registerCommand({
        name: 'inspect',
        optionsMap: {
            '-t, --type [typeName]': 'Build type, weapp/swan/alipay/tt/h5/quickapp/rn/qq/jd',
            '-o, --output [outputPath]': 'output config to ouputPath'
        },
        synopsisList: [
            'taro inspect --type weapp',
            'taro inspect --type weapp --output inspect.config.js',
            'taro inspect --type weapp plugins',
            'taro inspect --type weapp module.rules.0'
        ],
        fn({ _, options }) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                const { fs, chalk } = ctx.helper;
                const platform = options.type || options.t;
                verifyIsTaroProject(ctx);
                verifyPlatform(platform, chalk);
                process.env.TARO_ENV = platform;
                let config = getConfig(ctx, platform);
                const isProduction = process.env.NODE_ENV === 'production';
                const outputPath = options.output || options.o;
                const mode = outputPath ? 'output' : 'console';
                const extractPath = _[1];
                config = Object.assign(Object.assign({}, config), config[((_a = ctx.platforms.get(platform)) === null || _a === void 0 ? void 0 : _a.useConfigName) || '']);
                delete config.mini;
                delete config.h5;
                yield ctx.applyPlugins({
                    name: platform,
                    opts: {
                        config: Object.assign(Object.assign({}, config), { isWatch: !isProduction, mode: isProduction ? 'production' : 'development', modifyWebpackChain(chain, webpack) {
                                return __awaiter(this, void 0, void 0, function* () {
                                    yield ctx.applyPlugins({
                                        name: 'modifyWebpackChain',
                                        initialVal: chain,
                                        opts: {
                                            chain,
                                            webpack
                                        }
                                    });
                                });
                            }, onWebpackChainReady(chain) {
                                const webpackConfig = chain.toConfig();
                                const { toString } = chain.constructor;
                                const config = extractConfig(webpackConfig, extractPath);
                                const res = toString(config);
                                if (mode === 'console') {
                                    console.log(cli_highlight_1.default(res, { language: 'js' }));
                                }
                                else if (mode === 'output' && outputPath) {
                                    fs.writeFileSync(outputPath, res);
                                }
                                process.exit(0);
                            } })
                    }
                });
            });
        }
    });
};
/** 是否 Taro 项目根路径 */
function verifyIsTaroProject(ctx) {
    const { fs, chalk, PROJECT_CONFIG } = ctx.helper;
    const { configPath } = ctx.paths;
    if (!configPath || !fs.existsSync(configPath)) {
        console.log(chalk.red(`找不到项目配置文件${PROJECT_CONFIG}，请确定当前目录是 Taro 项目根目录!`));
        process.exit(1);
    }
}
/** 检查平台类型 */
function verifyPlatform(platform, chalk) {
    if (typeof platform !== 'string') {
        console.log(chalk.red('请传入正确的编译类型！'));
        process.exit(0);
    }
}
/** 整理 config */
function getConfig(ctx, platform) {
    const { initialConfig } = ctx;
    const sourceDirName = initialConfig.sourceRoot || helper_1.SOURCE_DIR;
    const outputDirName = initialConfig.outputRoot || helper_1.OUTPUT_DIR;
    const sourceDir = path.join(ctx.appPath, sourceDirName);
    const entryFilePath = helper_1.resolveScriptPath(path.join(sourceDir, helper_1.ENTRY));
    const entry = {
        [helper_1.ENTRY]: [entryFilePath]
    };
    return Object.assign(Object.assign({}, initialConfig), { entry, sourceRoot: sourceDirName, outputRoot: outputDirName, platform });
}
/** 按路径取出 webpackConfig 内的对应值 */
function extractConfig(webpackConfig, extractPath) {
    if (!extractPath)
        return webpackConfig;
    const list = extractPath.split('.');
    return list.reduce((config, current) => config[current], webpackConfig);
}
//# sourceMappingURL=inspect.js.map