"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const _ = require("lodash/fp");
const npmCheck = require("npm-check");
const helper_1 = require("@tarojs/helper");
const util_1 = require("../util");
const mustInstalledTaroPkg = [
    '@tarojs/components',
    '@tarojs/runtime',
    '@tarojs/taro',
    '@tarojs/mini-runner',
    '@tarojs/webpack-runner',
    'babel-preset-taro',
    'eslint-config-taro'
];
const cliVersion = util_1.getPkgVersion();
const isPkgInstalled = _.get('isInstalled');
const isPkgNotInstalled = _.negate(isPkgInstalled);
function checkPkgs({ appPath }) {
    return __awaiter(this, void 0, void 0, function* () {
        let errorLines = [];
        const pkgs = yield npmCheck({
            cwd: appPath
        })
            .then(currentState => currentState.get('packages'));
        errorLines = _.concat(errorLines, pkgsNotInstalled(pkgs));
        errorLines = _.concat(errorLines, taroShouldUpdate(pkgs));
        errorLines = _.concat(errorLines, taroOutdate(pkgs));
        errorLines = _.compact(errorLines);
        return {
            desc: '检查依赖',
            lines: errorLines
        };
    });
}
function pkgsNotInstalled(pkgs) {
    const uninstalledPkgs = _.filter(isPkgNotInstalled, pkgs);
    const lines = _.map(pkg => Object({
        desc: `使用到的依赖 ${pkg.moduleName} 还没有安装`,
        valid: false
    }), uninstalledPkgs);
    return lines;
}
function taroShouldUpdate(pkgs) {
    // sort 是为了 UPDATE_PACKAGE_LIST 顺序改变也不影响单测结果
    const list = helper_1.UPDATE_PACKAGE_LIST
        .filter(item => !(/nerv/.test(item)))
        .sort()
        .map(item => {
        const taroPkg = pkgs.find(pkg => pkg.moduleName === item);
        if (!taroPkg) {
            if (!mustInstalledTaroPkg.includes(item))
                return null;
            return {
                desc: `请安装 Taro 依赖: ${item}`,
                valid: true
            };
        }
        const { moduleName, installed, latest } = taroPkg;
        if (installed === cliVersion) {
            if (installed === latest)
                return null;
            return {
                desc: `依赖 ${moduleName} 可更新到最新版本 ${latest}，当前安装版本为 ${installed}`,
                valid: true
            };
        }
        return {
            desc: `依赖 ${moduleName} (${installed}) 与当前使用的 Taro CLI (${cliVersion}) 版本不一致, 请更新为统一的版本`,
            valid: false
        };
    });
    return _.compact(list);
}
function taroOutdate(pkgs) {
    const list = [];
    pkgs.forEach(({ moduleName, isInstalled }) => {
        if (!helper_1.UPDATE_PACKAGE_LIST.includes(moduleName) && /^@tarojs/.test(moduleName)) {
            list.push({
                desc: `Taro 3 不再依赖 ${moduleName}，可以${isInstalled ? '卸载' : '从 package.json 移除'}`,
                valid: true
            });
        }
    });
    return list;
}
exports.default = checkPkgs;
//# sourceMappingURL=packageValidator.js.map