using System.Reflection;
using System.Text;
using SqlParser.Net.Ast.Expression;
using Xunit.Abstractions;

namespace SqlParser.Net.Test;

public class TestHelper
{
    [Fact]
    public void GenerateIAstVisitorAndBaseAstVisitor()
    {
        var sb = new StringBuilder();
        sb.Append("/// <summary>\r\n/// Automatically generated by testHelper\r\n/// </summary>\r\n");
        sb.Append("public interface IAstVisitor\r\n{\r\n");
        var sb2 = new StringBuilder();
        sb2.Append("/// <summary>\r\n/// Automatically generated by testHelper\r\n/// </summary>\r\n");
        sb2.Append("public class BaseAstVisitor : IAstVisitor\r\n{\r\n");
        var expressionList = typeof(SqlExpression).Assembly.DefinedTypes.Where(it => typeof(SqlExpression).IsAssignableFrom(it)&&it!=typeof(SqlExpression)).OrderBy(it=>it.Name).ToList();
        foreach (var typeInfo in expressionList)
        {
            sb.Append($"    void Visit{typeInfo.Name}({typeInfo.Name} {typeInfo.Name.Substring(0, 1).ToLower() + typeInfo.Name.Substring(1)});\r\n");
            sb2.Append($"    public virtual void Visit{typeInfo.Name}({typeInfo.Name} {typeInfo.Name.Substring(0, 1).ToLower() + typeInfo.Name.Substring(1)})\r\n    {{\r\n\r\n    }}\r\n");
        }

        sb.Append("}");
        sb2.Append("}");
        var iAstVisitor = sb.ToString();
        var baseAstVisitor = sb2.ToString();

    }

    [Fact]
    public void GetDatabaseReservedWords()
    {
        var oracleReservedWords = "\r\nACCESS\tELSE\tMODIFY\tSTART\r\nADD\tEXCLUSIVE\tNOAUDIT\tSELECT\r\nALL\tEXISTS\tNOCOMPRESS\tSESSION\r\nALTER\tFILE\tNOT\tSET\r\nAND\tFLOAT\tNOTFOUND\tSHARE\r\nANY\tFOR\tNOWAIT\tSIZE\r\nARRAYLEN\tFROM\tNULL\tSMALLINT\r\nAS\tGRANT\tNUMBER\tSQLBUF\r\nASC\tGROUP\tOF\tSUCCESSFUL\r\nAUDIT\tHAVING\tOFFLINE\tSYNONYM\r\nBETWEEN\tIDENTIFIED\tON\tSYSDATE\r\nBY\tIMMEDIATE\tONLINE\tTABLE\r\nCHAR\tIN\tOPTION\tTHEN\r\nCHECK\tINCREMENT\tOR\tTO\r\nCLUSTER\tINDEX\tORDER\tTRIGGER\r\nCOLUMN\tINITIAL\tPCTFREE\tUID\r\nCOMMENT\tINSERT\tPRIOR\tUNION\r\nCOMPRESS\tINTEGER\tPRIVILEGES\tUNIQUE\r\nCONNECT\tINTERSECT\tPUBLIC\tUPDATE\r\nCREATE\tINTO\tRAW\tUSER\r\nCURRENT\tIS\tRENAME\tVALIDATE\r\nDATE\tLEVEL\tRESOURCE\tVALUES\r\nDECIMAL\tLIKE\tREVOKE\tVARCHAR\r\nDEFAULT\tLOCK\tROW\tVARCHAR2\r\nDELETE\tLONG\tROWID\tVIEW\r\nDESC\tMAXEXTENTS\tROWLABEL\tWHENEVER\r\nDISTINCT\tMINUS\tROWNUM\tWHERE\r\nDROP\tMODE\tROWS\tWITH".Replace("\t", ";").Replace("\r\n", ";").ToLowerInvariant();
        var sqlserverReservedWords= "ADD\r\n\r\nEXTERNAL\r\n\r\nPROCEDURE\r\n\r\nALL\r\n\r\nFETCH\r\n\r\nPUBLIC\r\n\r\nALTER\r\n\r\nFILE\r\n\r\nRAISERROR\r\n\r\nAND\r\n\r\nFILLFACTOR\r\n\r\nREAD\r\n\r\nANY\r\n\r\nFOR\r\n\r\nREADTEXT\r\n\r\nAS\r\n\r\nFOREIGN\r\n\r\nRECONFIGURE\r\n\r\nASC\r\n\r\nFREETEXT\r\n\r\nREFERENCES\r\n\r\nAUTHORIZATION\r\n\r\nFREETEXTTABLE\r\n\r\nREPLICATION\r\n\r\nBACKUP\r\n\r\nFROM\r\n\r\nRESTORE\r\n\r\nBEGIN\r\n\r\nFULL\r\n\r\nRESTRICT\r\n\r\nBETWEEN\r\n\r\nFUNCTION\r\n\r\nRETURN\r\n\r\nBREAK\r\n\r\nGOTO\r\n\r\nREVERT\r\n\r\nBROWSE\r\n\r\nGRANT\r\n\r\nREVOKE\r\n\r\nBULK\r\n\r\nGROUP\r\n\r\nRIGHT\r\n\r\nBY\r\n\r\nHAVING\r\n\r\nROLLBACK\r\n\r\nCASCADE\r\n\r\nHOLDLOCK\r\n\r\nROWCOUNT\r\n\r\nCASE\r\n\r\nIDENTITY\r\n\r\nROWGUIDCOL\r\n\r\nCHECK\r\n\r\nIDENTITY_INSERT\r\n\r\nRULE\r\n\r\nCHECKPOINT\r\n\r\nIDENTITYCOL\r\n\r\nSAVE\r\n\r\nCLOSE\r\n\r\nIF\r\n\r\nSCHEMA\r\n\r\nCLUSTERED\r\n\r\nIN\r\n\r\nSECURITYAUDIT\r\n\r\nCOALESCE\r\n\r\nINDEX\r\n\r\nSELECT\r\n\r\nCOLLATE\r\n\r\nINNER\r\n\r\nSEMANTICKEYPHRASETABLE\r\n\r\nCOLUMN\r\n\r\nINSERT\r\n\r\nSEMANTICSIMILARITYDETAILSTABLE\r\n\r\nCOMMIT\r\n\r\nINTERSECT\r\n\r\nSEMANTICSIMILARITYTABLE\r\n\r\nCOMPUTE\r\n\r\nINTO\r\n\r\nSESSION_USER\r\n\r\nCONSTRAINT\r\n\r\nIS\r\n\r\nSET\r\n\r\nCONTAINS\r\n\r\nJOIN\r\n\r\nSETUSER\r\n\r\nCONTAINSTABLE\r\n\r\nKEY\r\n\r\nSHUTDOWN\r\n\r\nCONTINUE\r\n\r\nKILL\r\n\r\nSOME\r\n\r\nCONVERT\r\n\r\nLEFT\r\n\r\nSTATISTICS\r\n\r\nCREATE\r\n\r\nLIKE\r\n\r\nSYSTEM_USER\r\n\r\nCROSS\r\n\r\nLINENO\r\n\r\nTABLE\r\n\r\nCURRENT\r\n\r\nLOAD\r\n\r\nTABLESAMPLE\r\n\r\nCURRENT_DATE\r\n\r\nMERGE\r\n\r\nTEXTSIZE\r\n\r\nCURRENT_TIME\r\n\r\nNATIONAL\r\n\r\nTHEN\r\n\r\nCURRENT_TIMESTAMP\r\n\r\nNOCHECK\r\n\r\nTO\r\n\r\nCURRENT_USER\r\n\r\nNONCLUSTERED\r\n\r\nTOP\r\n\r\nCURSOR\r\n\r\nNOT\r\n\r\nTRAN\r\n\r\nDATABASE\r\n\r\nNULL\r\n\r\nTRANSACTION\r\n\r\nDBCC\r\n\r\nNULLIF\r\n\r\nTRIGGER\r\n\r\nDEALLOCATE\r\n\r\nOF\r\n\r\nTRUNCATE\r\n\r\nDECLARE\r\n\r\nOFF\r\n\r\nTRY_CONVERT\r\n\r\nDEFAULT\r\n\r\nOFFSETS\r\n\r\nTSEQUAL\r\n\r\nDELETE\r\n\r\nON\r\n\r\nUNION\r\n\r\nDENY\r\n\r\nOPEN\r\n\r\nUNIQUE\r\n\r\nDESC\r\n\r\nOPENDATASOURCE\r\n\r\nUNPIVOT\r\n\r\nDISK\r\n\r\nOPENQUERY\r\n\r\nUPDATE\r\n\r\nDISTINCT\r\n\r\nOPENROWSET\r\n\r\nUPDATETEXT\r\n\r\nDISTRIBUTED\r\n\r\nOPENXML\r\n\r\nUSE\r\n\r\nDOUBLE\r\n\r\nOPTION\r\n\r\nUSER\r\n\r\nDROP\r\n\r\nOR\r\n\r\nVALUES\r\n\r\nDUMP\r\n\r\nORDER\r\n\r\nVARYING\r\n\r\nELSE\r\n\r\nOUTER\r\n\r\nVIEW\r\n\r\nEND\r\n\r\nOVER\r\n\r\nWAITFOR\r\n\r\nERRLVL\r\n\r\nPERCENT\r\n\r\nWHEN\r\n\r\nESCAPE\r\n\r\nPIVOT\r\n\r\nWHERE\r\n\r\nEXCEPT\r\n\r\nPLAN\r\n\r\nWHILE\r\n\r\nEXEC\r\n\r\nPRECISION\r\n\r\nWITH\r\n\r\nEXECUTE\r\n\r\nPRIMARY\r\n\r\nWITHIN GROUP\r\n\r\nEXISTS\r\n\r\nPRINT\r\n\r\nWRITETEXT\r\n\r\nEXIT\r\n\r\nPROC".Replace("\r\n\r\n", ";").ToLowerInvariant();
    }


}