/*
 * Decompiled with CFR 0.152.
 */
package utils;

import burp.BurpExtender;
import entity.MatchResult;
import entity.Rule;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import matcher.impl.JsonMatcher;
import matcher.impl.XmlMatcher;
import utils.Util;

public class RuleMannager {
    public static MatchResult match(String str, Rule rule) {
        switch (rule.getType()) {
            case 0: {
                return RuleMannager.matchRsqData(str);
            }
            case 1: {
                return RuleMannager.matchByRegular(str, rule.getRule());
            }
            case 2: {
                return RuleMannager.matchByPosistion(str, rule.getnStart(), rule.getnEnd());
            }
            case 3: {
                return RuleMannager.matchByStartEndString(str, rule.getStrStart(), rule.getStrEnd());
            }
            case 4: {
                JsonMatcher jsonMatcher = new JsonMatcher();
                return jsonMatcher.match(str, rule.getRule());
            }
            case 5: {
                XmlMatcher xmlMatcher = new XmlMatcher();
                return xmlMatcher.match(str, rule.getRule());
            }
        }
        MatchResult result = new MatchResult();
        result.setResult("unkown rule type");
        return result;
    }

    public static MatchResult matchRsqData(String str) {
        MatchResult result = new MatchResult();
        String res = new String(Util.getRspBody(str.getBytes()));
        int bodyOffset = str.indexOf(res);
        result.setStart(bodyOffset);
        result.setEnd(bodyOffset + res.length());
        result.setResult(res);
        return result;
    }

    public static MatchResult matchByRegular(String str, String regular) {
        MatchResult result = new MatchResult();
        String res = null;
        int start = 0;
        int end = 0;
        Pattern r = Pattern.compile(regular);
        Matcher m = r.matcher(str);
        if (m.find()) {
            res = m.group(1);
            start = m.start();
            int n = str.substring(start, str.length()).indexOf(res);
            end = (start += n) + res.length();
        }
        result.setResult(res);
        result.setStart(start);
        result.setEnd(end);
        return result;
    }

    public static MatchResult matchByPosistion(String str, int start, int end) {
        MatchResult result = new MatchResult();
        result.setStart(start);
        result.setEnd(end);
        result.setResult(str.substring(start, end));
        return result;
    }

    public static MatchResult matchByStartEndString(String str, String start, String end) {
        int nStart = str.indexOf(start) + start.length();
        int nEnd = str.indexOf(end);
        MatchResult result = new MatchResult();
        result.setStart(nStart);
        result.setEnd(nEnd);
        result.setResult(str.substring(nStart, nEnd));
        return result;
    }

    public static String generateRegular(String raw, int start, int end) {
        int newStart = start;
        int newEnd = end;
        String startStr = "";
        String endStr = "";
        String target = raw.substring(start, end);
        String strReg = "";
        if (start > 3) {
            newStart -= 3;
        } else if (start > 1) {
            --newStart;
        }
        if (end < raw.length() - 3) {
            newEnd += 3;
        }
        for (int i = 0; i < raw.length(); ++i) {
            startStr = raw.substring(newStart, start);
            startStr = Util.escapeExprSpecialWord(startStr);
            endStr = raw.substring(end, newEnd);
            endStr = Util.escapeExprSpecialWord(endStr);
            strReg = String.format("%s(.*?)%s", startStr, endStr);
            System.out.println("---------------------------------------");
            System.out.println(strReg);
            BurpExtender.stderr.println("------------------------------");
            BurpExtender.stderr.println("[+] " + target);
            BurpExtender.stderr.println(strReg);
            if (RuleMannager.matchByRegular(raw, strReg).getResult().equals(target) || newStart == 0 && newEnd == raw.length()) break;
            if (newStart > 0) {
                --newStart;
            }
            if (newEnd >= raw.length()) continue;
            ++newEnd;
        }
        return strReg;
    }

    public static String generatePositionRule(int start, int end) {
        String rule = String.format("{\"start\":%d,\"end\":%d}", start, end);
        return rule;
    }

    public static String generateStartEndRule(String raw, int start, int end) {
        int endPosition;
        int startPosition;
        String keyword = raw.substring(start, end);
        String strStart = "";
        int e = end;
        String strEnd = "";
        for (int s = start; s >= 0 && (startPosition = raw.indexOf(strStart = raw.substring(s, start)) + strStart.length()) != start; --s) {
        }
        while (e <= raw.length() && (endPosition = raw.indexOf(strEnd = raw.substring(end, e))) != end) {
            ++e;
        }
        strStart = Util.escapeJsonString(strStart);
        strEnd = Util.escapeJsonString(strEnd);
        String rule = String.format("{\"start\":\"%s\",\"end\":\"%s\"}", strStart, strEnd);
        if (RuleMannager.matchByStartEndString(raw, strStart, strEnd).getResult().equals(keyword)) {
            return rule;
        }
        return "generate rule fail,try again";
    }

    public static void main(String[] args) {
        String str = RuleMannager.generateStartEndRule("absdsdsdbsdsfwewwfwfwdsdddcdesdfsdffghijkweweefewffsadfssdgslmnopqrsdsdst", 12, 34);
    }
}

