/*
 * Decompiled with CFR 0.152.
 */
package utils;

import burp.BurpExtender;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import utils.Util;

public class LableParser {
    private byte[] byteImage;

    public LableParser(byte[] byteImage) {
        this.byteImage = byteImage;
    }

    public String parseAllLable(String str) throws IOException {
        String reqTpl = str;
        while (reqTpl.indexOf("<@") >= 0) {
            reqTpl = this.parseOneLable(reqTpl);
        }
        if (reqTpl.indexOf("[base64]") >= 0) {
            String b64encode = reqTpl.substring(reqTpl.indexOf("[base64]") + 8, reqTpl.lastIndexOf("[base64]"));
            String b64decode = new String(Util.base64Decode(b64encode));
            reqTpl = reqTpl.replace(String.format("[base64]%s[base64]", b64encode), b64decode);
        }
        return reqTpl;
    }

    private String parseOneLable(String str) throws IOException {
        String parseRes = "";
        String lable = str.substring(str.indexOf("<@") + 2, str.indexOf(">"));
        if (!lable.equals(null) && !lable.trim().equals("")) {
            String prefix = String.format("<@%s>", lable);
            String suffix = String.format("</@%s>", lable);
            String allContent = str.substring(str.indexOf(prefix), str.indexOf(suffix) + suffix.length());
            String subContent = str.substring(str.indexOf(prefix) + prefix.length(), str.indexOf(suffix));
            if (subContent.indexOf("<@") >= 0 && subContent.indexOf(">") >= 0) {
                str = str.replace(subContent, this.parseOneLable(subContent));
                allContent = str.substring(str.indexOf(prefix), str.indexOf(suffix) + suffix.length());
                subContent = str.substring(str.indexOf(prefix) + prefix.length(), str.indexOf(suffix));
                parseRes = str.replace(allContent, this.encdoeLable(lable, subContent));
            } else {
                parseRes = str.replace(allContent, this.encdoeLable(lable, subContent));
            }
        }
        return parseRes;
    }

    private String parseOneLableByRegular(String str) throws IOException {
        String parseRes = "";
        String regular1 = "<@(.*?)>";
        String lable = Util.matchByRegular(str, regular1);
        if (!lable.equals(null) && !lable.trim().equals("")) {
            String regular2 = String.format("<@%s>(.*?)</@%s>", lable, lable);
            String all_content = Util.matchByRegular(str, regular2, 0);
            String content = Util.matchByRegular(str, regular2, 1);
            String sublable = Util.matchByRegular(content, regular1);
            if (!sublable.equals(null) && !sublable.trim().equals("")) {
                str = str.replace(content, this.parseOneLable(content));
                content = Util.matchByRegular(str, regular2, 1);
                all_content = Util.matchByRegular(str, regular2, 0);
                parseRes = str.replace(all_content, this.encdoeLable(lable, content));
            } else {
                parseRes = str.replace(all_content, this.encdoeLable(lable, content));
            }
        }
        return parseRes;
    }

    private String encdoeLable(String type, String str) throws IOException {
        String encodeStr = "";
        switch (type) {
            case "BASE64": {
                if (str.startsWith("[base64]")) {
                    str = str.replace("[base64]", "");
                    encodeStr = Util.base64Encode(Util.base64Decode(str));
                    break;
                }
                encodeStr = Util.base64Encode(str);
                break;
            }
            case "URLENCODE": {
                if (str.startsWith("[base64]")) {
                    str = str.replace("[base64]", "");
                    byte[] byteRes = Util.base64Decode(str);
                    encodeStr = Util.URLEncode(new String(byteRes));
                    break;
                }
                encodeStr = Util.URLEncode(str);
                break;
            }
            case "IMG_RAW": {
                String strr = new String(this.byteImage);
                String words = BurpExtender.gui.tfWords.getText();
                if (!words.trim().equals("") && strr.contains(words)) {
                    this.byteImage = Util.dataimgToimg(strr, words);
                } else if (strr.contains("data:image") || strr.contains("data%3Aimage")) {
                    strr = strr.replace("\\r\\n", "").replace("\\n", "");
                    strr = strr.replace("\\", "");
                    String pattern = "(data:image.*?)[\"|&]|(data%2Aimage.*?)[\"|&]";
                    Pattern r = Pattern.compile(pattern);
                    Matcher m = r.matcher(strr);
                    if (m.find()) {
                        strr = m.group(0).replace("\"", "").replace("&", "").replace("Base64:", "").replace("base64:", "");
                    }
                    if (!strr.contains("data:image")) {
                        strr = "o;base64," + strr;
                    }
                    this.byteImage = DatatypeConverter.parseBase64Binary(strr.substring(strr.indexOf(",") + 1));
                }
                String base64Img = Util.base64Encode(this.byteImage);
                encodeStr = "[base64]" + base64Img + "[base64]";
                break;
            }
            default: {
                encodeStr = str;
            }
        }
        return encodeStr;
    }

    public static void main(String[] args) {
        String reqTpl = "a[base64]eHh4[base64]b";
        String base64encode = reqTpl.substring(reqTpl.indexOf("[base64]") + 8, reqTpl.lastIndexOf("[base64]"));
        String base64decode = new String(Util.base64Decode(base64encode));
        String str = reqTpl.replace(String.format("[base64]%s[base64]", base64encode), base64decode);
    }
}

