/*
 * Decompiled with CFR 0.152.
 */
package utils;

import burp.BurpExtender;
import burp.IHttpRequestResponse;
import burp.IRequestInfo;
import entity.HttpService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import utils.LableParser;
import utils.Util;

public class HttpClient {
    private String url;
    private String protocol;
    private String method;
    private String httpversion;
    private String host;
    private int port;
    private String path;
    private HttpService service;
    private Map<String, String> headers = new HashMap<String, String>();
    private String data;
    private String raw;
    private byte[] byteImg;

    public HttpClient(String url, String raw, byte[] byteImg) throws IOException {
        this.url = url;
        this.raw = this.processLine(raw);
        this.byteImg = byteImg;
        this.parseLabel();
        this.parserRequest();
        this.updateContentLength();
    }

    public String processLine(String reqraw) {
        String method = null;
        String header = null;
        String body = null;
        String request = null;
        if (reqraw.startsWith("GET")) {
            method = "GET";
        } else if (reqraw.startsWith("POST")) {
            method = "POST";
        } else {
            method = "unkown";
            return reqraw;
        }
        if (method.equals("GET")) {
            header = reqraw;
            header.replace("\r\n", "\n");
            header.replace("\n", "\r\n");
            request = header;
        }
        if (method.equals("POST")) {
            int n = reqraw.indexOf("\n\n") != -1 ? reqraw.indexOf("\n\n") : reqraw.indexOf("\r\n\r\n");
            header = reqraw.substring(0, n).trim();
            body = reqraw.substring(n + 1, reqraw.length()).trim();
            if (header.indexOf("\n") >= 0 && header.indexOf("\r\n") < 0) {
                header = header.replace("\n", "\r\n");
            }
            request = header + "\r\n\r\n" + body;
        }
        return request;
    }

    public String getHttpService() {
        return this.service.toString();
    }

    public String getRaw() {
        return this.raw;
    }

    public void parseLabel() throws IOException {
        LableParser parser = new LableParser(this.byteImg);
        this.raw = parser.parseAllLable(this.raw);
    }

    private void parserRequest() {
        this.service = new HttpService(this.url);
        try {
            IRequestInfo requestInfo = BurpExtender.helpers.analyzeRequest(this.service, this.raw.getBytes());
            requestInfo.getBodyOffset();
            this.method = requestInfo.getMethod();
            for (String header : requestInfo.getHeaders()) {
                String value;
                if (header.indexOf(this.method) >= 0 && header.indexOf("HTTP/") >= 0) {
                    this.path = header.split(" ")[1];
                    this.httpversion = header.split(" ")[2];
                    continue;
                }
                if (header.indexOf(":") <= 0) continue;
                String key = header.substring(0, header.indexOf(":"));
                try {
                    value = Util.trimStart(header.substring(header.indexOf(":") + 1));
                }
                catch (Exception e) {
                    value = header.substring(header.indexOf(":") + 1);
                }
                if (value.equals("")) {
                    value = " ";
                }
                this.headers.put(key, value);
            }
            if (this.method.equals("POST")) {
                this.data = this.raw.substring(requestInfo.getBodyOffset(), this.raw.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parserRequestOld() {
        if (Util.isURL(this.url)) {
            this.service = new HttpService(this.url);
            String[] rawsArray = this.raw.split(System.lineSeparator());
            try {
                for (int i = 0; i < rawsArray.length; ++i) {
                    if (i == 0) {
                        this.method = rawsArray[0].split(" ")[0];
                        this.path = rawsArray[0].split(" ")[1];
                        this.httpversion = rawsArray[0].split(" ")[2];
                        continue;
                    }
                    if (this.method.equals("POST") && i == rawsArray.length - 1) {
                        this.data = rawsArray[i].trim();
                        continue;
                    }
                    if (rawsArray[i].indexOf(": ") <= 0) continue;
                    String key = rawsArray[i].split(": ")[0];
                    String value = rawsArray[i].split(": ")[1];
                    this.headers.put(key.trim(), value.trim());
                }
            }
            catch (Exception e) {
                BurpExtender.stdout.println(e.getMessage());
            }
        }
    }

    public void updateContentLength() {
        if (this.method.equals("POST")) {
            int length = this.data.length();
            this.headers.put("Content-Length", String.valueOf(length));
            String reqLine = String.format("%s %s %s", this.method, this.path, this.httpversion);
            reqLine = reqLine + "\r\n";
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                String line = String.format("%s: %s", header.getKey(), header.getValue());
                reqLine = reqLine + line;
                reqLine = reqLine + "\r\n";
            }
            reqLine = reqLine + "\r\n";
            this.raw = reqLine = reqLine + this.data;
        }
    }

    public byte[] doReust() {
        byte[] req = this.raw.getBytes();
        try {
            IHttpRequestResponse reqrsp = BurpExtender.callbacks.makeHttpRequest(this.service, req);
            byte[] response = reqrsp.getResponse();
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            BurpExtender.stderr.println(e);
            return null;
        }
    }
}

