/*
 * Decompiled with CFR 0.152.
 */
package ui.model;

import burp.BurpExtender;
import entity.CaptchaEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.xml.bind.DatatypeConverter;
import ui.GUI;
import utils.Util;

public class TableModel
extends AbstractTableModel {
    private List<String> title = new ArrayList<String>();
    private JTable table;

    public TableModel(JTable table) {
        this.table = table;
        this.title.add(0, "\u9a8c\u8bc1\u7801");
        this.title.add(1, "\u8bc6\u522b\u7ed3\u679c");
    }

    @Override
    public String getColumnName(int column) {
        return this.title.get(column);
    }

    @Override
    public int getRowCount() {
        return GUI.captcha.size();
    }

    @Override
    public int getColumnCount() {
        return this.title.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Icon.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        CaptchaEntity captcha = GUI.captcha.get(row);
        try {
            switch (column) {
                case 0: {
                    String strr = new String(captcha.getImage());
                    String words = BurpExtender.gui.getTfwords().getText();
                    if (!words.equals("") && strr.contains(words)) {
                        byte[] byteImage = Util.dataimgToimg(new String(captcha.getImage()), words);
                        ImageIcon icon = Util.byte2img(byteImage);
                        this.table.setRowHeight(row, icon.getIconHeight() + 5);
                        return icon;
                    }
                    if (strr.contains("data:image") || strr.contains("data%3Aimage")) {
                        String pattern = "(data:image.*?)[\"|&]|(data%2Aimage.*?)[\"|&]";
                        Pattern r = Pattern.compile(pattern);
                        Matcher m = r.matcher(strr);
                        if (m.find()) {
                            strr = m.group(0).replace("\"", "").replace("&", "").replace("Base64:", "").replace("base64:", "");
                        }
                        if (!strr.contains("data:image")) {
                            strr = "data:image/jpeg;base64," + strr;
                        }
                        System.out.println("*****");
                        System.out.println(strr);
                        strr = strr.replace("\\r\\n", "").replace("\\n", "");
                        strr = strr.replace("\\", "");
                        byte[] byteImage = DatatypeConverter.parseBase64Binary(strr.substring(strr.indexOf(",") + 1));
                        ImageIcon icon = Util.byte2img(byteImage);
                        this.table.setRowHeight(row, icon.getIconHeight() + 5);
                        return icon;
                    }
                    ImageIcon icon = Util.byte2img(captcha.getImage());
                    this.table.setRowHeight(row, icon.getIconHeight() + 5);
                    return icon;
                }
                case 1: {
                    return captcha.getResult();
                }
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }
}

