/*
 * Decompiled with CFR 0.152.
 */
package matcher.impl;

import entity.MatchResult;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import matcher.IMathcher;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import utils.Util;

public class XmlMatcher
implements IMathcher {
    private List<String> result = new ArrayList<String>();
    private List<String> keywords = new ArrayList<String>();

    @Override
    public MatchResult match(String strResponse, String keyword) {
        MatchResult matchResult = new MatchResult();
        String rsqData = new String(Util.getRspBody(strResponse.getBytes()));
        try {
            SAXReader sax = new SAXReader();
            Document document = sax.read(new ByteArrayInputStream(rsqData.getBytes()));
            Element root = document.getRootElement();
            this.searchXml(root, keyword);
            if (this.result.size() != 0) {
                String res = this.result.get(0);
                int start = rsqData.indexOf(res);
                int end = start + res.length();
                matchResult.setResult(res);
                matchResult.setStart(start);
                matchResult.setEnd(end);
            } else {
                matchResult.setResult("Alert: No match to");
            }
        }
        catch (Exception e) {
            matchResult.setResult(String.format("Error: %s", e.getMessage()));
        }
        return matchResult;
    }

    @Override
    public String buildKeyword(String strResponse, String value) {
        String keyword = null;
        String rsqData = new String(Util.getRspBody(strResponse.getBytes()));
        try {
            SAXReader sax = new SAXReader();
            Document document = sax.read(new ByteArrayInputStream(rsqData.getBytes()));
            Element root = document.getRootElement();
            this.buildKeyword(root, value, null);
            keyword = this.keywords.size() != 0 ? this.keywords.get(0) : "build keyword fail!";
        }
        catch (Exception e) {
            keyword = String.format("build keyword error: %s", e.getMessage());
        }
        return keyword;
    }

    protected void searchXml(Element node, String keyword) {
        String[] fs = keyword.split("\\.");
        String current_keyword = fs[0];
        String attr_name = null;
        String new_keyword = null;
        if (current_keyword.contains("#")) {
            attr_name = current_keyword.split("#")[1];
            current_keyword = current_keyword.split("#")[0];
        }
        new_keyword = fs.length != 1 ? keyword.replace(current_keyword + ".", "") : current_keyword;
        if (node.getName().equals(current_keyword)) {
            if (attr_name != null) {
                List<Attribute> listAttr = node.attributes();
                for (Attribute attr : listAttr) {
                    if (!attr.getName().equals(attr_name)) continue;
                    this.result.add(attr.getValue());
                }
                return;
            }
            if (fs.length == 1) {
                this.result.add(node.getTextTrim());
            } else {
                List<Element> listElement = node.elements();
                for (Element e : listElement) {
                    this.searchXml(e, new_keyword);
                }
            }
        } else {
            List<Element> listElement = node.elements();
            for (Element e : listElement) {
                this.searchXml(e, keyword);
            }
        }
    }

    protected void buildKeyword(Element node, String val, String keyword) {
        if (keyword == null) {
            keyword = "";
        }
        String kw = keyword;
        kw = kw + (keyword.equals("") ? node.getName() : "." + node.getName());
        if (node.getTextTrim().equals(val)) {
            this.keywords.add(kw);
        }
        List<Attribute> listAttr = node.attributes();
        for (Attribute attr : listAttr) {
            if (!attr.getValue().equals(val)) continue;
            String attrkw = kw;
            attrkw = attrkw + "#" + attr.getName();
            this.keywords.add(attrkw);
        }
        List<Element> listElement = node.elements();
        for (Element e : listElement) {
            this.buildKeyword(e, val, kw);
        }
    }
}

