/*
 * Decompiled with CFR 0.152.
 */
package entity;

import burp.BurpExtender;
import burp.IHttpService;
import java.net.MalformedURLException;
import java.net.URL;

public class HttpService
implements IHttpService {
    private String protocol;
    private String host;
    private int port;

    public HttpService(String url) {
        this.protocol = url.startsWith("https://") ? "https" : "http";
        try {
            URL u = new URL(url);
            this.protocol = u.getProtocol();
            this.host = u.getHost();
            this.port = u.getPort() == -1 ? (this.protocol.equals("https") ? 443 : 80) : u.getPort();
        }
        catch (MalformedURLException e) {
            BurpExtender.stderr.println("[-] " + e.getMessage());
        }
    }

    public HttpService(String protocol, String host, int port) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String toString() {
        return String.format("%s://%s:%d", this.protocol, this.host, this.port);
    }
}

