/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.operations.ExecuteTestBuildOperationType;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.build.event.types.AbstractTestResult;
import org.gradle.internal.build.event.types.DefaultFailure;
import org.gradle.internal.build.event.types.DefaultTestDescriptor;
import org.gradle.internal.build.event.types.DefaultTestFailureResult;
import org.gradle.internal.build.event.types.DefaultTestFinishedProgressEvent;
import org.gradle.internal.build.event.types.DefaultTestSkippedResult;
import org.gradle.internal.build.event.types.DefaultTestStartedProgressEvent;
import org.gradle.internal.build.event.types.DefaultTestSuccessResult;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.provider.runner.BuildOperationMapper;
import org.gradle.tooling.internal.provider.runner.BuildOperationTracker;
import org.gradle.tooling.internal.provider.runner.TestTaskExecutionTracker;

class TestOperationMapper
implements BuildOperationMapper<ExecuteTestBuildOperationType.Details, DefaultTestDescriptor> {
    private final TestTaskExecutionTracker taskTracker;

    TestOperationMapper(TestTaskExecutionTracker taskTracker) {
        this.taskTracker = taskTracker;
    }

    @Override
    public boolean isEnabled(BuildEventSubscriptions subscriptions) {
        return subscriptions.isRequested(OperationType.TEST);
    }

    @Override
    public Class<ExecuteTestBuildOperationType.Details> getDetailsType() {
        return ExecuteTestBuildOperationType.Details.class;
    }

    @Override
    public List<? extends BuildOperationTracker> getTrackers() {
        return ImmutableList.of((Object)this.taskTracker);
    }

    @Override
    public DefaultTestDescriptor createDescriptor(ExecuteTestBuildOperationType.Details details, BuildOperationDescriptor buildOperation, @Nullable OperationIdentifier parent) {
        TestDescriptorInternal testDescriptor = (TestDescriptorInternal)details.getTestDescriptor();
        return testDescriptor.isComposite() ? this.toTestDescriptorForSuite(buildOperation.getId(), parent, testDescriptor) : this.toTestDescriptorForTest(buildOperation.getId(), parent, testDescriptor);
    }

    @Override
    public InternalOperationStartedProgressEvent createStartedEvent(DefaultTestDescriptor descriptor, ExecuteTestBuildOperationType.Details details, OperationStartEvent startEvent) {
        return new DefaultTestStartedProgressEvent(details.getStartTime(), descriptor);
    }

    @Override
    public InternalOperationFinishedProgressEvent createFinishedEvent(DefaultTestDescriptor descriptor, ExecuteTestBuildOperationType.Details details, OperationFinishEvent finishEvent) {
        TestResult testResult = ((ExecuteTestBuildOperationType.Result)finishEvent.getResult()).getResult();
        return new DefaultTestFinishedProgressEvent(testResult.getEndTime(), descriptor, TestOperationMapper.adapt(testResult));
    }

    private DefaultTestDescriptor toTestDescriptorForSuite(OperationIdentifier buildOperationId, OperationIdentifier parentId, TestDescriptorInternal suite) {
        String name = suite.getName();
        String displayName = TestOperationMapper.backwardsCompatibleDisplayNameOf(suite);
        String testKind = "SUITE";
        String className = suite.getClassName();
        String methodName = null;
        String testTaskPath = this.taskTracker.getTaskPath(buildOperationId);
        return new DefaultTestDescriptor(buildOperationId, name, displayName, testKind, suite.getName(), className, methodName, parentId, testTaskPath);
    }

    private DefaultTestDescriptor toTestDescriptorForTest(OperationIdentifier buildOperationId, OperationIdentifier parentId, TestDescriptorInternal test) {
        String name = test.getName();
        String displayName = TestOperationMapper.backwardsCompatibleDisplayNameOf(test);
        String testKind = "ATOMIC";
        String className = test.getClassName();
        String methodName = test.getName();
        String taskPath = this.taskTracker.getTaskPath(buildOperationId);
        return new DefaultTestDescriptor(buildOperationId, name, displayName, testKind, null, className, methodName, parentId, taskPath);
    }

    private static String backwardsCompatibleDisplayNameOf(TestDescriptorInternal descriptor) {
        String className = descriptor.getClassName();
        String methodName = descriptor.getName();
        String displayName = descriptor.getDisplayName();
        if (methodName != null && methodName.equals(displayName) || className != null && className.equals(displayName)) {
            return descriptor.toString();
        }
        return displayName;
    }

    private static AbstractTestResult adapt(TestResult result) {
        TestResult.ResultType resultType = result.getResultType();
        switch (resultType) {
            case SUCCESS: {
                return new DefaultTestSuccessResult(result.getStartTime(), result.getEndTime());
            }
            case SKIPPED: {
                return new DefaultTestSkippedResult(result.getStartTime(), result.getEndTime());
            }
            case FAILURE: {
                return new DefaultTestFailureResult(result.getStartTime(), result.getEndTime(), TestOperationMapper.convertExceptions(result.getExceptions()));
            }
        }
        throw new IllegalStateException("Unknown test result type: " + resultType);
    }

    private static List<DefaultFailure> convertExceptions(List<Throwable> exceptions) {
        ArrayList<DefaultFailure> failures = new ArrayList<DefaultFailure>(exceptions.size());
        for (Throwable exception : exceptions) {
            failures.add(DefaultFailure.fromThrowable((Throwable)exception));
        }
        return failures;
    }
}

