/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import com.google.common.collect.ImmutableList;
import groovy.lang.Closure;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.FeatureSpec;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.JavaResolutionConsistency;
import org.gradle.api.plugins.internal.DefaultJavaFeatureSpec;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.Actions;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.jvm.toolchain.internal.ToolchainSpecInternal;
import org.gradle.util.internal.ConfigureUtil;

public class DefaultJavaPluginExtension
implements JavaPluginExtension {
    private static final Pattern VALID_FEATURE_NAME = Pattern.compile("[a-zA-Z0-9]+");
    private final SourceSetContainer sourceSets;
    private final ToolchainSpecInternal toolchainSpec;
    private final ObjectFactory objectFactory;
    private final SoftwareComponentContainer components;
    private final ModularitySpec modularity;
    private final JvmPluginServices jvmPluginServices;
    private final JavaToolchainSpec toolchain;
    private final ProjectInternal project;
    private final DirectoryProperty docsDir;
    private final DirectoryProperty testResultsDir;
    private final DirectoryProperty testReportDir;
    private JavaVersion srcCompat;
    private JavaVersion targetCompat;
    private boolean autoTargetJvm = true;

    public DefaultJavaPluginExtension(ProjectInternal project, SourceSetContainer sourceSets, DefaultToolchainSpec toolchainSpec, JvmPluginServices jvmPluginServices) {
        this.docsDir = project.getObjects().directoryProperty();
        this.testResultsDir = project.getObjects().directoryProperty();
        this.testReportDir = project.getObjects().directoryProperty();
        this.project = project;
        this.sourceSets = sourceSets;
        this.toolchainSpec = toolchainSpec;
        this.objectFactory = project.getObjects();
        this.components = project.getComponents();
        this.modularity = (ModularitySpec)this.objectFactory.newInstance(DefaultModularitySpec.class, new Object[0]);
        this.jvmPluginServices = jvmPluginServices;
        this.toolchain = toolchainSpec;
        this.configureDefaults();
    }

    private void configureDefaults() {
        this.docsDir.convention(this.project.getLayout().getBuildDirectory().dir("docs"));
        this.testResultsDir.convention(this.project.getLayout().getBuildDirectory().dir("test-results"));
        this.testReportDir.convention(((ReportingExtension)this.project.getExtensions().getByType(ReportingExtension.class)).getBaseDirectory().dir("tests"));
    }

    @Override
    public Object sourceSets(Closure closure) {
        return this.sourceSets.configure(closure);
    }

    @Override
    public DirectoryProperty getDocsDir() {
        return this.docsDir;
    }

    @Override
    public DirectoryProperty getTestResultsDir() {
        return this.testResultsDir;
    }

    @Override
    public DirectoryProperty getTestReportDir() {
        return this.testReportDir;
    }

    @Override
    public JavaVersion getSourceCompatibility() {
        if (this.srcCompat != null) {
            return this.srcCompat;
        }
        if (this.toolchainSpec != null && this.toolchainSpec.isConfigured()) {
            return JavaVersion.toVersion((Object)((JavaLanguageVersion)this.toolchainSpec.getLanguageVersion().get()).toString());
        }
        return JavaVersion.current();
    }

    public JavaVersion getRawSourceCompatibility() {
        return this.srcCompat;
    }

    @Override
    public void setSourceCompatibility(Object value) {
        this.setSourceCompatibility(JavaVersion.toVersion((Object)value));
    }

    @Override
    public void setSourceCompatibility(JavaVersion value) {
        this.srcCompat = value;
    }

    @Override
    public JavaVersion getTargetCompatibility() {
        return this.targetCompat != null ? this.targetCompat : this.getSourceCompatibility();
    }

    public JavaVersion getRawTargetCompatibility() {
        return this.targetCompat;
    }

    @Override
    public void setTargetCompatibility(Object value) {
        this.setTargetCompatibility(JavaVersion.toVersion((Object)value));
    }

    @Override
    public void setTargetCompatibility(JavaVersion value) {
        this.targetCompat = value;
    }

    @Override
    public Manifest manifest() {
        return this.manifest((Action<? super Manifest>)Actions.doNothing());
    }

    @Override
    public Manifest manifest(Closure closure) {
        return (Manifest)ConfigureUtil.configure((Closure)closure, (Object)this.createManifest());
    }

    @Override
    public Manifest manifest(Action<? super Manifest> action) {
        Manifest manifest = this.createManifest();
        action.execute((Object)manifest);
        return manifest;
    }

    private Manifest createManifest() {
        return new DefaultManifest((PathToFileResolver)this.project.getFileResolver());
    }

    @Override
    public SourceSetContainer getSourceSets() {
        return this.sourceSets;
    }

    @Override
    public void disableAutoTargetJvm() {
        this.autoTargetJvm = false;
    }

    @Override
    public boolean getAutoTargetJvmDisabled() {
        return !this.autoTargetJvm;
    }

    @Override
    public void registerFeature(String name, Action<? super FeatureSpec> configureAction) {
        ProjectDerivedCapability defaultCapability = new ProjectDerivedCapability((Project)this.project, name);
        DefaultJavaFeatureSpec spec = new DefaultJavaFeatureSpec(DefaultJavaPluginExtension.validateFeatureName(name), (Capability)defaultCapability, this.jvmPluginServices);
        configureAction.execute((Object)spec);
        spec.create();
    }

    @Override
    public void withJavadocJar() {
        TaskContainerInternal tasks = this.project.getTasks();
        ConfigurationContainer configurations = this.project.getConfigurations();
        SourceSet main = (SourceSet)this.getSourceSets().getByName("main");
        JvmPluginsHelper.configureDocumentationVariantWithArtifact("javadocElements", null, "javadoc", (List<Capability>)ImmutableList.of(), main.getJavadocJarTaskName(), tasks.named(main.getJavadocTaskName()), JvmPluginsHelper.findJavaComponent(this.components), configurations, (TaskContainer)tasks, this.objectFactory);
    }

    @Override
    public void withSourcesJar() {
        TaskContainerInternal tasks = this.project.getTasks();
        ConfigurationContainer configurations = this.project.getConfigurations();
        SourceSet main = (SourceSet)this.getSourceSets().getByName("main");
        JvmPluginsHelper.configureDocumentationVariantWithArtifact("sourcesElements", null, "sources", (List<Capability>)ImmutableList.of(), main.getSourcesJarTaskName(), main.getAllSource(), JvmPluginsHelper.findJavaComponent(this.components), configurations, (TaskContainer)tasks, this.objectFactory);
    }

    @Override
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    @Override
    public JavaToolchainSpec getToolchain() {
        return this.toolchain;
    }

    @Override
    public JavaToolchainSpec toolchain(Action<? super JavaToolchainSpec> action) {
        action.execute((Object)this.toolchain);
        return this.toolchain;
    }

    @Override
    public void consistentResolution(Action<? super JavaResolutionConsistency> action) {
        ConfigurationContainer configurations = this.project.getConfigurations();
        SourceSetContainer sourceSets = this.getSourceSets();
        action.execute(this.project.getObjects().newInstance(DefaultJavaResolutionConsistency.class, new Object[]{sourceSets, configurations}));
    }

    private static String validateFeatureName(String name) {
        if (!VALID_FEATURE_NAME.matcher(name).matches()) {
            throw new InvalidUserDataException("Invalid feature name '" + name + "'. Must match " + VALID_FEATURE_NAME.pattern());
        }
        return name;
    }

    public static class DefaultJavaResolutionConsistency
    implements JavaResolutionConsistency {
        private final Configuration mainCompileClasspath;
        private final Configuration mainRuntimeClasspath;
        private final Configuration testCompileClasspath;
        private final Configuration testRuntimeClasspath;
        private final SourceSetContainer sourceSets;
        private final ConfigurationContainer configurations;

        @Inject
        public DefaultJavaResolutionConsistency(SourceSetContainer sourceSets, ConfigurationContainer configurations) {
            this.sourceSets = sourceSets;
            this.configurations = configurations;
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            SourceSet testSourceSet = (SourceSet)sourceSets.getByName("test");
            this.mainCompileClasspath = this.findConfiguration(mainSourceSet.getCompileClasspathConfigurationName());
            this.mainRuntimeClasspath = this.findConfiguration(mainSourceSet.getRuntimeClasspathConfigurationName());
            this.testCompileClasspath = this.findConfiguration(testSourceSet.getCompileClasspathConfigurationName());
            this.testRuntimeClasspath = this.findConfiguration(testSourceSet.getRuntimeClasspathConfigurationName());
        }

        @Override
        public void useCompileClasspathVersions() {
            this.sourceSets.configureEach(this::applyCompileClasspathConsistency);
            this.testCompileClasspath.shouldResolveConsistentlyWith(this.mainCompileClasspath);
        }

        @Override
        public void useRuntimeClasspathVersions() {
            this.sourceSets.configureEach(this::applyRuntimeClasspathConsistency);
            this.testRuntimeClasspath.shouldResolveConsistentlyWith(this.mainRuntimeClasspath);
        }

        private void applyCompileClasspathConsistency(SourceSet sourceSet) {
            Configuration compileClasspath = this.findConfiguration(sourceSet.getCompileClasspathConfigurationName());
            Configuration runtimeClasspath = this.findConfiguration(sourceSet.getRuntimeClasspathConfigurationName());
            runtimeClasspath.shouldResolveConsistentlyWith(compileClasspath);
        }

        private void applyRuntimeClasspathConsistency(SourceSet sourceSet) {
            Configuration compileClasspath = this.findConfiguration(sourceSet.getCompileClasspathConfigurationName());
            Configuration runtimeClasspath = this.findConfiguration(sourceSet.getRuntimeClasspathConfigurationName());
            compileClasspath.shouldResolveConsistentlyWith(runtimeClasspath);
        }

        private Configuration findConfiguration(String configName) {
            return this.configurations.getByName(configName);
        }
    }
}

