/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.catalog.internal;

import com.google.common.collect.Interner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.DefaultVersionCatalogBuilder;
import org.gradle.api.internal.catalog.parser.DependenciesModelHelper;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;

public class DependenciesAwareVersionCatalogBuilder
extends DefaultVersionCatalogBuilder {
    private static final Logger LOGGER = Logging.getLogger(DependenciesAwareVersionCatalogBuilder.class);
    private final Configuration dependenciesConfiguration;
    private final Map<ModuleIdentifier, String> explicitAliases = Maps.newHashMap();
    private boolean shouldAmendModel = true;

    @Inject
    public DependenciesAwareVersionCatalogBuilder(String name, Interner<String> strings, Interner<ImmutableVersionConstraint> versionConstraintInterner, ObjectFactory objects, ProviderFactory providers, Supplier<DependencyResolutionServices> dependencyResolutionServicesSupplier, Configuration dependenciesConfiguration) {
        super(name, strings, versionConstraintInterner, objects, providers, dependencyResolutionServicesSupplier);
        this.dependenciesConfiguration = dependenciesConfiguration;
    }

    public DefaultVersionCatalog build() {
        if (this.shouldAmendModel) {
            DependencySet allDependencies = this.dependenciesConfiguration.getAllDependencies();
            DependencyConstraintSet allDependencyConstraints = this.dependenciesConfiguration.getAllDependencyConstraints();
            HashSet seen = Sets.newHashSet();
            this.collectDependencies(allDependencies, seen);
            this.collectConstraints(allDependencyConstraints, seen);
        }
        this.shouldAmendModel = false;
        return super.build();
    }

    void tryGenericAlias(String group, String name, Action<? super MutableVersionConstraint> versionSpec) {
        String alias = DependenciesAwareVersionCatalogBuilder.normalizeName(name);
        if (this.containsDependencyAlias(alias)) {
            throw new InvalidUserDataException("A dependency with alias '" + alias + "' already exists for module '" + group + ":" + name + "'. Please configure an explicit alias for this dependency.");
        }
        if (!DependenciesModelHelper.ALIAS_PATTERN.matcher(alias).matches()) {
            throw new InvalidUserDataException("Unable to generate an automatic alias for '" + group + ":" + name + "'. Please configure an explicit alias for this dependency.");
        }
        this.alias(alias).to(group, name).version(versionSpec);
    }

    private static String normalizeName(String name) {
        return name.replace('.', '-');
    }

    private void collectDependencies(DependencySet allDependencies, Set<ModuleIdentifier> seen) {
        for (Dependency dependency : allDependencies) {
            String group = dependency.getGroup();
            String name = dependency.getName();
            if (group == null) continue;
            ModuleIdentifier id = DefaultModuleIdentifier.newId((String)group, (String)name);
            if (seen.add(id)) {
                String alias = this.explicitAliases.get(id);
                if (alias != null) {
                    this.alias(alias).to(group, name).version(v -> DependenciesAwareVersionCatalogBuilder.copyDependencyVersion(dependency, group, name, v));
                    continue;
                }
                this.tryGenericAlias(group, name, (Action<? super MutableVersionConstraint>)((Action)v -> DependenciesAwareVersionCatalogBuilder.copyDependencyVersion(dependency, group, name, v)));
                continue;
            }
            LOGGER.warn("Duplicate entry for dependency " + group + ":" + name);
        }
    }

    private static void copyDependencyVersion(Dependency dependency, String group, String name, MutableVersionConstraint v) {
        if (dependency instanceof ExternalModuleDependency) {
            VersionConstraint vc = ((ExternalModuleDependency)dependency).getVersionConstraint();
            DependenciesAwareVersionCatalogBuilder.copyConstraint(vc, v);
        } else {
            String version = dependency.getVersion();
            if (version == null || version.isEmpty()) {
                throw new InvalidUserDataException("Version for dependency " + group + ":" + name + " must not be empty");
            }
            v.require(version);
        }
    }

    private void collectConstraints(DependencyConstraintSet allConstraints, Set<ModuleIdentifier> seen) {
        for (DependencyConstraint constraint : allConstraints) {
            String name;
            String group = constraint.getGroup();
            ModuleIdentifier id = DefaultModuleIdentifier.newId((String)group, (String)(name = constraint.getName()));
            if (seen.add(id)) {
                String alias = this.explicitAliases.get(id);
                if (alias != null) {
                    this.alias(alias).to(group, name).version(into -> DependenciesAwareVersionCatalogBuilder.copyConstraint(constraint.getVersionConstraint(), into));
                    continue;
                }
                this.tryGenericAlias(group, name, (Action<? super MutableVersionConstraint>)((Action)into -> DependenciesAwareVersionCatalogBuilder.copyConstraint(constraint.getVersionConstraint(), into)));
                continue;
            }
            LOGGER.warn("Duplicate entry for constraint " + group + ":" + name);
        }
    }

    private static void copyConstraint(VersionConstraint from, MutableVersionConstraint into) {
        if (!from.getRequiredVersion().isEmpty()) {
            into.require(from.getRequiredVersion());
        }
        if (!from.getStrictVersion().isEmpty()) {
            into.strictly(from.getStrictVersion());
        }
        if (!from.getPreferredVersion().isEmpty()) {
            into.prefer(from.getPreferredVersion());
        }
        if (!from.getRejectedVersions().isEmpty()) {
            into.reject(from.getRejectedVersions().toArray(new String[0]));
        }
    }

    public void configureExplicitAlias(ModuleIdentifier id, String alias) {
        this.explicitAliases.put(id, alias);
    }
}

