/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.java.WebApplication;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.DefaultWarPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.War;
import org.gradle.internal.deprecation.DeprecatableConfiguration;

public class WarPlugin
implements Plugin<Project> {
    public static final String PROVIDED_COMPILE_CONFIGURATION_NAME = "providedCompile";
    public static final String PROVIDED_RUNTIME_CONFIGURATION_NAME = "providedRuntime";
    public static final String WAR_TASK_NAME = "war";
    public static final String WEB_APP_GROUP = "web application";
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;

    @Inject
    public WarPlugin(ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory) {
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        DefaultWarPluginConvention pluginConvention = new DefaultWarPluginConvention(project);
        project.getConvention().getPlugins().put(WAR_TASK_NAME, pluginConvention);
        project.getTasks().withType(War.class).configureEach(task -> {
            task.getWebAppDirectory().convention(project.getLayout().dir(project.provider(() -> pluginConvention.getWebAppDir())));
            task.from(new Object[]{task.getWebAppDirectory()});
            task.dependsOn(new Object[]{() -> ((SourceSet)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main")).getRuntimeClasspath()});
            task.classpath(() -> {
                FileCollection runtimeClasspath = ((SourceSet)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main")).getRuntimeClasspath();
                Configuration providedRuntime = project.getConfigurations().getByName(PROVIDED_RUNTIME_CONFIGURATION_NAME);
                return runtimeClasspath.minus((FileCollection)providedRuntime);
            });
        });
        TaskProvider war = project.getTasks().register(WAR_TASK_NAME, War.class, warTask -> {
            warTask.setDescription("Generates a war archive with all the compiled classes, the web-app content and the libraries.");
            warTask.setGroup("build");
        });
        LazyPublishArtifact warArtifact = new LazyPublishArtifact((Provider)war);
        ((DefaultArtifactPublicationSet)project.getExtensions().getByType(DefaultArtifactPublicationSet.class)).addCandidate((PublishArtifact)warArtifact);
        this.configureConfigurations(project.getConfigurations());
        this.configureComponent(project, (PublishArtifact)warArtifact);
    }

    public void configureConfigurations(ConfigurationContainer configurationContainer) {
        Configuration providedCompileConfiguration = ((Configuration)configurationContainer.create(PROVIDED_COMPILE_CONFIGURATION_NAME)).setVisible(false).setDescription("Additional compile classpath for libraries that should not be part of the WAR archive.");
        WarPlugin.deprecateForConsumption(providedCompileConfiguration);
        Configuration providedRuntimeConfiguration = ((Configuration)configurationContainer.create(PROVIDED_RUNTIME_CONFIGURATION_NAME)).setVisible(false).extendsFrom(new Configuration[]{providedCompileConfiguration}).setDescription("Additional runtime classpath for libraries that should not be part of the WAR archive.");
        WarPlugin.deprecateForConsumption(providedRuntimeConfiguration);
        configurationContainer.getByName("implementation").extendsFrom(new Configuration[]{providedCompileConfiguration});
        configurationContainer.getByName("runtimeClasspath").extendsFrom(new Configuration[]{providedRuntimeConfiguration});
        configurationContainer.getByName("testRuntimeClasspath").extendsFrom(new Configuration[]{providedRuntimeConfiguration});
        configurationContainer.getByName("runtimeElements").extendsFrom(new Configuration[]{providedRuntimeConfiguration});
    }

    private static void deprecateForConsumption(Configuration configuration) {
        ((DeprecatableConfiguration)configuration).deprecateForConsumption((T deprecation) -> deprecation.willBecomeAnErrorInGradle8().withUpgradeGuideSection(7, "plugin_configuration_consumption"));
    }

    private void configureComponent(Project project, PublishArtifact warArtifact) {
        AttributeContainer attributes = this.attributesFactory.mutable().attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.objectFactory.named(Usage.class, "java-runtime")));
        project.getComponents().add((Object)((SoftwareComponent)this.objectFactory.newInstance(WebApplication.class, new Object[]{warArtifact, "master", attributes})));
    }
}

