/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.tasks.options.FieldOptionElement;
import org.gradle.api.internal.tasks.options.InstanceOptionDescriptor;
import org.gradle.api.internal.tasks.options.MethodOptionElement;
import org.gradle.api.internal.tasks.options.OptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionElement;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.api.internal.tasks.options.OptionValueNotationParserFactory;
import org.gradle.api.tasks.options.Option;
import org.gradle.api.tasks.options.OptionValues;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.util.internal.CollectionUtils;

public class OptionReader {
    private final ListMultimap<Class<?>, OptionElement> cachedOptionElements = ArrayListMultimap.create();
    private final Map<OptionElement, JavaMethod<Object, Collection>> cachedOptionValueMethods = new HashMap<OptionElement, JavaMethod<Object, Collection>>();
    private final OptionValueNotationParserFactory optionValueNotationParserFactory = new OptionValueNotationParserFactory();

    public List<OptionDescriptor> getOptions(Object target) {
        Class<?> targetClass = target.getClass();
        HashMap<String, InstanceOptionDescriptor> options = new HashMap<String, InstanceOptionDescriptor>();
        if (!this.cachedOptionElements.containsKey(targetClass)) {
            this.loadClassDescriptorInCache(target);
        }
        for (OptionElement optionElement : this.cachedOptionElements.get(targetClass)) {
            JavaMethod<Object, Collection> optionValueMethod = this.cachedOptionValueMethods.get(optionElement);
            options.put(optionElement.getOptionName(), new InstanceOptionDescriptor(target, optionElement, optionValueMethod));
        }
        return CollectionUtils.sort(options.values());
    }

    private void loadClassDescriptorInCache(Object target) {
        Collection<OptionElement> optionElements = this.getOptionElements(target);
        List<JavaMethod<Object, Collection>> optionValueMethods = OptionReader.loadValueMethodForOption(target.getClass());
        HashSet<String> processedOptionElements = new HashSet<String>();
        for (OptionElement optionElement : optionElements) {
            if (processedOptionElements.contains(optionElement.getOptionName())) {
                throw new OptionValidationException(String.format("@Option '%s' linked to multiple elements in class '%s'.", optionElement.getOptionName(), target.getClass().getName()));
            }
            processedOptionElements.add(optionElement.getOptionName());
            JavaMethod<Object, Collection> optionValueMethodForOption = OptionReader.getOptionValueMethodForOption(optionValueMethods, optionElement);
            this.cachedOptionElements.put(target.getClass(), (Object)optionElement);
            this.cachedOptionValueMethods.put(optionElement, optionValueMethodForOption);
        }
    }

    private static JavaMethod<Object, Collection> getOptionValueMethodForOption(List<JavaMethod<Object, Collection>> optionValueMethods, OptionElement optionElement) {
        JavaMethod<Object, Collection> valueMethod = null;
        for (JavaMethod<Object, Collection> optionValueMethod : optionValueMethods) {
            Object[] optionNames = OptionReader.getOptionNames(optionValueMethod);
            if (!CollectionUtils.toList((Object[])optionNames).contains(optionElement.getOptionName())) continue;
            if (valueMethod == null) {
                valueMethod = optionValueMethod;
                continue;
            }
            throw new OptionValidationException(String.format("@OptionValues for '%s' cannot be attached to multiple methods in class '%s'.", optionElement.getOptionName(), optionValueMethod.getMethod().getDeclaringClass().getName()));
        }
        return valueMethod;
    }

    private static String[] getOptionNames(JavaMethod<Object, Collection> optionValueMethod) {
        OptionValues optionValues = optionValueMethod.getMethod().getAnnotation(OptionValues.class);
        return optionValues.value();
    }

    private Collection<OptionElement> getOptionElements(Object target) {
        ArrayList<OptionElement> allOptionElements = new ArrayList<OptionElement>();
        for (Class<?> type = target.getClass(); type != Object.class && type != null; type = type.getSuperclass()) {
            allOptionElements.addAll(this.getMethodAnnotations(type));
            allOptionElements.addAll(this.getFieldAnnotations(type));
        }
        return allOptionElements;
    }

    private List<OptionElement> getFieldAnnotations(Class<?> type) {
        ArrayList<OptionElement> fieldOptionElements = new ArrayList<OptionElement>();
        for (Field field : type.getDeclaredFields()) {
            Option option = this.findOption(field);
            if (option == null) continue;
            fieldOptionElements.add(FieldOptionElement.create(option, field, this.optionValueNotationParserFactory));
        }
        return fieldOptionElements;
    }

    private Option findOption(Field field) {
        Option option = field.getAnnotation(Option.class);
        if (option != null && Modifier.isStatic(field.getModifiers())) {
            throw new OptionValidationException(String.format("@Option on static field '%s' not supported in class '%s'.", field.getName(), field.getDeclaringClass().getName()));
        }
        return option;
    }

    private List<OptionElement> getMethodAnnotations(Class<?> type) {
        ArrayList<OptionElement> methodOptionElements = new ArrayList<OptionElement>();
        for (Method method : type.getDeclaredMethods()) {
            Option option = this.findOption(method);
            if (option == null) continue;
            OptionElement methodOptionDescriptor = MethodOptionElement.create(option, method, this.optionValueNotationParserFactory);
            methodOptionElements.add(methodOptionDescriptor);
        }
        return methodOptionElements;
    }

    private Option findOption(Method method) {
        Option option = method.getAnnotation(Option.class);
        if (option != null && Modifier.isStatic(method.getModifiers())) {
            throw new OptionValidationException(String.format("@Option on static method '%s' not supported in class '%s'.", method.getName(), method.getDeclaringClass().getName()));
        }
        return option;
    }

    private static List<JavaMethod<Object, Collection>> loadValueMethodForOption(Class<?> declaredClass) {
        ArrayList<JavaMethod<Object, Collection>> methods = new ArrayList<JavaMethod<Object, Collection>>();
        for (Class<?> type = declaredClass; type != Object.class && type != null; type = type.getSuperclass()) {
            for (Method method : type.getDeclaredMethods()) {
                JavaMethod<Object, Collection> optionValuesMethod = OptionReader.getAsOptionValuesMethod(type, method);
                if (optionValuesMethod == null) continue;
                methods.add(optionValuesMethod);
            }
        }
        return methods;
    }

    private static JavaMethod<Object, Collection> getAsOptionValuesMethod(Class<?> type, Method method) {
        OptionValues optionValues = method.getAnnotation(OptionValues.class);
        if (optionValues == null) {
            return null;
        }
        if (Collection.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0 && !Modifier.isStatic(method.getModifiers())) {
            return JavaMethod.of(Collection.class, (Method)method);
        }
        throw new OptionValidationException(String.format("@OptionValues annotation not supported on method '%s' in class '%s'. Supported method must be non-static, return a Collection<String> and take no parameters.", method.getName(), type.getName()));
    }
}

