/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.parsing.ContractsDslNames;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u0007H\u0000\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0012"}, d2={"equalsDslDescriptor", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "dslName", "Lorg/jetbrains/kotlin/name/Name;", "firstArgumentAsExpressionOrNull", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isCallsInPlaceEffectDescriptor", "isContractCallDescriptor", "isEffectDescriptor", "isEqualsDescriptor", "isFromContractDsl", "isImpliesCallDescriptor", "isInvocationKindEnum", "isReturnsEffectDescriptor", "isReturnsNotNullDescriptor", "isReturnsWildcardDescriptor", "frontend"})
public final class PsiContractsUtilsKt {
    public static final boolean isFromContractDsl(@NotNull DeclarationDescriptor $this$isFromContractDsl) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromContractDsl, (String)"<this>");
        return $this$isFromContractDsl.getAnnotations().hasAnnotation(ContractsDslNames.INSTANCE.getCONTRACTS_DSL_ANNOTATION_FQN());
    }

    public static final boolean isContractCallDescriptor(@NotNull DeclarationDescriptor $this$isContractCallDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$isContractCallDescriptor, (String)"<this>");
        return PsiContractsUtilsKt.equalsDslDescriptor($this$isContractCallDescriptor, ContractsDslNames.INSTANCE.getCONTRACT());
    }

    public static final boolean isImpliesCallDescriptor(@NotNull DeclarationDescriptor $this$isImpliesCallDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$isImpliesCallDescriptor, (String)"<this>");
        return PsiContractsUtilsKt.equalsDslDescriptor($this$isImpliesCallDescriptor, ContractsDslNames.INSTANCE.getIMPLIES());
    }

    public static final boolean isReturnsEffectDescriptor(@NotNull DeclarationDescriptor $this$isReturnsEffectDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$isReturnsEffectDescriptor, (String)"<this>");
        return PsiContractsUtilsKt.equalsDslDescriptor($this$isReturnsEffectDescriptor, ContractsDslNames.INSTANCE.getRETURNS());
    }

    public static final boolean isReturnsNotNullDescriptor(@NotNull DeclarationDescriptor $this$isReturnsNotNullDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$isReturnsNotNullDescriptor, (String)"<this>");
        return PsiContractsUtilsKt.equalsDslDescriptor($this$isReturnsNotNullDescriptor, ContractsDslNames.INSTANCE.getRETURNS_NOT_NULL());
    }

    public static final boolean isReturnsWildcardDescriptor(@NotNull DeclarationDescriptor $this$isReturnsWildcardDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$isReturnsWildcardDescriptor, (String)"<this>");
        return PsiContractsUtilsKt.equalsDslDescriptor($this$isReturnsWildcardDescriptor, ContractsDslNames.INSTANCE.getRETURNS()) && $this$isReturnsWildcardDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)$this$isReturnsWildcardDescriptor).getValueParameters().isEmpty();
    }

    public static final boolean isEffectDescriptor(@NotNull DeclarationDescriptor $this$isEffectDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectDescriptor, (String)"<this>");
        return PsiContractsUtilsKt.equalsDslDescriptor($this$isEffectDescriptor, ContractsDslNames.INSTANCE.getEFFECT());
    }

    public static final boolean isCallsInPlaceEffectDescriptor(@NotNull DeclarationDescriptor $this$isCallsInPlaceEffectDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$isCallsInPlaceEffectDescriptor, (String)"<this>");
        return PsiContractsUtilsKt.equalsDslDescriptor($this$isCallsInPlaceEffectDescriptor, ContractsDslNames.INSTANCE.getCALLS_IN_PLACE());
    }

    public static final boolean isInvocationKindEnum(@NotNull DeclarationDescriptor $this$isInvocationKindEnum) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvocationKindEnum, (String)"<this>");
        return PsiContractsUtilsKt.equalsDslDescriptor($this$isInvocationKindEnum, ContractsDslNames.INSTANCE.getINVOCATION_KIND_ENUM());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEqualsDescriptor(@NotNull DeclarationDescriptor $this$isEqualsDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualsDescriptor, (String)"<this>");
        if (!($this$isEqualsDescriptor instanceof FunctionDescriptor)) return false;
        if (!Intrinsics.areEqual((Object)((FunctionDescriptor)$this$isEqualsDescriptor).getName(), (Object)Name.identifier("equals"))) return false;
        if (((FunctionDescriptor)$this$isEqualsDescriptor).getDispatchReceiverParameter() == null) return false;
        Annotated annotated = ((FunctionDescriptor)$this$isEqualsDescriptor).getReturnType();
        if (annotated == null) {
            return false;
        }
        if (!TypeUtilsKt.isBoolean((KotlinType)annotated)) return false;
        boolean bl = true;
        if (!bl) return false;
        Object object = ((FunctionDescriptor)$this$isEqualsDescriptor).getValueParameters();
        Intrinsics.checkNotNullExpressionValue(object, (String)"this.valueParameters");
        annotated = (ValueParameterDescriptor)CollectionsKt.singleOrNull(object);
        if (annotated == null) {
            return false;
        }
        object = annotated.getType();
        if (object == null) {
            return false;
        }
        if (!TypeUtilsKt.isNullableAny((KotlinType)object)) return false;
        return true;
    }

    @Nullable
    public static final KtExpression firstArgumentAsExpressionOrNull(@NotNull ResolvedCall<?> $this$firstArgumentAsExpressionOrNull) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter($this$firstArgumentAsExpressionOrNull, (String)"<this>");
        List<ResolvedValueArgument> list2 = $this$firstArgumentAsExpressionOrNull.getValueArgumentsByIndex();
        if (list2 == null) {
            ktExpression = null;
        } else {
            ResolvedValueArgument resolvedValueArgument = (ResolvedValueArgument)CollectionsKt.firstOrNull(list2);
            if (resolvedValueArgument == null) {
                ktExpression = null;
            } else {
                ValueArgument valueArgument;
                ExpressionValueArgument expressionValueArgument;
                ResolvedValueArgument $this$safeAs$iv = resolvedValueArgument;
                boolean $i$f$safeAs = false;
                ResolvedValueArgument resolvedValueArgument2 = $this$safeAs$iv;
                if (!(resolvedValueArgument2 instanceof ExpressionValueArgument)) {
                    resolvedValueArgument2 = null;
                }
                ktExpression = (expressionValueArgument = (ExpressionValueArgument)resolvedValueArgument2) == null ? null : ((valueArgument = expressionValueArgument.getValueArgument()) == null ? null : valueArgument.getArgumentExpression());
            }
        }
        return ktExpression;
    }

    private static final boolean equalsDslDescriptor(DeclarationDescriptor $this$equalsDslDescriptor, Name dslName) {
        return Intrinsics.areEqual((Object)$this$equalsDslDescriptor.getName(), (Object)dslName) && PsiContractsUtilsKt.isFromContractDsl($this$equalsDslDescriptor);
    }
}

