/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiKeyword;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class PsiMethodReferenceUtil {
    private static final Logger LOG = Logger.getInstance(PsiMethodReferenceUtil.class);

    public static boolean isSecondSearchPossible(PsiType[] parameterTypes, QualifierResolveResult qualifierResolveResult, PsiMethodReferenceExpression methodRef) {
        return parameterTypes.length > 0 && !(parameterTypes[0] instanceof PsiPrimitiveType) && !methodRef.isConstructor() && PsiMethodReferenceUtil.isStaticallyReferenced(methodRef) && PsiMethodReferenceUtil.isReceiverType(parameterTypes[0], qualifierResolveResult.getContainingClass(), qualifierResolveResult.getSubstitutor());
    }

    public static boolean isResolvedBySecondSearch(@NotNull PsiMethodReferenceExpression methodRef) {
        PsiElement resolve2;
        if (methodRef == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(0);
        }
        if ((resolve2 = methodRef.resolve()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolve2;
            PsiType functionalInterfaceType = methodRef.getFunctionalInterfaceType();
            PsiClassType.ClassResolveResult functionalResolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(functionalResolveResult);
            return interfaceMethod != null && PsiMethodReferenceUtil.isResolvedBySecondSearch(methodRef, interfaceMethod.getSignature(LambdaUtil.getSubstitutor(interfaceMethod, functionalResolveResult)), method.isVarArgs(), method.hasModifierProperty("static"), method.getParameterList().getParametersCount());
        }
        return false;
    }

    public static boolean isResolvedBySecondSearch(@NotNull PsiMethodReferenceExpression methodRef, @Nullable MethodSignature signature2, boolean varArgs, boolean isStatic, int parametersCount) {
        if (methodRef == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(1);
        }
        if (signature2 == null) {
            return false;
        }
        QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(methodRef);
        PsiType[] functionalMethodParameterTypes = signature2.getParameterTypes();
        return (parametersCount + 1 == functionalMethodParameterTypes.length && !varArgs || varArgs && functionalMethodParameterTypes.length > 0 && !isStatic) && PsiMethodReferenceUtil.isSecondSearchPossible(functionalMethodParameterTypes, qualifierResolveResult, methodRef);
    }

    @Nullable
    public static PsiType getQualifierType(PsiMethodReferenceExpression expression2) {
        PsiTypeElement typeElement = expression2.getQualifierType();
        if (typeElement != null) {
            return typeElement.getType();
        }
        PsiType qualifierType = null;
        PsiElement qualifier = expression2.getQualifier();
        if (qualifier instanceof PsiExpression) {
            qualifierType = ((PsiExpression)qualifier).getType();
        }
        if (qualifierType == null && qualifier instanceof PsiReferenceExpression) {
            return JavaPsiFacade.getElementFactory(expression2.getProject()).createType((PsiReferenceExpression)qualifier);
        }
        return qualifierType;
    }

    public static boolean isReturnTypeCompatible(PsiMethodReferenceExpression expression2, JavaResolveResult result2, PsiType functionalInterfaceType) {
        return PsiMethodReferenceUtil.isReturnTypeCompatible(expression2, result2, functionalInterfaceType, null);
    }

    public static PsiType getMethodReferenceReturnType(PsiMethodReferenceExpression expression2) {
        return PsiMethodReferenceUtil.getMethodReferenceReturnType(expression2, expression2.advancedResolve(false));
    }

    private static PsiType getMethodReferenceReturnType(PsiMethodReferenceExpression expression2, JavaResolveResult result2) {
        PsiSubstitutor subst = result2.getSubstitutor();
        PsiType methodReturnType2 = null;
        PsiClass containingClass = null;
        PsiElement resolve2 = result2.getElement();
        if (resolve2 instanceof PsiMethod) {
            containingClass = ((PsiMethod)resolve2).getContainingClass();
            methodReturnType2 = PsiTypesUtil.patchMethodGetClassReturnType(expression2, (PsiMethod)resolve2);
            if (methodReturnType2 == null) {
                methodReturnType2 = ((PsiMethod)resolve2).getReturnType();
                if (PsiType.VOID.equals(methodReturnType2)) {
                    return methodReturnType2;
                }
                methodReturnType2 = subst.substitute(methodReturnType2);
            }
        } else if (resolve2 instanceof PsiClass) {
            PsiTypeParameter[] typeParameters2;
            if (PsiUtil.isArrayClass(resolve2) && (typeParameters2 = ((PsiClass)resolve2).getTypeParameters()).length == 1) {
                PsiType arrayComponentType = subst.substitute(typeParameters2[0]);
                if (arrayComponentType == null) {
                    return null;
                }
                methodReturnType2 = arrayComponentType.createArrayType();
            }
            containingClass = (PsiClass)resolve2;
        }
        if (methodReturnType2 == null) {
            if (containingClass == null) {
                return null;
            }
            methodReturnType2 = JavaPsiFacade.getElementFactory(expression2.getProject()).createType(containingClass, subst);
        }
        return PsiUtil.captureToplevelWildcards(methodReturnType2, expression2);
    }

    private static boolean isReturnTypeCompatible(PsiMethodReferenceExpression expression2, JavaResolveResult result2, PsiType functionalInterfaceType, Ref<? super String> errorMessage2) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (interfaceMethod != null) {
            PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
            if (PsiType.VOID.equals(interfaceReturnType) || interfaceReturnType == null) {
                return true;
            }
            PsiType methodReturnType2 = PsiMethodReferenceUtil.getMethodReferenceReturnType(expression2, result2);
            if (methodReturnType2 == null) {
                return false;
            }
            if (TypeConversionUtil.isAssignable(interfaceReturnType, methodReturnType2)) {
                return true;
            }
            if (errorMessage2 != null) {
                errorMessage2.set(JavaPsiBundle.message("bad.return.type.in.method.reference", methodReturnType2.getCanonicalText(), interfaceReturnType.getCanonicalText()));
            }
        }
        return false;
    }

    public static boolean isValidQualifier(PsiMethodReferenceExpression expression2) {
        PsiElement referenceNameElement = expression2.getReferenceNameElement();
        if (referenceNameElement instanceof PsiKeyword) {
            PsiElement qualifier = expression2.getQualifier();
            if (qualifier instanceof PsiTypeElement) {
                return true;
            }
            if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static QualifierResolveResult getQualifierResolveResult(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        if (methodReferenceExpression == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(2);
        }
        PsiClass containingClass = null;
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        PsiExpression expression2 = methodReferenceExpression.getQualifierExpression();
        if (expression2 != null) {
            JavaResolveResult resolveResult;
            PsiElement resolve2;
            PsiType expressionType = expression2.getType();
            expressionType = expressionType instanceof PsiCapturedWildcardType ? ((PsiCapturedWildcardType)expressionType).getUpperBound() : PsiMethodReferenceUtil.replaceArrayType(expressionType, expression2);
            PsiClassType.ClassResolveResult result2 = PsiUtil.resolveGenericsClassInType(expressionType);
            containingClass = result2.getElement();
            if (containingClass != null) {
                substitutor2 = result2.getSubstitutor();
            }
            if (containingClass == null && expression2 instanceof PsiReferenceExpression && (resolve2 = (resolveResult = ((PsiReferenceExpression)expression2).advancedResolve(false)).getElement()) instanceof PsiClass) {
                containingClass = (PsiClass)resolve2;
                substitutor2 = resolveResult.getSubstitutor();
                return new QualifierResolveResult(containingClass, substitutor2, true);
            }
        } else {
            PsiType type2;
            PsiClassType.ClassResolveResult result3;
            PsiTypeElement typeElement = methodReferenceExpression.getQualifierType();
            if (typeElement != null && (containingClass = (result3 = PsiUtil.resolveGenericsClassInType(type2 = PsiMethodReferenceUtil.replaceArrayType(typeElement.getType(), typeElement))).getElement()) != null) {
                return new QualifierResolveResult(containingClass, result3.getSubstitutor(), true);
            }
        }
        return new QualifierResolveResult(containingClass, substitutor2, false);
    }

    public static boolean isStaticallyReferenced(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        PsiExpression qualifierExpression;
        if (methodReferenceExpression == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(3);
        }
        if ((qualifierExpression = methodReferenceExpression.getQualifierExpression()) != null) {
            return qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).resolve() instanceof PsiClass;
        }
        return true;
    }

    public static boolean isReceiverType(@Nullable PsiType receiverType, PsiClass containingClass, PsiSubstitutor psiSubstitutor) {
        if (receiverType == null) {
            return false;
        }
        return TypeConversionUtil.isAssignable(JavaPsiFacade.getElementFactory(containingClass.getProject()).createType(containingClass, psiSubstitutor), PsiMethodReferenceUtil.replaceArrayType(receiverType, containingClass));
    }

    public static PsiType getFirstParameterType(PsiType functionalInterfaceType, PsiElement context2) {
        int interfaceMethodParamsLength;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        MethodSignature function2 = LambdaUtil.getFunction(resolveResult.getElement());
        if (function2 != null && (interfaceMethodParamsLength = function2.getParameterTypes().length) > 0) {
            PsiType type2 = resolveResult.getSubstitutor().substitute(function2.getParameterTypes()[0]);
            return type2 != null ? PsiUtil.captureToplevelWildcards(type2, context2) : null;
        }
        return null;
    }

    private static PsiType replaceArrayType(PsiType type2, @NotNull PsiElement context2) {
        if (context2 == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(4);
        }
        if (type2 instanceof PsiArrayType) {
            type2 = JavaPsiFacade.getElementFactory(context2.getProject()).getArrayClassType(((PsiArrayType)type2).getComponentType(), PsiUtil.getLanguageLevel(context2));
        }
        return type2;
    }

    public static String checkTypeArguments(PsiTypeElement qualifier, PsiType psiType2) {
        PsiJavaCodeReferenceElement referenceElement;
        if (psiType2 instanceof PsiClassType && (referenceElement = qualifier.getInnermostComponentReferenceElement()) != null) {
            PsiType[] typeParameters2;
            for (PsiType typeParameter : typeParameters2 = referenceElement.getTypeParameters()) {
                if (!(typeParameter instanceof PsiWildcardType)) continue;
                return JavaPsiBundle.message("error.message.wildcard.not.expected", new Object[0]);
            }
        }
        return null;
    }

    public static String checkReturnType(PsiMethodReferenceExpression expression2, JavaResolveResult result2, PsiType functionalInterfaceType) {
        Ref errorMessage2 = Ref.create();
        if (!PsiMethodReferenceUtil.isReturnTypeCompatible(expression2, result2, functionalInterfaceType, errorMessage2)) {
            return (String)errorMessage2.get();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReferenceExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiMethodReferenceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isResolvedBySecondSearch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifierResolveResult";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isStaticallyReferenced";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceArrayType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class QualifierResolveResult {
        private final PsiClass myContainingClass;
        private final PsiSubstitutor mySubstitutor;
        private final boolean myReferenceTypeQualified;

        public QualifierResolveResult(PsiClass containingClass, PsiSubstitutor substitutor2, boolean referenceTypeQualified) {
            this.myContainingClass = containingClass;
            this.mySubstitutor = substitutor2;
            this.myReferenceTypeQualified = referenceTypeQualified;
        }

        @Nullable
        public PsiClass getContainingClass() {
            return this.myContainingClass;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.mySubstitutor;
        }

        public boolean isReferenceTypeQualified() {
            return this.myReferenceTypeQualified;
        }
    }
}

