/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.NumberCompare;
import org.jetbrains.kotlin.codegen.ObjectCompare;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.org.objectweb.asm.Label;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/BooleanComparison;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "op", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "a", "Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;", "b", "(Lcom/intellij/psi/tree/IElementType;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;)V", "getA", "()Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;", "getB", "getOp", "()Lcom/intellij/psi/tree/IElementType;", "discard", "", "jumpIfFalse", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "backend.jvm"})
public final class BooleanComparison
extends BooleanValue {
    @NotNull
    private final IElementType op;
    @NotNull
    private final MaterialValue a;
    @NotNull
    private final MaterialValue b;

    public BooleanComparison(@NotNull IElementType op, @NotNull MaterialValue a, @NotNull MaterialValue b) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        super(a.getCodegen());
        this.op = op;
        this.a = a;
        this.b = b;
    }

    @NotNull
    public final IElementType getOp() {
        return this.op;
    }

    @NotNull
    public final MaterialValue getA() {
        return this.a;
    }

    @NotNull
    public final MaterialValue getB() {
        return this.b;
    }

    @Override
    public void jumpIfFalse(@NotNull Label target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int opcode = this.a.getType().getSort() == 10 ? ObjectCompare.Companion.getObjectCompareOpcode(this.op) : NumberCompare.Companion.patchOpcode(NumberCompare.Companion.getNumberCompareOpcode(this.op), this.getMv(), this.op, this.a.getType());
        this.getMv().visitJumpInsn(opcode, target);
    }

    @Override
    public void jumpIfTrue(@NotNull Label target) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.a.getType().getSort() == 10) {
            Integer n2 = BranchedValue.Companion.getNegatedOperations().get(ObjectCompare.Companion.getObjectCompareOpcode(this.op));
            Intrinsics.checkNotNull((Object)n2);
            n = n2;
        } else {
            Integer n3 = BranchedValue.Companion.getNegatedOperations().get(NumberCompare.Companion.getNumberCompareOpcode(this.op));
            Intrinsics.checkNotNull((Object)n3);
            Integer n4 = n3;
            Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"BranchedValue.negatedOpe\u2026umberCompareOpcode(op)]!!");
            n = NumberCompare.Companion.patchOpcode(((Number)n4).intValue(), this.getMv(), this.op, this.a.getType());
        }
        Integer n5 = n;
        Intrinsics.checkNotNullExpressionValue((Object)n5, (String)"if (a.type.sort == Type.\u2026e(op)]!!, mv, op, a.type)");
        int opcode = ((Number)n5).intValue();
        this.getMv().visitJumpInsn(opcode, target);
    }

    @Override
    public void discard() {
        this.b.discard();
        this.a.discard();
    }
}

