/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaForkOptions;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;

public class JacocoPluginExtension {
    public static final String TASK_EXTENSION_NAME = "jacoco";
    private static final Logger LOGGER = Logging.getLogger(JacocoPluginExtension.class);
    @Deprecated
    protected final Project project;
    private final ProviderFactory providers;
    private final ObjectFactory objects;
    private final ProjectLayout layout;
    private final FileSystemOperations fs;
    private final JacocoAgentJar agent;
    private String toolVersion;
    private final DirectoryProperty reportsDirectory;

    public JacocoPluginExtension(Project project, JacocoAgentJar agent) {
        this.project = project;
        this.agent = agent;
        this.providers = project.getProviders();
        this.objects = project.getObjects();
        this.layout = project.getLayout();
        this.fs = (FileSystemOperations)((ProjectInternal)project).getServices().get(FileSystemOperations.class);
        this.reportsDirectory = project.getObjects().directoryProperty();
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public DirectoryProperty getReportsDirectory() {
        return this.reportsDirectory;
    }

    @Deprecated
    public File getReportsDir() {
        this.nagReportsDirDeprecation();
        return ((Directory)this.reportsDirectory.get()).getAsFile();
    }

    @Deprecated
    public void setReportsDir(Provider<File> reportsDir) {
        this.nagReportsDirDeprecation();
        this.reportsDirectory.set(this.layout.dir(reportsDir));
    }

    @Deprecated
    public void setReportsDir(File reportsDir) {
        this.nagReportsDirDeprecation();
        this.reportsDirectory.set(reportsDir);
    }

    private void nagReportsDirDeprecation() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(JacocoPluginExtension.class, (String)"reportsDir").replaceWith((Object)"reportsDirectory")).willBeRemovedInGradle8().withDslReference().nagUser();
    }

    public <T extends Task & JavaForkOptions> void applyTo(T task) {
        String taskName = task.getName();
        LOGGER.debug("Applying Jacoco to " + taskName);
        JacocoTaskExtension extension = (JacocoTaskExtension)task.getExtensions().create(TASK_EXTENSION_NAME, JacocoTaskExtension.class, new Object[]{this.objects, this.agent, task});
        extension.setDestinationFile((Provider<File>)this.layout.getBuildDirectory().file("jacoco/" + taskName + ".exec").map(RegularFile::getAsFile));
        ((JavaForkOptions)task).getJvmArgumentProviders().add(new JacocoAgent(extension));
        task.doFirst((Action)new JacocoOutputCleanupTestTaskAction(this.fs, this.providers.provider(() -> extension.isEnabled() && extension.getOutput() == JacocoTaskExtension.Output.FILE), this.providers.provider(extension::getDestinationFile)));
        Provider doNotCachePredicate = this.providers.provider(() -> extension.isEnabled() && extension.getOutput() != JacocoTaskExtension.Output.FILE);
        task.getOutputs().doNotCacheIf("JaCoCo configured to not produce its output as a file", SerializableLambdas.spec((SerializableLambdas.SerializableSpec & Serializable)targetTask -> (Boolean)doNotCachePredicate.get()));
    }

    public <T extends Task & JavaForkOptions> void applyTo(TaskCollection<T> tasks) {
        tasks.withType(JavaForkOptions.class, x$0 -> this.applyTo((Task)x$0));
    }

    private static class JacocoAgent
    implements CommandLineArgumentProvider,
    Named {
        private final JacocoTaskExtension jacoco;

        public JacocoAgent(JacocoTaskExtension jacoco) {
            this.jacoco = jacoco;
        }

        @Nullable
        @Optional
        @Nested
        public JacocoTaskExtension getJacoco() {
            return this.jacoco.isEnabled() ? this.jacoco : null;
        }

        public Iterable<String> asArguments() {
            return this.jacoco.isEnabled() ? ImmutableList.of((Object)this.jacoco.getAsJvmArg()) : Collections.emptyList();
        }

        @Internal
        public String getName() {
            return "jacocoAgent";
        }
    }

    private static class JacocoOutputCleanupTestTaskAction
    implements Action<Task> {
        private final FileSystemOperations fs;
        private final Provider<Boolean> hasFileOutput;
        private final Provider<File> destinationFile;

        private JacocoOutputCleanupTestTaskAction(FileSystemOperations fs, Provider<Boolean> hasFileOutput, Provider<File> destinationFile) {
            this.fs = fs;
            this.hasFileOutput = hasFileOutput;
            this.destinationFile = destinationFile;
        }

        public void execute(Task task) {
            if (((Boolean)this.hasFileOutput.get()).booleanValue()) {
                File coverageFile = (File)this.destinationFile.getOrNull();
                if (coverageFile == null) {
                    throw new GradleException("JaCoCo destination file must not be null if output type is FILE");
                }
                this.fs.delete(spec -> spec.delete(new Object[]{coverageFile}));
            }
        }
    }
}

