/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.VersionCatalog;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.catalog.AbstractExternalDependencyFactory;
import org.gradle.api.internal.catalog.AliasNormalizer;
import org.gradle.api.internal.catalog.DefaultExternalDependencyFactory;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.ExternalModuleDependencyFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.plugin.use.PluginDependency;

public class VersionCatalogView
implements VersionCatalog {
    private final DefaultVersionCatalog config;
    private final ProviderFactory providerFactory;
    private final ExternalModuleDependencyFactory dependencyFactory;

    @Inject
    public VersionCatalogView(DefaultVersionCatalog config, ProviderFactory providerFactory) {
        this.config = config;
        this.providerFactory = providerFactory;
        this.dependencyFactory = new DefaultExternalDependencyFactory(config, providerFactory);
    }

    public final Optional<Provider<MinimalExternalModuleDependency>> findDependency(String alias) {
        String normalizedAlias = AliasNormalizer.normalize(alias);
        if (this.config.getDependencyAliases().contains(normalizedAlias)) {
            return Optional.of(this.dependencyFactory.create(normalizedAlias));
        }
        return Optional.empty();
    }

    public final Optional<Provider<ExternalModuleDependencyBundle>> findBundle(String bundle) {
        String normalizedBundle = AliasNormalizer.normalize(bundle);
        if (this.config.getBundleAliases().contains(normalizedBundle)) {
            return Optional.of(new AbstractExternalDependencyFactory.BundleFactory(this.providerFactory, this.config).createBundle(normalizedBundle));
        }
        return Optional.empty();
    }

    public final Optional<VersionConstraint> findVersion(String name) {
        String normalizedName = AliasNormalizer.normalize(name);
        if (this.config.getVersionAliases().contains(normalizedName)) {
            return Optional.of(new AbstractExternalDependencyFactory.VersionFactory(this.providerFactory, this.config).findVersionConstraint(normalizedName));
        }
        return Optional.empty();
    }

    public Optional<Provider<PluginDependency>> findPlugin(String alias) {
        String normalizedAlias = AliasNormalizer.normalize(alias);
        if (this.config.getPluginAliases().contains(normalizedAlias)) {
            return Optional.of(new AbstractExternalDependencyFactory.PluginFactory(this.providerFactory, this.config).createPlugin(normalizedAlias));
        }
        return Optional.empty();
    }

    public final String getName() {
        return this.config.getName();
    }

    public List<String> getDependencyAliases() {
        return this.config.getDependencyAliases();
    }

    public List<String> getBundleAliases() {
        return this.config.getBundleAliases();
    }

    public List<String> getVersionAliases() {
        return this.config.getVersionAliases();
    }

    public List<String> getPluginAliases() {
        return this.config.getPluginAliases();
    }
}

