################################################################################
#
# libwebsockets-openipc
#
################################################################################

LIBWEBSOCKETS_OPENIPC_VERSION = 4.2.2
LIBWEBSOCKETS_OPENIPC_SITE = $(call github,warmcat,libwebsockets,v$(LIBWEBSOCKETS_OPENIPC_VERSION))

LIBWEBSOCKETS_OPENIPC_LICENSE = LGPL-2.1 with exceptions
LIBWEBSOCKETS_OPENIPC_LICENSE_FILES = LICENSE
LIBWEBSOCKETS_OPENIPC_DEPENDENCIES = zlib
LIBWEBSOCKETS_OPENIPC_INSTALL_STAGING = YES
LIBWEBSOCKETS_OPENIPC_CONF_OPTS = -DLWS_WITHOUT_TESTAPPS=ON \
								  -DLWS_IPV6=ON \
								  -DLWS_WITH_HTTP2=OFF \
								  -DLWS_WITH_EVLIB_PLUGINS=OFF \
								  -DDISABLE_WERROR=ON

# If LWS_MAX_SMP=1, then there is no code related to pthreads compiled
# in the library. If unset, LWS_MAX_SMP defaults to 32 and a small
# amount of pthread mutex code is built into the library.
ifeq ($(BR2_TOOLCHAIN_HAS_THREADS),)
LIBWEBSOCKETS_OPENIPC_CONF_OPTS += -DLWS_MAX_SMP=1
else
LIBWEBSOCKETS_OPENIPC_CONF_OPTS += -DLWS_MAX_SMP=
endif

ifeq ($(BR2_PACKAGE_MBEDTLS_OPENIPC),y)
LIBWEBSOCKETS_OPENIPC_DEPENDENCIES += mbedtls-openipc
LIBWEBSOCKETS_OPENIPC_CONF_OPTS += -DLWS_WITH_MBEDTLS=ON
else
LIBWEBSOCKETS_OPENIPC_CONF_OPTS += -DLWS_WITH_MBEDTLS=OFF
endif

ifeq ($(BR2_PACKAGE_LIBEV),y)
LIBWEBSOCKETS_OPENIPC_DEPENDENCIES += libev
LIBWEBSOCKETS_OPENIPC_CONF_OPTS += \
	-DLWS_WITH_LIBEV=ON \
	-DLWS_WITH_LIBEVENT=OFF
else ifeq ($(BR2_PACKAGE_LIBEVENT_OPENIPC),y)
LIBWEBSOCKETS_OPENIPC_DEPENDENCIES += libevent-openipc
LIBWEBSOCKETS_OPENIPC_CONF_OPTS += \
	-DLWS_WITH_LIBEV=OFF \
	-DLWS_WITH_LIBEVENT=ON
else
LIBWEBSOCKETS_OPENIPC_CONF_OPTS += \
	-DLWS_WITH_LIBEV=OFF \
	-DLWS_WITH_LIBEVENT=OFF
endif

ifeq ($(BR2_PACKAGE_LIBUV),y)
LIBWEBSOCKETS_OPENIPC_DEPENDENCIES += libuv
LIBWEBSOCKETS_OPENIPC_CONF_OPTS += -DLWS_WITH_LIBUV=ON
else
LIBWEBSOCKETS_OPENIPC_CONF_OPTS += -DLWS_WITH_LIBUV=OFF
endif

ifeq ($(BR2_STATIC_LIBS),y)
LIBWEBSOCKETS_OPENIPC_CONF_OPTS += -DLWS_WITH_SHARED=OFF
endif

ifeq ($(BR2_SHARED_LIBS),y)
LIBWEBSOCKETS_OPENIPC_CONF_OPTS += -DLWS_WITH_STATIC=OFF
endif

$(eval $(cmake-package))
