# 讯飞E听说答案解析

这是一个专门为上海高考听说测试（**讯飞E听说**）设计的答案解析程序。该程序可以从讯飞E听说的本地文件中自动解析试卷内容，并生成对应的解析文档（Word格式），方便用户对照参考。程序支持从下载的试卷中提取内容，包括**选择题**、**朗读句子**、**朗读段落**、**情景提问**、**图片描述**、**快速应答**以及**简述和回答**等类型的题目。

## 项目特点

- **自动解析**：程序自动从用户的本地文件夹（%Appdata%\ETS）中读取试卷，并解析试卷中的题目和答案。
- **Word生成**：将解析结果保存为 Word 文档，生成答案解析报告。
- **文本格式**：支持中文字体使用**等线**，英文使用**Times New Roman**的格式。
- **答案样式**：解析报告中，答案部分会被高亮标注，**Section A** 和 **Section B** 中的答案会被标记为蓝色，解析文档中的大标题会显示为绿色。
- **图像支持**：如果试卷中包含图片描述题目，程序会自动将题目对应的图片插入到 Word 文档中。

## 项目背景

本项目专门针对**上海高考听说测试**的试卷内容进行解析。该程序适用于下载并保存在 `%Appdata%\ETS` 文件夹中的试卷，每一套试卷对应一个编号文件夹，文件夹中包含试卷内容和题目音频文件。本程序旨在帮助考生、教师以及相关工作者自动生成详细的试卷答案解析，提升练习效率。

## 运行环境

- Python 3.7+
- Windows 操作系统
- `python-docx` 库


## 使用说明

1. **选择试卷**：程序启动后，会列出所有下载的试卷，按照下载时间从新到旧排序。用户可以输入试卷对应的编号来选择要解析的试卷。

2. **生成解析文档**：程序会自动解析选定试卷的内容，并生成解析文档。解析文档会保存到用户的桌面，文档名称为 `E听说_解析.docx`。如果文件已经存在，程序会在文件名后添加序号，避免覆盖已有文档。

3. **文档格式**：
   - **大标题**（如 "Section A"、"朗读句子" 等）为绿色（RGB 值为 `#00B050`），中文使用等线字体，英文使用 Times New Roman。
   - **Section A 和 Section B 的答案**部分以蓝色标注，且加粗“答案”二字。
   - **图片描述**中若存在图片，程序会自动将图片插入到文档中。


## 示例

**命令行界面**：

```
请选择试卷文件夹（已按照下载时间从新到旧排列）：
1. 353306
2. 353311
3. 353312
请输入对应的数字: 1
解析完成，文件已保存到: C:\Users\admin\Desktop\E听说_解析.docx
```

**Word文档示例**：

```markdown
Section A
1. M: How many cups do we need?
   W: We have bought 20 online and my mum has just sent 10 over, which means we have already got enough.
   A. 12 cups.
   B. 30 cups.
   C. 20 cups.
   D. 10 cups.
   答案：B

...

图片描述
答案：
● Tina loves her dog very much. She never ties her dog when she walks it in the street. Tina feels very happy when the dog chases and barks at the kids in the street...
```

## 注意事项

1. **程序仅支持** **上海高考听说测试** 下载的试卷文件。其他来源的文件格式可能无法正常解析。
2. **解析后的Word文档**会自动保存到用户桌面，若同名文件存在，则会加上序号避免覆盖。
3. **图片处理**：如果题目中包含图片描述题，程序会自动从 `material` 文件夹中寻找对应图片并插入文档。

## 常见问题

### 1. 为什么程序无法找到试卷文件？

请确保您使用的E听说是最新版，本程序基于 **E听说 V5.7.1** 开发请确保您的试卷文件已经正确下载并保存在 `%Appdata%\ETS` 文件夹中。该程序只解析存储在此路径下的试卷数据。

### 2. 为什么解析出的答案格式不对？

请确保您的系统中安装了 **等线** 和 **Times New Roman** 字体，并且您的试卷文件结构没有被修改。解析过程依赖于固定的文件结构和路径。

### 3. 如何安装依赖项？

如果您遇到依赖项安装问题，请检查 `python-docx` 是否成功安装。您可以使用以下命令进行安装：

```bash
pip install python-docx
```

## 许可证

本项目基于 [MIT License](LICENSE) 开源。