package org.openqa.selenium.devtools.v138.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum HeavyAdResolutionStatus {

    HEAVYADBLOCKED("HeavyAdBlocked"), HEAVYADWARNING("HeavyAdWarning");

    private String value;

    HeavyAdResolutionStatus(String value) {
        this.value = value;
    }

    public static HeavyAdResolutionStatus fromString(String s) {
        return java.util.Arrays.stream(HeavyAdResolutionStatus.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within HeavyAdResolutionStatus "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static HeavyAdResolutionStatus fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
