/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v140.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v140.css.model.SourceRange;
import org.openqa.selenium.devtools.v140.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v140.dom.model.LogicalAxes;
import org.openqa.selenium.devtools.v140.dom.model.PhysicalAxes;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CSSContainerQuery {
    private final String text;
    private final Optional<SourceRange> range;
    private final Optional<StyleSheetId> styleSheetId;
    private final Optional<String> name;
    private final Optional<PhysicalAxes> physicalAxes;
    private final Optional<LogicalAxes> logicalAxes;
    private final Optional<Boolean> queriesScrollState;
    private final Optional<Boolean> queriesAnchored;

    public CSSContainerQuery(String text, Optional<SourceRange> range, Optional<StyleSheetId> styleSheetId, Optional<String> name, Optional<PhysicalAxes> physicalAxes, Optional<LogicalAxes> logicalAxes, Optional<Boolean> queriesScrollState, Optional<Boolean> queriesAnchored) {
        this.text = Objects.requireNonNull(text, "text is required");
        this.range = range;
        this.styleSheetId = styleSheetId;
        this.name = name;
        this.physicalAxes = physicalAxes;
        this.logicalAxes = logicalAxes;
        this.queriesScrollState = queriesScrollState;
        this.queriesAnchored = queriesAnchored;
    }

    public String getText() {
        return this.text;
    }

    public Optional<SourceRange> getRange() {
        return this.range;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<PhysicalAxes> getPhysicalAxes() {
        return this.physicalAxes;
    }

    public Optional<LogicalAxes> getLogicalAxes() {
        return this.logicalAxes;
    }

    public Optional<Boolean> getQueriesScrollState() {
        return this.queriesScrollState;
    }

    public Optional<Boolean> getQueriesAnchored() {
        return this.queriesAnchored;
    }

    private static CSSContainerQuery fromJson(JsonInput input) {
        String text = null;
        Optional<SourceRange> range = Optional.empty();
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        Optional<String> name = Optional.empty();
        Optional<PhysicalAxes> physicalAxes = Optional.empty();
        Optional<LogicalAxes> logicalAxes = Optional.empty();
        Optional<Boolean> queriesScrollState = Optional.empty();
        Optional<Boolean> queriesAnchored = Optional.empty();
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "text": {
                    text = input.nextString();
                    continue block20;
                }
                case "range": {
                    range = Optional.ofNullable((SourceRange)input.read(SourceRange.class));
                    continue block20;
                }
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block20;
                }
                case "name": {
                    name = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "physicalAxes": {
                    physicalAxes = Optional.ofNullable((PhysicalAxes)((Object)input.read(PhysicalAxes.class)));
                    continue block20;
                }
                case "logicalAxes": {
                    logicalAxes = Optional.ofNullable((LogicalAxes)((Object)input.read(LogicalAxes.class)));
                    continue block20;
                }
                case "queriesScrollState": {
                    queriesScrollState = Optional.ofNullable(input.nextBoolean());
                    continue block20;
                }
                case "queriesAnchored": {
                    queriesAnchored = Optional.ofNullable(input.nextBoolean());
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSContainerQuery(text, range, styleSheetId, name, physicalAxes, logicalAxes, queriesScrollState, queriesAnchored);
    }
}

