// This file is generated by the scripts available at https://github.com/hauuau/magpie-prescalers
// Please don't edit this file directly.
// Generated by: nnedi3.py --nns 128 --win 8x6 --use-compute-shader --use-magpie
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//!MAGPIE EFFECT
//!VERSION 4
//!SORT_NAME NNEDI3_128_6

//!TEXTURE
Texture2D INPUT;

//!SAMPLER
//!FILTER POINT
SamplerState sam_INPUT;

//!TEXTURE
//!WIDTH  INPUT_WIDTH * 1 * 2
//!HEIGHT INPUT_HEIGHT * 2 * 1
Texture2D OUTPUT;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam_INPUT_LINEAR;

//!TEXTURE
//!FORMAT R16_FLOAT
//!WIDTH  INPUT_WIDTH * 1
//!HEIGHT INPUT_HEIGHT * 2
Texture2D temp;

//!SAMPLER
//!FILTER POINT
SamplerState sam_temp;

//!COMMON
#include "prescalers.hlsli"

#define LAST_PASS 2

//!PASS 1
//!DESC NNEDI3 (double_y, nns128, win8x6)
//!IN INPUT
//!OUT temp
//!BLOCK_SIZE 32, 16
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[12]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 12; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 48.0;
	float mstd1 = sumsq / 48.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 = W(0, -1138315554, 1017020226, 1054031418, -1098719688)
		 + W(1, -1110814528, -1144117236, -1151849881, -1120184142)
		 + W(2, 1052033568, -1094289569, 1026313661, 1029415347)
		 + W(3, -1130100551, -1113913797, 1057266643, -1094215666)
		 + W(4, -1136459684, -1122295896, -1139428474, -1137890034)
		 + W(5, 1050615732, -1084764287, 1037955767, -1158862002)
		 + W(6, -1115186183, -1105019328, 1060278709, -1093503073)
		 + W(7, -1125342359, -1115484761, 1024054031, 1030136834)
		 + W(8, 1051842684, -1122358095, -1118592012, 1027215228)
		 + W(9, -1123693866, -1119041199, 1049323809, -1104408867)
		 + W(10, -1141919603, -1148196514, -1134121575, 1009291685)
		 + W(11, 1050624038, -1101060057, -1117980571, -1131405947);
	sum2 =
		W(0, 1011608699, -1112090344, 1035039469, 1018826733) + W(1, -1130070276, -1126912052, 1021515189, 1032910614)
		+ W(2, -1112298310, -1103038162, 1030536589, 1027816837)
		+ W(3, -1133688887, -1111235489, 1068933685, 1035541017)
		+ W(4, 1002846254, -1119314146, -1109181339, 1050015381)
		+ W(5, 1079505355, -1096237270, 1047170650, -1132054353) + W(6, 1032724543, 1041065097, -1082386736, 1051919390)
		+ W(7, 1012706615, 1004049262, -1120491130, -1106592726)
		+ W(8, -1067816278, -1101133158, -1108914015, 1017068057)
		+ W(9, 997621755, -1112521193, -1094139890, -1120644044) + W(10, 1011888367, 1020965593, 1020760181, 1032648390)
		+ W(11, -1123411157, 1029904493, -1115273665, 1017829425);
	WS(1038714296, 1044827315);
	sum1 = W(0, 1008773074, -1137155124, 1058392080, -1100726684)
		 + W(1, -1097060854, 1034472653, 1000000044, -1139148008)
		 + W(2, 1051571686, -1106613964, 1034039029, -1136883834)
		 + W(3, -1125197471, -1110040196, 1058043460, -1093356205)
		 + W(4, -1112523275, 1033872898, -1155069097, -1114984084)
		 + W(5, 1059856605, -1087655353, -1137125990, -1122772178)
		 + W(6, -1128457331, -1117135435, 1053821137, -1093486798)
		 + W(7, -1134047198, -1125370043, -1147450330, 1038803511)
		 + W(8, 1050763009, -1088451200, -1131894321, 1027534056)
		 + W(9, -1142834606, -1110360429, 1046500044, -1109846237)
		 + W(10, 1021083253, -1126166913, -1131672268, 1046900069)
		 + W(11, 1049636107, -1093848946, -1108292068, 1020331091);
	sum2 = W(0, -1123255245, -1116671780, 1046375724, 1061532718) + W(1, 998291536, -1094346395, 982126402, -1111301077)
		 + W(2, 1053914306, 1066141278, 1041257894, -1108898352) + W(3, 1020504368, 1011773496, 1013495848, 1064263836)
		 + W(4, 1023442398, 1023084860, 1036976721, -1102830064)
		 + W(5, -1106352300, 1055449836, -1101238723, 1037821947)
		 + W(6, -1113656730, 1031803093, -1103067006, -1076699072)
		 + W(7, -1103198508, -1123876988, -1157600449, 1045043848)
		 + W(8, -1094946683, -1085904680, 1048924521, 1041381351)
		 + W(9, -1129338356, 1026389126, 1036977493, -1099822488)
		 + W(10, -1109968297, -1109391389, 1032297389, 1022832316)
		 + W(11, -1098417421, -1092845936, 1053328593, 1023206676);
	WS(-1087781687, -1134030789);
	sum1 =
		W(0, 1028179002, -1113846601, -1090428884, 1056064759) + W(1, -1116809458, -1123784128, 1037437606, -1129634048)
		+ W(2, -1098510574, 1049319247, -1105760812, 1016685513)
		+ W(3, -1106850597, 1045066941, -1095161561, 1048732210)
		+ W(4, 1007721067, -1105661778, 1040743460, -1108576055) + W(5, -1094444002, 1054487227, 1050640540, 1048222150)
		+ W(6, -1123964671, 1030205873, -1095134094, 1044300425)
		+ W(7, 1040160031, -1110013906, -1122790273, -1117192467)
		+ W(8, -1098192922, 1055338520, -1106372902, 1033480951) + W(9, 1036030878, 1027547489, -1101066654, 1034894336)
		+ W(10, -1109703824, -1112122819, 1027799500, -1110675758)
		+ W(11, -1095206484, 1053272331, -1138309939, 1033810456);
	sum2 = W(0, 1023697539, -1119401943, 1010071413, 1025267901) + W(1, 988018625, -1122026299, -1134698244, 1013558867)
		 + W(2, -1112961274, 1033970227, -1116217767, 1005039212)
		 + W(3, 1018187921, -1119659280, 1019163177, 1048742053)
		 + W(4, -1103390691, -1115786374, 1024534132, 1038666215)
		 + W(5, -1097296472, 1082848284, -1064739318, 1042066180)
		 + W(6, -1145140771, -1120396841, 1033089456, 1060700209)
		 + W(7, -1086947071, 1017803659, -1142625275, 1035154544)
		 + W(8, -1105855221, -1115995862, 1042818438, -1115628759)
		 + W(9, -1141296989, -1131590401, -1156341795, 1035612397)
		 + W(10, -1109434149, -1150181080, 1007645751, 1021197862)
		 + W(11, -1120357988, -1123714371, 1029308077, 1011442501);
	WS(1060770743, -1108197568);
	sum1 =
		W(0, 1016886775, 1029069588, -1095627128, 1046558478) + W(1, -1146067869, 1009558662, -1160198547, 1038531041)
		+ W(2, -1096395039, 1048524254, -1097778094, 1033422755) + W(3, 1015246637, 1041390628, -1086831062, 1058409012)
		+ W(4, -1098986327, 1033638277, -1139668038, 1022402527) + W(5, 1057717017, 1050284011, -1110221104, 1029754521)
		+ W(6, 1034731136, -1103954605, 1056693263, -1083755424)
		+ W(7, 1042951984, -1119102757, 1019206597, -1112398730)
		+ W(8, 1053908426, -1092005688, 1037994808, -1130383710)
		+ W(9, -1123983389, -1117714338, 1043180606, -1101033824)
		+ W(10, 1025216609, -1114155844, -1115649126, 1039312430)
		+ W(11, 1038174992, -1131529899, 1000398449, -1129441697);
	sum2 =
		W(0, -1104188915, 1041755532, 1039915367, 1028942726) + W(1, 1030445090, -1104654601, 1026676440, -1099902739)
		+ W(2, 1048552390, -1105392496, -1104867005, 1033528857)
		+ W(3, -1122447814, 1020538503, -1105911641, -1106738713)
		+ W(4, -1106850996, 989961401, 1024214572, -1096783078) + W(5, 1068731351, 1066518668, -1126700225, -1133955554)
		+ W(6, 1036156927, -1094671115, -1096057439, -1122053390)
		+ W(7, 1025639958, -1153726297, 1039804037, -1096595186)
		+ W(8, -1091471401, -1123632409, -1113480650, 1032072745)
		+ W(9, -1140508998, -1108992818, 1033306823, 1032650381)
		+ W(10, -1115144981, -1128986161, 1023379743, 1023478108)
		+ W(11, -1096750685, -1109607147, 1031767054, 1023561226);
	WS(-1105940700, 1068951582);
	sum1 =
		W(0, 1000087558, -1126610867, 1040363554, -1103531583) + W(1, -1126498674, 1033586531, 1035444041, -1119652358)
		+ W(2, 1048983991, -1095183320, 1041424541, 1011542187) + W(3, 1016288952, -1105308514, -1129232537, 1035540828)
		+ W(4, -1116171169, 1018737568, 1033866603, 1025089333) + W(5, 1043404182, -1091977028, -1108874003, 1021129404)
		+ W(6, 1023501510, -1101500686, 1050470779, -1098956255) + W(7, -1107291841, 1033496245, 1030903912, 1024487034)
		+ W(8, 1032787659, 1016827662, -1115835365, 1023594100) + W(9, -1121882082, 1036868116, 1042688239, -1107477027)
		+ W(10, 1038297635, 1015384473, -1139243976, -1137536646)
		+ W(11, 1051055933, -1111432589, -1101253029, 1034920923);
	sum2 = W(0, -1123978268, -1102554320, 1043643239, 1026913323)
		 + W(1, 1031431539, -1112242992, -1122059260, 1044079872)
		 + W(2, -1111536011, 1056944699, 1037617295, 1005844362)
		 + W(3, -1123592170, -1093658955, 1042723115, -1093217948)
		 + W(4, -1103624535, -1101249260, 1036141312, -1094337979)
		 + W(5, 1067907418, 1064662115, -1090550375, 1042545272)
		 + W(6, -1111710804, 1045282706, -1118927202, -1091166584)
		 + W(7, -1119161360, -1111294278, -1127043568, -1139302445)
		 + W(8, 1035940631, -1092135065, -1112133073, 1025042022) + W(9, 1040694361, 983065168, 1016057395, 1041761864)
		 + W(10, 1014979737, 1026789959, -1120657957, -1105233712)
		 + W(11, 1027935282, -1104693620, -1106943303, -1114223884);
	WS(1061289911, -1074625008);
	sum1 =
		W(0, -1118986355, 1035013222, 1058027688, -1087592511) + W(1, -1107213995, 1048036382, 1042690449, -1110099132)
		+ W(2, 1047068971, 1013931199, 1008030621, -1106703359) + W(3, 1022020251, 1048074309, 1036127926, -1088015817)
		+ W(4, 1042727509, 1044183504, 1032007652, -1101544522) + W(5, 1058005973, -1099315493, -1093058723, 1029001296)
		+ W(6, 1040686510, -1102744618, 1048070472, -1091144488)
		+ W(7, 1042938237, -1106075703, -1108674269, 1043103143) + W(8, 1057593649, -1088950448, 1002612916, 1048869669)
		+ W(9, -1123719572, -1099009366, 1043345580, 1033106140)
		+ W(10, -1110941900, -1107279296, 1033202498, 1038471242)
		+ W(11, 1055515931, -1090129177, -1113377491, 1042195418);
	sum2 =
		W(0, 1034897388, 1047600068, -1092005485, 1032211690) + W(1, 1046053217, -1111289614, -1104469346, 1074182899)
		+ W(2, -1074957140, -1124075063, 981988140, 990179414) + W(3, -1104312342, 1080728354, -1067981267, -1100127529)
		+ W(4, 1036844207, -1123826485, 1033162274, 1077196082)
		+ W(5, -1071410100, -1093339345, 1030504779, -1109598746)
		+ W(6, 1001538203, 1039546617, -1101189403, 1036352485) + W(7, 1025223671, 1036519612, -1119055011, -1121476275)
		+ W(8, 1042351425, 1008083901, -1101604075, -1146561467)
		+ W(9, 1036889309, -1113609974, -1113906708, 1032631324)
		+ W(10, 1034478190, 1017678167, -1122390571, -1124909535)
		+ W(11, 1037135096, 1002134635, -1113103836, -1132393287);
	WS(-1106894556, 1030995446);
	sum1 =
		W(0, 1025589699, 1033805806, 1034528997, -1098701288) + W(1, -1119393787, 1027839817, -1123387156, 1025291593)
		+ W(2, 1054610112, -1096105008, 1037953340, -1123546765)
		+ W(3, 1028556318, -1127599047, 1039781117, -1091536615)
		+ W(4, -1120434724, 1027349522, -1139656804, -1105750398)
		+ W(5, 1065523109, -1090836572, -1103173850, 1022652480) + W(6, 980812294, -1104274718, 1054896451, -1097995702)
		+ W(7, -1111869411, -1135075504, -1128131860, -1117867836)
		+ W(8, 1045458038, 1039238949, -1104116474, -1125284461)
		+ W(9, -1137342353, 1018769427, 1040199808, -1110811780)
		+ W(10, -1129786002, -1152753902, 1017797929, -1114245906)
		+ W(11, 1047692618, 1001735913, -1106977725, -1131064048);
	sum2 = W(0, 1030581609, -1096073996, -1104952058, 1036583621)
		 + W(1, 1006888722, 1023568502, -1110091164, -1132437108)
		 + W(2, 1031847146, 1040176294, -1120421639, -1124563800) + W(3, 1024868796, 1051933742, 1077840619, 1056082302)
		 + W(4, -1114613612, 1026684617, -1124528958, 1042406776)
		 + W(5, -1071401906, -1080138625, 1012484405, -1114165836)
		 + W(6, -1175372351, -1117745155, -1108532142, 1039833458)
		 + W(7, 1044393926, -1139194300, 1022252519, -1117509823)
		 + W(8, -1107574374, 1041695761, -1112420268, 1023135287)
		 + W(9, -1123141270, -1110977956, 1034777920, -1119756119)
		 + W(10, 1028893644, -1122696127, -1123316826, 1029056744)
		 + W(11, 1034383482, 977900031, 1027961212, 1034470668);
	WS(-1094248046, 1034739186);
	sum1 =
		W(0, -1121641997, 1043421097, -1090462057, 1057979744) + W(1, 1042504017, 1019430629, -1148807918, -1114752489)
		+ W(2, -1097763033, 1045790578, -1105205440, -1115505835)
		+ W(3, -1119896808, 1040593858, -1089339622, 1054873978) + W(4, 1029920941, 1008619887, -1118546659, 1043491504)
		+ W(5, -1089142502, 1054724534, -1114903193, 1038945077)
		+ W(6, -1117202258, 1033892386, -1089696734, 1056858543) + W(7, -1102740772, 1025474934, 1027770003, 1035924243)
		+ W(8, -1098379668, 1046524773, 1042806872, -1148381698)
		+ W(9, -1121511758, 1032482905, -1096843609, 1049846778)
		+ W(10, -1103488653, 1017864241, -1114510703, 1031829015)
		+ W(11, -1089945727, 1056083605, 1031492831, 1029503362);
	sum2 =
		W(0, 1032629114, -1111104155, -1111175727, 1069180600) + W(1, -1092657949, -1081878912, 1024571549, 1022922994)
		+ W(2, 1047799465, 1065968459, -1106624299, -1085703668)
		+ W(3, -1123705993, 1036988882, -1121840686, 1066031139)
		+ W(4, 1026540087, -1080884055, -1120833813, -1104365480)
		+ W(5, -1098359864, 1064223912, 1044325339, -1079207816) + W(6, 1031286487, 1038064580, 1008715668, 1062275672)
		+ W(7, 1048614780, -1083548865, -1113289848, -1119955010)
		+ W(8, -1115327032, 1060225053, -1117772151, -1085294305) + W(9, 1033808184, 1018164430, 1042276675, 1060364945)
		+ W(10, -1105153406, -1090372695, 1035572024, -1144675449)
		+ W(11, -1114533548, 1057151625, -1103516228, -1100806033);
	WS(-1095016302, 1049780935);
	sum1 =
		W(0, -1140214663, 1050711943, 1044505338, -1092537964) + W(1, -1110639373, 1025322472, 1008440267, -1110792724)
		+ W(2, 1051364259, -1101785640, 1026645590, 1024485132) + W(3, -1137823987, 1036012635, 1051977632, -1091742968)
		+ W(4, -1130979716, 1018037601, 1035221148, -1104496021)
		+ W(5, 1058946996, -1090015552, -1106527650, 1032762847)
		+ W(6, 1007510683, -1145733059, 1056967247, -1090979415)
		+ W(7, -1146016549, 1010918699, 1029727784, -1109552317) + W(8, 1057598839, -1088424934, 1015167915, 1027572437)
		+ W(9, -1142229143, -1115585956, 1050931556, -1096995861)
		+ W(10, 1009720606, -1127055707, 1025812851, -1142816275)
		+ W(11, 1058283380, -1095074239, -1105047309, 1011865435);
	sum2 = W(0, 1040969494, -1087779211, 1056604611, 1059045592) + W(1, -1085730308, 1035668628, 1036141535, 1033693595)
		 + W(2, -1095617275, 1037950807, 1051875566, -1110274633)
		 + W(3, -1136101349, -1096934819, 1057610078, 1059474718)
		 + W(4, -1104408796, -1106464684, 1015318832, 1042126031)
		 + W(5, 1059711341, 1079595174, 1011257519, -1106179801)
		 + W(6, -1112220931, 1036377831, -1098744628, 1065421414)
		 + W(7, -1102027272, 1035078820, -1111621316, 1046621966)
		 + W(8, -1088974739, -1079659864, -1097874228, 1045400280)
		 + W(9, 1042180910, -1129542795, -1112239718, -1077353318)
		 + W(10, -1123714793, -1122902412, -1115487487, 1052735842)
		 + W(11, -1089093989, -1076641223, -1089345613, 1057832501);
	WS(-1081166556, -1096725839);
	sum1 = W(0, -1146977357, -1114510289, 1050030946, -1102646113)
		 + W(1, -1113153825, -1114582784, -1130642485, -1119269199)
		 + W(2, 1045921361, -1098664649, 992772066, 1022415207) + W(3, 1032268722, 1038356317, 1039889859, 1027769520)
		 + W(4, 1041426283, 1025422681, -1111253552, -1095921640)
		 + W(5, 1057711094, -1089074675, -1107182252, -1098886685)
		 + W(6, 1024786511, 1038758688, 1053078718, -1098156409) + W(7, 1043642083, 1036466489, 1021187873, -1102108905)
		 + W(8, 1045805544, -1106011300, -1131324475, -1129952762)
		 + W(9, -1115200917, -1117501552, 1042557010, -1102728052)
		 + W(10, -1148235644, -1133449046, 1021141494, 1024092394)
		 + W(11, 1052716334, -1107570834, -1153593794, 1012650491);
	sum2 =
		W(0, -1154116071, 1032309947, -1123962703, -1133231158) + W(1, -1128886461, 1035599863, -1120032365, 1017679770)
		+ W(2, 1025906643, -1134787122, -1108727038, 1039832482)
		+ W(3, 1033357218, -1118521489, 1007375557, -1096414395) + W(4, 1020492423, 1035524914, -1132933754, 1020082264)
		+ W(5, -1114291801, 1064675801, -1080568363, 1059399952)
		+ W(6, -1165588207, -1122971142, -1114360955, -1097709607)
		+ W(7, -1108104258, 1040378905, 1029048100, 1015972752) + W(8, 1031540723, 1040110606, -1112615988, 1024318985)
		+ W(9, -1115144648, 1021714009, -1136421576, -1121524587)
		+ W(10, -1111963053, 1036458899, 1020455541, -1134334294)
		+ W(11, 1014310369, -1119507729, 1028363593, -1122706022);
	WS(1058284215, -1100256461);
	sum1 = W(0, -1136333391, 1042064203, 1048792691, -1108621703) + W(1, -1107171315, 1009105958, 977549609, 1017583666)
		 + W(2, 1037147366, -1098054746, 1036542212, -1118222526)
		 + W(3, 1023954799, -1103445177, 1061193316, -1084539629) + W(4, 1001865121, 1005641493, 1032458293, 1003134525)
		 + W(5, 1055543997, -1105743629, -1113492892, 1001049989)
		 + W(6, -1131855793, 1030077610, -1089393894, 1061657482)
		 + W(7, -1095280499, -1141919717, -1132003829, 1044505715)
		 + W(8, -1102389770, -1111653453, 1000070140, 1031530183)
		 + W(9, 1014651348, 1034368605, -1126089633, 1032593324)
		 + W(10, -1124982771, 957669220, 1007647892, -1109681210)
		 + W(11, 1030932473, -1134741175, 1012906393, -1123915241);
	sum2 =
		W(0, 1025749667, 1018718450, -1104497483, -1109821356) + W(1, 1032840840, 1009497507, -1112523495, 1033569638)
		+ W(2, -1111912018, 1026676021, -1114119398, 1017944258)
		+ W(3, 1034709000, -1099586256, -1087345020, -1092985416)
		+ W(4, 1018773778, 1033599708, 1021531102, -1096388774) + W(5, 1061077725, 1065372034, -1129773592, -1109427758)
		+ W(6, -1129693762, -1109846828, 1049253485, 1048850468)
		+ W(7, -1101038787, 1029395381, 1006685387, -1112379914)
		+ W(8, -1117456886, -1106255761, 1043058397, -1106769492)
		+ W(9, -1119027428, 1008781387, 1038233914, 1013968523)
		+ W(10, -1113511705, 1020319838, -1106459716, 1045287677)
		+ W(11, -1135366091, -1138431127, 1037121278, -1113647178);
	WS(1048665454, 1062854025);
	sum1 =
		W(0, 1004974300, -1140401360, 1040482153, -1107105990) + W(1, -1113947114, 1004764812, 1032679478, -1099989608)
		+ W(2, 1038119146, -1094089019, 1043046180, -1132148363)
		+ W(3, 1041394910, -1108003052, 1050737065, -1084721726) + W(4, 1044891839, 1022372181, 1026224498, -1103518244)
		+ W(5, 1054936910, 1054691719, 1025601857, -1113753404) + W(6, -1128844481, 1044968661, -1084409495, 1057517320)
		+ W(7, 1022006333, 1033354242, -1137588617, 1040271757) + W(8, -1099872844, 1035416977, 1017193535, -1131287582)
		+ W(9, -1115578718, 1031459778, -1107158134, 1033669936)
		+ W(10, 1025595521, -1112957780, -1128306202, -1114933822)
		+ W(11, 1038726400, 1032390235, 1023203548, 1012659010);
	sum2 = W(0, -1120028750, -1116919239, 1026537129, 1032246372)
		 + W(1, 1047938064, -1102851233, -1137390044, 1034599590)
		 + W(2, -1105861815, -1095438265, 1022176478, -1129352893)
		 + W(3, 1031876652, -1110926857, -1114848017, -1093245727)
		 + W(4, -1093210017, 1046245506, -1112211314, 1037510574)
		 + W(5, 1054207178, 1062401065, -1118385188, -1106645860)
		 + W(6, 1041988042, -1091078601, 1059021754, -1115099719)
		 + W(7, -1104427658, 1043294706, -1105672202, 1052042083)
		 + W(8, -1104155840, -1100501338, 1013766280, 1016480352)
		 + W(9, 1032816067, -1102117757, 1047757772, -1112097107)
		 + W(10, 1027075631, -1113418727, -1122489809, 1043447553)
		 + W(11, -1115066040, -1102195598, 1027463789, 1030659187);
	WS(1046819548, -1112403026);
	sum1 =
		W(0, 1043575156, -1096536373, 1028458839, 1042563315) + W(1, -1147631681, -1134760216, -1118831073, 1040283909)
		+ W(2, 1047473762, -1108795847, -1115473730, 1037371629) + W(3, 1028002987, 1049135339, -1083606160, 1040849058)
		+ W(4, 1015994849, 1036578576, 1025124390, -1115136450) + W(5, 1052252597, 1045384892, -1102431101, -1147407721)
		+ W(6, 1023377962, -1127238030, 1054448495, -1081137782) + W(7, 1046487189, 1029054905, 1034880715, 1042113706)
		+ W(8, -1106041242, 1040945110, 1026652836, -1113175874)
		+ W(9, -1125071779, -1124049974, 1031800519, 1026387221)
		+ W(10, -1096718751, 1032040846, -1144027915, 1045174012)
		+ W(11, -1138801364, -1122981994, 1030118403, -1121286085);
	sum2 =
		W(0, -1116472244, 1036928405, 1035706238, -1121318128) + W(1, -1114868876, 1033058067, 1025044698, -1122373594)
		+ W(2, 1040619830, -1104861162, 1034962287, -1110745183)
		+ W(3, -1123391126, -1111538981, 1046111644, 1038958235)
		+ W(4, 1034772140, -1130393948, 1003069456, -1111848203) + W(5, 1044878634, 1050016986, -1113883437, 1005454840)
		+ W(6, -1129719684, 1027481573, 1017226015, 1040124875) + W(7, -1114732111, -1105702279, -1110477199, 990411281)
		+ W(8, 1030695866, -1116142138, -1102609372, 1029172520)
		+ W(9, 1023677849, -1136822924, -1114454329, -1113301330)
		+ W(10, 1029458562, -1112847239, 989635105, -1136314996)
		+ W(11, 1007553654, -1112411005, -1109652887, -1150621057);
	WS(1054158702, -1098491196);
	sum1 = W(0, -1129450472, -1119237644, -1101713087, 1033589815) + W(1, 1034513750, 1023147092, 983582877, 1026235385)
		 + W(2, -1098493798, 1048228620, -1123359016, -1173092218)
		 + W(3, -1121209423, 1037197666, -1083899440, 1060260620)
		 + W(4, -1103037013, 1035595873, -1121678922, 1031464488)
		 + W(5, -1103778771, 1056756834, -1122982297, 1020058530)
		 + W(6, 1031290553, -1099798307, 1057005120, -1093716116)
		 + W(7, 1049393023, -1117980637, -1119715259, -1102325483)
		 + W(8, 1046824098, -1102446942, 1028221304, -1124996559)
		 + W(9, 1032360987, -1107157175, 1037130136, -1111054172)
		 + W(10, 1041637742, -1115548960, -1115265987, 1036899466)
		 + W(11, 1011053924, -1132207900, 992781927, 995105423);
	sum2 =
		W(0, 1022318336, 1013555797, -1107715656, 1023151297) + W(1, 1033284778, -1133592549, -1115650269, 1016103802)
		+ W(2, -1119261847, -1114491928, -1130031974, -1142562170)
		+ W(3, 1023537352, 1041650416, 1043696631, 1042399799) + W(4, -1108010060, -1132296546, -1109544964, 1052577828)
		+ W(5, -1093802466, -1088107917, 1027122983, 1012286637)
		+ W(6, -1104797311, -1105646271, 1070961498, 1046742027)
		+ W(7, -1123089325, -1129646858, 1016525394, -1089308865)
		+ W(8, -1101461419, 1041655381, 1023301191, -1123666701)
		+ W(9, 1034835508, -1093424353, -1129647390, 1027817568)
		+ W(10, 1010592861, 1020078242, 1033208955, -1123233885)
		+ W(11, -1103638866, -1123805293, 1027104379, 1017326494);
	WS(-1098756718, 1025257793);
	sum1 =
		W(0, -1170432841, 1023803110, -1090131561, 1057699745) + W(1, -1119694405, 1012926412, 992949730, -1138344011)
		+ W(2, -1107275570, 1040420307, -1117188674, -1123369303)
		+ W(3, 1001883457, 1026014126, -1096556254, 1054103406)
		+ W(4, -1115724526, -1127845816, 1015181254, -1121590721)
		+ W(5, -1096688477, 1044394251, 1029634610, 1035099253)
		+ W(6, -1113865961, -1118191492, -1094031636, 1054646511)
		+ W(7, -1140440641, -1114907963, 1025052052, -1131017933)
		+ W(8, -1105028073, 1053702338, -1105231572, 1041135600) + W(9, -1142935155, 992699702, -1106433523, 1018441892)
		+ W(10, 1028218227, -1110839852, 1028407518, -1125677724)
		+ W(11, -1094260670, 1056434389, -1115106656, 1033590433);
	sum2 =
		W(0, -1113857499, 1035336978, 1003212424, 1016146718) + W(1, -1124908942, 1007728744, 1017397942, 977119295)
		+ W(2, -1169985407, -1139136560, -1127032094, 1015257206) + W(3, 994248048, 1058657166, -1086726098, 1029663775)
		+ W(4, -1128987279, -1139895388, -1107301692, 1082282453)
		+ W(5, -1067974855, -1088717558, 1045162011, 989071903) + W(6, -1114604929, 1081592322, -1065596346, 1032721198)
		+ W(7, -1132432620, -1115423533, -1099171315, 1057428850)
		+ W(8, -1101606461, -1109521003, 1001306728, 1026551071)
		+ W(9, -1128156929, 1029982493, -1114706375, 1035913834)
		+ W(10, -1127893472, -1124574009, -1105825924, 1050573738)
		+ W(11, -1113547007, -1115579388, 1022139202, 999865176);
	WS(1057488311, 1032489366);
	sum1 = W(0, 998859696, -1107316871, -1130375162, 1045821468)
		 + W(1, 1009430200, -1127874328, -1126361486, 1034785118)
		 + W(2, -1098594694, 1031878554, -1137835434, -1124885440)
		 + W(3, 1028022609, -1114064513, -1105098668, 1057263754)
		 + W(4, -1104540630, -1121514949, -1139957040, 1048520075)
		 + W(5, -1099155379, -1127500588, 1033795278, 1026343507)
		 + W(6, 1015295094, -1112481238, -1109749909, 1049599048)
		 + W(7, -1105774078, 1007199100, -1122345661, -1154023155)
		 + W(8, -1112014022, 1025402492, 1046311438, -1119007402)
		 + W(9, -1126668079, -1133481329, -1114013594, 1034877470)
		 + W(10, -1109189150, 1026086402, -1129886863, -1108825451)
		 + W(11, -1116334683, 1046739556, -1119327433, -1138298796);
	sum2 =
		W(0, -1131728975, 1036764889, -1111227173, -1128881737) + W(1, 1037242625, -1122740141, 1035973522, -1115068573)
		+ W(2, 1022919798, 1043114423, 990889655, -1130091274) + W(3, 1044679054, -1096357732, -1128128484, -1098903856)
		+ W(4, 1034691185, -1126568042, 1057647035, -1081650015) + W(5, 1064645808, -1105946360, 997618289, 1036162942)
		+ W(6, 1029801795, 1008652352, -1094730608, -1121257166)
		+ W(7, -1119761613, -1145265129, -1120435503, 1020148594)
		+ W(8, 1034184152, -1122224678, -1123774451, 1016517254) + W(9, 1040526136, 1019038058, -1110501324, 1033879187)
		+ W(10, 1017411026, 1025838030, 1001204178, -1125968836)
		+ W(11, -1141167471, -1125677560, 1017460301, -1121815648);
	WS(1059796919, -1120566973);
	sum1 =
		W(0, -1128913552, -1112300176, -1105877684, 1051198984) + W(1, 1031319296, -1128535084, -1121363289, 1042197939)
		+ W(2, -1097436160, 1044389601, -1156941767, 1024751122)
		+ W(3, -1114223569, 1034918960, -1084964393, 1058261945)
		+ W(4, -1115209492, 1025460631, -1170089852, 1019526904) + W(5, 1000497399, 1057668526, 1032065846, 1032881746)
		+ W(6, 1032486790, -1097594444, 1058860547, -1083919657) + W(7, 1045243539, 1010383044, 1007200827, -1109654209)
		+ W(8, 1031553246, -1093305914, 1041280427, 986576750) + W(9, 1031548233, -1121876014, 1038828418, -1113158982)
		+ W(10, 1014469175, 1034628234, 1025411673, -1114258964)
		+ W(11, -1106885131, 1024357474, -1128319413, 1012703988);
	sum2 = W(0, -1143612781, 1030657759, -1142189493, -1116365956)
		 + W(1, -1108113093, -1144957229, 1024653023, -1114346787)
		 + W(2, -1145631357, -1122350618, -1120960689, 1013910379)
		 + W(3, 1031492195, -1115709916, 1041520845, -1109597137)
		 + W(4, -1100459142, 1028619709, -1118229715, -1122961088)
		 + W(5, 1058735511, 1063925227, -1102646250, 1003281301)
		 + W(6, 1037055061, 1023143173, -1123318690, -1097941231)
		 + W(7, -1097541479, 1040501280, -1103747903, 1032102149)
		 + W(8, -1113230658, -1096423541, -1119600722, 1015718737)
		 + W(9, 1027878177, 1035049663, -1107577516, 1034348655)
		 + W(10, 994779835, -1116733621, -1120661119, -1115297076)
		 + W(11, 1029140405, -1104473650, 1048901284, -1122107736);
	WS(1025862512, -1097886171);
	sum1 =
		W(0, 1017995501, 1039868615, -1084617440, 1048852846) + W(1, 1036255511, 1003283810, 1028206791, 1039095646)
		+ W(2, -1095591910, 1046495341, 1032043925, 1031081728) + W(3, -1115115241, 1044724702, -1088992852, 1053236428)
		+ W(4, 974144948, -1128580235, 1023900364, 1040670187) + W(5, -1089161581, 1054642003, 1024473755, 1033561578)
		+ W(6, 973319892, 1036683863, -1092805231, 1050422468) + W(7, -1132527589, 1012484477, 1028215869, -1105649212)
		+ W(8, -1107053347, 1049220624, -1120787802, -1126192084)
		+ W(9, 1033665516, 1040757263, -1107160205, 1039010398) + W(10, 1025750940, 1035723265, 1031994596, -1101644966)
		+ W(11, -1102281943, 1042256548, 1034960116, -1141688154);
	sum2 = W(0, 1017309480, -1113384832, 1051665642, -1106075829)
		 + W(1, 1041533127, -1143916576, -1115898040, -1105498372)
		 + W(2, 1043260681, 1041703091, -1122221676, -1119502308)
		 + W(3, 1026950620, -1140340528, -1109716244, -1109231476)
		 + W(4, 1047102067, 1032670038, -1131938440, -1101077232)
		 + W(5, 1039662810, 1049668212, -1109791178, -1130795288)
		 + W(6, -1120377052, -1114410560, -1113565360, 1032262130)
		 + W(7, 1039963022, -1112068676, -1147724576, 1042402941)
		 + W(8, -1097796100, 1040746517, -1131969000, 1031201932)
		 + W(9, -1108926548, -1114542528, -1108348496, -1140600496)
		 + W(10, 1032294606, -1108483346, -1120540424, 1040078450)
		 + W(11, -1097463639, 1048026467, -1107112902, 1028500076);
	WS(1059594295, -1081462343);
	sum1 = W(0, 1027153262, 1043504002, 1052804111, -1087238767) + W(1, 1041162890, 1012415888, 978268098, -1116748340)
		 + W(2, 1047257898, -1102654539, 1038115889, -1165722369)
		 + W(3, 1020914066, 1039643767, 1049749519, -1086204143) + W(4, 1044063108, 1033818911, 1037283618, 1038369681)
		 + W(5, 1054855273, -1088075529, 1037006730, 1032180390) + W(6, 1001487768, 1034058802, 1047397560, -1086503800)
		 + W(7, -1117492081, 991868273, 1024040629, 1040894970) + W(8, 1052275873, -1098202447, 1024505810, 1034352017)
		 + W(9, -1121199663, -1111840522, 1039603542, -1107277965)
		 + W(10, 995252542, -1131707508, 1022356543, 1036921959)
		 + W(11, 1026848211, -1098696769, 1036480704, -1136594828);
	sum2 = W(0, 1028621181, -1120219585, 1035384087, 1034472183)
		 + W(1, -1123130413, -1120488613, -1110777341, -1127812186)
		 + W(2, -1126856730, -1129759266, -1106344343, -1132463093)
		 + W(3, 1027102605, -1121966109, 1038893967, -1123472797)
		 + W(4, -1121376361, -1111137329, 1030597213, -1109734497)
		 + W(5, 1046142043, 1054407172, -1110811845, 1013238549)
		 + W(6, -1106396561, -1139970197, -1102581665, -1114873213)
		 + W(7, -1147353578, -1113345499, 1041951037, 1005564394) + W(8, 1024169581, 1049042812, 1023037898, 1010521365)
		 + W(9, -1110468651, 1027913013, -1119264521, -1104920828)
		 + W(10, -1123538565, -1123696429, 1026771477, 1021745754)
		 + W(11, 1045072501, -1117275361, -1108801471, 934750635);
	WS(1001790336, 1033193226);
	sum1 = W(0, -1113292474, 1018580889, -1117909243, 1052553934)
		 + W(1, -1104113579, -1129785460, -1131356554, -1115176285)
		 + W(2, 1046326027, -1113855449, -1112351060, -1156866531)
		 + W(3, -1133969725, -1102427201, 1041639692, 1060794158)
		 + W(4, -1095014251, -1132017542, -1118664394, -1094752997)
		 + W(5, 1062953181, 999804065, -1105541862, -1130622370)
		 + W(6, 1027204153, -1105768635, 1031529696, -1122254720)
		 + W(7, -1102735326, 1022740922, -1111709325, -1119059021)
		 + W(8, 1040555139, -1110352445, 1031818996, -1121415144)
		 + W(9, 1024655285, -1121009370, -1115548569, 1026923705)
		 + W(10, 1008421480, 1008916224, -1127980619, -1131789226)
		 + W(11, 1030139737, -1100154756, 1016036429, -1122315305);
	sum2 =
		W(0, 999771042, 1019371878, 1035878909, -1106457448) + W(1, 1038257769, -1118330440, -1130012060, -1137594745)
		+ W(2, 991329315, 1043986431, -1108709562, -1156785507) + W(3, -1123589256, 1002965746, 1042318306, -1118271248)
		+ W(4, 1025444512, -1134019065, 1018901632, -1114341154) + W(5, 1053769225, 1057361082, -1113472862, 1021163648)
		+ W(6, -1124249760, -1115605194, 1010690665, -1102884302)
		+ W(7, 1015483632, -1123825168, 1017234680, 1017493044) + W(8, -1099274218, 1037230696, -1115820708, 1025071687)
		+ W(9, -1118367200, 1015905000, -1101115118, -1112309114)
		+ W(10, 1020142296, -1126466092, 1016197020, 1024661143)
		+ W(11, -1092869373, 1036147884, 1016005876, 1013380697);
	WS(-1096043118, -1087645231);
	sum1 =
		W(0, -1115587665, 1029203067, 1045341850, -1106908023) + W(1, -1131991862, -1114910160, 1032694426, -1099485226)
		+ W(2, 1017432376, 1052615508, -1113683692, -1127306394)
		+ W(3, 1031441086, -1113336032, 1054321442, -1082902530) + W(4, 1050084000, 998100766, 1023546425, -1121275799)
		+ W(5, 1050158903, 1045376289, -1116607496, -1147820543)
		+ W(6, -1130229584, 1051148019, -1081266857, 1057440145)
		+ W(7, 1027649766, 1021215128, -1147531597, -1118364796) + W(8, 1047006846, -1118131945, -1120491559, 991663462)
		+ W(9, 1019733960, -1127235090, -1106232936, -1134199968)
		+ W(10, 1027530281, -1123554607, -1115129818, -1119188228)
		+ W(11, 1041137522, 1018710010, -1131853547, -1124042776);
	sum2 =
		W(0, -1129211209, 1023515648, 1040374834, -1110890211) + W(1, 1020265593, 1023672492, 1023861908, -1119658781)
		+ W(2, -1108471855, -1133136545, 1048083250, -1109425046)
		+ W(3, 1038235290, -1121364796, -1096619497, 1044872450)
		+ W(4, 1034188808, -1121333166, 1029997412, -1103304652)
		+ W(5, 1039720436, 1050855479, -1102257516, -1130250517)
		+ W(6, -1125523437, -1109858923, -1113539350, -1117035130)
		+ W(7, 1022698753, 1029442100, -1107362446, 1044349350) + W(8, 1038091910, -1107498682, 1024895152, -1122118916)
		+ W(9, -1114850415, 1032218024, -1121557752, -1130602657)
		+ W(10, -1162309256, 1020180841, 1013933265, 1027861436)
		+ W(11, 982770184, -1128608489, -1129090321, 939323929);
	WS(1062090935, 1058767985);
	sum1 =
		W(0, 1016379967, -1111629724, -1115487571, 1040669191) + W(1, -1124650927, -1131647467, -1127587553, 1016014666)
		+ W(2, 1046030390, -1131263417, -1107621674, 1039946613)
		+ W(3, -1124869109, 1045897412, -1089079359, 1049140321)
		+ W(4, -1120715392, -1197661491, 1030044278, 1039181162) + W(5, -1107063038, 1046027952, 1035258018, 1033161790)
		+ W(6, -1135267218, -1111908667, 1056809425, -1082917799)
		+ W(7, 1051125844, -1129645073, 1021197901, 1032078908)
		+ W(8, -1100036461, 1040408361, -1117322707, -1124734374)
		+ W(9, -1146487047, -1129970444, 1008766834, -1115518322)
		+ W(10, -1115270659, 1029976235, 1001072263, 1037221664)
		+ W(11, -1118068997, 1034380765, -1135017032, -1119763541);
	sum2 =
		W(0, 1033054007, -1111327982, -1121722910, 1038740385) + W(1, -1119336676, -1124024618, -1116547758, 1041352776)
		+ W(2, 1034677105, -1115132829, -1124364804, 1035204548)
		+ W(3, -1123189128, 1032790615, 1033549613, -1092378351) + W(4, -1102497930, 1032784783, 1033469023, 1012971008)
		+ W(5, 1033020303, -1108961666, -1106694042, 1032253989)
		+ W(6, -1122818756, -1098982462, 1051050782, -1121004928) + W(7, 1035128176, 1009754028, 1026371779, 1042838787)
		+ W(8, -1098306997, 1045175561, 1039643256, -1118316692)
		+ W(9, -1136838880, -1110172088, 1034801784, 1019964530)
		+ W(10, 1015821086, -1125398316, -1137766108, 1004924993)
		+ W(11, -1120000922, 1027487385, 1017988993, 1028774587);
	WS(1065136439, 1040354336);
	sum1 = W(0, -1140671753, -1108811053, 1057254373, -1099781359)
		 + W(1, 1009251305, 1003726785, -1120274067, -1107804932)
		 + W(2, 1050226223, -1098842784, 1010162395, -1112753158)
		 + W(3, 1022747450, -1110160675, 1059609336, -1092867554)
		 + W(4, 1036945681, -1120831377, -1124666160, -1105899870)
		 + W(5, 1031464345, 1000731409, -1114655220, -1112429520)
		 + W(6, -1123069063, 1025125049, -1093137163, 1058399851)
		 + W(7, -1109467235, -1119063979, -1131113682, 1033405406)
		 + W(8, -1111386668, 1055942809, -1101547023, -1146511789)
		 + W(9, -1118356003, -1129239633, -1105328992, 1044975810)
		 + W(10, -1113825780, -1116155918, -1126498983, 1016924742)
		 + W(11, -1111235284, 1051704028, -1104493413, -1117793303);
	sum2 = W(0, -1139839138, 1034041544, 1034669108, -1095769692) + W(1, -1105759439, 1039138956, 998321428, 1018598993)
		 + W(2, -1116818777, -1114897304, -1105398904, -1145690340)
		 + W(3, -1134067290, 987604943, 1007335842, -1102588486)
		 + W(4, -1108283066, 1018314989, 1024466364, -1102834025)
		 + W(5, 1061492513, 1062722215, -1098749835, 1025712340)
		 + W(6, 1008723794, -1131349085, -1121214551, -1107691916)
		 + W(7, -1108418109, 1022467761, -1119932526, -1118877643)
		 + W(8, -1116983417, -1117176868, 1041629273, -1121476700)
		 + W(9, 1028368392, 1031347596, -1114752830, 1009572226)
		 + W(10, -1103951670, 1033232162, -1132382549, -1113750023)
		 + W(11, -1103912225, 1035794880, 1046707789, -1110829011);
	WS(1015535328, -1084984071);
	sum1 = W(0, -1114800552, -1108603860, -1099862310, 1058689409)
		 + W(1, -1114937124, -1119809253, 1017574081, -1120445077)
		 + W(2, -1098244185, 1050368026, -1113854018, -1119794874)
		 + W(3, -1121052395, -1120661414, -1094435959, 1059588503)
		 + W(4, -1120887600, -1117398367, -1121642214, 1038434434)
		 + W(5, -1091868509, 1053265766, 1038069402, -1124845785)
		 + W(6, 1031943978, 1004694578, -1100742889, 1053762387) + W(7, 1032168457, -1126829041, -1119258038, 983354644)
		 + W(8, -1090330210, 1049777811, 1033335786, -1124490374)
		 + W(9, 1015340962, -1131668588, -1106546547, 1042220181)
		 + W(10, -1112611163, -1122991451, -1152091148, -1117988144)
		 + W(11, -1096238847, 1044693386, 1033654385, 1025017029);
	sum2 = W(0, -1113763234, -1123863865, -1152383745, -1153318001)
		 + W(1, 1032880554, -1112434267, -1113925793, -1117743388)
		 + W(2, 1049718598, -1115051721, -1108241407, 1017487533)
		 + W(3, -1117079348, 1031541130, 1054034272, -1111062529)
		 + W(4, 1025815300, -1115045873, 1016562523, 1034144457) + W(5, 1045174355, 1029337732, 1040219109, -1115252534)
		 + W(6, -1106152769, -1108434934, 1019958281, -1107848604)
		 + W(7, -1122950542, -1112234054, 1021767953, 1028245712)
		 + W(8, 1048832333, 1036566626, 1032317223, -1144290245)
		 + W(9, -1110489214, -1107854239, 1037079656, -1106439039)
		 + W(10, -1114917041, -1111099643, -1118706081, -1131124226)
		 + W(11, 1041167636, -1100833945, 1023645948, -1123196065);
	WS(1058837943, 1069665989);
	sum1 = W(0, 962159770, -1123278397, 1059574623, -1100091288)
		 + W(1, -1106975399, 1026912571, -1131526763, -1133106088)
		 + W(2, 1052414436, -1100255560, 1034080493, 1026538575)
		 + W(3, -1123587520, -1111839826, 1056026369, -1090882007)
		 + W(4, 1026032901, -1128992103, 1016761717, -1119033369)
		 + W(5, 1050778647, -1089604336, 1030312842, -1142474253)
		 + W(6, -1116652202, -1112323118, 1057288447, -1090318286)
		 + W(7, -1115237492, -1126485147, 1020359383, -1123741278)
		 + W(8, 1051933055, -1098258189, -1123145400, 1024876312)
		 + W(9, -1124916236, -1111587013, 1049400292, -1098860821)
		 + W(10, 1023272149, -1130617057, -1120750038, 1031183749)
		 + W(11, 1050858601, -1113801599, -1102573630, -1147252941);
	sum2 =
		W(0, 1031825723, 1031898082, -1068962638, -1097279430) + W(1, -1106804175, 1033946762, -1121672345, -1123032728)
		+ W(2, -1070958719, 1042495248, 1004890268, 1015278793) + W(3, -1128689519, -1149677000, 1062859919, 1042236169)
		+ W(4, 1033261211, -1125393239, 1003655756, 1042326937) + W(5, 1079716701, -1097154173, 1047991146, -1129356209)
		+ W(6, -1112729716, 1016978721, 1069238165, 1043003442) + W(7, 1029430153, -1130449529, 1021714543, -1135526098)
		+ W(8, -1106783417, -1101596383, 1006662138, -1143028884)
		+ W(9, -1143241256, 1017362221, 1038638730, -1114855682)
		+ W(10, 1016716693, 1021676019, 1015056847, -1115756346)
		+ W(11, 1030095799, 1029691669, -1116617969, 1007567766);
	WS(1027937136, 1051433372);
	sum1 = W(0, 1024223452, 1027262836, -1095583884, 1036904555) + W(1, 1037383306, 1026871330, -1131494490, 1034970897)
		 + W(2, -1102510757, 1043230726, -1126475809, -1131579916)
		 + W(3, 1034208027, 1041574867, -1088128354, 1043513377) + W(4, 1038022750, 1022249046, -1113660825, 1051529138)
		 + W(5, -1082034838, -1088109312, 1049740992, -1121104697)
		 + W(6, 1026687777, 1043759333, -1107709564, 1040837474) + W(7, 1043020088, 1030621125, 1007645322, 1035492122)
		 + W(8, 1021392868, 1023668834, 1040579632, -1128113439) + W(9, 1019229306, 1025216066, -1116281753, 1033050768)
		 + W(10, 968839375, 1026071912, 1023660333, 1033175550) + W(11, 1019915650, 1041627229, 1040383308, 1024084817);
	sum2 = W(0, -1122636491, 1019704225, 1049771287, -1108218455)
		 + W(1, 1003686724, 1007985666, -1114076695, 1037288383) + W(2, 1032297878, 1029534785, -1114871835, 1019192761)
		 + W(3, -1122337791, 1038646185, 1050229287, 1038576544)
		 + W(4, 1026526587, -1146139348, -1121313911, -1113812515)
		 + W(5, 1058219066, 1058416091, -1129529893, 1021492965)
		 + W(6, 1019616565, -1115379683, -1126947029, -1096957025)
		 + W(7, 1020162449, -1131201101, 1032037049, -1144905268)
		 + W(8, -1089173556, 1029636273, 1011141050, -1129337357)
		 + W(9, -1121846167, -1124810757, -1109798125, -1112204367)
		 + W(10, 1015768281, -1117257463, 1035628188, -1104091459)
		 + W(11, -1085784913, 1039375301, -1169657505, 1026702945);
	WS(-1087300279, 1060388257);
	sum1 =
		W(0, -1129462823, 1023690092, -1095623283, -1106106692) + W(1, 1037669414, -1130365587, 1031115364, 1041026294)
		+ W(2, -1092905754, 1045171988, -1113959460, -1127843579)
		+ W(3, -1114720439, 1027269348, -1093094418, 1058204318)
		+ W(4, -1142625182, -1122973026, 1025637865, 1022155151) + W(5, -1092295181, 1060821043, 1044954958, 1027810288)
		+ W(6, -1150727557, 1032140389, -1091295733, 1047241920) + W(7, 1031904715, 1008074737, 1019407412, 1019365849)
		+ W(8, -1094422277, 1051757075, 1022315054, 1005685302) + W(9, 1005184420, 1035913085, -1097873082, 1047453654)
		+ W(10, -1121754201, 1011776124, -1144567588, -1142073248)
		+ W(11, -1089577936, 1052799910, 1027854342, 1023937224);
	sum2 = W(0, -1120594034, -1166872476, 1040489823, -1102509951)
		 + W(1, -1086857984, 1045679794, -1141459412, 1004777140)
		 + W(2, -1122900789, -1110936244, -1095818924, -1104593759)
		 + W(3, -1136839806, -1113289360, 1021539093, 1067324619)
		 + W(4, -1093760272, -1110068744, 1028313984, 1013932442)
		 + W(5, -1095750682, 1045560576, 1065644346, -1103109579)
		 + W(6, -1127607807, 1019995585, 1045364618, -1096904945)
		 + W(7, -1123950010, 1034732462, -1122936307, -1124945717)
		 + W(8, 1031026044, -1100965201, 1042979309, 1018809021) + W(9, 1007613018, -1145964804, 1033830372, 1000232964)
		 + W(10, -1121148085, -1152320711, -1134584398, -1157638606)
		 + W(11, -1125456395, -1108078168, 1026162850, 980148252);
	WS(-1090838638, 1050174926);
	sum1 =
		W(0, 1024715784, -1109115088, -1106716164, 1038102082) + W(1, -1115525408, 1016756989, 1033853293, 1049593122)
		+ W(2, -1120751425, 1051782073, -1136454131, 1035169257) + W(3, -1106406969, 994296459, -1094496661, 1043814476)
		+ W(4, -1105105482, -1108133484, 1042483832, 1045373935) + W(5, -1086184702, 1058236139, 1033520471, 1042591993)
		+ W(6, 1025782733, 1015694078, -1092092861, 1045378621)
		+ W(7, 1029286795, -1140252101, -1138965820, -1112080289)
		+ W(8, -1095245812, 1042079876, -1106373991, -1115290814)
		+ W(9, 1038488261, 1045351388, -1100690449, 1050438570)
		+ W(10, 1034575399, 1041627941, -1139164262, -1114987669)
		+ W(11, -1094326222, 1040938025, -1122199803, 1001134058);
	sum2 =
		W(0, 1051544715, -1087153288, -1090874159, 1047568122) + W(1, -1111412903, 1034895049, 1047565246, -1111682644)
		+ W(2, -1099176408, 1032035298, 1040133461, -1131191613)
		+ W(3, 1046232208, -1081925443, -1105576760, -1119008010)
		+ W(4, -1140028602, -1112144320, -1105592564, 1060283907)
		+ W(5, 1048906709, 1036693685, -1107739759, 1040322447)
		+ W(6, -1094324661, 1062548140, -1112367085, -1119206793)
		+ W(7, 1044620924, -1130045765, -1105924841, -1127110112)
		+ W(8, 1049091960, -1158298480, -1096403637, 1011461326) + W(9, 1021200095, 1051334754, -1107585156, 1036759049)
		+ W(10, 1046459856, 1012649582, -1103932050, 1033462267)
		+ W(11, 1048824237, -1114785543, -1114351857, -1111955333);
	WS(1039738296, 1044009556);
	sum1 =
		W(0, 1031992376, -1113116036, 1058890327, -1088719167) + W(1, 1040542090, -1107110028, -1118478209, -1126664684)
		+ W(2, 1042459434, -1107130859, -1129453002, 1036863629) + W(3, 1036413734, 1028656912, 1054229481, -1088309806)
		+ W(4, 1042227988, -1133301245, 1042319122, -1095949365)
		+ W(5, 1057173004, -1090115281, -1127816747, -1121635021)
		+ W(6, 1025321013, 1046101634, 1048940614, -1090901446) + W(7, 1048439133, -1120611033, 1019779694, -1104617834)
		+ W(8, 1052520321, -1096019759, -1119199044, 1022364232)
		+ W(9, -1126468451, -1111694091, 1047137387, -1098195015)
		+ W(10, 1036380619, -1108092830, 1028741314, 1029160593)
		+ W(11, 1057385245, -1090793697, 1040359505, -1129794251);
	sum2 =
		W(0, -1088996856, 1009251693, 1062110924, -1115283476) + W(1, 1030923639, 1034262626, -1089163817, -1107842867)
		+ W(2, 1057525018, 1042234988, 1032774718, -1123202523)
		+ W(3, -1081345153, -1124806950, 1064189433, -1104109471)
		+ W(4, -1126776930, -1130902850, -1080285142, 1052635731)
		+ W(5, 1067630395, -1112028150, 1034769026, 1036915346)
		+ W(6, -1079794071, -1106464080, 1063058829, -1113992476)
		+ W(7, -1106165885, -1110986466, -1089981167, -1125456570)
		+ W(8, 1062842970, 1045262592, -1136163037, 1035294670) + W(9, -1091438196, -1115606726, 1054193960, 1042247754)
		+ W(10, 1032379012, -1135519157, -1099490886, -1106662163)
		+ W(11, 1053790298, -1104249669, -1108359351, 1024576891);
	WS(-1096394862, 1050867114);
	sum1 = W(0, 975777376, 1011677768, 1050217928, -1095631255) + W(1, -1105375964, 1033079080, 1035680965, -1097606072)
		 + W(2, 1041761501, -1108785275, 1035556439, -1107649602)
		 + W(3, 1017323049, 1017467204, 1059053443, -1088500104)
		 + W(4, 1042635014, 1020084753, -1164976624, -1122057965)
		 + W(5, -1098739346, -1111108333, 1025006046, -1112750027)
		 + W(6, -1126109949, 1039142936, -1089683010, 1062642602)
		 + W(7, 1038036638, -1142614292, -1117859264, -1137149130)
		 + W(8, -1104430516, 1040456976, 1027021261, 1017623258) + W(9, 1011370603, 1023416416, -1115445691, 1016594173)
		 + W(10, 1041295544, -1113983747, -1122131819, -1112401517)
		 + W(11, 1042596520, -1120553683, 1029575724, -1124248029);
	sum2 =
		W(0, -1131210775, 1029829507, 1018275001, -1122984086) + W(1, -1096338526, 1033255054, 1024840523, -1108448221)
		+ W(2, -1117395779, -1132016729, -1114466007, -1103146109)
		+ W(3, 1024067225, 1046565608, 1042461338, 1059140985) + W(4, -1107995649, -1119288636, 1022860453, -1107856867)
		+ W(5, -1092962046, -1089805596, -1166014069, -1099911282)
		+ W(6, -1125865258, 1042031083, 1053212914, 1058514952)
		+ W(7, 1052927486, -1113255745, -1130239171, -1106481128)
		+ W(8, -1102214835, 1027704725, 1041713274, -1106771914)
		+ W(9, 1024964869, -1127390051, -1114692565, -1118917379)
		+ W(10, 1037010892, -1111017176, -1117571915, -1124576676)
		+ W(11, 991892650, 1032905776, 1032336370, 1000523989);
	WS(-1112511928, 1031640207);
	sum1 =
		W(0, 1037301926, -1102373753, 1058068053, -1091912761) + W(1, 1030698115, -1112730073, -1130112569, 1048837234)
		+ W(2, 1051625169, -1095738529, 1045615952, 1045904421)
		+ W(3, -1119711398, -1091456672, 1054040787, -1101742756)
		+ W(4, -1104227307, -1098654019, 1044751592, 1045582560)
		+ W(5, 1044375881, -1090186767, 1051640030, -1111879892)
		+ W(6, -1102628100, -1119033858, 1057193534, -1090190311)
		+ W(7, -1111999463, -1123401908, 1042267541, -1093436941)
		+ W(8, 1051238780, -1110077161, 1008998972, -1101737376) + W(9, 1021159833, 1050238014, 1045936610, -1098844722)
		+ W(10, 1050341641, 1043894710, -1122521821, -1100593739)
		+ W(11, 1058222955, -1090967581, -1108465231, -1112695488);
	sum2 =
		W(0, 1016218439, 1024549194, -1121292007, 1037076368) + W(1, -1112700443, 1032984152, 1009444234, -1117974589)
		+ W(2, -1111737758, -1110249739, 1020335555, -1112172263)
		+ W(3, -1111008440, 1042315856, 1047393563, -1086831522) + W(4, 1038599637, 1060801772, 1026480303, -1106327815)
		+ W(5, -1089871257, -1069929292, -1111547810, 1079084175)
		+ W(6, 1015374231, 1040022175, -1115783084, -1085683537) + W(7, 1049254465, 1057876572, -1115006890, 1025059842)
		+ W(8, 1043300713, 1033002057, -1118960414, 1033693800) + W(9, 1027237715, -1110870197, -1103999090, 1033912191)
		+ W(10, -1118358651, -1104475663, -1122692269, 1033099318)
		+ W(11, 1022298131, 1032775289, -1104218510, 1045399536);
	WS(-1106120924, 1033431669);
	sum1 = W(0, 1016553159, 1035990878, -1101729723, 1042266392) + W(1, 1024064284, 1018305971, -1146851238, 1041817850)
		 + W(2, 1024013341, 1027850273, 1026394008, 1021653787) + W(3, 1024375743, 1041767260, -1116899488, 977256084)
		 + W(4, 990294084, 996614956, 1026515514, 1047579686) + W(5, -1085522812, -1090381288, 1048833585, -1125739905)
		 + W(6, 1005429062, 1031819293, -1090064383, 1048109660) + W(7, 1038017843, 1016883609, 1029812010, 1026577053)
		 + W(8, -1118087802, -1113190325, 1040657490, -1121801815)
		 + W(9, 1008887700, 1014785832, -1126747713, 1024173993) + W(10, 1020235411, 1027952623, 1021177962, 1011005202)
		 + W(11, 1025078601, -1127218683, 1041410670, -1132785763);
	sum2 =
		W(0, 1032555846, -1110721648, -1094136567, 1030929664) + W(1, -1146526593, 1018020888, 1019641904, -1116342888)
		+ W(2, -1089264280, -1112511004, 1032788860, -1125819008)
		+ W(3, 1015684488, -1102693078, -1097199465, 1046449598) + W(4, 1012812816, 1004426241, -1123545328, 1027573888)
		+ W(5, 1056898914, 1052843165, 1033507644, -1122415072) + W(6, -1118308408, 1043950970, 1037769558, 1024674316)
		+ W(7, -1106559340, 1028547840, -1117707424, 1021888896) + W(8, 1041236542, -1109778580, 1017687520, 996318210)
		+ W(9, -1137876352, 1007632640, 1026403708, -1123597216)
		+ W(10, 1028523456, -1149117889, -1152988290, 1023916088)
		+ W(11, 1046276806, -1105717038, -1122312832, -1132920416);
	WS(1034973624, 1056792353);
	sum1 = W(0, -1120658336, -1130821617, -1114903379, -1130597942)
		 + W(1, -1109039532, -1124529164, -1121055921, -1114464179)
		 + W(2, -1125024178, -1102939831, -1115164458, -1124681556)
		 + W(3, -1128295926, -1106629009, 1008426736, -1118485143)
		 + W(4, -1104109440, -1138254780, 1021962732, -1093463666)
		 + W(5, 1062068439, 1067744046, -1094141737, 993935312) + W(6, -1127490506, -1097245927, 1050479246, 1049107361)
		 + W(7, -1105858697, -1132704804, -1119904327, -1132912612)
		 + W(8, -1107542555, 1045213129, -1119937620, -1120970067)
		 + W(9, -1122942113, -1118132038, 1028006365, -1113875250)
		 + W(10, -1141854766, -1122550700, -1119710033, -1115274080)
		 + W(11, 1025872901, 1036565277, -1121170098, -1120520661);
	sum2 = W(0, 1020401308, -1120501349, 1037264768, -1090330474) + W(1, -1105802125, 1023925581, 1017661559, 996214904)
		 + W(2, -1116129767, -1084580575, 1032645479, -1119976615)
		 + W(3, -1129375401, -1140432422, 1035443152, -1097846115)
		 + W(4, -1102145888, 1025111856, -1130735541, 1024553914)
		 + W(5, 1051779064, 1064606263, 1038402436, -1136822486) + W(6, -1146688164, 1006774606, 1039827062, 1048687051)
		 + W(7, 1000828364, -1121332237, -1166762145, -1124013507)
		 + W(8, 1025600009, 1019182043, 1025151371, 1015612208)
		 + W(9, -1130185789, 1033491675, -1114545658, -1117487855)
		 + W(10, 1028059566, -1119338761, -1137125822, -1117903931)
		 + W(11, 1032817572, 1037037513, -1112238814, 999461036);
	WS(-1082445367, -1085006700);
	sum1 =
		W(0, -1131835086, 1041974800, -1081109875, 1054173212) + W(1, 1035072463, -1137431795, 1034878908, 1043293403)
		+ W(2, -1092276724, 1051286356, 1034209806, 1038048136) + W(3, -1106661648, 1042063924, -1086386347, 1055927462)
		+ W(4, -1114712644, -1110863483, 1037617118, 1045196135) + W(5, -1094524616, 1058619216, 1036390662, 1042877649)
		+ W(6, -1121819052, 1037212703, -1094507255, 1050138098)
		+ W(7, 1015171028, -1123146704, 1022066011, -1105403448)
		+ W(8, -1104988703, 1028915053, -1139447658, -1114994477)
		+ W(9, 1036207796, 1046411795, -1105674409, 1041419787) + W(10, 1026111277, 1040360493, 1033542412, -1100599618)
		+ W(11, -1096619449, -1130824962, 1045523870, -1121943708);
	sum2 = W(0, -1112963339, 1043137200, 1014823768, -1089890678)
		 + W(1, 1022229356, -1128614108, 1025676326, 1000796272) + W(2, 1031859059, -1102855534, 1031913791, 1018516204)
		 + W(3, -1117465202, 993751520, 1020211292, 1018575516)
		 + W(4, -1120060570, -1138611816, 1036266015, -1098528956)
		 + W(5, 1055374057, 1061198225, -1098119563, 1020738140) + W(6, -1124864900, 1032573075, 986723264, 1038055959)
		 + W(7, -1106568385, -1132953832, 1019242508, -1097473255)
		 + W(8, -1125510524, 1050136287, -1098582022, -1123833514)
		 + W(9, 1017632828, 1049454991, -1111044051, -1109681619)
		 + W(10, 1030233630, 1035860627, 1039721851, -1090503899)
		 + W(11, 1007293144, 1054985311, -1101215648, -1110059149);
	WS(-1089141943, 1068474134);
	sum1 =
		W(0, 1024130588, -1121972404, 1032495505, 1036801227) + W(1, -1117579092, -1114425265, -1101143803, 1041396360)
		+ W(2, 1045416789, -1094238571, 1039470024, 1024684838) + W(3, 1039148539, -1105946681, -1106461946, 1057861426)
		+ W(4, -1113046718, -1108918837, -1124204515, 1052602058)
		+ W(5, -1094942270, -1098420551, 1047303536, -1127532529)
		+ W(6, 1026773217, -1091638882, 1059099726, 1040764762) + W(7, -1094617668, 1027200645, 1018218693, 1032280890)
		+ W(8, -1106993164, 1033290001, 1040300696, -1103088708)
		+ W(9, -1104179471, 1041946144, 1045088278, -1105244536)
		+ W(10, -1110195745, 1043167338, -1123573325, -1138642417)
		+ W(11, 1009482242, 1037819035, -1108347351, -1116739793);
	sum2 = W(0, 1016644168, -1134771145, -1129326838, -1114142714)
		 + W(1, 1012771369, 1025799488, 998892514, -1114282184) + W(2, 1049635340, -1101404122, -1114952606, 1041138771)
		 + W(3, -1116049462, 1042383274, -1147070546, -1095734150)
		 + W(4, 1057697290, -1095991584, 1033248586, 1025008594)
		 + W(5, -1102476512, 1060588986, -1111850310, 1027653952)
		 + W(6, -1110140123, -1104878488, -1090718582, 1052949499)
		 + W(7, -1096580248, -1127102864, 1041609896, -1101611481)
		 + W(8, 1046973498, -1143476482, -1114336646, 1035005082)
		 + W(9, -1103095555, 1048842205, -1115539252, -1110997031)
		 + W(10, 1031782132, 992902692, 1030835892, -1122288558)
		 + W(11, 1028769716, 1022411808, -1118966953, -1120028296);
	WS(1055908206, 1023803300);
	sum1 =
		W(0, 1033033649, -1114766205, 1059767687, -1093070812) + W(1, -1106762950, -1139512861, -1128828388, 1011459483)
		+ W(2, 1054454099, -1094569204, 1029622486, 1016172182) + W(3, 1027156540, -1106069078, 1057986836, -1086765600)
		+ W(4, 991938588, 1027600816, 1024886583, -1116675477) + W(5, 1059734148, -1090099632, -1098865153, 1027525694)
		+ W(6, -1122498726, -1116893112, 1056528229, -1094363024)
		+ W(7, -1101593593, -1135964969, 1032744244, 1045609495)
		+ W(8, 1043829406, -1102732570, -1139103892, 1036132330)
		+ W(9, -1114524705, -1113403236, 1047712168, -1103438026)
		+ W(10, 1022039246, -1117700205, 1005980052, 1049123968)
		+ W(11, 1049516377, -1098493775, -1097177334, 1035501771);
	sum2 =
		W(0, 1025334517, 1052224655, -1085507535, -1083097675) + W(1, -1097828858, 1062578782, -1115143239, 1029199567)
		+ W(2, -1092254017, -1079915962, -1092877982, 1029921983)
		+ W(3, -1112308287, 1050599738, -1091835304, -1078367265)
		+ W(4, -1101001669, 1036651638, -1115511381, -1137182696)
		+ W(5, 1050309385, -1085955474, 1031547399, 1017725718) + W(6, 1042864237, -1101494467, 1052849573, 1077549274)
		+ W(7, 974314816, -1103762806, 1031444191, -1094150391) + W(8, 1058681981, 1068550083, -1100178328, -1106558945)
		+ W(9, 1040795754, -1116631442, -1093246396, 1054678659)
		+ W(10, 1046838481, 1039431488, -1111573417, -1092627938)
		+ W(11, 1066882777, 1059124396, -1088438520, -1098096651);
	WS(-1078207964, -1098790270);
	sum1 =
		W(0, -1117816013, 1017293260, 1049047675, -1100878354) + W(1, 1032784131, -1126192007, 1039615439, -1121106131)
		+ W(2, -1100078274, 1049964833, -1107321921, -1122801847)
		+ W(3, 1040159636, -1098516348, 1057717203, -1094050686) + W(4, 1040450075, 1034337038, 1032454162, -1100564368)
		+ W(5, 1041647209, -1119951725, -1099964381, 1014677674)
		+ W(6, 1029735698, -1142189601, -1090236946, 1052197359)
		+ W(7, -1116032848, 1028031798, 1026856980, -1115831559) + W(8, 1041839801, -1110599850, 1034137049, 1027844545)
		+ W(9, -1128361629, -1129405415, -1114821509, 1009705546)
		+ W(10, 1036993018, -1121696025, 1002339317, -1114960439)
		+ W(11, 1034781465, 1020602063, 993360895, -1130484229);
	sum2 =
		W(0, 1025029135, -1104367710, -1119205162, 1051361304) + W(1, -1097951274, 1037239658, -1115606678, -1132455965)
		+ W(2, 1051294613, -1090262380, 1046775583, 1027534783)
		+ W(3, -1098891737, 1054704406, -1118431701, -1094584814)
		+ W(4, -1111734067, -1137589907, -1111864983, 1035843132)
		+ W(5, 1040638061, 1042639742, -1115582191, -1161598998) + W(6, -1112278329, 1038310704, 1033551568, 1042180969)
		+ W(7, -1116801751, -1113612863, 1017169741, 1037432870)
		+ W(8, -1095570314, 1054301740, -1102111461, -1137659371)
		+ W(9, -1123958951, -1137648567, 1040693441, 1006683771)
		+ W(10, -1108749213, 1017443081, 1031819582, -1122384617)
		+ W(11, 1008777251, 1032304440, -1103720876, 1038413214);
	WS(1060561207, -1110135205);
	sum1 =
		W(0, -1114856118, 1049197464, -1091745710, 1057921518) + W(1, 1045672489, 1021270499, -1124131449, -1108658488)
		+ W(2, -1095755605, 1045522218, -1100746808, -1112929307)
		+ W(3, -1121034566, 1041962623, -1091090769, 1055093690)
		+ W(4, 1019645080, -1157317541, -1112340961, 1047635080)
		+ W(5, -1089785676, 1056738433, -1111234056, 1036938084)
		+ W(6, -1112123800, 1029521634, -1088312300, 1057086969)
		+ W(7, -1095870350, -1148757666, 1034679769, 1045001085) + W(8, -1105390912, 1048793054, 1047514180, 1026507103)
		+ W(9, -1115322038, 1019494819, -1095959893, 1049205462)
		+ W(10, -1099214252, 1019330670, -1107671902, 1038785126)
		+ W(11, -1089779917, 1057170552, 1022895484, 1029094240);
	sum2 =
		W(0, -1110883135, 1041894205, -1114700148, -1082032478) + W(1, 1046875162, 1064081845, -1122184691, -1115970606)
		+ W(2, -1118217955, -1081043792, 1049320576, 1059051295) + W(3, 1008834310, 982318965, -1097954058, -1085641610)
		+ W(4, 982336213, 1064706681, 1033395903, 1040255170) + W(5, -1109327580, -1095688614, -1107088758, 1066526360)
		+ W(6, -1110716892, -1134396672, -1107386491, -1084362127)
		+ W(7, 1032307660, 1060847547, 1024095030, 1031402202) + W(8, -1114148625, -1093205100, -1122373488, 1058657081)
		+ W(9, -1113505190, -1121857157, -1116084956, -1087863650)
		+ W(10, 1045820748, 1055302318, -1113542640, 1031923695)
		+ W(11, -1128842340, -1094939475, 1044473869, 1041403755);
	WS(-1088848183, -1091270356);
	sum1 = W(0, -1113444636, 1022583331, -1092936920, 1050793382)
		 + W(1, 1035173048, -1115063927, -1127291412, 1011517178)
		 + W(2, -1094397598, 1055228191, -1112816343, 1007040780)
		 + W(3, -1131637032, 1047190142, -1092945549, 1056457416)
		 + W(4, 1039723405, -1118782984, -1105736260, 1040877723)
		 + W(5, -1086200137, 1051083611, 1039289519, -1114815627)
		 + W(6, 1030983166, 1035565944, -1102025475, 1056969730) + W(7, 1015654008, 998545680, -1127378047, -1097520394)
		 + W(8, -1104020948, 1051399464, -1108815670, -1127143385)
		 + W(9, 1037357901, -1114602800, -1116833526, 1044492479)
		 + W(10, -1116817631, 1025703109, -1115666437, -1108205485)
		 + W(11, -1102830535, 1047811509, 1032741190, -1123886254);
	sum2 =
		W(0, 1023906737, 1067295699, -1081442287, -1097077469) + W(1, 1029195957, 1026431960, -1110646223, 1065087692)
		+ W(2, -1085042817, 1037915281, 1015927544, -1132623721)
		+ W(3, -1119411664, 1065459703, -1083251842, -1096872835)
		+ W(4, 1018101230, 1018762696, 1010017751, -1118952488) + W(5, 1050008558, -1110920551, 1042598936, -1124571002)
		+ W(6, -1108429461, -1081475488, 1064700095, 1006981249)
		+ W(7, -1103158035, 1020104602, 1029589423, -1083105366) + W(8, 1064469883, 1036080906, 1041992018, -1114107558)
		+ W(9, -1110439418, -1095503285, 1057972141, -1106015672)
		+ W(10, -1108943564, 1036691137, -1125097343, -1083389324)
		+ W(11, 1061045473, 1051761632, -1114827780, -1119006739);
	WS(1034259896, 1039623341);
	sum1 = W(0, 1016878676, -1137539339, 1055868742, -1088089066) + W(1, 1043298073, 984347141, 1028460795, -1104998988)
		 + W(2, 1047938201, -1091378989, 1036240559, -1121755284)
		 + W(3, 1034359235, -1129847248, 1058114664, -1090213650) + W(4, 1043122195, 932956556, 1011385345, 1015052988)
		 + W(5, 1043619008, -1114958501, -1119276751, 1018241806)
		 + W(6, 1015855070, 1032818160, -1096687428, 1054476715) + W(7, -1110579607, 1026808723, 1016831138, 1044006969)
		 + W(8, -1092418872, 1049053750, -1101201217, 1034235663)
		 + W(9, -1128588247, 1033445320, -1100196186, 1040121848)
		 + W(10, -1106781444, 1010316760, 1025908283, 1043524531)
		 + W(11, -1095896370, 1044746961, 1018213241, -1120101215);
	sum2 =
		W(0, 951810592, -1108037836, -1092018666, -1130209970) + W(1, 1022643242, 1009312276, 1033659165, -1102042508)
		+ W(2, -1107310314, -1115641842, -1110096702, 1032067593)
		+ W(3, 1002259560, -1103529440, -1101738099, 1041635941)
		+ W(4, 1034513697, -1114108683, 1037243759, -1102191435) + W(5, 1066447662, 1067062587, -1100161415, 1041326077)
		+ W(6, -1112310958, -1111056455, 1032823775, -1098661250)
		+ W(7, 1027860693, -1120382671, 1034753865, -1119026649)
		+ W(8, 1031795157, -1099014553, -1096684817, 1026651225) + W(9, 992340497, -1101647251, 1040899047, -1117726225)
		+ W(10, -1114962434, 1038338139, -1114454490, 1024637657)
		+ W(11, 1046257437, -1111013301, -1112982645, -1106704138);
	WS(-1096556910, 1067967914);
	sum1 = W(0, 1032707155, -1122886335, -1095119782, 1055235700)
		 + W(1, -1120012638, 1031514684, 1024354487, 1031668012)
		 + W(2, -1103532312, 1048353625, -1105977207, -1126996321)
		 + W(3, -1131915011, 1021347526, -1095435756, 1044387963)
		 + W(4, -1105830818, -1116416117, 1043480447, 1041914807)
		 + W(5, -1090836352, 1053060297, -1133082414, 1043128001)
		 + W(6, -1118942187, 1036630543, -1091218783, 1041581564)
		 + W(7, 1017318739, -1110350280, -1132633269, 1034774528)
		 + W(8, -1104917967, 1052242886, -1121967338, 1039162573)
		 + W(9, 1031302952, -1125222297, -1100801113, 1033613430)
		 + W(10, -1130484760, -1148985233, 1031513592, -1106257250)
		 + W(11, -1104067043, 1050269976, -1109204860, 1034839630);
	sum2 =
		W(0, -1125934657, 1041393774, -1097497496, 1047775001) + W(1, -1131783044, -1122059316, -1120747465, 1032139854)
		+ W(2, -1114660789, -1105604596, 1018330620, -1129241452)
		+ W(3, -1126946517, -1107151652, -1096477783, 1048515105)
		+ W(4, -1096755902, -1147658728, 1019390634, 1046075673) + W(5, 1057927405, 1059160295, 1041946221, 1011994599)
		+ W(6, -1140291646, -1090083756, -1110210473, 1043731078)
		+ W(7, -1091797353, 1032850220, 1045993569, 1024325836) + W(8, -1137735680, 1039621515, 1046026631, -1126091098)
		+ W(9, -1110717499, -1116058677, 1033250412, -1116506490)
		+ W(10, -1106745231, 1009337229, 1038335355, -1097350707)
		+ W(11, -1127153776, 987432265, -1124643180, -1124186068);
	WS(1061843767, -1077951557);
	sum1 =
		W(0, 1026388735, -1106366502, 1059311576, -1088217072) + W(1, 1041378862, -1102542817, -1120114128, -1131166601)
		+ W(2, 1043697070, -1105977039, -1130669927, 1039925540) + W(3, 1037862893, 1029755951, 1054385928, -1091419383)
		+ W(4, 1047467576, 989452730, 1029309653, -1091391038) + W(5, 1057568381, -1089136642, -1111164306, -1105668215)
		+ W(6, 1036389538, 1048316317, 1054220568, -1092475601)
		+ W(7, 1053509792, -1138232735, -1122000006, -1099454574)
		+ W(8, 1049723715, -1095416897, -1108260705, -1130981221)
		+ W(9, -1126306304, -1106178153, 1050234615, -1096877448)
		+ W(10, 1038585474, -1107228323, 1030215888, 1034019808)
		+ W(11, 1058416302, -1091809363, 1045917860, -1116719540);
	sum2 =
		W(0, 1061533858, 1041546460, -1081881922, -1104625991) + W(1, 1020257203, -1112819836, 1062451832, 1044663473)
		+ W(2, -1084977950, -1116240264, -1107478927, -1146254682)
		+ W(3, 1068272760, 1019905335, -1081565785, -1115490290) + W(4, 1038097782, 1018218872, 1070735043, -1103665132)
		+ W(5, -1079025547, -1094934042, -1129735749, -1108448519)
		+ W(6, 1070929067, 1027882908, -1082597652, 1002519540) + W(7, 1043320870, 1032555484, 1058522058, 1053579543)
		+ W(8, -1079765468, -1096683616, 997759194, -1111378699)
		+ W(9, 1059576348, 1030217484, -1088759123, -1103272320)
		+ W(10, -1110736144, 1018278443, 1052624489, 1042937819)
		+ W(11, -1090364693, 1039524167, 1041293151, -1120119454);
	WS(-1084224055, -1088316584);
	sum1 =
		W(0, -1113613001, -1107673717, 1006747746, 1039555654) + W(1, 1033838821, -1159624430, 1003388692, 1028109079)
		+ W(2, -1098426505, 1048291572, 1024741190, -1124153911)
		+ W(3, -1106869627, 1012698375, -1088923256, 1059475506) + W(4, -1120760050, 1033833840, 1016662735, 1027116933)
		+ W(5, -1097246285, 1054502102, 1019707757, 1010228666) + W(6, 1022316973, -1094644889, 1057877820, -1093203288)
		+ W(7, 1048977331, -1114819581, -1136760929, 1023495179)
		+ W(8, 1033746004, -1098003683, 1036081339, -1110624834)
		+ W(9, 1028746387, -1107590588, 1041863252, -1105649846) + W(10, 1041797102, -1119454813, 984919127, 1024116594)
		+ W(11, 1022736621, -1114921814, -1127589064, -1122201606);
	sum2 = W(0, 1015245257, -1113301472, -1126889814, -1122805777)
		 + W(1, 1024783162, -1125306444, -1113948506, -1150409563)
		 + W(2, 1027745966, -1121614859, 1024732276, -1120982285)
		 + W(3, -1130594159, -1113241340, 1053517180, 1035094088) + W(4, 1035927962, -1117285071, 1007533655, 988101766)
		 + W(5, -1115083078, -1117590123, 1033594898, -1115586407)
		 + W(6, -1122336092, -1114338752, -1120298083, 1041346715)
		 + W(7, -1136757529, -1179946326, -1131246557, 1042344950)
		 + W(8, 1009652067, 1010321235, -1112303516, -1122655190)
		 + W(9, -1121042747, 1024929700, 1023796132, 1022595647)
		 + W(10, -1107129305, 1031780006, -1112003767, 1034588627)
		 + W(11, 1015099871, 1021357977, -1116844702, -1109817399);
	WS(1056759150, 1060224665);
	sum1 = W(0, -1139374311, -1132085157, -1099925456, 1041263149)
		 + W(1, 1033127353, -1131329248, 995010733, 1023919167)
		 + W(2, -1105275165, -1143162806, 1020125661, -1128574472)
		 + W(3, -1111414410, 1047983919, -1089721802, 1045591848)
		 + W(4, 1047176279, -1124813330, -1108849608, 1035204919)
		 + W(5, 1047380996, 1054640011, -1109178223, -1115433611)
		 + W(6, 1028987391, 1044747100, -1111752399, -1086265361) + W(7, 1047077327, 1014274699, 1016981889, 1009635916)
		 + W(8, -1106656308, 1052567064, 1025513390, -1114033239)
		 + W(9, -1123115291, 1026679904, -1119632759, -1119813375)
		 + W(10, 1020940735, -1135589654, -1129401942, -1133052010)
		 + W(11, -1103728616, 1036660778, 1026259564, -1154487021);
	sum2 =
		W(0, 1023227060, -1114834111, -1123255684, -1111609489) + W(1, 1029177075, 1009084849, 1023565277, -1123243930)
		+ W(2, 1036838581, -1109001470, 1046335474, -1110362282)
		+ W(3, 1023373012, -1110717616, -1121973236, -1106028739)
		+ W(4, 1040383540, 1030364025, -1127246210, -1119831250)
		+ W(5, -1128787384, 1068968933, -1085459757, 1038001226) + W(6, 1035525242, 995075850, -1106791563, -1084327071)
		+ W(7, 1055427968, 1004844681, -1115895934, -1112704991)
		+ W(8, 1017209933, 1049794788, -1106438120, -1109625554)
		+ W(9, 1032252451, -1137853837, 1025363014, -1103092626)
		+ W(10, 1039281515, 1026824663, -1115664904, -1177558227)
		+ W(11, -1117762720, 1033559138, -1108939748, 1027051057);
	WS(1059198391, -1114206899);
	sum1 =
		W(0, -1123230572, 1047908609, -1086695351, -1111534963) + W(1, 1041894153, -1168813170, 1033309054, -1113872057)
		+ W(2, 1005036838, -1127426130, 1035651728, 1029018614)
		+ W(3, -1136657179, -1131612168, 1053830093, -1097279138)
		+ W(4, -1114797926, 1015674230, 1042361008, 1032838544) + W(5, 1063074340, 1032841926, 1042266564, -1115081892)
		+ W(6, -1127872354, 1018582917, 1022976638, -1102974814) + W(7, 1036160183, 1022213546, 1026831155, 1025662981)
		+ W(8, 1048968528, -1086802103, 1043048448, -1119589535)
		+ W(9, 1034821095, -1122684754, 1037218004, -1094977286) + W(10, 1028546130, 1023015663, 1027013917, 1042918755)
		+ W(11, 1045668084, -1080167184, 1051954532, -1121567905);
	sum2 = W(0, -1109294951, -1116747636, 1053044316, -1093594252)
		 + W(1, -1105874671, 1036768486, 1044771761, -1095594447)
		 + W(2, -1102224225, 1044254591, -1148207325, -1122217612)
		 + W(3, -1106240469, -1091993541, 1065361960, -1103264547)
		 + W(4, -1098859579, 1038496462, 1037653814, -1098134808)
		 + W(5, 1060397410, 1059446961, -1110887683, -1106764847)
		 + W(6, -1132138943, 1045429231, -1095097189, 1053539276)
		 + W(7, -1103270924, 1035231626, -1129034439, -1112675284)
		 + W(8, -1139768526, -1147713757, 1018090127, -1112984312)
		 + W(9, 1027920896, 1030264036, -1100471477, -1115698004)
		 + W(10, -1105560593, 1037287074, -1126749735, 1027709116)
		 + W(11, -1095674438, -1131922215, 1044415945, -1106415399);
	WS(-1081905372, 1072993545);
	sum1 = W(0, 1004609681, -1111485397, -1100618406, 1052555682)
		 + W(1, -1113666277, -1113131956, -1113931058, 1044870886)
		 + W(2, -1103601459, 1050421002, -1125853837, -1119475260)
		 + W(3, 1017897178, -1101161424, -1117978262, 1053397115)
		 + W(4, -1109207833, -1119057377, -1110350900, 1042868018)
		 + W(5, -1088871615, 1057434595, -1108715676, -1116054255)
		 + W(6, -1119842647, 1016958866, -1096217303, 1037835279) + W(7, 1041223333, 1033629886, 1029593625, 1036666966)
		 + W(8, -1090419947, 1054502387, -1131918060, 1019600139)
		 + W(9, -1114320538, 1034341084, -1105396084, 1036260396)
		 + W(10, 1046093262, 1034832815, 1026419555, -1123516147)
		 + W(11, -1100180286, 1041011339, -1108472674, 1025124935);
	sum2 =
		W(0, 1027207918, -1134820995, -1123507780, 1022927690) + W(1, -1148644129, -1124904791, -1131003531, 1019005665)
		+ W(2, 992028222, 1039006609, -1114458430, 1019252639) + W(3, -1155176792, 1018656479, 1020777698, -1108026125)
		+ W(4, 985006155, 1019665619, -1144704129, 1016837667)
		+ W(5, -1093100477, -1075529389, -1165905039, -1148497627)
		+ W(6, -1120277627, -1133755465, -1106617270, -1071234400)
		+ W(7, 1009164120, -1154476856, 1018692534, 1007330736) + W(8, 1026210395, -1098388857, 1080134310, 1041946375)
		+ W(9, -1122116985, 1008190855, 1015481059, 1043410538) + W(10, 1068769301, -1120913968, 1016313728, 1024160458)
		+ W(11, 1009441727, -1127804151, 1038162442, -1102924087);
	WS(1052536174, -1151096569);
	sum1 = W(0, 991116371, -1128173243, -1103836723, 1032573088) + W(1, 999976938, 1037991630, 1033302347, -1146822742)
		 + W(2, 1034951935, -1120898050, -1138114279, 1035558856)
		 + W(3, -1116642336, 1036050892, -1087917523, 1057405287)
		 + W(4, -1098834165, 1042054293, -1115536654, 1034768509)
		 + W(5, -1106200391, -1120590821, -1118223722, 986260550)
		 + W(6, 1020657940, -1102372039, 1061554222, -1082912644)
		 + W(7, 1047922098, -1130396508, -1114833734, 1030675614)
		 + W(8, 1041046871, 1002819162, -1107937520, 1023135729)
		 + W(9, 1031490598, -1114628406, 1046795201, -1124848916)
		 + W(10, 1038688870, -1142052488, -1158391502, 1032401267)
		 + W(11, 1027714602, -1124036191, -1118805976, -1177279769);
	sum2 = W(0, 1035223119, 1038869307, -1108836158, -1105867416)
		 + W(1, -1106282608, 1028503999, -1127800761, 1034423710)
		 + W(2, -1116666352, -1109342419, 1047028407, -1119414296)
		 + W(3, 1038890181, -1109261585, -1087753137, 1027333841)
		 + W(4, -1148256348, -1113209005, 1028905699, -1095895125)
		 + W(5, 1061176216, 1057224086, -1148022324, 1010099974) + W(6, 994981383, -1098712671, -1099737664, 1049674522)
		 + W(7, -1103462952, 1020393479, -1127955051, 1032845262)
		 + W(8, -1208820627, 1011854042, 1043242553, -1115953239) + W(9, 998786660, 1030375171, -1126035264, 1017325847)
		 + W(10, -1121350765, 1024565993, -1121293280, -1114148994)
		 + W(11, 1042226462, -1120003540, -1117125009, 1001260628);
	WS(1058902967, -1081860445);
	sum1 = W(0, -1121371387, -1116017491, -1114517185, -1144385454)
		 + W(1, 1031405875, -1133995267, 1029881036, -1110722656)
		 + W(2, -1096281750, 1046612526, 1032371736, -1118231237)
		 + W(3, 992316765, -1103068528, -1110556335, 1050079932)
		 + W(4, -1114542190, 1037331941, -1117974353, -1120254383)
		 + W(5, -1087192661, 1061346066, -1113719056, -1117606232)
		 + W(6, 1019164800, -1111729689, -1138608617, 1054224317)
		 + W(7, -1147587566, 1027634660, -1115308289, -1123116948)
		 + W(8, -1119671953, 1023689473, -1121094047, -1114416951)
		 + W(9, 1031905998, -1110978129, 1026716344, 1034730016)
		 + W(10, 1032702160, -1150819433, -1118946572, 1027465948)
		 + W(11, 1026550240, 990814541, 1025765741, 1002408318);
	sum2 =
		W(0, -1127268449, 1017520494, 1046612660, -1104246964) + W(1, -1098833757, 1019779427, 1008157504, -1110533731)
		+ W(2, 1053115740, -1126879265, -1103206877, -1135658469)
		+ W(3, 1022079949, -1110799425, 1042237616, 1071620340) + W(4, 1047260740, -1112586418, -1129508015, 1038116680)
		+ W(5, -1081939523, -1082767624, 1046386206, 1021781126)
		+ W(6, 1023435994, -1149062134, 1046590815, -1091995420) + W(7, 1034566387, 1021597755, 987488696, -1109564641)
		+ W(8, 1019421448, -1133233221, -1113663072, 1025921212)
		+ W(9, -1149203238, 1031926637, 1025089506, -1113723868)
		+ W(10, -1131415815, 1022181144, 1025441916, -1140288129)
		+ W(11, 1002014090, 1008464055, -1120607589, -1133866981);
	WS(-1118927728, -1114990634);
	sum1 =
		W(0, -1123938375, 1033195056, 1057535917, -1087859524) + W(1, -1107191040, 1047574307, 1040612950, -1114716774)
		+ W(2, 1047260544, -1132924433, 1007112943, -1106834116) + W(3, 1024746402, 1048819881, 1042772673, -1087499341)
		+ W(4, 1043648426, 1044210486, 1022214714, -1104426015) + W(5, 1057677234, -1097320317, -1093740782, 1028537764)
		+ W(6, 1038811590, -1105195831, 1045869257, -1091890215)
		+ W(7, 1042013107, -1106862316, -1112630087, 1042575344) + W(8, 1057533694, -1089715893, 1020754614, 1047539199)
		+ W(9, -1118622728, -1098438774, 1042859777, 1029276300)
		+ W(10, -1107815558, -1107232885, 1031232344, 1038434900)
		+ W(11, 1055588422, -1091230428, -1113991309, 1041569343);
	sum2 =
		W(0, -1117938617, -1098776947, 1052841626, -1111689798) + W(1, -1101990052, 1034353164, 1034943831, -1074997876)
		+ W(2, 1071950042, 1008522816, 1023979086, 1019125592) + W(3, 1047294563, -1067348911, 1078478928, 1042633900)
		+ W(4, -1106116215, 1021696573, -1112881764, -1073328658)
		+ W(5, 1075942353, -1105497105, 1040726051, 1032192788)
		+ W(6, -1113196518, -1106856879, 1048374094, -1100859969)
		+ W(7, -1128120408, -1129459590, 1017166837, 1007574096)
		+ W(8, -1110198115, 1027760421, 1041816709, -1114781060)
		+ W(9, -1119652380, 1040326435, 1016518417, -1106280857) + W(10, 1015116440, 983174391, -1122537978, 1003760381)
		+ W(11, -1132261857, -1146348222, 1015700123, 1019612376);
	WS(1034111416, -1106797037);
	sum1 =
		W(0, -1127934684, -1113852291, -1096035023, 1052464285) + W(1, 1032415443, -1113420426, -1146675705, 1035613338)
		+ W(2, -1102929642, 1042719307, -1114220817, 1025128440) + W(3, 1006977829, 1034804131, -1090308252, 1054858571)
		+ W(4, 1032020487, -1114922591, -1113401378, 1037672145)
		+ W(5, -1089088820, 1057164897, -1123663635, -1136503085)
		+ W(6, 1019549798, 1044038057, -1096624416, 1050796251) + W(7, 1035431737, 1026704599, 1016064490, -1106829090)
		+ W(8, -1097224209, 1048920159, -1131720964, -1109868785)
		+ W(9, -1139061950, 1033066250, -1104516203, 1042039981) + W(10, -1114943722, 1024811962, 998716411, 995721454)
		+ W(11, -1095532026, 1049209393, 1041424208, -1138798477);
	sum2 =
		W(0, 1018373307, 1030944977, -1120549779, -1139755202) + W(1, -1101691927, 1049483493, -1117669473, 1035483586)
		+ W(2, -1113169149, -1114451942, -1102665013, 1049560407)
		+ W(3, 1036793172, -1120221588, 1031305133, 1047991436)
		+ W(4, -1083948126, 1057078402, -1107254646, -1138388666)
		+ W(5, -1118729068, 1050438576, -1083351573, 1060878230)
		+ W(6, 1027210469, -1119036598, -1123944089, 1058194810) + W(7, -1081291530, 1058504911, 983011887, 1026801669)
		+ W(8, -1136088418, -1103576008, -1106933299, 1044728114)
		+ W(9, -1124389554, -1120993070, 1045466087, 1037255439) + W(10, -1095248620, 1047223280, 999841656, 1036234905)
		+ W(11, -1110162376, -1114267729, -1124771645, 1036725012);
	WS(1038841272, 1052605132);
	sum1 =
		W(0, 1031922765, -1100459309, 1037270288, 1026910357) + W(1, 1023447506, -1104596348, -1104568331, 1046914264)
		+ W(2, 1041702805, -1101939446, -1114279623, 1044685961)
		+ W(3, 1037544250, -1120141702, -1098675705, 1040827436)
		+ W(4, 1048352911, -1104877098, -1109808312, -1117060814)
		+ W(5, 1045728636, 1037079325, -1115507167, -1117405559)
		+ W(6, -1115625903, 1046551204, 1017164043, -1095425143) + W(7, 1040518727, 1032200833, 1042593752, -1097718198)
		+ W(8, 999474559, 1046662664, 1038294495, -1104511859) + W(9, -1105481799, 1032086688, 1031450455, -1103113592)
		+ W(10, -1106032688, 1039045107, 1033924054, -1112841053)
		+ W(11, 1034794943, 1015870568, 1041969331, -1111795079);
	sum2 = W(0, -1119788132, 992683382, 1018867293, 1022669528) + W(1, 1044098145, -1102594356, 1033659476, -1104347191)
		 + W(2, 1020892153, 1043646320, 1022003003, -1105788334)
		 + W(3, -1112158198, 1044081475, -1090780387, 1053457206)
		 + W(4, 1053806225, -1097169858, 1008462738, 1034564598)
		 + W(5, -1098943438, -1103925357, 1061138285, -1089462725)
		 + W(6, -1128623485, 1037093866, 1024702018, -1094689316)
		 + W(7, 1061570617, -1090351234, -1135723434, -1118342628)
		 + W(8, 1037085984, -1130567667, 1042502677, -1124000960)
		 + W(9, 1030330775, 1008221186, -1108937272, -1111881166)
		 + W(10, 1045330453, -1102638867, -1125624097, -1116661382)
		 + W(11, 1041747819, 1006874186, 1015917808, -1119261652);
	WS(1059476151, -1123203418);
	sum1 = W(0, -1111725774, 1035594491, -1091810916, 1057461865)
		 + W(1, 1016189354, -1123857235, 1032359159, 1034919857) + W(2, -1140486487, 1048140086, 1034245225, 1028750247)
		 + W(3, -1110577724, -1111760306, -1084838663, 1060577506)
		 + W(4, -1104347695, -1113205590, -1105544893, 1046155316)
		 + W(5, -1086139015, 1052038472, 1027870402, -1121460986)
		 + W(6, -1121304930, 1044165509, -1095808892, 1057513991)
		 + W(7, -1103056264, -1148349487, -1115245634, 1020829292)
		 + W(8, -1096673622, 1053266340, -1108853472, -1113141864)
		 + W(9, 1036887935, 1039852002, -1127813812, 1045123672)
		 + W(10, 1031021091, 1036934292, -1110517831, -1120384574)
		 + W(11, -1090491960, 1055106407, -1133152957, 1011178567);
	sum2 =
		W(0, -1114868977, 1026556603, 1004734644, 1034344926) + W(1, 1040708934, -1131620842, -1107973502, -1115461868)
		+ W(2, -1092079110, 1042028492, -1103991549, -1105590488)
		+ W(3, 1044770988, -1104823400, 1059587552, 1024895663) + W(4, 1051421807, 1029419915, -1101288212, -1105554340)
		+ W(5, 1045430990, 1050688149, -1095880897, -1114582112) + W(6, 1025917421, 1036199790, 1037874646, 1047334362)
		+ W(7, -1118101029, 1015496806, 1028043472, -1116199065)
		+ W(8, -1137785064, -1116948841, -1122024357, -1121536685)
		+ W(9, -1111158861, 1020651575, -1093651456, 1044938016)
		+ W(10, -1099771430, -1121478353, -1123193100, -1128075734)
		+ W(11, -1127404110, 1042458099, 1007412048, -1127827256);
	WS(-1096078190, -1082738059);
	sum1 = W(0, 1007239809, -1108860284, -1100207850, 1053165251)
		 + W(1, -1112013420, -1115685558, -1114850361, 1046670329)
		 + W(2, -1101169270, 1050939564, -1126100266, -1124400725)
		 + W(3, -1130257143, -1103368477, -1116530972, 1051252601)
		 + W(4, -1112810720, -1112871192, -1112210107, 1045976117)
		 + W(5, -1088435015, 1056131912, -1124484747, -1117830909)
		 + W(6, -1118665957, 1029494103, -1092482434, 1045571555) + W(7, 1041969097, 1031308937, 1028242343, 1036298605)
		 + W(8, -1090334611, 1053021861, 1032260218, -1143992478)
		 + W(9, -1116764258, 1029804679, -1105280439, 1035862579)
		 + W(10, 1044490698, 1037078646, 1022403683, -1128309634)
		 + W(11, -1099682433, 1038809821, -1114977769, 1016808747);
	sum2 =
		W(0, -1133820219, 1027229337, -1115513384, 1007940354) + W(1, -1156542700, 1020775992, -1147891684, 1032424255)
		+ W(2, -1107406978, -1125237780, 1031863482, 994071912) + W(3, -1127336652, -1137665638, 1037916056, 1044701152)
		+ W(4, -1113898133, -1127018949, -1127200453, 1045946307)
		+ W(5, -1096925824, 1067148595, 1048747828, -1115116116) + W(6, 1020736496, -1116510358, 1031285965, 1076670751)
		+ W(7, -1101339101, -1122694416, 1001166860, -1145031593)
		+ W(8, -1138759126, 1039470145, -1070343554, -1106720041)
		+ W(9, 1022486646, -1116471963, 1020254812, -1109537872)
		+ W(10, -1082365934, 1034791139, -1135690985, -1126621635)
		+ W(11, -1122394148, 1025436583, -1107321525, 1039293842);
	WS(1056919406, -1123699093);
	sum1 = W(0, -1153021483, 985933670, -1089586019, 1058308826)
		 + W(1, -1122912091, -1130942473, 1016658279, -1142160193)
		 + W(2, -1106728023, 1043832952, -1111941676, -1162334614)
		 + W(3, -1169964908, 1032391598, -1095447822, 1054485203)
		 + W(4, -1114359010, -1115887538, -1131540465, -1109380555)
		 + W(5, -1095937215, 1051425640, 1038539876, 1035573952)
		 + W(6, -1116724456, -1112807501, -1092279079, 1057168451)
		 + W(7, -1129000267, -1120065804, 1018808083, -1115139838)
		 + W(8, -1105250414, 1053123845, -1105627696, 1037216107) + W(9, 986184318, 1023499017, -1104943256, 1034402292)
		 + W(10, 1011544866, -1114397383, 1026972628, -1119658051)
		 + W(11, -1093497009, 1056025192, -1129701482, 1031803900);
	sum2 =
		W(0, 1034281368, -1104410341, 1018060402, -1138447737) + W(1, 994323516, -1140256393, -1126716121, 1032410612)
		+ W(2, 1017706532, -1115589617, 1029627322, -1133676977)
		+ W(3, -1121241308, -1087414339, 1061712823, 1021983592)
		+ W(4, -1133709215, 1012505315, 1045372780, -1068615761)
		+ W(5, 1078313037, -1100339818, 1015111478, -1130902073)
		+ W(6, 1035929285, -1067644471, 1079888634, -1123293195) + W(7, 1023885100, 1028720332, 1047600787, -1091405946)
		+ W(8, 1048822788, 1030149270, -1124744731, -1123320040)
		+ W(9, 1004087438, -1118166494, 1023636550, -1120625820)
		+ W(10, 1010097407, 1022959192, 1041718259, -1097556864)
		+ W(11, 1035128990, 1021734756, 1009567515, -1136405679);
	WS(1057577783, -1116545908);
	sum1 =
		W(0, -1140559047, 1023488522, 1031631673, -1127758170) + W(1, 1037581685, -1129099776, -1119858755, 1007841757)
		+ W(2, 1034355893, -1102068668, 1038802963, 1023940956) + W(3, 1001413734, -1099448121, 1034820815, -1139646818)
		+ W(4, 1020321573, 1023108226, 1019558160, -1135636631)
		+ W(5, -1095265297, 1043309332, -1118918103, -1133216315)
		+ W(6, 1027838711, -1106014610, -1133110549, 1058446926)
		+ W(7, -1104027725, 1027058075, -1123065945, -1112832085)
		+ W(8, 976310772, 1018622064, -1110623851, -1123708581) + W(9, -1133184076, -1132115376, 1031909175, 1033516923)
		+ W(10, -1124259695, 1025545342, -1116764451, 1007686986)
		+ W(11, 1033492939, 1033353766, -1114622946, -1118432359);
	sum2 =
		W(0, -1139693312, -1124752720, -1098950560, 999696497) + W(1, -1111434581, 1026280044, 1036960926, -1121090060)
		+ W(2, -1103693150, 1034222778, -1119707404, 1014405392)
		+ W(3, -1143311649, -1099787410, 1033289622, -1104157082)
		+ W(4, 1018041096, -1121205834, 990661185, -1112556974) + W(5, 1052753541, 1058657457, -1108624084, 1023217352)
		+ W(6, 1015972640, -1123282486, -1106573325, 1042484509)
		+ W(7, -1111132399, 1005957425, 1000525745, -1104610584) + W(8, 1031872996, 1044261031, -1121815492, 1017712752)
		+ W(9, -1129692664, 1028371280, -1115662969, 1026599244)
		+ W(10, 1018446608, -1139874592, 1028832752, -1104217347)
		+ W(11, -1115847157, 1041506121, -1129135268, 1010211304);
	WS(1063874743, -1123600943);
	sum1 =
		W(0, 1026726381, -1110972995, -1088392527, 1060534134) + W(1, -1131352649, 1017113381, 1005084141, 1029034162)
		+ W(2, -1096434085, 1052968261, -1125442370, 1023149165)
		+ W(3, -1121313992, 1029564141, -1088422197, 1061531727)
		+ W(4, -1111100967, -1121647548, 1022502021, 1019350337) + W(5, -1089197156, 1048937234, 1007055431, 1028622922)
		+ W(6, 1010678471, 1021423943, -1089730182, 1053585019)
		+ W(7, -1124123103, -1132301739, 1012880846, -1112342611)
		+ W(8, -1099324833, 1049533342, 1037169096, -1122598880) + W(9, 1016038684, 1036724585, -1105649226, 1044791660)
		+ W(10, -1119334386, 1017220849, 1031948511, -1096649610)
		+ W(11, -1102131796, 1047748258, 1048887628, -1134858375);
	sum2 =
		W(0, 1041516351, -1098661524, 1065773241, 1067471192) + W(1, -1095722385, 1025030832, -1114001722, -1113317539)
		+ W(2, 1066164852, 1062194047, 1029392016, 1015621429) + W(3, 1031962338, 1041960143, -1094243603, -1131590099)
		+ W(4, 1045112423, 1033273068, -1127882717, -1113172562)
		+ W(5, -1071023147, -1071391818, 1027735196, -1106774969)
		+ W(6, 1024371132, 1057245216, -1087722937, -1082288010)
		+ W(7, 1047570295, 1021784721, -1116893380, -1108932190)
		+ W(8, 1043021464, 1036914992, -1110460182, -1147670187) + W(9, -1137233618, 1040530840, 1059923771, 1056604249)
		+ W(10, 1008215114, -1157997580, 1035584360, -1090505328)
		+ W(11, 1062948018, 1065534266, -1096088381, 1025226110);
	WS(-1081605212, 1037230241);
	sum1 = W(0, -1129286954, -1115600951, -1139829872, 1042245092)
		 + W(1, -1130516890, -1191245347, -1127382348, -1127078325)
		 + W(2, 1037397159, -1101819637, 1025459530, -1140137724)
		 + W(3, -1114123448, 1045220821, -1103957592, 1057239854)
		 + W(4, -1098019463, -1135821456, -1119205995, 1032978341)
		 + W(5, 1057561887, -1089716883, 1040837167, -1153142562)
		 + W(6, -1116053850, 1031622828, 1057799156, -1088291628)
		 + W(7, 1039979404, -1123070334, -1114061454, 1039357911)
		 + W(8, -1103125195, -1162281827, -1123433113, -1115244132)
		 + W(9, 1024011222, 1020277751, 1035843369, -1111135597) + W(10, 1008116332, 975751222, -1165173963, 1026874614)
		 + W(11, -1159950147, -1144308089, -1115664788, -1121723210);
	sum2 = W(0, -1129847377, 1027890930, 1045384717, -1131041629)
		 + W(1, -1118537275, -1129495121, -1132201467, -1115667911)
		 + W(2, -1139027758, -1086235324, 1015945835, 1022067627)
		 + W(3, -1111059277, -1109124506, 1062718876, 1071241567)
		 + W(4, -1090110249, -1139816838, 1032250249, -1115518668)
		 + W(5, -1088514518, -1104078593, 1050303031, -1109320206)
		 + W(6, 1003251981, -1131706033, 1043614591, -1091065468)
		 + W(7, -1130925231, 1035917053, -1175110606, 1033851379)
		 + W(8, -1096199608, 1021865867, 1030828678, -1140186118)
		 + W(9, -1119100754, 1008685286, 1038009999, -1113376611)
		 + W(10, -1128909271, 1027374356, 1007928974, -1130851063)
		 + W(11, -1126833063, -1120766781, -1121346672, -1130315761);
	WS(1048635758, -1111558989);
	sum1 = W(0, -1116715915, -1114167026, 1019884197, 1046236914)
		 + W(1, 1023679491, -1123924777, 1007517554, -1144951432)
		 + W(2, -1100411873, 1042364482, 1030303424, -1115625243)
		 + W(3, -1125319757, 1032434734, -1082609609, 1057088310)
		 + W(4, 1025882348, 1018952757, -1130676803, -1116349759)
		 + W(5, -1099356457, 1060062511, 1027068912, -1117219752)
		 + W(6, 1032051720, 1007313161, -1114189151, -1105629450)
		 + W(7, 1046455412, -1128015465, -1122176818, 1037795522)
		 + W(8, -1098216348, 1032549225, 1037080648, -1117338239)
		 + W(9, 1019813529, 1011561671, -1118483848, -1156935944)
		 + W(10, 1024380849, 1001454266, -1125995833, 1022555096)
		 + W(11, -1115419480, 1017135051, 1020138940, 1015509889);
	sum2 =
		W(0, 1017200252, 1032764106, -1100965710, -1120952053) + W(1, 1023440400, 1026555164, -1128076598, 1032749056)
		+ W(2, 1036328960, -1105592489, 1037836738, -1121478225)
		+ W(3, 1020177744, 1042154489, -1079875623, -1093732085)
		+ W(4, -1110726007, 1032334674, 1027061114, -1091917968) + W(5, 1069362278, 1053281179, -1110949820, 1004458190)
		+ W(6, -1120062015, -1115647155, 1041923814, 1053015354)
		+ W(7, -1097734576, 1030547292, 1007295183, -1109350747)
		+ W(8, -1121245377, 1023497366, 1029656316, -1115087241) + W(9, 1005463470, -1136438311, 1023734232, 1044015507)
		+ W(10, -1107014120, 1024950244, -1120999608, -1152745757)
		+ W(11, -1115720719, 1040619345, 1039138178, -1107079388);
	WS(1057226679, -1099093504);
	sum1 = W(0, -1117743115, -1106860569, 1059123761, -1116606854)
		 + W(1, -1117312579, -1126837697, -1111361838, -1097721634)
		 + W(2, 1043835217, -1113320356, 1021938430, -1108681130)
		 + W(3, -1142218540, 1017711998, 1054886149, -1098795498)
		 + W(4, 1024346219, -1128001843, -1115584496, -1098477656)
		 + W(5, 1036645937, 1036044245, -1113074392, -1126342351)
		 + W(6, -1144474236, 1017808579, -1096319852, 1058878095)
		 + W(7, -1113306631, -1145404316, -1112915081, -1127808199)
		 + W(8, -1102898152, 1054951826, -1104150268, 1022603516)
		 + W(9, -1118048876, -1110778360, -1108186916, 1042821748)
		 + W(10, -1109837016, -1113519979, -1124754680, 988685674)
		 + W(11, -1103594844, 1057715322, -1104945799, -1166667748);
	sum2 =
		W(0, 1017552406, -1115134458, -1123239700, 1040415751) + W(1, 1024802817, -1116030864, -1121365003, -1113297695)
		+ W(2, 1033578978, -1119377084, -1140510683, -1154029132)
		+ W(3, 1024315197, -1121331284, 1032104202, 1033268884) + W(4, 1031096569, -1127078294, -1126393870, 1034056828)
		+ W(5, -1122610502, 1042552247, 1027588477, -1123710517) + W(6, 1006096662, -1116036592, 1042239151, 1014688747)
		+ W(7, -1116363642, -1142638070, 1026122801, -1122098200)
		+ W(8, -1128246386, 1038912262, -1106292650, 1002524342)
		+ W(9, -1115019758, -1138309587, -1130645774, 1011328923)
		+ W(10, -1119712705, -1123496021, 1010820131, -1114451237)
		+ W(11, 1021632898, 1013103251, -1106135611, 1026182445);
	WS(-1108758968, -1120615143);
	sum1 =
		W(0, 1007512449, 1043847294, 1041722714, -1089504654) + W(1, 1035899020, 1021562716, -1118729201, -1115009907)
		+ W(2, 1047642150, -1097300100, 1024857813, -1157490338) + W(3, 1033236958, 1038269372, 1052029054, -1092318719)
		+ W(4, 1041772976, 1033997944, -1188181540, -1103491829)
		+ W(5, 1056274631, -1092329088, -1115586563, -1127937658)
		+ W(6, 1032455763, 1026842103, 1057598894, -1088834696) + W(7, 1037648114, 1034853541, -1139132956, 1028990457)
		+ W(8, 1044856958, -1094694701, 1028932916, -1139535439)
		+ W(9, -1126666947, -1112992067, 1049081300, -1102944265) + W(10, 1031373190, 999073631, 1028445809, 1045480960)
		+ W(11, 1008203541, -1095636207, 987483733, 1033314299);
	sum2 = W(0, 1022601823, -1119857460, -1099325942, -1068582801)
		 + W(1, 1035739756, 1015907333, 1027503424, 1016942723)
		 + W(2, -1112391205, -1076271776, -1104095012, 1016973548)
		 + W(3, -1114440342, -1113768249, 1050839307, 1067690352)
		 + W(4, 1026494027, -1122697579, 1031020236, 1049278985) + W(5, -1097330938, 1077639092, 1047876791, 1015148595)
		 + W(6, -1115479573, 1023747258, 1019565806, 1061065209) + W(7, 1016405011, -1106941761, 1028798660, 1008539869)
		 + W(8, -1108724816, -1120523343, -1115660355, 1032414836)
		 + W(9, -1137878778, 1030670036, -1143955309, 1002861982)
		 + W(10, 1022661839, -1126087053, 973255146, -1124354630)
		 + W(11, -1115374863, 1029925423, 1033007729, -1124658022);
	WS(-1125070560, -1096513533);
	sum1 =
		W(0, -1112401838, 1032850683, -1111199410, 1046757622) + W(1, 1033951818, -1110786345, -1141896047, 1035442769)
		+ W(2, -1105684773, 1047296038, 1013771590, -1113414691)
		+ W(3, -1114813980, 1027743049, -1093508577, 1061969278)
		+ W(4, -1100008383, -1131095256, -1125005414, 1036941992)
		+ W(5, -1099350541, -1107426238, 1023589122, -1114443933)
		+ W(6, 1026386210, -1104378805, 1060063436, -1092774776) + W(7, -1122038496, 996299870, -1115056418, 1037833707)
		+ W(8, -1112618105, 1028130403, -1110298148, -1117830096)
		+ W(9, 1012901881, 1022681350, 1035294797, -1127381572)
		+ W(10, 1030080099, -1140100259, -1125623196, 1033887999)
		+ W(11, 988362813, 1016528878, -1106008748, 1014753608);
	sum2 =
		W(0, -1128089453, 1024340419, -1102023306, -1103821003) + W(1, 1043342989, -1119644228, -1110645236, 1043920397)
		+ W(2, -1114712453, -1097377481, -1109265540, 1026656603)
		+ W(3, -1130916401, -1129344777, 1028225499, 972074333) + W(4, -1100613575, 1034952995, 1026446699, 1009781987)
		+ W(5, 1057874897, 1059140954, -1103696793, 1032660433) + W(6, -1115610756, -1102796808, 1052660862, 1038144249)
		+ W(7, -1116201867, -1130501689, 1032679495, 1037523581)
		+ W(8, -1102216434, -1107293486, -1131885037, 1029362471)
		+ W(9, -1114433002, 1023912055, -1127455825, 1006589878)
		+ W(10, -1105206442, 1013212643, -1123355757, 1026431795)
		+ W(11, -1128264837, -1102041035, -1127587329, 1005668278);
	WS(1049867118, 1034735186);
	sum1 =
		W(0, -1127774262, 1029333619, 1019113028, 1024964758) + W(1, 1007980364, -1121402761, -1117373036, -1123455456)
		+ W(2, 1040322517, 1032014380, 1019723167, -1118901061) + W(3, 1031064438, -1105261096, 1040279186, 1048588372)
		+ W(4, -1114399774, -1126411220, -1112922680, -1096141178)
		+ W(5, -1101685436, 1050135703, -1100797936, -1110911420)
		+ W(6, 1012648832, -1120189874, 1044944438, 1034886579) + W(7, -1113398479, 1019321608, -1132535687, 1024540628)
		+ W(8, -1121818673, 1040490120, -1150021355, -1114680743)
		+ W(9, -1120670652, -1138107141, 1035373868, 1016312768)
		+ W(10, -1128775361, -1121234663, -1140537009, 1000234461)
		+ W(11, 1032620736, 1034120602, 1008873398, -1121766352);
	sum2 =
		W(0, -1161289046, -1111556088, 1038429491, 1024158411) + W(1, -1123794133, 1016121349, 1020587590, -1127668568)
		+ W(2, -1130067243, 1018324827, 1035096674, -1127328688)
		+ W(3, 1029682388, -1095922552, 1050898724, -1123472030)
		+ W(4, -1142905112, -1126947701, 1031608572, -1092239431)
		+ W(5, 1058359401, -1093717514, 1042534485, -1126252937)
		+ W(6, -1117304231, -1165373610, 1040200303, -1118204561)
		+ W(7, -1137719883, -1122434117, -1129471662, -1120133906)
		+ W(8, 1044552317, -1112781150, -1136196985, -1137031592) + W(9, 965398246, 1007233453, -1132308256, 1017795291)
		+ W(10, 1027736448, -1121369248, -1134569151, 1019046119)
		+ W(11, 1031851372, -1120826542, -1128305748, -1162116006);
	WS(1063598519, 1040709546);
	sum1 =
		W(0, 989424433, -1129964132, -1092181324, 1056340507) + W(1, -1140166214, 1007420926, 1025004011, 1018517694)
		+ W(2, -1096845618, 1052096915, -1124688156, 1025298052)
		+ W(3, -1117397173, 1036280904, -1092686069, 1055848084) + W(4, 1027380346, -1114706068, 1010227902, 1042042835)
		+ W(5, -1082263275, -1117189370, 1041673920, 1030527159)
		+ W(6, -1116859551, 1025484624, -1087946945, 1053023013) + W(7, 1025279965, 1004378644, 1035862832, -1108371497)
		+ W(8, -1124000752, 1053676604, 1021321051, -1130325786) + W(9, 1012428267, 1028794752, 977020321, 1044581128)
		+ W(10, -1125256895, 1025029349, 1028295307, -1105766207)
		+ W(11, -1108973663, 1048031389, 1035434166, 1015026205);
	sum2 =
		W(0, -1128989779, 1040099849, -1100874000, 1021993174) + W(1, -1130783901, 1011642260, -1132752301, 992269838)
		+ W(2, 1034251701, -1130867684, 1034483450, -1123860313)
		+ W(3, -1121498089, 1034828720, -1104384455, -1113539068)
		+ W(4, -1122004711, 1016725938, -1112228563, 1034859451) + W(5, 1044543345, 1053848304, 1016645052, -1122625223)
		+ W(6, 1023519830, 1034954038, 1046406891, -1104908283) + W(7, 1032774629, 1011006880, -1111737432, -1122349299)
		+ W(8, 1028583216, -1100179639, 1016210650, -1114528083)
		+ W(9, 1023675120, 1019899084, -1114022376, -1111378604)
		+ W(10, 1033297067, 1021084026, -1134051546, -1112348174)
		+ W(11, 1040182737, -1097476412, 1025418184, -1141294629);
	WS(1052377710, -1116561061);
	sum1 = W(0, -1122160137, 1026711393, 1034438088, 1023922180)
		 + W(1, -1115207840, 1014756539, -1112995181, 1046449684)
		 + W(2, -1103073456, -1112523427, 1036366239, -1110629817)
		 + W(3, 1021266631, -1094207935, 1059878180, 1031595583) + W(4, -1096200621, 1025340632, 1017022397, 1051777944)
		 + W(5, -1091454284, -1107259466, 1043506315, -1122333286)
		 + W(6, 1032809511, -1105978112, -1108523806, 1059633699)
		 + W(7, -1105628259, -1126028515, -1105019076, 1045042328)
		 + W(8, -1137740923, -1094439010, 1043730779, -1114494718)
		 + W(9, 1019774100, -1140860791, -1113848547, 1048809290)
		 + W(10, -1114298535, 1024493780, -1119221338, -1140595366)
		 + W(11, 1015748571, 1019553093, -1117446555, -1121208702);
	sum2 = W(0, -1125003387, 1023545558, 1001356924, 1019826271)
		 + W(1, 1029018751, -1114113554, -1110204990, -1122326332)
		 + W(2, 1049948311, -1106041547, -1122275300, 1028296019)
		 + W(3, 1008672566, 1039271760, -1104177316, 1040609653) + W(4, 1017003703, -1143932072, -1110854180, 997586352)
		 + W(5, -1099440370, 1057375034, -1099421810, -1122149120)
		 + W(6, 1015432805, 1043658401, -1101604747, -1098469549)
		 + W(7, 1052007058, -1118594118, 1007507570, -1126010948)
		 + W(8, -1112581048, 1041033112, 1018898909, -1129527698)
		 + W(9, -1129875419, -1128126180, 1034699764, -1108980340)
		 + W(10, -1118843549, 1031512617, -1145172348, 1018354299)
		 + W(11, -1118892801, 1026776081, -1123423040, -1147650596);
	WS(1066846108, 1044745002);
	sum1 =
		W(0, 1019372186, 1049403789, 1042475733, -1091781177) + W(1, -1124410122, 1015897062, 978233216, -1107121557)
		+ W(2, 1051348497, -1100692098, 1039801345, 1009376476) + W(3, -1129136976, 1041504923, 1048713517, -1091573825)
		+ W(4, 1032893815, -1126291000, 1025331363, -1134682116) + W(5, 1054698948, -1089263023, 1040511932, 1006187856)
		+ W(6, -1142297744, 1039399714, 1049146911, -1091452887)
		+ W(7, -1146055296, 1016897132, 1015116199, -1122699462) + W(8, 1058118606, -1090043533, 1032222216, 1012743170)
		+ W(9, 1015645340, -1121336819, 1046729314, -1102394372)
		+ W(10, -1115550793, 1010428515, 1016287548, 1026221102)
		+ W(11, 1056609718, -1091564925, -1107840672, 1000566800);
	sum2 =
		W(0, -1121498998, 1040076187, 1040991236, -1097642453) + W(1, 1041191639, -1143069461, 1025173682, -1110698495)
		+ W(2, 1027215822, 1032193313, -1107046015, -1127878497)
		+ W(3, -1127952317, 1046879062, -1097422534, -1089335507)
		+ W(4, 1027648922, 1033858873, -1123064681, -1114452496)
		+ W(5, -1079622690, -1070315938, -1107556506, 1031644922)
		+ W(6, 1031325102, 1037259271, -1113150532, -1080614075)
		+ W(7, 1040688678, -1125227083, 1031547392, -1113826794) + W(8, 1059352243, 1063284099, 1044912350, -1135729999)
		+ W(9, -1116804726, -1113826560, 1032134129, 1075195474)
		+ W(10, -1107091577, -1112123781, 1013263415, -1114840697)
		+ W(11, 1048220488, 1071802337, 1050907604, -1104322253);
	WS(-1083170743, 1032719415);
	sum1 =
		W(0, 1023701883, -1115388842, -1095142736, -1131637740) + W(1, 1043889005, 1012236805, 1027723212, 1037576352)
		+ W(2, -1104329709, 1047136718, -1114738168, -1143133226)
		+ W(3, -1122560214, 1028066352, -1093573195, 1050356544) + W(4, 1032119470, -1126174356, 989186599, 1034436696)
		+ W(5, -1091782714, 1058921626, 1035779088, 1024911192) + W(6, 1018265472, 1046871436, -1090370147, 1057401704)
		+ W(7, -1119260798, 1033076018, -1118377474, 1036384970)
		+ W(8, -1088395265, 1046747968, 1026791695, -1122725807) + W(9, 1034616094, 1041769608, -1092608855, 1048250192)
		+ W(10, 1007978244, 1033024419, -1143849572, 1033711598)
		+ W(11, -1085234190, 1051022467, 1035213927, 1028803056);
	sum2 =
		W(0, 1040592912, -1091007599, -1122569720, 1061904811) + W(1, -1096410255, -1107753434, -1148866748, 1043419584)
		+ W(2, -1102576481, -1110256028, -1106770914, 1043044202)
		+ W(3, 1032765896, -1111893630, -1114969246, 1042199718)
		+ W(4, -1108992598, -1138614142, -1113675298, -1100951705)
		+ W(5, 1060370086, 1060838438, -1088153932, -1121677972) + W(6, 1035431068, 1030657616, 1018512847, 1061366749)
		+ W(7, -1091610254, 1049599377, -1111525482, -1123081200)
		+ W(8, -1112438148, -1086083341, 1039676388, -1117594428) + W(9, 1031171080, 1009914590, 1033713452, 1029235040)
		+ W(10, -1104419583, -1154941432, -1111672592, 1048594219)
		+ W(11, -1120657004, -1090315205, 1040642594, 1041324320);
	WS(-1087374135, 1068569819);
	sum1 = W(0, 1034522569, 1036038485, 1051494643, -1092286050)
		 + W(1, 1024631242, -1124293233, -1114460210, -1134485343)
		 + W(2, 1048850073, -1097395434, -1155697773, 1035227470) + W(3, 1040675195, 998999958, 1055860825, -1093950865)
		 + W(4, 1034953465, 1022306499, -1156322949, -1102898978)
		 + W(5, 1058980799, -1086427635, 1036357020, -1115248568)
		 + W(6, -1126356143, 1032174021, 1050366134, -1097745188)
		 + W(7, -1115522123, 1025097211, 1038944141, 1032843110) + W(8, 1048730421, -1098221875, 1020968428, 1020281868)
		 + W(9, -1123272884, -1112707068, 1043911796, -1095510475)
		 + W(10, 1032316940, -1112095119, -1147588893, 1041667373)
		 + W(11, 1049367775, -1093210118, -1134843155, 1003691067);
	sum2 =
		W(0, 1036982689, -1101176821, 1032029724, 1031712503) + W(1, -1095262307, -1135236510, -1109420523, 1040154700)
		+ W(2, 1008871494, 1051308638, -1089037290, 1036178124) + W(3, 1038171016, -1103427381, 1053639476, -1103617514)
		+ W(4, -1077227331, 1056219784, -1114883799, 1011961296)
		+ W(5, -1094943648, -1090481186, -1077304111, 1063074442)
		+ W(6, 1032698755, -1115041464, 1046242469, 1048516585) + W(7, -1075605762, 1070767205, 1023400751, -1112162319)
		+ W(8, 1015257266, -1110670159, -1086532256, 1074120487)
		+ W(9, -1119043865, -1114657793, 1018562568, 1026474691)
		+ W(10, -1115849955, 1066414901, 1034471555, -1117007917)
		+ W(11, 1031877719, 1044794303, -1110424851, 1052188053);
	WS(-1094340206, 1025238393);
	sum1 =
		W(0, 1025401267, 1041212259, 1051626551, -1087771683) + W(1, 1026720107, 1024873417, -1120317764, -1123694073)
		+ W(2, 1044638395, -1099303356, 1027277160, 1003045609) + W(3, 1029217422, 1040075594, 1051991350, -1089805402)
		+ W(4, 1042793877, 1025974530, 1017691154, -1128349902) + W(5, 1049159169, -1090474853, 1032035372, -1140916353)
		+ W(6, 1015273200, 1030937834, 1055056667, -1089928234) + W(7, 1038797403, 1026491292, 1006374863, 1030337996)
		+ W(8, 1045537234, -1095611655, 1028636183, -1125445197)
		+ W(9, -1149759301, -1112880429, 1047952828, -1103717662)
		+ W(10, 1034683820, 1018728702, 1023921508, 1048792866)
		+ W(11, -1109761292, -1097665994, 1024357062, 1024842472);
	sum2 =
		W(0, 1016272983, -1117564089, 1054344808, 1082928383) + W(1, 1043627742, -1113989008, -1125328223, 1007328518)
		+ W(2, 1047318060, 1074423709, 1037006400, -1137080694) + W(3, 1019432157, 1038058236, -1095657702, -1074337637)
		+ W(4, 1040243063, 1017883877, -1136495190, -1106032359)
		+ W(5, -1084625245, -1066615612, -1106132294, -1126758430)
		+ W(6, 1024638490, 1036423350, -1124414562, -1087090886)
		+ W(7, -1119023275, 1040797418, -1122054341, -1129861056)
		+ W(8, 1036648948, 1034359725, 1004167460, -1113361096) + W(9, 1016158573, -1141592892, -1120282232, 999766988)
		+ W(10, 1002865564, 1023713345, -1137665190, 1032273458)
		+ W(11, 1033205457, -1114245215, -1113153751, 1022755221);
	WS(-1098231918, 1035887052);
	sum1 = W(0, 1007686525, -1117693688, 1048268202, -1105099271)
		 + W(1, -1110112236, 1016554315, -1112046456, -1119004197)
		 + W(2, 1036810732, -1097653932, -1130249512, -1115219957)
		 + W(3, -1136641001, -1104788790, 1055375147, -1098720398)
		 + W(4, -1106155488, -1142876018, 1025581173, -1092353842)
		 + W(5, 1069647932, 1066085926, -1091717545, -1143806946)
		 + W(6, -1121240420, -1104580134, 1052170270, -1093227035)
		 + W(7, -1110987409, -1113561092, -1165513922, -1146015939)
		 + W(8, 1020096363, -1123833253, -1108464746, -1123809427)
		 + W(9, -1114143760, -1162096818, -1125578169, -1107379122)
		 + W(10, -1156567122, -1113074326, -1123656209, -1117522176)
		 + W(11, 1031911554, -1130540403, -1106840908, -1120698772);
	sum2 = W(0, -1125891647, -1121500935, 1021750179, 1017645919)
		 + W(1, -1130193055, -1118741587, -1139529830, 1033326245)
		 + W(2, -1133323886, -1167588957, 1018366499, 1021086319)
		 + W(3, -1127048511, -1110257678, 1040835222, -1108825416)
		 + W(4, -1144215516, -1113356630, -1119620679, 1033808587)
		 + W(5, 1061147710, 1055027509, 1035778772, -1123951235)
		 + W(6, 1015042367, -1152963927, -1110018076, -1105425292)
		 + W(7, -1105010302, -1124596863, -1133002574, 1023704513)
		 + W(8, 1035246842, -1090179180, 1019226535, 995355927) + W(9, 1001053676, -1125968895, -1123027527, 1035235033)
		 + W(10, -1113493000, -1135606974, -1136336990, -1159911790)
		 + W(11, -1144777900, -1104047270, -1137733870, -1141401292);
	WS(-1081201436, -1083122818);
	sum1 =
		W(0, 1024396773, -1118776317, -1090317103, 1056470156) + W(1, -1120183581, -1124728406, 1040103323, -1121204906)
		+ W(2, -1098486564, 1048677796, -1105729174, 1010393788)
		+ W(3, -1104054160, 1048678635, -1094484293, 1048629197)
		+ W(4, 1032093347, -1105359341, 1042893967, -1101546374) + W(5, -1101075087, 1052113969, 1048228642, 1048587688)
		+ W(6, -1121710378, 1036673102, -1095873942, 1033707976)
		+ W(7, 1044099610, -1107414311, -1122190892, -1112386175)
		+ W(8, -1099326495, 1057451847, -1102747354, 1034642220) + W(9, 1038539251, 1022162966, -1101153544, 1027207978)
		+ W(10, -1114063013, -1109685144, 1020559724, -1111471555)
		+ W(11, -1095630377, 1053998976, -1125760751, 1033222029);
	sum2 = W(0, -1130151079, 1029357099, -1141051917, -1126143047)
		 + W(1, -1138853383, 1016378649, -1128601535, -1139320303)
		 + W(2, 1027307392, -1124015138, 1026568428, -1128887123)
		 + W(3, 1016586775, 1016703563, 1040480663, -1090482710) + W(4, 1051692940, 1024508650, -1116462462, 1036545095)
		 + W(5, -1084177500, -1061542668, 1087807110, -1109325640)
		 + W(6, 1006316053, 1027702761, 1027514935, -1081711054)
		 + W(7, 1065457143, -1115450794, -1136401487, -1115282656)
		 + W(8, 1033882273, 1042416533, -1101742731, 1030137534) + W(9, -1134837023, 1025282364, 975470826, -1107083018)
		 + W(10, 1035528582, 1016609727, 1015531121, -1128863347)
		 + W(11, 1013565163, 1030037156, -1123914522, -1122133136);
	WS(1056806766, 1019813151);
	sum1 =
		W(0, -1109922347, 1038862168, -1094336356, 1045176100) + W(1, 1023835087, -1117706029, 1027672232, -1098777292)
		+ W(2, 1025923920, 1046907893, -1097985673, -1143840774)
		+ W(3, -1113027385, 1057340869, -1089223672, 1028090813)
		+ W(4, 1044113854, -1111671123, -1106442907, -1131946518) + W(5, 1049099726, 1060367739, 1010151151, 1025756788)
		+ W(6, -1119504732, 1048903346, -1102142547, -1102839017)
		+ W(7, 1051267347, -1111600768, -1127683323, -1100586740)
		+ W(8, -1122538541, 1052174932, -1093148714, 1040843731) + W(9, 1015134384, 1027127869, -1099585557, 1024110556)
		+ W(10, 1029024221, -1107564881, -1122196904, -1136830686)
		+ W(11, -1100472159, 1047790604, -1137237669, -1131252120);
	sum2 =
		W(0, 1016054025, -1119367753, -1115811972, 1024987046) + W(1, 1016843613, 1007599121, -1116580030, 1033363716)
		+ W(2, -1119979151, -1114756690, 1025664850, -1120202841)
		+ W(3, -1128856269, -1107794961, 1046175546, -1100926142)
		+ W(4, 1028330842, -1144919563, 1024017790, -1129548157) + W(5, 1051115205, 1048732221, 1029232538, -1123931557)
		+ W(6, -1120027976, 1034251322, -1095340379, 1044324276)
		+ W(7, -1105635461, -1122027017, 1003808451, 1039517400)
		+ W(8, -1127431641, -1104827086, 1042504965, -1118580981)
		+ W(9, -1120561807, 1019337653, 976018325, -1139095561)
		+ W(10, -1118828309, 1016896817, 1020365697, -1174223189)
		+ W(11, -1148320619, -1138276477, -1117203320, 1009819353);
	WS(1067549148, 1061168738);
	sum1 =
		W(0, -1136860560, 1041916271, 1043173595, -1099729080) + W(1, 1028345500, -1117900922, 1019396970, -1102760394)
		+ W(2, 1046914407, -1097589844, 1036811500, -1118556558)
		+ W(3, 1034693791, -1100215160, 1063664325, -1085101004)
		+ W(4, 1044130369, -1118557363, 1031876061, -1127917744)
		+ W(5, 1041579695, 1044764001, -1111608196, -1148658183)
		+ W(6, -1126960466, 1038708237, -1084953669, 1062969721) + W(7, -1096862061, 1028601293, 1026075051, 1042570959)
		+ W(8, -1099553438, 1046958554, -1104831702, 1014732126)
		+ W(9, -1129065354, 1024557450, -1111656016, 1031927572)
		+ W(10, -1121741642, 999719805, -1125694250, -1114527138)
		+ W(11, 1036161892, -1129394940, 1028864534, -1111432076);
	sum2 =
		W(0, 1037988572, -1097183834, -1096111302, -1112255513)
		+ W(1, 1025606252, -1131066844, -1109648154, -1096035348)
		+ W(2, 1046143856, 1047451704, -1109281762, 1021094187) + W(3, -1115314649, -1106718097, 1065688064, 1048785443)
		+ W(4, 1025033440, -1118872350, -1110735622, 1044362532)
		+ W(5, -1100541529, -1089624797, -1124926742, 1035314838) + W(6, 1029414023, 1044653749, 1022961930, 1040629892)
		+ W(7, 1024229044, -1132267648, -1115532881, -1118097482)
		+ W(8, 1041170408, -1135819985, -1109992198, 1004115214)
		+ W(9, -1114457629, 1036871139, -1121640520, -1109975688)
		+ W(10, 1007526703, -1128646118, -1123631499, 1035597348)
		+ W(11, -1109551474, 1030316886, 1031542857, -1117895342);
	WS(-1090126519, 1034760182);
	sum1 =
		W(0, 1022234099, 1038732905, -1095221408, 1049091087) + W(1, -1141106060, -1130848127, 987019599, 1040082783)
		+ W(2, -1096833350, 1049531159, -1100657291, 1036771650) + W(3, 1021371561, 1042926010, -1090005917, 1052645704)
		+ W(4, -1098472859, 1035488804, -1125185183, 1019049563) + W(5, 1049172122, 1048882035, -1113910991, 1025403478)
		+ W(6, 1040030303, -1101231100, 1056956325, -1086324445) + W(7, 1041783487, 1007113098, 1005824514, -1108355337)
		+ W(8, 1052986466, -1089320760, 1033537135, -1138596020)
		+ W(9, 1028122555, -1115211984, 1046568014, -1101798768)
		+ W(10, 1037621024, -1128732298, -1120592523, 1035983309)
		+ W(11, 1025899358, -1123937043, -1125397784, -1127374557);
	sum2 = W(0, 1016736022, 1032939170, -1122689775, -1102551566)
		 + W(1, -1122487238, 1026411789, 1011977196, -1102682487)
		 + W(2, 1060510561, 1060805847, -1122236502, -1128029215)
		 + W(3, -1137999416, 1037611888, 1051792579, 1057985083) + W(4, 1036808922, 1019619350, 1019963070, -1102949496)
		 + W(5, -1073351999, -1073393989, -1103029047, -1125796177)
		 + W(6, 1030437859, 1039010410, 1059164734, 1057367527) + W(7, 1039165500, 1024266957, -1122046802, -1110345340)
		 + W(8, 1062467108, 1062012989, -1106860549, -1119780381)
		 + W(9, -1142727409, -1124097437, 1031495287, -1147452225)
		 + W(10, -1143421321, 1024156551, 1018753414, -1113761662)
		 + W(11, -1101619274, -1099879364, 1015482390, 1016465010);
	WS(-1089242039, -1127205581);
	sum1 =
		W(0, -1124452989, 1047404342, -1086849964, -1114062493) + W(1, 1042532510, 1010360274, 1037734344, -1111320098)
		+ W(2, 1001557948, 998659036, 1038364441, 1032729828) + W(3, -1136469606, -1115981071, 1055753134, -1096047365)
		+ W(4, -1118490271, 1015888923, 1045032037, 1038279993) + W(5, 1059294849, -1107330927, 1044317529, -1118190491)
		+ W(6, -1131176455, 1006926037, 1006841992, -1105936042) + W(7, 1035319841, 1021147727, 1029283077, 1030509432)
		+ W(8, 1049404683, -1087265492, 1043122385, -1123196402)
		+ W(9, 1038076384, -1123275877, 1037635838, -1095492784) + W(10, 1027367204, 1027584778, 1029887056, 1043334248)
		+ W(11, 1044156233, -1080260267, 1053177470, -1118995315);
	sum2 =
		W(0, 1029897599, -1102843967, 1001547796, 1049416264) + W(1, -1120840401, -1115391670, -1114965417, 1046605828)
		+ W(2, 1025076963, -1100594038, 1041915682, 1020641677) + W(3, 1025776431, 1033633995, -1090433692, -1096668289)
		+ W(4, 1040646462, -1111492899, -1121485495, 1048791648) + W(5, 1044097140, -1117020477, 1042521794, 1034331443)
		+ W(6, -1140617930, -1104898739, 1042488362, -1102246327)
		+ W(7, -1112857889, -1115861875, -1113546368, 1031053127)
		+ W(8, -1118485295, 1034926551, -1109164591, -1134127978)
		+ W(9, 1031651703, -1108448442, 1045463546, 1047237110)
		+ W(10, 1015998805, -1120855845, -1117524097, -1108356905)
		+ W(11, 1040816680, 1044694712, -1109851905, -1124879769);
	WS(-1081567068, -1085072352);
	sum1 =
		W(0, 1026202077, 1008391383, 1043376377, -1106037014) + W(1, -1119432853, 1015626934, 1017630556, -1102096537)
		+ W(2, 1035138955, -1113878797, 1041401156, -1112723700)
		+ W(3, 1034866076, -1105309517, 1062685095, -1091962582) + W(4, 1028045374, 995954372, -1120073907, -1113888457)
		+ W(5, -1088326467, -1099527071, 1036249665, -1112822301) + W(6, 990337572, 1038015146, -1087780001, 1065743931)
		+ W(7, -1122166240, 1036674595, -1122725732, 1010107993)
		+ W(8, -1095652846, 1048331161, 1030964177, -1165855255) + W(9, 1016189565, 1035371298, -1111927693, 1035819857)
		+ W(10, 1030882915, 1020668626, -1135328058, -1107104879)
		+ W(11, -1134788873, 1033560764, 1034792920, -1140134473);
	sum2 =
		W(0, -1101998430, 1025808817, 1026331301, 1041383807) + W(1, 1033833028, -1108635033, 1034880732, -1110518368)
		+ W(2, 1035202798, 1044537615, -1096440885, 1042833515)
		+ W(3, -1111573656, -1090739547, -1095903349, 1045506861)
		+ W(4, 1030373631, -1107072548, 1034691412, -1098171169) + W(5, 1068344140, 1069658374, -1094064924, 1037649108)
		+ W(6, 1017688506, 1047617175, -1085314459, -1090700374)
		+ W(7, -1106284721, -1117475933, 1032207084, -1112107064)
		+ W(8, -1108916250, -1135142667, -1113568166, 996218700)
		+ W(9, 1002612774, 1027687639, -1113844364, -1106371211) + W(10, 1043762008, -1115713024, 995363580, 1035291452)
		+ W(11, -1111293323, -1105384559, -1113615358, 1031725587);
	WS(-1122270064, -1083487436);
	sum1 =
		W(0, 1022021054, -1111938972, -1089129474, 1061173530) + W(1, -1117042135, 990992466, 1000846209, 1031069285)
		+ W(2, -1092279467, 1053406092, -1112839626, 997371026) + W(3, -1120651002, 1035108132, -1089405705, 1061891890)
		+ W(4, -1115403968, -1123767278, -1133172181, -1122478547)
		+ W(5, -1088959911, 1046812368, 1035227362, -1136588785) + W(6, 1015175368, 1022898156, -1101358829, 1052509753)
		+ W(7, 983155781, 1014548513, 1008528664, -1109542844) + W(8, -1113192731, 1035774995, 1035355065, -1120262163)
		+ W(9, 1014262402, 1003755051, -1110785838, 1040815801)
		+ W(10, -1114859906, -1139309996, 1032206792, -1099224128)
		+ W(11, -1105614817, 1041852206, 1046440556, -1196238920);
	sum2 = W(0, 1044179919, -1111986018, -1080384748, -1092393621) + W(1, 1048581079, 1031858735, 1022028328, 998943655)
		 + W(2, -1088604014, 1029389095, 1009323699, 1021777892)
		 + W(3, 1040258943, -1095034556, -1104000317, -1090514887)
		 + W(4, 1015383036, 1024626196, -1118974089, -1095846499)
		 + W(5, 1073459027, 1071708766, -1097133430, 1024702395)
		 + W(6, 1033279863, -1110448374, -1098039236, 1012336831)
		 + W(7, -1122793353, 1031448400, -1117110809, -1099083231)
		 + W(8, 1045892370, 1049307354, -1097759856, 1030521846)
		 + W(9, 1031745329, -1120681553, -1111672860, -1100485937)
		 + W(10, 1041920736, 1016567237, -1103290765, -1101323001)
		 + W(11, 1055006842, 1051814517, -1091667564, 1029007432);
	WS(-1097130350, -1073679750);
	sum1 =
		W(0, -1154560184, -1142702368, -1095841490, 1034517635) + W(1, 1044574577, 992206103, 1025389788, 1008724804)
		+ W(2, -1096179481, 1053502809, -1112918112, -1143244972)
		+ W(3, -1145657140, 1035954194, -1095185831, 1045830013) + W(4, 1042446427, -1122388570, 1000633100, 1046084016)
		+ W(5, -1085973126, 1057148843, 1025817904, -1139683234)
		+ W(6, -1120139600, 1042008657, -1089907161, 1051926551) + W(7, 1017272605, 1018417129, 1032643785, -1106616153)
		+ W(8, -1096805620, 1052799826, -1123577295, 1017209342) + W(9, 1008755251, 1025929714, -1098086361, 1043469780)
		+ W(10, -1143679882, 1016358830, 1030414749, -1102859291)
		+ W(11, -1107347576, 1050172789, 1014891512, 1026775680);
	sum2 = W(0, 1021941992, -1106123822, 1031547466, -1135582819)
		 + W(1, 1018035752, 1017098260, -1140009235, -1137197699)
		 + W(2, 1040410800, 1048777558, -1114989513, -1129449426)
		 + W(3, 1026649920, -1104678389, -1091687878, -1102399061)
		 + W(4, 1038853959, -1170697076, 1025391436, -1103278668)
		 + W(5, -1069452203, -1086654414, -1112110740, -1134437671)
		 + W(6, 1033557641, 1049392706, 1071493698, 1036526271) + W(7, -1155541821, 1030635558, -1110654493, 1026389826)
		 + W(8, 1075377385, 1051671224, -1119910153, -1127657747)
		 + W(9, -1117894486, 1046385471, -1093315115, 1003979070)
		 + W(10, -1130248744, 1010389927, 1031221238, -1107040085)
		 + W(11, -1101021764, 1042747507, -1119798403, 1007123883);
	WS(-1110542776, 1046722292);
	sum1 =
		W(0, -1112464600, 1033517476, 1047470894, -1131671638) + W(1, 1005087552, -1142745264, 1016022658, -1108629467)
		+ W(2, -1133454244, 1032980471, -1105826521, 1026603482)
		+ W(3, 1027765771, -1106997347, 1053995028, -1092318054) + W(4, 1042584756, -1129658366, 981819586, -1113497042)
		+ W(5, -1100439522, 1042288212, -1109105451, 1017901338)
		+ W(6, 1026835189, -1116788199, -1093531706, 1061947018)
		+ W(7, -1098489206, -1142191304, 1025143735, -1106078850)
		+ W(8, 1048713001, -1121614518, -1105038597, 1040275689)
		+ W(9, -1111607705, 1041100086, -1106135867, 1012478420) + W(10, 977775992, 1016467704, 1024330241, -1124631714)
		+ W(11, -1115421707, 1041393523, -1114990145, 1020475210);
	sum2 = W(0, 1031452303, -1132232893, -1109510079, 1018866101) + W(1, 1014551643, 1032688527, 992881643, -1116591675)
		 + W(2, 1032912109, -1116915567, 1024567259, -1114177042) + W(3, 978475180, 1016124301, -1114514404, 1055420465)
		 + W(4, -1097097100, 1042584708, -1121457613, -1114931492)
		 + W(5, 1032060799, 1059251768, -1118272021, -1109972047)
		 + W(6, 1034445399, -1094590847, 1051504728, -1088887374)
		 + W(7, 1048490818, 1024892699, -1130052481, 1040974964)
		 + W(8, -1087149232, 1044275534, 1035881493, -1108606213)
		 + W(9, 1032145701, -1110729382, 1039284419, -1114948355)
		 + W(10, 1032922179, -1121421993, -1116902843, 1035934107)
		 + W(11, 1032317221, -1104983612, 1032032409, -1133789139);
	WS(1059165367, -1104520251);
	sum1 =
		W(0, 1007492796, -1108628644, -1117534006, 1041312427) + W(1, -1113108212, -1124001749, -1117692608, 1046236477)
		+ W(2, -1094176525, -1118419948, 1029454180, -1113899741)
		+ W(3, 1009135144, -1120534447, 1053590938, -1107420459)
		+ W(4, -1110779368, -1131761404, -1115310467, 1052736188)
		+ W(5, 1041258594, -1097199722, 1053879643, -1114949702) + W(6, 1014125520, -1118278150, 1001540436, 1055263011)
		+ W(7, -1098892966, 1025063448, -1113191163, 1036684740)
		+ W(8, -1106455985, -1100739533, 1045621277, -1105125705)
		+ W(9, -1129119585, 1015268651, -1112388022, 1040471133)
		+ W(10, -1126748266, -1126282358, -1118876992, 1008090175)
		+ W(11, -1114551242, 1020553106, 1026632706, -1127494856);
	sum2 =
		W(0, 1027505664, -1104527074, 1034957797, 1041601252) + W(1, -1108054404, -1122847824, -1115834059, 1048986559)
		+ W(2, -1098163961, -1125657446, 1041896195, 1034858548) + W(3, 1029084872, -1089420265, 1051828462, 1045110551)
		+ W(4, -1099714824, -1116127595, 1029257304, -1098414029)
		+ W(5, 1053778056, 1041501740, -1129563106, -1170669534)
		+ W(6, -1128264406, -1104406791, 1048509414, 1041829791)
		+ W(7, -1092212913, 1037831890, -1138405484, 1040673804)
		+ W(8, -1106881855, -1119286592, 1049994472, -1107117839)
		+ W(9, -1118563560, -1203758566, -1113115951, 1045914276)
		+ W(10, -1105182054, 1031508216, -1127212263, -1117936348)
		+ W(11, -1136870020, 1022365337, -1139619400, -1127498142);
	WS(1064754871, 1064755352);
	sum1 =
		W(0, -1124996947, 1039345889, -1096693846, 1051509189) + W(1, -1110987505, 1036233792, -1126765813, 1034558935)
		+ W(2, -1096907004, 1048609181, -1122110878, 981607022) + W(3, -1111973122, 1025078634, -1092723587, 1055455058)
		+ W(4, -1103910610, 1033037628, 995438583, 1031530717) + W(5, 1042155040, 1038916133, 1036071207, 1028131846)
		+ W(6, -1131935965, -1102805216, 1055052309, -1085470304)
		+ W(7, 1036962198, -1113728073, 1011044801, -1112086641)
		+ W(8, 1050402072, -1096310694, 1042970795, -1155599823)
		+ W(9, 1017902933, -1108706152, 1045488762, -1110967031)
		+ W(10, 999916154, -1121653045, -1117569083, -1125705364)
		+ W(11, 1036105095, -1114430562, 1043170799, -1131031997);
	sum2 =
		W(0, -1133117125, 1035315397, 1034291601, -1093657955) + W(1, -1083656994, 1063017252, 1023646322, -1104375670)
		+ W(2, 1023753609, 1053589289, -1096844972, -1117431336)
		+ W(3, 1023723550, 1045506061, -1107539440, -1104725243)
		+ W(4, -1079943056, 1065218548, 1016880452, -1100884270)
		+ W(5, 1046403885, 1040733712, -1108767061, -1110535684) + W(6, -1128763803, 1037072250, -1123261308, 987308827)
		+ W(7, 1066015084, -1088643610, 1032406499, -1100571834) + W(8, 1040670310, 1047435788, 1056439411, -1092199491)
		+ W(9, -1112596197, 1043010850, -1109210140, -1103530057)
		+ W(10, 1038430454, -1140617522, 1024272758, -1106522969)
		+ W(11, 1037357283, 1046389911, 1050581867, -1093142505);
	WS(-1141889920, -1150694570);
	sum1 =
		W(0, -1121776659, -1156363954, -1110656781, -1150990554) + W(1, 1001967189, 1009891810, 1035438770, 1043244278)
		+ W(2, -1108191526, 1049522698, 1024784007, 1026909213) + W(3, -1107472311, 1039611642, -1092681840, 1047918398)
		+ W(4, -1120026675, -1115519345, 1029335145, 1044045394) + W(5, -1089342271, 1044281805, 1041259438, 1032535224)
		+ W(6, 1032163820, 1031781705, -1107172434, -1142656241)
		+ W(7, 1035091531, -1156224954, -1122959321, -1113754566)
		+ W(8, -1110931796, -1118178969, -1114065315, -1114416227)
		+ W(9, 1035788170, 1041298854, -1106653204, 1044014582) + W(10, 1037418924, 1034927023, 1006930832, -1113010266)
		+ W(11, -1098776751, 1035377494, 968315538, -1127266575);
	sum2 =
		W(0, -1096670021, 1059540854, 1045575353, -1133958494) + W(1, 1031038260, -1118270456, -1102787949, 1039622534)
		+ W(2, 1037899964, 1013042349, -1110193614, 988987510) + W(3, -1099441746, 1064198145, 1030855272, 1040028330)
		+ W(4, -1117097690, 1032105974, 1043637876, -1086802625)
		+ W(5, -1101655681, 1036771998, -1125265460, -1117707023)
		+ W(6, 1052388948, -1085971065, 1033969343, 1032851236)
		+ W(7, -1103569731, -1134648980, 1042101483, -1113298762)
		+ W(8, -1105771070, -1120619083, 1049976190, 1021389004) + W(9, -1135324433, -1098667485, 1036465297, 981463467)
		+ W(10, -1101523135, -1119296945, 1042670443, -1104634628)
		+ W(11, -1104173140, 1030229840, 1035574893, 1035007302);
	WS(1060329015, -1107100438);
	sum1 =
		W(0, -1139109867, 1016013223, 1052529520, -1098269535) + W(1, -1120993331, 1025836257, -1126768152, -1108878752)
		+ W(2, 1042283693, -1103310414, 1033078264, -1113589378)
		+ W(3, -1154508124, -1139382101, 1051369597, -1093610355) + W(4, 1033661966, 1029380042, 1024792785, 1046477388)
		+ W(5, 1051787130, -1088582834, 1015463488, -1124637616)
		+ W(6, -1145234942, 1046417836, 1040695538, -1090008057)
		+ W(7, 1035018943, -1127749832, -1121126338, 1044791733) + W(8, 1046651812, -1097854544, 1029328303, 1030094510)
		+ W(9, -1165337473, -1115375281, 1039020124, -1110993568)
		+ W(10, 980238373, -1117533511, -1128378904, 1030070044)
		+ W(11, 1046922680, -1105218789, -1121430349, 1016154976);
	sum2 =
		W(0, -1122821091, 1039646422, -1126218548, 1020520346) + W(1, 1030755819, 1003947528, 1016851522, -1156337616)
		+ W(2, -1123806894, -1105518185, 1031650855, 980292032) + W(3, -1106087013, -1131895450, 1035943528, 999070248)
		+ W(4, 1015158698, -1123933765, -1109184296, -1080883791)
		+ W(5, 1071805249, -1096231655, 1043321474, -1122746065)
		+ W(6, 1045004090, -1074990048, 1071092779, -1125969764)
		+ W(7, -1125796080, 1018391998, 1015529466, -1105476432)
		+ W(8, -1126394390, 1028426171, 1026097175, -1126690400) + W(9, 1026918939, -1104782698, 1031828962, 1030594487)
		+ W(10, -1140334484, 1018627618, -1115690469, 1022339242)
		+ W(11, -1122803425, -1127395662, -1110808154, -1149029768);
	WS(1004067712, 1029538397);
	sum1 = W(0, 1039684517, 1025050595, 1055781642, -1093421305)
		 + W(1, -1134522377, 1033902960, -1113057966, -1112884456)
		 + W(2, 1052279792, -1096595713, 1008080123, -1134909265)
		 + W(3, 1034662227, -1120136235, 1057037092, -1096171643) + W(4, 1038845557, 1000314570, 976341006, -1106127376)
		 + W(5, 1048957300, -1083333863, -1104830972, 1017566030)
		 + W(6, -1116361615, -1108532672, 1059667231, -1093970477)
		 + W(7, -1107387175, -1120056627, 1039793800, -1136083213)
		 + W(8, 1049781884, 1050503466, -1105145436, 1034175935)
		 + W(9, -1114202454, -1109109944, 1046150498, -1098876866)
		 + W(10, -1111371224, -1129568684, 1023346679, 1026195563)
		 + W(11, 1052752022, -1119746148, -1106375815, 1002478074);
	sum2 = W(0, 996458418, 1023361218, 1020176326, -1105686968) + W(1, -1112170015, 1016740014, 1033154491, -1129026548)
		 + W(2, 1036155261, -1136279909, 1029838361, -1122796554)
		 + W(3, -1124552606, -1113149678, -1107309754, -1101182829)
		 + W(4, -1110765232, 1027141165, 983965669, -1096377075) + W(5, 1064108379, 1059185253, 1029555247, -1111484496)
		 + W(6, -1113544599, -1108470744, -1113642974, -1094171461)
		 + W(7, 1048386684, 1033692775, -1118592979, -1107366613)
		 + W(8, -1147140265, -1097506500, 995412594, -1108579478)
		 + W(9, 1024911403, 1040480632, -1123866147, 1038318571)
		 + W(10, 1045927904, -1126067866, -1120675710, 978762058)
		 + W(11, -1127049668, 1027330889, -1102738273, 1023291782);
	WS(1047133404, -1079170418);
	sum1 = W(0, 1009155056, -1122581460, 1042667713, 1030334583)
		 + W(1, -1108143194, 1027163842, -1116032717, -1127398915)
		 + W(2, 1041078541, -1113404572, -1123819760, -1122554086)
		 + W(3, -1135035740, -1111731450, 1051022508, -1111377849)
		 + W(4, -1112180142, 1023811915, -1132905800, -1098422622)
		 + W(5, 1065228285, -1104817319, -1102890728, -1133181796)
		 + W(6, 1006908676, -1136427723, 1042380775, -1091891141)
		 + W(7, -1111098047, 1001483047, -1123509635, 1019095722)
		 + W(8, 1050271906, -1103926112, 1023382911, -1116735535)
		 + W(9, -1129150906, 1037504657, -1107182030, -1121675713)
		 + W(10, -1136273159, 1015217807, -1147535977, 1012838771)
		 + W(11, 1023931745, -1123007382, -1123177070, -1130799202);
	sum2 = W(0, -1151544588, 1017708852, -1147640076, 1008923057)
		 + W(1, 1011942449, 1018406594, -1155029688, -1121981859)
		 + W(2, -1129630940, 1024218233, 998377109, -1133221663)
		 + W(3, 1018065470, -1114670464, -1093073209, -1119653793)
		 + W(4, -1131988255, 1025316590, 1007239987, 1049278985)
		 + W(5, -1077783117, -1083801634, 1041518161, -1123603132)
		 + W(6, -1125453823, 1041079714, 1074285479, 1047560438)
		 + W(7, -1114079754, -1131599727, -1118997712, -1156221672)
		 + W(8, 1034878186, 1028846010, -1118519138, 1024940191) + W(9, 1007542759, -1120658712, 1016277382, 1036336794)
		 + W(10, -1121956184, -1131785133, -1133631258, -1113215345)
		 + W(11, 1033160981, 1022080564, 1027490516, -1130450701);
	WS(1043550940, 1028476494);
	sum1 = W(0, -1115183742, -1130981802, -1100607937, 1051762223)
		 + W(1, 1000007075, -1121847282, -1121780237, -1102302048)
		 + W(2, -1105099981, 1040535662, -1138550724, -1111548899)
		 + W(3, -1117842775, -1117998761, -1096882923, 1059510884)
		 + W(4, -1102853271, -1132334487, -1110838377, -1094318158)
		 + W(5, 1062548805, 1068023761, -1099046056, 1013492582) + W(6, 991794198, -1102037997, -1103616404, 1055882697)
		 + W(7, -1102330336, 1018468811, -1111061058, -1115328139)
		 + W(8, -1097580450, 1041348961, -1131654944, -1119471984)
		 + W(9, 1015980795, -1113105937, -1103768718, 1034161697)
		 + W(10, -1112888641, -1129682576, -1113960535, -1106426583)
		 + W(11, -1100373208, 1044552262, -1110284503, -1148988811);
	sum2 = W(0, 1029690847, -1103820712, 998970743, 1028297515)
		 + W(1, -1122562191, -1133991676, -1115037203, 1043435491)
		 + W(2, -1096312501, 1046052979, -1115911439, 1007821180)
		 + W(3, -1127742454, -1100462798, 1044923803, -1099477234)
		 + W(4, 1030898927, -1113716427, 1036903221, 1028701483) + W(5, 1041049643, 1065575031, -1096910875, 1036974934)
		 + W(6, -1106227374, -1121926871, 1030485727, -1098681477)
		 + W(7, 1034498637, -1111652935, 1039025001, -1126383902)
		 + W(8, -1125321886, 1040854499, -1115709255, -1126914630)
		 + W(9, -1108879063, 1017141302, 1008577020, -1106467082)
		 + W(10, 1013474716, -1128843302, 1016988574, -1115441627)
		 + W(11, 1033537170, -1122382559, -1129067614, -1114648723);
	WS(-1079050332, -1087647968);
	sum1 = W(0, -1138480508, -1112879708, -1095708941, 1054719611)
		 + W(1, 1031575959, -1122888245, -1122115440, 1026750308)
		 + W(2, -1102419558, 1048762675, -1106236805, -1139407140)
		 + W(3, 1024624314, 1027382179, -1136300523, 1057423590)
		 + W(4, -1115045376, -1136279992, -1106223181, -1116109267)
		 + W(5, -1083772539, 1057166968, -1096438944, -1112079518)
		 + W(6, 1029330596, 1024806390, -1103579129, 1058690419)
		 + W(7, -1115914082, 1025354440, -1120448614, -1128868784)
		 + W(8, -1102450653, 1049252525, -1116410163, -1128866725)
		 + W(9, -1134294785, 1022822666, -1100406055, 1046884233)
		 + W(10, -1127656777, 1008311211, 1004544641, -1115751616)
		 + W(11, -1099401009, 1051036287, 1031406769, 1030150228);
	sum2 =
		W(0, 1018441725, -1121226957, 1025980595, -1143973174) + W(1, -1145354702, -1118705847, 1018735508, -1128043345)
		+ W(2, 1035475244, 1028848366, 1010180031, 1001175670) + W(3, -1106801879, 1036012925, -1093599779, -1119821797)
		+ W(4, -1106432772, -1114705464, 1042307735, -1105109021)
		+ W(5, 1063056253, 1055391108, -1103238145, 1024485983)
		+ W(6, -1108191465, 1026535678, -1097885523, -1118265757)
		+ W(7, -1114258989, -1109715589, -1153036923, 1024075219)
		+ W(8, 1035122552, 1031788992, -1114303163, 1025382280) + W(9, 1023515972, -1143871918, 1028845741, -1122707515)
		+ W(10, 1031455538, -1125366621, -1130614305, -1115606924)
		+ W(11, -1124060823, -1149779899, -1117711701, -1122890135);
	WS(1061221431, 1002405371);
	sum1 =
		W(0, -1123061017, -1123480946, -1090405194, 1054235011) + W(1, 1026563665, 1000058490, -1109190069, 1033046959)
		+ W(2, -1104934581, 1044209302, -1108435303, -1121369187)
		+ W(3, -1111043962, 1050201177, -1102475777, 1057895846) + W(4, 1037490845, 1030151784, -1094345134, 1042710035)
		+ W(5, -1086823335, 1052530935, -1102625680, -1111380603)
		+ W(6, -1146354418, 1050099666, -1097235340, 1058601910) + W(7, 1033897294, 1040756961, -1113941840, 1026923762)
		+ W(8, -1091215734, 1050794548, -1126650490, -1126829850)
		+ W(9, -1145213652, 1032794752, -1094526523, 1041457976)
		+ W(10, -1110275296, 1032331475, 1017803349, 1029204218)
		+ W(11, -1089600016, 1055600534, 1021417496, 1033488871);
	sum2 =
		W(0, 1049937345, -1089706816, 1050626093, 1030967529) + W(1, -1115709839, 1039088353, 1058657690, -1087536311)
		+ W(2, -1106625833, -1105431871, 1036734782, -1109192755)
		+ W(3, 1071079778, -1078069733, 1020012689, 1044296437) + W(4, -1122006247, 1031394755, 1072348129, -1078647761)
		+ W(5, -1094966474, -1112600090, -1122763227, -1116226089)
		+ W(6, 1066389113, -1079714039, -1098171132, 1038432439)
		+ W(7, -1130276743, 1022577738, 1049150259, -1090508646) + W(8, 1050328795, 1044145959, 1024733405, 1012728894)
		+ W(9, -1119844839, 1022376790, -1105718319, -1126694997)
		+ W(10, 1021875579, -1123093509, -1113785170, -1103849791)
		+ W(11, 1052174137, 1034822829, -1112758982, 1013882918);
	WS(-1092893294, -1089220584);
	sum1 = W(0, 1008699951, -1127519944, 1053766130, -1103359682)
		 + W(1, -1104704049, 998920846, 1010493299, -1118558929) + W(2, 1051919929, -1096189801, 1032200864, 1028526614)
		 + W(3, -1124403149, -1106263811, 1056071340, -1097091836)
		 + W(4, -1111082358, -1149496748, 1025199074, -1113928672)
		 + W(5, 1052175436, -1086367179, 1015736929, 1019181009)
		 + W(6, -1117387089, -1098638288, 1062605050, -1096005139)
		 + W(7, -1120379023, -1115659002, 1015178277, 1041393441)
		 + W(8, 1047707912, -1102452900, -1123219920, 1027645503)
		 + W(9, -1125915034, -1112838969, 1053546873, -1101730612)
		 + W(10, 1019333603, -1131717807, -1130896954, 1035998582)
		 + W(11, 1049473086, -1095432549, -1136688761, -1136451331);
	sum2 = W(0, -1143112647, 1034689803, -1115356591, -1121270233)
		 + W(1, 1017968792, 1021729984, 992704062, -1109431235) + W(2, 1039097516, 1048248946, -1124530814, 1005857263)
		 + W(3, -1124855502, 1033324328, -1073085951, -1106299172)
		 + W(4, 1023517229, -1126326370, 1038449046, -1098090520)
		 + W(5, -1063972596, -1091325299, -1113483013, 1015994888)
		 + W(6, -1105916124, 1038361982, 1062319475, -1090314642)
		 + W(7, -1141826407, 1013997779, 1035072543, 1040866773) + W(8, 1085456662, 1056006422, 1034240002, -1134900259)
		 + W(9, -1114904409, 1032024575, 1062308854, 1043935118)
		 + W(10, -1124783482, -1135264403, 1019251456, -1164332444)
		 + W(11, -1102205120, -1107459099, 1032935811, 1001043447);
	WS(-1104754908, -1106735671);
	sum1 =
		W(0, 1030490103, -1117923535, -1088908700, 1033028505) + W(1, 1045999740, -1120248133, 1032595044, 1002237924)
		+ W(2, -1094516030, 1029213684, -1144798556, 1015682178)
		+ W(3, -1128810020, -1122216143, -1092804364, 1050263192)
		+ W(4, 1022746927, -1129595020, 1032319302, -1120462507)
		+ W(5, -1102093923, 1063837581, -1106958295, 1030078356) + W(6, 1019231224, 1025980110, -1088198897, 1058220138)
		+ W(7, -1107413149, 1021953856, 1025969502, -1123369072) + W(8, -1096286026, 1054477272, 995801516, -1153493672)
		+ W(9, 1016077744, 1034830735, -1102086589, 1045907999)
		+ W(10, -1115665070, 1019926661, 1024124136, -1104242198)
		+ W(11, -1103741447, 1049334234, 1030012489, 1022398552);
	sum2 = W(0, -1116247065, 1035833889, -1087068607, -1107323417)
		 + W(1, -1109274147, 1021616338, 1015145430, -1107082251)
		 + W(2, -1079268655, -1102842161, 1016322550, -1133554677)
		 + W(3, 986051432, -1114579693, 1022672030, 1049680335) + W(4, -1111459111, 1010843781, -1117862601, 1043695503)
		 + W(5, 1067901888, 1032100715, 1026073955, 1017398706) + W(6, -1114715779, 1039299404, 1059152338, 1040660749)
		 + W(7, 992278036, 998891466, 1034116930, -1114493167) + W(8, 1008422125, -1115195239, -1173738319, -1139208557)
		 + W(9, -1144744186, -1120378069, 1020328850, 1018816198)
		 + W(10, 1033325633, -1138764845, 1026244953, 1019204162)
		 + W(11, -1111927269, 1021018582, -1123657301, 1016479082);
	WS(-1092340590, -1082645376);
	sum1 =
		W(0, 1018128252, 1033191659, 1040446513, -1112709788) + W(1, 1031456758, -1113441282, 1018184990, -1106475329)
		+ W(2, 1036685563, -1105689791, 1040219053, -1127103440)
		+ W(3, 1028162329, -1101261661, 1061713267, -1086509296)
		+ W(4, 1042438664, -1123459213, -1117677972, -1102532636)
		+ W(5, 1042646693, 1038532783, -1111899057, 1018898486) + W(6, -1115495745, 1031605429, -1089327101, 1064314083)
		+ W(7, -1100451664, 1033438227, -1115409474, 1010011868)
		+ W(8, -1106573237, 1046976369, -1105951352, 1029058545)
		+ W(9, 1015642046, -1127814216, -1105713919, 1039016129)
		+ W(10, 1010066702, 1013299750, -1118723567, -1112449263)
		+ W(11, -1112423953, 1030956248, 1022848097, -1130132966);
	sum2 = W(0, -1107775669, 1040551451, 1027302533, 1033412933)
		 + W(1, -1135101756, -1131050762, -1121347079, 1042459857)
		 + W(2, -1122087227, -1113656153, 1017950151, -1130160250)
		 + W(3, -1118975841, 1031184422, 1016161914, 1035641742)
		 + W(4, -1109563699, 1017438602, -1121125435, -1152381105) + W(5, 989383522, -1114487413, 1046120628, 987844130)
		 + W(6, -1123325897, -1105935240, 1045806619, 1041762467)
		 + W(7, -1114574520, -1117833439, 1012434826, -1115286413)
		 + W(8, -1125562074, 1029416951, 1035110196, -1173771715)
		 + W(9, -1129695564, -1124425722, -1111270899, 1028252326)
		 + W(10, 998528980, -1121778743, 1006663086, -1111096901)
		 + W(11, -1114174571, -1127668218, 997585257, -1126450718);
	WS(1052284526, 1042464092);
	sum1 =
		W(0, 1010280196, 999914700, 1057530557, -1098111272) + W(1, -1101387838, 1027464615, -1136974408, -1110845507)
		+ W(2, 1046554367, -1100087104, -1110795931, -1128121686)
		+ W(3, 1026365340, -1109035161, 1060667985, -1090659644)
		+ W(4, -1102616600, 1001926272, 1020617774, -1110448219)
		+ W(5, 1063323154, -1094987596, -1105684762, 1025859742)
		+ W(6, 1023947782, -1110075532, 1043924417, -1095988958)
		+ W(7, -1124311688, 1017827156, -1127515216, 1038195741) + W(8, 1050039723, -1097163609, 1018127786, 1034844538)
		+ W(9, -1129271461, -1114945332, 1042422080, -1105136802)
		+ W(10, -1124435598, -1130637466, 1007810505, 1019473092)
		+ W(11, 1052688005, -1095692091, -1114597706, 1027019478);
	sum2 =
		W(0, 1025355846, -1119913429, 1034044275, -1140464466) + W(1, -1091074448, 1041357090, -1124685033, 1010871130)
		+ W(2, 1036346050, 1032812135, -1086522508, 1037018199) + W(3, 1029205900, 1016143206, -1128364593, 1071964190)
		+ W(4, -1074918519, 1033277276, 1011755468, 1033794365)
		+ W(5, -1133342818, 1067600837, -1089329657, -1111447139)
		+ W(6, -1113277680, -1140030878, 1020927778, 1039362648)
		+ W(7, -1106053895, -1118126225, 1035269289, 1020099653) + W(8, 1035477071, 1033733070, -1108456989, 1032003060)
		+ W(9, -1122502097, 991986873, 1011575434, 1008065452) + W(10, -1146528221, -1117647411, 1013457876, 1035095720)
		+ W(11, 1029499077, 994468553, -1106105254, 1009180302);
	WS(-1085785015, -1080175544);
	sum1 = W(0, 1035373246, -1103151077, 1058377668, -1091874455)
		 + W(1, 1025579124, -1111695537, -1125806618, 1045216768)
		 + W(2, 1050584367, -1094766367, 1043611260, 1043525714)
		 + W(3, -1118822551, -1094452856, 1054861331, -1107649205)
		 + W(4, -1106387815, -1102079139, 1044894533, 1039875576)
		 + W(5, 1046782533, -1090132878, 1049375324, -1105407270)
		 + W(6, -1102223008, -1151103277, 1057861265, -1090472533)
		 + W(7, -1115030560, -1144672552, 1041222777, -1094574331)
		 + W(8, 1051791466, -1111571937, -1137989279, -1102123612)
		 + W(9, 1023709757, 1048044105, 1043274206, -1098390656)
		 + W(10, 1049548184, 1041305154, -1122183565, -1103877399)
		 + W(11, 1058273114, -1092114299, -1106419572, -1116205169);
	sum2 =
		W(0, 998449416, -1118465870, -1124628345, -1148690252) + W(1, 1037770975, -1105952484, -1121990028, 1035743758)
		+ W(2, 1040306990, 1001004257, -1132010249, 1037805583) + W(3, 1039055377, -1103571680, -1098483719, 1060096717)
		+ W(4, -1108861100, -1087084008, -1115523342, 1049274722) + W(5, 964150684, 1077176219, 1047972499, -1070507600)
		+ W(6, -1132069983, -1106547389, 1024621733, 1060014437)
		+ W(7, -1098623231, -1092504349, 1032292249, -1126693677)
		+ W(8, -1103504000, 1016774454, 1034159573, -1105946989)
		+ W(9, -1128335569, 1034009109, 1043582890, -1107960970) + W(10, 1020716885, 1041667680, 998312734, -1116877357)
		+ W(11, -1116867442, -1139511962, 1042264637, -1102914489);
	WS(1041580764, 1025947967);
	sum1 =
		W(0, 1032565172, 1034662848, 1053611982, -1093835868) + W(1, -1131110976, 1036244351, -1116825273, -1104706235)
		+ W(2, 1050747028, -1092905173, -1131069497, -1119290642)
		+ W(3, 1019951750, -1115255997, 1050206724, -1095669879) + W(4, 1036897764, 1017394926, 1022134396, -1107214727)
		+ W(5, 1063007652, -1096926641, -1105182467, 1029927621)
		+ W(6, -1111515158, -1098820316, 1060757006, -1089733625)
		+ W(7, -1098715869, -1106823604, 1034025399, 1032808736) + W(8, 1052025888, 1049974094, -1104277767, 1037476046)
		+ W(9, -1110133221, -1102823188, 1043880105, -1099659531)
		+ W(10, -1106501955, -1114565306, -1159719714, 1021100817)
		+ W(11, 1052817434, -1119725058, -1106408671, -1122404893);
	sum2 = W(0, -1132209742, 1031078182, -1131885988, -1109418986) + W(1, 969823813, -1135041624, 986836209, 1029631070)
		 + W(2, 1025515900, -1129378830, 1027058278, 1012367442)
		 + W(3, -1121945777, -1119773491, 1029199828, -1113141662)
		 + W(4, 1030656895, -1116640321, -1170553346, 1020231728)
		 + W(5, -1120148774, 1055904551, -1099466937, 1014349374)
		 + W(6, -1138085578, 1023900693, -1122079840, 1057958803)
		 + W(7, -1089769002, 1019607807, -1127752664, -1133642976)
		 + W(8, 1019687015, 1044815557, -1096970616, 1019685270) + W(9, 1024317954, 1016594015, 1019770946, -1115676013)
		 + W(10, -1105180704, 1040370156, -1170071298, -1123929889)
		 + W(11, -1134784812, 1040873658, -1104818759, 1020720783);
	WS(-1101021916, -1101341893);
	sum1 =
		W(0, 1026213188, -1104193847, -1099125811, 1055643976) + W(1, 1025577212, -1110018309, -1128959914, 1029994953)
		+ W(2, -1096018912, 1049220736, -1111820508, 1025253614)
		+ W(3, 1026395551, -1146733010, -1093634574, 1055313981)
		+ W(4, -1119144868, -1114303945, -1114900877, 1036038140)
		+ W(5, -1086773562, 1052012604, -1127551698, -1123712161)
		+ W(6, -1152047246, 1031817213, -1090412335, 1060627153)
		+ W(7, -1111302883, 1028280877, 1012420650, -1118727997)
		+ W(8, -1107844781, 1051291321, 1025725832, -1119269431) + W(9, 1006057769, 1021561044, -1104575744, 1049980081)
		+ W(10, -1112108341, 1031833384, 1026345301, -1106810537)
		+ W(11, -1104632714, 1047342967, 1003961523, 999050183);
	sum2 = W(0, -1131988010, -1111316079, 1041465340, 1024389323)
		 + W(1, -1121573843, -1149117460, 1023490159, 1007442131)
		 + W(2, -1100903601, 1055734435, -1125698351, -1131908940)
		 + W(3, -1126411872, -1122871173, 1038743702, 1080207498)
		 + W(4, 1043717463, -1114017647, -1164111651, 1046145376)
		 + W(5, -1093182708, 1078445253, 1049726225, -1119425741)
		 + W(6, -1121501747, 1040330964, 1049859497, -1068399047)
		 + W(7, -1122596352, 1019240934, 1031886393, -1109560063)
		 + W(8, -1098635398, -1066503158, -1100760677, 1009702615)
		 + W(9, -1117332099, 1016982738, 1035352171, -1109489195)
		 + W(10, -1113462329, 1032687935, 1035364539, 1005935896)
		 + W(11, -1113093917, 1012210427, 1035980752, -1141270643);
	WS(1046490332, 1041425064);
	sum1 = W(0, 1024529499, -1116828595, -1093042204, 1043650965) + W(1, 1015429414, 1019425762, 1033054902, 1002731779)
		 + W(2, -1098109922, 1045029126, -1106337284, 995804238) + W(3, 1031945755, 1040980232, -1092614541, 1058500980)
		 + W(4, 1033182334, 1032419541, -1146773895, -1160896989)
		 + W(5, -1086741475, 1055608303, -1109695552, -1179835378)
		 + W(6, 1029605664, 1052617834, -1091564618, 1058257970) + W(7, -1174108025, 1044059953, 1004520717, 1015420456)
		 + W(8, -1090483479, 1019101890, 1029823567, -1127672093)
		 + W(9, 1031502108, 1044142352, -1094325635, 1041689704)
		 + W(10, -1123497953, 1032927635, 1024614604, 1032157630)
		 + W(11, -1086427940, 1049761551, 1041880275, 1040104968);
	sum2 = W(0, -1122431319, 1026151548, -1122010793, 1049905644)
		 + W(1, -1102178930, -1124048569, -1114479591, -1106953243)
		 + W(2, 999999917, -1108260971, -1125976243, -1126306455) + W(3, 1024826864, 1048064546, 992235770, 1050719290)
		 + W(4, -1123774104, 1025075060, -1100833312, -1097347844)
		 + W(5, 1040448763, 1045454882, -1096948195, -1105554812) + W(6, 1043724086, 1037967160, 1044292364, 1049686405)
		 + W(7, 1038302972, 1034346164, -1109354990, -1109085075)
		 + W(8, 1032432738, -1111087807, -1108325988, -1114960687)
		 + W(9, -1130104331, -1110876131, -1143420941, -1098496523)
		 + W(10, -1118752296, 994535386, 1015245663, 1007980535)
		 + W(11, 1040568157, 1043523736, -1113347688, 1032072922);
	WS(-1096079726, -1086813702);
	sum1 = W(0, -1135457777, -1105268453, 1045566625, -1104980990)
		 + W(1, -1105625101, -1128467237, 1020632987, -1134572551)
		 + W(2, 1038076635, -1125909619, -1145052038, 1035122115)
		 + W(3, -1136898909, -1100910973, -1141635906, -1094783105)
		 + W(4, 1032999502, -1125440663, 1041289173, -1166801940) + W(5, 1058638213, 1057673490, 1030475041, 1035865453)
		 + W(6, 1012368645, 1038525034, -1104077708, -1100424110)
		 + W(7, -1113674176, 988204202, 1002632984, -1102504381)
		 + W(8, 1033251913, -1111352769, -1113040784, -1119749552)
		 + W(9, 1024629150, 1029902179, 1009307365, 1012100357) + W(10, 992583714, 1027550920, -1127204699, -1110256943)
		 + W(11, 1022942147, -1133590617, -1114381639, -1124393059);
	sum2 = W(0, 1009177065, -1117003048, 1042183695, -1105766164)
		 + W(1, -1112946812, 1019480223, -1120740066, 1013092463)
		 + W(2, 1025589372, 1042721142, -1113055730, 1026018809)
		 + W(3, 1031366584, -1102800003, -1111208570, -1149080533)
		 + W(4, -1103263899, 1020058227, 1041576942, -1090661723) + W(5, 1068855162, 1040487387, 1030911277, 1007104581)
		 + W(6, -1100270767, 1059100650, -1085550755, 1023619821)
		 + W(7, -1103276630, 1029611268, 1045439690, -1097382737)
		 + W(8, 1044086134, -1099098175, -1114239046, -1162581429)
		 + W(9, -1125959183, 1022453518, 1032267243, -1126080241)
		 + W(10, -1107084863, 1037226018, 1033773937, -1106788899)
		 + W(11, 1025170288, -1106320787, 1019625936, -1116554192);
	WS(1059841719, 1028884484);
	sum1 = W(0, -1113543486, -1108411818, -1112074625, 1058342439)
		 + W(1, -1101044205, -1143395087, -1112448166, -1111506273)
		 + W(2, 1034453786, 1041783662, -1112657624, -1122260358)
		 + W(3, -1123514455, -1104706915, 1033474668, 1050338440)
		 + W(4, -1103529079, -1124590486, 1014814024, -1096756366)
		 + W(5, 1052483434, 1043430567, -1099567912, -1132902244)
		 + W(6, -1116573889, -1106354949, 1048710884, -1116369607)
		 + W(7, -1110811775, -1118491109, -1120616579, -1107115957)
		 + W(8, 1049505778, -1117001986, -1119641312, -1118809775)
		 + W(9, -1132301434, -1117349474, 1050151687, 1011608836)
		 + W(10, -1133908615, 996976763, -1127146586, -1105758103)
		 + W(11, 1056594572, -1106214629, -1113349351, -1114523384);
	sum2 = W(0, -1131846847, -1142019487, -1119272484, 1043688817)
		 + W(1, -1110979463, -1128104285, 999597315, 973346488)
		 + W(2, -1113005256, -1112114230, -1112619479, 1003422803)
		 + W(3, 997751878, -1127636492, -1113445057, 1056371527)
		 + W(4, -1097247478, 1021279303, -1114921220, -1114646695)
		 + W(5, 1055277760, 1041350431, 1019660165, -1127196333) + W(6, 1031101790, -1098897499, 1032426103, 1038923617)
		 + W(7, -1105379211, -1138766624, -1115596944, 1027087956)
		 + W(8, 1036539833, -1123786644, 1026606310, -1129408714)
		 + W(9, 1024706196, -1111832500, -1114392819, -1130636099)
		 + W(10, 1012894502, -1130181692, -1120544321, 1029100436)
		 + W(11, 1010252474, -1123180191, -1125326592, -1164469676);
	WS(-1092619630, -1089382730);
	sum1 =
		W(0, -1111364766, 1023648980, 1039669985, -1112475547) + W(1, -1102256285, 1036516737, 1043539187, 1020312451)
		+ W(2, -1096148415, 1048019422, 1027548272, -1110790259) + W(3, 984781533, -1115220152, 1055391282, -1085560118)
		+ W(4, 1048070471, 1016263062, 1030068626, -1101226428) + W(5, 1026945555, 1059189430, -1108016176, -1120756633)
		+ W(6, 1026274177, 1038621209, -1081505706, 1059392734) + W(7, 1040580240, 1007770772, -1111039089, -1105671421)
		+ W(8, 1045179252, -1105049488, 1037378816, 1034683832) + W(9, 1024515101, -1101912057, -1132720100, 1041558112)
		+ W(10, 1031071010, -1109624324, -1120853581, 1015856825)
		+ W(11, 1027675681, -1133761880, 1032748839, 1021933410);
	sum2 = W(0, 1021752691, -1111677325, -1108952074, 1033183913)
		 + W(1, 1044091848, -1113755692, -1117827136, 1031932470)
		 + W(2, -1110048197, 1038437939, -1103930854, 1027358915)
		 + W(3, -1125983252, -1130612142, 1045228241, 1050756049)
		 + W(4, 1008734718, -1104619422, 990310070, -1104195843) + W(5, 1051763659, 1045197632, -1105931725, 1032921649)
		 + W(6, -1109957501, -1168184730, 1028013889, -1115591069)
		 + W(7, -1149204891, -1117367196, 1040724727, -1105272655)
		 + W(8, -1136328910, -1123843648, 1020655719, -1140627498)
		 + W(9, -1109878975, 1035492359, -1114456338, -1120329563)
		 + W(10, -1120613434, 1033876328, 1031887118, -1103738768)
		 + W(11, -1114723198, 1035246991, -1121689275, -1121880867);
	WS(1051433070, 1041054969);
	sum1 = W(0, 1027474774, 1025557871, -1105663671, 1035613609) + W(1, 1041537220, 1027665948, 995089009, 1019369911)
		 + W(2, 1032468488, 1037418314, 1036952965, -1122283488) + W(3, 1034863641, 1049084179, -1096978722, 1039456478)
		 + W(4, 1041156238, 1041167849, -1109189270, 1046403907)
		 + W(5, -1082587707, -1080639932, 1049567823, -1112387034)
		 + W(6, 1039503310, 1044512531, -1102025153, 1026454114) + W(7, 1040087661, 1039611744, -1126811322, 1035909664)
		 + W(8, -1107200379, 1042549431, 1039105725, -1137459494)
		 + W(9, 1033371404, 1033234174, -1104819461, 1042229543)
		 + W(10, -1131034584, 1031071714, 1010666397, 1028564471)
		 + W(11, -1106755535, 1034360184, 1031577769, 1033297350);
	sum2 =
		W(0, 1039097792, -1103860174, -1106228186, 1004583985) + W(1, 1031892389, -1133334119, -1128793460, -1106733661)
		+ W(2, 1050938198, -1097187313, 1046933969, -1107245750)
		+ W(3, -1140010118, 1043000544, -1100268114, 1021007203)
		+ W(4, -1107049139, 1039577114, 1022871695, -1106671798) + W(5, 1039252188, 1053089515, 1049075999, -1104825734)
		+ W(6, -1138263433, 1046664654, -1099105674, 1048715277)
		+ W(7, -1103930146, 1030321621, -1112923836, -1123142296)
		+ W(8, -1121884665, -1114597930, 1022883749, -1117968576)
		+ W(9, 1026478628, 1037719970, -1100173198, 1047464456)
		+ W(10, -1098080196, 1036807670, -1110368657, 1042580191)
		+ W(11, 1034926170, -1106315502, -1108178582, 1018138445);
	WS(-1097236334, -1078251511);
	sum1 =
		W(0, -1147379729, -1107131303, -1102832418, 1058323440) + W(1, 1023750586, -1116361496, 981774949, 1007351583)
		+ W(2, -1125527926, 1053289720, -1121375351, -1124892056)
		+ W(3, -1145120489, 1033603653, -1095625930, 1056660465)
		+ W(4, 1026746467, -1128008098, -1112510828, 1043141838)
		+ W(5, -1082084799, 1032726417, 1033795604, -1117973855) + W(6, 975327689, 1029606457, -1090577043, 1058345481)
		+ W(7, 1025947909, -1148460889, 1008364580, 938727969) + W(8, -1093823475, 1053416161, -1131151340, -1125502955)
		+ W(9, -1140670990, 1020032977, -1098508888, 1046390514)
		+ W(10, -1119905544, 999577711, 1022969831, -1108966769)
		+ W(11, -1096801949, 1049766564, 1037296218, 1010324189);
	sum2 =
		W(0, 1024894779, -1102276353, -1120020336, -1081787381) + W(1, 1039662448, 1023553607, 1020144998, 1025017931)
		+ W(2, -1096890621, -1080908066, 992888305, -1118655405)
		+ W(3, -1118791847, -1107221556, 1050182775, -1102161510)
		+ W(4, -1130889346, -1120230550, 1007750652, 1046635995) + W(5, 1039741552, 1072604155, 1039835396, -1126400334)
		+ W(6, -1137666916, -1132306598, 1043589185, 1055213170) + W(7, -1110509653, 1020541198, 1023698735, 1023586615)
		+ W(8, -1108361045, -1115556916, -1122324709, 1020891302)
		+ W(9, 1009542396, 1030880679, -1114600836, 1037616572)
		+ W(10, 1000980713, -1119304668, -1129126018, 1015842286)
		+ W(11, 1024872627, -1105259074, -1124270218, 1033066840);
	WS(-1095840110, 1065907853);
	sum1 =
		W(0, -1149009607, -1123781617, 1057715094, -1102734645) + W(1, -1101560548, 1034276991, 1029310442, -1130903741)
		+ W(2, 1048478500, 1041326469, 1036129479, 1021921030) + W(3, -1122029108, -1115466131, 1058442742, -1088947208)
		+ W(4, -1107277134, 1036949012, -1136794300, 964920945) + W(5, 1045634572, -1083008792, -1109559039, 1024401462)
		+ W(6, -1118254622, -1115351608, 1052165513, -1096684061)
		+ W(7, 1036543086, -1114280609, -1132243967, 1043406509) + W(8, 1053323726, -1089856222, 1024712701, 1035777670)
		+ W(9, -1126823604, -1116119295, 1042519141, -1127763004)
		+ W(10, 1009014011, -1132072137, 1010554921, 1040435870)
		+ W(11, 1051535704, -1095672430, -1114598742, 1024787534);
	sum2 =
		W(0, -1122765153, -1112086475, 1040388299, 966593378) + W(1, -1114107386, 975247631, -1119761608, -1118318168)
		+ W(2, 1023061820, -1102263327, -1113965021, -1137846028)
		+ W(3, -1115823403, -1121250504, -1128744886, -1110151426)
		+ W(4, 1045334069, -1111548146, -1123357438, -1119202357)
		+ W(5, 1057284387, 1059190541, -1118800384, 1023792011)
		+ W(6, -1105805209, 1024515185, -1103324019, -1106793279)
		+ W(7, -1164047122, -1112106446, 1031734555, -1130234658) + W(8, 1037222780, 1050053336, 1025627836, 1020007628)
		+ W(9, -1111986136, -1134784044, -1110952019, -1107073751)
		+ W(10, -1114668630, -1125560981, -1126486235, 1026675759)
		+ W(11, -1117543075, 1021583022, -1124432766, -1131408661);
	WS(1024351088, -1094038469);
	sum1 = W(0, 1016930687, 1038061004, 1052546457, -1086527812) + W(1, 1040515838, 1006605995, 1024919184, -1118029957)
		 + W(2, 1050276351, -1103330015, 1027568116, 1004978763) + W(3, 988693323, 1005748798, 1052906127, -1085615881)
		 + W(4, 1040353352, 1030413326, 1038267403, 1038925818) + W(5, 1062157201, -1097782940, -1124671689, 1031140124)
		 + W(6, 1001354275, 1032752795, 1055274272, -1088621706)
		 + W(7, -1113419105, 1009586849, -1123840710, 1034287148)
		 + W(8, 1050137483, -1090365828, 1017331974, 1023985459)
		 + W(9, -1125725377, -1110688307, 1036684158, -1108159426)
		 + W(10, 1018660298, -1129057942, -1120680465, 1036629872)
		 + W(11, -1112935826, -1098987606, 1039926041, -1120649652);
	sum2 =
		W(0, 1018662896, 1033363591, -1101021011, -1107389045) + W(1, 1013978472, -1120396150, -1131745232, 1031409358)
		+ W(2, -1109130821, 1050735765, -1122086781, 1024022584)
		+ W(3, -1136728576, 1036576685, -1097527529, 1043333749) + W(4, 1029525730, 1015209616, -1110788716, 1060006588)
		+ W(5, 1058553385, -1120731420, -1118628277, 1030135008)
		+ W(6, -1123530251, 1052968790, 1023922010, -1100470754)
		+ W(7, -1117232951, 1018906596, -1101470606, -1102632350)
		+ W(8, 1057288665, -1097217661, -1112638769, -1121049341)
		+ W(9, -1110519714, -1105224546, -1111209476, 1038218737)
		+ W(10, -1121310567, 1024891644, -1125138150, -1083015355)
		+ W(11, 1034932287, 1047940150, 1023530026, -1113292326);
	WS(-1086599863, 1058406314);
	sum1 = W(0, -1165120005, 1027409257, 1060099497, -1093079745)
		 + W(1, -1114693988, 1019186220, -1133002117, -1121445206)
		 + W(2, 1049800473, -1099695891, 1033258882, 1025328858)
		 + W(3, -1129945046, -1106007410, 1059141168, -1091476505)
		 + W(4, -1129815521, -1128567742, 1024249318, -1105883025)
		 + W(5, 1051534797, -1093891126, -1124179562, 1017248474)
		 + W(6, -1119162837, -1105279538, 1058010671, -1094225343)
		 + W(7, -1106482085, -1123837177, 1026085015, -1127421331)
		 + W(8, 1051659429, -1106347590, -1112036922, 1031899202)
		 + W(9, -1121003281, -1109094875, 1047889907, -1098091099)
		 + W(10, 1030868870, -1123224348, -1127955907, 1024561201)
		 + W(11, 1050835423, 999784785, -1097732400, -1141903913);
	sum2 = W(0, -1116781913, 1031543998, 1082393585, 1050004941) + W(1, 1025243259, -1123250937, 1016621488, 1029140379)
		 + W(2, 1078957479, 1028477447, 1010603263, -1125975170)
		 + W(3, -1133566515, 1044191480, -1080327233, -1104837212)
		 + W(4, -1125439138, 1007793087, -1124282558, -1105795809)
		 + W(5, -1065075267, -1086493521, -1117319975, 1028403247)
		 + W(6, 1034216133, 1017978886, -1076777978, -1109285108)
		 + W(7, 988101688, -1125200922, -1128560494, -1175609568) + W(8, 1030943022, 1045155438, 1024551608, 1020903576)
		 + W(9, 991940908, -1120640387, -1110243052, 1033432207)
		 + W(10, -1129511338, -1119399555, 1017899660, 1019924506)
		 + W(11, -1113970478, -1130476854, 1020472787, 1028374268);
	WS(-1102531292, -1104168529);
	sum1 =
		W(0, -1149508566, 1032023755, 1058049088, -1091020399) + W(1, -1123106485, 1018386839, -1156103398, -1123937923)
		+ W(2, 1044530702, -1093487559, 1028416434, 1022122127) + W(3, 1005530819, -1114986325, 1057825341, -1088576155)
		+ W(4, -1124442300, 1027828556, 1019304359, -1105594348)
		+ W(5, 1061967565, -1113700815, -1132463754, 1023613146)
		+ W(6, -1111288609, -1100927253, 1057378026, -1096522221)
		+ W(7, -1107169312, -1118265958, -1152861762, 1042848102)
		+ W(8, 1043852869, -1100187457, 1030031137, 1031835352)
		+ W(9, -1123770879, -1131000647, 1032195229, -1097716728)
		+ W(10, -1127676038, -1124424850, 992160490, 1048571064)
		+ W(11, 1021567685, -1095320739, 1015048992, -1151822630);
	sum2 =
		W(0, -1112466451, 1034684305, -1101371049, -1100658772) + W(1, 1043071493, -1119405084, -1130983341, 1035765483)
		+ W(2, -1113050760, -1100149859, 1039321546, -1140521940)
		+ W(3, 1032826781, -1117553496, -1096382267, 1042208912)
		+ W(4, -1131759707, -1127348451, -1114093653, -1101908611)
		+ W(5, 1063677104, 1062452463, -1106482074, 1028341682) + W(6, 1040752192, -1105770401, -1132405995, 1047214162)
		+ W(7, -1105645940, 1022142418, -1154197073, -1106309648)
		+ W(8, -1114901667, -1095028755, 1034888818, -1118255322) + W(9, 1026229169, 984953298, 1023704972, -1109270652)
		+ W(10, 1035103126, -1118485150, 1032051747, -1113409477)
		+ W(11, -1104964374, -1107539022, 1008251057, 1025943565);
	WS(-1107552696, -1110437397);
	sum1 = W(0, 994440345, -1114854865, 1038159592, -1169396004)
		 + W(1, -1112745281, 1003079356, -1123893979, -1115498472)
		 + W(2, -1143015444, -1103811554, -1176837895, -1126823399)
		 + W(3, -1123659045, -1107252796, 1048547885, -1102945115)
		 + W(4, -1113210869, -1127252913, 1033249360, -1098484960)
		 + W(5, 1066459081, 1054059005, -1092775086, 1036761683)
		 + W(6, -1115012423, -1105215024, 1050116824, -1110458371)
		 + W(7, -1107508006, -1117476787, 1025628848, -1113844817)
		 + W(8, -1114931568, 1027966800, -1115481499, -1139958260)
		 + W(9, -1120012907, 1015022176, -1139703834, -1137430074)
		 + W(10, -1123286831, -1143819946, -1138236651, -1112267573)
		 + W(11, 1030992175, 1038350450, -1114208046, -1119805695);
	sum2 =
		W(0, -1128900045, 1032112026, -1122103841, 1020429393) + W(1, -1123818335, 1025087925, -1134566747, -1121844433)
		+ W(2, 1023900033, 1031965476, -1168200234, -1116320886) + W(3, 1023101249, 1024457633, -1130431017, 1010339139)
		+ W(4, -1111989275, 1037399444, -1119409466, 1041370918)
		+ W(5, 1071310745, -1073631838, -1111141033, -1131868341)
		+ W(6, 1014344875, -1138667107, 1015570157, 1024644617) + W(7, -1128248465, 1027301561, -1124604689, 1023011873)
		+ W(8, 1025187637, 1038341472, 1032459330, -1118206868)
		+ W(9, -1135550339, -1123574415, 1029193653, -1117036677)
		+ W(10, 999769253, -1124415769, 1011013307, 1018662193)
		+ W(11, -1118001398, 1034637136, 1020580065, -1136885571);
	WS(-1106869980, -1095812171);
	sum1 = W(0, 998635262, 1030538232, -1104276842, 1021368885) + W(1, 1037657452, 1012233735, -1132768195, 1032306163)
		 + W(2, 1027943897, 1042581143, -1130589992, -1127936403)
		 + W(3, 1031165051, 1040655940, -1094369165, 1043839724) + W(4, 1045125152, 1030674671, -1109012795, 1049530762)
		 + W(5, -1079963696, -1098205560, 1052736873, -1106402911)
		 + W(6, 1031921458, 1035845131, -1094529094, 1041010327) + W(7, 1041646697, 1035635524, 959153786, 1029124089)
		 + W(8, -1138415831, 1043286153, 1033263566, -1117746707)
		 + W(9, 1015400066, 1034791747, -1107836910, 1040781721)
		 + W(10, -1127518347, 1026900011, 1020404450, -1126776961)
		 + W(11, -1127281161, 1032119517, 1032079673, 1007765715);
	sum2 =
		W(0, -1137391706, 1016897725, -1122041158, 1032188407) + W(1, 959684203, 1004755699, -1152109415, -1123613558)
		+ W(2, -1117579022, 1034093919, -1123954990, -1142267571)
		+ W(3, 1015680093, 1031100358, 1032233585, -1107212716) + W(4, -1144448755, 1020208893, -1108578627, 1031185182)
		+ W(5, 1068869480, -1079207220, -1112638895, -1131161181)
		+ W(6, 1012334874, 1018767069, 1031129926, -1118301998) + W(7, -1145613555, 1014639674, -1126811133, 1016912269)
		+ W(8, -1135215962, 1010098650, 1002322227, 1010341946)
		+ W(9, -1146463859, -1123894542, -1172726683, 1010207290)
		+ W(10, -1163026381, -1128211133, 1013671002, -1129388765)
		+ W(11, 1025914590, 998321459, -1185201771, 1014227898);
	WS(-1106551004, 1058945856);
	sum1 = W(0, -1136733265, 1027999917, 1036329486, 1021052191) + W(1, -1112842790, 996925861, 1029534949, -1110759309)
		 + W(2, 1039804839, -1090459221, 1042972690, -1126301053)
		 + W(3, 1040114552, -1101184472, 1055915689, -1088507490)
		 + W(4, -1116549941, 1035692146, 1023973738, -1136820001)
		 + W(5, 1045009467, -1102642413, 1048917175, -1116120689)
		 + W(6, 1008178533, -1120539979, -1099722578, 1057115504)
		 + W(7, -1103385510, 1032281663, -1121731675, 1050535890)
		 + W(8, -1092228133, -1141944531, 1042662182, 1025401864)
		 + W(9, -1122738710, 1036280349, -1110742697, 1036514925)
		 + W(10, -1123309658, -1122836256, 998670125, -1112884987)
		 + W(11, -1133144549, 1024140334, 1040183891, 1009223461);
	sum2 =
		W(0, -1166199047, 1029866216, -1143586281, 1016771040) + W(1, -1123676489, -1174784654, 1008667864, -1111274931)
		+ W(2, 1037662319, 1050961303, 1039205717, -1119230230) + W(3, -1137339492, 1026227362, 1052978055, 1073672156)
		+ W(4, 1048063806, -1117826448, -1142224481, -1119220040)
		+ W(5, -1079795268, -1075413433, 1028203090, 1028246046)
		+ W(6, -1152330850, 1031356244, -1109068899, 1029037052)
		+ W(7, -1113725553, -1160612324, 1020018908, -1116678638)
		+ W(8, 1041694498, 1026323256, -1115208722, 1024440460) + W(9, -1116618549, 1026327024, -1122243464, 1021575344)
		+ W(10, 1002430881, -1126523302, 1015962596, -1189397276)
		+ W(11, 1027749752, -1119692611, -1114291930, 1031666290);
	WS(1045979868, -1116118129);
	sum1 = W(0, 1019079208, -1115974509, 1054347779, -1096855346)
		 + W(1, -1118610636, -1120438410, -1124899402, -1114857165)
		 + W(2, 1046800787, -1098629066, 1029706377, 1017939836)
		 + W(3, -1142300538, -1110287856, 1053005207, -1093283235)
		 + W(4, 1028644213, -1131155654, 1011594153, -1099509298)
		 + W(5, 1063937495, -1097005655, 1015974258, -1116499825)
		 + W(6, -1134190949, -1112842949, 1058166871, -1090046872)
		 + W(7, 1040979430, -1119992573, -1132197046, -1107483943)
		 + W(8, 1048177899, -1104885511, -1129150352, -1120133576)
		 + W(9, -1116332853, -1111331677, 1047873428, -1102896822)
		 + W(10, 1028514810, -1118080608, -1135144470, 1018268010)
		 + W(11, 1056893199, -1096686406, -1118433447, -1112688517);
	sum2 =
		W(0, -1132220574, 1034058342, 1008450820, -1132397996) + W(1, -1105536207, 1025437040, -1115410889, -1116250603)
		+ W(2, -1126553639, -1097158033, -1108668742, -1118211898)
		+ W(3, 1017347763, 1029372102, -1105866140, 1060185134)
		+ W(4, -1106418349, 1034066570, -1123931551, -1101916549)
		+ W(5, 1053545154, 1060913993, -1104852271, -1102379864) + W(6, 1027749497, -1104316591, 1054419707, 1033775493)
		+ W(7, -1106993048, -1133416673, -1111299822, 1035393713)
		+ W(8, -1102688086, -1115290197, -1102129692, -1209279719)
		+ W(9, 1025854529, -1107314572, 1036131430, -1106841697)
		+ W(10, -1149271050, -1133826631, -1123916419, 1033668899)
		+ W(11, -1144517652, 990325833, -1114889391, -1129688184);
	WS(1058774455, 1069380246);
	sum1 = W(0, 1032626516, -1114780225, 1045065548, -1111975378)
		 + W(1, 1025328225, -1121960111, -1119757626, 1038823639)
		 + W(2, 1040221656, -1115053555, 1020222778, 1037972921) + W(3, 1033017026, -1098306133, 1021036585, 1050529784)
		 + W(4, -1115391173, -1112361500, 1015522813, 1034533838)
		 + W(5, -1082356272, -1095104409, 1045288819, -1139302935)
		 + W(6, -1128327131, -1103839696, 1057244812, -1133328720)
		 + W(7, -1116298540, 1018289699, 1036888920, -1112718001)
		 + W(8, 1032300191, -1111385431, 1042918995, -1110693582)
		 + W(9, 1032769109, -1126986782, 1043416793, -1124233691)
		 + W(10, 1029500622, 1027375220, -1148588495, 1012070438)
		 + W(11, 1045596067, -1105784401, 1037659662, -1114680879);
	sum2 =
		W(0, -1129789987, 1017265095, -1124616639, -1116091154) + W(1, 1033010488, 1011223606, 1019234847, -1124971531)
		+ W(2, -1114025560, 1022067335, -1114442452, -1117824661)
		+ W(3, -1128803579, 1043137983, -1132476030, -1102585265)
		+ W(4, 1028851843, 1031833634, -1112792165, 1047657371)
		+ W(5, -1114992592, 1052022695, -1115343414, -1136738894)
		+ W(6, 1011967806, 1034970984, -1098689491, 1033604172) + W(7, 1002830796, 988094894, 995307959, 1010908150)
		+ W(8, -1115509379, 1031244615, -1121158047, 1025799099) + W(9, 1018394359, -1107223361, 1006851110, 1032350856)
		+ W(10, -1114060980, -1118870225, -1112288614, 1027672251)
		+ W(11, -1128503755, 1024636851, 1027935499, -1127411999);
	WS(1065814108, -1098421406);
	sum1 =
		W(0, 1030554015, -1104400078, -1097091133, 1050276747) + W(1, 1045406982, -1119880969, -1131576032, 1022555209)
		+ W(2, -1099298246, 1048827844, -1106685173, -1132305362)
		+ W(3, 1020712308, -1130072911, -1094842433, 1057743463)
		+ W(4, 1040093248, -1122176686, 1019668842, -1118231891) + W(5, -1084181571, 1051719984, 1018405640, 1026194364)
		+ W(6, -1178997255, 1041059117, -1098796514, 1058357819)
		+ W(7, -1118903138, 1004376640, 1023970854, -1115494780)
		+ W(8, -1094912271, 1056339293, -1115388505, 1024072531) + W(9, 1011631425, 1035736611, -1090107010, 1051879221)
		+ W(10, -1113309730, 1009992363, 1023862096, -1104560304)
		+ W(11, -1092396649, 1057941592, -1118151090, 1029155252);
	sum2 = W(0, -1104337717, -1085961218, 1065899128, 1055232204)
		 + W(1, -1090132108, 1023963317, 1027104118, 1036459641)
		 + W(2, -1117484391, -1101810882, 1052764213, 1014918739)
		 + W(3, -1114433477, -1092980271, 1062039746, 1049041629)
		 + W(4, -1092098978, 1035158266, -1122138940, -1101372003)
		 + W(5, 1077763913, 1071302707, -1123596042, 1027553578)
		 + W(6, 1048327612, -1098271754, -1088377514, -1084489503)
		 + W(7, 1027311380, -1115760458, 1018207462, -1115566688)
		 + W(8, -1079225367, -1087139921, 1042626102, 1025357528)
		 + W(9, 1015118770, -1101224844, -1106150830, 1036291830)
		 + W(10, -1105072819, 1032466828, 1054676844, -1105452167)
		 + W(11, -1079350028, -1090077553, 1053993534, -1115160051);
	WS(-1083527351, -1082119000);
	sum1 =
		W(0, 1025283773, -1100516229, -1103907601, 1054198743) + W(1, -1139734483, -1115248201, -1132057884, 1028453762)
		+ W(2, -1097545679, 1048327710, -1114897689, 1021031566)
		+ W(3, 1024000280, -1124447466, -1096840081, 1054350616)
		+ W(4, -1109407791, -1115380998, -1117776915, 1027818609)
		+ W(5, -1088298777, 1057412078, -1112548849, -1139302503) + W(6, 994019357, 1030853236, -1090997910, 1059405315)
		+ W(7, -1107996896, 1029448614, -1146975260, -1120656758)
		+ W(8, -1097629690, 1052404744, 1035903152, -1119316016) + W(9, 1021506300, 1023329542, -1102673054, 1051692752)
		+ W(10, -1110888465, 1026998601, 1016847260, -1111423375)
		+ W(11, -1097673748, 1047886934, 1034953432, -1149960989);
	sum2 = W(0, 1023717076, 1034248479, -1110594365, -1113079527) + W(1, 1030579691, 999456782, 996584188, -1120794590)
		 + W(2, 1045315954, -1094151830, -1113958061, 1021526858)
		 + W(3, -1122858228, 1037241484, -1111180041, -1064957365)
		 + W(4, -1106054130, 1018369486, 1005163886, -1124781820)
		 + W(5, -1088752945, -1066051811, -1113733983, 1031457177)
		 + W(6, 1025356913, -1115274025, -1100621689, 1081496726)
		 + W(7, 1049150725, -1112407773, -1118691920, 1026099362) + W(8, 1052626156, 1084041658, 1032870315, 1022214782)
		 + W(9, 1028885707, -1121079636, -1114153113, 1034711477)
		 + W(10, 1042989109, -1108284893, -1114207359, 1010502519)
		 + W(11, 1038857859, -1115018893, -1106741724, 1023330420);
	WS(1031453552, -1108810221);
	sum1 = W(0, -1122540068, -1106571135, -1105389195, 1051764564)
		 + W(1, -1121040220, -1136080166, -1141490084, 1028200745)
		 + W(2, 1023785053, -1104087736, 1027661528, 1023137883)
		 + W(3, -1132153597, -1106394603, 1041720002, 1055195957)
		 + W(4, -1111907522, -1123745267, 1029503994, 1029495448)
		 + W(5, -1089108304, -1096098616, 1031937892, 1034024448)
		 + W(6, -1126370513, -1118016922, 1047749927, 1047204316)
		 + W(7, -1112974291, -1121356173, -1127727061, 1043712879)
		 + W(8, -1092241143, 1028938666, 1025162247, 1028910871) + W(9, -1132743443, 1035505061, 998106632, 1043190746)
		 + W(10, -1152510101, -1121641711, 1024122485, 1041979953)
		 + W(11, -1098695505, 1039644831, 1002213552, 1025100697);
	sum2 =
		W(0, 1032316109, -1117365450, 1028239450, -1106184057) + W(1, 1039709205, -1127567978, -1122133197, 1033736971)
		+ W(2, -1104139010, 1045998485, -1126266788, 1029398164)
		+ W(3, 1021061413, -1117276879, -1090538079, -1087751568)
		+ W(4, 1056538813, -1106793212, -1122180337, 1009179554) + W(5, 1022309577, 1065712953, -1098763613, 1016414657)
		+ W(6, -1115376331, 1034450077, -1125496737, -1100319643)
		+ W(7, 1017435581, 1032114232, -1123716599, -1100616286)
		+ W(8, 1059658657, -1100023584, 1022563437, -1113653553)
		+ W(9, 1008734994, -1130550593, 1014965154, -1115246006)
		+ W(10, 980175008, 1034308617, -1144451812, -1102305630)
		+ W(11, 1053491799, -1107982835, -1103966134, 1020870093);
	WS(1060627383, -1111244297);
	sum1 =
		W(0, -1124372048, 1041984816, -1098607926, 1048999428) + W(1, -1110297584, 1037179887, -1124233202, 1023856878)
		+ W(2, -1097555068, 1050454749, -1119853981, -1124350564)
		+ W(3, -1115057922, 1037843884, -1092180401, 1057072683)
		+ W(4, -1100337986, 1037306108, -1126359548, 1013283185)
		+ W(5, 1035134080, 1037566628, -1117600845, -1180500637)
		+ W(6, -1135390133, -1106598024, 1055432750, -1088869991)
		+ W(7, 1045634091, -1107300041, 999175032, -1109047521) + W(8, 1050330552, -1097603878, 1040799043, -1132131255)
		+ W(9, -1137033126, -1108189319, 1046692025, -1106138715)
		+ W(10, -1129123036, -1126029544, -1120904377, -1127664786)
		+ W(11, 1039361415, -1115643873, 1042168959, -1132202938);
	sum2 =
		W(0, 1027553654, -1105419467, -1141314538, 1051401064) + W(1, 1061407816, -1086513034, -1128416633, 1035214610)
		+ W(2, 992160749, -1098506313, 1048701957, 1023990179) + W(3, -1120268362, -1102082588, 1039698771, 1041311911)
		+ W(4, 1065441970, -1083801169, 1026192109, 1034096310) + W(5, 1028842291, 1044707561, -1108357660, 1027929117)
		+ W(6, 1010812163, -1109637676, -1128101012, 1040877432)
		+ W(7, -1080219839, 1058347144, -1133939099, 1042926233)
		+ W(8, -1110346070, -1107620104, -1089748519, 1054974548)
		+ W(9, 1033310247, -1103557522, 1041169016, 1044637450) + W(10, -1106511250, 1012370076, 1007338654, 1039202903)
		+ W(11, -1150310139, -1101325278, -1094091750, 1054706164);
	WS(1037089208, -1117319375);
	sum1 = W(0, -1117307261, -1127081515, -1090315640, 1055484319)
		 + W(1, 1019801962, -1140393804, -1109658215, 1037266337)
		 + W(2, -1103803502, 1036834781, -1121027890, -1122236391)
		 + W(3, -1104716662, 1045840649, -1108965493, 1059715066)
		 + W(4, -1120952094, 1007521585, -1095157370, 1048384396)
		 + W(5, -1089739445, 1050929076, -1115632913, -1115666157)
		 + W(6, -1115283233, 1042005149, -1098438340, 1059599591)
		 + W(7, -1115851136, 1038771059, -1113906562, 1026318614)
		 + W(8, -1090508193, 1050537744, 1036887192, -1114842616)
		 + W(9, -1127634429, 1035073906, -1096110967, 1039184033)
		 + W(10, -1109698481, 1040209394, -1150522598, -1129730364)
		 + W(11, -1090097982, 1056916499, 994450682, 1023772594);
	sum2 = W(0, -1096641595, 1051991389, -1107135642, -1120991144)
		 + W(1, -1123228782, -1119770484, -1086741683, 1059199896)
		 + W(2, 1044105651, 1025236133, 1032269711, 1020415755) + W(3, -1073585699, 1069582799, 1057042277, -1123268190)
		 + W(4, -1116194138, -1119862022, -1071753138, 1070628328)
		 + W(5, 1065961920, -1098135951, -1144560253, 1033682735)
		 + W(6, -1078410756, 1067042424, 1057516905, 1032298014)
		 + W(7, 1026966393, -1113740644, -1096289506, 1055331220)
		 + W(8, -1098611055, -1106950583, -1155415556, 1022995083)
		 + W(9, -1145261363, 1015112751, 1043415065, 1007537613) + W(10, 992611856, -1144895945, 997353903, 1024293693)
		 + W(11, -1101981251, 1025642916, 1011854094, -1130196038);
	WS(-1089262391, 1050517969);
	sum1 = W(0, -1112721887, 956356282, 1041136081, -1112851037) + W(1, -1118798326, 1033047322, 1040766980, 1032255106)
		 + W(2, -1099047838, -1136806893, 1044101949, -1110781188)
		 + W(3, -1116916633, -1115255965, 1050954387, 1047658201)
		 + W(4, -1099177336, 1022949658, -1109323658, 1053521294)
		 + W(5, -1090918435, -1090498606, 1048722524, 984126311)
		 + W(6, 1043853249, -1109293354, 1049475859, -1111100085)
		 + W(7, 1044026608, -1111349460, -1102481809, 1024224759)
		 + W(8, 1046323061, -1101889105, -1109421665, -1151794972)
		 + W(9, 1025978335, 1036451442, -1129023222, -1112184834)
		 + W(10, 1044252857, -1140137768, -1134508350, 998852344)
		 + W(11, -1126452038, 1037224108, -1113020120, -1119083507);
	sum2 =
		W(0, -1120544497, -1104964203, 1056285145, -1109256198) + W(1, -1107706742, 1033408182, 1042905493, -1097077111)
		+ W(2, -1118581415, 1026029661, 1025674690, -1118988963)
		+ W(3, 1045262161, -1098230931, -1079914544, 1056552993)
		+ W(4, -1103396776, 1021102038, -1104438232, 1057982485)
		+ W(5, 1057557770, -1104081201, 1048351556, -1136298684)
		+ W(6, 1023630957, -1106247773, 1048964135, -1114436673)
		+ W(7, 1018818866, -1112938187, -1122372280, 1011970003) + W(8, 1020547274, 1033190701, -1103728916, 1034200267)
		+ W(9, 1027866949, 1026340389, -1113753028, -1107460568)
		+ W(10, 1046941904, -1117493164, -1121491826, 1016978228)
		+ W(11, 1034078959, 1034442922, -1106194166, -1172844144);
	WS(1055467886, -1126093527);
	sum1 =
		W(0, -1115675946, 1037777366, 1043818615, -1096353162) + W(1, -1150025924, 1035905869, 1039731987, -1126460340)
		+ W(2, -1103677379, 1012406341, 1031349769, -1103947080)
		+ W(3, -1108949528, -1145838757, 1060367897, -1088026493) + W(4, 1034695514, 1034985426, 1014043817, 1049783617)
		+ W(5, -1102044139, -1095567535, 1044285022, -1129716323) + W(6, 1025589529, 991251120, -1109258124, 1051881528)
		+ W(7, 1011738461, -1107675487, -1102050167, 1042727635)
		+ W(8, 1049311757, -1095440907, -1115570324, 1042590402)
		+ W(9, 1035820699, -1123043835, -1116399889, 1032817677)
		+ W(10, 1040150333, -1104125432, -1114599603, 1024161077)
		+ W(11, 1046137806, -1116994158, -1110796915, -1140552997);
	sum2 =
		W(0, -1115939175, -1111463085, 1026058510, 1015189774) + W(1, -1116961377, 1003109525, 1042939513, 1009748958)
		+ W(2, -1101036999, 1048391804, 1019493983, -1128500291)
		+ W(3, -1106984126, -1104760450, 1046231331, -1101164712)
		+ W(4, 1013441892, -1127287103, 1036071940, 1026404786) + W(5, 1060091622, 1059732347, -1113485706, 1036806652)
		+ W(6, -1133154938, 1042746589, -1109115274, -1090421446)
		+ W(7, -1102245299, -1110906499, -1110872047, 1018643239)
		+ W(8, 1042116887, -1092755101, -1104832958, 1042929180) + W(9, 1038271101, 1024219237, -1104891113, 1018386748)
		+ W(10, 1043357489, -1108912836, -1124388167, -1107044825)
		+ W(11, -1137025366, -1112446842, -1123717753, 1034520620);
	WS(1062208951, 1065603754);
	sum1 =
		W(0, 1032466911, 1029341462, 1059167044, -1090134924) + W(1, -1133534677, 987089513, 1012820793, 1027274819)
		+ W(2, 1052950767, -1094303727, 1027990706, 1032570772) + W(3, 1029562264, 997585115, 1057349364, -1085543304)
		+ W(4, 1035990447, -1136982833, 1020285479, 1040141401)
		+ W(5, -1108524682, -1080037127, 1037410929, -1125543221) + W(6, 993753125, 1032063722, 1049874906, -1095616607)
		+ W(7, 1039846496, 1015158861, 1033268866, -1153074023) + W(8, 1048703978, -1112675170, 1023735025, -1145342854)
		+ W(9, -1131051261, 1015103815, 1050186639, -1111683969) + W(10, 1040888889, 1031358985, 1028903855, 1040294280)
		+ W(11, 1053103700, -1091636059, -1118753424, 1022936933);
	sum2 =
		W(0, 1035386648, 1042887622, -1086410483, -1090258329) + W(1, 1060158548, -1113981975, 1023547272, -1099060438)
		+ W(2, 1053956416, -1112148135, 1050315819, -1099847621)
		+ W(3, 1025878508, -1099619867, -1094814183, -1093316197)
		+ W(4, 1046080958, 1046524888, 1026832668, -1099104088) + W(5, 1069089225, 1060781490, -1103190742, -1112424275)
		+ W(6, 1029828312, 1048769602, 1044213412, -1091192206)
		+ W(7, -1105160931, 1051146364, -1098240729, -1121505868)
		+ W(8, 1035342184, -1105713821, -1084784918, 1019461112) + W(9, 1044150428, 1040524432, 1040447750, -1089411157)
		+ W(10, 1058372334, 1028619520, -1103643200, -1115369075)
		+ W(11, 1049544904, 1058550641, -1080579858, 1040133188);
	WS(-1078970012, -1070975772);
	sum1 =
		W(0, 1023443287, -1111813336, -1095332548, 1048282532) + W(1, 1036630695, 999582566, 1008154783, 1034628686)
		+ W(2, -1098370186, 1052880922, -1109395910, -1140663171)
		+ W(3, 1008498119, 1020510238, -1091304148, 1054365856) + W(4, 1031904252, -1128098380, 1032996598, -1119594955)
		+ W(5, -1097391342, 1065196819, -1105409007, 1030941172)
		+ W(6, -1130007992, 1037186855, -1088889903, 1037830473) + W(7, 1022933044, 1003729918, 1026985054, -1129455456)
		+ W(8, -1093273302, 1040256647, 1030320779, -1138808617) + W(9, 1001505728, 1024916861, -1097878954, 1042516535)
		+ W(10, -1131972409, 1018809669, 1027285064, -1118416824)
		+ W(11, -1097408559, 1044458956, 1037289397, 1005961310);
	sum2 =
		W(0, -1114009537, 1019032853, 1024640816, 1029944441) + W(1, -1146945026, -1136399129, 1035366037, -1143037026)
		+ W(2, -1101234014, -1105571142, 1031686749, 1018164069)
		+ W(3, -1111463643, -1122373240, 1068131945, 1044188353)
		+ W(4, -1128619453, -1125359481, -1119334122, 1056620469) + W(5, 1075463933, -1093783941, 1046426762, 999713778)
		+ W(6, -1132366661, -1103744316, -1075751794, 1050699227)
		+ W(7, -1109652943, -1123073190, 1001109746, 1002774938)
		+ W(8, -1072865378, -1098127223, -1131952529, 1019524751)
		+ W(9, 1035022899, -1102405348, 1052446989, 1028903402) + W(10, -1123943246, 983357578, -1112054465, 1046894720)
		+ W(11, 1019415611, -1119380340, 1017598049, 1013611461);
	WS(-1137905088, -1096938393);
	sum1 =
		W(0, -1127951952, -1116133184, -1092624022, 1045295113) + W(1, 1023908704, 1031880695, -1139830244, 1040763803)
		+ W(2, -1104553656, 1046745657, -1103252327, 1040451684)
		+ W(3, -1108742721, 1041221580, -1090149133, 1057147883) + W(4, -1103732914, 1026434167, 1019792636, 1009683312)
		+ W(5, 1044078592, -1112574564, -1127338650, 1007135764)
		+ W(6, 1018370522, -1107181880, 1058802794, -1085568476) + W(7, 1040869579, 1014113348, 1020799581, 1002965001)
		+ W(8, 1043495791, -1103617227, 991652540, -1125537591) + W(9, 1021418002, 1022849180, 1033578226, 1032014262)
		+ W(10, 1013121207, 1016284007, -1148599498, 1039287108)
		+ W(11, -1113073030, 1022418564, 1011288682, -1116579933);
	sum2 = W(0, 1036469548, -1097965159, -1116680345, 1001756270)
		 + W(1, 1032969412, -1131471357, 1017461301, -1101551098)
		 + W(2, -1125992347, -1115644020, -1124365977, 1016380025)
		 + W(3, 1017339130, -1094477168, 1058922542, 1035448965) + W(4, 1040541302, 1001720584, -1095997080, 1035631286)
		 + W(5, -1103956246, -1105032669, -1112710338, -1115585175)
		 + W(6, -1099654066, 1054988432, 1040393300, 1039533461) + W(7, 1017600743, 1001178742, -1105423964, 1047389393)
		 + W(8, 1040203374, -1122662741, -1114085496, 1001141734)
		 + W(9, -1113359567, 1041958533, -1108890296, -1130070269)
		 + W(10, -1134082186, 1010209588, -1131580992, 1043362318)
		 + W(11, 1024609216, 1025676040, 1015920174, -1122393401);
	WS(1017525984, 1039916017);
	sum1 =
		W(0, -1124853567, 1018048624, -1095739637, 1045916039) + W(1, 1035770156, 1019449355, -1147061122, -1127291978)
		+ W(2, -1104996150, 1043181303, 1038596810, -1118699785)
		+ W(3, -1129462517, 1049183858, -1085471393, 1054258797) + W(4, 1048116160, 1018729693, -1119594613, 1032566282)
		+ W(5, -1090223247, 1054999864, 1024906308, -1125493497) + W(6, 999306018, 1036307723, -1104470177, -1108082389)
		+ W(7, 1035021201, -1111613764, -1156505185, -1150114695)
		+ W(8, -1105492077, 1055713893, -1114305018, 1013642059)
		+ W(9, 1012193026, -1116656134, -1109848430, -1134406033)
		+ W(10, 1014226964, -1117195563, 1010192066, -1111959392)
		+ W(11, -1107232129, 1049351719, -1132413284, 990662981);
	sum2 =
		W(0, 1033095635, -1113611213, -1120605005, 1010827478) + W(1, -1096460028, 992544217, -1123818427, 1038354785)
		+ W(2, 1043017802, 1005632845, -1090567932, 1043858115) + W(3, 1023960168, -1136308834, 1016597499, 1067061797)
		+ W(4, -1078682340, 1041505996, -1115456886, 1031365710)
		+ W(5, -1105318511, 1065783254, -1094955795, -1104546945)
		+ W(6, -1130014725, -1121052824, 1032279133, 1033387493)
		+ W(7, -1114814318, -1114466677, -1134763238, 1037262635)
		+ W(8, -1129541437, 1024758296, 994121897, -1115137122) + W(9, 1020936831, -1129095405, 1028982810, -1141733133)
		+ W(10, -1126300988, 1007094454, 1030713030, 1030934712)
		+ W(11, 969324748, 973320358, -1148320949, -1122716507);
	WS(1033221560, 1063777383);
	sum1 =
		W(0, 1019126833, -1112638616, 1057738402, -1088696201) + W(1, 1044063732, -1130166589, 1022703059, -1107233655)
		+ W(2, 1049316970, -1093677291, 1018619290, -1127677637)
		+ W(3, 1034317754, -1107419652, 1057780266, -1091493000)
		+ W(4, 1042363102, -1141893947, -1141147507, 1017313945)
		+ W(5, 1039925560, -1105678958, -1123751101, -1141892011)
		+ W(6, 1023815261, 1030431247, -1101232178, 1054033952) + W(7, -1103422471, 1028589441, -1145478905, 1043218964)
		+ W(8, -1097249286, 1050643572, -1099574259, 1032480102)
		+ W(9, -1139797991, 1030899327, -1105363093, 1039373871)
		+ W(10, -1109462943, 1000558881, 1017044691, 1042038278)
		+ W(11, -1097041200, 1044902925, -1143343447, -1115509735);
	sum2 =
		W(0, -1130982538, -1106875761, 1056618334, 1055977286) + W(1, -1102508839, 1020425242, 1021127838, 1011019608)
		+ W(2, 1055137831, 1058761027, -1115387544, 1013848532) + W(3, 1013698904, 1024572751, 1048771047, -1103617496)
		+ W(4, -1128394642, 1016018634, -1227267307, 1039986653)
		+ W(5, -1073860127, -1072531400, 1043687089, -1112657573)
		+ W(6, -1180063220, -1113103478, -1108123535, 1052255088)
		+ W(7, -1126700500, 1035781641, -1130392938, -1104759550)
		+ W(8, 1059126644, 1063802283, -1109991236, -1125248586) + W(9, -1129014326, 1035543741, 1045481337, 1048895081)
		+ W(10, 1031917163, -1126407949, 1032270489, -1129087757)
		+ W(11, 1042704754, 1016319978, -1121934766, 1030839801);
	WS(-1091503470, -1126838795);
	sum1 = W(0, -1124121237, -1134568843, 1047693172, -1109412515)
		 + W(1, -1129997061, 1024589216, -1113414670, -1126036384)
		 + W(2, 1049117760, -1103447906, 1034526751, -1113770234)
		 + W(3, 1028321829, 1033159265, -1105247938, -1096437464)
		 + W(4, -1143270742, 1036105485, -1111356688, 1037814911)
		 + W(5, 1058889082, -1098797565, 1022658271, -1114645460)
		 + W(6, 1026686479, 1031580097, 1012762455, -1104719461)
		 + W(7, -1109175079, 1023714995, -1121133649, 1040854417)
		 + W(8, -1120516448, -1106636212, 1042645116, -1138248951)
		 + W(9, -1120913068, -1106928812, 1049438209, -1129886751)
		 + W(10, -1104071908, -1132081196, -1126384695, 1027944427)
		 + W(11, 1040171928, -1106734009, 1012750451, -1145462266);
	sum2 =
		W(0, -1121971015, 1025966975, -1127561691, 1032121603) + W(1, -1118316871, -1147835451, -1109269766, 1042653975)
		+ W(2, 1038662008, -1104797770, 1018661176, 1023052754) + W(3, -1096046215, 1058579369, -1095336395, 1041625968)
		+ W(4, -1131103951, -1129857431, -1096349825, 1055073186)
		+ W(5, -1156170871, -1098327149, 1035437895, -1114991229)
		+ W(6, -1104467071, 1043843774, 1054347264, -1090818470) + W(7, 1042639369, 1011784142, -1105457821, 1043492169)
		+ W(8, -1116732629, 1028261711, -1115472379, -1157273063)
		+ W(9, -1114558576, -1138844670, 1043300107, -1117277405)
		+ W(10, -1115061521, 1024244091, -1113812495, 1035958317)
		+ W(11, 1025184897, -1130419167, -1130646919, -1148362739);
	WS(1065968028, 1020949470);
	sum1 = W(0, 1032158503, 1043191673, 1050691771, -1089572661) + W(1, 983294118, 1033006978, 1018701500, 1020082981)
		 + W(2, 1043953282, -1139338281, 1041437600, -1139648989) + W(3, 1028916776, 999481917, 1047062836, -1091936976)
		 + W(4, 1042367115, 1033705422, 1031923218, 1033906881) + W(5, 1032996498, -1081715803, 1040306653, -1132542121)
		 + W(6, -1143490705, -1123072324, 1057457238, -1087112685)
		 + W(7, 1019100064, -1138694873, 1005807263, 1012896153)
		 + W(8, 1057445286, -1088032573, -1123572193, 1033839136)
		 + W(9, 1028568398, 1015001550, 1051530049, -1100585253) + W(10, 1039280729, 1027376729, 1026731038, 1035245559)
		 + W(11, 1057446979, -1095410205, -1104642968, 1015844228);
	sum2 =
		W(0, -1107158830, -1098284578, 1059620359, 1059101624) + W(1, -1080819081, 1041045600, -1114179967, 1050997929)
		+ W(2, -1120628180, -1084072333, 1055292451, 1041809552) + W(3, -1106205598, 1032837846, 1056621385, 1033838752)
		+ W(4, -1084530179, -1150759871, -1112529879, -1138556160)
		+ W(5, 1064698181, 1049137220, -1118657190, 1036987884) + W(6, 1036191348, -1103494095, 1049117565, -1100194061)
		+ W(7, 1035375516, 1040790470, 1045048740, 1033058370) + W(8, -1087565422, -1096659207, 1055648971, -1098721116)
		+ W(9, -1112261511, -1109765233, 1050635491, 1042760064)
		+ W(10, -1101810418, 1028926760, 1045813672, 1040601336)
		+ W(11, -1087363324, -1087988644, 1059720072, -1118399816);
	WS(-1079370588, -1069938997);
	sum1 =
		W(0, -1107111607, 1024046068, 1034755057, -1106911318) + W(1, 1032333322, -1122522177, 1031876694, 1040468568)
		+ W(2, 1048995971, -1106422470, 1043602212, -1133546645)
		+ W(3, -1108546779, -1110778478, 1044693184, -1092550445)
		+ W(4, -1124221431, -1123999146, 1007409349, 1041967908)
		+ W(5, 1056322870, -1089848952, 1044063648, -1129245296) + W(6, -1119937056, 1037532265, 992363881, -1115839591)
		+ W(7, -1137125241, -1121719236, -1110402417, 1027170100)
		+ W(8, -1123931633, -1098485404, 1015794334, 1009488187) + W(9, 1034313646, 1028424065, 1041273350, 1027494176)
		+ W(10, 1038675968, -1146748727, -1115195974, 1030920188)
		+ W(11, 1034999584, -1101830589, 1024639630, -1115284904);
	sum2 =
		W(0, -1116010697, 1044972838, -1107525170, 1025111869) + W(1, -1115770744, 1027404867, 1039856206, -1094195694)
		+ W(2, 1054041965, -1105218154, 1021276689, -1122132060) + W(3, 1025692273, 1041658757, -1095593913, 1047241736)
		+ W(4, -1113081166, 1036997767, 1047723216, -1090167008)
		+ W(5, 1054432792, -1103340827, 1030984707, -1109230755)
		+ W(6, 1054500142, -1087657974, 1048962216, -1105033641) + W(7, 1026520309, 1000189578, 1045538686, -1114739465)
		+ W(8, -1099510609, 1043141319, 1008623973, 949401483) + W(9, 1020883249, -1103808398, 1041852115, -1104502432)
		+ W(10, 1031142833, -1121181330, 1037455508, 1025495534)
		+ W(11, -1112321007, 1020729805, 1034321699, 989367833);
	WS(1051966318, -1113875142);
	sum1 =
		W(0, 1035883793, 1040145278, 1051696565, -1091560996) + W(1, -1133003627, -1126824689, -1111332346, -1135399329)
		+ W(2, 1051177307, -1096861164, -1117751383, 1039745286) + W(3, 1045917727, 1017502534, 1054251573, -1091248610)
		+ W(4, -1178468754, 1020593891, 1006041029, -1096989371)
		+ W(5, 1061428120, -1087158964, -1126263439, 1008594943)
		+ W(6, -1129901007, 1043615094, 1037934795, -1098884432) + W(7, -1106662601, 1037849734, 1042663274, 1025318012)
		+ W(8, 1050890887, -1096301045, 1017933485, 1035118155)
		+ W(9, -1119690564, -1113005508, 1046007992, -1093706893)
		+ W(10, 1038615540, -1114145271, 1014471632, 1043398529)
		+ W(11, 1049249377, -1093100168, -1116546293, 1028529816);
	sum2 =
		W(0, -1120038729, 995641288, 1035481768, 1011267102) + W(1, 1042749492, 1026093812, 1032134121, 1034430176)
		+ W(2, -1099098436, -1099374838, 1055985885, -1113501317) + W(3, -1112337284, 1011533369, 960227969, 1055781369)
		+ W(4, 1067101038, -1095011910, 1014623636, 1032554184) + W(5, -1122840036, 1046041384, 1069533386, -1086401299)
		+ W(6, 1015804972, -1114631943, -1123247827, 1055178264)
		+ W(7, 1065618150, -1079450114, -1111055788, 1037430467)
		+ W(8, -1115890560, -1124103196, 1058921177, -1075689828) + W(9, 1025605092, 1022278663, 1022436109, 1039303021)
		+ W(10, -1106092627, -1082339747, -1118260382, 1020696197)
		+ W(11, 1010081074, -1116158530, -1118372702, -1095588850);
	WS(-1087762743, -1114043214);
	sum1 =
		W(0, 1028903325, 1040067739, 1045936105, -1095653187) + W(1, -1122706133, 1029496147, -1111481047, 981566559)
		+ W(2, 1050679259, -1096161947, 1026181394, -1149217596) + W(3, 1010874850, 1032756947, 1052053924, -1090950614)
		+ W(4, 1034645023, -1132850610, -1117223539, -1130847267)
		+ W(5, 1055533279, -1084280212, 1030922562, -1154701224)
		+ W(6, -1114811697, -1123313460, 1059392176, -1097768267)
		+ W(7, 1030340896, -1113406339, 1027957028, -1113871531) + W(8, 1053658934, 1005713692, -1102292436, 1020850850)
		+ W(9, -1115120063, -1126050567, 1039338221, -1120312930)
		+ W(10, -1107839810, 1017761874, 1025677743, -1113266015)
		+ W(11, 1051823712, -1118568631, -1112577800, -1117302546);
	sum2 =
		W(0, 1001016005, -1150454109, 1001531747, 983352173) + W(1, -1106746798, -1157019725, -1125241033, -1111980552)
		+ W(2, 1031575403, -1103460210, 1036252996, 1023495862) + W(3, 1018218852, 1033028659, 1016765132, -1103428024)
		+ W(4, -1128273041, 1033057508, -1111720092, 1037513337)
		+ W(5, -1085543392, -1076627395, 1046375720, -1112606370)
		+ W(6, 1015413875, -1109924763, 1053354837, 1074369634) + W(7, 1055587240, 1019967806, -1140722987, -1144232926)
		+ W(8, 1054900052, 1051272122, -1094917738, -1107285947)
		+ W(9, -1138333196, -1117260807, 1041131548, -1098379064)
		+ W(10, -1106193524, 1012881631, 1010568725, -1113652225)
		+ W(11, 1045881209, -1098914955, -1098562564, 1031041657);
	WS(-1090517687, -1095444575);
	sum1 =
		W(0, 1025742446, 1032739299, 1054789967, -1095546301) + W(1, 1033023507, 1028563508, -1111454559, -1106175885)
		+ W(2, 1031326631, -1101847659, -1107099097, -1117676152)
		+ W(3, 1040962578, -1110724347, 1052551894, -1090925684) + W(4, 1036045063, 1036888990, 1035513890, -1118213794)
		+ W(5, 1059778428, -1089262225, 1035395209, 1007580971) + W(6, 1025779251, -1103218657, 1045793474, -1096439373)
		+ W(7, -1101529212, 949923192, 1041617005, 1040368314) + W(8, 1051667296, -1099734269, 1050132438, 1037985265)
		+ W(9, -1106922364, -1105137317, 1040121301, -1104705805)
		+ W(10, -1102593253, -1113513373, 1024699903, 1024907982)
		+ W(11, 1052247674, -1097282993, 1016797696, 1026673059);
	sum2 =
		W(0, 1052208474, -1095438834, 1040952518, -1101013864) + W(1, 1045777263, -1125550479, 1035064858, -1104348375)
		+ W(2, -1095663473, 1048824145, -1099869349, -1127115193)
		+ W(3, 1064043431, -1079843968, 1060639651, -1097227129) + W(4, 1049789703, 1024044553, 1055780907, -1084432555)
		+ W(5, 1054823629, -1105218176, -1118379111, 972648308) + W(6, 1048070172, -1106077690, -1098542607, 1048082838)
		+ W(7, -1102784042, 1021849499, 1057138231, -1086965748) + W(8, 1057295667, -1106201667, 1043327775, 1016298873)
		+ W(9, -1100953655, 1048708391, -1095587456, 1042233875)
		+ W(10, -1107731485, -1116706874, 1042120650, -1106942577)
		+ W(11, 1035260440, -1136871967, 1006771796, 1030896448);
	WS(-1115614648, 1042425791);
	sum1 = W(0, -1120207204, -1115327070, -1093340989, 1053481388)
		 + W(1, 1030984860, -1113874973, -1124027509, 1016926292)
		 + W(2, -1096731140, 1053311332, -1116407641, 1010793530)
		 + W(3, -1144413692, 1038910502, -1096554678, 1057006919)
		 + W(4, 1038600290, -1116271283, -1105701711, 1037845356)
		 + W(5, -1085064420, 1049566369, 1043585442, -1114795809)
		 + W(6, 1014568102, 1042236823, -1100005974, 1056376458) + W(7, 1018535375, 992031960, -1120774251, -1105850383)
		 + W(8, -1098496607, 1048579325, -1122768840, -1130485552)
		 + W(9, 1029691462, -1134596907, -1135406214, 1042582346)
		 + W(10, -1120431498, 1029193328, -1119274774, -1117126533)
		 + W(11, -1098152617, 1043887136, 1035562443, -1140222054);
	sum2 = W(0, -1127240204, -1079712608, 1066527571, 1049757184)
		 + W(1, -1122509441, -1120167031, 1024332524, -1082891577)
		 + W(2, 1063276166, 1025750476, -1127423195, 976948665) + W(3, -1145474239, -1081879450, 1065092416, 1045572932)
		 + W(4, -1127801782, -1123809997, -1111478947, 1047818786)
		 + W(5, 1033988518, -1093152038, -1126799575, 1030959654)
		 + W(6, 1029335642, 1066272635, -1081647719, -1129453741) + W(7, 1033523902, 995040830, -1112394176, 1064292926)
		 + W(8, -1085935960, -1107360776, -1109456127, 1026103880)
		 + W(9, 1042612281, 1048742105, -1090025738, 1042389166)
		 + W(10, 1029374360, -1116538748, -1152251822, 1063028070)
		 + W(11, -1088819358, -1095668919, -1163717821, 1033003323);
	WS(1005558656, -1134386388);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[507];

#define CURRENT_PASS 1

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) { temp[pos] = (value); }

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define HOOKED_tex(pos) INPUT_tex(pos)
#define HOOKED_size INPUT_size
#define HOOKED_pt INPUT_pt

void Pass1(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 13 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 507; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 13, y = (uint)id % 13;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (3)) + 0.5, float(group_base.y + y - (2)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[12];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 4];
	samples[1][1] = inp[local_pos + 5];
	samples[1][2] = inp[local_pos + 13];
	samples[1][3] = inp[local_pos + 14];
	samples[2][0] = inp[local_pos + 15];
	samples[2][1] = inp[local_pos + 16];
	samples[2][2] = inp[local_pos + 17];
	samples[2][3] = inp[local_pos + 18];
	samples[3][0] = inp[local_pos + 26];
	samples[3][1] = inp[local_pos + 27];
	samples[3][2] = inp[local_pos + 28];
	samples[3][3] = inp[local_pos + 29];
	samples[4][0] = inp[local_pos + 30];
	samples[4][1] = inp[local_pos + 31];
	samples[4][2] = inp[local_pos + 39];
	samples[4][3] = inp[local_pos + 40];
	samples[5][0] = inp[local_pos + 41];
	samples[5][1] = inp[local_pos + 42];
	samples[5][2] = inp[local_pos + 43];
	samples[5][3] = inp[local_pos + 44];
	samples[6][0] = inp[local_pos + 52];
	samples[6][1] = inp[local_pos + 53];
	samples[6][2] = inp[local_pos + 54];
	samples[6][3] = inp[local_pos + 55];
	samples[7][0] = inp[local_pos + 56];
	samples[7][1] = inp[local_pos + 57];
	samples[7][2] = inp[local_pos + 65];
	samples[7][3] = inp[local_pos + 66];
	samples[8][0] = inp[local_pos + 67];
	samples[8][1] = inp[local_pos + 68];
	samples[8][2] = inp[local_pos + 69];
	samples[8][3] = inp[local_pos + 70];
	samples[9][0] = inp[local_pos + 78];
	samples[9][1] = inp[local_pos + 79];
	samples[9][2] = inp[local_pos + 80];
	samples[9][3] = inp[local_pos + 81];
	samples[10][0] = inp[local_pos + 82];
	samples[10][1] = inp[local_pos + 83];
	samples[10][2] = inp[local_pos + 91];
	samples[10][3] = inp[local_pos + 92];
	samples[11][0] = inp[local_pos + 93];
	samples[11][1] = inp[local_pos + 94];
	samples[11][2] = inp[local_pos + 95];
	samples[11][3] = inp[local_pos + 96];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 41];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * ivec2(1, 2);
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2) + ivec2(0, 1), ret);
}
//!PASS 2
//!DESC NNEDI3 (double_x, nns128, win8x6)
//!IN INPUT, temp
//!OUT OUTPUT
//!BLOCK_SIZE 64, 8
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[12]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 12; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 48.0;
	float mstd1 = sumsq / 48.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 = W(0, -1138315554, -1151849881, -1130100551, -1139428474)
		 + W(1, -1115186183, 1024054031, -1123693866, -1134121575)
		 + W(2, 1017020226, -1120184142, -1113913797, -1137890034)
		 + W(3, -1105019328, 1030136834, -1119041199, 1009291685) + W(4, 1054031418, 1052033568, 1057266643, 1050615732)
		 + W(5, 1060278709, 1051842684, 1049323809, 1050624038)
		 + W(6, -1098719688, -1094289569, -1094215666, -1084764287)
		 + W(7, -1093503073, -1122358095, -1104408867, -1101060057)
		 + W(8, -1110814528, 1026313661, -1136459684, 1037955767)
		 + W(9, -1125342359, -1118592012, -1141919603, -1117980571)
		 + W(10, -1144117236, 1029415347, -1122295896, -1158862002)
		 + W(11, -1115484761, 1027215228, -1148196514, -1131405947);
	sum2 =
		W(0, 1011608699, 1021515189, -1133688887, -1109181339) + W(1, 1032724543, -1120491130, 997621755, 1020760181)
		+ W(2, -1112090344, 1032910614, -1111235489, 1050015381)
		+ W(3, 1041065097, -1106592726, -1112521193, 1032648390) + W(4, 1035039469, -1112298310, 1068933685, 1079505355)
		+ W(5, -1082386736, -1067816278, -1094139890, -1123411157)
		+ W(6, 1018826733, -1103038162, 1035541017, -1096237270)
		+ W(7, 1051919390, -1101133158, -1120644044, 1029904493) + W(8, -1130070276, 1030536589, 1002846254, 1047170650)
		+ W(9, 1012706615, -1108914015, 1011888367, -1115273665)
		+ W(10, -1126912052, 1027816837, -1119314146, -1132054353)
		+ W(11, 1004049262, 1017068057, 1020965593, 1017829425);
	WS(1038714296, 1044827315);
	sum1 = W(0, 1008773074, 1000000044, -1125197471, -1155069097)
		 + W(1, -1128457331, -1147450330, -1142834606, -1131672268)
		 + W(2, -1137155124, -1139148008, -1110040196, -1114984084)
		 + W(3, -1117135435, 1038803511, -1110360429, 1046900069) + W(4, 1058392080, 1051571686, 1058043460, 1059856605)
		 + W(5, 1053821137, 1050763009, 1046500044, 1049636107)
		 + W(6, -1100726684, -1106613964, -1093356205, -1087655353)
		 + W(7, -1093486798, -1088451200, -1109846237, -1093848946)
		 + W(8, -1097060854, 1034039029, -1112523275, -1137125990)
		 + W(9, -1134047198, -1131894321, 1021083253, -1108292068)
		 + W(10, 1034472653, -1136883834, 1033872898, -1122772178)
		 + W(11, -1125370043, 1027534056, -1126166913, 1020331091);
	sum2 =
		W(0, -1123255245, 982126402, 1020504368, 1036976721) + W(1, -1113656730, -1157600449, -1129338356, 1032297389)
		+ W(2, -1116671780, -1111301077, 1011773496, -1102830064) + W(3, 1031803093, 1045043848, 1026389126, 1022832316)
		+ W(4, 1046375724, 1053914306, 1013495848, -1106352300)
		+ W(5, -1103067006, -1094946683, 1036977493, -1098417421) + W(6, 1061532718, 1066141278, 1064263836, 1055449836)
		+ W(7, -1076699072, -1085904680, -1099822488, -1092845936)
		+ W(8, 998291536, 1041257894, 1023442398, -1101238723) + W(9, -1103198508, 1048924521, -1109968297, 1053328593)
		+ W(10, -1094346395, -1108898352, 1023084860, 1037821947)
		+ W(11, -1123876988, 1041381351, -1109391389, 1023206676);
	WS(-1087781687, -1134030789);
	sum1 = W(0, 1028179002, 1037437606, -1106850597, 1040743460)
		 + W(1, -1123964671, -1122790273, 1036030878, 1027799500)
		 + W(2, -1113846601, -1129634048, 1045066941, -1108576055)
		 + W(3, 1030205873, -1117192467, 1027547489, -1110675758)
		 + W(4, -1090428884, -1098510574, -1095161561, -1094444002)
		 + W(5, -1095134094, -1098192922, -1101066654, -1095206484)
		 + W(6, 1056064759, 1049319247, 1048732210, 1054487227) + W(7, 1044300425, 1055338520, 1034894336, 1053272331)
		 + W(8, -1116809458, -1105760812, 1007721067, 1050640540)
		 + W(9, 1040160031, -1106372902, -1109703824, -1138309939)
		 + W(10, -1123784128, 1016685513, -1105661778, 1048222150)
		 + W(11, -1110013906, 1033480951, -1112122819, 1033810456);
	sum2 = W(0, 1023697539, -1134698244, 1018187921, 1024534132)
		 + W(1, -1145140771, -1142625275, -1141296989, 1007645751)
		 + W(2, -1119401943, 1013558867, -1119659280, 1038666215)
		 + W(3, -1120396841, 1035154544, -1131590401, 1021197862)
		 + W(4, 1010071413, -1112961274, 1019163177, -1097296472)
		 + W(5, 1033089456, -1105855221, -1156341795, -1120357988)
		 + W(6, 1025267901, 1033970227, 1048742053, 1082848284) + W(7, 1060700209, -1115995862, 1035612397, -1123714371)
		 + W(8, 988018625, -1116217767, -1103390691, -1064739318)
		 + W(9, -1086947071, 1042818438, -1109434149, 1029308077)
		 + W(10, -1122026299, 1005039212, -1115786374, 1042066180)
		 + W(11, 1017803659, -1115628759, -1150181080, 1011442501);
	WS(1060770743, -1108197568);
	sum1 = W(0, 1016886775, -1160198547, 1015246637, -1139668038)
		 + W(1, 1034731136, 1019206597, -1123983389, -1115649126) + W(2, 1029069588, 1038531041, 1041390628, 1022402527)
		 + W(3, -1103954605, -1112398730, -1117714338, 1039312430)
		 + W(4, -1095627128, -1096395039, -1086831062, 1057717017)
		 + W(5, 1056693263, 1053908426, 1043180606, 1038174992) + W(6, 1046558478, 1048524254, 1058409012, 1050284011)
		 + W(7, -1083755424, -1092005688, -1101033824, -1131529899)
		 + W(8, -1146067869, -1097778094, -1098986327, -1110221104)
		 + W(9, 1042951984, 1037994808, 1025216609, 1000398449) + W(10, 1009558662, 1033422755, 1033638277, 1029754521)
		 + W(11, -1119102757, -1130383710, -1114155844, -1129441697);
	sum2 = W(0, -1104188915, 1026676440, -1122447814, 1024214572)
		 + W(1, 1036156927, 1039804037, -1140508998, 1023379743)
		 + W(2, 1041755532, -1099902739, 1020538503, -1096783078)
		 + W(3, -1094671115, -1096595186, -1108992818, 1023478108)
		 + W(4, 1039915367, 1048552390, -1105911641, 1068731351)
		 + W(5, -1096057439, -1091471401, 1033306823, -1096750685)
		 + W(6, 1028942726, -1105392496, -1106738713, 1066518668)
		 + W(7, -1122053390, -1123632409, 1032650381, -1109607147)
		 + W(8, 1030445090, -1104867005, -1106850996, -1126700225)
		 + W(9, 1025639958, -1113480650, -1115144981, 1031767054)
		 + W(10, -1104654601, 1033528857, 989961401, -1133955554)
		 + W(11, -1153726297, 1032072745, -1128986161, 1023561226);
	WS(-1105940700, 1068951582);
	sum1 =
		W(0, 1000087558, 1035444041, 1016288952, 1033866603) + W(1, 1023501510, 1030903912, -1121882082, -1139243976)
		+ W(2, -1126610867, -1119652358, -1105308514, 1025089333)
		+ W(3, -1101500686, 1024487034, 1036868116, -1137536646) + W(4, 1040363554, 1048983991, -1129232537, 1043404182)
		+ W(5, 1050470779, 1032787659, 1042688239, 1051055933) + W(6, -1103531583, -1095183320, 1035540828, -1091977028)
		+ W(7, -1098956255, 1016827662, -1107477027, -1111432589)
		+ W(8, -1126498674, 1041424541, -1116171169, -1108874003)
		+ W(9, -1107291841, -1115835365, 1038297635, -1101253029)
		+ W(10, 1033586531, 1011542187, 1018737568, 1021129404) + W(11, 1033496245, 1023594100, 1015384473, 1034920923);
	sum2 = W(0, -1123978268, -1122059260, -1123592170, 1036141312)
		 + W(1, -1111710804, -1127043568, 1040694361, -1120657957)
		 + W(2, -1102554320, 1044079872, -1093658955, -1094337979)
		 + W(3, 1045282706, -1139302445, 983065168, -1105233712) + W(4, 1043643239, -1111536011, 1042723115, 1067907418)
		 + W(5, -1118927202, 1035940631, 1016057395, 1027935282) + W(6, 1026913323, 1056944699, -1093217948, 1064662115)
		 + W(7, -1091166584, -1092135065, 1041761864, -1104693620)
		 + W(8, 1031431539, 1037617295, -1103624535, -1090550375)
		 + W(9, -1119161360, -1112133073, 1014979737, -1106943303)
		 + W(10, -1112242992, 1005844362, -1101249260, 1042545272)
		 + W(11, -1111294278, 1025042022, 1026789959, -1114223884);
	WS(1061289911, -1074625008);
	sum1 =
		W(0, -1118986355, 1042690449, 1022020251, 1032007652) + W(1, 1040686510, -1108674269, -1123719572, 1033202498)
		+ W(2, 1035013222, -1110099132, 1048074309, -1101544522)
		+ W(3, -1102744618, 1043103143, -1099009366, 1038471242) + W(4, 1058027688, 1047068971, 1036127926, 1058005973)
		+ W(5, 1048070472, 1057593649, 1043345580, 1055515931) + W(6, -1087592511, 1013931199, -1088015817, -1099315493)
		+ W(7, -1091144488, -1088950448, 1033106140, -1090129177)
		+ W(8, -1107213995, 1008030621, 1042727509, -1093058723)
		+ W(9, 1042938237, 1002612916, -1110941900, -1113377491)
		+ W(10, 1048036382, -1106703359, 1044183504, 1029001296)
		+ W(11, -1106075703, 1048869669, -1107279296, 1042195418);
	sum2 =
		W(0, 1034897388, -1104469346, -1104312342, 1033162274) + W(1, 1001538203, -1119055011, 1036889309, -1122390571)
		+ W(2, 1047600068, 1074182899, 1080728354, 1077196082) + W(3, 1039546617, -1121476275, -1113609974, -1124909535)
		+ W(4, -1092005485, -1074957140, -1067981267, -1071410100)
		+ W(5, -1101189403, 1042351425, -1113906708, 1037135096)
		+ W(6, 1032211690, -1124075063, -1100127529, -1093339345) + W(7, 1036352485, 1008083901, 1032631324, 1002134635)
		+ W(8, 1046053217, 981988140, 1036844207, 1030504779) + W(9, 1025223671, -1101604075, 1034478190, -1113103836)
		+ W(10, -1111289614, 990179414, -1123826485, -1109598746)
		+ W(11, 1036519612, -1146561467, 1017678167, -1132393287);
	WS(-1106894556, 1030995446);
	sum1 = W(0, 1025589699, -1123387156, 1028556318, -1139656804)
		 + W(1, 980812294, -1128131860, -1137342353, 1017797929)
		 + W(2, 1033805806, 1025291593, -1127599047, -1105750398)
		 + W(3, -1104274718, -1117867836, 1018769427, -1114245906)
		 + W(4, 1034528997, 1054610112, 1039781117, 1065523109) + W(5, 1054896451, 1045458038, 1040199808, 1047692618)
		 + W(6, -1098701288, -1096105008, -1091536615, -1090836572)
		 + W(7, -1097995702, 1039238949, -1110811780, 1001735913)
		 + W(8, -1119393787, 1037953340, -1120434724, -1103173850)
		 + W(9, -1111869411, -1104116474, -1129786002, -1106977725)
		 + W(10, 1027839817, -1123546765, 1027349522, 1022652480)
		 + W(11, -1135075504, -1125284461, -1152753902, -1131064048);
	sum2 =
		W(0, 1030581609, -1110091164, 1024868796, -1124528958) + W(1, -1175372351, 1022252519, -1123141270, -1123316826)
		+ W(2, -1096073996, -1132437108, 1051933742, 1042406776)
		+ W(3, -1117745155, -1117509823, -1110977956, 1029056744)
		+ W(4, -1104952058, 1031847146, 1077840619, -1071401906)
		+ W(5, -1108532142, -1107574374, 1034777920, 1034383482) + W(6, 1036583621, 1040176294, 1056082302, -1080138625)
		+ W(7, 1039833458, 1041695761, -1119756119, 977900031) + W(8, 1006888722, -1120421639, -1114613612, 1012484405)
		+ W(9, 1044393926, -1112420268, 1028893644, 1027961212)
		+ W(10, 1023568502, -1124563800, 1026684617, -1114165836)
		+ W(11, -1139194300, 1023135287, -1122696127, 1034470668);
	WS(-1094248046, 1034739186);
	sum1 = W(0, -1121641997, -1148807918, -1119896808, -1118546659)
		 + W(1, -1117202258, 1027770003, -1121511758, -1114510703)
		 + W(2, 1043421097, -1114752489, 1040593858, 1043491504) + W(3, 1033892386, 1035924243, 1032482905, 1031829015)
		 + W(4, -1090462057, -1097763033, -1089339622, -1089142502)
		 + W(5, -1089696734, -1098379668, -1096843609, -1089945727)
		 + W(6, 1057979744, 1045790578, 1054873978, 1054724534) + W(7, 1056858543, 1046524773, 1049846778, 1056083605)
		 + W(8, 1042504017, -1105205440, 1029920941, -1114903193)
		 + W(9, -1102740772, 1042806872, -1103488653, 1031492831)
		 + W(10, 1019430629, -1115505835, 1008619887, 1038945077)
		 + W(11, 1025474934, -1148381698, 1017864241, 1029503362);
	sum2 = W(0, 1032629114, 1024571549, -1123705993, -1120833813)
		 + W(1, 1031286487, -1113289848, 1033808184, 1035572024)
		 + W(2, -1111104155, 1022922994, 1036988882, -1104365480)
		 + W(3, 1038064580, -1119955010, 1018164430, -1144675449)
		 + W(4, -1111175727, 1047799465, -1121840686, -1098359864)
		 + W(5, 1008715668, -1115327032, 1042276675, -1114533548) + W(6, 1069180600, 1065968459, 1066031139, 1064223912)
		 + W(7, 1062275672, 1060225053, 1060364945, 1057151625) + W(8, -1092657949, -1106624299, 1026540087, 1044325339)
		 + W(9, 1048614780, -1117772151, -1105153406, -1103516228)
		 + W(10, -1081878912, -1085703668, -1080884055, -1079207816)
		 + W(11, -1083548865, -1085294305, -1090372695, -1100806033);
	WS(-1095016302, 1049780935);
	sum1 =
		W(0, -1140214663, 1008440267, -1137823987, 1035221148) + W(1, 1007510683, 1029727784, -1142229143, 1025812851)
		+ W(2, 1050711943, -1110792724, 1036012635, -1104496021)
		+ W(3, -1145733059, -1109552317, -1115585956, -1142816275)
		+ W(4, 1044505338, 1051364259, 1051977632, 1058946996) + W(5, 1056967247, 1057598839, 1050931556, 1058283380)
		+ W(6, -1092537964, -1101785640, -1091742968, -1090015552)
		+ W(7, -1090979415, -1088424934, -1096995861, -1095074239)
		+ W(8, -1110639373, 1026645590, -1130979716, -1106527650)
		+ W(9, -1146016549, 1015167915, 1009720606, -1105047309) + W(10, 1025322472, 1024485132, 1018037601, 1032762847)
		+ W(11, 1010918699, 1027572437, -1127055707, 1011865435);
	sum2 =
		W(0, 1040969494, 1036141535, -1136101349, 1015318832) + W(1, -1112220931, -1111621316, 1042180910, -1115487487)
		+ W(2, -1087779211, 1033693595, -1096934819, 1042126031) + W(3, 1036377831, 1046621966, -1129542795, 1052735842)
		+ W(4, 1056604611, -1095617275, 1057610078, 1059711341)
		+ W(5, -1098744628, -1088974739, -1112239718, -1089093989)
		+ W(6, 1059045592, 1037950807, 1059474718, 1079595174) + W(7, 1065421414, -1079659864, -1077353318, -1076641223)
		+ W(8, -1085730308, 1051875566, -1104408796, 1011257519)
		+ W(9, -1102027272, -1097874228, -1123714793, -1089345613)
		+ W(10, 1035668628, -1110274633, -1106464684, -1106179801)
		+ W(11, 1035078820, 1045400280, -1122902412, 1057832501);
	WS(-1081166556, -1096725839);
	sum1 =
		W(0, -1146977357, -1130642485, 1032268722, -1111253552) + W(1, 1024786511, 1021187873, -1115200917, 1021141494)
		+ W(2, -1114510289, -1119269199, 1038356317, -1095921640)
		+ W(3, 1038758688, -1102108905, -1117501552, 1024092394) + W(4, 1050030946, 1045921361, 1039889859, 1057711094)
		+ W(5, 1053078718, 1045805544, 1042557010, 1052716334) + W(6, -1102646113, -1098664649, 1027769520, -1089074675)
		+ W(7, -1098156409, -1106011300, -1102728052, -1107570834)
		+ W(8, -1113153825, 992772066, 1041426283, -1107182252)
		+ W(9, 1043642083, -1131324475, -1148235644, -1153593794)
		+ W(10, -1114582784, 1022415207, 1025422681, -1098886685)
		+ W(11, 1036466489, -1129952762, -1133449046, 1012650491);
	sum2 =
		W(0, -1154116071, -1120032365, 1033357218, -1132933754) + W(1, -1165588207, 1029048100, -1115144648, 1020455541)
		+ W(2, 1032309947, 1017679770, -1118521489, 1020082264) + W(3, -1122971142, 1015972752, 1021714009, -1134334294)
		+ W(4, -1123962703, 1025906643, 1007375557, -1114291801)
		+ W(5, -1114360955, 1031540723, -1136421576, 1014310369)
		+ W(6, -1133231158, -1134787122, -1096414395, 1064675801)
		+ W(7, -1097709607, 1040110606, -1121524587, -1119507729)
		+ W(8, -1128886461, -1108727038, 1020492423, -1080568363)
		+ W(9, -1108104258, -1112615988, -1111963053, 1028363593)
		+ W(10, 1035599863, 1039832482, 1035524914, 1059399952)
		+ W(11, 1040378905, 1024318985, 1036458899, -1122706022);
	WS(1058284215, -1100256461);
	sum1 = W(0, -1136333391, 977549609, 1023954799, 1032458293) + W(1, -1131855793, -1132003829, 1014651348, 1007647892)
		 + W(2, 1042064203, 1017583666, -1103445177, 1003134525) + W(3, 1030077610, 1044505715, 1034368605, -1109681210)
		 + W(4, 1048792691, 1037147366, 1061193316, 1055543997)
		 + W(5, -1089393894, -1102389770, -1126089633, 1030932473)
		 + W(6, -1108621703, -1098054746, -1084539629, -1105743629)
		 + W(7, 1061657482, -1111653453, 1032593324, -1134741175)
		 + W(8, -1107171315, 1036542212, 1001865121, -1113492892)
		 + W(9, -1095280499, 1000070140, -1124982771, 1012906393)
		 + W(10, 1009105958, -1118222526, 1005641493, 1001049989)
		 + W(11, -1141919717, 1031530183, 957669220, -1123915241);
	sum2 = W(0, 1025749667, -1112523495, 1034709000, 1021531102)
		 + W(1, -1129693762, 1006685387, -1119027428, -1106459716)
		 + W(2, 1018718450, 1033569638, -1099586256, -1096388774)
		 + W(3, -1109846828, -1112379914, 1008781387, 1045287677)
		 + W(4, -1104497483, -1111912018, -1087345020, 1061077725)
		 + W(5, 1049253485, -1117456886, 1038233914, -1135366091)
		 + W(6, -1109821356, 1026676021, -1092985416, 1065372034)
		 + W(7, 1048850468, -1106255761, 1013968523, -1138431127)
		 + W(8, 1032840840, -1114119398, 1018773778, -1129773592)
		 + W(9, -1101038787, 1043058397, -1113511705, 1037121278)
		 + W(10, 1009497507, 1017944258, 1033599708, -1109427758)
		 + W(11, 1029395381, -1106769492, 1020319838, -1113647178);
	WS(1048665454, 1062854025);
	sum1 =
		W(0, 1004974300, 1032679478, 1041394910, 1026224498) + W(1, -1128844481, -1137588617, -1115578718, -1128306202)
		+ W(2, -1140401360, -1099989608, -1108003052, -1103518244)
		+ W(3, 1044968661, 1040271757, 1031459778, -1114933822) + W(4, 1040482153, 1038119146, 1050737065, 1054936910)
		+ W(5, -1084409495, -1099872844, -1107158134, 1038726400)
		+ W(6, -1107105990, -1094089019, -1084721726, 1054691719) + W(7, 1057517320, 1035416977, 1033669936, 1032390235)
		+ W(8, -1113947114, 1043046180, 1044891839, 1025601857) + W(9, 1022006333, 1017193535, 1025595521, 1023203548)
		+ W(10, 1004764812, -1132148363, 1022372181, -1113753404)
		+ W(11, 1033354242, -1131287582, -1112957780, 1012659010);
	sum2 =
		W(0, -1120028750, -1137390044, 1031876652, -1112211314) + W(1, 1041988042, -1105672202, 1032816067, -1122489809)
		+ W(2, -1116919239, 1034599590, -1110926857, 1037510574)
		+ W(3, -1091078601, 1052042083, -1102117757, 1043447553)
		+ W(4, 1026537129, -1105861815, -1114848017, 1054207178)
		+ W(5, 1059021754, -1104155840, 1047757772, -1115066040)
		+ W(6, 1032246372, -1095438265, -1093245727, 1062401065)
		+ W(7, -1115099719, -1100501338, -1112097107, -1102195598)
		+ W(8, 1047938064, 1022176478, -1093210017, -1118385188) + W(9, -1104427658, 1013766280, 1027075631, 1027463789)
		+ W(10, -1102851233, -1129352893, 1046245506, -1106645860)
		+ W(11, 1043294706, 1016480352, -1113418727, 1030659187);
	WS(1046819548, -1112403026);
	sum1 =
		W(0, 1043575156, -1118831073, 1028002987, 1025124390) + W(1, 1023377962, 1034880715, -1125071779, -1144027915)
		+ W(2, -1096536373, 1040283909, 1049135339, -1115136450)
		+ W(3, -1127238030, 1042113706, -1124049974, 1045174012) + W(4, 1028458839, 1047473762, -1083606160, 1052252597)
		+ W(5, 1054448495, -1106041242, 1031800519, -1138801364) + W(6, 1042563315, -1108795847, 1040849058, 1045384892)
		+ W(7, -1081137782, 1040945110, 1026387221, -1122981994)
		+ W(8, -1147631681, -1115473730, 1015994849, -1102431101)
		+ W(9, 1046487189, 1026652836, -1096718751, 1030118403)
		+ W(10, -1134760216, 1037371629, 1036578576, -1147407721)
		+ W(11, 1029054905, -1113175874, 1032040846, -1121286085);
	sum2 =
		W(0, -1116472244, 1025044698, -1123391126, 1003069456) + W(1, -1129719684, -1110477199, 1023677849, 989635105)
		+ W(2, 1036928405, -1122373594, -1111538981, -1111848203)
		+ W(3, 1027481573, 990411281, -1136822924, -1136314996) + W(4, 1035706238, 1040619830, 1046111644, 1044878634)
		+ W(5, 1017226015, 1030695866, -1114454329, 1007553654) + W(6, -1121318128, -1104861162, 1038958235, 1050016986)
		+ W(7, 1040124875, -1116142138, -1113301330, -1112411005)
		+ W(8, -1114868876, 1034962287, 1034772140, -1113883437)
		+ W(9, -1114732111, -1102609372, 1029458562, -1109652887)
		+ W(10, 1033058067, -1110745183, -1130393948, 1005454840)
		+ W(11, -1105702279, 1029172520, -1112847239, -1150621057);
	WS(1054158702, -1098491196);
	sum1 = W(0, -1129450472, 983582877, -1121209423, -1121678922)
		 + W(1, 1031290553, -1119715259, 1032360987, -1115265987)
		 + W(2, -1119237644, 1026235385, 1037197666, 1031464488)
		 + W(3, -1099798307, -1102325483, -1107157175, 1036899466)
		 + W(4, -1101713087, -1098493798, -1083899440, -1103778771)
		 + W(5, 1057005120, 1046824098, 1037130136, 1011053924) + W(6, 1033589815, 1048228620, 1060260620, 1056756834)
		 + W(7, -1093716116, -1102446942, -1111054172, -1132207900)
		 + W(8, 1034513750, -1123359016, -1103037013, -1122982297) + W(9, 1049393023, 1028221304, 1041637742, 992781927)
		 + W(10, 1023147092, -1173092218, 1035595873, 1020058530)
		 + W(11, -1117980637, -1124996559, -1115548960, 995105423);
	sum2 =
		W(0, 1022318336, -1115650269, 1023537352, -1109544964) + W(1, -1104797311, 1016525394, 1034835508, 1033208955)
		+ W(2, 1013555797, 1016103802, 1041650416, 1052577828)
		+ W(3, -1105646271, -1089308865, -1093424353, -1123233885)
		+ W(4, -1107715656, -1119261847, 1043696631, -1093802466)
		+ W(5, 1070961498, -1101461419, -1129647390, -1103638866)
		+ W(6, 1023151297, -1114491928, 1042399799, -1088107917) + W(7, 1046742027, 1041655381, 1027817568, -1123805293)
		+ W(8, 1033284778, -1130031974, -1108010060, 1027122983) + W(9, -1123089325, 1023301191, 1010592861, 1027104379)
		+ W(10, -1133592549, -1142562170, -1132296546, 1012286637)
		+ W(11, -1129646858, -1123666701, 1020078242, 1017326494);
	WS(-1098756718, 1025257793);
	sum1 = W(0, -1170432841, 992949730, 1001883457, 1015181254) + W(1, -1113865961, 1025052052, -1142935155, 1028407518)
		 + W(2, 1023803110, -1138344011, 1026014126, -1121590721)
		 + W(3, -1118191492, -1131017933, 992699702, -1125677724)
		 + W(4, -1090131561, -1107275570, -1096556254, -1096688477)
		 + W(5, -1094031636, -1105028073, -1106433523, -1094260670)
		 + W(6, 1057699745, 1040420307, 1054103406, 1044394251) + W(7, 1054646511, 1053702338, 1018441892, 1056434389)
		 + W(8, -1119694405, -1117188674, -1115724526, 1029634610)
		 + W(9, -1140440641, -1105231572, 1028218227, -1115106656)
		 + W(10, 1012926412, -1123369303, -1127845816, 1035099253)
		 + W(11, -1114907963, 1041135600, -1110839852, 1033590433);
	sum2 =
		W(0, -1113857499, 1017397942, 994248048, -1107301692) + W(1, -1114604929, -1099171315, -1128156929, -1105825924)
		+ W(2, 1035336978, 977119295, 1058657166, 1082282453) + W(3, 1081592322, 1057428850, 1029982493, 1050573738)
		+ W(4, 1003212424, -1169985407, -1086726098, -1067974855)
		+ W(5, -1065596346, -1101606461, -1114706375, -1113547007)
		+ W(6, 1016146718, -1139136560, 1029663775, -1088717558)
		+ W(7, 1032721198, -1109521003, 1035913834, -1115579388)
		+ W(8, -1124908942, -1127032094, -1128987279, 1045162011)
		+ W(9, -1132432620, 1001306728, -1127893472, 1022139202) + W(10, 1007728744, 1015257206, -1139895388, 989071903)
		+ W(11, -1115423533, 1026551071, -1124574009, 999865176);
	WS(1057488311, 1032489366);
	sum1 = W(0, 998859696, -1126361486, 1028022609, -1139957040)
		 + W(1, 1015295094, -1122345661, -1126668079, -1129886863)
		 + W(2, -1107316871, 1034785118, -1114064513, 1048520075)
		 + W(3, -1112481238, -1154023155, -1133481329, -1108825451)
		 + W(4, -1130375162, -1098594694, -1105098668, -1099155379)
		 + W(5, -1109749909, -1112014022, -1114013594, -1116334683)
		 + W(6, 1045821468, 1031878554, 1057263754, -1127500588) + W(7, 1049599048, 1025402492, 1034877470, 1046739556)
		 + W(8, 1009430200, -1137835434, -1104540630, 1033795278)
		 + W(9, -1105774078, 1046311438, -1109189150, -1119327433)
		 + W(10, -1127874328, -1124885440, -1121514949, 1026343507)
		 + W(11, 1007199100, -1119007402, 1026086402, -1138298796);
	sum2 = W(0, -1131728975, 1035973522, 1044679054, 1057647035) + W(1, 1029801795, -1120435503, 1040526136, 1001204178)
		 + W(2, 1036764889, -1115068573, -1096357732, -1081650015)
		 + W(3, 1008652352, 1020148594, 1019038058, -1125968836)
		 + W(4, -1111227173, 1022919798, -1128128484, 1064645808)
		 + W(5, -1094730608, 1034184152, -1110501324, -1141167471)
		 + W(6, -1128881737, 1043114423, -1098903856, -1105946360)
		 + W(7, -1121257166, -1122224678, 1033879187, -1125677560) + W(8, 1037242625, 990889655, 1034691185, 997618289)
		 + W(9, -1119761613, -1123774451, 1017411026, 1017460301)
		 + W(10, -1122740141, -1130091274, -1126568042, 1036162942)
		 + W(11, -1145265129, 1016517254, 1025838030, -1121815648);
	WS(1059796919, -1120566973);
	sum1 =
		W(0, -1128913552, -1121363289, -1114223569, -1170089852) + W(1, 1032486790, 1007200827, 1031548233, 1025411673)
		+ W(2, -1112300176, 1042197939, 1034918960, 1019526904)
		+ W(3, -1097594444, -1109654209, -1121876014, -1114258964)
		+ W(4, -1105877684, -1097436160, -1084964393, 1000497399)
		+ W(5, 1058860547, 1031553246, 1038828418, -1106885131) + W(6, 1051198984, 1044389601, 1058261945, 1057668526)
		+ W(7, -1083919657, -1093305914, -1113158982, 1024357474)
		+ W(8, 1031319296, -1156941767, -1115209492, 1032065846) + W(9, 1045243539, 1041280427, 1014469175, -1128319413)
		+ W(10, -1128535084, 1024751122, 1025460631, 1032881746) + W(11, 1010383044, 986576750, 1034628234, 1012703988);
	sum2 =
		W(0, -1143612781, 1024653023, 1031492195, -1118229715) + W(1, 1037055061, -1103747903, 1027878177, -1120661119)
		+ W(2, 1030657759, -1114346787, -1115709916, -1122961088)
		+ W(3, 1023143173, 1032102149, 1035049663, -1115297076) + W(4, -1142189493, -1145631357, 1041520845, 1058735511)
		+ W(5, -1123318690, -1113230658, -1107577516, 1029140405)
		+ W(6, -1116365956, -1122350618, -1109597137, 1063925227)
		+ W(7, -1097941231, -1096423541, 1034348655, -1104473650)
		+ W(8, -1108113093, -1120960689, -1100459142, -1102646250)
		+ W(9, -1097541479, -1119600722, 994779835, 1048901284) + W(10, -1144957229, 1013910379, 1028619709, 1003281301)
		+ W(11, 1040501280, 1015718737, -1116733621, -1122107736);
	WS(1025862512, -1097886171);
	sum1 = W(0, 1017995501, 1028206791, -1115115241, 1023900364) + W(1, 973319892, 1028215869, 1033665516, 1031994596)
		 + W(2, 1039868615, 1039095646, 1044724702, 1040670187) + W(3, 1036683863, -1105649212, 1040757263, -1101644966)
		 + W(4, -1084617440, -1095591910, -1088992852, -1089161581)
		 + W(5, -1092805231, -1107053347, -1107160205, -1102281943)
		 + W(6, 1048852846, 1046495341, 1053236428, 1054642003) + W(7, 1050422468, 1049220624, 1039010398, 1042256548)
		 + W(8, 1036255511, 1032043925, 974144948, 1024473755) + W(9, -1132527589, -1120787802, 1025750940, 1034960116)
		 + W(10, 1003283810, 1031081728, -1128580235, 1033561578)
		 + W(11, 1012484477, -1126192084, 1035723265, -1141688154);
	sum2 =
		W(0, 1017309480, -1115898040, 1026950620, -1131938440)
		+ W(1, -1120377052, -1147724576, -1108926548, -1120540424)
		+ W(2, -1113384832, -1105498372, -1140340528, -1101077232)
		+ W(3, -1114410560, 1042402941, -1114542528, 1040078450) + W(4, 1051665642, 1043260681, -1109716244, 1039662810)
		+ W(5, -1113565360, -1097796100, -1108348496, -1097463639)
		+ W(6, -1106075829, 1041703091, -1109231476, 1049668212) + W(7, 1032262130, 1040746517, -1140600496, 1048026467)
		+ W(8, 1041533127, -1122221676, 1047102067, -1109791178)
		+ W(9, 1039963022, -1131969000, 1032294606, -1107112902)
		+ W(10, -1143916576, -1119502308, 1032670038, -1130795288)
		+ W(11, -1112068676, 1031201932, -1108483346, 1028500076);
	WS(1059594295, -1081462343);
	sum1 = W(0, 1027153262, 978268098, 1020914066, 1037283618) + W(1, 1001487768, 1024040629, -1121199663, 1022356543)
		 + W(2, 1043504002, -1116748340, 1039643767, 1038369681) + W(3, 1034058802, 1040894970, -1111840522, 1036921959)
		 + W(4, 1052804111, 1047257898, 1049749519, 1054855273) + W(5, 1047397560, 1052275873, 1039603542, 1026848211)
		 + W(6, -1087238767, -1102654539, -1086204143, -1088075529)
		 + W(7, -1086503800, -1098202447, -1107277965, -1098696769)
		 + W(8, 1041162890, 1038115889, 1044063108, 1037006730) + W(9, -1117492081, 1024505810, 995252542, 1036480704)
		 + W(10, 1012415888, -1165722369, 1033818911, 1032180390)
		 + W(11, 991868273, 1034352017, -1131707508, -1136594828);
	sum2 = W(0, 1028621181, -1110777341, 1027102605, 1030597213)
		 + W(1, -1106396561, 1041951037, -1110468651, 1026771477)
		 + W(2, -1120219585, -1127812186, -1121966109, -1109734497)
		 + W(3, -1139970197, 1005564394, 1027913013, 1021745754) + W(4, 1035384087, -1126856730, 1038893967, 1046142043)
		 + W(5, -1102581665, 1024169581, -1119264521, 1045072501)
		 + W(6, 1034472183, -1129759266, -1123472797, 1054407172)
		 + W(7, -1114873213, 1049042812, -1104920828, -1117275361)
		 + W(8, -1123130413, -1106344343, -1121376361, -1110811845)
		 + W(9, -1147353578, 1023037898, -1123538565, -1108801471)
		 + W(10, -1120488613, -1132463093, -1111137329, 1013238549)
		 + W(11, -1113345499, 1010521365, -1123696429, 934750635);
	WS(1001790336, 1033193226);
	sum1 = W(0, -1113292474, -1131356554, -1133969725, -1118664394)
		 + W(1, 1027204153, -1111709325, 1024655285, -1127980619)
		 + W(2, 1018580889, -1115176285, -1102427201, -1094752997)
		 + W(3, -1105768635, -1119059021, -1121009370, -1131789226)
		 + W(4, -1117909243, 1046326027, 1041639692, 1062953181) + W(5, 1031529696, 1040555139, -1115548569, 1030139737)
		 + W(6, 1052553934, -1113855449, 1060794158, 999804065)
		 + W(7, -1122254720, -1110352445, 1026923705, -1100154756)
		 + W(8, -1104113579, -1112351060, -1095014251, -1105541862)
		 + W(9, -1102735326, 1031818996, 1008421480, 1016036429)
		 + W(10, -1129785460, -1156866531, -1132017542, -1130622370)
		 + W(11, 1022740922, -1121415144, 1008916224, -1122315305);
	sum2 =
		W(0, 999771042, -1130012060, -1123589256, 1018901632) + W(1, -1124249760, 1017234680, -1118367200, 1016197020)
		+ W(2, 1019371878, -1137594745, 1002965746, -1114341154) + W(3, -1115605194, 1017493044, 1015905000, 1024661143)
		+ W(4, 1035878909, 991329315, 1042318306, 1053769225) + W(5, 1010690665, -1099274218, -1101115118, -1092869373)
		+ W(6, -1106457448, 1043986431, -1118271248, 1057361082)
		+ W(7, -1102884302, 1037230696, -1112309114, 1036147884)
		+ W(8, 1038257769, -1108709562, 1025444512, -1113472862) + W(9, 1015483632, -1115820708, 1020142296, 1016005876)
		+ W(10, -1118330440, -1156785507, -1134019065, 1021163648)
		+ W(11, -1123825168, 1025071687, -1126466092, 1013380697);
	WS(-1096043118, -1087645231);
	sum1 = W(0, -1115587665, 1032694426, 1031441086, 1023546425)
		 + W(1, -1130229584, -1147531597, 1019733960, -1115129818)
		 + W(2, 1029203067, -1099485226, -1113336032, -1121275799)
		 + W(3, 1051148019, -1118364796, -1127235090, -1119188228)
		 + W(4, 1045341850, 1017432376, 1054321442, 1050158903) + W(5, -1081266857, 1047006846, -1106232936, 1041137522)
		 + W(6, -1106908023, 1052615508, -1082902530, 1045376289)
		 + W(7, 1057440145, -1118131945, -1134199968, 1018710010)
		 + W(8, -1131991862, -1113683692, 1050084000, -1116607496)
		 + W(9, 1027649766, -1120491559, 1027530281, -1131853547)
		 + W(10, -1114910160, -1127306394, 998100766, -1147820543)
		 + W(11, 1021215128, 991663462, -1123554607, -1124042776);
	sum2 =
		W(0, -1129211209, 1023861908, 1038235290, 1029997412) + W(1, -1125523437, -1107362446, -1114850415, 1013933265)
		+ W(2, 1023515648, -1119658781, -1121364796, -1103304652)
		+ W(3, -1109858923, 1044349350, 1032218024, 1027861436) + W(4, 1040374834, -1108471855, -1096619497, 1039720436)
		+ W(5, -1113539350, 1038091910, -1121557752, 982770184) + W(6, -1110890211, -1133136545, 1044872450, 1050855479)
		+ W(7, -1117035130, -1107498682, -1130602657, -1128608489)
		+ W(8, 1020265593, 1048083250, 1034188808, -1102257516) + W(9, 1022698753, 1024895152, -1162309256, -1129090321)
		+ W(10, 1023672492, -1109425046, -1121333166, -1130250517)
		+ W(11, 1029442100, -1122118916, 1020180841, 939323929);
	WS(1062090935, 1058767985);
	sum1 =
		W(0, 1016379967, -1127587553, -1124869109, 1030044278) + W(1, -1135267218, 1021197901, -1146487047, 1001072263)
		+ W(2, -1111629724, 1016014666, 1045897412, 1039181162) + W(3, -1111908667, 1032078908, -1129970444, 1037221664)
		+ W(4, -1115487571, 1046030390, -1089079359, -1107063038)
		+ W(5, 1056809425, -1100036461, 1008766834, -1118068997) + W(6, 1040669191, -1131263417, 1049140321, 1046027952)
		+ W(7, -1082917799, 1040408361, -1115518322, 1034380765)
		+ W(8, -1124650927, -1107621674, -1120715392, 1035258018)
		+ W(9, 1051125844, -1117322707, -1115270659, -1135017032)
		+ W(10, -1131647467, 1039946613, -1197661491, 1033161790)
		+ W(11, -1129645073, -1124734374, 1029976235, -1119763541);
	sum2 =
		W(0, 1033054007, -1116547758, -1123189128, 1033469023) + W(1, -1122818756, 1026371779, -1136838880, -1137766108)
		+ W(2, -1111327982, 1041352776, 1032790615, 1012971008) + W(3, -1098982462, 1042838787, -1110172088, 1004924993)
		+ W(4, -1121722910, 1034677105, 1033549613, 1033020303) + W(5, 1051050782, -1098306997, 1034801784, -1120000922)
		+ W(6, 1038740385, -1115132829, -1092378351, -1108961666)
		+ W(7, -1121004928, 1045175561, 1019964530, 1027487385)
		+ W(8, -1119336676, -1124364804, -1102497930, -1106694042)
		+ W(9, 1035128176, 1039643256, 1015821086, 1017988993) + W(10, -1124024618, 1035204548, 1032784783, 1032253989)
		+ W(11, 1009754028, -1118316692, -1125398316, 1028774587);
	WS(1065136439, 1040354336);
	sum1 = W(0, -1140671753, -1120274067, 1022747450, -1124666160)
		 + W(1, -1123069063, -1131113682, -1118356003, -1126498983)
		 + W(2, -1108811053, -1107804932, -1110160675, -1105899870)
		 + W(3, 1025125049, 1033405406, -1129239633, 1016924742) + W(4, 1057254373, 1050226223, 1059609336, 1031464345)
		 + W(5, -1093137163, -1111386668, -1105328992, -1111235284)
		 + W(6, -1099781359, -1098842784, -1092867554, 1000731409)
		 + W(7, 1058399851, 1055942809, 1044975810, 1051704028) + W(8, 1009251305, 1010162395, 1036945681, -1114655220)
		 + W(9, -1109467235, -1101547023, -1113825780, -1104493413)
		 + W(10, 1003726785, -1112753158, -1120831377, -1112429520)
		 + W(11, -1119063979, -1146511789, -1116155918, -1117793303);
	sum2 = W(0, -1139839138, 998321428, -1134067290, 1024466364)
		 + W(1, 1008723794, -1119932526, 1028368392, -1132382549) + W(2, 1034041544, 1018598993, 987604943, -1102834025)
		 + W(3, -1131349085, -1118877643, 1031347596, -1113750023)
		 + W(4, 1034669108, -1116818777, 1007335842, 1061492513)
		 + W(5, -1121214551, -1116983417, -1114752830, -1103912225)
		 + W(6, -1095769692, -1114897304, -1102588486, 1062722215)
		 + W(7, -1107691916, -1117176868, 1009572226, 1035794880)
		 + W(8, -1105759439, -1105398904, -1108283066, -1098749835)
		 + W(9, -1108418109, 1041629273, -1103951670, 1046707789)
		 + W(10, 1039138956, -1145690340, 1018314989, 1025712340)
		 + W(11, 1022467761, -1121476700, 1033232162, -1110829011);
	WS(1015535328, -1084984071);
	sum1 = W(0, -1114800552, 1017574081, -1121052395, -1121642214)
		 + W(1, 1031943978, -1119258038, 1015340962, -1152091148)
		 + W(2, -1108603860, -1120445077, -1120661414, 1038434434)
		 + W(3, 1004694578, 983354644, -1131668588, -1117988144)
		 + W(4, -1099862310, -1098244185, -1094435959, -1091868509)
		 + W(5, -1100742889, -1090330210, -1106546547, -1096238847)
		 + W(6, 1058689409, 1050368026, 1059588503, 1053265766) + W(7, 1053762387, 1049777811, 1042220181, 1044693386)
		 + W(8, -1114937124, -1113854018, -1120887600, 1038069402)
		 + W(9, 1032168457, 1033335786, -1112611163, 1033654385)
		 + W(10, -1119809253, -1119794874, -1117398367, -1124845785)
		 + W(11, -1126829041, -1124490374, -1122991451, 1025017029);
	sum2 = W(0, -1113763234, -1113925793, -1117079348, 1016562523)
		 + W(1, -1106152769, 1021767953, -1110489214, -1118706081)
		 + W(2, -1123863865, -1117743388, 1031541130, 1034144457)
		 + W(3, -1108434934, 1028245712, -1107854239, -1131124226)
		 + W(4, -1152383745, 1049718598, 1054034272, 1045174355) + W(5, 1019958281, 1048832333, 1037079656, 1041167636)
		 + W(6, -1153318001, -1115051721, -1111062529, 1029337732)
		 + W(7, -1107848604, 1036566626, -1106439039, -1100833945)
		 + W(8, 1032880554, -1108241407, 1025815300, 1040219109)
		 + W(9, -1122950542, 1032317223, -1114917041, 1023645948)
		 + W(10, -1112434267, 1017487533, -1115045873, -1115252534)
		 + W(11, -1112234054, -1144290245, -1111099643, -1123196065);
	WS(1058837943, 1069665989);
	sum1 = W(0, 962159770, -1131526763, -1123587520, 1016761717)
		 + W(1, -1116652202, 1020359383, -1124916236, -1120750038)
		 + W(2, -1123278397, -1133106088, -1111839826, -1119033369)
		 + W(3, -1112323118, -1123741278, -1111587013, 1031183749)
		 + W(4, 1059574623, 1052414436, 1056026369, 1050778647) + W(5, 1057288447, 1051933055, 1049400292, 1050858601)
		 + W(6, -1100091288, -1100255560, -1090882007, -1089604336)
		 + W(7, -1090318286, -1098258189, -1098860821, -1113801599)
		 + W(8, -1106975399, 1034080493, 1026032901, 1030312842)
		 + W(9, -1115237492, -1123145400, 1023272149, -1102573630)
		 + W(10, 1026912571, 1026538575, -1128992103, -1142474253)
		 + W(11, -1126485147, 1024876312, -1130617057, -1147252941);
	sum2 =
		W(0, 1031825723, -1121672345, -1128689519, 1003655756) + W(1, -1112729716, 1021714543, -1143241256, 1015056847)
		+ W(2, 1031898082, -1123032728, -1149677000, 1042326937)
		+ W(3, 1016978721, -1135526098, 1017362221, -1115756346)
		+ W(4, -1068962638, -1070958719, 1062859919, 1079716701) + W(5, 1069238165, -1106783417, 1038638730, 1030095799)
		+ W(6, -1097279430, 1042495248, 1042236169, -1097154173)
		+ W(7, 1043003442, -1101596383, -1114855682, 1029691669) + W(8, -1106804175, 1004890268, 1033261211, 1047991146)
		+ W(9, 1029430153, 1006662138, 1016716693, -1116617969)
		+ W(10, 1033946762, 1015278793, -1125393239, -1129356209)
		+ W(11, -1130449529, -1143028884, 1021676019, 1007567766);
	WS(1027937136, 1051433372);
	sum1 = W(0, 1024223452, -1131494490, 1034208027, -1113660825) + W(1, 1026687777, 1007645322, 1019229306, 1023660333)
		 + W(2, 1027262836, 1034970897, 1041574867, 1051529138) + W(3, 1043759333, 1035492122, 1025216066, 1033175550)
		 + W(4, -1095583884, -1102510757, -1088128354, -1082034838)
		 + W(5, -1107709564, 1021392868, -1116281753, 1019915650)
		 + W(6, 1036904555, 1043230726, 1043513377, -1088109312) + W(7, 1040837474, 1023668834, 1033050768, 1041627229)
		 + W(8, 1037383306, -1126475809, 1038022750, 1049740992) + W(9, 1043020088, 1040579632, 968839375, 1040383308)
		 + W(10, 1026871330, -1131579916, 1022249046, -1121104697)
		 + W(11, 1030621125, -1128113439, 1026071912, 1024084817);
	sum2 =
		W(0, -1122636491, -1114076695, -1122337791, -1121313911) + W(1, 1019616565, 1032037049, -1121846167, 1035628188)
		+ W(2, 1019704225, 1037288383, 1038646185, -1113812515)
		+ W(3, -1115379683, -1144905268, -1124810757, -1104091459)
		+ W(4, 1049771287, 1032297878, 1050229287, 1058219066)
		+ W(5, -1126947029, -1089173556, -1109798125, -1085784913)
		+ W(6, -1108218455, 1029534785, 1038576544, 1058416091) + W(7, -1096957025, 1029636273, -1112204367, 1039375301)
		+ W(8, 1003686724, -1114871835, 1026526587, -1129529893) + W(9, 1020162449, 1011141050, 1015768281, -1169657505)
		+ W(10, 1007985666, 1019192761, -1146139348, 1021492965)
		+ W(11, -1131201101, -1129337357, -1117257463, 1026702945);
	WS(-1087300279, 1060388257);
	sum1 =
		W(0, -1129462823, 1031115364, -1114720439, 1025637865) + W(1, -1150727557, 1019407412, 1005184420, -1144567588)
		+ W(2, 1023690092, 1041026294, 1027269348, 1022155151) + W(3, 1032140389, 1019365849, 1035913085, -1142073248)
		+ W(4, -1095623283, -1092905754, -1093094418, -1092295181)
		+ W(5, -1091295733, -1094422277, -1097873082, -1089577936)
		+ W(6, -1106106692, 1045171988, 1058204318, 1060821043) + W(7, 1047241920, 1051757075, 1047453654, 1052799910)
		+ W(8, 1037669414, -1113959460, -1142625182, 1044954958) + W(9, 1031904715, 1022315054, -1121754201, 1027854342)
		+ W(10, -1130365587, -1127843579, -1122973026, 1027810288)
		+ W(11, 1008074737, 1005685302, 1011776124, 1023937224);
	sum2 = W(0, -1120594034, -1141459412, -1136839806, 1028313984)
		 + W(1, -1127607807, -1122936307, 1007613018, -1134584398)
		 + W(2, -1166872476, 1004777140, -1113289360, 1013932442)
		 + W(3, 1019995585, -1124945717, -1145964804, -1157638606)
		 + W(4, 1040489823, -1122900789, 1021539093, -1095750682)
		 + W(5, 1045364618, 1031026044, 1033830372, -1125456395)
		 + W(6, -1102509951, -1110936244, 1067324619, 1045560576)
		 + W(7, -1096904945, -1100965201, 1000232964, -1108078168)
		 + W(8, -1086857984, -1095818924, -1093760272, 1065644346)
		 + W(9, -1123950010, 1042979309, -1121148085, 1026162850)
		 + W(10, 1045679794, -1104593759, -1110068744, -1103109579)
		 + W(11, 1034732462, 1018809021, -1152320711, 980148252);
	WS(-1090838638, 1050174926);
	sum1 = W(0, 1024715784, 1033853293, -1106406969, 1042483832)
		 + W(1, 1025782733, -1138965820, 1038488261, -1139164262) + W(2, -1109115088, 1049593122, 994296459, 1045373935)
		 + W(3, 1015694078, -1112080289, 1045351388, -1114987669)
		 + W(4, -1106716164, -1120751425, -1094496661, -1086184702)
		 + W(5, -1092092861, -1095245812, -1100690449, -1094326222)
		 + W(6, 1038102082, 1051782073, 1043814476, 1058236139) + W(7, 1045378621, 1042079876, 1050438570, 1040938025)
		 + W(8, -1115525408, -1136454131, -1105105482, 1033520471)
		 + W(9, 1029286795, -1106373991, 1034575399, -1122199803)
		 + W(10, 1016756989, 1035169257, -1108133484, 1042591993)
		 + W(11, -1140252101, -1115290814, 1041627941, 1001134058);
	sum2 =
		W(0, 1051544715, 1047565246, 1046232208, -1105592564) + W(1, -1094324661, -1105924841, 1021200095, -1103932050)
		+ W(2, -1087153288, -1111682644, -1081925443, 1060283907)
		+ W(3, 1062548140, -1127110112, 1051334754, 1033462267)
		+ W(4, -1090874159, -1099176408, -1105576760, 1048906709)
		+ W(5, -1112367085, 1049091960, -1107585156, 1048824237) + W(6, 1047568122, 1032035298, -1119008010, 1036693685)
		+ W(7, -1119206793, -1158298480, 1036759049, -1114785543)
		+ W(8, -1111412903, 1040133461, -1140028602, -1107739759)
		+ W(9, 1044620924, -1096403637, 1046459856, -1114351857)
		+ W(10, 1034895049, -1131191613, -1112144320, 1040322447)
		+ W(11, -1130045765, 1011461326, 1012649582, -1111955333);
	WS(1039738296, 1044009556);
	sum1 = W(0, 1031992376, -1118478209, 1036413734, 1042319122) + W(1, 1025321013, 1019779694, -1126468451, 1028741314)
		 + W(2, -1113116036, -1126664684, 1028656912, -1095949365)
		 + W(3, 1046101634, -1104617834, -1111694091, 1029160593) + W(4, 1058890327, 1042459434, 1054229481, 1057173004)
		 + W(5, 1048940614, 1052520321, 1047137387, 1057385245)
		 + W(6, -1088719167, -1107130859, -1088309806, -1090115281)
		 + W(7, -1090901446, -1096019759, -1098195015, -1090793697)
		 + W(8, 1040542090, -1129453002, 1042227988, -1127816747)
		 + W(9, 1048439133, -1119199044, 1036380619, 1040359505)
		 + W(10, -1107110028, 1036863629, -1133301245, -1121635021)
		 + W(11, -1120611033, 1022364232, -1108092830, -1129794251);
	sum2 = W(0, -1088996856, -1089163817, -1081345153, -1080285142)
		 + W(1, -1079794071, -1089981167, -1091438196, -1099490886)
		 + W(2, 1009251693, -1107842867, -1124806950, 1052635731)
		 + W(3, -1106464080, -1125456570, -1115606726, -1106662163)
		 + W(4, 1062110924, 1057525018, 1064189433, 1067630395) + W(5, 1063058829, 1062842970, 1054193960, 1053790298)
		 + W(6, -1115283476, 1042234988, -1104109471, -1112028150)
		 + W(7, -1113992476, 1045262592, 1042247754, -1104249669)
		 + W(8, 1030923639, 1032774718, -1126776930, 1034769026)
		 + W(9, -1106165885, -1136163037, 1032379012, -1108359351)
		 + W(10, 1034262626, -1123202523, -1130902850, 1036915346)
		 + W(11, -1110986466, 1035294670, -1135519157, 1024576891);
	WS(-1096394862, 1050867114);
	sum1 =
		W(0, 975777376, 1035680965, 1017323049, -1164976624) + W(1, -1126109949, -1117859264, 1011370603, -1122131819)
		+ W(2, 1011677768, -1097606072, 1017467204, -1122057965)
		+ W(3, 1039142936, -1137149130, 1023416416, -1112401517) + W(4, 1050217928, 1041761501, 1059053443, -1098739346)
		+ W(5, -1089683010, -1104430516, -1115445691, 1042596520)
		+ W(6, -1095631255, -1108785275, -1088500104, -1111108333)
		+ W(7, 1062642602, 1040456976, 1016594173, -1120553683) + W(8, -1105375964, 1035556439, 1042635014, 1025006046)
		+ W(9, 1038036638, 1027021261, 1041295544, 1029575724) + W(10, 1033079080, -1107649602, 1020084753, -1112750027)
		+ W(11, -1142614292, 1017623258, -1113983747, -1124248029);
	sum2 =
		W(0, -1131210775, 1024840523, 1024067225, 1022860453) + W(1, -1125865258, -1130239171, 1024964869, -1117571915)
		+ W(2, 1029829507, -1108448221, 1046565608, -1107856867)
		+ W(3, 1042031083, -1106481128, -1127390051, -1124576676)
		+ W(4, 1018275001, -1117395779, 1042461338, -1092962046) + W(5, 1053212914, -1102214835, -1114692565, 991892650)
		+ W(6, -1122984086, -1132016729, 1059140985, -1089805596)
		+ W(7, 1058514952, 1027704725, -1118917379, 1032905776)
		+ W(8, -1096338526, -1114466007, -1107995649, -1166014069)
		+ W(9, 1052927486, 1041713274, 1037010892, 1032336370)
		+ W(10, 1033255054, -1103146109, -1119288636, -1099911282)
		+ W(11, -1113255745, -1106771914, -1111017176, 1000523989);
	WS(-1112511928, 1031640207);
	sum1 =
		W(0, 1037301926, -1130112569, -1119711398, 1044751592) + W(1, -1102628100, 1042267541, 1021159833, -1122521821)
		+ W(2, -1102373753, 1048837234, -1091456672, 1045582560)
		+ W(3, -1119033858, -1093436941, 1050238014, -1100593739) + W(4, 1058068053, 1051625169, 1054040787, 1044375881)
		+ W(5, 1057193534, 1051238780, 1045936610, 1058222955)
		+ W(6, -1091912761, -1095738529, -1101742756, -1090186767)
		+ W(7, -1090190311, -1110077161, -1098844722, -1090967581)
		+ W(8, 1030698115, 1045615952, -1104227307, 1051640030) + W(9, -1111999463, 1008998972, 1050341641, -1108465231)
		+ W(10, -1112730073, 1045904421, -1098654019, -1111879892)
		+ W(11, -1123401908, -1101737376, 1043894710, -1112695488);
	sum2 =
		W(0, 1016218439, 1009444234, -1111008440, 1026480303) + W(1, 1015374231, -1115006890, 1027237715, -1122692269)
		+ W(2, 1024549194, -1117974589, 1042315856, -1106327815) + W(3, 1040022175, 1025059842, -1110870197, 1033099318)
		+ W(4, -1121292007, -1111737758, 1047393563, -1089871257)
		+ W(5, -1115783084, 1043300713, -1103999090, 1022298131)
		+ W(6, 1037076368, -1110249739, -1086831522, -1069929292)
		+ W(7, -1085683537, 1033002057, 1033912191, 1032775289) + W(8, -1112700443, 1020335555, 1038599637, -1111547810)
		+ W(9, 1049254465, -1118960414, -1118358651, -1104218510)
		+ W(10, 1032984152, -1112172263, 1060801772, 1079084175)
		+ W(11, 1057876572, 1033693800, -1104475663, 1045399536);
	WS(-1106120924, 1033431669);
	sum1 = W(0, 1016553159, -1146851238, 1024375743, 1026515514) + W(1, 1005429062, 1029812010, 1008887700, 1021177962)
		 + W(2, 1035990878, 1041817850, 1041767260, 1047579686) + W(3, 1031819293, 1026577053, 1014785832, 1011005202)
		 + W(4, -1101729723, 1024013341, -1116899488, -1085522812)
		 + W(5, -1090064383, -1118087802, -1126747713, 1025078601)
		 + W(6, 1042266392, 1027850273, 977256084, -1090381288) + W(7, 1048109660, -1113190325, 1024173993, -1127218683)
		 + W(8, 1024064284, 1026394008, 990294084, 1048833585) + W(9, 1038017843, 1040657490, 1020235411, 1041410670)
		 + W(10, 1018305971, 1021653787, 996614956, -1125739905)
		 + W(11, 1016883609, -1121801815, 1027952623, -1132785763);
	sum2 =
		W(0, 1032555846, 1019641904, 1015684488, -1123545328) + W(1, -1118308408, -1117707424, -1137876352, -1152988290)
		+ W(2, -1110721648, -1116342888, -1102693078, 1027573888) + W(3, 1043950970, 1021888896, 1007632640, 1023916088)
		+ W(4, -1094136567, -1089264280, -1097199465, 1056898914) + W(5, 1037769558, 1041236542, 1026403708, 1046276806)
		+ W(6, 1030929664, -1112511004, 1046449598, 1052843165)
		+ W(7, 1024674316, -1109778580, -1123597216, -1105717038)
		+ W(8, -1146526593, 1032788860, 1012812816, 1033507644) + W(9, -1106559340, 1017687520, 1028523456, -1122312832)
		+ W(10, 1018020888, -1125819008, 1004426241, -1122415072)
		+ W(11, 1028547840, 996318210, -1149117889, -1132920416);
	WS(1034973624, 1056792353);
	sum1 = W(0, -1120658336, -1121055921, -1128295926, 1021962732)
		 + W(1, -1127490506, -1119904327, -1122942113, -1119710033)
		 + W(2, -1130821617, -1114464179, -1106629009, -1093463666)
		 + W(3, -1097245927, -1132912612, -1118132038, -1115274080)
		 + W(4, -1114903379, -1125024178, 1008426736, 1062068439)
		 + W(5, 1050479246, -1107542555, 1028006365, 1025872901)
		 + W(6, -1130597942, -1102939831, -1118485143, 1067744046)
		 + W(7, 1049107361, 1045213129, -1113875250, 1036565277)
		 + W(8, -1109039532, -1115164458, -1104109440, -1094141737)
		 + W(9, -1105858697, -1119937620, -1141854766, -1121170098)
		 + W(10, -1124529164, -1124681556, -1138254780, 993935312)
		 + W(11, -1132704804, -1120970067, -1122550700, -1120520661);
	sum2 =
		W(0, 1020401308, 1017661559, -1129375401, -1130735541)
		+ W(1, -1146688164, -1166762145, -1130185789, -1137125822)
		+ W(2, -1120501349, 996214904, -1140432422, 1024553914) + W(3, 1006774606, -1124013507, 1033491675, -1117903931)
		+ W(4, 1037264768, -1116129767, 1035443152, 1051779064) + W(5, 1039827062, 1025600009, -1114545658, 1032817572)
		+ W(6, -1090330474, -1084580575, -1097846115, 1064606263)
		+ W(7, 1048687051, 1019182043, -1117487855, 1037037513) + W(8, -1105802125, 1032645479, -1102145888, 1038402436)
		+ W(9, 1000828364, 1025151371, 1028059566, -1112238814)
		+ W(10, 1023925581, -1119976615, 1025111856, -1136822486)
		+ W(11, -1121332237, 1015612208, -1119338761, 999461036);
	WS(-1082445367, -1085006700);
	sum1 = W(0, -1131835086, 1034878908, -1106661648, 1037617118)
		 + W(1, -1121819052, 1022066011, 1036207796, 1033542412) + W(2, 1041974800, 1043293403, 1042063924, 1045196135)
		 + W(3, 1037212703, -1105403448, 1046411795, -1100599618)
		 + W(4, -1081109875, -1092276724, -1086386347, -1094524616)
		 + W(5, -1094507255, -1104988703, -1105674409, -1096619449)
		 + W(6, 1054173212, 1051286356, 1055927462, 1058619216) + W(7, 1050138098, 1028915053, 1041419787, -1130824962)
		 + W(8, 1035072463, 1034209806, -1114712644, 1036390662) + W(9, 1015171028, -1139447658, 1026111277, 1045523870)
		 + W(10, -1137431795, 1038048136, -1110863483, 1042877649)
		 + W(11, -1123146704, -1114994477, 1040360493, -1121943708);
	sum2 =
		W(0, -1112963339, 1025676326, -1117465202, 1036266015) + W(1, -1124864900, 1019242508, 1017632828, 1039721851)
		+ W(2, 1043137200, 1000796272, 993751520, -1098528956) + W(3, 1032573075, -1097473255, 1049454991, -1090503899)
		+ W(4, 1014823768, 1031859059, 1020211292, 1055374057) + W(5, 986723264, -1125510524, -1111044051, 1007293144)
		+ W(6, -1089890678, -1102855534, 1018575516, 1061198225) + W(7, 1038055959, 1050136287, -1109681619, 1054985311)
		+ W(8, 1022229356, 1031913791, -1120060570, -1098119563)
		+ W(9, -1106568385, -1098582022, 1030233630, -1101215648)
		+ W(10, -1128614108, 1018516204, -1138611816, 1020738140)
		+ W(11, -1132953832, -1123833514, 1035860627, -1110059149);
	WS(-1089141943, 1068474134);
	sum1 =
		W(0, 1024130588, -1101143803, 1039148539, -1124204515) + W(1, 1026773217, 1018218693, -1104179471, -1123573325)
		+ W(2, -1121972404, 1041396360, -1105946681, 1052602058)
		+ W(3, -1091638882, 1032280890, 1041946144, -1138642417)
		+ W(4, 1032495505, 1045416789, -1106461946, -1094942270) + W(5, 1059099726, -1106993164, 1045088278, 1009482242)
		+ W(6, 1036801227, -1094238571, 1057861426, -1098420551) + W(7, 1040764762, 1033290001, -1105244536, 1037819035)
		+ W(8, -1117579092, 1039470024, -1113046718, 1047303536)
		+ W(9, -1094617668, 1040300696, -1110195745, -1108347351)
		+ W(10, -1114425265, 1024684838, -1108918837, -1127532529)
		+ W(11, 1027200645, -1103088708, 1043167338, -1116739793);
	sum2 = W(0, 1016644168, 998892514, -1116049462, 1033248586) + W(1, -1110140123, 1041609896, -1103095555, 1030835892)
		 + W(2, -1134771145, -1114282184, 1042383274, 1025008594)
		 + W(3, -1104878488, -1101611481, 1048842205, -1122288558)
		 + W(4, -1129326838, 1049635340, -1147070546, -1102476512)
		 + W(5, -1090718582, 1046973498, -1115539252, 1028769716)
		 + W(6, -1114142714, -1101404122, -1095734150, 1060588986)
		 + W(7, 1052949499, -1143476482, -1110997031, 1022411808)
		 + W(8, 1012771369, -1114952606, 1057697290, -1111850310)
		 + W(9, -1096580248, -1114336646, 1031782132, -1118966953)
		 + W(10, 1025799488, 1041138771, -1095991584, 1027653952)
		 + W(11, -1127102864, 1035005082, 992902692, -1120028296);
	WS(1055908206, 1023803300);
	sum1 = W(0, 1033033649, -1128828388, 1027156540, 1024886583)
		 + W(1, -1122498726, 1032744244, -1114524705, 1005980052)
		 + W(2, -1114766205, 1011459483, -1106069078, -1116675477)
		 + W(3, -1116893112, 1045609495, -1113403236, 1049123968) + W(4, 1059767687, 1054454099, 1057986836, 1059734148)
		 + W(5, 1056528229, 1043829406, 1047712168, 1049516377)
		 + W(6, -1093070812, -1094569204, -1086765600, -1090099632)
		 + W(7, -1094363024, -1102732570, -1103438026, -1098493775)
		 + W(8, -1106762950, 1029622486, 991938588, -1098865153)
		 + W(9, -1101593593, -1139103892, 1022039246, -1097177334)
		 + W(10, -1139512861, 1016172182, 1027600816, 1027525694)
		 + W(11, -1135964969, 1036132330, -1117700205, 1035501771);
	sum2 = W(0, 1025334517, -1115143239, -1112308287, -1115511381)
		 + W(1, 1042864237, 1031444191, 1040795754, -1111573417) + W(2, 1052224655, 1029199567, 1050599738, -1137182696)
		 + W(3, -1101494467, -1094150391, -1116631442, -1092627938)
		 + W(4, -1085507535, -1092254017, -1091835304, 1050309385)
		 + W(5, 1052849573, 1058681981, -1093246396, 1066882777)
		 + W(6, -1083097675, -1079915962, -1078367265, -1085955474)
		 + W(7, 1077549274, 1068550083, 1054678659, 1059124396)
		 + W(8, -1097828858, -1092877982, -1101001669, 1031547399)
		 + W(9, 974314816, -1100178328, 1046838481, -1088438520) + W(10, 1062578782, 1029921983, 1036651638, 1017725718)
		 + W(11, -1103762806, -1106558945, 1039431488, -1098096651);
	WS(-1078207964, -1098790270);
	sum1 =
		W(0, -1117816013, 1039615439, 1040159636, 1032454162) + W(1, 1029735698, 1026856980, -1128361629, 1002339317)
		+ W(2, 1017293260, -1121106131, -1098516348, -1100564368)
		+ W(3, -1142189601, -1115831559, -1129405415, -1114960439)
		+ W(4, 1049047675, -1100078274, 1057717203, 1041647209) + W(5, -1090236946, 1041839801, -1114821509, 1034781465)
		+ W(6, -1100878354, 1049964833, -1094050686, -1119951725)
		+ W(7, 1052197359, -1110599850, 1009705546, 1020602063) + W(8, 1032784131, -1107321921, 1040450075, -1099964381)
		+ W(9, -1116032848, 1034137049, 1036993018, 993360895) + W(10, -1126192007, -1122801847, 1034337038, 1014677674)
		+ W(11, 1028031798, 1027844545, -1121696025, -1130484229);
	sum2 =
		W(0, 1025029135, -1115606678, -1098891737, -1111864983) + W(1, -1112278329, 1017169741, -1123958951, 1031819582)
		+ W(2, -1104367710, -1132455965, 1054704406, 1035843132)
		+ W(3, 1038310704, 1037432870, -1137648567, -1122384617)
		+ W(4, -1119205162, 1051294613, -1118431701, 1040638061) + W(5, 1033551568, -1095570314, 1040693441, 1008777251)
		+ W(6, 1051361304, -1090262380, -1094584814, 1042639742) + W(7, 1042180969, 1054301740, 1006683771, 1032304440)
		+ W(8, -1097951274, 1046775583, -1111734067, -1115582191)
		+ W(9, -1116801751, -1102111461, -1108749213, -1103720876)
		+ W(10, 1037239658, 1027534783, -1137589907, -1161598998)
		+ W(11, -1113612863, -1137659371, 1017443081, 1038413214);
	WS(1060561207, -1110135205);
	sum1 = W(0, -1114856118, -1124131449, -1121034566, -1112340961)
		 + W(1, -1112123800, 1034679769, -1115322038, -1107671902)
		 + W(2, 1049197464, -1108658488, 1041962623, 1047635080) + W(3, 1029521634, 1045001085, 1019494819, 1038785126)
		 + W(4, -1091745710, -1095755605, -1091090769, -1089785676)
		 + W(5, -1088312300, -1105390912, -1095959893, -1089779917)
		 + W(6, 1057921518, 1045522218, 1055093690, 1056738433) + W(7, 1057086969, 1048793054, 1049205462, 1057170552)
		 + W(8, 1045672489, -1100746808, 1019645080, -1111234056)
		 + W(9, -1095870350, 1047514180, -1099214252, 1022895484)
		 + W(10, 1021270499, -1112929307, -1157317541, 1036938084)
		 + W(11, -1148757666, 1026507103, 1019330670, 1029094240);
	sum2 =
		W(0, -1110883135, -1122184691, 1008834310, 1033395903) + W(1, -1110716892, 1024095030, -1113505190, -1113542640)
		+ W(2, 1041894205, -1115970606, 982318965, 1040255170) + W(3, -1134396672, 1031402202, -1121857157, 1031923695)
		+ W(4, -1114700148, -1118217955, -1097954058, -1109327580)
		+ W(5, -1107386491, -1114148625, -1116084956, -1128842340)
		+ W(6, -1082032478, -1081043792, -1085641610, -1095688614)
		+ W(7, -1084362127, -1093205100, -1087863650, -1094939475)
		+ W(8, 1046875162, 1049320576, 982336213, -1107088758) + W(9, 1032307660, -1122373488, 1045820748, 1044473869)
		+ W(10, 1064081845, 1059051295, 1064706681, 1066526360) + W(11, 1060847547, 1058657081, 1055302318, 1041403755);
	WS(-1088848183, -1091270356);
	sum1 = W(0, -1113444636, -1127291412, -1131637032, -1105736260)
		 + W(1, 1030983166, -1127378047, 1037357901, -1115666437) + W(2, 1022583331, 1011517178, 1047190142, 1040877723)
		 + W(3, 1035565944, -1097520394, -1114602800, -1108205485)
		 + W(4, -1092936920, -1094397598, -1092945549, -1086200137)
		 + W(5, -1102025475, -1104020948, -1116833526, -1102830535)
		 + W(6, 1050793382, 1055228191, 1056457416, 1051083611) + W(7, 1056969730, 1051399464, 1044492479, 1047811509)
		 + W(8, 1035173048, -1112816343, 1039723405, 1039289519)
		 + W(9, 1015654008, -1108815670, -1116817631, 1032741190)
		 + W(10, -1115063927, 1007040780, -1118782984, -1114815627)
		 + W(11, 998545680, -1127143385, 1025703109, -1123886254);
	sum2 =
		W(0, 1023906737, -1110646223, -1119411664, 1010017751) + W(1, -1108429461, 1029589423, -1110439418, -1125097343)
		+ W(2, 1067295699, 1065087692, 1065459703, -1118952488)
		+ W(3, -1081475488, -1083105366, -1095503285, -1083389324)
		+ W(4, -1081442287, -1085042817, -1083251842, 1050008558) + W(5, 1064700095, 1064469883, 1057972141, 1061045473)
		+ W(6, -1097077469, 1037915281, -1096872835, -1110920551)
		+ W(7, 1006981249, 1036080906, -1106015672, 1051761632) + W(8, 1029195957, 1015927544, 1018101230, 1042598936)
		+ W(9, -1103158035, 1041992018, -1108943564, -1114827780)
		+ W(10, 1026431960, -1132623721, 1018762696, -1124571002)
		+ W(11, 1020104602, -1114107558, 1036691137, -1119006739);
	WS(1034259896, 1039623341);
	sum1 = W(0, 1016878676, 1028460795, 1034359235, 1011385345) + W(1, 1015855070, 1016831138, -1128588247, 1025908283)
		 + W(2, -1137539339, -1104998988, -1129847248, 1015052988)
		 + W(3, 1032818160, 1044006969, 1033445320, 1043524531) + W(4, 1055868742, 1047938201, 1058114664, 1043619008)
		 + W(5, -1096687428, -1092418872, -1100196186, -1095896370)
		 + W(6, -1088089066, -1091378989, -1090213650, -1114958501)
		 + W(7, 1054476715, 1049053750, 1040121848, 1044746961) + W(8, 1043298073, 1036240559, 1043122195, -1119276751)
		 + W(9, -1110579607, -1101201217, -1106781444, 1018213241)
		 + W(10, 984347141, -1121755284, 932956556, 1018241806)
		 + W(11, 1026808723, 1034235663, 1010316760, -1120101215);
	sum2 = W(0, 951810592, 1033659165, 1002259560, 1037243759) + W(1, -1112310958, 1034753865, 992340497, -1114454490)
		 + W(2, -1108037836, -1102042508, -1103529440, -1102191435)
		 + W(3, -1111056455, -1119026649, -1101647251, 1024637657)
		 + W(4, -1092018666, -1107310314, -1101738099, 1066447662)
		 + W(5, 1032823775, 1031795157, 1040899047, 1046257437) + W(6, -1130209970, -1115641842, 1041635941, 1067062587)
		 + W(7, -1098661250, -1099014553, -1117726225, -1111013301)
		 + W(8, 1022643242, -1110096702, 1034513697, -1100161415)
		 + W(9, 1027860693, -1096684817, -1114962434, -1112982645)
		 + W(10, 1009312276, 1032067593, -1114108683, 1041326077)
		 + W(11, -1120382671, 1026651225, 1038338139, -1106704138);
	WS(-1096556910, 1067967914);
	sum1 =
		W(0, 1032707155, 1024354487, -1131915011, 1043480447) + W(1, -1118942187, -1132633269, 1031302952, 1031513592)
		+ W(2, -1122886335, 1031668012, 1021347526, 1041914807) + W(3, 1036630543, 1034774528, -1125222297, -1106257250)
		+ W(4, -1095119782, -1103532312, -1095435756, -1090836352)
		+ W(5, -1091218783, -1104917967, -1100801113, -1104067043)
		+ W(6, 1055235700, 1048353625, 1044387963, 1053060297) + W(7, 1041581564, 1052242886, 1033613430, 1050269976)
		+ W(8, -1120012638, -1105977207, -1105830818, -1133082414)
		+ W(9, 1017318739, -1121967338, -1130484760, -1109204860)
		+ W(10, 1031514684, -1126996321, -1116416117, 1043128001)
		+ W(11, -1110350280, 1039162573, -1148985233, 1034839630);
	sum2 = W(0, -1125934657, -1120747465, -1126946517, 1019390634)
		 + W(1, -1140291646, 1045993569, -1110717499, 1038335355)
		 + W(2, 1041393774, 1032139854, -1107151652, 1046075673)
		 + W(3, -1090083756, 1024325836, -1116058677, -1097350707)
		 + W(4, -1097497496, -1114660789, -1096477783, 1057927405)
		 + W(5, -1110210473, -1137735680, 1033250412, -1127153776)
		 + W(6, 1047775001, -1105604596, 1048515105, 1059160295) + W(7, 1043731078, 1039621515, -1116506490, 987432265)
		 + W(8, -1131783044, 1018330620, -1096755902, 1041946221)
		 + W(9, -1091797353, 1046026631, -1106745231, -1124643180)
		 + W(10, -1122059316, -1129241452, -1147658728, 1011994599)
		 + W(11, 1032850220, -1126091098, 1009337229, -1124186068);
	WS(1061843767, -1077951557);
	sum1 =
		W(0, 1026388735, -1120114128, 1037862893, 1029309653) + W(1, 1036389538, -1122000006, -1126306304, 1030215888)
		+ W(2, -1106366502, -1131166601, 1029755951, -1091391038)
		+ W(3, 1048316317, -1099454574, -1106178153, 1034019808) + W(4, 1059311576, 1043697070, 1054385928, 1057568381)
		+ W(5, 1054220568, 1049723715, 1050234615, 1058416302)
		+ W(6, -1088217072, -1105977039, -1091419383, -1089136642)
		+ W(7, -1092475601, -1095416897, -1096877448, -1091809363)
		+ W(8, 1041378862, -1130669927, 1047467576, -1111164306) + W(9, 1053509792, -1108260705, 1038585474, 1045917860)
		+ W(10, -1102542817, 1039925540, 989452730, -1105668215)
		+ W(11, -1138232735, -1130981221, -1107228323, -1116719540);
	sum2 = W(0, 1061533858, 1062451832, 1068272760, 1070735043) + W(1, 1070929067, 1058522058, 1059576348, 1052624489)
		 + W(2, 1041546460, 1044663473, 1019905335, -1103665132) + W(3, 1027882908, 1053579543, 1030217484, 1042937819)
		 + W(4, -1081881922, -1084977950, -1081565785, -1079025547)
		 + W(5, -1082597652, -1079765468, -1088759123, -1090364693)
		 + W(6, -1104625991, -1116240264, -1115490290, -1094934042)
		 + W(7, 1002519540, -1096683616, -1103272320, 1039524167)
		 + W(8, 1020257203, -1107478927, 1038097782, -1129735749) + W(9, 1043320870, 997759194, -1110736144, 1041293151)
		 + W(10, -1112819836, -1146254682, 1018218872, -1108448519)
		 + W(11, 1032555484, -1111378699, 1018278443, -1120119454);
	WS(-1084224055, -1088316584);
	sum1 = W(0, -1113613001, 1003388692, -1106869627, 1016662735) + W(1, 1022316973, -1136760929, 1028746387, 984919127)
		 + W(2, -1107673717, 1028109079, 1012698375, 1027116933)
		 + W(3, -1094644889, 1023495179, -1107590588, 1024116594)
		 + W(4, 1006747746, -1098426505, -1088923256, -1097246285)
		 + W(5, 1057877820, 1033746004, 1041863252, 1022736621) + W(6, 1039555654, 1048291572, 1059475506, 1054502102)
		 + W(7, -1093203288, -1098003683, -1105649846, -1114921814)
		 + W(8, 1033838821, 1024741190, -1120760050, 1019707757) + W(9, 1048977331, 1036081339, 1041797102, -1127589064)
		 + W(10, -1159624430, -1124153911, 1033833840, 1010228666)
		 + W(11, -1114819581, -1110624834, -1119454813, -1122201606);
	sum2 =
		W(0, 1015245257, -1113948506, -1130594159, 1007533655)
		+ W(1, -1122336092, -1131246557, -1121042747, -1112003767)
		+ W(2, -1113301472, -1150409563, -1113241340, 988101766) + W(3, -1114338752, 1042344950, 1024929700, 1034588627)
		+ W(4, -1126889814, 1027745966, 1053517180, -1115083078) + W(5, -1120298083, 1009652067, 1023796132, 1015099871)
		+ W(6, -1122805777, -1121614859, 1035094088, -1117590123) + W(7, 1041346715, 1010321235, 1022595647, 1021357977)
		+ W(8, 1024783162, 1024732276, 1035927962, 1033594898)
		+ W(9, -1136757529, -1112303516, -1107129305, -1116844702)
		+ W(10, -1125306444, -1120982285, -1117285071, -1115586407)
		+ W(11, -1179946326, -1122655190, 1031780006, -1109817399);
	WS(1056759150, 1060224665);
	sum1 =
		W(0, -1139374311, 995010733, -1111414410, -1108849608) + W(1, 1028987391, 1016981889, -1123115291, -1129401942)
		+ W(2, -1132085157, 1023919167, 1047983919, 1035204919) + W(3, 1044747100, 1009635916, 1026679904, -1133052010)
		+ W(4, -1099925456, -1105275165, -1089721802, 1047380996)
		+ W(5, -1111752399, -1106656308, -1119632759, -1103728616)
		+ W(6, 1041263149, -1143162806, 1045591848, 1054640011) + W(7, -1086265361, 1052567064, -1119813375, 1036660778)
		+ W(8, 1033127353, 1020125661, 1047176279, -1109178223) + W(9, 1047077327, 1025513390, 1020940735, 1026259564)
		+ W(10, -1131329248, -1128574472, -1124813330, -1115433611)
		+ W(11, 1014274699, -1114033239, -1135589654, -1154487021);
	sum2 =
		W(0, 1023227060, 1023565277, 1023373012, -1127246210) + W(1, 1035525242, -1115895934, 1032252451, -1115664904)
		+ W(2, -1114834111, -1123243930, -1110717616, -1119831250)
		+ W(3, 995075850, -1112704991, -1137853837, -1177558227)
		+ W(4, -1123255684, 1036838581, -1121973236, -1128787384)
		+ W(5, -1106791563, 1017209933, 1025363014, -1117762720)
		+ W(6, -1111609489, -1109001470, -1106028739, 1068968933)
		+ W(7, -1084327071, 1049794788, -1103092626, 1033559138) + W(8, 1029177075, 1046335474, 1040383540, -1085459757)
		+ W(9, 1055427968, -1106438120, 1039281515, -1108939748)
		+ W(10, 1009084849, -1110362282, 1030364025, 1038001226)
		+ W(11, 1004844681, -1109625554, 1026824663, 1027051057);
	WS(1059198391, -1114206899);
	sum1 =
		W(0, -1123230572, 1033309054, -1136657179, 1042361008) + W(1, -1127872354, 1026831155, 1034821095, 1027013917)
		+ W(2, 1047908609, -1113872057, -1131612168, 1032838544) + W(3, 1018582917, 1025662981, -1122684754, 1042918755)
		+ W(4, -1086695351, 1005036838, 1053830093, 1063074340) + W(5, 1022976638, 1048968528, 1037218004, 1045668084)
		+ W(6, -1111534963, -1127426130, -1097279138, 1032841926)
		+ W(7, -1102974814, -1086802103, -1094977286, -1080167184)
		+ W(8, 1041894153, 1035651728, -1114797926, 1042266564) + W(9, 1036160183, 1043048448, 1028546130, 1051954532)
		+ W(10, -1168813170, 1029018614, 1015674230, -1115081892)
		+ W(11, 1022213546, -1119589535, 1023015663, -1121567905);
	sum2 = W(0, -1109294951, 1044771761, -1106240469, 1037653814)
		 + W(1, -1132138943, -1129034439, 1027920896, -1126749735)
		 + W(2, -1116747636, -1095594447, -1091993541, -1098134808)
		 + W(3, 1045429231, -1112675284, 1030264036, 1027709116) + W(4, 1053044316, -1102224225, 1065361960, 1060397410)
		 + W(5, -1095097189, -1139768526, -1100471477, -1095674438)
		 + W(6, -1093594252, 1044254591, -1103264547, 1059446961)
		 + W(7, 1053539276, -1147713757, -1115698004, -1131922215)
		 + W(8, -1105874671, -1148207325, -1098859579, -1110887683)
		 + W(9, -1103270924, 1018090127, -1105560593, 1044415945)
		 + W(10, 1036768486, -1122217612, 1038496462, -1106764847)
		 + W(11, 1035231626, -1112984312, 1037287074, -1106415399);
	WS(-1081905372, 1072993545);
	sum1 =
		W(0, 1004609681, -1113931058, 1017897178, -1110350900) + W(1, -1119842647, 1029593625, -1114320538, 1026419555)
		+ W(2, -1111485397, 1044870886, -1101161424, 1042868018) + W(3, 1016958866, 1036666966, 1034341084, -1123516147)
		+ W(4, -1100618406, -1103601459, -1117978262, -1088871615)
		+ W(5, -1096217303, -1090419947, -1105396084, -1100180286)
		+ W(6, 1052555682, 1050421002, 1053397115, 1057434595) + W(7, 1037835279, 1054502387, 1036260396, 1041011339)
		+ W(8, -1113666277, -1125853837, -1109207833, -1108715676)
		+ W(9, 1041223333, -1131918060, 1046093262, -1108472674)
		+ W(10, -1113131956, -1119475260, -1119057377, -1116054255)
		+ W(11, 1033629886, 1019600139, 1034832815, 1025124935);
	sum2 = W(0, 1027207918, -1131003531, -1155176792, -1144704129)
		 + W(1, -1120277627, 1018692534, -1122116985, 1016313728)
		 + W(2, -1134820995, 1019005665, 1018656479, 1016837667) + W(3, -1133755465, 1007330736, 1008190855, 1024160458)
		 + W(4, -1123507780, 992028222, 1020777698, -1093100477) + W(5, -1106617270, 1026210395, 1015481059, 1009441727)
		 + W(6, 1022927690, 1039006609, -1108026125, -1075529389)
		 + W(7, -1071234400, -1098388857, 1043410538, -1127804151)
		 + W(8, -1148644129, -1114458430, 985006155, -1165905039) + W(9, 1009164120, 1080134310, 1068769301, 1038162442)
		 + W(10, -1124904791, 1019252639, 1019665619, -1148497627)
		 + W(11, -1154476856, 1041946375, -1120913968, -1102924087);
	WS(1052536174, -1151096569);
	sum1 = W(0, 991116371, 1033302347, -1116642336, -1115536654)
		 + W(1, 1020657940, -1114833734, 1031490598, -1158391502)
		 + W(2, -1128173243, -1146822742, 1036050892, 1034768509)
		 + W(3, -1102372039, 1030675614, -1114628406, 1032401267)
		 + W(4, -1103836723, 1034951935, -1087917523, -1106200391)
		 + W(5, 1061554222, 1041046871, 1046795201, 1027714602) + W(6, 1032573088, -1120898050, 1057405287, -1120590821)
		 + W(7, -1082912644, 1002819162, -1124848916, -1124036191)
		 + W(8, 999976938, -1138114279, -1098834165, -1118223722)
		 + W(9, 1047922098, -1107937520, 1038688870, -1118805976) + W(10, 1037991630, 1035558856, 1042054293, 986260550)
		 + W(11, -1130396508, 1023135729, -1142052488, -1177279769);
	sum2 = W(0, 1035223119, -1127800761, 1038890181, 1028905699) + W(1, 994981383, -1127955051, 998786660, -1121293280)
		 + W(2, 1038869307, 1034423710, -1109261585, -1095895125)
		 + W(3, -1098712671, 1032845262, 1030375171, -1114148994)
		 + W(4, -1108836158, -1116666352, -1087753137, 1061176216)
		 + W(5, -1099737664, -1208820627, -1126035264, 1042226462)
		 + W(6, -1105867416, -1109342419, 1027333841, 1057224086)
		 + W(7, 1049674522, 1011854042, 1017325847, -1120003540)
		 + W(8, -1106282608, 1047028407, -1148256348, -1148022324)
		 + W(9, -1103462952, 1043242553, -1121350765, -1117125009)
		 + W(10, 1028503999, -1119414296, -1113209005, 1010099974)
		 + W(11, 1020393479, -1115953239, 1024565993, 1001260628);
	WS(1058902967, -1081860445);
	sum1 =
		W(0, -1121371387, 1029881036, 992316765, -1117974353) + W(1, 1019164800, -1115308289, 1031905998, -1118946572)
		+ W(2, -1116017491, -1110722656, -1103068528, -1120254383)
		+ W(3, -1111729689, -1123116948, -1110978129, 1027465948)
		+ W(4, -1114517185, -1096281750, -1110556335, -1087192661)
		+ W(5, -1138608617, -1119671953, 1026716344, 1026550240) + W(6, -1144385454, 1046612526, 1050079932, 1061346066)
		+ W(7, 1054224317, 1023689473, 1034730016, 990814541) + W(8, 1031405875, 1032371736, -1114542190, -1113719056)
		+ W(9, -1147587566, -1121094047, 1032702160, 1025765741)
		+ W(10, -1133995267, -1118231237, 1037331941, -1117606232)
		+ W(11, 1027634660, -1114416951, -1150819433, 1002408318);
	sum2 = W(0, -1127268449, 1008157504, 1022079949, -1129508015) + W(1, 1023435994, 987488696, -1149203238, 1025441916)
		 + W(2, 1017520494, -1110533731, -1110799425, 1038116680)
		 + W(3, -1149062134, -1109564641, 1031926637, -1140288129)
		 + W(4, 1046612660, 1053115740, 1042237616, -1081939523) + W(5, 1046590815, 1019421448, 1025089506, 1002014090)
		 + W(6, -1104246964, -1126879265, 1071620340, -1082767624)
		 + W(7, -1091995420, -1133233221, -1113723868, 1008464055)
		 + W(8, -1098833757, -1103206877, 1047260740, 1046386206)
		 + W(9, 1034566387, -1113663072, -1131415815, -1120607589)
		 + W(10, 1019779427, -1135658469, -1112586418, 1021781126)
		 + W(11, 1021597755, 1025921212, 1022181144, -1133866981);
	WS(-1118927728, -1114990634);
	sum1 = W(0, -1123938375, 1040612950, 1024746402, 1022214714)
		 + W(1, 1038811590, -1112630087, -1118622728, 1031232344)
		 + W(2, 1033195056, -1114716774, 1048819881, -1104426015)
		 + W(3, -1105195831, 1042575344, -1098438774, 1038434900) + W(4, 1057535917, 1047260544, 1042772673, 1057677234)
		 + W(5, 1045869257, 1057533694, 1042859777, 1055588422)
		 + W(6, -1087859524, -1132924433, -1087499341, -1097320317)
		 + W(7, -1091890215, -1089715893, 1029276300, -1091230428)
		 + W(8, -1107191040, 1007112943, 1043648426, -1093740782)
		 + W(9, 1042013107, 1020754614, -1107815558, -1113991309)
		 + W(10, 1047574307, -1106834116, 1044210486, 1028537764)
		 + W(11, -1106862316, 1047539199, -1107232885, 1041569343);
	sum2 = W(0, -1117938617, 1034943831, 1047294563, -1112881764)
		 + W(1, -1113196518, 1017166837, -1119652380, -1122537978)
		 + W(2, -1098776947, -1074997876, -1067348911, -1073328658)
		 + W(3, -1106856879, 1007574096, 1040326435, 1003760381) + W(4, 1052841626, 1071950042, 1078478928, 1075942353)
		 + W(5, 1048374094, -1110198115, 1016518417, -1132261857)
		 + W(6, -1111689798, 1008522816, 1042633900, -1105497105)
		 + W(7, -1100859969, 1027760421, -1106280857, -1146348222)
		 + W(8, -1101990052, 1023979086, -1106116215, 1040726051)
		 + W(9, -1128120408, 1041816709, 1015116440, 1015700123) + W(10, 1034353164, 1019125592, 1021696573, 1032192788)
		 + W(11, -1129459590, -1114781060, 983174391, 1019612376);
	WS(1034111416, -1106797037);
	sum1 = W(0, -1127934684, -1146675705, 1006977829, -1113401378)
		 + W(1, 1019549798, 1016064490, -1139061950, 998716411) + W(2, -1113852291, 1035613338, 1034804131, 1037672145)
		 + W(3, 1044038057, -1106829090, 1033066250, 995721454)
		 + W(4, -1096035023, -1102929642, -1090308252, -1089088820)
		 + W(5, -1096624416, -1097224209, -1104516203, -1095532026)
		 + W(6, 1052464285, 1042719307, 1054858571, 1057164897) + W(7, 1050796251, 1048920159, 1042039981, 1049209393)
		 + W(8, 1032415443, -1114220817, 1032020487, -1123663635)
		 + W(9, 1035431737, -1131720964, -1114943722, 1041424208)
		 + W(10, -1113420426, 1025128440, -1114922591, -1136503085)
		 + W(11, 1026704599, -1109868785, 1024811962, -1138798477);
	sum2 = W(0, 1018373307, -1117669473, 1036793172, -1107254646) + W(1, 1027210469, 983011887, -1124389554, 999841656)
		 + W(2, 1030944977, 1035483586, -1120221588, -1138388666)
		 + W(3, -1119036598, 1026801669, -1120993070, 1036234905)
		 + W(4, -1120549779, -1113169149, 1031305133, -1118729068)
		 + W(5, -1123944089, -1136088418, 1045466087, -1110162376)
		 + W(6, -1139755202, -1114451942, 1047991436, 1050438576)
		 + W(7, 1058194810, -1103576008, 1037255439, -1114267729)
		 + W(8, -1101691927, -1102665013, -1083948126, -1083351573)
		 + W(9, -1081291530, -1106933299, -1095248620, -1124771645)
		 + W(10, 1049483493, 1049560407, 1057078402, 1060878230)
		 + W(11, 1058504911, 1044728114, 1047223280, 1036725012);
	WS(1038841272, 1052605132);
	sum1 =
		W(0, 1031922765, -1104568331, 1037544250, -1109808312) + W(1, -1115625903, 1042593752, -1105481799, 1033924054)
		+ W(2, -1100459309, 1046914264, -1120141702, -1117060814)
		+ W(3, 1046551204, -1097718198, 1032086688, -1112841053) + W(4, 1037270288, 1041702805, -1098675705, 1045728636)
		+ W(5, 1017164043, 999474559, 1031450455, 1034794943) + W(6, 1026910357, -1101939446, 1040827436, 1037079325)
		+ W(7, -1095425143, 1046662664, -1103113592, 1015870568)
		+ W(8, 1023447506, -1114279623, 1048352911, -1115507167) + W(9, 1040518727, 1038294495, -1106032688, 1041969331)
		+ W(10, -1104596348, 1044685961, -1104877098, -1117405559)
		+ W(11, 1032200833, -1104511859, 1039045107, -1111795079);
	sum2 = W(0, -1119788132, 1033659476, -1112158198, 1008462738)
		 + W(1, -1128623485, -1135723434, 1030330775, -1125624097)
		 + W(2, 992683382, -1104347191, 1044081475, 1034564598) + W(3, 1037093866, -1118342628, 1008221186, -1116661382)
		 + W(4, 1018867293, 1020892153, -1090780387, -1098943438)
		 + W(5, 1024702018, 1037085984, -1108937272, 1041747819) + W(6, 1022669528, 1043646320, 1053457206, -1103925357)
		 + W(7, -1094689316, -1130567667, -1111881166, 1006874186)
		 + W(8, 1044098145, 1022003003, 1053806225, 1061138285) + W(9, 1061570617, 1042502677, 1045330453, 1015917808)
		 + W(10, -1102594356, -1105788334, -1097169858, -1089462725)
		 + W(11, -1090351234, -1124000960, -1102638867, -1119261652);
	WS(1059476151, -1123203418);
	sum1 = W(0, -1111725774, 1032359159, -1110577724, -1105544893)
		 + W(1, -1121304930, -1115245634, 1036887935, -1110517831)
		 + W(2, 1035594491, 1034919857, -1111760306, 1046155316) + W(3, 1044165509, 1020829292, 1039852002, -1120384574)
		 + W(4, -1091810916, -1140486487, -1084838663, -1086139015)
		 + W(5, -1095808892, -1096673622, -1127813812, -1090491960)
		 + W(6, 1057461865, 1048140086, 1060577506, 1052038472) + W(7, 1057513991, 1053266340, 1045123672, 1055106407)
		 + W(8, 1016189354, 1034245225, -1104347695, 1027870402)
		 + W(9, -1103056264, -1108853472, 1031021091, -1133152957)
		 + W(10, -1123857235, 1028750247, -1113205590, -1121460986)
		 + W(11, -1148349487, -1113141864, 1036934292, 1011178567);
	sum2 =
		W(0, -1114868977, -1107973502, 1044770988, -1101288212) + W(1, 1025917421, 1028043472, -1111158861, -1123193100)
		+ W(2, 1026556603, -1115461868, -1104823400, -1105554340)
		+ W(3, 1036199790, -1116199065, 1020651575, -1128075734) + W(4, 1004734644, -1092079110, 1059587552, 1045430990)
		+ W(5, 1037874646, -1137785064, -1093651456, -1127404110) + W(6, 1034344926, 1042028492, 1024895663, 1050688149)
		+ W(7, 1047334362, -1116948841, 1044938016, 1042458099) + W(8, 1040708934, -1103991549, 1051421807, -1095880897)
		+ W(9, -1118101029, -1122024357, -1099771430, 1007412048)
		+ W(10, -1131620842, -1105590488, 1029419915, -1114582112)
		+ W(11, 1015496806, -1121536685, -1121478353, -1127827256);
	WS(-1096078190, -1082738059);
	sum1 =
		W(0, 1007239809, -1114850361, -1130257143, -1112210107) + W(1, -1118665957, 1028242343, -1116764258, 1022403683)
		+ W(2, -1108860284, 1046670329, -1103368477, 1045976117) + W(3, 1029494103, 1036298605, 1029804679, -1128309634)
		+ W(4, -1100207850, -1101169270, -1116530972, -1088435015)
		+ W(5, -1092482434, -1090334611, -1105280439, -1099682433)
		+ W(6, 1053165251, 1050939564, 1051252601, 1056131912) + W(7, 1045571555, 1053021861, 1035862579, 1038809821)
		+ W(8, -1112013420, -1126100266, -1112810720, -1124484747)
		+ W(9, 1041969097, 1032260218, 1044490698, -1114977769)
		+ W(10, -1115685558, -1124400725, -1112871192, -1117830909)
		+ W(11, 1031308937, -1143992478, 1037078646, 1016808747);
	sum2 = W(0, -1133820219, -1147891684, -1127336652, -1127200453)
		 + W(1, 1020736496, 1001166860, 1022486646, -1135690985) + W(2, 1027229337, 1032424255, -1137665638, 1045946307)
		 + W(3, -1116510358, -1145031593, -1116471963, -1126621635)
		 + W(4, -1115513384, -1107406978, 1037916056, -1096925824)
		 + W(5, 1031285965, -1138759126, 1020254812, -1122394148)
		 + W(6, 1007940354, -1125237780, 1044701152, 1067148595) + W(7, 1076670751, 1039470145, -1109537872, 1025436583)
		 + W(8, -1156542700, 1031863482, -1113898133, 1048747828)
		 + W(9, -1101339101, -1070343554, -1082365934, -1107321525)
		 + W(10, 1020775992, 994071912, -1127018949, -1115116116)
		 + W(11, -1122694416, -1106720041, 1034791139, 1039293842);
	WS(1056919406, -1123699093);
	sum1 = W(0, -1153021483, 1016658279, -1169964908, -1131540465)
		 + W(1, -1116724456, 1018808083, 986184318, 1026972628) + W(2, 985933670, -1142160193, 1032391598, -1109380555)
		 + W(3, -1112807501, -1115139838, 1023499017, -1119658051)
		 + W(4, -1089586019, -1106728023, -1095447822, -1095937215)
		 + W(5, -1092279079, -1105250414, -1104943256, -1093497009)
		 + W(6, 1058308826, 1043832952, 1054485203, 1051425640) + W(7, 1057168451, 1053123845, 1034402292, 1056025192)
		 + W(8, -1122912091, -1111941676, -1114359010, 1038539876)
		 + W(9, -1129000267, -1105627696, 1011544866, -1129701482)
		 + W(10, -1130942473, -1162334614, -1115887538, 1035573952)
		 + W(11, -1120065804, 1037216107, -1114397383, 1031803900);
	sum2 = W(0, 1034281368, -1126716121, -1121241308, 1045372780) + W(1, 1035929285, 1047600787, 1004087438, 1041718259)
		 + W(2, -1104410341, 1032410612, -1087414339, -1068615761)
		 + W(3, -1067644471, -1091405946, -1118166494, -1097556864)
		 + W(4, 1018060402, 1017706532, 1061712823, 1078313037) + W(5, 1079888634, 1048822788, 1023636550, 1035128990)
		 + W(6, -1138447737, -1115589617, 1021983592, -1100339818)
		 + W(7, -1123293195, 1030149270, -1120625820, 1021734756) + W(8, 994323516, 1029627322, -1133709215, 1015111478)
		 + W(9, 1023885100, -1124744731, 1010097407, 1009567515)
		 + W(10, -1140256393, -1133676977, 1012505315, -1130902073)
		 + W(11, 1028720332, -1123320040, 1022959192, -1136405679);
	WS(1057577783, -1116545908);
	sum1 = W(0, -1140559047, -1119858755, 1001413734, 1019558160)
		 + W(1, 1027838711, -1123065945, -1133184076, -1116764451)
		 + W(2, 1023488522, 1007841757, -1099448121, -1135636631)
		 + W(3, -1106014610, -1112832085, -1132115376, 1007686986)
		 + W(4, 1031631673, 1034355893, 1034820815, -1095265297) + W(5, -1133110549, 976310772, 1031909175, 1033492939)
		 + W(6, -1127758170, -1102068668, -1139646818, 1043309332)
		 + W(7, 1058446926, 1018622064, 1033516923, 1033353766) + W(8, 1037581685, 1038802963, 1020321573, -1118918103)
		 + W(9, -1104027725, -1110623851, -1124259695, -1114622946)
		 + W(10, -1129099776, 1023940956, 1023108226, -1133216315)
		 + W(11, 1027058075, -1123708581, 1025545342, -1118432359);
	sum2 = W(0, -1139693312, 1036960926, -1143311649, 990661185) + W(1, 1015972640, 1000525745, -1129692664, 1028832752)
		 + W(2, -1124752720, -1121090060, -1099787410, -1112556974)
		 + W(3, -1123282486, -1104610584, 1028371280, -1104217347)
		 + W(4, -1098950560, -1103693150, 1033289622, 1052753541)
		 + W(5, -1106573325, 1031872996, -1115662969, -1115847157)
		 + W(6, 999696497, 1034222778, -1104157082, 1058657457) + W(7, 1042484509, 1044261031, 1026599244, 1041506121)
		 + W(8, -1111434581, -1119707404, 1018041096, -1108624084)
		 + W(9, -1111132399, -1121815492, 1018446608, -1129135268)
		 + W(10, 1026280044, 1014405392, -1121205834, 1023217352)
		 + W(11, 1005957425, 1017712752, -1139874592, 1010211304);
	WS(1063874743, -1123600943);
	sum1 = W(0, 1026726381, 1005084141, -1121313992, 1022502021) + W(1, 1010678471, 1012880846, 1016038684, 1031948511)
		 + W(2, -1110972995, 1029034162, 1029564141, 1019350337)
		 + W(3, 1021423943, -1112342611, 1036724585, -1096649610)
		 + W(4, -1088392527, -1096434085, -1088422197, -1089197156)
		 + W(5, -1089730182, -1099324833, -1105649226, -1102131796)
		 + W(6, 1060534134, 1052968261, 1061531727, 1048937234) + W(7, 1053585019, 1049533342, 1044791660, 1047748258)
		 + W(8, -1131352649, -1125442370, -1111100967, 1007055431)
		 + W(9, -1124123103, 1037169096, -1119334386, 1048887628)
		 + W(10, 1017113381, 1023149165, -1121647548, 1028622922)
		 + W(11, -1132301739, -1122598880, 1017220849, -1134858375);
	sum2 =
		W(0, 1041516351, -1114001722, 1031962338, -1127882717) + W(1, 1024371132, -1116893380, -1137233618, 1035584360)
		+ W(2, -1098661524, -1113317539, 1041960143, -1113172562)
		+ W(3, 1057245216, -1108932190, 1040530840, -1090505328)
		+ W(4, 1065773241, 1066164852, -1094243603, -1071023147) + W(5, -1087722937, 1043021464, 1059923771, 1062948018)
		+ W(6, 1067471192, 1062194047, -1131590099, -1071391818) + W(7, -1082288010, 1036914992, 1056604249, 1065534266)
		+ W(8, -1095722385, 1029392016, 1045112423, 1027735196) + W(9, 1047570295, -1110460182, 1008215114, -1096088381)
		+ W(10, 1025030832, 1015621429, 1033273068, -1106774969)
		+ W(11, 1021784721, -1147670187, -1157997580, 1025226110);
	WS(-1081605212, 1037230241);
	sum1 = W(0, -1129286954, -1127382348, -1114123448, -1119205995)
		 + W(1, -1116053850, -1114061454, 1024011222, -1165173963)
		 + W(2, -1115600951, -1127078325, 1045220821, 1032978341) + W(3, 1031622828, 1039357911, 1020277751, 1026874614)
		 + W(4, -1139829872, 1037397159, -1103957592, 1057561887)
		 + W(5, 1057799156, -1103125195, 1035843369, -1159950147)
		 + W(6, 1042245092, -1101819637, 1057239854, -1089716883)
		 + W(7, -1088291628, -1162281827, -1111135597, -1144308089)
		 + W(8, -1130516890, 1025459530, -1098019463, 1040837167)
		 + W(9, 1039979404, -1123433113, 1008116332, -1115664788)
		 + W(10, -1191245347, -1140137724, -1135821456, -1153142562)
		 + W(11, -1123070334, -1115244132, 975751222, -1121723210);
	sum2 = W(0, -1129847377, -1132201467, -1111059277, 1032250249)
		 + W(1, 1003251981, -1175110606, -1119100754, 1007928974)
		 + W(2, 1027890930, -1115667911, -1109124506, -1115518668)
		 + W(3, -1131706033, 1033851379, 1008685286, -1130851063)
		 + W(4, 1045384717, -1139027758, 1062718876, -1088514518)
		 + W(5, 1043614591, -1096199608, 1038009999, -1126833063)
		 + W(6, -1131041629, -1086235324, 1071241567, -1104078593)
		 + W(7, -1091065468, 1021865867, -1113376611, -1120766781)
		 + W(8, -1118537275, 1015945835, -1090110249, 1050303031)
		 + W(9, -1130925231, 1030828678, -1128909271, -1121346672)
		 + W(10, -1129495121, 1022067627, -1139816838, -1109320206)
		 + W(11, 1035917053, -1140186118, 1027374356, -1130315761);
	WS(1048635758, -1111558989);
	sum1 =
		W(0, -1116715915, 1007517554, -1125319757, -1130676803) + W(1, 1032051720, -1122176818, 1019813529, -1125995833)
		+ W(2, -1114167026, -1144951432, 1032434734, -1116349759) + W(3, 1007313161, 1037795522, 1011561671, 1022555096)
		+ W(4, 1019884197, -1100411873, -1082609609, -1099356457)
		+ W(5, -1114189151, -1098216348, -1118483848, -1115419480)
		+ W(6, 1046236914, 1042364482, 1057088310, 1060062511) + W(7, -1105629450, 1032549225, -1156935944, 1017135051)
		+ W(8, 1023679491, 1030303424, 1025882348, 1027068912) + W(9, 1046455412, 1037080648, 1024380849, 1020138940)
		+ W(10, -1123924777, -1115625243, 1018952757, -1117219752)
		+ W(11, -1128015465, -1117338239, 1001454266, 1015509889);
	sum2 = W(0, 1017200252, -1128076598, 1020177744, 1027061114)
		 + W(1, -1120062015, 1007295183, 1005463470, -1120999608)
		 + W(2, 1032764106, 1032749056, 1042154489, -1091917968)
		 + W(3, -1115647155, -1109350747, -1136438311, -1152745757)
		 + W(4, -1100965710, 1036328960, -1079875623, 1069362278)
		 + W(5, 1041923814, -1121245377, 1023734232, -1115720719)
		 + W(6, -1120952053, -1105592489, -1093732085, 1053281179)
		 + W(7, 1053015354, 1023497366, 1044015507, 1040619345) + W(8, 1023440400, 1037836738, -1110726007, -1110949820)
		 + W(9, -1097734576, 1029656316, -1107014120, 1039138178)
		 + W(10, 1026555164, -1121478225, 1032334674, 1004458190)
		 + W(11, 1030547292, -1115087241, 1024950244, -1107079388);
	WS(1057226679, -1099093504);
	sum1 = W(0, -1117743115, -1111361838, -1142218540, -1115584496)
		 + W(1, -1144474236, -1112915081, -1118048876, -1124754680)
		 + W(2, -1106860569, -1097721634, 1017711998, -1098477656)
		 + W(3, 1017808579, -1127808199, -1110778360, 988685674) + W(4, 1059123761, 1043835217, 1054886149, 1036645937)
		 + W(5, -1096319852, -1102898152, -1108186916, -1103594844)
		 + W(6, -1116606854, -1113320356, -1098795498, 1036044245)
		 + W(7, 1058878095, 1054951826, 1042821748, 1057715322) + W(8, -1117312579, 1021938430, 1024346219, -1113074392)
		 + W(9, -1113306631, -1104150268, -1109837016, -1104945799)
		 + W(10, -1126837697, -1108681130, -1128001843, -1126342351)
		 + W(11, -1145404316, 1022603516, -1113519979, -1166667748);
	sum2 =
		W(0, 1017552406, -1121365003, 1024315197, -1126393870) + W(1, 1006096662, 1026122801, -1115019758, 1010820131)
		+ W(2, -1115134458, -1113297695, -1121331284, 1034056828)
		+ W(3, -1116036592, -1122098200, -1138309587, -1114451237)
		+ W(4, -1123239700, 1033578978, 1032104202, -1122610502)
		+ W(5, 1042239151, -1128246386, -1130645774, 1021632898) + W(6, 1040415751, -1119377084, 1033268884, 1042552247)
		+ W(7, 1014688747, 1038912262, 1011328923, 1013103251) + W(8, 1024802817, -1140510683, 1031096569, 1027588477)
		+ W(9, -1116363642, -1106292650, -1119712705, -1106135611)
		+ W(10, -1116030864, -1154029132, -1127078294, -1123710517)
		+ W(11, -1142638070, 1002524342, -1123496021, 1026182445);
	WS(-1108758968, -1120615143);
	sum1 =
		W(0, 1007512449, -1118729201, 1033236958, -1188181540) + W(1, 1032455763, -1139132956, -1126666947, 1028445809)
		+ W(2, 1043847294, -1115009907, 1038269372, -1103491829) + W(3, 1026842103, 1028990457, -1112992067, 1045480960)
		+ W(4, 1041722714, 1047642150, 1052029054, 1056274631) + W(5, 1057598894, 1044856958, 1049081300, 1008203541)
		+ W(6, -1089504654, -1097300100, -1092318719, -1092329088)
		+ W(7, -1088834696, -1094694701, -1102944265, -1095636207)
		+ W(8, 1035899020, 1024857813, 1041772976, -1115586563) + W(9, 1037648114, 1028932916, 1031373190, 987483733)
		+ W(10, 1021562716, -1157490338, 1033997944, -1127937658)
		+ W(11, 1034853541, -1139535439, 999073631, 1033314299);
	sum2 =
		W(0, 1022601823, 1027503424, -1114440342, 1031020236) + W(1, -1115479573, 1028798660, -1137878778, 973255146)
		+ W(2, -1119857460, 1016942723, -1113768249, 1049278985) + W(3, 1023747258, 1008539869, 1030670036, -1124354630)
		+ W(4, -1099325942, -1112391205, 1050839307, -1097330938)
		+ W(5, 1019565806, -1108724816, -1143955309, -1115374863)
		+ W(6, -1068582801, -1076271776, 1067690352, 1077639092) + W(7, 1061065209, -1120523343, 1002861982, 1029925423)
		+ W(8, 1035739756, -1104095012, 1026494027, 1047876791) + W(9, 1016405011, -1115660355, 1022661839, 1033007729)
		+ W(10, 1015907333, 1016973548, -1122697579, 1015148595)
		+ W(11, -1106941761, 1032414836, -1126087053, -1124658022);
	WS(-1125070560, -1096513533);
	sum1 = W(0, -1112401838, -1141896047, -1114813980, -1125005414)
		 + W(1, 1026386210, -1115056418, 1012901881, -1125623196) + W(2, 1032850683, 1035442769, 1027743049, 1036941992)
		 + W(3, -1104378805, 1037833707, 1022681350, 1033887999)
		 + W(4, -1111199410, -1105684773, -1093508577, -1099350541)
		 + W(5, 1060063436, -1112618105, 1035294797, 988362813) + W(6, 1046757622, 1047296038, 1061969278, -1107426238)
		 + W(7, -1092774776, 1028130403, -1127381572, 1016528878)
		 + W(8, 1033951818, 1013771590, -1100008383, 1023589122)
		 + W(9, -1122038496, -1110298148, 1030080099, -1106008748)
		 + W(10, -1110786345, -1113414691, -1131095256, -1114443933)
		 + W(11, 996299870, -1117830096, -1140100259, 1014753608);
	sum2 = W(0, -1128089453, -1110645236, -1130916401, 1026446699)
		 + W(1, -1115610756, 1032679495, -1114433002, -1123355757)
		 + W(2, 1024340419, 1043920397, -1129344777, 1009781987) + W(3, -1102796808, 1037523581, 1023912055, 1026431795)
		 + W(4, -1102023306, -1114712453, 1028225499, 1057874897)
		 + W(5, 1052660862, -1102216434, -1127455825, -1128264837)
		 + W(6, -1103821003, -1097377481, 972074333, 1059140954)
		 + W(7, 1038144249, -1107293486, 1006589878, -1102041035)
		 + W(8, 1043342989, -1109265540, -1100613575, -1103696793)
		 + W(9, -1116201867, -1131885037, -1105206442, -1127587329)
		 + W(10, -1119644228, 1026656603, 1034952995, 1032660433)
		 + W(11, -1130501689, 1029362471, 1013212643, 1005668278);
	WS(1049867118, 1034735186);
	sum1 = W(0, -1127774262, -1117373036, 1031064438, -1112922680)
		 + W(1, 1012648832, -1132535687, -1120670652, -1140537009)
		 + W(2, 1029333619, -1123455456, -1105261096, -1096141178)
		 + W(3, -1120189874, 1024540628, -1138107141, 1000234461)
		 + W(4, 1019113028, 1040322517, 1040279186, -1101685436) + W(5, 1044944438, -1121818673, 1035373868, 1032620736)
		 + W(6, 1024964758, 1032014380, 1048588372, 1050135703) + W(7, 1034886579, 1040490120, 1016312768, 1034120602)
		 + W(8, 1007980364, 1019723167, -1114399774, -1100797936)
		 + W(9, -1113398479, -1150021355, -1128775361, 1008873398)
		 + W(10, -1121402761, -1118901061, -1126411220, -1110911420)
		 + W(11, 1019321608, -1114680743, -1121234663, -1121766352);
	sum2 =
		W(0, -1161289046, 1020587590, 1029682388, 1031608572) + W(1, -1117304231, -1129471662, 965398246, -1134569151)
		+ W(2, -1111556088, -1127668568, -1095922552, -1092239431)
		+ W(3, -1165373610, -1120133906, 1007233453, 1019046119) + W(4, 1038429491, -1130067243, 1050898724, 1058359401)
		+ W(5, 1040200303, 1044552317, -1132308256, 1031851372) + W(6, 1024158411, 1018324827, -1123472030, -1093717514)
		+ W(7, -1118204561, -1112781150, 1017795291, -1120826542)
		+ W(8, -1123794133, 1035096674, -1142905112, 1042534485)
		+ W(9, -1137719883, -1136196985, 1027736448, -1128305748)
		+ W(10, 1016121349, -1127328688, -1126947701, -1126252937)
		+ W(11, -1122434117, -1137031592, -1121369248, -1162116006);
	WS(1063598519, 1040709546);
	sum1 =
		W(0, 989424433, 1025004011, -1117397173, 1010227902) + W(1, -1116859551, 1035862832, 1012428267, 1028295307)
		+ W(2, -1129964132, 1018517694, 1036280904, 1042042835) + W(3, 1025484624, -1108371497, 1028794752, -1105766207)
		+ W(4, -1092181324, -1096845618, -1092686069, -1082263275)
		+ W(5, -1087946945, -1124000752, 977020321, -1108973663) + W(6, 1056340507, 1052096915, 1055848084, -1117189370)
		+ W(7, 1053023013, 1053676604, 1044581128, 1048031389) + W(8, -1140166214, -1124688156, 1027380346, 1041673920)
		+ W(9, 1025279965, 1021321051, -1125256895, 1035434166) + W(10, 1007420926, 1025298052, -1114706068, 1030527159)
		+ W(11, 1004378644, -1130325786, 1025029349, 1015026205);
	sum2 = W(0, -1128989779, -1132752301, -1121498089, -1112228563)
		 + W(1, 1023519830, -1111737432, 1023675120, -1134051546) + W(2, 1040099849, 992269838, 1034828720, 1034859451)
		 + W(3, 1034954038, -1122349299, 1019899084, -1112348174)
		 + W(4, -1100874000, 1034251701, -1104384455, 1044543345)
		 + W(5, 1046406891, 1028583216, -1114022376, 1040182737)
		 + W(6, 1021993174, -1130867684, -1113539068, 1053848304)
		 + W(7, -1104908283, -1100179639, -1111378604, -1097476412)
		 + W(8, -1130783901, 1034483450, -1122004711, 1016645052) + W(9, 1032774629, 1016210650, 1033297067, 1025418184)
		 + W(10, 1011642260, -1123860313, 1016725938, -1122625223)
		 + W(11, 1011006880, -1114528083, 1021084026, -1141294629);
	WS(1052377710, -1116561061);
	sum1 =
		W(0, -1122160137, -1112995181, 1021266631, 1017022397) + W(1, 1032809511, -1105019076, 1019774100, -1119221338)
		+ W(2, 1026711393, 1046449684, -1094207935, 1051777944)
		+ W(3, -1105978112, 1045042328, -1140860791, -1140595366)
		+ W(4, 1034438088, -1103073456, 1059878180, -1091454284)
		+ W(5, -1108523806, -1137740923, -1113848547, 1015748571)
		+ W(6, 1023922180, -1112523427, 1031595583, -1107259466) + W(7, 1059633699, -1094439010, 1048809290, 1019553093)
		+ W(8, -1115207840, 1036366239, -1096200621, 1043506315)
		+ W(9, -1105628259, 1043730779, -1114298535, -1117446555)
		+ W(10, 1014756539, -1110629817, 1025340632, -1122333286)
		+ W(11, -1126028515, -1114494718, 1024493780, -1121208702);
	sum2 =
		W(0, -1125003387, -1110204990, 1008672566, -1110854180) + W(1, 1015432805, 1007507570, -1129875419, -1145172348)
		+ W(2, 1023545558, -1122326332, 1039271760, 997586352) + W(3, 1043658401, -1126010948, -1128126180, 1018354299)
		+ W(4, 1001356924, 1049948311, -1104177316, -1099440370)
		+ W(5, -1101604747, -1112581048, 1034699764, -1118892801)
		+ W(6, 1019826271, -1106041547, 1040609653, 1057375034) + W(7, -1098469549, 1041033112, -1108980340, 1026776081)
		+ W(8, 1029018751, -1122275300, 1017003703, -1099421810)
		+ W(9, 1052007058, 1018898909, -1118843549, -1123423040)
		+ W(10, -1114113554, 1028296019, -1143932072, -1122149120)
		+ W(11, -1118594118, -1129527698, 1031512617, -1147650596);
	WS(1066846108, 1044745002);
	sum1 = W(0, 1019372186, 978233216, -1129136976, 1025331363) + W(1, -1142297744, 1015116199, 1015645340, 1016287548)
		 + W(2, 1049403789, -1107121557, 1041504923, -1134682116)
		 + W(3, 1039399714, -1122699462, -1121336819, 1026221102) + W(4, 1042475733, 1051348497, 1048713517, 1054698948)
		 + W(5, 1049146911, 1058118606, 1046729314, 1056609718)
		 + W(6, -1091781177, -1100692098, -1091573825, -1089263023)
		 + W(7, -1091452887, -1090043533, -1102394372, -1091564925)
		 + W(8, -1124410122, 1039801345, 1032893815, 1040511932)
		 + W(9, -1146055296, 1032222216, -1115550793, -1107840672)
		 + W(10, 1015897062, 1009376476, -1126291000, 1006187856)
		 + W(11, 1016897132, 1012743170, 1010428515, 1000566800);
	sum2 =
		W(0, -1121498998, 1025173682, -1127952317, -1123064681) + W(1, 1031325102, 1031547392, -1116804726, 1013263415)
		+ W(2, 1040076187, -1110698495, 1046879062, -1114452496)
		+ W(3, 1037259271, -1113826794, -1113826560, -1114840697)
		+ W(4, 1040991236, 1027215822, -1097422534, -1079622690) + W(5, -1113150532, 1059352243, 1032134129, 1048220488)
		+ W(6, -1097642453, 1032193313, -1089335507, -1070315938)
		+ W(7, -1080614075, 1063284099, 1075195474, 1071802337) + W(8, 1041191639, -1107046015, 1027648922, -1107556506)
		+ W(9, 1040688678, 1044912350, -1107091577, 1050907604)
		+ W(10, -1143069461, -1127878497, 1033858873, 1031644922)
		+ W(11, -1125227083, -1135729999, -1112123781, -1104322253);
	WS(-1083170743, 1032719415);
	sum1 = W(0, 1023701883, 1027723212, -1122560214, 989186599) + W(1, 1018265472, -1118377474, 1034616094, -1143849572)
		 + W(2, -1115388842, 1037576352, 1028066352, 1034436696) + W(3, 1046871436, 1036384970, 1041769608, 1033711598)
		 + W(4, -1095142736, -1104329709, -1093573195, -1091782714)
		 + W(5, -1090370147, -1088395265, -1092608855, -1085234190)
		 + W(6, -1131637740, 1047136718, 1050356544, 1058921626) + W(7, 1057401704, 1046747968, 1048250192, 1051022467)
		 + W(8, 1043889005, -1114738168, 1032119470, 1035779088) + W(9, -1119260798, 1026791695, 1007978244, 1035213927)
		 + W(10, 1012236805, -1143133226, -1126174356, 1024911192)
		 + W(11, 1033076018, -1122725807, 1033024419, 1028803056);
	sum2 =
		W(0, 1040592912, -1148866748, 1032765896, -1113675298) + W(1, 1035431068, -1111525482, 1031171080, -1111672592)
		+ W(2, -1091007599, 1043419584, -1111893630, -1100951705)
		+ W(3, 1030657616, -1123081200, 1009914590, 1048594219)
		+ W(4, -1122569720, -1102576481, -1114969246, 1060370086)
		+ W(5, 1018512847, -1112438148, 1033713452, -1120657004) + W(6, 1061904811, -1110256028, 1042199718, 1060838438)
		+ W(7, 1061366749, -1086083341, 1029235040, -1090315205)
		+ W(8, -1096410255, -1106770914, -1108992598, -1088153932)
		+ W(9, -1091610254, 1039676388, -1104419583, 1040642594)
		+ W(10, -1107753434, 1043044202, -1138614142, -1121677972)
		+ W(11, 1049599377, -1117594428, -1154941432, 1041324320);
	WS(-1087374135, 1068569819);
	sum1 =
		W(0, 1034522569, -1114460210, 1040675195, -1156322949) + W(1, -1126356143, 1038944141, -1123272884, -1147588893)
		+ W(2, 1036038485, -1134485343, 998999958, -1102898978) + W(3, 1032174021, 1032843110, -1112707068, 1041667373)
		+ W(4, 1051494643, 1048850073, 1055860825, 1058980799) + W(5, 1050366134, 1048730421, 1043911796, 1049367775)
		+ W(6, -1092286050, -1097395434, -1093950865, -1086427635)
		+ W(7, -1097745188, -1098221875, -1095510475, -1093210118)
		+ W(8, 1024631242, -1155697773, 1034953465, 1036357020) + W(9, -1115522123, 1020968428, 1032316940, -1134843155)
		+ W(10, -1124293233, 1035227470, 1022306499, -1115248568)
		+ W(11, 1025097211, 1020281868, -1112095119, 1003691067);
	sum2 =
		W(0, 1036982689, -1109420523, 1038171016, -1114883799) + W(1, 1032698755, 1023400751, -1119043865, 1034471555)
		+ W(2, -1101176821, 1040154700, -1103427381, 1011961296)
		+ W(3, -1115041464, -1112162319, -1114657793, -1117007917)
		+ W(4, 1032029724, 1008871494, 1053639476, -1094943648) + W(5, 1046242469, 1015257266, 1018562568, 1031877719)
		+ W(6, 1031712503, 1051308638, -1103617514, -1090481186) + W(7, 1048516585, -1110670159, 1026474691, 1044794303)
		+ W(8, -1095262307, -1089037290, -1077227331, -1077304111)
		+ W(9, -1075605762, -1086532256, -1115849955, -1110424851)
		+ W(10, -1135236510, 1036178124, 1056219784, 1063074442)
		+ W(11, 1070767205, 1074120487, 1066414901, 1052188053);
	WS(-1094340206, 1025238393);
	sum1 = W(0, 1025401267, -1120317764, 1029217422, 1017691154) + W(1, 1015273200, 1006374863, -1149759301, 1023921508)
		 + W(2, 1041212259, -1123694073, 1040075594, -1128349902)
		 + W(3, 1030937834, 1030337996, -1112880429, 1048792866) + W(4, 1051626551, 1044638395, 1051991350, 1049159169)
		 + W(5, 1055056667, 1045537234, 1047952828, -1109761292)
		 + W(6, -1087771683, -1099303356, -1089805402, -1090474853)
		 + W(7, -1089928234, -1095611655, -1103717662, -1097665994)
		 + W(8, 1026720107, 1027277160, 1042793877, 1032035372) + W(9, 1038797403, 1028636183, 1034683820, 1024357062)
		 + W(10, 1024873417, 1003045609, 1025974530, -1140916353)
		 + W(11, 1026491292, -1125445197, 1018728702, 1024842472);
	sum2 =
		W(0, 1016272983, -1125328223, 1019432157, -1136495190) + W(1, 1024638490, -1122054341, 1016158573, -1137665190)
		+ W(2, -1117564089, 1007328518, 1038058236, -1106032359)
		+ W(3, 1036423350, -1129861056, -1141592892, 1032273458)
		+ W(4, 1054344808, 1047318060, -1095657702, -1084625245)
		+ W(5, -1124414562, 1036648948, -1120282232, 1033205457)
		+ W(6, 1082928383, 1074423709, -1074337637, -1066615612) + W(7, -1087090886, 1034359725, 999766988, -1114245215)
		+ W(8, 1043627742, 1037006400, 1040243063, -1106132294) + W(9, -1119023275, 1004167460, 1002865564, -1113153751)
		+ W(10, -1113989008, -1137080694, 1017883877, -1126758430)
		+ W(11, 1040797418, -1113361096, 1023713345, 1022755221);
	WS(-1098231918, 1035887052);
	sum1 = W(0, 1007686525, -1112046456, -1136641001, 1025581173)
		 + W(1, -1121240420, -1165513922, -1114143760, -1123656209)
		 + W(2, -1117693688, -1119004197, -1104788790, -1092353842)
		 + W(3, -1104580134, -1146015939, -1162096818, -1117522176)
		 + W(4, 1048268202, 1036810732, 1055375147, 1069647932) + W(5, 1052170270, 1020096363, -1125578169, 1031911554)
		 + W(6, -1105099271, -1097653932, -1098720398, 1066085926)
		 + W(7, -1093227035, -1123833253, -1107379122, -1130540403)
		 + W(8, -1110112236, -1130249512, -1106155488, -1091717545)
		 + W(9, -1110987409, -1108464746, -1156567122, -1106840908)
		 + W(10, 1016554315, -1115219957, -1142876018, -1143806946)
		 + W(11, -1113561092, -1123809427, -1113074326, -1120698772);
	sum2 = W(0, -1125891647, -1139529830, -1127048511, -1119620679)
		 + W(1, 1015042367, -1133002574, 1001053676, -1136336990)
		 + W(2, -1121500935, 1033326245, -1110257678, 1033808587)
		 + W(3, -1152963927, 1023704513, -1125968895, -1159911790)
		 + W(4, 1021750179, -1133323886, 1040835222, 1061147710)
		 + W(5, -1110018076, 1035246842, -1123027527, -1144777900)
		 + W(6, 1017645919, -1167588957, -1108825416, 1055027509)
		 + W(7, -1105425292, -1090179180, 1035235033, -1104047270)
		 + W(8, -1130193055, 1018366499, -1144215516, 1035778772)
		 + W(9, -1105010302, 1019226535, -1113493000, -1137733870)
		 + W(10, -1118741587, 1021086319, -1113356630, -1123951235)
		 + W(11, -1124596863, 995355927, -1135606974, -1141401292);
	WS(-1081201436, -1083122818);
	sum1 = W(0, 1024396773, 1040103323, -1104054160, 1042893967)
		 + W(1, -1121710378, -1122190892, 1038539251, 1020559724)
		 + W(2, -1118776317, -1121204906, 1048678635, -1101546374)
		 + W(3, 1036673102, -1112386175, 1022162966, -1111471555)
		 + W(4, -1090317103, -1098486564, -1094484293, -1101075087)
		 + W(5, -1095873942, -1099326495, -1101153544, -1095630377)
		 + W(6, 1056470156, 1048677796, 1048629197, 1052113969) + W(7, 1033707976, 1057451847, 1027207978, 1053998976)
		 + W(8, -1120183581, -1105729174, 1032093347, 1048228642)
		 + W(9, 1044099610, -1102747354, -1114063013, -1125760751)
		 + W(10, -1124728406, 1010393788, -1105359341, 1048587688)
		 + W(11, -1107414311, 1034642220, -1109685144, 1033222029);
	sum2 =
		W(0, -1130151079, -1128601535, 1016586775, -1116462462) + W(1, 1006316053, -1136401487, -1134837023, 1015531121)
		+ W(2, 1029357099, -1139320303, 1016703563, 1036545095) + W(3, 1027702761, -1115282656, 1025282364, -1128863347)
		+ W(4, -1141051917, 1027307392, 1040480663, -1084177500) + W(5, 1027514935, 1033882273, 975470826, 1013565163)
		+ W(6, -1126143047, -1124015138, -1090482710, -1061542668)
		+ W(7, -1081711054, 1042416533, -1107083018, 1030037156) + W(8, -1138853383, 1026568428, 1051692940, 1087807110)
		+ W(9, 1065457143, -1101742731, 1035528582, -1123914522)
		+ W(10, 1016378649, -1128887123, 1024508650, -1109325640)
		+ W(11, -1115450794, 1030137534, 1016609727, -1122133136);
	WS(1056806766, 1019813151);
	sum1 = W(0, -1109922347, 1027672232, -1113027385, -1106442907)
		 + W(1, -1119504732, -1127683323, 1015134384, -1122196904)
		 + W(2, 1038862168, -1098777292, 1057340869, -1131946518)
		 + W(3, 1048903346, -1100586740, 1027127869, -1136830686)
		 + W(4, -1094336356, 1025923920, -1089223672, 1049099726)
		 + W(5, -1102142547, -1122538541, -1099585557, -1100472159)
		 + W(6, 1045176100, 1046907893, 1028090813, 1060367739) + W(7, -1102839017, 1052174932, 1024110556, 1047790604)
		 + W(8, 1023835087, -1097985673, 1044113854, 1010151151)
		 + W(9, 1051267347, -1093148714, 1029024221, -1137237669)
		 + W(10, -1117706029, -1143840774, -1111671123, 1025756788)
		 + W(11, -1111600768, 1040843731, -1107564881, -1131252120);
	sum2 =
		W(0, 1016054025, -1116580030, -1128856269, 1024017790) + W(1, -1120027976, 1003808451, -1120561807, 1020365697)
		+ W(2, -1119367753, 1033363716, -1107794961, -1129548157)
		+ W(3, 1034251322, 1039517400, 1019337653, -1174223189) + W(4, -1115811972, -1119979151, 1046175546, 1051115205)
		+ W(5, -1095340379, -1127431641, 976018325, -1148320619)
		+ W(6, 1024987046, -1114756690, -1100926142, 1048732221)
		+ W(7, 1044324276, -1104827086, -1139095561, -1138276477) + W(8, 1016843613, 1025664850, 1028330842, 1029232538)
		+ W(9, -1105635461, 1042504965, -1118828309, -1117203320)
		+ W(10, 1007599121, -1120202841, -1144919563, -1123931557)
		+ W(11, -1122027017, -1118580981, 1016896817, 1009819353);
	WS(1067549148, 1061168738);
	sum1 = W(0, -1136860560, 1019396970, 1034693791, 1031876061)
		 + W(1, -1126960466, 1026075051, -1129065354, -1125694250)
		 + W(2, 1041916271, -1102760394, -1100215160, -1127917744)
		 + W(3, 1038708237, 1042570959, 1024557450, -1114527138) + W(4, 1043173595, 1046914407, 1063664325, 1041579695)
		 + W(5, -1084953669, -1099553438, -1111656016, 1036161892)
		 + W(6, -1099729080, -1097589844, -1085101004, 1044764001)
		 + W(7, 1062969721, 1046958554, 1031927572, -1129394940) + W(8, 1028345500, 1036811500, 1044130369, -1111608196)
		 + W(9, -1096862061, -1104831702, -1121741642, 1028864534)
		 + W(10, -1117900922, -1118556558, -1118557363, -1148658183)
		 + W(11, 1028601293, 1014732126, 999719805, -1111432076);
	sum2 =
		W(0, 1037988572, -1109648154, -1115314649, -1110735622)
		+ W(1, 1029414023, -1115532881, -1114457629, -1123631499)
		+ W(2, -1097183834, -1096035348, -1106718097, 1044362532)
		+ W(3, 1044653749, -1118097482, 1036871139, 1035597348) + W(4, -1096111302, 1046143856, 1065688064, -1100541529)
		+ W(5, 1022961930, 1041170408, -1121640520, -1109551474)
		+ W(6, -1112255513, 1047451704, 1048785443, -1089624797)
		+ W(7, 1040629892, -1135819985, -1109975688, 1030316886)
		+ W(8, 1025606252, -1109281762, 1025033440, -1124926742) + W(9, 1024229044, -1109992198, 1007526703, 1031542857)
		+ W(10, -1131066844, 1021094187, -1118872350, 1035314838)
		+ W(11, -1132267648, 1004115214, -1128646118, -1117895342);
	WS(-1090126519, 1034760182);
	sum1 =
		W(0, 1022234099, 987019599, 1021371561, -1125185183) + W(1, 1040030303, 1005824514, 1028122555, -1120592523)
		+ W(2, 1038732905, 1040082783, 1042926010, 1019049563) + W(3, -1101231100, -1108355337, -1115211984, 1035983309)
		+ W(4, -1095221408, -1096833350, -1090005917, 1049172122) + W(5, 1056956325, 1052986466, 1046568014, 1025899358)
		+ W(6, 1049091087, 1049531159, 1052645704, 1048882035)
		+ W(7, -1086324445, -1089320760, -1101798768, -1123937043)
		+ W(8, -1141106060, -1100657291, -1098472859, -1113910991)
		+ W(9, 1041783487, 1033537135, 1037621024, -1125397784) + W(10, -1130848127, 1036771650, 1035488804, 1025403478)
		+ W(11, 1007113098, -1138596020, -1128732298, -1127374557);
	sum2 =
		W(0, 1016736022, 1011977196, -1137999416, 1019963070) + W(1, 1030437859, -1122046802, -1142727409, 1018753414)
		+ W(2, 1032939170, -1102682487, 1037611888, -1102949496)
		+ W(3, 1039010410, -1110345340, -1124097437, -1113761662)
		+ W(4, -1122689775, 1060510561, 1051792579, -1073351999) + W(5, 1059164734, 1062467108, 1031495287, -1101619274)
		+ W(6, -1102551566, 1060805847, 1057985083, -1073393989)
		+ W(7, 1057367527, 1062012989, -1147452225, -1099879364)
		+ W(8, -1122487238, -1122236502, 1036808922, -1103029047)
		+ W(9, 1039165500, -1106860549, -1143421321, 1015482390)
		+ W(10, 1026411789, -1128029215, 1019619350, -1125796177)
		+ W(11, 1024266957, -1119780381, 1024156551, 1016465010);
	WS(-1089242039, -1127205581);
	sum1 = W(0, -1124452989, 1037734344, -1136469606, 1045032037)
		 + W(1, -1131176455, 1029283077, 1038076384, 1029887056)
		 + W(2, 1047404342, -1111320098, -1115981071, 1038279993)
		 + W(3, 1006926037, 1030509432, -1123275877, 1043334248) + W(4, -1086849964, 1001557948, 1055753134, 1059294849)
		 + W(5, 1006841992, 1049404683, 1037635838, 1044156233) + W(6, -1114062493, 998659036, -1096047365, -1107330927)
		 + W(7, -1105936042, -1087265492, -1095492784, -1080260267)
		 + W(8, 1042532510, 1038364441, -1118490271, 1044317529) + W(9, 1035319841, 1043122385, 1027367204, 1053177470)
		 + W(10, 1010360274, 1032729828, 1015888923, -1118190491)
		 + W(11, 1021147727, -1123196402, 1027584778, -1118995315);
	sum2 = W(0, 1029897599, -1114965417, 1025776431, -1121485495)
		 + W(1, -1140617930, -1113546368, 1031651703, -1117524097)
		 + W(2, -1102843967, 1046605828, 1033633995, 1048791648)
		 + W(3, -1104898739, 1031053127, -1108448442, -1108356905)
		 + W(4, 1001547796, 1025076963, -1090433692, 1044097140) + W(5, 1042488362, -1118485295, 1045463546, 1040816680)
		 + W(6, 1049416264, -1100594038, -1096668289, -1117020477)
		 + W(7, -1102246327, 1034926551, 1047237110, 1044694712) + W(8, -1120840401, 1041915682, 1040646462, 1042521794)
		 + W(9, -1112857889, -1109164591, 1015998805, -1109851905)
		 + W(10, -1115391670, 1020641677, -1111492899, 1034331443)
		 + W(11, -1115861875, -1134127978, -1120855845, -1124879769);
	WS(-1081567068, -1085072352);
	sum1 = W(0, 1026202077, 1017630556, 1034866076, -1120073907) + W(1, 990337572, -1122725732, 1016189565, -1135328058)
		 + W(2, 1008391383, -1102096537, -1105309517, -1113888457)
		 + W(3, 1038015146, 1010107993, 1035371298, -1107104879) + W(4, 1043376377, 1035138955, 1062685095, -1088326467)
		 + W(5, -1087780001, -1095652846, -1111927693, -1134788873)
		 + W(6, -1106037014, -1113878797, -1091962582, -1099527071)
		 + W(7, 1065743931, 1048331161, 1035819857, 1033560764) + W(8, -1119432853, 1041401156, 1028045374, 1036249665)
		 + W(9, -1122166240, 1030964177, 1030882915, 1034792920)
		 + W(10, 1015626934, -1112723700, 995954372, -1112822301)
		 + W(11, 1036674595, -1165855255, 1020668626, -1140134473);
	sum2 = W(0, -1101998430, 1034880732, -1111573656, 1034691412) + W(1, 1017688506, 1032207084, 1002612774, 995363580)
		 + W(2, 1025808817, -1110518368, -1090739547, -1098171169)
		 + W(3, 1047617175, -1112107064, 1027687639, 1035291452) + W(4, 1026331301, 1035202798, -1095903349, 1068344140)
		 + W(5, -1085314459, -1108916250, -1113844364, -1111293323)
		 + W(6, 1041383807, 1044537615, 1045506861, 1069658374)
		 + W(7, -1090700374, -1135142667, -1106371211, -1105384559)
		 + W(8, 1033833028, -1096440885, 1030373631, -1094064924)
		 + W(9, -1106284721, -1113568166, 1043762008, -1113615358)
		 + W(10, -1108635033, 1042833515, -1107072548, 1037649108)
		 + W(11, -1117475933, 996218700, -1115713024, 1031725587);
	WS(-1122270064, -1083487436);
	sum1 = W(0, 1022021054, 1000846209, -1120651002, -1133172181) + W(1, 1015175368, 1008528664, 1014262402, 1032206792)
		 + W(2, -1111938972, 1031069285, 1035108132, -1122478547)
		 + W(3, 1022898156, -1109542844, 1003755051, -1099224128)
		 + W(4, -1089129474, -1092279467, -1089405705, -1088959911)
		 + W(5, -1101358829, -1113192731, -1110785838, -1105614817)
		 + W(6, 1061173530, 1053406092, 1061891890, 1046812368) + W(7, 1052509753, 1035774995, 1040815801, 1041852206)
		 + W(8, -1117042135, -1112839626, -1115403968, 1035227362)
		 + W(9, 983155781, 1035355065, -1114859906, 1046440556) + W(10, 990992466, 997371026, -1123767278, -1136588785)
		 + W(11, 1014548513, -1120262163, -1139309996, -1196238920);
	sum2 =
		W(0, 1044179919, 1022028328, 1040258943, -1118974089) + W(1, 1033279863, -1117110809, 1031745329, -1103290765)
		+ W(2, -1111986018, 998943655, -1095034556, -1095846499)
		+ W(3, -1110448374, -1099083231, -1120681553, -1101323001)
		+ W(4, -1080384748, -1088604014, -1104000317, 1073459027)
		+ W(5, -1098039236, 1045892370, -1111672860, 1055006842)
		+ W(6, -1092393621, 1029389095, -1090514887, 1071708766) + W(7, 1012336831, 1049307354, -1100485937, 1051814517)
		+ W(8, 1048581079, 1009323699, 1015383036, -1097133430)
		+ W(9, -1122793353, -1097759856, 1041920736, -1091667564)
		+ W(10, 1031858735, 1021777892, 1024626196, 1024702395) + W(11, 1031448400, 1030521846, 1016567237, 1029007432);
	WS(-1097130350, -1073679750);
	sum1 =
		W(0, -1154560184, 1025389788, -1145657140, 1000633100) + W(1, -1120139600, 1032643785, 1008755251, 1030414749)
		+ W(2, -1142702368, 1008724804, 1035954194, 1046084016) + W(3, 1042008657, -1106616153, 1025929714, -1102859291)
		+ W(4, -1095841490, -1096179481, -1095185831, -1085973126)
		+ W(5, -1089907161, -1096805620, -1098086361, -1107347576)
		+ W(6, 1034517635, 1053502809, 1045830013, 1057148843) + W(7, 1051926551, 1052799826, 1043469780, 1050172789)
		+ W(8, 1044574577, -1112918112, 1042446427, 1025817904) + W(9, 1017272605, -1123577295, -1143679882, 1014891512)
		+ W(10, 992206103, -1143244972, -1122388570, -1139683234)
		+ W(11, 1018417129, 1017209342, 1016358830, 1026775680);
	sum2 =
		W(0, 1021941992, -1140009235, 1026649920, 1025391436) + W(1, 1033557641, -1110654493, -1117894486, 1031221238)
		+ W(2, -1106123822, -1137197699, -1104678389, -1103278668)
		+ W(3, 1049392706, 1026389826, 1046385471, -1107040085) + W(4, 1031547466, 1040410800, -1091687878, -1069452203)
		+ W(5, 1071493698, 1075377385, -1093315115, -1101021764)
		+ W(6, -1135582819, 1048777558, -1102399061, -1086654414) + W(7, 1036526271, 1051671224, 1003979070, 1042747507)
		+ W(8, 1018035752, -1114989513, 1038853959, -1112110740)
		+ W(9, -1155541821, -1119910153, -1130248744, -1119798403)
		+ W(10, 1017098260, -1129449426, -1170697076, -1134437671)
		+ W(11, 1030635558, -1127657747, 1010389927, 1007123883);
	WS(-1110542776, 1046722292);
	sum1 = W(0, -1112464600, 1016022658, 1027765771, 981819586) + W(1, 1026835189, 1025143735, -1111607705, 1024330241)
		 + W(2, 1033517476, -1108629467, -1106997347, -1113497042)
		 + W(3, -1116788199, -1106078850, 1041100086, -1124631714)
		 + W(4, 1047470894, -1133454244, 1053995028, -1100439522)
		 + W(5, -1093531706, 1048713001, -1106135867, -1115421707)
		 + W(6, -1131671638, 1032980471, -1092318054, 1042288212)
		 + W(7, 1061947018, -1121614518, 1012478420, 1041393523)
		 + W(8, 1005087552, -1105826521, 1042584756, -1109105451)
		 + W(9, -1098489206, -1105038597, 977775992, -1114990145)
		 + W(10, -1142745264, 1026603482, -1129658366, 1017901338)
		 + W(11, -1142191304, 1040275689, 1016467704, 1020475210);
	sum2 = W(0, 1031452303, 992881643, 978475180, -1121457613) + W(1, 1034445399, -1130052481, 1032145701, -1116902843)
		 + W(2, -1132232893, -1116591675, 1016124301, -1114931492)
		 + W(3, -1094590847, 1040974964, -1110729382, 1035934107)
		 + W(4, -1109510079, 1032912109, -1114514404, 1032060799)
		 + W(5, 1051504728, -1087149232, 1039284419, 1032317221) + W(6, 1018866101, -1116915567, 1055420465, 1059251768)
		 + W(7, -1088887374, 1044275534, -1114948355, -1104983612)
		 + W(8, 1014551643, 1024567259, -1097097100, -1118272021) + W(9, 1048490818, 1035881493, 1032922179, 1032032409)
		 + W(10, 1032688527, -1114177042, 1042584708, -1109972047)
		 + W(11, 1024892699, -1108606213, -1121421993, -1133789139);
	WS(1059165367, -1104520251);
	sum1 =
		W(0, 1007492796, -1117692608, 1009135144, -1115310467) + W(1, 1014125520, -1113191163, -1129119585, -1118876992)
		+ W(2, -1108628644, 1046236477, -1120534447, 1052736188) + W(3, -1118278150, 1036684740, 1015268651, 1008090175)
		+ W(4, -1117534006, -1094176525, 1053590938, 1041258594)
		+ W(5, 1001540436, -1106455985, -1112388022, -1114551242)
		+ W(6, 1041312427, -1118419948, -1107420459, -1097199722)
		+ W(7, 1055263011, -1100739533, 1040471133, 1020553106) + W(8, -1113108212, 1029454180, -1110779368, 1053879643)
		+ W(9, -1098892966, 1045621277, -1126748266, 1026632706)
		+ W(10, -1124001749, -1113899741, -1131761404, -1114949702)
		+ W(11, 1025063448, -1105125705, -1126282358, -1127494856);
	sum2 = W(0, 1027505664, -1115834059, 1029084872, 1029257304)
		 + W(1, -1128264406, -1138405484, -1118563560, -1127212263)
		 + W(2, -1104527074, 1048986559, -1089420265, -1098414029)
		 + W(3, -1104406791, 1040673804, -1203758566, -1117936348)
		 + W(4, 1034957797, -1098163961, 1051828462, 1053778056)
		 + W(5, 1048509414, -1106881855, -1113115951, -1136870020)
		 + W(6, 1041601252, -1125657446, 1045110551, 1041501740) + W(7, 1041829791, -1119286592, 1045914276, 1022365337)
		 + W(8, -1108054404, 1041896195, -1099714824, -1129563106)
		 + W(9, -1092212913, 1049994472, -1105182054, -1139619400)
		 + W(10, -1122847824, 1034858548, -1116127595, -1170669534)
		 + W(11, 1037831890, -1107117839, 1031508216, -1127498142);
	WS(1064754871, 1064755352);
	sum1 = W(0, -1124996947, -1126765813, -1111973122, 995438583)
		 + W(1, -1131935965, 1011044801, 1017902933, -1117569083) + W(2, 1039345889, 1034558935, 1025078634, 1031530717)
		 + W(3, -1102805216, -1112086641, -1108706152, -1125705364)
		 + W(4, -1096693846, -1096907004, -1092723587, 1042155040)
		 + W(5, 1055052309, 1050402072, 1045488762, 1036105095) + W(6, 1051509189, 1048609181, 1055455058, 1038916133)
		 + W(7, -1085470304, -1096310694, -1110967031, -1114430562)
		 + W(8, -1110987505, -1122110878, -1103910610, 1036071207) + W(9, 1036962198, 1042970795, 999916154, 1043170799)
		 + W(10, 1036233792, 981607022, 1033037628, 1028131846)
		 + W(11, -1113728073, -1155599823, -1121653045, -1131031997);
	sum2 =
		W(0, -1133117125, 1023646322, 1023723550, 1016880452) + W(1, -1128763803, 1032406499, -1112596197, 1024272758)
		+ W(2, 1035315397, -1104375670, 1045506061, -1100884270)
		+ W(3, 1037072250, -1100571834, 1043010850, -1106522969) + W(4, 1034291601, 1023753609, -1107539440, 1046403885)
		+ W(5, -1123261308, 1040670310, -1109210140, 1037357283)
		+ W(6, -1093657955, 1053589289, -1104725243, 1040733712) + W(7, 987308827, 1047435788, -1103530057, 1046389911)
		+ W(8, -1083656994, -1096844972, -1079943056, -1108767061)
		+ W(9, 1066015084, 1056439411, 1038430454, 1050581867) + W(10, 1063017252, -1117431336, 1065218548, -1110535684)
		+ W(11, -1088643610, -1092199491, -1140617522, -1093142505);
	WS(-1141889920, -1150694570);
	sum1 =
		W(0, -1121776659, 1035438770, -1107472311, 1029335145) + W(1, 1032163820, -1122959321, 1035788170, 1006930832)
		+ W(2, -1156363954, 1043244278, 1039611642, 1044045394) + W(3, 1031781705, -1113754566, 1041298854, -1113010266)
		+ W(4, -1110656781, -1108191526, -1092681840, -1089342271)
		+ W(5, -1107172434, -1110931796, -1106653204, -1098776751)
		+ W(6, -1150990554, 1049522698, 1047918398, 1044281805) + W(7, -1142656241, -1118178969, 1044014582, 1035377494)
		+ W(8, 1001967189, 1024784007, -1120026675, 1041259438) + W(9, 1035091531, -1114065315, 1037418924, 968315538)
		+ W(10, 1009891810, 1026909213, -1115519345, 1032535224)
		+ W(11, -1156224954, -1114416227, 1034927023, -1127266575);
	sum2 = W(0, -1096670021, -1102787949, -1099441746, 1043637876)
		 + W(1, 1052388948, 1042101483, -1135324433, 1042670443) + W(2, 1059540854, 1039622534, 1064198145, -1086802625)
		 + W(3, -1085971065, -1113298762, -1098667485, -1104634628)
		 + W(4, 1045575353, 1037899964, 1030855272, -1101655681)
		 + W(5, 1033969343, -1105771070, 1036465297, -1104173140)
		 + W(6, -1133958494, 1013042349, 1040028330, 1036771998) + W(7, 1032851236, -1120619083, 981463467, 1030229840)
		 + W(8, 1031038260, -1110193614, -1117097690, -1125265460)
		 + W(9, -1103569731, 1049976190, -1101523135, 1035574893)
		 + W(10, -1118270456, 988987510, 1032105974, -1117707023)
		 + W(11, -1134648980, 1021389004, -1119296945, 1035007302);
	WS(1060329015, -1107100438);
	sum1 = W(0, -1139109867, -1126768152, -1154508124, 1024792785)
		 + W(1, -1145234942, -1121126338, -1165337473, -1128378904)
		 + W(2, 1016013223, -1108878752, -1139382101, 1046477388)
		 + W(3, 1046417836, 1044791733, -1115375281, 1030070044) + W(4, 1052529520, 1042283693, 1051369597, 1051787130)
		 + W(5, 1040695538, 1046651812, 1039020124, 1046922680)
		 + W(6, -1098269535, -1103310414, -1093610355, -1088582834)
		 + W(7, -1090008057, -1097854544, -1110993568, -1105218789)
		 + W(8, -1120993331, 1033078264, 1033661966, 1015463488) + W(9, 1035018943, 1029328303, 980238373, -1121430349)
		 + W(10, 1025836257, -1113589378, 1029380042, -1124637616)
		 + W(11, -1127749832, 1030094510, -1117533511, 1016154976);
	sum2 =
		W(0, -1122821091, 1016851522, -1106087013, -1109184296) + W(1, 1045004090, 1015529466, 1026918939, -1115690469)
		+ W(2, 1039646422, -1156337616, -1131895450, -1080883791)
		+ W(3, -1074990048, -1105476432, -1104782698, 1022339242)
		+ W(4, -1126218548, -1123806894, 1035943528, 1071805249)
		+ W(5, 1071092779, -1126394390, 1031828962, -1122803425) + W(6, 1020520346, -1105518185, 999070248, -1096231655)
		+ W(7, -1125969764, 1028426171, 1030594487, -1127395662) + W(8, 1030755819, 1031650855, 1015158698, 1043321474)
		+ W(9, -1125796080, 1026097175, -1140334484, -1110808154)
		+ W(10, 1003947528, 980292032, -1123933765, -1122746065)
		+ W(11, 1018391998, -1126690400, 1018627618, -1149029768);
	WS(1004067712, 1029538397);
	sum1 = W(0, 1039684517, -1113057966, 1034662227, 976341006) + W(1, -1116361615, 1039793800, -1114202454, 1023346679)
		 + W(2, 1025050595, -1112884456, -1120136235, -1106127376)
		 + W(3, -1108532672, -1136083213, -1109109944, 1026195563)
		 + W(4, 1055781642, 1052279792, 1057037092, 1048957300) + W(5, 1059667231, 1049781884, 1046150498, 1052752022)
		 + W(6, -1093421305, -1096595713, -1096171643, -1083333863)
		 + W(7, -1093970477, 1050503466, -1098876866, -1119746148)
		 + W(8, -1134522377, 1008080123, 1038845557, -1104830972)
		 + W(9, -1107387175, -1105145436, -1111371224, -1106375815)
		 + W(10, 1033902960, -1134909265, 1000314570, 1017566030)
		 + W(11, -1120056627, 1034175935, -1129568684, 1002478074);
	sum2 = W(0, 996458418, 1033154491, -1124552606, 983965669) + W(1, -1113544599, -1118592979, 1024911403, -1120675710)
		 + W(2, 1023361218, -1129026548, -1113149678, -1096377075)
		 + W(3, -1108470744, -1107366613, 1040480632, 978762058) + W(4, 1020176326, 1036155261, -1107309754, 1064108379)
		 + W(5, -1113642974, -1147140265, -1123866147, -1127049668)
		 + W(6, -1105686968, -1136279909, -1101182829, 1059185253)
		 + W(7, -1094171461, -1097506500, 1038318571, 1027330889)
		 + W(8, -1112170015, 1029838361, -1110765232, 1029555247) + W(9, 1048386684, 995412594, 1045927904, -1102738273)
		 + W(10, 1016740014, -1122796554, 1027141165, -1111484496)
		 + W(11, 1033692775, -1108579478, -1126067866, 1023291782);
	WS(1047133404, -1079170418);
	sum1 = W(0, 1009155056, -1116032717, -1135035740, -1132905800)
		 + W(1, 1006908676, -1123509635, -1129150906, -1147535977)
		 + W(2, -1122581460, -1127398915, -1111731450, -1098422622)
		 + W(3, -1136427723, 1019095722, 1037504657, 1012838771) + W(4, 1042667713, 1041078541, 1051022508, 1065228285)
		 + W(5, 1042380775, 1050271906, -1107182030, 1023931745)
		 + W(6, 1030334583, -1113404572, -1111377849, -1104817319)
		 + W(7, -1091891141, -1103926112, -1121675713, -1123007382)
		 + W(8, -1108143194, -1123819760, -1112180142, -1102890728)
		 + W(9, -1111098047, 1023382911, -1136273159, -1123177070)
		 + W(10, 1027163842, -1122554086, 1023811915, -1133181796)
		 + W(11, 1001483047, -1116735535, 1015217807, -1130799202);
	sum2 = W(0, -1151544588, -1155029688, 1018065470, 1007239987)
		 + W(1, -1125453823, -1118997712, 1007542759, -1133631258)
		 + W(2, 1017708852, -1121981859, -1114670464, 1049278985)
		 + W(3, 1041079714, -1156221672, -1120658712, -1113215345)
		 + W(4, -1147640076, -1129630940, -1093073209, -1077783117)
		 + W(5, 1074285479, 1034878186, 1016277382, 1033160981) + W(6, 1008923057, 1024218233, -1119653793, -1083801634)
		 + W(7, 1047560438, 1028846010, 1036336794, 1022080564) + W(8, 1011942449, 998377109, -1131988255, 1041518161)
		 + W(9, -1114079754, -1118519138, -1121956184, 1027490516)
		 + W(10, 1018406594, -1133221663, 1025316590, -1123603132)
		 + W(11, -1131599727, 1024940191, -1131785133, -1130450701);
	WS(1043550940, 1028476494);
	sum1 = W(0, -1115183742, -1121780237, -1117842775, -1110838377)
		 + W(1, 991794198, -1111061058, 1015980795, -1113960535)
		 + W(2, -1130981802, -1102302048, -1117998761, -1094318158)
		 + W(3, -1102037997, -1115328139, -1113105937, -1106426583)
		 + W(4, -1100607937, -1105099981, -1096882923, 1062548805)
		 + W(5, -1103616404, -1097580450, -1103768718, -1100373208)
		 + W(6, 1051762223, 1040535662, 1059510884, 1068023761) + W(7, 1055882697, 1041348961, 1034161697, 1044552262)
		 + W(8, 1000007075, -1138550724, -1102853271, -1099046056)
		 + W(9, -1102330336, -1131654944, -1112888641, -1110284503)
		 + W(10, -1121847282, -1111548899, -1132334487, 1013492582)
		 + W(11, 1018468811, -1119471984, -1129682576, -1148988811);
	sum2 =
		W(0, 1029690847, -1115037203, -1127742454, 1036903221) + W(1, -1106227374, 1039025001, -1108879063, 1016988574)
		+ W(2, -1103820712, 1043435491, -1100462798, 1028701483)
		+ W(3, -1121926871, -1126383902, 1017141302, -1115441627) + W(4, 998970743, -1096312501, 1044923803, 1041049643)
		+ W(5, 1030485727, -1125321886, 1008577020, 1033537170) + W(6, 1028297515, 1046052979, -1099477234, 1065575031)
		+ W(7, -1098681477, 1040854499, -1106467082, -1122382559)
		+ W(8, -1122562191, -1115911439, 1030898927, -1096910875)
		+ W(9, 1034498637, -1115709255, 1013474716, -1129067614)
		+ W(10, -1133991676, 1007821180, -1113716427, 1036974934)
		+ W(11, -1111652935, -1126914630, -1128843302, -1114648723);
	WS(-1079050332, -1087647968);
	sum1 = W(0, -1138480508, -1122115440, 1024624314, -1106223181)
		 + W(1, 1029330596, -1120448614, -1134294785, 1004544641)
		 + W(2, -1112879708, 1026750308, 1027382179, -1116109267)
		 + W(3, 1024806390, -1128868784, 1022822666, -1115751616)
		 + W(4, -1095708941, -1102419558, -1136300523, -1083772539)
		 + W(5, -1103579129, -1102450653, -1100406055, -1099401009)
		 + W(6, 1054719611, 1048762675, 1057423590, 1057166968) + W(7, 1058690419, 1049252525, 1046884233, 1051036287)
		 + W(8, 1031575959, -1106236805, -1115045376, -1096438944)
		 + W(9, -1115914082, -1116410163, -1127656777, 1031406769)
		 + W(10, -1122888245, -1139407140, -1136279992, -1112079518)
		 + W(11, 1025354440, -1128866725, 1008311211, 1030150228);
	sum2 =
		W(0, 1018441725, 1018735508, -1106801879, 1042307735) + W(1, -1108191465, -1153036923, 1023515972, -1130614305)
		+ W(2, -1121226957, -1128043345, 1036012925, -1105109021)
		+ W(3, 1026535678, 1024075219, -1143871918, -1115606924) + W(4, 1025980595, 1035475244, -1093599779, 1063056253)
		+ W(5, -1097885523, 1035122552, 1028845741, -1124060823)
		+ W(6, -1143973174, 1028848366, -1119821797, 1055391108)
		+ W(7, -1118265757, 1031788992, -1122707515, -1149779899)
		+ W(8, -1145354702, 1010180031, -1106432772, -1103238145)
		+ W(9, -1114258989, -1114303163, 1031455538, -1117711701)
		+ W(10, -1118705847, 1001175670, -1114705464, 1024485983)
		+ W(11, -1109715589, 1025382280, -1125366621, -1122890135);
	WS(1061221431, 1002405371);
	sum1 = W(0, -1123061017, -1109190069, -1111043962, -1094345134)
		 + W(1, -1146354418, -1113941840, -1145213652, 1017803349)
		 + W(2, -1123480946, 1033046959, 1050201177, 1042710035) + W(3, 1050099666, 1026923762, 1032794752, 1029204218)
		 + W(4, -1090405194, -1104934581, -1102475777, -1086823335)
		 + W(5, -1097235340, -1091215734, -1094526523, -1089600016)
		 + W(6, 1054235011, 1044209302, 1057895846, 1052530935) + W(7, 1058601910, 1050794548, 1041457976, 1055600534)
		 + W(8, 1026563665, -1108435303, 1037490845, -1102625680)
		 + W(9, 1033897294, -1126650490, -1110275296, 1021417496)
		 + W(10, 1000058490, -1121369187, 1030151784, -1111380603)
		 + W(11, 1040756961, -1126829850, 1032331475, 1033488871);
	sum2 = W(0, 1049937345, 1058657690, 1071079778, 1072348129) + W(1, 1066389113, 1049150259, -1119844839, -1113785170)
		 + W(2, -1089706816, -1087536311, -1078069733, -1078647761)
		 + W(3, -1079714039, -1090508646, 1022376790, -1103849791)
		 + W(4, 1050626093, -1106625833, 1020012689, -1094966474)
		 + W(5, -1098171132, 1050328795, -1105718319, 1052174137)
		 + W(6, 1030967529, -1105431871, 1044296437, -1112600090)
		 + W(7, 1038432439, 1044145959, -1126694997, 1034822829)
		 + W(8, -1115709839, 1036734782, -1122006247, -1122763227)
		 + W(9, -1130276743, 1024733405, 1021875579, -1112758982)
		 + W(10, 1039088353, -1109192755, 1031394755, -1116226089)
		 + W(11, 1022577738, 1012728894, -1123093509, 1013882918);
	WS(-1092893294, -1089220584);
	sum1 = W(0, 1008699951, 1010493299, -1124403149, 1025199074)
		 + W(1, -1117387089, 1015178277, -1125915034, -1130896954)
		 + W(2, -1127519944, -1118558929, -1106263811, -1113928672)
		 + W(3, -1098638288, 1041393441, -1112838969, 1035998582) + W(4, 1053766130, 1051919929, 1056071340, 1052175436)
		 + W(5, 1062605050, 1047707912, 1053546873, 1049473086)
		 + W(6, -1103359682, -1096189801, -1097091836, -1086367179)
		 + W(7, -1096005139, -1102452900, -1101730612, -1095432549)
		 + W(8, -1104704049, 1032200864, -1111082358, 1015736929)
		 + W(9, -1120379023, -1123219920, 1019333603, -1136688761)
		 + W(10, 998920846, 1028526614, -1149496748, 1019181009)
		 + W(11, -1115659002, 1027645503, -1131717807, -1136451331);
	sum2 =
		W(0, -1143112647, 992704062, -1124855502, 1038449046) + W(1, -1105916124, 1035072543, -1114904409, 1019251456)
		+ W(2, 1034689803, -1109431235, 1033324328, -1098090520) + W(3, 1038361982, 1040866773, 1032024575, -1164332444)
		+ W(4, -1115356591, 1039097516, -1073085951, -1063972596)
		+ W(5, 1062319475, 1085456662, 1062308854, -1102205120)
		+ W(6, -1121270233, 1048248946, -1106299172, -1091325299)
		+ W(7, -1090314642, 1056006422, 1043935118, -1107459099)
		+ W(8, 1017968792, -1124530814, 1023517229, -1113483013)
		+ W(9, -1141826407, 1034240002, -1124783482, 1032935811)
		+ W(10, 1021729984, 1005857263, -1126326370, 1015994888)
		+ W(11, 1013997779, -1134900259, -1135264403, 1001043447);
	WS(-1104754908, -1106735671);
	sum1 = W(0, 1030490103, 1032595044, -1128810020, 1032319302) + W(1, 1019231224, 1025969502, 1016077744, 1024124136)
		 + W(2, -1117923535, 1002237924, -1122216143, -1120462507)
		 + W(3, 1025980110, -1123369072, 1034830735, -1104242198)
		 + W(4, -1088908700, -1094516030, -1092804364, -1102093923)
		 + W(5, -1088198897, -1096286026, -1102086589, -1103741447)
		 + W(6, 1033028505, 1029213684, 1050263192, 1063837581) + W(7, 1058220138, 1054477272, 1045907999, 1049334234)
		 + W(8, 1045999740, -1144798556, 1022746927, -1106958295)
		 + W(9, -1107413149, 995801516, -1115665070, 1030012489)
		 + W(10, -1120248133, 1015682178, -1129595020, 1030078356)
		 + W(11, 1021953856, -1153493672, 1019926661, 1022398552);
	sum2 =
		W(0, -1116247065, 1015145430, 986051432, -1117862601) + W(1, -1114715779, 1034116930, -1144744186, 1026244953)
		+ W(2, 1035833889, -1107082251, -1114579693, 1043695503)
		+ W(3, 1039299404, -1114493167, -1120378069, 1019204162)
		+ W(4, -1087068607, -1079268655, 1022672030, 1067901888) + W(5, 1059152338, 1008422125, 1020328850, -1111927269)
		+ W(6, -1107323417, -1102842161, 1049680335, 1032100715) + W(7, 1040660749, -1115195239, 1018816198, 1021018582)
		+ W(8, -1109274147, 1016322550, -1111459111, 1026073955) + W(9, 992278036, -1173738319, 1033325633, -1123657301)
		+ W(10, 1021616338, -1133554677, 1010843781, 1017398706)
		+ W(11, 998891466, -1139208557, -1138764845, 1016479082);
	WS(-1092340590, -1082645376);
	sum1 =
		W(0, 1018128252, 1018184990, 1028162329, -1117677972) + W(1, -1115495745, -1115409474, 1015642046, -1118723567)
		+ W(2, 1033191659, -1106475329, -1101261661, -1102532636)
		+ W(3, 1031605429, 1010011868, -1127814216, -1112449263) + W(4, 1040446513, 1036685563, 1061713267, 1042646693)
		+ W(5, -1089327101, -1106573237, -1105713919, -1112423953)
		+ W(6, -1112709788, -1105689791, -1086509296, 1038532783) + W(7, 1064314083, 1046976369, 1039016129, 1030956248)
		+ W(8, 1031456758, 1040219053, 1042438664, -1111899057) + W(9, -1100451664, -1105951352, 1010066702, 1022848097)
		+ W(10, -1113441282, -1127103440, -1123459213, 1018898486)
		+ W(11, 1033438227, 1029058545, 1013299750, -1130132966);
	sum2 =
		W(0, -1107775669, -1121347079, -1118975841, -1121125435)
		+ W(1, -1123325897, 1012434826, -1129695564, 1006663086) + W(2, 1040551451, 1042459857, 1031184422, -1152381105)
		+ W(3, -1105935240, -1115286413, -1124425722, -1111096901)
		+ W(4, 1027302533, -1122087227, 1016161914, 989383522) + W(5, 1045806619, -1125562074, -1111270899, -1114174571)
		+ W(6, 1033412933, -1113656153, 1035641742, -1114487413) + W(7, 1041762467, 1029416951, 1028252326, -1127668218)
		+ W(8, -1135101756, 1017950151, -1109563699, 1046120628) + W(9, -1114574520, 1035110196, 998528980, 997585257)
		+ W(10, -1131050762, -1130160250, 1017438602, 987844130)
		+ W(11, -1117833439, -1173771715, -1121778743, -1126450718);
	WS(1052284526, 1042464092);
	sum1 = W(0, 1010280196, -1136974408, 1026365340, 1020617774)
		 + W(1, 1023947782, -1127515216, -1129271461, 1007810505)
		 + W(2, 999914700, -1110845507, -1109035161, -1110448219)
		 + W(3, -1110075532, 1038195741, -1114945332, 1019473092) + W(4, 1057530557, 1046554367, 1060667985, 1063323154)
		 + W(5, 1043924417, 1050039723, 1042422080, 1052688005)
		 + W(6, -1098111272, -1100087104, -1090659644, -1094987596)
		 + W(7, -1095988958, -1097163609, -1105136802, -1095692091)
		 + W(8, -1101387838, -1110795931, -1102616600, -1105684762)
		 + W(9, -1124311688, 1018127786, -1124435598, -1114597706)
		 + W(10, 1027464615, -1128121686, 1001926272, 1025859742)
		 + W(11, 1017827156, 1034844538, -1130637466, 1027019478);
	sum2 = W(0, 1025355846, -1124685033, 1029205900, 1011755468)
		 + W(1, -1113277680, 1035269289, -1122502097, 1013457876)
		 + W(2, -1119913429, 1010871130, 1016143206, 1033794365) + W(3, -1140030878, 1020099653, 991986873, 1035095720)
		 + W(4, 1034044275, 1036346050, -1128364593, -1133342818) + W(5, 1020927778, 1035477071, 1011575434, 1029499077)
		 + W(6, -1140464466, 1032812135, 1071964190, 1067600837) + W(7, 1039362648, 1033733070, 1008065452, 994468553)
		 + W(8, -1091074448, -1086522508, -1074918519, -1089329657)
		 + W(9, -1106053895, -1108456989, -1146528221, -1106105254)
		 + W(10, 1041357090, 1037018199, 1033277276, -1111447139)
		 + W(11, -1118126225, 1032003060, -1117647411, 1009180302);
	WS(-1085785015, -1080175544);
	sum1 = W(0, 1035373246, -1125806618, -1118822551, 1044894533)
		 + W(1, -1102223008, 1041222777, 1023709757, -1122183565)
		 + W(2, -1103151077, 1045216768, -1094452856, 1039875576)
		 + W(3, -1151103277, -1094574331, 1048044105, -1103877399)
		 + W(4, 1058377668, 1050584367, 1054861331, 1046782533) + W(5, 1057861265, 1051791466, 1043274206, 1058273114)
		 + W(6, -1091874455, -1094766367, -1107649205, -1090132878)
		 + W(7, -1090472533, -1111571937, -1098390656, -1092114299)
		 + W(8, 1025579124, 1043611260, -1106387815, 1049375324)
		 + W(9, -1115030560, -1137989279, 1049548184, -1106419572)
		 + W(10, -1111695537, 1043525714, -1102079139, -1105407270)
		 + W(11, -1144672552, -1102123612, 1041305154, -1116205169);
	sum2 =
		W(0, 998449416, -1121990028, 1039055377, -1115523342) + W(1, -1132069983, 1032292249, -1128335569, 998312734)
		+ W(2, -1118465870, 1035743758, -1103571680, 1049274722)
		+ W(3, -1106547389, -1126693677, 1034009109, -1116877357)
		+ W(4, -1124628345, 1040306990, -1098483719, 964150684) + W(5, 1024621733, -1103504000, 1043582890, -1116867442)
		+ W(6, -1148690252, 1001004257, 1060096717, 1077176219) + W(7, 1060014437, 1016774454, -1107960970, -1139511962)
		+ W(8, 1037770975, -1132010249, -1108861100, 1047972499) + W(9, -1098623231, 1034159573, 1020716885, 1042264637)
		+ W(10, -1105952484, 1037805583, -1087084008, -1070507600)
		+ W(11, -1092504349, -1105946989, 1041667680, -1102914489);
	WS(1041580764, 1025947967);
	sum1 = W(0, 1032565172, -1116825273, 1019951750, 1022134396)
		 + W(1, -1111515158, 1034025399, -1110133221, -1159719714)
		 + W(2, 1034662848, -1104706235, -1115255997, -1107214727)
		 + W(3, -1098820316, 1032808736, -1102823188, 1021100817) + W(4, 1053611982, 1050747028, 1050206724, 1063007652)
		 + W(5, 1060757006, 1052025888, 1043880105, 1052817434)
		 + W(6, -1093835868, -1092905173, -1095669879, -1096926641)
		 + W(7, -1089733625, 1049974094, -1099659531, -1119725058)
		 + W(8, -1131110976, -1131069497, 1036897764, -1105182467)
		 + W(9, -1098715869, -1104277767, -1106501955, -1106408671)
		 + W(10, 1036244351, -1119290642, 1017394926, 1029927621)
		 + W(11, -1106823604, 1037476046, -1114565306, -1122404893);
	sum2 =
		W(0, -1132209742, 986836209, -1121945777, -1170553346) + W(1, -1138085578, -1127752664, 1024317954, -1170071298)
		+ W(2, 1031078182, 1029631070, -1119773491, 1020231728) + W(3, 1023900693, -1133642976, 1016594015, -1123929889)
		+ W(4, -1131885988, 1025515900, 1029199828, -1120148774)
		+ W(5, -1122079840, 1019687015, 1019770946, -1134784812)
		+ W(6, -1109418986, -1129378830, -1113141662, 1055904551)
		+ W(7, 1057958803, 1044815557, -1115676013, 1040873658) + W(8, 969823813, 1027058278, 1030656895, -1099466937)
		+ W(9, -1089769002, -1096970616, -1105180704, -1104818759)
		+ W(10, -1135041624, 1012367442, -1116640321, 1014349374)
		+ W(11, 1019607807, 1019685270, 1040370156, 1020720783);
	WS(-1101021916, -1101341893);
	sum1 = W(0, 1026213188, -1128959914, 1026395551, -1114900877)
		 + W(1, -1152047246, 1012420650, 1006057769, 1026345301)
		 + W(2, -1104193847, 1029994953, -1146733010, 1036038140)
		 + W(3, 1031817213, -1118727997, 1021561044, -1106810537)
		 + W(4, -1099125811, -1096018912, -1093634574, -1086773562)
		 + W(5, -1090412335, -1107844781, -1104575744, -1104632714)
		 + W(6, 1055643976, 1049220736, 1055313981, 1052012604) + W(7, 1060627153, 1051291321, 1049980081, 1047342967)
		 + W(8, 1025577212, -1111820508, -1119144868, -1127551698)
		 + W(9, -1111302883, 1025725832, -1112108341, 1003961523)
		 + W(10, -1110018309, 1025253614, -1114303945, -1123712161)
		 + W(11, 1028280877, -1119269431, 1031833384, 999050183);
	sum2 =
		W(0, -1131988010, 1023490159, -1126411872, -1164111651) + W(1, -1121501747, 1031886393, -1117332099, 1035364539)
		+ W(2, -1111316079, 1007442131, -1122871173, 1046145376) + W(3, 1040330964, -1109560063, 1016982738, 1005935896)
		+ W(4, 1041465340, -1100903601, 1038743702, -1093182708)
		+ W(5, 1049859497, -1098635398, 1035352171, -1113093917) + W(6, 1024389323, 1055734435, 1080207498, 1078445253)
		+ W(7, -1068399047, -1066503158, -1109489195, 1012210427)
		+ W(8, -1121573843, -1125698351, 1043717463, 1049726225)
		+ W(9, -1122596352, -1100760677, -1113462329, 1035980752)
		+ W(10, -1149117460, -1131908940, -1114017647, -1119425741)
		+ W(11, 1019240934, 1009702615, 1032687935, -1141270643);
	WS(1046490332, 1041425064);
	sum1 = W(0, 1024529499, 1033054902, 1031945755, -1146773895) + W(1, 1029605664, 1004520717, 1031502108, 1024614604)
		 + W(2, -1116828595, 1002731779, 1040980232, -1160896989) + W(3, 1052617834, 1015420456, 1044142352, 1032157630)
		 + W(4, -1093042204, -1098109922, -1092614541, -1086741475)
		 + W(5, -1091564618, -1090483479, -1094325635, -1086427940)
		 + W(6, 1043650965, 1045029126, 1058500980, 1055608303) + W(7, 1058257970, 1019101890, 1041689704, 1049761551)
		 + W(8, 1015429414, -1106337284, 1033182334, -1109695552)
		 + W(9, -1174108025, 1029823567, -1123497953, 1041880275)
		 + W(10, 1019425762, 995804238, 1032419541, -1179835378)
		 + W(11, 1044059953, -1127672093, 1032927635, 1040104968);
	sum2 = W(0, -1122431319, -1114479591, 1024826864, -1100833312)
		 + W(1, 1043724086, -1109354990, -1130104331, 1015245663)
		 + W(2, 1026151548, -1106953243, 1048064546, -1097347844)
		 + W(3, 1037967160, -1109085075, -1110876131, 1007980535) + W(4, -1122010793, 999999917, 992235770, 1040448763)
		 + W(5, 1044292364, 1032432738, -1143420941, 1040568157) + W(6, 1049905644, -1108260971, 1050719290, 1045454882)
		 + W(7, 1049686405, -1111087807, -1098496523, 1043523736)
		 + W(8, -1102178930, -1125976243, -1123774104, -1096948195)
		 + W(9, 1038302972, -1108325988, -1118752296, -1113347688)
		 + W(10, -1124048569, -1126306455, 1025075060, -1105554812)
		 + W(11, 1034346164, -1114960687, 994535386, 1032072922);
	WS(-1096079726, -1086813702);
	sum1 = W(0, -1135457777, 1020632987, -1136898909, 1041289173)
		 + W(1, 1012368645, 1002632984, 1024629150, -1127204699)
		 + W(2, -1105268453, -1134572551, -1100910973, -1166801940)
		 + W(3, 1038525034, -1102504381, 1029902179, -1110256943)
		 + W(4, 1045566625, 1038076635, -1141635906, 1058638213) + W(5, -1104077708, 1033251913, 1009307365, 1022942147)
		 + W(6, -1104980990, -1125909619, -1094783105, 1057673490)
		 + W(7, -1100424110, -1111352769, 1012100357, -1133590617)
		 + W(8, -1105625101, -1145052038, 1032999502, 1030475041)
		 + W(9, -1113674176, -1113040784, 992583714, -1114381639)
		 + W(10, -1128467237, 1035122115, -1125440663, 1035865453)
		 + W(11, 988204202, -1119749552, 1027550920, -1124393059);
	sum2 =
		W(0, 1009177065, -1120740066, 1031366584, 1041576942) + W(1, -1100270767, 1045439690, -1125959183, 1033773937)
		+ W(2, -1117003048, 1013092463, -1102800003, -1090661723)
		+ W(3, 1059100650, -1097382737, 1022453518, -1106788899) + W(4, 1042183695, 1025589372, -1111208570, 1068855162)
		+ W(5, -1085550755, 1044086134, 1032267243, 1025170288) + W(6, -1105766164, 1042721142, -1149080533, 1040487387)
		+ W(7, 1023619821, -1099098175, -1126080241, -1106320787)
		+ W(8, -1112946812, -1113055730, -1103263899, 1030911277)
		+ W(9, -1103276630, -1114239046, -1107084863, 1019625936)
		+ W(10, 1019480223, 1026018809, 1020058227, 1007104581)
		+ W(11, 1029611268, -1162581429, 1037226018, -1116554192);
	WS(1059841719, 1028884484);
	sum1 = W(0, -1113543486, -1112448166, -1123514455, 1014814024)
		 + W(1, -1116573889, -1120616579, -1132301434, -1127146586)
		 + W(2, -1108411818, -1111506273, -1104706915, -1096756366)
		 + W(3, -1106354949, -1107115957, -1117349474, -1105758103)
		 + W(4, -1112074625, 1034453786, 1033474668, 1052483434) + W(5, 1048710884, 1049505778, 1050151687, 1056594572)
		 + W(6, 1058342439, 1041783662, 1050338440, 1043430567)
		 + W(7, -1116369607, -1117001986, 1011608836, -1106214629)
		 + W(8, -1101044205, -1112657624, -1103529079, -1099567912)
		 + W(9, -1110811775, -1119641312, -1133908615, -1113349351)
		 + W(10, -1143395087, -1122260358, -1124590486, -1132902244)
		 + W(11, -1118491109, -1118809775, 996976763, -1114523384);
	sum2 = W(0, -1131846847, 999597315, 997751878, -1114921220) + W(1, 1031101790, -1115596944, 1024706196, -1120544321)
		 + W(2, -1142019487, 973346488, -1127636492, -1114646695)
		 + W(3, -1098897499, 1027087956, -1111832500, 1029100436)
		 + W(4, -1119272484, -1113005256, -1113445057, 1055277760)
		 + W(5, 1032426103, 1036539833, -1114392819, 1010252474) + W(6, 1043688817, -1112114230, 1056371527, 1041350431)
		 + W(7, 1038923617, -1123786644, -1130636099, -1123180191)
		 + W(8, -1110979463, -1112619479, -1097247478, 1019660165)
		 + W(9, -1105379211, 1026606310, 1012894502, -1125326592)
		 + W(10, -1128104285, 1003422803, 1021279303, -1127196333)
		 + W(11, -1138766624, -1129408714, -1130181692, -1164469676);
	WS(-1092619630, -1089382730);
	sum1 = W(0, -1111364766, 1043539187, 984781533, 1030068626) + W(1, 1026274177, -1111039089, 1024515101, -1120853581)
		 + W(2, 1023648980, 1020312451, -1115220152, -1101226428)
		 + W(3, 1038621209, -1105671421, -1101912057, 1015856825)
		 + W(4, 1039669985, -1096148415, 1055391282, 1026945555)
		 + W(5, -1081505706, 1045179252, -1132720100, 1027675681)
		 + W(6, -1112475547, 1048019422, -1085560118, 1059189430)
		 + W(7, 1059392734, -1105049488, 1041558112, -1133761880)
		 + W(8, -1102256285, 1027548272, 1048070471, -1108016176) + W(9, 1040580240, 1037378816, 1031071010, 1032748839)
		 + W(10, 1036516737, -1110790259, 1016263062, -1120756633)
		 + W(11, 1007770772, 1034683832, -1109624324, 1021933410);
	sum2 =
		W(0, 1021752691, -1117827136, -1125983252, 990310070) + W(1, -1109957501, 1040724727, -1109878975, 1031887118)
		+ W(2, -1111677325, 1031932470, -1130612142, -1104195843)
		+ W(3, -1168184730, -1105272655, 1035492359, -1103738768)
		+ W(4, -1108952074, -1110048197, 1045228241, 1051763659)
		+ W(5, 1028013889, -1136328910, -1114456338, -1114723198) + W(6, 1033183913, 1038437939, 1050756049, 1045197632)
		+ W(7, -1115591069, -1123843648, -1120329563, 1035246991)
		+ W(8, 1044091848, -1103930854, 1008734718, -1105931725)
		+ W(9, -1149204891, 1020655719, -1120613434, -1121689275)
		+ W(10, -1113755692, 1027358915, -1104619422, 1032921649)
		+ W(11, -1117367196, -1140627498, 1033876328, -1121880867);
	WS(1051433070, 1041054969);
	sum1 = W(0, 1027474774, 995089009, 1034863641, -1109189270) + W(1, 1039503310, -1126811322, 1033371404, 1010666397)
		 + W(2, 1025557871, 1019369911, 1049084179, 1046403907) + W(3, 1044512531, 1035909664, 1033234174, 1028564471)
		 + W(4, -1105663671, 1032468488, -1096978722, -1082587707)
		 + W(5, -1102025153, -1107200379, -1104819461, -1106755535)
		 + W(6, 1035613609, 1037418314, 1039456478, -1080639932) + W(7, 1026454114, 1042549431, 1042229543, 1034360184)
		 + W(8, 1041537220, 1036952965, 1041156238, 1049567823) + W(9, 1040087661, 1039105725, -1131034584, 1031577769)
		 + W(10, 1027665948, -1122283488, 1041167849, -1112387034)
		 + W(11, 1039611744, -1137459494, 1031071714, 1033297350);
	sum2 =
		W(0, 1039097792, -1128793460, -1140010118, 1022871695) + W(1, -1138263433, -1112923836, 1026478628, -1110368657)
		+ W(2, -1103860174, -1106733661, 1043000544, -1106671798)
		+ W(3, 1046664654, -1123142296, 1037719970, 1042580191) + W(4, -1106228186, 1050938198, -1100268114, 1039252188)
		+ W(5, -1099105674, -1121884665, -1100173198, 1034926170)
		+ W(6, 1004583985, -1097187313, 1021007203, 1053089515) + W(7, 1048715277, -1114597930, 1047464456, -1106315502)
		+ W(8, 1031892389, 1046933969, -1107049139, 1049075999)
		+ W(9, -1103930146, 1022883749, -1098080196, -1108178582)
		+ W(10, -1133334119, -1107245750, 1039577114, -1104825734)
		+ W(11, 1030321621, -1117968576, 1036807670, 1018138445);
	WS(-1097236334, -1078251511);
	sum1 = W(0, -1147379729, 981774949, -1145120489, -1112510828) + W(1, 975327689, 1008364580, -1140670990, 1022969831)
		 + W(2, -1107131303, 1007351583, 1033603653, 1043141838) + W(3, 1029606457, 938727969, 1020032977, -1108966769)
		 + W(4, -1102832418, -1125527926, -1095625930, -1082084799)
		 + W(5, -1090577043, -1093823475, -1098508888, -1096801949)
		 + W(6, 1058323440, 1053289720, 1056660465, 1032726417) + W(7, 1058345481, 1053416161, 1046390514, 1049766564)
		 + W(8, 1023750586, -1121375351, 1026746467, 1033795604)
		 + W(9, 1025947909, -1131151340, -1119905544, 1037296218)
		 + W(10, -1116361496, -1124892056, -1128008098, -1117973855)
		 + W(11, -1148460889, -1125502955, 999577711, 1010324189);
	sum2 =
		W(0, 1024894779, 1020144998, -1118791847, 1007750652) + W(1, -1137666916, 1023698735, 1009542396, -1129126018)
		+ W(2, -1102276353, 1025017931, -1107221556, 1046635995) + W(3, -1132306598, 1023586615, 1030880679, 1015842286)
		+ W(4, -1120020336, -1096890621, 1050182775, 1039741552)
		+ W(5, 1043589185, -1108361045, -1114600836, 1024872627)
		+ W(6, -1081787381, -1080908066, -1102161510, 1072604155)
		+ W(7, 1055213170, -1115556916, 1037616572, -1105259074) + W(8, 1039662448, 992888305, -1130889346, 1039835396)
		+ W(9, -1110509653, -1122324709, 1000980713, -1124270218)
		+ W(10, 1023553607, -1118655405, -1120230550, -1126400334)
		+ W(11, 1020541198, 1020891302, -1119304668, 1033066840);
	WS(-1095840110, 1065907853);
	sum1 = W(0, -1149009607, 1029310442, -1122029108, -1136794300)
		 + W(1, -1118254622, -1132243967, -1126823604, 1010554921)
		 + W(2, -1123781617, -1130903741, -1115466131, 964920945)
		 + W(3, -1115351608, 1043406509, -1116119295, 1040435870) + W(4, 1057715094, 1048478500, 1058442742, 1045634572)
		 + W(5, 1052165513, 1053323726, 1042519141, 1051535704)
		 + W(6, -1102734645, 1041326469, -1088947208, -1083008792)
		 + W(7, -1096684061, -1089856222, -1127763004, -1095672430)
		 + W(8, -1101560548, 1036129479, -1107277134, -1109559039)
		 + W(9, 1036543086, 1024712701, 1009014011, -1114598742) + W(10, 1034276991, 1021921030, 1036949012, 1024401462)
		 + W(11, -1114280609, 1035777670, -1132072137, 1024787534);
	sum2 =
		W(0, -1122765153, -1119761608, -1115823403, -1123357438)
		+ W(1, -1105805209, 1031734555, -1111986136, -1126486235)
		+ W(2, -1112086475, -1118318168, -1121250504, -1119202357)
		+ W(3, 1024515185, -1130234658, -1134784044, 1026675759) + W(4, 1040388299, 1023061820, -1128744886, 1057284387)
		+ W(5, -1103324019, 1037222780, -1110952019, -1117543075)
		+ W(6, 966593378, -1102263327, -1110151426, 1059190541) + W(7, -1106793279, 1050053336, -1107073751, 1021583022)
		+ W(8, -1114107386, -1113965021, 1045334069, -1118800384)
		+ W(9, -1164047122, 1025627836, -1114668630, -1124432766)
		+ W(10, 975247631, -1137846028, -1111548146, 1023792011)
		+ W(11, -1112106446, 1020007628, -1125560981, -1131408661);
	WS(1024351088, -1094038469);
	sum1 = W(0, 1016930687, 1024919184, 988693323, 1038267403) + W(1, 1001354275, -1123840710, -1125725377, -1120680465)
		 + W(2, 1038061004, -1118029957, 1005748798, 1038925818) + W(3, 1032752795, 1034287148, -1110688307, 1036629872)
		 + W(4, 1052546457, 1050276351, 1052906127, 1062157201) + W(5, 1055274272, 1050137483, 1036684158, -1112935826)
		 + W(6, -1086527812, -1103330015, -1085615881, -1097782940)
		 + W(7, -1088621706, -1090365828, -1108159426, -1098987606)
		 + W(8, 1040515838, 1027568116, 1040353352, -1124671689) + W(9, -1113419105, 1017331974, 1018660298, 1039926041)
		 + W(10, 1006605995, 1004978763, 1030413326, 1031140124)
		 + W(11, 1009586849, 1023985459, -1129057942, -1120649652);
	sum2 =
		W(0, 1018662896, -1131745232, -1136728576, -1110788716)
		+ W(1, -1123530251, -1101470606, -1110519714, -1125138150)
		+ W(2, 1033363591, 1031409358, 1036576685, 1060006588) + W(3, 1052968790, -1102632350, -1105224546, -1083015355)
		+ W(4, -1101021011, -1109130821, -1097527529, 1058553385)
		+ W(5, 1023922010, 1057288665, -1111209476, 1034932287) + W(6, -1107389045, 1050735765, 1043333749, -1120731420)
		+ W(7, -1100470754, -1097217661, 1038218737, 1047940150)
		+ W(8, 1013978472, -1122086781, 1029525730, -1118628277)
		+ W(9, -1117232951, -1112638769, -1121310567, 1023530026)
		+ W(10, -1120396150, 1024022584, 1015209616, 1030135008)
		+ W(11, 1018906596, -1121049341, 1024891644, -1113292326);
	WS(-1086599863, 1058406314);
	sum1 = W(0, -1165120005, -1133002117, -1129945046, 1024249318)
		 + W(1, -1119162837, 1026085015, -1121003281, -1127955907)
		 + W(2, 1027409257, -1121445206, -1106007410, -1105883025)
		 + W(3, -1105279538, -1127421331, -1109094875, 1024561201)
		 + W(4, 1060099497, 1049800473, 1059141168, 1051534797) + W(5, 1058010671, 1051659429, 1047889907, 1050835423)
		 + W(6, -1093079745, -1099695891, -1091476505, -1093891126)
		 + W(7, -1094225343, -1106347590, -1098091099, 999784785)
		 + W(8, -1114693988, 1033258882, -1129815521, -1124179562)
		 + W(9, -1106482085, -1112036922, 1030868870, -1097732400)
		 + W(10, 1019186220, 1025328858, -1128567742, 1017248474)
		 + W(11, -1123837177, 1031899202, -1123224348, -1141903913);
	sum2 = W(0, -1116781913, 1016621488, -1133566515, -1124282558)
		 + W(1, 1034216133, -1128560494, 991940908, 1017899660) + W(2, 1031543998, 1029140379, 1044191480, -1105795809)
		 + W(3, 1017978886, -1175609568, -1120640387, 1019924506)
		 + W(4, 1082393585, 1078957479, -1080327233, -1065075267)
		 + W(5, -1076777978, 1030943022, -1110243052, -1113970478)
		 + W(6, 1050004941, 1028477447, -1104837212, -1086493521)
		 + W(7, -1109285108, 1045155438, 1033432207, -1130476854)
		 + W(8, 1025243259, 1010603263, -1125439138, -1117319975) + W(9, 988101688, 1024551608, -1129511338, 1020472787)
		 + W(10, -1123250937, -1125975170, 1007793087, 1028403247)
		 + W(11, -1125200922, 1020903576, -1119399555, 1028374268);
	WS(-1102531292, -1104168529);
	sum1 =
		W(0, -1149508566, -1156103398, 1005530819, 1019304359) + W(1, -1111288609, -1152861762, -1123770879, 992160490)
		+ W(2, 1032023755, -1123937923, -1114986325, -1105594348)
		+ W(3, -1100927253, 1042848102, -1131000647, 1048571064) + W(4, 1058049088, 1044530702, 1057825341, 1061967565)
		+ W(5, 1057378026, 1043852869, 1032195229, 1021567685)
		+ W(6, -1091020399, -1093487559, -1088576155, -1113700815)
		+ W(7, -1096522221, -1100187457, -1097716728, -1095320739)
		+ W(8, -1123106485, 1028416434, -1124442300, -1132463754)
		+ W(9, -1107169312, 1030031137, -1127676038, 1015048992) + W(10, 1018386839, 1022122127, 1027828556, 1023613146)
		+ W(11, -1118265958, 1031835352, -1124424850, -1151822630);
	sum2 =
		W(0, -1112466451, -1130983341, 1032826781, -1114093653) + W(1, 1040752192, -1154197073, 1026229169, 1032051747)
		+ W(2, 1034684305, 1035765483, -1117553496, -1101908611)
		+ W(3, -1105770401, -1106309648, 984953298, -1113409477)
		+ W(4, -1101371049, -1113050760, -1096382267, 1063677104)
		+ W(5, -1132405995, -1114901667, 1023704972, -1104964374)
		+ W(6, -1100658772, -1100149859, 1042208912, 1062452463)
		+ W(7, 1047214162, -1095028755, -1109270652, -1107539022)
		+ W(8, 1043071493, 1039321546, -1131759707, -1106482074) + W(9, -1105645940, 1034888818, 1035103126, 1008251057)
		+ W(10, -1119405084, -1140521940, -1127348451, 1028341682)
		+ W(11, 1022142418, -1118255322, -1118485150, 1025943565);
	WS(-1107552696, -1110437397);
	sum1 =
		W(0, 994440345, -1123893979, -1123659045, 1033249360) + W(1, -1115012423, 1025628848, -1120012907, -1138236651)
		+ W(2, -1114854865, -1115498472, -1107252796, -1098484960)
		+ W(3, -1105215024, -1113844817, 1015022176, -1112267573)
		+ W(4, 1038159592, -1143015444, 1048547885, 1066459081) + W(5, 1050116824, -1114931568, -1139703834, 1030992175)
		+ W(6, -1169396004, -1103811554, -1102945115, 1054059005)
		+ W(7, -1110458371, 1027966800, -1137430074, 1038350450)
		+ W(8, -1112745281, -1176837895, -1113210869, -1092775086)
		+ W(9, -1107508006, -1115481499, -1123286831, -1114208046)
		+ W(10, 1003079356, -1126823399, -1127252913, 1036761683)
		+ W(11, -1117476787, -1139958260, -1143819946, -1119805695);
	sum2 =
		W(0, -1128900045, -1134566747, 1023101249, -1119409466) + W(1, 1014344875, -1124604689, -1135550339, 1011013307)
		+ W(2, 1032112026, -1121844433, 1024457633, 1041370918) + W(3, -1138667107, 1023011873, -1123574415, 1018662193)
		+ W(4, -1122103841, 1023900033, -1130431017, 1071310745) + W(5, 1015570157, 1025187637, 1029193653, -1118001398)
		+ W(6, 1020429393, 1031965476, 1010339139, -1073631838) + W(7, 1024644617, 1038341472, -1117036677, 1034637136)
		+ W(8, -1123818335, -1168200234, -1111989275, -1111141033)
		+ W(9, -1128248465, 1032459330, 999769253, 1020580065) + W(10, 1025087925, -1116320886, 1037399444, -1131868341)
		+ W(11, 1027301561, -1118206868, -1124415769, -1136885571);
	WS(-1106869980, -1095812171);
	sum1 = W(0, 998635262, -1132768195, 1031165051, -1109012795) + W(1, 1031921458, 959153786, 1015400066, 1020404450)
		 + W(2, 1030538232, 1032306163, 1040655940, 1049530762) + W(3, 1035845131, 1029124089, 1034791747, -1126776961)
		 + W(4, -1104276842, 1027943897, -1094369165, -1079963696)
		 + W(5, -1094529094, -1138415831, -1107836910, -1127281161)
		 + W(6, 1021368885, 1042581143, 1043839724, -1098205560) + W(7, 1041010327, 1043286153, 1040781721, 1032119517)
		 + W(8, 1037657452, -1130589992, 1045125152, 1052736873) + W(9, 1041646697, 1033263566, -1127518347, 1032079673)
		 + W(10, 1012233735, -1127936403, 1030674671, -1106402911)
		 + W(11, 1035635524, -1117746707, 1026900011, 1007765715);
	sum2 =
		W(0, -1137391706, -1152109415, 1015680093, -1108578627) + W(1, 1012334874, -1126811133, -1146463859, 1013671002)
		+ W(2, 1016897725, -1123613558, 1031100358, 1031185182) + W(3, 1018767069, 1016912269, -1123894542, -1129388765)
		+ W(4, -1122041158, -1117579022, 1032233585, 1068869480)
		+ W(5, 1031129926, -1135215962, -1172726683, 1025914590)
		+ W(6, 1032188407, 1034093919, -1107212716, -1079207220) + W(7, -1118301998, 1010098650, 1010207290, 998321459)
		+ W(8, 959684203, -1123954990, -1144448755, -1112638895)
		+ W(9, -1145613555, 1002322227, -1163026381, -1185201771)
		+ W(10, 1004755699, -1142267571, 1020208893, -1131161181)
		+ W(11, 1014639674, 1010341946, -1128211133, 1014227898);
	WS(-1106551004, 1058945856);
	sum1 = W(0, -1136733265, 1029534949, 1040114552, 1023973738) + W(1, 1008178533, -1121731675, -1122738710, 998670125)
		 + W(2, 1027999917, -1110759309, -1101184472, -1136820001)
		 + W(3, -1120539979, 1050535890, 1036280349, -1112884987) + W(4, 1036329486, 1039804839, 1055915689, 1045009467)
		 + W(5, -1099722578, -1092228133, -1110742697, -1133144549)
		 + W(6, 1021052191, -1090459221, -1088507490, -1102642413)
		 + W(7, 1057115504, -1141944531, 1036514925, 1024140334)
		 + W(8, -1112842790, 1042972690, -1116549941, 1048917175)
		 + W(9, -1103385510, 1042662182, -1123309658, 1040183891)
		 + W(10, 996925861, -1126301053, 1035692146, -1116120689)
		 + W(11, 1032281663, 1025401864, -1122836256, 1009223461);
	sum2 =
		W(0, -1166199047, 1008667864, -1137339492, -1142224481) + W(1, -1152330850, 1020018908, -1116618549, 1015962596)
		+ W(2, 1029866216, -1111274931, 1026227362, -1119220040)
		+ W(3, 1031356244, -1116678638, 1026327024, -1189397276)
		+ W(4, -1143586281, 1037662319, 1052978055, -1079795268)
		+ W(5, -1109068899, 1041694498, -1122243464, 1027749752) + W(6, 1016771040, 1050961303, 1073672156, -1075413433)
		+ W(7, 1029037052, 1026323256, 1021575344, -1119692611) + W(8, -1123676489, 1039205717, 1048063806, 1028203090)
		+ W(9, -1113725553, -1115208722, 1002430881, -1114291930)
		+ W(10, -1174784654, -1119230230, -1117826448, 1028246046)
		+ W(11, -1160612324, 1024440460, -1126523302, 1031666290);
	WS(1045979868, -1116118129);
	sum1 = W(0, 1019079208, -1124899402, -1142300538, 1011594153)
		 + W(1, -1134190949, -1132197046, -1116332853, -1135144470)
		 + W(2, -1115974509, -1114857165, -1110287856, -1099509298)
		 + W(3, -1112842949, -1107483943, -1111331677, 1018268010)
		 + W(4, 1054347779, 1046800787, 1053005207, 1063937495) + W(5, 1058166871, 1048177899, 1047873428, 1056893199)
		 + W(6, -1096855346, -1098629066, -1093283235, -1097005655)
		 + W(7, -1090046872, -1104885511, -1102896822, -1096686406)
		 + W(8, -1118610636, 1029706377, 1028644213, 1015974258)
		 + W(9, 1040979430, -1129150352, 1028514810, -1118433447)
		 + W(10, -1120438410, 1017939836, -1131155654, -1116499825)
		 + W(11, -1119992573, -1120133576, -1118080608, -1112688517);
	sum2 =
		W(0, -1132220574, -1115410889, 1017347763, -1123931551) + W(1, 1027749497, -1111299822, 1025854529, -1123916419)
		+ W(2, 1034058342, -1116250603, 1029372102, -1101916549)
		+ W(3, -1104316591, 1035393713, -1107314572, 1033668899)
		+ W(4, 1008450820, -1126553639, -1105866140, 1053545154)
		+ W(5, 1054419707, -1102688086, 1036131430, -1144517652)
		+ W(6, -1132397996, -1097158033, 1060185134, 1060913993) + W(7, 1033775493, -1115290197, -1106841697, 990325833)
		+ W(8, -1105536207, -1108668742, -1106418349, -1104852271)
		+ W(9, -1106993048, -1102129692, -1149271050, -1114889391)
		+ W(10, 1025437040, -1118211898, 1034066570, -1102379864)
		+ W(11, -1133416673, -1209279719, -1133826631, -1129688184);
	WS(1058774455, 1069380246);
	sum1 = W(0, 1032626516, -1119757626, 1033017026, 1015522813)
		 + W(1, -1128327131, 1036888920, 1032769109, -1148588495)
		 + W(2, -1114780225, 1038823639, -1098306133, 1034533838)
		 + W(3, -1103839696, -1112718001, -1126986782, 1012070438)
		 + W(4, 1045065548, 1040221656, 1021036585, -1082356272) + W(5, 1057244812, 1032300191, 1043416793, 1045596067)
		 + W(6, -1111975378, -1115053555, 1050529784, -1095104409)
		 + W(7, -1133328720, -1111385431, -1124233691, -1105784401)
		 + W(8, 1025328225, 1020222778, -1115391173, 1045288819) + W(9, -1116298540, 1042918995, 1029500622, 1037659662)
		 + W(10, -1121960111, 1037972921, -1112361500, -1139302935)
		 + W(11, 1018289699, -1110693582, 1027375220, -1114680879);
	sum2 = W(0, -1129789987, 1019234847, -1128803579, -1112792165)
		 + W(1, 1011967806, 995307959, 1018394359, -1112288614) + W(2, 1017265095, -1124971531, 1043137983, 1047657371)
		 + W(3, 1034970984, 1010908150, -1107223361, 1027672251)
		 + W(4, -1124616639, -1114025560, -1132476030, -1114992592)
		 + W(5, -1098689491, -1115509379, 1006851110, -1128503755)
		 + W(6, -1116091154, 1022067335, -1102585265, 1052022695) + W(7, 1033604172, 1031244615, 1032350856, 1024636851)
		 + W(8, 1033010488, -1114442452, 1028851843, -1115343414)
		 + W(9, 1002830796, -1121158047, -1114060980, 1027935499)
		 + W(10, 1011223606, -1117824661, 1031833634, -1136738894)
		 + W(11, 988094894, 1025799099, -1118870225, -1127411999);
	WS(1065814108, -1098421406);
	sum1 = W(0, 1030554015, -1131576032, 1020712308, 1019668842) + W(1, -1178997255, 1023970854, 1011631425, 1023862096)
		 + W(2, -1104400078, 1022555209, -1130072911, -1118231891)
		 + W(3, 1041059117, -1115494780, 1035736611, -1104560304)
		 + W(4, -1097091133, -1099298246, -1094842433, -1084181571)
		 + W(5, -1098796514, -1094912271, -1090107010, -1092396649)
		 + W(6, 1050276747, 1048827844, 1057743463, 1051719984) + W(7, 1058357819, 1056339293, 1051879221, 1057941592)
		 + W(8, 1045406982, -1106685173, 1040093248, 1018405640)
		 + W(9, -1118903138, -1115388505, -1113309730, -1118151090)
		 + W(10, -1119880969, -1132305362, -1122176686, 1026194364)
		 + W(11, 1004376640, 1024072531, 1009992363, 1029155252);
	sum2 = W(0, -1104337717, 1027104118, -1114433477, -1122138940)
		 + W(1, 1048327612, 1018207462, 1015118770, 1054676844)
		 + W(2, -1085961218, 1036459641, -1092980271, -1101372003)
		 + W(3, -1098271754, -1115566688, -1101224844, -1105452167)
		 + W(4, 1065899128, -1117484391, 1062039746, 1077763913)
		 + W(5, -1088377514, -1079225367, -1106150830, -1079350028)
		 + W(6, 1055232204, -1101810882, 1049041629, 1071302707)
		 + W(7, -1084489503, -1087139921, 1036291830, -1090077553)
		 + W(8, -1090132108, 1052764213, -1092098978, -1123596042)
		 + W(9, 1027311380, 1042626102, -1105072819, 1053993534) + W(10, 1023963317, 1014918739, 1035158266, 1027553578)
		 + W(11, -1115760458, 1025357528, 1032466828, -1115160051);
	WS(-1083527351, -1082119000);
	sum1 = W(0, 1025283773, -1132057884, 1024000280, -1117776915) + W(1, 994019357, -1146975260, 1021506300, 1016847260)
		 + W(2, -1100516229, 1028453762, -1124447466, 1027818609)
		 + W(3, 1030853236, -1120656758, 1023329542, -1111423375)
		 + W(4, -1103907601, -1097545679, -1096840081, -1088298777)
		 + W(5, -1090997910, -1097629690, -1102673054, -1097673748)
		 + W(6, 1054198743, 1048327710, 1054350616, 1057412078) + W(7, 1059405315, 1052404744, 1051692752, 1047886934)
		 + W(8, -1139734483, -1114897689, -1109407791, -1112548849)
		 + W(9, -1107996896, 1035903152, -1110888465, 1034953432)
		 + W(10, -1115248201, 1021031566, -1115380998, -1139302503)
		 + W(11, 1029448614, -1119316016, 1026998601, -1149960989);
	sum2 = W(0, 1023717076, 996584188, -1122858228, 1005163886) + W(1, 1025356913, -1118691920, 1028885707, -1114207359)
		 + W(2, 1034248479, -1120794590, 1037241484, -1124781820)
		 + W(3, -1115274025, 1026099362, -1121079636, 1010502519)
		 + W(4, -1110594365, 1045315954, -1111180041, -1088752945)
		 + W(5, -1100621689, 1052626156, -1114153113, 1038857859)
		 + W(6, -1113079527, -1094151830, -1064957365, -1066051811)
		 + W(7, 1081496726, 1084041658, 1034711477, -1115018893)
		 + W(8, 1030579691, -1113958061, -1106054130, -1113733983)
		 + W(9, 1049150725, 1032870315, 1042989109, -1106741724) + W(10, 999456782, 1021526858, 1018369486, 1031457177)
		 + W(11, -1112407773, 1022214782, -1108284893, 1023330420);
	WS(1031453552, -1108810221);
	sum1 =
		W(0, -1122540068, -1141490084, -1132153597, 1029503994)
		+ W(1, -1126370513, -1127727061, -1132743443, 1024122485)
		+ W(2, -1106571135, 1028200745, -1106394603, 1029495448) + W(3, -1118016922, 1043712879, 1035505061, 1041979953)
		+ W(4, -1105389195, 1023785053, 1041720002, -1089108304) + W(5, 1047749927, -1092241143, 998106632, -1098695505)
		+ W(6, 1051764564, -1104087736, 1055195957, -1096098616) + W(7, 1047204316, 1028938666, 1043190746, 1039644831)
		+ W(8, -1121040220, 1027661528, -1111907522, 1031937892)
		+ W(9, -1112974291, 1025162247, -1152510101, 1002213552)
		+ W(10, -1136080166, 1023137883, -1123745267, 1034024448)
		+ W(11, -1121356173, 1028910871, -1121641711, 1025100697);
	sum2 =
		W(0, 1032316109, -1122133197, 1021061413, -1122180337) + W(1, -1115376331, -1123716599, 1008734994, -1144451812)
		+ W(2, -1117365450, 1033736971, -1117276879, 1009179554)
		+ W(3, 1034450077, -1100616286, -1130550593, -1102305630)
		+ W(4, 1028239450, -1104139010, -1090538079, 1022309577) + W(5, -1125496737, 1059658657, 1014965154, 1053491799)
		+ W(6, -1106184057, 1045998485, -1087751568, 1065712953)
		+ W(7, -1100319643, -1100023584, -1115246006, -1107982835)
		+ W(8, 1039709205, -1126266788, 1056538813, -1098763613) + W(9, 1017435581, 1022563437, 980175008, -1103966134)
		+ W(10, -1127567978, 1029398164, -1106793212, 1016414657)
		+ W(11, 1032114232, -1113653553, 1034308617, 1020870093);
	WS(1060627383, -1111244297);
	sum1 = W(0, -1124372048, -1124233202, -1115057922, -1126359548)
		 + W(1, -1135390133, 999175032, -1137033126, -1120904377) + W(2, 1041984816, 1023856878, 1037843884, 1013283185)
		 + W(3, -1106598024, -1109047521, -1108189319, -1127664786)
		 + W(4, -1098607926, -1097555068, -1092180401, 1035134080)
		 + W(5, 1055432750, 1050330552, 1046692025, 1039361415) + W(6, 1048999428, 1050454749, 1057072683, 1037566628)
		 + W(7, -1088869991, -1097603878, -1106138715, -1115643873)
		 + W(8, -1110297584, -1119853981, -1100337986, -1117600845)
		 + W(9, 1045634091, 1040799043, -1129123036, 1042168959)
		 + W(10, 1037179887, -1124350564, 1037306108, -1180500637)
		 + W(11, -1107300041, -1132131255, -1126029544, -1132202938);
	sum2 =
		W(0, 1027553654, -1128416633, -1120268362, 1026192109) + W(1, 1010812163, -1133939099, 1033310247, 1007338654)
		+ W(2, -1105419467, 1035214610, -1102082588, 1034096310)
		+ W(3, -1109637676, 1042926233, -1103557522, 1039202903) + W(4, -1141314538, 992160749, 1039698771, 1028842291)
		+ W(5, -1128101012, -1110346070, 1041169016, -1150310139)
		+ W(6, 1051401064, -1098506313, 1041311911, 1044707561) + W(7, 1040877432, -1107620104, 1044637450, -1101325278)
		+ W(8, 1061407816, 1048701957, 1065441970, -1108357660)
		+ W(9, -1080219839, -1089748519, -1106511250, -1094091750)
		+ W(10, -1086513034, 1023990179, -1083801169, 1027929117)
		+ W(11, 1058347144, 1054974548, 1012370076, 1054706164);
	WS(1037089208, -1117319375);
	sum1 = W(0, -1117307261, -1109658215, -1104716662, -1095157370)
		 + W(1, -1115283233, -1113906562, -1127634429, -1150522598)
		 + W(2, -1127081515, 1037266337, 1045840649, 1048384396) + W(3, 1042005149, 1026318614, 1035073906, -1129730364)
		 + W(4, -1090315640, -1103803502, -1108965493, -1089739445)
		 + W(5, -1098438340, -1090508193, -1096110967, -1090097982)
		 + W(6, 1055484319, 1036834781, 1059715066, 1050929076) + W(7, 1059599591, 1050537744, 1039184033, 1056916499)
		 + W(8, 1019801962, -1121027890, -1120952094, -1115632913)
		 + W(9, -1115851136, 1036887192, -1109698481, 994450682)
		 + W(10, -1140393804, -1122236391, 1007521585, -1115666157)
		 + W(11, 1038771059, -1114842616, 1040209394, 1023772594);
	sum2 = W(0, -1096641595, -1086741683, -1073585699, -1071753138)
		 + W(1, -1078410756, -1096289506, -1145261363, 997353903) + W(2, 1051991389, 1059199896, 1069582799, 1070628328)
		 + W(3, 1067042424, 1055331220, 1015112751, 1024293693) + W(4, -1107135642, 1044105651, 1057042277, 1065961920)
		 + W(5, 1057516905, -1098611055, 1043415065, -1101981251)
		 + W(6, -1120991144, 1025236133, -1123268190, -1098135951)
		 + W(7, 1032298014, -1106950583, 1007537613, 1025642916)
		 + W(8, -1123228782, 1032269711, -1116194138, -1144560253)
		 + W(9, 1026966393, -1155415556, 992611856, 1011854094)
		 + W(10, -1119770484, 1020415755, -1119862022, 1033682735)
		 + W(11, -1113740644, 1022995083, -1144895945, -1130196038);
	WS(-1089262391, 1050517969);
	sum1 = W(0, -1112721887, 1040766980, -1116916633, -1109323658)
		 + W(1, 1043853249, -1102481809, 1025978335, -1134508350) + W(2, 956356282, 1032255106, -1115255965, 1053521294)
		 + W(3, -1109293354, 1024224759, 1036451442, 998852344) + W(4, 1041136081, -1099047838, 1050954387, -1090918435)
		 + W(5, 1049475859, 1046323061, -1129023222, -1126452038)
		 + W(6, -1112851037, -1136806893, 1047658201, -1090498606)
		 + W(7, -1111100085, -1101889105, -1112184834, 1037224108)
		 + W(8, -1118798326, 1044101949, -1099177336, 1048722524)
		 + W(9, 1044026608, -1109421665, 1044252857, -1113020120)
		 + W(10, 1033047322, -1110781188, 1022949658, 984126311)
		 + W(11, -1111349460, -1151794972, -1140137768, -1119083507);
	sum2 =
		W(0, -1120544497, 1042905493, 1045262161, -1104438232) + W(1, 1023630957, -1122372280, 1027866949, -1121491826)
		+ W(2, -1104964203, -1097077111, -1098230931, 1057982485)
		+ W(3, -1106247773, 1011970003, 1026340389, 1016978228) + W(4, 1056285145, -1118581415, -1079914544, 1057557770)
		+ W(5, 1048964135, 1020547274, -1113753028, 1034078959) + W(6, -1109256198, 1026029661, 1056552993, -1104081201)
		+ W(7, -1114436673, 1033190701, -1107460568, 1034442922)
		+ W(8, -1107706742, 1025674690, -1103396776, 1048351556)
		+ W(9, 1018818866, -1103728916, 1046941904, -1106194166)
		+ W(10, 1033408182, -1118988963, 1021102038, -1136298684)
		+ W(11, -1112938187, 1034200267, -1117493164, -1172844144);
	WS(1055467886, -1126093527);
	sum1 =
		W(0, -1115675946, 1039731987, -1108949528, 1014043817) + W(1, 1025589529, -1102050167, 1035820699, -1114599603)
		+ W(2, 1037777366, -1126460340, -1145838757, 1049783617) + W(3, 991251120, 1042727635, -1123043835, 1024161077)
		+ W(4, 1043818615, -1103677379, 1060367897, -1102044139)
		+ W(5, -1109258124, 1049311757, -1116399889, 1046137806)
		+ W(6, -1096353162, 1012406341, -1088026493, -1095567535)
		+ W(7, 1051881528, -1095440907, 1032817677, -1116994158) + W(8, -1150025924, 1031349769, 1034695514, 1044285022)
		+ W(9, 1011738461, -1115570324, 1040150333, -1110796915)
		+ W(10, 1035905869, -1103947080, 1034985426, -1129716323)
		+ W(11, -1107675487, 1042590402, -1104125432, -1140552997);
	sum2 = W(0, -1115939175, 1042939513, -1106984126, 1036071940)
		 + W(1, -1133154938, -1110872047, 1038271101, -1124388167)
		 + W(2, -1111463085, 1009748958, -1104760450, 1026404786)
		 + W(3, 1042746589, 1018643239, 1024219237, -1107044825) + W(4, 1026058510, -1101036999, 1046231331, 1060091622)
		 + W(5, -1109115274, 1042116887, -1104891113, -1137025366)
		 + W(6, 1015189774, 1048391804, -1101164712, 1059732347)
		 + W(7, -1090421446, -1092755101, 1018386748, -1112446842)
		 + W(8, -1116961377, 1019493983, 1013441892, -1113485706)
		 + W(9, -1102245299, -1104832958, 1043357489, -1123717753)
		 + W(10, 1003109525, -1128500291, -1127287103, 1036806652)
		 + W(11, -1110906499, 1042929180, -1108912836, 1034520620);
	WS(1062208951, 1065603754);
	sum1 = W(0, 1032466911, 1012820793, 1029562264, 1020285479) + W(1, 993753125, 1033268866, -1131051261, 1028903855)
		 + W(2, 1029341462, 1027274819, 997585115, 1040141401) + W(3, 1032063722, -1153074023, 1015103815, 1040294280)
		 + W(4, 1059167044, 1052950767, 1057349364, -1108524682) + W(5, 1049874906, 1048703978, 1050186639, 1053103700)
		 + W(6, -1090134924, -1094303727, -1085543304, -1080037127)
		 + W(7, -1095616607, -1112675170, -1111683969, -1091636059)
		 + W(8, -1133534677, 1027990706, 1035990447, 1037410929) + W(9, 1039846496, 1023735025, 1040888889, -1118753424)
		 + W(10, 987089513, 1032570772, -1136982833, -1125543221)
		 + W(11, 1015158861, -1145342854, 1031358985, 1022936933);
	sum2 = W(0, 1035386648, 1023547272, 1025878508, 1026832668) + W(1, 1029828312, -1098240729, 1044150428, -1103643200)
		 + W(2, 1042887622, -1099060438, -1099619867, -1099104088)
		 + W(3, 1048769602, -1121505868, 1040524432, -1115369075)
		 + W(4, -1086410483, 1053956416, -1094814183, 1069089225) + W(5, 1044213412, 1035342184, 1040447750, 1049544904)
		 + W(6, -1090258329, -1112148135, -1093316197, 1060781490)
		 + W(7, -1091192206, -1105713821, -1089411157, 1058550641)
		 + W(8, 1060158548, 1050315819, 1046080958, -1103190742)
		 + W(9, -1105160931, -1084784918, 1058372334, -1080579858)
		 + W(10, -1113981975, -1099847621, 1046524888, -1112424275)
		 + W(11, 1051146364, 1019461112, 1028619520, 1040133188);
	WS(-1078970012, -1070975772);
	sum1 = W(0, 1023443287, 1008154783, 1008498119, 1032996598) + W(1, -1130007992, 1026985054, 1001505728, 1027285064)
		 + W(2, -1111813336, 1034628686, 1020510238, -1119594955)
		 + W(3, 1037186855, -1129455456, 1024916861, -1118416824)
		 + W(4, -1095332548, -1098370186, -1091304148, -1097391342)
		 + W(5, -1088889903, -1093273302, -1097878954, -1097408559)
		 + W(6, 1048282532, 1052880922, 1054365856, 1065196819) + W(7, 1037830473, 1040256647, 1042516535, 1044458956)
		 + W(8, 1036630695, -1109395910, 1031904252, -1105409007)
		 + W(9, 1022933044, 1030320779, -1131972409, 1037289397)
		 + W(10, 999582566, -1140663171, -1128098380, 1030941172)
		 + W(11, 1003729918, -1138808617, 1018809669, 1005961310);
	sum2 =
		W(0, -1114009537, 1035366037, -1111463643, -1119334122) + W(1, -1132366661, 1001109746, 1035022899, -1112054465)
		+ W(2, 1019032853, -1143037026, -1122373240, 1056620469)
		+ W(3, -1103744316, 1002774938, -1102405348, 1046894720) + W(4, 1024640816, -1101234014, 1068131945, 1075463933)
		+ W(5, -1075751794, -1072865378, 1052446989, 1019415611)
		+ W(6, 1029944441, -1105571142, 1044188353, -1093783941)
		+ W(7, 1050699227, -1098127223, 1028903402, -1119380340)
		+ W(8, -1146945026, 1031686749, -1128619453, 1046426762)
		+ W(9, -1109652943, -1131952529, -1123943246, 1017598049)
		+ W(10, -1136399129, 1018164069, -1125359481, 999713778)
		+ W(11, -1123073190, 1019524751, 983357578, 1013611461);
	WS(-1137905088, -1096938393);
	sum1 = W(0, -1127951952, -1139830244, -1108742721, 1019792636)
		 + W(1, 1018370522, 1020799581, 1021418002, -1148599498) + W(2, -1116133184, 1040763803, 1041221580, 1009683312)
		 + W(3, -1107181880, 1002965001, 1022849180, 1039287108)
		 + W(4, -1092624022, -1104553656, -1090149133, 1044078592)
		 + W(5, 1058802794, 1043495791, 1033578226, -1113073030) + W(6, 1045295113, 1046745657, 1057147883, -1112574564)
		 + W(7, -1085568476, -1103617227, 1032014262, 1022418564)
		 + W(8, 1023908704, -1103252327, -1103732914, -1127338650) + W(9, 1040869579, 991652540, 1013121207, 1011288682)
		 + W(10, 1031880695, 1040451684, 1026434167, 1007135764)
		 + W(11, 1014113348, -1125537591, 1016284007, -1116579933);
	sum2 =
		W(0, 1036469548, 1017461301, 1017339130, -1095997080) + W(1, -1099654066, -1105423964, -1113359567, -1131580992)
		+ W(2, -1097965159, -1101551098, -1094477168, 1035631286) + W(3, 1054988432, 1047389393, 1041958533, 1043362318)
		+ W(4, -1116680345, -1125992347, 1058922542, -1103956246)
		+ W(5, 1040393300, 1040203374, -1108890296, 1024609216) + W(6, 1001756270, -1115644020, 1035448965, -1105032669)
		+ W(7, 1039533461, -1122662741, -1130070269, 1025676040)
		+ W(8, 1032969412, -1124365977, 1040541302, -1112710338)
		+ W(9, 1017600743, -1114085496, -1134082186, 1015920174)
		+ W(10, -1131471357, 1016380025, 1001720584, -1115585175)
		+ W(11, 1001178742, 1001141734, 1010209588, -1122393401);
	WS(1017525984, 1039916017);
	sum1 = W(0, -1124853567, -1147061122, -1129462517, -1119594613)
		 + W(1, 999306018, -1156505185, 1012193026, 1010192066) + W(2, 1018048624, -1127291978, 1049183858, 1032566282)
		 + W(3, 1036307723, -1150114695, -1116656134, -1111959392)
		 + W(4, -1095739637, -1104996150, -1085471393, -1090223247)
		 + W(5, -1104470177, -1105492077, -1109848430, -1107232129)
		 + W(6, 1045916039, 1043181303, 1054258797, 1054999864) + W(7, -1108082389, 1055713893, -1134406033, 1049351719)
		 + W(8, 1035770156, 1038596810, 1048116160, 1024906308) + W(9, 1035021201, -1114305018, 1014226964, -1132413284)
		 + W(10, 1019449355, -1118699785, 1018729693, -1125493497)
		 + W(11, -1111613764, 1013642059, -1117195563, 990662981);
	sum2 =
		W(0, 1033095635, -1123818427, 1023960168, -1115456886) + W(1, -1130014725, -1134763238, 1020936831, 1030713030)
		+ W(2, -1113611213, 1038354785, -1136308834, 1031365710)
		+ W(3, -1121052824, 1037262635, -1129095405, 1030934712)
		+ W(4, -1120605005, 1043017802, 1016597499, -1105318511) + W(5, 1032279133, -1129541437, 1028982810, 969324748)
		+ W(6, 1010827478, 1005632845, 1067061797, 1065783254) + W(7, 1033387493, 1024758296, -1141733133, 973320358)
		+ W(8, -1096460028, -1090567932, -1078682340, -1094955795)
		+ W(9, -1114814318, 994121897, -1126300988, -1148320949) + W(10, 992544217, 1043858115, 1041505996, -1104546945)
		+ W(11, -1114466677, -1115137122, 1007094454, -1122716507);
	WS(1033221560, 1063777383);
	sum1 = W(0, 1019126833, 1022703059, 1034317754, -1141147507)
		 + W(1, 1023815261, -1145478905, -1139797991, 1017044691)
		 + W(2, -1112638616, -1107233655, -1107419652, 1017313945)
		 + W(3, 1030431247, 1043218964, 1030899327, 1042038278) + W(4, 1057738402, 1049316970, 1057780266, 1039925560)
		 + W(5, -1101232178, -1097249286, -1105363093, -1097041200)
		 + W(6, -1088696201, -1093677291, -1091493000, -1105678958)
		 + W(7, 1054033952, 1050643572, 1039373871, 1044902925) + W(8, 1044063732, 1018619290, 1042363102, -1123751101)
		 + W(9, -1103422471, -1099574259, -1109462943, -1143343447)
		 + W(10, -1130166589, -1127677637, -1141893947, -1141892011)
		 + W(11, 1028589441, 1032480102, 1000558881, -1115509735);
	sum2 = W(0, -1130982538, 1021127838, 1013698904, -1227267307)
		 + W(1, -1180063220, -1130392938, -1129014326, 1032270489)
		 + W(2, -1106875761, 1011019608, 1024572751, 1039986653)
		 + W(3, -1113103478, -1104759550, 1035543741, -1129087757)
		 + W(4, 1056618334, 1055137831, 1048771047, -1073860127) + W(5, -1108123535, 1059126644, 1045481337, 1042704754)
		 + W(6, 1055977286, 1058761027, -1103617496, -1072531400) + W(7, 1052255088, 1063802283, 1048895081, 1016319978)
		 + W(8, -1102508839, -1115387544, -1128394642, 1043687089)
		 + W(9, -1126700500, -1109991236, 1031917163, -1121934766)
		 + W(10, 1020425242, 1013848532, 1016018634, -1112657573)
		 + W(11, 1035781641, -1125248586, -1126407949, 1030839801);
	WS(-1091503470, -1126838795);
	sum1 = W(0, -1124121237, -1113414670, 1028321829, -1111356688)
		 + W(1, 1026686479, -1121133649, -1120913068, -1126384695)
		 + W(2, -1134568843, -1126036384, 1033159265, 1037814911)
		 + W(3, 1031580097, 1040854417, -1106928812, 1027944427) + W(4, 1047693172, 1049117760, -1105247938, 1058889082)
		 + W(5, 1012762455, -1120516448, 1049438209, 1040171928)
		 + W(6, -1109412515, -1103447906, -1096437464, -1098797565)
		 + W(7, -1104719461, -1106636212, -1129886751, -1106734009)
		 + W(8, -1129997061, 1034526751, -1143270742, 1022658271)
		 + W(9, -1109175079, 1042645116, -1104071908, 1012750451)
		 + W(10, 1024589216, -1113770234, 1036105485, -1114645460)
		 + W(11, 1023714995, -1138248951, -1132081196, -1145462266);
	sum2 = W(0, -1121971015, -1109269766, -1096046215, -1096349825)
		 + W(1, -1104467071, -1105457821, -1114558576, -1113812495)
		 + W(2, 1025966975, 1042653975, 1058579369, 1055073186) + W(3, 1043843774, 1043492169, -1138844670, 1035958317)
		 + W(4, -1127561691, 1038662008, -1095336395, -1156170871)
		 + W(5, 1054347264, -1116732629, 1043300107, 1025184897)
		 + W(6, 1032121603, -1104797770, 1041625968, -1098327149)
		 + W(7, -1090818470, 1028261711, -1117277405, -1130419167)
		 + W(8, -1118316871, 1018661176, -1131103951, 1035437895)
		 + W(9, 1042639369, -1115472379, -1115061521, -1130646919)
		 + W(10, -1147835451, 1023052754, -1129857431, -1114991229)
		 + W(11, 1011784142, -1157273063, 1024244091, -1148362739);
	WS(1065968028, 1020949470);
	sum1 = W(0, 1032158503, 1018701500, 1028916776, 1031923218) + W(1, -1143490705, 1005807263, 1028568398, 1026731038)
		 + W(2, 1043191673, 1020082981, 999481917, 1033906881) + W(3, -1123072324, 1012896153, 1015001550, 1035245559)
		 + W(4, 1050691771, 1043953282, 1047062836, 1032996498) + W(5, 1057457238, 1057445286, 1051530049, 1057446979)
		 + W(6, -1089572661, -1139338281, -1091936976, -1081715803)
		 + W(7, -1087112685, -1088032573, -1100585253, -1095410205)
		 + W(8, 983294118, 1041437600, 1042367115, 1040306653) + W(9, 1019100064, -1123572193, 1039280729, -1104642968)
		 + W(10, 1033006978, -1139648989, 1033705422, -1132542121)
		 + W(11, -1138694873, 1033839136, 1027376729, 1015844228);
	sum2 =
		W(0, -1107158830, -1114179967, -1106205598, -1112529879) + W(1, 1036191348, 1045048740, -1112261511, 1045813672)
		+ W(2, -1098284578, 1050997929, 1032837846, -1138556160)
		+ W(3, -1103494095, 1033058370, -1109765233, 1040601336) + W(4, 1059620359, -1120628180, 1056621385, 1064698181)
		+ W(5, 1049117565, -1087565422, 1050635491, -1087363324) + W(6, 1059101624, -1084072333, 1033838752, 1049137220)
		+ W(7, -1100194061, -1096659207, 1042760064, -1087988644)
		+ W(8, -1080819081, 1055292451, -1084530179, -1118657190)
		+ W(9, 1035375516, 1055648971, -1101810418, 1059720072) + W(10, 1041045600, 1041809552, -1150759871, 1036987884)
		+ W(11, 1040790470, -1098721116, 1028926760, -1118399816);
	WS(-1079370588, -1069938997);
	sum1 = W(0, -1107111607, 1031876694, -1108546779, 1007409349)
		 + W(1, -1119937056, -1110402417, 1034313646, -1115195974)
		 + W(2, 1024046068, 1040468568, -1110778478, 1041967908) + W(3, 1037532265, 1027170100, 1028424065, 1030920188)
		 + W(4, 1034755057, 1048995971, 1044693184, 1056322870) + W(5, 992363881, -1123931633, 1041273350, 1034999584)
		 + W(6, -1106911318, -1106422470, -1092550445, -1089848952)
		 + W(7, -1115839591, -1098485404, 1027494176, -1101830589)
		 + W(8, 1032333322, 1043602212, -1124221431, 1044063648) + W(9, -1137125241, 1015794334, 1038675968, 1024639630)
		 + W(10, -1122522177, -1133546645, -1123999146, -1129245296)
		 + W(11, -1121719236, 1009488187, -1146748727, -1115284904);
	sum2 = W(0, -1116010697, 1039856206, 1025692273, 1047723216) + W(1, 1054500142, 1045538686, 1020883249, 1037455508)
		 + W(2, 1044972838, -1094195694, 1041658757, -1090167008)
		 + W(3, -1087657974, -1114739465, -1103808398, 1025495534)
		 + W(4, -1107525170, 1054041965, -1095593913, 1054432792)
		 + W(5, 1048962216, -1099510609, 1041852115, -1112321007)
		 + W(6, 1025111869, -1105218154, 1047241736, -1103340827)
		 + W(7, -1105033641, 1043141319, -1104502432, 1020729805)
		 + W(8, -1115770744, 1021276689, -1113081166, 1030984707) + W(9, 1026520309, 1008623973, 1031142833, 1034321699)
		 + W(10, 1027404867, -1122132060, 1036997767, -1109230755)
		 + W(11, 1000189578, 949401483, -1121181330, 989367833);
	WS(1051966318, -1113875142);
	sum1 =
		W(0, 1035883793, -1111332346, 1045917727, 1006041029) + W(1, -1129901007, 1042663274, -1119690564, 1014471632)
		+ W(2, 1040145278, -1135399329, 1017502534, -1096989371) + W(3, 1043615094, 1025318012, -1113005508, 1043398529)
		+ W(4, 1051696565, 1051177307, 1054251573, 1061428120) + W(5, 1037934795, 1050890887, 1046007992, 1049249377)
		+ W(6, -1091560996, -1096861164, -1091248610, -1087158964)
		+ W(7, -1098884432, -1096301045, -1093706893, -1093100168)
		+ W(8, -1133003627, -1117751383, -1178468754, -1126263439)
		+ W(9, -1106662601, 1017933485, 1038615540, -1116546293)
		+ W(10, -1126824689, 1039745286, 1020593891, 1008594943)
		+ W(11, 1037849734, 1035118155, -1114145271, 1028529816);
	sum2 =
		W(0, -1120038729, 1032134121, -1112337284, 1014623636) + W(1, 1015804972, -1111055788, 1025605092, -1118260382)
		+ W(2, 995641288, 1034430176, 1011533369, 1032554184) + W(3, -1114631943, 1037430467, 1022278663, 1020696197)
		+ W(4, 1035481768, -1099098436, 960227969, -1122840036) + W(5, -1123247827, -1115890560, 1022436109, 1010081074)
		+ W(6, 1011267102, -1099374838, 1055781369, 1046041384) + W(7, 1055178264, -1124103196, 1039303021, -1116158530)
		+ W(8, 1042749492, 1055985885, 1067101038, 1069533386) + W(9, 1065618150, 1058921177, -1106092627, -1118372702)
		+ W(10, 1026093812, -1113501317, -1095011910, -1086401299)
		+ W(11, -1079450114, -1075689828, -1082339747, -1095588850);
	WS(-1087762743, -1114043214);
	sum1 = W(0, 1028903325, -1111481047, 1010874850, -1117223539)
		 + W(1, -1114811697, 1027957028, -1115120063, 1025677743) + W(2, 1040067739, 981566559, 1032756947, -1130847267)
		 + W(3, -1123313460, -1113871531, -1126050567, -1113266015)
		 + W(4, 1045936105, 1050679259, 1052053924, 1055533279) + W(5, 1059392176, 1053658934, 1039338221, 1051823712)
		 + W(6, -1095653187, -1096161947, -1090950614, -1084280212)
		 + W(7, -1097768267, 1005713692, -1120312930, -1118568631)
		 + W(8, -1122706133, 1026181394, 1034645023, 1030922562)
		 + W(9, 1030340896, -1102292436, -1107839810, -1112577800)
		 + W(10, 1029496147, -1149217596, -1132850610, -1154701224)
		 + W(11, -1113406339, 1020850850, 1017761874, -1117302546);
	sum2 = W(0, 1001016005, -1125241033, 1018218852, -1111720092)
		 + W(1, 1015413875, -1140722987, -1138333196, 1010568725)
		 + W(2, -1150454109, -1111980552, 1033028659, 1037513337)
		 + W(3, -1109924763, -1144232926, -1117260807, -1113652225)
		 + W(4, 1001531747, 1031575403, 1016765132, -1085543392) + W(5, 1053354837, 1054900052, 1041131548, 1045881209)
		 + W(6, 983352173, -1103460210, -1103428024, -1076627395)
		 + W(7, 1074369634, 1051272122, -1098379064, -1098914955)
		 + W(8, -1106746798, 1036252996, -1128273041, 1046375720)
		 + W(9, 1055587240, -1094917738, -1106193524, -1098562564)
		 + W(10, -1157019725, 1023495862, 1033057508, -1112606370)
		 + W(11, 1019967806, -1107285947, 1012881631, 1031041657);
	WS(-1090517687, -1095444575);
	sum1 = W(0, 1025742446, -1111454559, 1040962578, 1035513890) + W(1, 1025779251, 1041617005, -1106922364, 1024699903)
		 + W(2, 1032739299, -1106175885, -1110724347, -1118213794)
		 + W(3, -1103218657, 1040368314, -1105137317, 1024907982) + W(4, 1054789967, 1031326631, 1052551894, 1059778428)
		 + W(5, 1045793474, 1051667296, 1040121301, 1052247674)
		 + W(6, -1095546301, -1101847659, -1090925684, -1089262225)
		 + W(7, -1096439373, -1099734269, -1104705805, -1097282993)
		 + W(8, 1033023507, -1107099097, 1036045063, 1035395209)
		 + W(9, -1101529212, 1050132438, -1102593253, 1016797696)
		 + W(10, 1028563508, -1117676152, 1036888990, 1007580971)
		 + W(11, 949923192, 1037985265, -1113513373, 1026673059);
	sum2 = W(0, 1052208474, 1035064858, 1064043431, 1055780907) + W(1, 1048070172, 1057138231, -1100953655, 1042120650)
		 + W(2, -1095438834, -1104348375, -1079843968, -1084432555)
		 + W(3, -1106077690, -1086965748, 1048708391, -1106942577)
		 + W(4, 1040952518, -1095663473, 1060639651, 1054823629)
		 + W(5, -1098542607, 1057295667, -1095587456, 1035260440)
		 + W(6, -1101013864, 1048824145, -1097227129, -1105218176)
		 + W(7, 1048082838, -1106201667, 1042233875, -1136871967)
		 + W(8, 1045777263, -1099869349, 1049789703, -1118379111)
		 + W(9, -1102784042, 1043327775, -1107731485, 1006771796)
		 + W(10, -1125550479, -1127115193, 1024044553, 972648308)
		 + W(11, 1021849499, 1016298873, -1116706874, 1030896448);
	WS(-1115614648, 1042425791);
	sum1 =
		W(0, -1120207204, -1124027509, -1144413692, -1105701711)
		+ W(1, 1014568102, -1120774251, 1029691462, -1119274774) + W(2, -1115327070, 1016926292, 1038910502, 1037845356)
		+ W(3, 1042236823, -1105850383, -1134596907, -1117126533)
		+ W(4, -1093340989, -1096731140, -1096554678, -1085064420)
		+ W(5, -1100005974, -1098496607, -1135406214, -1098152617)
		+ W(6, 1053481388, 1053311332, 1057006919, 1049566369) + W(7, 1056376458, 1048579325, 1042582346, 1043887136)
		+ W(8, 1030984860, -1116407641, 1038600290, 1043585442) + W(9, 1018535375, -1122768840, -1120431498, 1035562443)
		+ W(10, -1113874973, 1010793530, -1116271283, -1114795809)
		+ W(11, 992031960, -1130485552, 1029193328, -1140222054);
	sum2 = W(0, -1127240204, 1024332524, -1145474239, -1111478947)
		 + W(1, 1029335642, -1112394176, 1042612281, -1152251822)
		 + W(2, -1079712608, -1082891577, -1081879450, 1047818786)
		 + W(3, 1066272635, 1064292926, 1048742105, 1063028070) + W(4, 1066527571, 1063276166, 1065092416, 1033988518)
		 + W(5, -1081647719, -1085935960, -1090025738, -1088819358)
		 + W(6, 1049757184, 1025750476, 1045572932, -1093152038)
		 + W(7, -1129453741, -1107360776, 1042389166, -1095668919)
		 + W(8, -1122509441, -1127423195, -1127801782, -1126799575)
		 + W(9, 1033523902, -1109456127, 1029374360, -1163717821)
		 + W(10, -1120167031, 976948665, -1123809997, 1030959654)
		 + W(11, 995040830, 1026103880, -1116538748, 1033003323);
	WS(1005558656, -1134386388);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[555];

#define CURRENT_PASS 2

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) {
	float2 UV = mul(rgb2uv, INPUT.SampleLevel(sam_INPUT_LINEAR, HOOKED_map(pos), 0).rgb);
	OUTPUT[pos] = float4(mul(yuv2rgb, float3(value.x, UV)), 1.0);
}

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define temp_tex(pos) (float(texture(temp, pos).x))
static const float2 temp_size = float2(GetInputSize().x * 1, GetInputSize().y * 2);
static const float2 temp_pt = float2(1.0 / (temp_size.x), 1.0 / (temp_size.y));

#define HOOKED_tex(pos) temp_tex(pos)
#define HOOKED_size temp_size
#define HOOKED_pt temp_pt

void Pass2(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 15 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 555; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 15, y = (uint)id % 15;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (2)) + 0.5, float(group_base.y + y - (3)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[12];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 4];
	samples[1][1] = inp[local_pos + 5];
	samples[1][2] = inp[local_pos + 6];
	samples[1][3] = inp[local_pos + 7];
	samples[2][0] = inp[local_pos + 15];
	samples[2][1] = inp[local_pos + 16];
	samples[2][2] = inp[local_pos + 17];
	samples[2][3] = inp[local_pos + 18];
	samples[3][0] = inp[local_pos + 19];
	samples[3][1] = inp[local_pos + 20];
	samples[3][2] = inp[local_pos + 21];
	samples[3][3] = inp[local_pos + 22];
	samples[4][0] = inp[local_pos + 30];
	samples[4][1] = inp[local_pos + 31];
	samples[4][2] = inp[local_pos + 32];
	samples[4][3] = inp[local_pos + 33];
	samples[5][0] = inp[local_pos + 34];
	samples[5][1] = inp[local_pos + 35];
	samples[5][2] = inp[local_pos + 36];
	samples[5][3] = inp[local_pos + 37];
	samples[6][0] = inp[local_pos + 45];
	samples[6][1] = inp[local_pos + 46];
	samples[6][2] = inp[local_pos + 47];
	samples[6][3] = inp[local_pos + 48];
	samples[7][0] = inp[local_pos + 49];
	samples[7][1] = inp[local_pos + 50];
	samples[7][2] = inp[local_pos + 51];
	samples[7][3] = inp[local_pos + 52];
	samples[8][0] = inp[local_pos + 60];
	samples[8][1] = inp[local_pos + 61];
	samples[8][2] = inp[local_pos + 62];
	samples[8][3] = inp[local_pos + 63];
	samples[9][0] = inp[local_pos + 64];
	samples[9][1] = inp[local_pos + 65];
	samples[9][2] = inp[local_pos + 66];
	samples[9][3] = inp[local_pos + 67];
	samples[10][0] = inp[local_pos + 75];
	samples[10][1] = inp[local_pos + 76];
	samples[10][2] = inp[local_pos + 77];
	samples[10][3] = inp[local_pos + 78];
	samples[11][0] = inp[local_pos + 79];
	samples[11][1] = inp[local_pos + 80];
	samples[11][2] = inp[local_pos + 81];
	samples[11][3] = inp[local_pos + 82];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 33];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * ivec2(2, 1);
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1) + ivec2(1, 0), ret);
}
